# Generated by Django 5.1.14 on 2025-12-10

from django.db import migrations
from tasks.tasks import backfill_daily_severity_summaries_task

from api.db_router import MainRouter
from api.rls import Tenant


def trigger_backfill_task(apps, schema_editor):
    """
    Trigger the backfill task for all tenants.

    This dispatches backfill_daily_severity_summaries_task for each tenant
    in the system to populate DailySeveritySummary records from historical scans.
    """
    tenant_ids = Tenant.objects.using(MainRouter.admin_db).values_list("id", flat=True)

    for tenant_id in tenant_ids:
        backfill_daily_severity_summaries_task.delay(tenant_id=str(tenant_id), days=90)


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0061_daily_severity_summary"),
    ]

    operations = [
        migrations.RunPython(trigger_backfill_task, migrations.RunPython.noop),
    ]
