# Generated by Django 5.1.5 on 2025-03-03 15:46

from functools import partial

from django.db import migrations

from api.db_utils import IntegrationTypeEnum, PostgresEnumMigration, register_enum
from api.models import Integration

IntegrationTypeEnumMigration = PostgresEnumMigration(
    enum_name="integration_type",
    enum_values=tuple(
        integration_type[0]
        for integration_type in Integration.IntegrationChoices.choices
    ),
)


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ("api", "0012_scan_report_output"),
    ]

    operations = [
        migrations.RunPython(
            IntegrationTypeEnumMigration.create_enum_type,
            reverse_code=IntegrationTypeEnumMigration.drop_enum_type,
        ),
        migrations.RunPython(
            partial(register_enum, enum_class=IntegrationTypeEnum),
            reverse_code=migrations.RunPython.noop,
        ),
    ]
