Always that you are writting documentation try to follow this text/communication style guide:

# Prowler's Brand Voice

Prowler is the open cloud security platform trusted by thousands of organizations automating security monitoring and compliance with hundreds of built-in security checks, remediation solutions, and compliance frameworks. With over 10 million downloads, thousands of contributors, and a vibrant global community, Prowler is driving the open-source cloud security movement by providing transparent, customizable, and user-friendly solutions that help teams secure AWS, Azure, GCP, Kubernetes, and Microsoft 365 environments. Leveraging open-source innovation and cost savings, the Prowler platform makes cloud security 10 times more cost-effective and accessible than alternatives.

These values must be demonstrated in all our conversations and communications.

---

## Unbiased Communication

Prowler aims to reach every person in the globe. Our communications must be as inclusive and diverse as possible every time. We are guided by the following principles:

### Avoid Gendered Pronouns

Reference to gendered pronouns (she/her/hers, he/his/his, they/them/theirs) must be avoided whenever possible.

* Use second person for communications (you/your/yours).
* Use a third-person reference instead of a gendered pronoun (the customer, the user).
* In case a gendered pronoun must be forcibly used, use they/them/theirs.
* Avoid double references like she/he, s/he, etc.

### Use Alternatives for Gendered Nouns

Avoid nouns that include gendered components. Examples:

* Businessman 🡪 Entrepreneur, businessperson, executive
* Salesman 🡪 Sales executive, sales representative
* Mankind 🡪 Humanity, people
* Penmanship 🡪 Calligraphy, handwriting
* Middleman 🡪 Intermediary, negotiator

### Diversity, Equity, and Inclusion

All communications must prioritize diversity and inclusivity. When incorporating examples, ensure representation across sex, gender, age, identity, race, culture, background, ability, and socioeconomic status. Strive for balanced and respectful depictions.

### Cultural and Geographical Awareness

Before referencing a region, country, culture, national status, political status, or socioeconomic realities, conduct thorough research. Maintain a respectful, informed approach and avoid unnecessary conflicts.

### Avoiding Generalizations

Avoid broad assumptions about gender, sex, race, sexual orientation, nationality, or culture. Generalizations can introduce bias and misrepresentation. Example to avoid: "Cybersecurity is of the utmost importance in the country, where corruption runs amok."

### Respectful Language

Derogatory terms must not be used. If uncertain about terminology, consult individuals from the relevant region or community to ensure accuracy and appropriateness.

### Clear and Accessible Language

* **Jargon:** Use technical terminology only when the audience is expected to understand it. If uncertain, opt for clear and universally accessible language.
* **Slang:** Minimize slang usage. Even when confident about the audience, prefer formal and neutral language to enhance clarity.

### Militaristic Language

Current tendencies in a topic as sensitive as cybersecurity avoid violent and militaristic references save for explicit reference to combat. These are some alternatives:

* Combat, fight, eliminate 🡪 Address, protect, safeguard, ward
* Kill chain 🡪 Cyberattack chain
* Attacker 🡪 Cyberattacker, bad actor, threat actor
* Defense-in-depth approach 🡪 Multilayered approach
* First line of defense, frontline 🡪 Security, protection, defense
* External attack surface 🡪 Vulnerabilities, point of access, external exposure

### Note on Safety and Security

“Safety” and “security” are terms often misunderstood. “Safety” is the microscopic, personal and individual term, while “security” is the macroscopic, broader, national term. Examples:

a. Seat belts are great for personal safety.
b. National security is of the utmost concern nowadays.

---

## Naming Conventions

### Prowler Features

Prowler Features are considered proper nouns. They are to be referenced without articles in all pieces of writing.

This is a list of Prowler Features:

* **Prowler App**
* **Prowler CLI**
* **Prowler SDK**
* **Built-in Compliance Checks**
* **Multi-cloud Security Scanning**
* **Autonomous Cloud Security Analyst (AI)**
* **Threat & Misconfiguration Detection**
* **Role-Based Access Control (RBAC)**
* **Identity & Access Risk Detection**
* **Tag-Based Scanning & Filtering**
* **Audit Logs & Security Reports**
* **Agentless & Works Anywhere**
* **Automated Scans & Continuous Monitoring**
* **Chat-based Security Querying (AI)**
* **AI-Generated Detections & Remediations**
* **Prowler Studio**
* **Custom Security Policies**
* **Prowler Cloud**
* **Prowler Registry**
* **Open Source & Full APIs**

---

## Verbal Constructions in Technical Writing

Choosing verbal constructions (using verbs) over nominal (using nouns) constructions can significantly impact the clarity, conciseness and especially readability of the content.

Nominal constructions often introduce unnecessary complexity or vagueness. For example:

* Nominal: "The creation of the report was successful."
* Verbal: "The report was successfully created."

Verbal constructions also tend to use fewer words, resulting in a more polished and concise style:

* Nominal: "The implementation of the solution reduced system downtime."
* Verbal: "The solution reduced system downtime."

Verbal constructions are to be chosen over nominal constructions whenever possible.

---

### Addendum: Verbal Structures Actually State your Purpose

* **Example 1:** Recommendation for multiple subscriptions
* **Example 2:** Recommendation for Managing Multiple Subscriptions

Example 1 is vague and even potentially ambiguous. Verbs state your purpose and they must be used whenever possible.

---

## Avoiding The Second Person Except for Imperative Instructions

Explicit use of second-person pronouns (you) and possessives (your) should be minimized whenever possible. Those constructions are best reserved for cases when instructions are directly given in an imperative form:

**Example of Improvement Through Avoiding Second Person Pronouns**

**Original:**
Prowler App can be installed in different ways, depending on your environment:

**Improved Version:**
Prowler App offers flexible installation methods tailored to various environments:

---

## Title-Case Capitalization

We use title case.

**Example:** This Is an Example on Title Case

Title case tends to be better for SEO because it improves readability and makes headlines more visually distinct, which can lead to higher click-through rates (CTR).

---

### Other Considerations on Capitalization

Follow these additional guidelines for capitalization:

### Inner Capitalization

Avoid internal capitalization of words in body text unless it is part of a proper name or brand denomination. Example: instead of E-mail and e-Book use email/e-mail and e-book.

### Acronym Capitalization

Do not capitalize the individual words of the spelled-out form of acronyms. Example: instead of CTI (Cyber Threat Intelligence) use CTI (cyber threat intelligence), but AWS (Amazon Web Services) is to be kept as is.

### Avoid Capitalization for Emphasis

Do not capitalize words in order to emphasize them.

### Capitalization of Languages and Standards

Check for the proper capitalization of language and standard names.

Language examples: HTML, JSON, YAML, XML, etc., must be capitalized.

Standard examples: standards follow title-case capitalization: Industrial Automation and Control Systems (IACS).

### Capitalization of Laws and Regulations

Laws and Regulations follow title-case capitalization. If referring to a non-domestic law or regulation, add the nationality and the original name.

**Example:** Code for the Cybersecurity Law published in the Spanish Official State Bulletin (BOE, Boletín Oficial del Estado).

Most UE Regulations have an official translation for all UE languages; please check it on EUR-Lex portal and choose the proper language: https://eur-lex.europa.eu/.

The different languages can be chosen on the portal under Languages, formats and link to OJ.

---

## Hyphenation

Hyphenation is to be used for noun modifiers in prenominal position, i.e., placed before nouns.

**Example:** Prowler is a world-leading company in open-source software.

It is not to be used for predicate adjectives in postnominal position.

**Example:** Prowler has many features built in.

### Note on Hyphenation and SEO

Google treats hyphens as word separators, as if they were blank spaces, i.e., the term `high quality checks` is treated as if it was the same term as `high-quality checks`. Hyphenation does not affect SEO on body text, thus the grammatically correct approach is recommended as sign of good writing. However, underscores (`_`) are treated as different words. This has implications particularly for URLs.

Hyphens are preferred for URLs as they improve readability and indexing.

**Example:**
* Better approach: `example.com/this-is-an-URL`
* Less ideal approach: `example.com/this_is_an_URL`

---

## Bullet Points

Bullet points offer several advantages:

* **Improved readability:** Bullet points make information scannable and enable vertical reading, allowing users to easily spot relevant details and breaking content into more digestible pieces.
* **Highlighting of relevant information:** They emphasize the most salient points, improving focus and enabling quick summarization at a glance.
* **Improved retention:** Bullet points enhance memory retention and contribute to a clearer, more polished final product.
* **Structured presentation:** They improve user experience through the logical organization of content.
* **SEO relevance (Search Engine Optimization):** Bullet points make content easier to consume and offer the following SEO benefits:
    * Reduced bounce rates
    * Increased time spent on page
    * Strategic keyword optimization
    * Improved chances of being featured in search engine snippets
    * Enhanced crawlability for search engines.

---

### When to Use Bullet Points

The use of bullet points is highly recommended when:

* Information can be logically divided into multiple categories, each sharing characteristics, features, or other relevant classifications.
* Items are significant enough as standalone concepts to deserve their own bullet point.

**Example of Improvement Through Bullet Points**

**Original:**
It contains hundreds of controls covering CIS, NIST 800, NIST CSF, CISA, RBI, FedRAMS, PCI-DSS, GDPR, HIPAA, FFIEC, SOC2, GXP, AWS Well-Architected Framework Security Pillar, AWS Foundational Technical Review (FTR), ENS (Spanish National Security Scheme), and your custom security frameworks.

**Improved with Bullet Points:**

**Prowler CLI Features:**
Prowler CLI includes hundreds of built-in controls to ensure compliance with standards and frameworks, including:

* **Industry standards:** CIS, NIST 800, NIST CSF, and CISA
* **Regulatory compliance and governance:** RBI, FedRAMP, and PCI-DSS
* **Frameworks for sensitive data and privacy:** GDPR, HIPAA, and FFIEC
* **Frameworks for organizational governance and quality control:** SOC2 and GXP
* **AWS-specific guidance:** AWS Foundational Technical Review (FTR) and AWS Well-Architected Framework (Security Pillar)
* **Regional compliance:** ENS (Spanish National Security Scheme)
* **Custom security frameworks:** Tailored to meet your organization’s specific needs

---

### Punctuation of Bullet Points

There are several options for punctuating bullet points. Regardless of the style chosen, it is imperative to maintain consistency throughout the text.

* **No punctuation (minimalistic):** This strategy is suitable when no verbs are involved and is best used to highlight products or features in isolation. For example:

    Prowler App is composed of three key components:
    * Prowler UI
    * Prowler API
    * Prowler SDK

    This example highlights each element individually and fosters retention with a noise-free approach.

* **Periods for full sentences:** This approach works best when each bullet point forms a full sentence or includes verbs. For example:

    Prowler App is composed of three key components:
    * Prowler UI, a web-based interface, built with Next.js, providing a user-friendly experience for executing Prowler scans and visualizing results.
    * Prowler API, a backend service, developed with Django REST Framework, responsible for running Prowler scans and storing the generated results.
    * Prowler SDK, a Python SDK designed to extend the functionality of the Prowler CLI for advanced capabilities.

    This example demonstrates a polished list using proper punctuation.

* **Semi-colons with final period:** This approach was traditionally used for those cases when bullet points were part of a continuous sentence or logical succession. However, it is being deprecated, consistent with the declining use of semi-colons in modern writing. It is to be avoided whenever possible. For example:

    Prowler UI:
    * is a web-based interface;
    * is built with Next.js;
    * provides a user-friendly experience for executing Prowler scans and visualizing results.

---

### Advantages of Adding Headers to Bullet Points

Adding headers to bullet points in technical writing is a powerful technique that enhances both the clarity and usability of the content. It has also advantages for SEO:

* Increased crawlability of search engines
* Enhanced keyword integration
* Improved user engagement
* Enhanced snippetting by search engines
* Reduced bounce rates

It is recommended to add headers to bullet points whenever possible.

---

## Quotation Marks

### Quotation Marks Usage in Technical Documentation

Proper use of quotation marks enhances clarity and consistency in technical writing. Below are key guidelines for using double and single quotation marks, following American English conventions.

### Double Quotation Marks

* Use for titles of books, movies, songs, and articles.
* Enclose direct quotes:
    * **Example:** The developer said, “We will try to fix this issue.”
* Capitalize the first word if quoting a full sentence.
* When quoting a phrase within a sentence, do not capitalize:
    * **Example:** The news portal called our product “one of the most efficient online help authoring tools.”
* Use scare quotes when words acquire a different or ironic meaning:
    * **Example:** The update is “scheduled” to release next week.
* To refer to a term without applying its meaning, use double quotes (or italics):
    * **Example:** Avoid terms like “don’t worry” in pop-ups to prevent user anxiety.

### Single Quotation Marks

* Used inside double quotes:
    * **Example:** He said, “I am not sure what ‘single sourcing’ means.”
* In British English, the order is often reversed (single quotation marks on the outside).

---

### Double Quoting in Software Documentation

Double quoting is to be used through software documentation where their use does not interfere with formatting restrictions.

1.  **Menu Items & UI Options**
    * Use double quotation marks when referring to selectable items in software interfaces.
    * **Example:** Click “File” and select “Save As” to export your document.
2.  **Buttons & Commands**
    * Use double quotes for labeled interface elements that users interact with.
    * **Example:** Select “Submit” to finalize the form.
3.  **Exact Input & User Actions**
    * If users need to enter exact text, enclose it in double quotes.
    * **Example:** Type “admin” in the username field.
4.  **Avoid Quoting Software Names**
    * Do not use quotation marks for software product names unless required for clarity.
    * **Correct:** Open Microsoft Excel.
    * **Incorrect:** Open “Microsoft Excel.”

---

## Interaction Verbs

The following are the correct verbs that must be used when referring to user interactions with the software.

### Mouse & Trackpad Actions (Desktop/Laptop)

* **Click:** Press and release the left mouse button or trackpad without moving the pointer.
    * **Example:** Click the “OK” button to confirm. 🡪 Transitive
* **Click on:** Often interchangeable with "Click," but less commonly used in technical writing for UI interactions.
    * **Example:** Click on the "Settings" icon to open preferences. (Less recommended—“Click” is preferred.)
* **Double-click:** Press and release twice in quick succession, usually to open files or applications.
    * **Example:** Double-click the document to open it. 🡪 Transitive
* **Right-click:** Press and release the right mouse button to open a context menu.
    * **Example:** Right-click the folder and select “Properties.” 🡪 Transitive

### Touchscreen Actions (Mobile & Touch)

* **Tap:** Touch the screen lightly with a finger or stylus, equivalent to "Click" on a mouse.
    * **Example:** Tap the “Sign in” button.
* **Double-tap:** Quickly touch the screen twice, often used for zooming or selecting text.
    * **Example:** Double-tap an image to zoom in.
* **Press and hold:** Touch and hold the screen for a moment to access additional options.
    * **Example:** Press and hold an app icon to see more actions. (Similar to “Right-click” in desktop environments.)

### Additional Actions

* **Drag:** Click or tap an item and move it while holding down the button or finger.
    * **Example:** Drag the file into the folder.
* **Swipe:** Move a finger across the touchscreen horizontally or vertically.
    * **Example:** Swipe left to dismiss the notification.
* **Pinch to zoom:** Use two fingers to zoom in or out.
    * **Example:** Pinch the screen to zoom in on the image.
* **Scroll:** Move the mouse wheel, swipe, or use the arrow keys to navigate up/down.
    * **Example:** Scroll down to see more results.

The widely-accepted terminology for gestures is Windows’: https://support.microsoft.com/en-us/windows/touch-gestures-for-windows-a9d28305-4818-a5df-4e2b-e5590f850741

---

## Sentence Structure for Technical Writing and SEO

When writing technical documentation, clarity, conciseness, and searchability (SEO) are key factors. Let’s compare the following two sentence structures, extracted from Prowler’s documentation:

**Option 1:**
"Open a terminal and execute the following command to create a new custom role."

**Option 2:**
"To create a new custom role, open a terminal and execute the following command."

### SEO Optimization

* Search engines prioritize clear intent at the beginning of a sentence.
* Option 2 starts with the action users are likely to search for (e.g., "Create a custom role"), which improves SEO rankings and makes the content more likely to match search queries.
* Option 1 places the primary search term toward the end, making it less effective for keyword optimization.

### Technical Writing Best Practices

* Technical writing emphasizes clear objectives first, followed by actions.
* Option 2 follows this best practice by stating the goal first ("To create a new custom role") and then providing instructions.
* Option 1 is still acceptable for step-by-step guides, but Option 2 is more effective for tutorials, manuals, and documentation.

### Key Takeaways

* Draft trying to mimic the most likely way users are to find the information (“Ctrl + F approach”).
* Place keywords and key terms at the beginning of sentences so that they rank better SEO-wise.
* Rule of thumb: “In order to what” precedes the “what”. “What” must mirror the user’s most likely way of drafting or searching.

---

## Section Titles and Headers in Technical Writing

Effective headers and section titles enhance document readability and structure, making content more accessible to the reader. This chapter outlines best practices for crafting clear, consistent, and meaningful headings.

1.  **Purpose of Headers**
    Headers serve several key functions:
    * **Improve Navigation:** Allow users to quickly locate relevant information.
    * **Enhance Readability:** Break down complex topics into manageable sections.
    * **Establish Hierarchy:** Define the logical flow of content.
    * **SEO:** Headers impact SEO both directly and indirectly:
        * Search engines use headings to determine the hierarchy and relevance of content.
        * **H1:** The primary heading (should be unique and descriptive).
        * **H2-H6:** Subheadings that break down content logically.
        * Best practices for SEO-friendly headers:
            * Include keywords naturally in headings.
            * Avoid keyword stuffing—keep it clear and readable.
            * Use structured hierarchy (H1 → H2 → H3, etc.).
2.  **Header Levels and Formatting**
    Use a structured approach for organizing section titles. Common conventions include:
    * **Title:** The primary heading of the document (e.g., H1).
    * **Main Sections:** First-level headers (H2), introducing key content areas.
    * **Subsections:** Second-level headers (H3) to detail specific topics within sections.
    * **Subtopics:** Third-level headers (H4+) used sparingly for finer details.

    **Example:**

    ```markdown
    # Document Title (H1)
    ## Main Section (H2)
    ### Subsection (H3)
    #### Subtopic (H4)
    ```

3.  **Writing Effective Headers**
    When crafting headers and section titles, follow these guidelines:
    * **Be Descriptive:** Clearly indicate what the section covers.
        * **Poor:** Introduction (too vague)
        * **Good:** Introduction to AWS CloudShell Installation (informative)
    * **Keep It Concise:** Use precise language without unnecessary words.
    * **Maintain Consistency:** Apply uniform formatting and style conventions throughout.
    * **Avoid Special Characters:** Limit punctuation for clarity—avoid excessive symbols, dashes, or underscores.
4.  **Capitalization Rules**
    Use Title Case for headers to ensure a professional look:
    * **Good:** How to Clone and Install Prowler from GitHub
    * **Poor:** How to clone and install Prowler from GitHub

    For technical documentation, sentence case may be used for readability in subheadings. Please note this differs from headers and it is only a recommendation, but consistency is to be kept throughout the documentation:

    * **Example:**
        * How to Clone and Install Prowler from GitHub (header: Title case)
            * How to install poetry dependencies (subheading: Sentence case)
5.  **Using Keywords in Headers**
    Headers should include relevant keywords to improve document searchability:
    * **Good:** Scanning AWS Accounts in Parallel
    * **Poor:** Ways to scan on AWS (vague and imprecise)
6.  **Consistency Across Documents**
    Ensure uniformity in section titles across related documentation:
    * **Standardized Header Naming:** Use consistent wording for common sections (e.g., "Installation," "Setup," "Configuration").
    * **Numbering Sections (If Necessary):** For structured guides, include numbering where appropriate (e.g., "Step 1: Install Prowler").

---

## Version Badge for Feature Documentation

The Version Badge component indicates when a specific feature or functionality was introduced in Prowler. This component is located at `docs/snippets/version-badge.mdx` and should be used consistently across the documentation.

### When to Use the Version Badge

Use the Version Badge when documenting:

* New features added in a specific version.
* New CLI options or flags.
* New API endpoints or SDK methods.
* New compliance frameworks or security checks.
* Breaking changes or deprecated features (with appropriate context).

### How to Use the Version Badge

1.  **Import the Component**

    At the top of the MDX file, import the snippet:

    ```mdx
    import { VersionBadge } from "/snippets/version-badge.mdx"
    ```

2.  **Place the Badge**

    Insert the badge immediately after the section header or feature title:

    ```mdx
    ## New Feature Name

    <VersionBadge version="4.5.0" />

    Description of the feature...
    ```

3.  **Version Format**

    Use semantic versioning format (e.g., `4.5.0`, `5.0.0`). Do not include the "v" prefix.

### Placement Guidelines

* Place the Version Badge on its own line, directly below the header.
* Leave a blank line after the badge before continuing with the content.
* For subsections, place the badge only if the subsection introduces something new independently from the parent section.

**Example:**

```mdx
## Tag-Based Scanning

import { VersionBadge } from "/snippets/version-badge.mdx"

<VersionBadge version="4.3.0" />

Tag-Based Scanning allows filtering resources by AWS tags during security assessments...
```

---

## Avoid Assumptions Regarding Audience’s Expertise

### Understand Your Audience’s Expertise

Despite knowing your target audience, assumptions on target audience’s expertise or knowledge are to be avoided.

Adjust the level of detail based on expected reader proficiency, but make sure to be as explanatory as humanly possible.

### Define Key Terms and Acronyms on First Use

Even if your audience is technical, some domain-specific terms may vary.
* Introduce jargon only after defining it clearly.
* If using acronyms (e.g., IAM, MFA), spell them out on first mention:
    * AWS Identity and Access Management (IAM)
    * Multifactor Authentication (MFA)

### Don’t Assume Unwritten Knowledge

Even experienced readers may not know every prerequisite. If a process relies on prior steps, briefly reference them:

* Before configuring security groups, ensure VPC networking is set up.

### Use Consistent Formatting

### Provide as Many Examples as Deemed Right… and Then Some

### Anticipate Common Knowledge Gaps

### Avoid Excessive Notes

Notes are often omitted by readers and they clutter text, so use them sparingly and only for additional information that is not essential or prompts any error or mistake.

---

## Using Warnings and Danger Calls for High-Severity Information

In technical documentation, warnings and danger calls highlight critical risks, guiding users in preventing security breaches or system failures. Proper usage ensures clarity and actionable guidance.

1.  **Define Severity Levels**
    Before applying Note, Warning, or Danger, clearly define their significance:
    * **Note:** Provides general information or best practices (low severity).
    * **Warning:** Indicates potential issues if instructions are not followed (moderate severity).
    * **Danger:** Highlights actions that could result in severe consequences, such as system corruption or data loss (high severity).
2.  **Explain Consequences**
    Each warning or danger call should explicitly describe the impact of ignoring the caution:
    * **Good:** Disabling encryption may expose sensitive data to unauthorized access.
    * **Poor:** Avoid disabling encryption.
3.  **Provide Remediation and Troubleshooting**
    Whenever possible, direct users to troubleshooting guides or mitigation steps to resolve the issue.

    **Example:**
    **Danger:** Running this command will **permanently delete all data**. Refer to @Data Recovery Guide for restoration steps.
