from prowler.lib.check.models import Check, Check_Report_AWS
from prowler.providers.aws.services.apigateway.apigateway_client import (
    apigateway_client,
)


class apigateway_restapi_public_with_authorizer(Check):
    def execute(self):
        findings = []
        for rest_api in apigateway_client.rest_apis:
            if rest_api.public_endpoint:
                report = Check_Report_AWS(metadata=self.metadata(), resource=rest_api)
                report.resource_id = rest_api.name

                report.status = "PASS"
                report.status_extended = f"API Gateway REST API {rest_api.name} with ID {rest_api.id} has a public endpoint with an authorizer."

                if not rest_api.authorizer:
                    report.status = "FAIL"
                    report.status_extended = f"API Gateway REST API {rest_api.name} with ID {rest_api.id} has a public endpoint without an authorizer."

                findings.append(report)

        return findings
