#! /usr/bin/env python

# This file is part of IVRE.
# Copyright 2011 - 2024 Pierre LALET <pierre@droids-corp.org>
#
# IVRE is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# IVRE is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
# License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IVRE. If not, see <http://www.gnu.org/licenses/>.


"""
This sub-module contains data from <https://sslbl.abuse.ch/>
"""

SSLBL_CERTIFICATES = {
    # GENERATED_DATA_SSLBL_CERTIFICATES
    "0009a66eab25c81f940e1c8324d848286d91e015": "Quakbot C&C",
    "001b0e1b9e6e33f5b48678a1780ad1bf17bd9f96": "AsyncRAT C&C",
    "002180a59724edba9ebd19c572d4c23fff8a78bc": "BitRAT C&C",
    "0022a1821c4cae59ac3918e4dcbe7c5c29bcbbc6": "Gozi C&C",
    "0032ab31e4cf80e8f66a3e55cc2095219202796d": "BitRAT C&C",
    "003961d4a2371354b233808697cdad4d660792a9": "PandaZeuS C&C",
    "003becd9037138c2ba7185abc0da32677c7ebef5": "njrat C&C",
    "0045eb6e50c1ccda72f94b562ee17be75cc20673": "Dridex C&C",
    "004f0b18d62f5329a9b7f5548c87409efd408517": "ServHelper C&C",
    "00501d89a880f63bbf9ca47932b85b8c2a1f2373": "IcedID C&C",
    "0069120a0b946b2de0d8ce95d780c868a341960a": "ServHelper C&C",
    "0070785e6e3dee58a6882e6d23df7dae14943c1b": "DCRat C&C",
    "008d33ce2e5d3583d8ebb115f72b250975757018": "Gozi C&C",
    "00945edf41ccfa2899dfd41d71b8427565313820": "Quakbot C&C",
    "00957eee8255631a04deef579b1cca9c395fe910": "Malware C&C",
    "009fd70b9f42a2b370c85a60a77b2fcd7a7c0ba7": "Quakbot C&C",
    "00a4061115638b152b16a7e2431080b6244d0e39": "AsyncRAT C&C",
    "00a93fc74ed000bdd1d9f0dd4f5b0ed75af30870": "Dridex C&C",
    "00b0195889068db84f763392dc1806f920ad030e": "Quakbot C&C",
    "00b68e4916552d750a6d07a2889c4dd24108c90c": "BitRAT C&C",
    "00c2e0375f9b44ba19159a882a243df320475a60": "TrickBot C&C",
    "00c5e34b34da3f23ac52975637da01d5f0f1d108": "Stealc C&C",
    "00c9b5247140f918ba3e223e5d5ff6b2f1449af2": "OrcusRAT C&C",
    "00d896dcfef632651ab0afa6c6d4f4d631b4648c": "AsyncRAT C&C",
    "0112b009ef499af27857777b459eaab5b216b49d": "AsyncRAT C&C",
    "01143a9ca93c9bbdc97f4627756f7a10b6b4bc66": "AsyncRAT C&C",
    "0128b81980078644e7fa17a3d2ce83d24de2c743": "AsyncRAT C&C",
    "012d140bf81b0fb8e0b771fd37b105357705686a": "Adwind C&C",
    "014eab17846f607b156421ba4ab42d8e2d7247b4": "Gootkit C&C",
    "015932bbdc3552246b9ea2f3b90f022a8c726f05": "AsyncRAT C&C",
    "015b573fb6232b4a5dce8207c41c514c82502045": "AsyncRAT C&C",
    "0170a717e8acd9112107c58dc51b13b9a9e541f0": "AsyncRAT C&C",
    "017bf6e27baa4295f21de75caf209616d5ee779b": "Dridex C&C",
    "0180d90cd6959e429b28104ee18c2a18edd8a6b0": "ZLoader C&C",
    "0187155da87ad36af4380428c28794c0ce2d6c03": "TorrentLocker C&C",
    "01876b9f02deeec369d62b2885e704f626da738b": "BazaLoader C&C",
    "019a14cbea171acd0f800dfa505fd0d1418c876c": "Gozi C&C",
    "01a458bd2d46b4383b11469f1c8e4f336753ec4d": "PandaZeuS C&C",
    "01a80c6868942bd8e76d5bd211952dc5709aeae1": "Gozi C&C",
    "01adb6517fe8bf0ae16f15f81af2437ded2ce344": "Quakbot C&C",
    "01b51bf8c324f2ebd7f460060861f30256d4ff07": "QuasarRAT C&C",
    "01b52bfcee87557575d69b78ae5f4c7e82247c0f": "QNodeService C&C",
    "01b8a3899bae90fb4c4e0596d548003407d65b53": "Gozi C&C",
    "01be746568576d7aeceec8ee6d0749f1260cd686": "Gozi C&C",
    "01ce960cb7e79b8a9f8794545bed24934c8d4c69": "QuasarRAT C&C",
    "01d04d7c4c8372ff8aa8fb42dcd132b4ffaad20e": "AsyncRAT C&C",
    "01f1f75b48f205acb92f1e23204869394b37b91f": "ZLoader C&C",
    "01f6b293e6616bad21c2ecf808df51eab4173471": "Malware C&C",
    "020189bf37d08319633028a87387aef05a4ca38c": "AsyncRAT C&C",
    "0204dfa093e27b72f1617ccea6076bcce5d0a482": "QuasarRAT C&C",
    "021c92b4d46dbc31589b3db97735db8bf51ad65a": "Gootkit C&C",
    "02322f134d1c4d43e7f905ccbb25431ba97e0cb8": "Quakbot C&C",
    "02398a8ccfd4f61522ecd22c00e928dd97fd8982": "DCRat C&C",
    "0245eacb18c9a56aae7615333819178597d062f1": "BitRAT C&C",
    "0247cd18097761be586d216f6f22966393284a52": "TorrentLocker C&C",
    "0249b953aa544bb66621393f23c6bc33b18cfc1a": "Quakbot C&C",
    "024cbdcb0f3795ef6d7ef249af3b3473da6a4790": "PandaZeuS C&C",
    "025b7c07b277e92964799180e08c79d930ee833a": "Dridex C&C",
    "0275f054d3e62c2ed969e7cf767827567559042a": "AsyncRAT C&C",
    "02853066d54080dd09fda423ed531d9c96393a6f": "CobaltStrike C&C",
    "028ae1f23e5fac7803ef1a3f6fee00505eed8b92": "AsyncRAT C&C",
    "0291d42dd1d671ae32088b9bcd0655554f9a6b79": "BitRAT C&C",
    "02930abf56910ab91d3b33272e13e6b25ce5aadc": "BitRAT C&C",
    "02a86c13c28d03fbd493d195b91d07a2b73f8db4": "AsyncRAT C&C",
    "02c6b62f2a4ae28be5e051830076c5240f5b387e": "AsyncRAT C&C",
    "02c7c2da067457f552d14f6becdc359fcbb40261": "AsyncRAT C&C",
    "02d96246965a7fd746dd4454be7b55e45aa483a7": "AsyncRAT C&C",
    "02e687c44da4467fc77639abba9ba91e0ac10d65": "Gootkit C&C",
    "02f3bd8a3754b20f1d6eb1400225f3230cc4d11f": "ZLoader C&C",
    "02f5e6373b0dc0afd8b7e2c9cb7509bcb91c7622": "FindPOS C&C",
    "02f6545666729ec98fd2fed2463bb2e9599990e8": "QuasarRAT C&C",
    "02f78f672f410cd3123a2f7ca0158702dcef7e6a": "Malware C&C",
    "02fcce97c6a9c0154e069c1c5f780eafe53d6766": "Gozi C&C",
    "02fdd90dedf3cc5f13b69e6800b279d407a2d750": "AsyncRAT C&C",
    "0304fa2f490e145e0e0dd4336141a2c51b732c08": "AsyncRAT C&C",
    "030b47a3ca4ca041deab4846b3a589a5d40157db": "PandaZeuS C&C",
    "031b9ab115b92306f8abee8fbb4220d286cf4497": "KINS C&C",
    "031d548427250e439a67b793043df2d5a21916ac": "Gozi C&C",
    "032001683dd04292ee9f8896d3ce4b5a64beafb3": "TrickBot C&C",
    "032f697e5a1720f559972909eecc1e7a1bff67be": "PandaZeuS C&C",
    "033cfe41ee167aa31b8af898b033f6bfec5cc9d2": "Gootkit C&C",
    "0354b03baefd0bc585336cc09832512f05426876": "QNodeService C&C",
    "035d187bfe97581d229febda2a8a1cb292ed64da": "Dridex C&C",
    "03749dc70a07d7c1c8bc328770f36be2f7b8452b": "CobaltStrike C&C",
    "03824cfbc33668c4bddaf8bd98f16f29c52d011f": "AsyncRAT C&C",
    "0384d235e6a736d1cb567aea360ffddc5278698b": "TrickBot C&C",
    "0395384975483fa11942e6cfd407d860b7822d41": "DCRat C&C",
    "0399b4d2132a027f5e69a99e2fd529fce19a42ab": "Gozi C&C",
    "03a0ac10933fbf844a7228083969b1a0dcbad740": "Quakbot C&C",
    "03a3b4cb7b4ed1eda7b4cd46350383e9e30a2260": "Dridex C&C",
    "03a9c8bd3e092ef8731db98ec0fa3eb6df838b08": "TorrentLocker C&C",
    "03bef93d9108fa3640c2aa71297a3fa243e4ffc8": "BitRAT C&C",
    "03c632b6eb7da7e46ee197e9c6c41f81e0d7d4cd": "BuerLoader C&C",
    "03e6bd14e100d41b68d6c40e45bbf71ff73c6274": "Downloader.AuotIT.ZLIB C&C",
    "04084d04aee07d52d6a8367894fef3240fc49e63": "Quakbot C&C",
    "0411d8b9b23547f86733347b0634010f112e158f": "QuasarRAT C&C",
    "041369b455e8eb78315ef715592d37d4d29bf785": "DCRat C&C",
    "043a68f048e8ce7470ae58860c58d25879668c91": "KINS C&C",
    "043d1a11a06d7a606501659a34cae94150846e9d": "Meterpreter C&C",
    "0447ac2bc5a1fda9710658f15aebbf70a8fda667": "IcedID C&C",
    "045608f3966c502feeee8931db169e084d2b475c": "AsyncRAT C&C",
    "0462d944ec9ff43806f96ae7e07b47cbb43b667d": "DCRat C&C",
    "0463a5f02f7eed1a797a1b0ff08a0b62639e7be0": "OrcusRAT C&C",
    "047dcf71ad690d3ad493233a24cdabd05993f04e": "IcedID C&C",
    "04bbff19be2eb08cb70d02f13c0a360c716a8196": "TrickBot C&C",
    "04c374161b21543ac1f2900b654538e164b5570a": "OrcusRAT C&C",
    "04f019b25417527fb4d8930717b1a2ccbabaff09": "Malware C&C",
    "05071de2e10628fda70e00daa9ad552f3ffdf5ec": "AsyncRAT C&C",
    "051b8e4f4a3e279ba2179dbf148bf6d16982b8ce": "AsyncRAT C&C",
    "05273e6fcf79d47b3841d4369b1ce3041f756163": "TorrentLocker C&C",
    "0534e825a416c145ef0643faf0a547dc316a1297": "BitRAT C&C",
    "053d41cdf0749d693a792c36947c16a6248bb028": "Dridex C&C",
    "053f6a7a8c4664d10b4e2cf90fcf0de0aba4ad40": "BitRAT C&C",
    "055f7fb82e25a2b4a7f71ed656bc5ac27f29effe": "AsyncRAT C&C",
    "056246aa19b960f594363c21b90df5e76066da3e": "QuasarRAT C&C",
    "056ddf720aab43450b83178752726e82761fe316": "Gozi C&C",
    "057c9a67b8f91527c9a7cb8a5497016a394f653e": "AsyncRAT C&C",
    "058e723608c0fb2ac01fd1f42ecf2b03c26af7ec": "Malware C&C",
    "05946f5e7664d0843055003be6aa635d6c69243b": "Gozi C&C",
    "059cef69c326c66a238d86738c5d1da15e44672a": "AsyncRAT C&C",
    "059e0e19e367bd566724ae496dfa7347846bb8e6": "Spambot C&C",
    "05a030093a5141f53b37eb6684fa7575bee0dfab": "PandaZeuS C&C",
    "05b23a86fe8e9c0a5f68ff7a72ee3c65ce6dd61f": "PandaZeuS C&C",
    "05b460ce9e14aa13d64f6e284af7d0437ce3e0c6": "AsyncRAT C&C",
    "05df9191f421f57089281a0067542d9546ad86eb": "AgentTesla C&C",
    "05e140c4511c175e88e9e161164f314f2a68692b": "AsyncRAT C&C",
    "05e704d1ec2ae8543e12b0d492b8a5f2b931af38": "ServHelper C&C",
    "05edec0514636be5e8ea9c4a276d347c6b4d0176": "DCRat C&C",
    "05f55aa751b5cf4a35443b8349e7ea5d116dba64": "BitRAT C&C",
    "06040d102db2f86e040c59ba3907d5874766c2fe": "Dridex C&C",
    "06072c50f131ca75799cb55726b289ce35c0d048": "Dridex C&C",
    "06125e1e4ffd775a55363a615d4232f36d0e223d": "OrcusRAT C&C",
    "061e5f80c1a866a3b38874ff8478f6bbec99c9a6": "Quakbot C&C",
    "062b99cbb7c93bd1b1f97caabe60281978e2f1e0": "Dridex C&C",
    "064d114bd34c4531d0299c4568de78825827622b": "Dridex C&C",
    "06529c2fd241d905ab19dfa0fa758d51950e3c35": "Gootkit C&C",
    "065699d29976a39715a3cffe587ed629028008a3": "AsyncRAT C&C",
    "0671f8eb8bbdfe0405323327732ffed2f949239a": "Dridex C&C",
    "067e94abdfe8cb8e71e15ef762ea456c9fa364a2": "CobaltStrike C&C",
    "0683506f22151f5445fa080f32259190ded1ab42": "Quakbot C&C",
    "06871c099603186ca26b9c51d59dd789f2b3686b": "AsyncRAT C&C",
    "069c38e7fa7d822785a14744b147991f7be0ab4b": "BitRAT C&C",
    "06ac5ea678f3d414c6521b61836878376b693c5d": "DCRat C&C",
    "06b099f47b2fcd9d7297b7c41f3639b433a81125": "NanoCore C&C",
    "06c4e1ee5164ca3ed01842d591e39dc2644ec026": "Dridex C&C",
    "06cbf12a81aa630457d26836c62ac0bbaa77f3f9": "PandaZeuS C&C",
    "06d2caceeec3cebf40189a27f79069bcda28ea2b": "Gootkit C&C",
    "06d5054bee1b52dfc432994889333da3ba74bd78": "KINS C&C",
    "06d9941cb627b71f0d749e5d9db8618c4f772327": "Dridex C&C",
    "06da44f87d12bbcaae57afe663b052810ad2393d": "AsyncRAT C&C",
    "06e27ed6979db891723528a806d906910e0b9022": "AsyncRAT C&C",
    "06e2baf85712999b72c83d6ef231827dfd685264": "AsyncRAT C&C",
    "06fc7ff6358bb69aa295165ad78f22f9c5700aa0": "ZLoader C&C",
    "06fee3b5adabca9b0827a9ff175923c19eef9759": "AsyncRAT C&C",
    "070337030ecb28a47e3825fd7999f255aeeefb49": "AsyncRAT C&C",
    "07099518db33233e686d3b44ba066c7a41c94099": "BitRAT C&C",
    "071735e346e36867f6bc897525d6db1398c865b7": "Dridex C&C",
    "073653abd679069d732660349551a2446ecd6656": "BitRAT C&C",
    "0739aacd13140bb3a141da80578f4e46ecf31689": "Gootkit C&C",
    "073ae3fafe0323f00f088009567822c99c2f3090": "AsyncRAT C&C",
    "0749c48bdd1cba96dd5b4d8bdeb895e54cdbcf7f": "Quakbot C&C",
    "074f7f3bd6da2569b3db52e20f1b9dc7c446e388": "BitRAT C&C",
    "07572d4e9d916d359a7ea5bc036a0926cdcbb128": "Quakbot C&C",
    "0760b70696976b36eecc0a671b7ff710b819fea7": "Quakbot C&C",
    "076163e0fd77493eb9bd252260c629b5358068ec": "Quakbot C&C",
    "0772c4c6a3b489714ed5175a9305bb7cc086fb17": "TrickBot C&C",
    "077c738a10d0ad2f7a749ad4c94921bcb2973ed0": "Ransomware C&C",
    "077ce4414538fc37bd1e6b1acf8cfedc8c26f813": "TrickBot malware distribution",
    "077dc279eeb10e0740765ad9cd2aa2601c31463b": "Matanbuchus C&C",
    "078a90846e1cbd6ff2e88f7c16c7a467b858f957": "BitRAT C&C",
    "079249326fa6fe9fd6066b7b00b51ea658ccc453": "Gootkit C&C",
    "0799fabe788588137e90f0828d06b5343269abe4": "Dridex C&C",
    "07a3fb85657ae7f64d92fd38624e032f940d8fec": "Adwind C&C",
    "07c6fc9d40313247f87b18e0b260f3e57fc1c525": "Gozi C&C",
    "07e86ec2e708d06f2dc0c785c4323572fa9d3b9b": "AsyncRAT C&C",
    "07f50f141a76009fe79bab2acc7ff559887a5174": "CobaltStrike C&C",
    "080342ef5ed2b5d16317695cc4327bf2ffc034aa": "QuasarRAT C&C",
    "080db6beae8b883d4101ce4adad336d3493fe9d9": "DCRat C&C",
    "0817e0e3aa88569f70c4a79da4e1dacc6c034058": "Gootkit C&C",
    "0818627a01ed9e095e779d0b1a26fcdfb26ba56d": "Quakbot C&C",
    "081cf50a56f59be9b1f9504858a225b80f233cb2": "IcedID C&C",
    "0829d766b7ad0425849c630e09c674cdc04c29a4": "DCRat C&C",
    "083f01cb4afae8bc97caa25f86a1fbc8c0718098": "BazaLoader C&C",
    "0848b651c0b54547d89d98312e0054fb8441cffc": "AsyncRAT C&C",
    "08525a9c6d576d0ac2139440619d29fc51874a77": "AsyncRAT C&C",
    "0868cd5f1380f6a7688cb65f6ee3694f83c68806": "ServHelper C&C",
    "086d4c63832e3a0720f358810f80c759217581a6": "Gozi C&C",
    "086f65089d7e2463aa60ab71934fe04c4c9d7cc6": "Qadars C&C",
    "0870506a75dd2e4a920fdf39f5b3de164993df1f": "IcedID C&C",
    "0870e7fc88a04d83d4af1659c8ae348ea0c1c701": "BitRAT C&C",
    "0875f28fe3af064bf789f5605cf8a3980cfd9d6a": "AsyncRAT C&C",
    "0880f2e9604fd6e1ff63751b6448065171ccd439": "AsyncRAT C&C",
    "08832c60295f53d768ef856693615f24e7d02955": "Stealc C&C",
    "08a82a722ad7b5376494d7112785b366da6cf449": "AsyncRAT C&C",
    "08b1abfd16e6b569c2912f7d382752a14b638298": "Dridex C&C",
    "08c19186c8806b0b816bef14da8eb16747b55b5a": "Gozi C&C",
    "08c395a92e1b2346793f71fc692e9b78bfece072": "Gootkit C&C",
    "08c9cf944b1ab2843475ab38423a211a4dab1849": "AsyncRAT C&C",
    "08ca6e54089538df6b3dc471d451af892e8631dc": "Gootkit C&C",
    "08da580056f6ac08676a417468658eff211f02db": "Dridex C&C",
    "08ebb003d3dda16bc81d7bb2f65b2e58be1ab971": "IcedID C&C",
    "09196f48ad7c4d14f43e87d78f7f1040f5178c9f": "CryptoLocker C&C",
    "091ed0a8ebaacf3367755c39a04be69fd7aafc57": "Ransomware C&C",
    "0955d414ef66a251c49f8af6959d0a441fc8cc65": "Quakbot C&C",
    "095bd6463cd2d1f6fb0880e314c651bcb6cedba6": "ZLoader C&C",
    "0964b856b1cb359afb5af87fd6f731c870c48d00": "Ransomware C&C",
    "096c0dd95cb8c4242d4a50937723682a5eaccb95": "BitRAT C&C",
    "096d12200c97588833256dfee4992494642ae677": "AsyncRAT C&C",
    "0982f84f7b7fa7c43a012c62c3eea6a96c081a54": "Gozi C&C",
    "0986f659dfdcd1dcc5850528a095509d4dd344a6": "IcedID C&C",
    "098b929b424bb09cbc9f97f4a629b6c88559a971": "AsyncRAT C&C",
    "09904cda16b560129e7039d2f7482b8eca04a19f": "QuasarRAT C&C",
    "099ba346c5b1f4432e39b7377b22acd7fba0ebf8": "IcedID C&C",
    "099db7d1719ffddf835c71830d270aaf5e7bfcc8": "IcedID C&C",
    "099fad794660b5ccf6bf89782e0cb543342547f1": "TorrentLocker C&C",
    "09a7251e277ca676597175feed291da4403a054b": "BitRAT C&C",
    "09a818c7a02cdde9948496497e3705806ad7ecc9": "TorrentLocker C&C",
    "09ae8b1d552838b45fcf673cbfe01e306ebff64d": "QuasarRAT C&C",
    "09b12ada43368507714bbb8948f63b2ad9f70b69": "RedLineStealer C&C",
    "09b5cdf652e885ae8ed1ecf3abee01a1c00b0448": "OrcusRAT C&C",
    "09c12ad9ac2de7d3014a6b08ddeb77b423821b27": "Dridex C&C",
    "09c502c2e967fef1b18150f60e20c041c484ef62": "Quakbot C&C",
    "09d63e58d39f1c6b61ec2619b357b6d8ea7b3109": "DCRat C&C",
    "09f0c186377363982c197aed2aca602dce4fcf16": "KINS C&C",
    "09f6e55d0a9c4d5e29c5d3952c12e55246cc9381": "AsyncRAT C&C",
    "0a042b353d16f5467fbd1f4fb8aa2910de690a9d": "AsyncRAT C&C",
    "0a14dd97f01db2e1c2f7c75108be46df3211df45": "Gootkit C&C",
    "0a1e1713c99e6ecffd9193b0054ea10ca56520df": "QNodeService C&C",
    "0a213703135064392c5b3d4114c082db06f547c3": "QuasarRAT C&C",
    "0a60a61abc5b97bee92afb73262a37b93235f147": "TrickBot C&C",
    "0a7bdfc4c9ef6888b1082cc5bd5f8562f84f2be5": "AsyncRAT C&C",
    "0a7ce70841da74bf4dcec734b5c112772adca877": "AsyncRAT C&C",
    "0a82039cbc718b673e0b0c341d4a9601d9e859a1": "Gozi C&C",
    "0a8a161d5cb6d714c6f909569c8d83c14825be10": "AsyncRAT C&C",
    "0aa06695ed5c9418a8d41dd5fc87540af20a73a6": "AsyncRAT C&C",
    "0aa0c90b6524192b0b078e9279b3ca1a0e1e7625": "Dridex C&C",
    "0aa121a6bee3f63c7e910b0ac0549cd5af2b95d9": "OrcusRAT C&C",
    "0aa8e028f16350558f5e3553737b4c52c13247a7": "QuasarRAT C&C",
    "0aafe06c86f4d202804785053719f7595da514b9": "Corebot C&C",
    "0ab626cc2bc96abc49c5872b0efc0739ef6747a1": "QuasarRAT C&C",
    "0ab8fc10ea5a42fedf4308fe70fb5f8aa3cc9577": "TorrentLocker C&C",
    "0ac6daa9411dfa6daa21f1d13ff34f6a1adc1bc1": "AsyncRAT C&C",
    "0ac6ec9453c687b183697cccb84155d14699c513": "Dridex C&C",
    "0ad3c352ffecdaa0a14c556639146e497d1b971b": "Gozi C&C",
    "0af6a32f066a5d5a829b4f0bae9b0d3856287c73": "BitRAT C&C",
    "0b0d838ae886412b31a3f6f0e9756d4c275dbe6c": "Dridex C&C",
    "0b1563b845d09ce8ccd995e248aca7e33ea26982": "AsyncRAT C&C",
    "0b23d6175ef8ff6c8ee8b224514a1081f98eecac": "BitRAT C&C",
    "0b240469f6168b6cf529bd353268548685121e22": "CobaltStrike C&C",
    "0b2b84873f7064d63e527414454f627dc8881006": "KINS C&C",
    "0b2d469d039371c3bcc2be00c9a9f41784092ced": "Dridex C&C",
    "0b3a189acf9baab0b3d037c763eec8147219037c": "CobaltStrike C&C",
    "0b42325236e86d495258fe26251e8b734ddc37a3": "BitRAT C&C",
    "0b43b1f17fc3b48ef07abddf6c61fe1605d93121": "FindPOS C&C",
    "0b47b3c41b3f19b0ba79fc5fcab0ce81402e0030": "KINS C&C",
    "0b4a266eb213b641769200729ec06bfc1fda028b": "TorrentLocker C&C",
    "0b4b65ba1a341c9d5940af1bf0b6218a915f7dbb": "AsyncRAT C&C",
    "0b51899b5cc59f222be2a6d0fbea35a913618616": "AsyncRAT C&C",
    "0b531023d72ab313474667eff0d0a1b33ddaf127": "AsyncRAT C&C",
    "0b5ee11166cd7a48903dfb1f4bb5f27a65b86600": "TorrentLocker C&C",
    "0b6477993a1b5c5cb194ed72185d052d61206dc5": "IcedID C&C",
    "0b6d456707c8d575da523fb82a119fa94b1dd64e": "TorrentLocker C&C",
    "0b8b47b4b29447985d425d90a690262ab733fe94": "VMZeuS C&C",
    "0bb085d561df07c889e5bad51c846371d4fcfd61": "KINS C&C",
    "0bbc7100b10f7518fb726ca59af03da78b2c177f": "Rhadamanthys C&C",
    "0bc117f5024aab93842984837206efb850258ecb": "TorrentLocker C&C",
    "0bc4b685a2acda723630100c1c535cf7b0d3fc19": "OrcusRAT C&C",
    "0bd43c3126de1b437f75efc28344f02f06801333": "Malware C&C",
    "0be86a6f0a79c0f3a32034c21c7dcfa159ad5d45": "PandaZeuS C&C",
    "0beefb32f9fca5562ee3bf9ec7e351444f0f7381": "BitRAT C&C",
    "0bf2bede3568a32c456cdcddbc104635b2196c95": "AsyncRAT C&C",
    "0bf417e3aaee820bc63a92b3d756aacdd5ab3b6b": "Dridex C&C",
    "0bf547c6015059dabb10f7af8fe388e314bdfada": "Shylock C&C",
    "0bfde53668bf3b686386d94877bbf7f248b3530e": "PandaZeuS C&C",
    "0c1aabeb94f43580ef47b5b43d9424db1ff4661d": "ZeuS C&C",
    "0c1b32bb67bf6b3b30fdd40c4a17f6214aefa866": "Dridex C&C",
    "0c1fdd7c0086b6350a3968516262a1a959a2ec54": "Quakbot C&C",
    "0c25569d92b7e87e33852bea5138fbd6fd7b2610": "Vjw0rm C&C",
    "0c43244977d281398338b084608d20e67e665818": "OrcusRAT C&C",
    "0c45ce8c56fcc400b798222345c24b5d386021f4": "Dridex C&C",
    "0c4b088d37609b9960fb54d6b29a23f5a3462abb": "RaccoonStealer C&C",
    "0c4d4baf62c47dedcc53474abf227373a168edd4": "IcedID C&C",
    "0c56c0abdb89a985b73c6c26ebcff88dbf0b0464": "BitRAT C&C",
    "0c5c0b114267590939592a6d4a819d8917097f73": "Gootkit C&C",
    "0c6d3721e9b4ba3bbac4617b34f0f0ff75f88e72": "Tuhkit C&C",
    "0c775409656266cb479f85dc45092f2b6da5ddac": "VoidLogger",
    "0c8412998e79a33f881f85cca83c6b37511fcc23": "Quakbot C&C",
    "0c90847769562ba88ef499f9f9f659f177b462cf": "AsyncRAT C&C",
    "0caf29e9a5d38c497b136406d6b02552a986b88c": "Dridex C&C",
    "0cb3da710c6dc833050a82f4d3864c05ddcb76c8": "Vidar C&C",
    "0cc206dbb15e1bd656861252c200ee36d42017af": "IcedID C&C",
    "0cd05bb43a7baf3f5c07760bf6d17ccc9de0bb19": "TrickBot C&C",
    "0cf710e33d3e4a572dcba9763d92e65b5d9caf57": "Gootkit C&C",
    "0d0f7891bd61ae0c503175723ada783c9973f3b8": "QuasarRAT C&C",
    "0d2274585486af6aacc8afe0dd7660b90a17717b": "Shylock C&C",
    "0d2bb0470fa5b8fc63667d03c9a0901d711e3a17": "AsyncRAT C&C",
    "0d34e3ba9635257c9356fb1dd9be64b0c7a08ef3": "KINS C&C",
    "0d41871221706791a26203f9617b859723ffb243": "Qadars C&C",
    "0d4348c0a5f3825a1350f8ef86e0e85e91a18d91": "CobaltStrike C&C",
    "0d53801a2de88dbdfb02eb24727bcaaa9c98568b": "DCRat C&C",
    "0d55a4dd72eaa9c0efe8489e182bff36cda1046c": "IcedID C&C",
    "0d5b2a16b45cc9820f84267328f6a30a812d0042": "AsyncRAT C&C",
    "0d8b2334680f420805cdd03fc5c1da4c78306e5e": "AsyncRAT C&C",
    "0d8e5b2cb22c0c3b1bb4cc9eef3fa74788351165": "Ransomware C&C",
    "0d92b28bf1d0db7822a37f47781b49ff26a71ec2": "QuasarRAT C&C",
    "0da045613676e3ae738defabe976de56c3438489": "Dridex C&C",
    "0db4db5a6662a6a3b53d7a1df4bd4300864252a4": "AsyncRAT C&C",
    "0dbd1eea345461fc7d0afe92e4d8490b00479afa": "IcedID C&C",
    "0dbfc8d8265b8604f7230d5890cf992d74a45d3a": "ProxyChanger C&C",
    "0dcc9701d2b4d916ce4ec436a8a90dcdae24ccb3": "Adwind C&C",
    "0de22bad561578e8ba0cd97cc7deb4f56c015e8d": "OrcusRAT C&C",
    "0dea646cb33fb285b12da4341c5f8b4cf45a51fd": "PandaZeuS C&C",
    "0dec05bb548cb8412f83b425fd082206b28f87b5": "Quakbot C&C",
    "0dee2da9fc683090184464da3044ff12969e76d8": "Dridex C&C",
    "0dee94cca8a85c6b6de16d889b90584b056cff74": "Quakbot C&C",
    "0df1b6e7514fb4e728144d9b2abf684238b1000b": "IcedID C&C",
    "0dfb213b0aac91629c97e83f1cfe3e60a05993db": "BitRAT C&C",
    "0e034408346e2c66faeca8f89724ea1ff6c75a5e": "KINS C&C",
    "0e12b2dbc3e8992b840cfd2ffd6bcec38c18af13": "Malware C&C",
    "0e1f2ef3c459c74c6d8e76ebbfbf54c3c69354de": "Dridex C&C",
    "0e225cf941fd1e7be0f5e9fe21dd13c373100e44": "Malware C&C",
    "0e276ebc2d52a58a4a31f1c93316538b8524afa7": "AsyncRAT C&C",
    "0e2e5e65c6b4803a644e28b833eb89ed5b31f7ef": "AsyncRAT C&C",
    "0e2f2b1364736e27609fd49c3d6f0fccb9a83fb0": "AsyncRAT C&C",
    "0e44c7aaadd1186c17f4f1364e3722c172a7ce2e": "Quakbot C&C",
    "0e46fd94504113bc42f1026672239aab8249962c": "Quakbot C&C",
    "0e5441b682565bc9adf5db854bad84e84017a521": "AsyncRAT C&C",
    "0e56dcd8bfda1d43c17e02912db3b92ed2a0c088": "DCRat C&C",
    "0e63759575633cb2626cfe23f0ac5f67506cff1b": "Shifu C&C",
    "0e66f3d415a6e83a25ce595e409a8c8be4e87af8": "FindPOS C&C",
    "0e95717d24caa218bdd1d5ba3587677b427a8933": "Gozi C&C",
    "0ea588347268749ad831a7188acc6df00e443863": "TorrentLocker C&C",
    "0ec9455d6b40b201791ed817003f3dcc232b28b3": "BitRAT C&C",
    "0eca9ef8356ece1be732d9f6fc01a8e537af2611": "Gozi C&C",
    "0ecb00b9fb085b9671058df0900956d8cae98c3f": "Dridex C&C",
    "0ed266200605c861f8ee04239e921287d0b20a21": "Quakbot C&C",
    "0eda9c1bf5f4ac1f5bd44eb93d8e7bf0acf3a691": "Dridex C&C",
    "0edd722452c12c686f16a7ee7be74b56e89a6db5": "CryptoWall C&C",
    "0ede2a9982ef00c0549718f1ec7e149171bb9035": "AsyncRAT C&C",
    "0ee1e19b755a24f497e45be308608413ab34ca90": "Upatre C&C",
    "0ee37f387404054bea6eccca1c3fb9336f52e498": "AsyncRAT C&C",
    "0ee40932825dcedc543a6a92965687757a70338a": "AsyncRAT C&C",
    "0eea47b589dfcf398f8759375d7ed12c1ae03b54": "Dridex C&C",
    "0ef75b1cb1935ad21bbd4fd940ccb38de3e6976e": "Gozi C&C",
    "0ef78a83ae88376ceeaeef6edd3195d39d73d8ad": "AsyncRAT C&C",
    "0f0169eb7bf66baed507976a31d68054e241f7d5": "OrcusRAT C&C",
    "0f0346bf4abf28d3ebf7732c6f9d9562e1b2b060": "DCRat C&C",
    "0f073d24a67637f427e74b2fa1ff5bbc42c4c157": "TorrentLocker C&C",
    "0f206c9a9522ca50c6df640e3f7dbebfaab817fc": "TorrentLocker C&C",
    "0f3c8ff02d1cb80377f8e5dd33417a18174e4099": "TorrentLocker C&C",
    "0f3f717020b132bde96c9d00173a7a53dd68ead9": "Dridex C&C",
    "0f53bc19baee63765bf711a1a34abf762e977546": "AsyncRAT C&C",
    "0f54d8f7eb723b690d8d5b61610136fa6840d2e1": "IcedID C&C",
    "0f62287ab3d88837c86e11599972ebed9abe2fbe": "BitRAT C&C",
    "0f68d8e8725eb584c1660d844954691d3575ae35": "AsyncRAT C&C",
    "0f68f0b233c8f90ed13ef5b4edb63b2a1a3bbcd4": "AsyncRAT C&C",
    "0f6f1aba7efd8c2a4aaa4297af4c061fd1c0d5fd": "Quakbot C&C",
    "0f760060863db3bbb1c42589a5f8ba12bb6a09c1": "ZLoader C&C",
    "0f7f0ed6f4f0aade6ed2a1cbcd87dfda657528f1": "RaccoonStealer C&C",
    "0fa737e6069d650d7014f01ebe679f47b6288a93": "BazaLoader C&C",
    "0fa94b0319b7952e809e2fa084d36a9ebc428add": "ZeuS C&C",
    "0fb89c51abb8d19955eb5b61b12a7c21ac29c76f": "OrcusRAT C&C",
    "0fc77c988b47ec2927fb9a9cd12e28b97fa13e51": "AsyncRAT C&C",
    "0fd75c5a5572afde739cefb11feba136f1c191f6": "AsyncRAT C&C",
    "100f4a41baefe223400cf414adef7cdcbdf92d41": "CobaltStrike C&C",
    "100fdb592c9db1eee434cf83b6192b7770e3488b": "OrcusRAT C&C",
    "10109781268ce3d9431e0a8d0886b94400bfced3": "PandaZeuS C&C",
    "101b0f5b4f4e336a2e9cc82b8e00d397f4939e6b": "Quakbot C&C",
    "1031245fa63cc4b7567f702bf6e8ee37159233df": "DCRat C&C",
    "1036271674fec5d87c855e9a81b820a843f38d39": "AsyncRAT C&C",
    "10404f65b3d0cafb327775c87c86ace56d6c703a": "AsyncRAT C&C",
    "10530dc91451b4775017c95fdd11763011f95004": "Quakbot C&C",
    "106b0ee83c924047ca994e3f6cbeed94c148fbff": "IcedID C&C",
    "10715a120804d5b64e83d987d6c858e6b29a89b0": "IcedID C&C",
    "1071d060d0c1257a33fbfd9b83dec0ab30436e04": "Dridex C&C",
    "107c1ae344f74a46f7d1e78bc3781e5b66a0a7d8": "AsyncRAT C&C",
    "10802705c65f123e989797bfe0ba46ba33b39d70": "ZLoader C&C",
    "1089af95083b7e36326af597530ce854a5f96f7f": "AsyncRAT C&C",
    "108c3ab5409f004342875a2c82fd51ddaa7274ac": "AsyncRAT C&C",
    "10a74978fd779e573f2082902886babfd4aa6c36": "PandaZeuS C&C",
    "10b3560db0c77446bef487ece9c5d26cf6e8d0e9": "Gozi C&C",
    "10b91a453ae6c3dc71df8d4485fa489299b9859f": "Gozi C&C",
    "10b9c59b0435947c97f5da8c3f4c7b5765a2e61d": "DCRat C&C",
    "10e70548ddee0ff53fe62247bf1b7075a30aa5a2": "ServHelper C&C",
    "10ea2497d8fa21b8125bda720c98c4799cf21624": "Shylock C&C",
    "10ec903d027a1f35268dd53af5be5fd2c7e3892a": "Gozi C&C",
    "10ee62a1a2d369e3a5b55f7c71273afd424f08d0": "KINS C&C",
    "10f8c2b1f1ea10c12f7fc156f9d584c37d3d98be": "Gozi C&C",
    "10fedb947efc90060623b08da660330c4b3722f6": "Gootkit C&C",
    "1106c395fd9f9281632b712bb34effdcb9016378": "IcedID C&C",
    "111007c2cac6241061075c6834a79ebd1ae5a4cb": "Quakbot C&C",
    "11234647793f73cbded849d827af9f33ebdf288a": "AsyncRAT C&C",
    "1126471892e645bab24afbaa6e2bdb9784425d04": "AsyncRAT C&C",
    "1141c41210c0ab791f3c8b51542ee16c5533ec60": "QuasarRAT C&C",
    "1147947433f261bcd2cd8f508461e01898c3960b": "TorrentLocker C&C",
    "11525e4bb2f541bf5d1c425edf3b061d2380fbfa": "AsyncRAT C&C",
    "1153e691d541234d434ea1543106ecc475f30693": "Dridex C&C",
    "115c3bbd6300a13a8593e1ea090433cdaa8539ca": "QuasarRAT C&C",
    "1162b1e7e4c9166f0e74bead5be14c1f8d68ca62": "Dridex C&C",
    "116a86e0c70310d135221b48cdfe88935a3e7a49": "Adwind C&C",
    "11813b03b912190950eba3ddfe83a3ebbbead4e1": "DCRat C&C",
    "1184aeb6470ab8e149edb10bd81613fa871f7ef6": "CobaltStrike C&C",
    "118c055ab8837cbfad1670262da046e68ffefeba": "Gootkit C&C",
    "118e9300fd7659eb54c28f0fb1b61bc5cd027c02": "DCRat C&C",
    "11a1603f749ef5d4d460634ad3ae6fc57d44f5ea": "PandaZeuS C&C",
    "11a2ca0d270243cd3e7346c27765e523c155cc96": "AsyncRAT C&C",
    "11a371400dc9e6e31bf510c08fd2bfb4d226f056": "PandaZeuS C&C",
    "11a6130c1cd6c94b43ec7d9e410261d090a9a0c8": "Quakbot C&C",
    "11a8f91e9ced99fa01a5f9f3e769aed3b99650f8": "Quakbot C&C",
    "11bbf86062c5469d5c3ee8ba1cb3cd8f5b8d0ea2": "Ostap C&C",
    "11bdbe13cea35d51614df7cbab70cc0a5bceb343": "Dridex C&C",
    "11c02808a85d245ae79c150f57e6aa8bcf43a328": "Quakbot C&C",
    "11cd138f46db0091c0b85b16b2d0e88af44328ad": "Malware C&C",
    "11df788f84138601ebcadbff9ffea902cb41637e": "AsyncRAT C&C",
    "11e58dd844a8a2e592c43c9515b7f86f30282941": "DCRat C&C",
    "11e68357b3e088a3708f1b64cf8da3017488b379": "Quakbot C&C",
    "1202213804fad8a8b6f3f797a130d10b423d387b": "BitRAT C&C",
    "1204580187849e1376f8f778507df5a9f01569a6": "RedLineStealer C&C",
    "1206c8147fd72b7e41b6f7e63bf067c155cfae0a": "TorrentLocker C&C",
    "1210c3324a067448d47ad198084d7a04b15fbb39": "Vawtrak C&C",
    "1225b3d97a5ef5fa6deeded90438d808121076a3": "AsyncRAT C&C",
    "1239afaed19c3ce093f4b2b530d62a1aa7af771e": "AsyncRAT C&C",
    "123b7034a5ce368e46582ee93289f06d6989b2d6": "CobaltStrike C&C",
    "12456b42c19d9b116ae5776f7448951fc2ca1baa": "Dridex C&C",
    "124643542ad5083b7b98e826c36732f36ecbf1be": "AsyncRAT C&C",
    "125f31e49c0345137983fd2354b9b37e516fbe28": "AsyncRAT C&C",
    "1287c10bc63df5c8d6f64134652e8227cc3ab007": "DCRat C&C",
    "1290a4037734f8f771db4dd157b0c9958d052b11": "ServHelper C&C",
    "12a879308ba22f02a55fad62d5b04be63a8d8a90": "QuasarRAT C&C",
    "12ab0e4e2cb1fa5818b3a771871f144186404cdc": "BitRAT C&C",
    "12b4b8c81ba47731a81fdcad111a0f38ad5b09e6": "TorrentLocker C&C",
    "12b5fcf91fd8b5c89a74b7b691ac90a366fe5aca": "Quakbot C&C",
    "12c7aa3e4169ff2582c28245ffa5b362697392c7": "TorrentLocker C&C",
    "12d0c4770b7cdd7a9b3a32828b61bbbc80c962e4": "Gootkit C&C",
    "12d9d892ee8c95d46e6a2350254b611bd105b529": "AsyncRAT C&C",
    "12dd4c2cc3237ed004098277b00d4332c7cc07f3": "Dridex C&C",
    "12ef34a0472d1d50228bdcbd1089c728f6800d9e": "TorrentLocker C&C",
    "12f084670c520b58cb35cd4c355ab982dfbba399": "AsyncRAT C&C",
    "12f3ea9d654deea679adbabd27621bfcd2bbaa33": "TrickBot C&C",
    "132a42bccc14c68f08633e553b6688902b556ae0": "BitRAT C&C",
    "1333316e0ce98ce7726113f8da521e794ca03f9a": "Shylock C&C",
    "134544467cb4447b55c5cd081e72d1215e5fc42a": "DCRat C&C",
    "134e5ee1f8d4c3524bf0c70d6148b62512a7b81b": "Gozi C&C",
    "134fb54ec32ba13d109d39b02b7afce805196e1a": "QuasarRAT C&C",
    "1350e40c1d96dbe37106e3d38bc9687692f14cdc": "BitRAT C&C",
    "135205db70a8087cc855746924a6275647bd1c3d": "Gozi C&C",
    "135fbc73c60de86782b05078b5bc443a2610e95d": "Quakbot C&C",
    "136e367e1850c8e74384ff0c5432fda7bda8ef89": "BitRAT C&C",
    "1373e20d483ef2c2b3fe9285ad349bca9f1be2d6": "TrickBot C&C",
    "138c72d19a86a1e26c97fb78e4e4efe6c099631a": "NetSupport C&C",
    "139772977c4396a94740493c6a8efc339a3516c6": "Dridex C&C",
    "13a2025f01a39af2f20a258a9bec88a36d36584b": "BitRAT C&C",
    "13b656371e83022e26ac7c82e391bb2b34de53bf": "KINS C&C",
    "13d63de5204a6c35182787935c8516466b1fcdd3": "Dridex C&C",
    "13f300e4b43397fb9550e324e3b04e98b4d270f7": "Dridex C&C",
    "13ff7fd53d92e185657214a7a47c090e26f529d1": "Malware C&C",
    "140b7a09d2448d688ab2569cee7e932dce7cc6dc": "BazaLoader C&C",
    "14133d53ce26bf94c0397c410dafb675c3ab62d6": "Dridex C&C",
    "14258736525bd529535a9b73b566d1f2c8f14461": "AsyncRAT C&C",
    "142d6b4f5673ade8dd09fa3d705be329adfb7531": "Gozi C&C",
    "142ef214dcacd78383d86f20a991e539a62c90ca": "Gootkit C&C",
    "144544c8d0ce8791b3d32cfb77a27f4840a2fac8": "OrcusRAT C&C",
    "14468f277dff9e73fce684e8bb350456ff615f0b": "TrickBot C&C",
    "144b047fc52f3d2e6628338e5482cde29a1ceb3d": "Quakbot C&C",
    "145d04c2ad96e1fb32db17181ec9af3680145935": "AsyncRAT C&C",
    "145e5b0a2e9fdcfae8baa4784a2b92f7201680ba": "BitRAT C&C",
    "146aebda6ff7b52f89564f6c96e1c366b2af5401": "AsyncRAT C&C",
    "14767c588fc8c81d95a7c1b66be7e4b38e663739": "AsyncRAT C&C",
    "147a2b14541b2a55bbcc2a79cd5e1976ba8ce611": "OrcusRAT C&C",
    "147e117c50120f86c30d598f4ec75e837794748a": "AsyncRAT C&C",
    "14873a6fccdc7c37fff2f9720a557ed401658d93": "CobaltStrike C&C",
    "14b1200d6c7614371bce81bc69d841c097e6e916": "AsyncRAT C&C",
    "14ccca986c4b83661ddbf1fb3b7351f216f3a007": "TorrentLocker C&C",
    "14d0b902caad60435ad3c32a025a24c1f97929be": "BazaLoader C&C",
    "14d43d6c4c31423942819f7586ed67e293516972": "BitRAT C&C",
    "14da2afe542ab49357645647bcbc012a60ca8d16": "hVNC C&C",
    "14e563519a67e007733ee687a237c686a2a62c2f": "PandaZeuS C&C",
    "14e65c13616592a49916d11baf4c76b875b7c5f5": "AsyncRAT C&C",
    "14e97c0d73ddb494ab11476821b4999eed996ed8": "TorrentLocker C&C",
    "14efa10c234b5c6dbbfb2520e144f91508ba4b7c": "CobaltStrike C&C",
    "14f2a08ac307c0025f3947c45ee1284228f97842": "Gootkit C&C",
    "1513e1070a6353408ccdf550f8cfb92829e2ce38": "TorrentLocker C&C",
    "1517a37ebebd3fc6bf95ab70d337539655400ead": "Malware C&C",
    "15182ab8432fcd20ac10a1582b4b9627f971658f": "AsyncRAT C&C",
    "151c050beed589505a9a8d5ccbb4a37996e92d17": "BitRAT C&C",
    "15295cb44d4d41537526f8c6ebcacae1ebd43d4b": "Dridex C&C",
    "152e495ee06603a9b7313c12854e46f9c476f982": "AsyncRAT C&C",
    "15381b6d25110885b8cfe9e0e667f08aa70435bd": "BitRAT C&C",
    "153a7ea3a7acb476fd66d214e61e51bb35b4a24b": "AsyncRAT C&C",
    "155e0f5d3c5353c158a8262b6ecf0c9d9634a627": "Dridex C&C",
    "155f9a76e76ff2293a3a283f232448d3717c9097": "Gootkit C&C",
    "156e3c069c3976c3f2e97d2a964c1fc19d38b3fa": "Dridex C&C",
    "1574232b013ff08e4771df9b70fdb17e38f25695": "AsyncRAT C&C",
    "15761e8a78189f6c050d071a164a3f426ae174c3": "Gootkit C&C",
    "15777050b28f31b84bd278051e9e4a391a145237": "Dridex C&C",
    "15846bfbb43e5b576dd3f3f6275ceb731d9926bc": "Shifu C&C",
    "158618c43a83f3414cd75486e3fa3cf2e70b3746": "QuasarRAT C&C",
    "158e10290c7a44fa661f913f66b3bf779c708d45": "IcedID C&C",
    "1592d6bd7a9677d4b6b33068e53fadea15f8c793": "Vawtrak C&C",
    "15aedbdb8bd020440c936cb25ab775fb0d42f098": "Dridex C&C",
    "15b428538476983abd09c384b44f18b3a5b798be": "BazaLoader C&C",
    "15b4cbdec2d2ec1b2a448839fe73d6c2d5b3e0ff": "Gozi C&C",
    "15b762a4ccae681004e36caf23f19f0503856ec4": "AsyncRAT C&C",
    "15bad520f098b649155b7d8071d9a9ed921e1d7c": "AsyncRAT C&C",
    "15bc800a0976f2faa4f2a8a25741ba721c0d64e0": "Malware C&C",
    "15cc6bca1f1eee1576924bcaa93d8af29f259512": "Gozi C&C",
    "15e1bde49062dbf2d8e21f01cbf4231eaff8b2dd": "Dridex C&C",
    "15e7391b57d7d610aa60836dd8dbbbaf57b07882": "OrcusRAT C&C",
    "15ef78c616027ddf4602e039a71f505a22d67565": "TA505 C&C",
    "15f121ad9c6e430d4a465d8ff60d1d0e6166d741": "Gozi C&C",
    "16004c0b5575453b3bff2fa2f23328fc2670c50d": "BazaLoader C&C",
    "1604657c34627bd69ae1f885bf4a8870c789cddf": "Gozi C&C",
    "1604b933367cfc643050158c7cdfca5b18f1f19e": "QuasarRAT C&C",
    "160b2668d67206c1a6edb3b6048d77b6be2becc7": "PlugX C&C",
    "1638ad399aa75df83eef613d827f549b21b54331": "RaccoonStealer C&C",
    "164093454336b9c6b780bf2ba0e599e5dcc1c193": "AsyncRAT C&C",
    "164aaedfdf707433c8a50f1e555a22f7ee2f77e5": "Vidar C&C",
    "165505c954ef9c182b5dbaeb98834b3d5025bb31": "Gozi C&C",
    "167acd806809e5ea36a026733930f2d76a824113": "KINS C&C",
    "1685ba03515650a1c2a1338bf9421ea00a7c0362": "Dridex C&C",
    "169fcafd6f04e3f0179483e10281bcfbbbedf773": "TorrentLocker C&C",
    "16a9f4dd4f3598b6cfed52bfb1076c990ccdb451": "Retefe C&C",
    "16b297fe392a082c653ed159106253c76c2e6b66": "CobaltStrike C&C",
    "16b8caa789abeff2c49b0da43519b0cbf3f7707c": "OrcusRAT C&C",
    "16ba5b214b47f1536121d4393810ad4f6e7a2b7c": "Adwind C&C",
    "16bd348cab3388079a7375d77d045daece8e6468": "RaccoonStealer C&C",
    "16d2a499d227a499be98431da1c912ff48761646": "CobaltStrike C&C",
    "16e06a88dbb10c75077780d4baed6d0b2733f985": "Gozi C&C",
    "16fd937fae211d1c05ee2800ee40f5a2b67069d8": "ServHelper C&C",
    "1710fe0b2e0354bb0c8a96c4febd42462226be5a": "Dridex C&C",
    "1714ea54c7f0d5e801c9822137a794b655e44529": "Qadars C&C",
    "172047b8223439ee5f24ec89362157d279d8f12d": "AsyncRAT C&C",
    "172de1d115c4126961ead6109f8b4f853370d54c": "KINS C&C",
    "1757dd0125ca88a59c56b4ea84422187e8e42ea6": "Adwind C&C",
    "175a7c910d0d06db6577dc3fe048e99c4a833f4a": "AsyncRAT C&C",
    "17652681a4d9311c49d274f1ee7ad620211ce7dd": "AsyncRAT C&C",
    "177ab87c04422196eb256d66e1f9e41d7945e8c9": "AsyncRAT C&C",
    "17874ba064a5a5a84d9093e321cd0acbda2faf7c": "Quakbot C&C",
    "178d9159f095c36efb007f18ac11f75e060bc964": "RaccoonStealer C&C",
    "17b2d26a235d92f31a992f85f2483d7ffa6d2109": "Ransomware C&C",
    "17cca4da0c0e5462418b65c78b84accb1137eb26": "Malware C&C",
    "17db8874488b8adf06b300507506c4bde048bfe2": "Smoke Loader C&C",
    "17dd9822d93bd01d91e99a42a30270a30517e82d": "Gootkit C&C",
    "17e4cc5240262f73f6c1ae2721724ed0f547a59c": "Dridex C&C",
    "17e958d3003bc9073246bd49866c355870a60830": "Quakbot C&C",
    "17f01f889f10bc21b66fd8769bc4163451494b4b": "Neutrino C&C",
    "17f5cd37ce818211f3136c4669ee3b6f91efd6ed": "AsyncRAT C&C",
    "17ff788ae04ce10d278a40d0e1e8ccab1d0dc8f8": "Malware C&C",
    "180dc5df7680cc83e76d6218d8636e04819b75f2": "Quakbot C&C",
    "181b7096284ebfbfa26ad01ad6d586854999621e": "AsyncRAT C&C",
    "18391d14164ea2bac3b2a86298ba54e9ac4d128a": "KINS C&C",
    "18398caad8e2f868a69de8dce07f1ecc0755a32c": "Malware C&C",
    "183d41c08e50fb28dfd26556cec89929a5eae8af": "BitRAT C&C",
    "183e703a4e5599a22aa0d563eed49e0d47b7640f": "TrickBot C&C",
    "1841c8063d7c6fb27a74a5d5ae566038cd1c8bac": "AsyncRAT C&C",
    "184b3bc4dae204aedc16b482a7a5da421faefa31": "PandaZeuS C&C",
    "1854931df56d041c0a33744a9b0111e11550deac": "ServHelper C&C",
    "1859ed5aa3f7220890cc94e83d19bb3d146059ae": "TrickBot C&C",
    "1860c11a2226ba9d254b5de2573197be9d0c6644": "KINS C&C",
    "1862c777babf298fe5a93406e4dc8456d718abcf": "Qadars C&C",
    "186568553a81a8b3fd3e332ea336a9fce24160f1": "Gozi C&C",
    "1869a409c3628cc3ecd7b6f61410cb3d16bef14d": "Dridex C&C",
    "186cb43aa48437a2f61a662be19e3f278c5d5099": "DCRat C&C",
    "18864bd01231a83cab6a6cea2ed3769b553d5ccf": "Dridex C&C",
    "1888d4252855802d9b798b130d4f656d89aced55": "IcedID C&C",
    "1890b3a0cb986ff4dd981376938876a61309b588": "AsyncRAT C&C",
    "189f94dc999d22a07e0814de34a77451161a7108": "RaccoonStealer C&C",
    "18a105f3f62e52e24714493e382b00b93070077b": "Quakbot C&C",
    "18ba0e66d5ee921eae0cee4d2ed0bbfa9a6a5b07": "Dridex C&C",
    "18c4529d486ddea86bca5f65fcf5102d841891d0": "AsyncRAT C&C",
    "18d2a163f67d6ecb68fae43c53726b4c7541dda4": "KINS C&C",
    "18d77887055dbe8981282498745606df2456fed1": "Quakbot C&C",
    "18defc22072eaf194bf722362e222be219459e20": "Gozi C&C",
    "18e337e72ef9ade65b792b500df754918e1188af": "FIN7",
    "18f0aed8c8318427e3b7aa6994ddea59e637456e": "BitRAT C&C",
    "1920e1292a4170b9e7e3d4def9c003038d6b8ef4": "BazarCall malware distribution",
    "192520d885c7bc2928cbafa39241664eacd22351": "AsyncRAT C&C",
    "192f20495a153c9448b7da3ca76ff008908468a2": "CobaltStrike C&C",
    "19331ae7a5d457bc362c882797936e798c35bf51": "TrickBot C&C",
    "1939a155906fe3476a9d43e1590ed68abbba8abb": "Quakbot C&C",
    "193a05c5325d1cc0cbf48e87f61e95e721588bcc": "Smoke Loader C&C",
    "193df87aa01c362b4dd26f0cdb9ca3b1958eb965": "Dridex C&C",
    "193e5ae878e2a71f4fcc60f42168bc63d19d1fb5": "Gozi C&C",
    "194ef9fd196268316911250bcb90a10fedffccf6": "Gozi C&C",
    "1956b7ff84f6f841f5b58d63768859b6d5f03d3c": "KINS C&C",
    "195f734d144ffb908f92cbef3eed5c658708468c": "Dridex C&C",
    "1960a592cd346a934f828c7b1da17de175ba59d4": "Malware C&C",
    "19816ad33169bec606a839ca7de06f5d508aed35": "AsyncRAT C&C",
    "198be3e1198934feec57d110ff36cf7905dcde8b": "Dridex C&C",
    "198c4b5852d21b425acb05daa590d409f3a54a65": "Vawtrak C&C",
    "1994a0b034b02da73b2fe9a170f8ce527140c9f0": "Gootkit C&C",
    "19a4d266644594c1a7d5f25e794902fb05292723": "Quakbot C&C",
    "19b19d332a6f48209ee9dd510b3fe1d2178c8806": "AsyncRAT C&C",
    "19c07aec70f01f798ca69378cb454f8975425f93": "BitRAT C&C",
    "19c07d102abda2a46768a70368f6d1cb5fdbfcd6": "AsyncRAT C&C",
    "19cf21e6326b6125b023c53df23b74060f4e786e": "IcedID C&C",
    "19da07607784b4bb3bd1509bc8e80ca4b91e59ee": "TorrentLocker C&C",
    "19dbb556067486a789847851a793efba00d4c4b8": "Dridex C&C",
    "19df51915fbd546226fbad5981b3b67998824486": "PandaZeuS C&C",
    "19e664f09401bf648b6ea57719e34ad795f3b6cb": "AsyncRAT C&C",
    "19fc51f0a4181e610b6187a522a15aef7b56ed33": "Gozi C&C",
    "19ffcdb04e53dc98bd96f76f457dec3f5f634157": "BitRAT C&C",
    "1a09ee00f67b0170d7ab138c9ba514cf7af55085": "Dridex C&C",
    "1a0fcad119150066f12c80a5bcc328fb82b686df": "AsyncRAT C&C",
    "1a17f101f65e4619de08a8e403d12974df94ebfa": "TorrentLocker C&C",
    "1a226f6aa67bf8b800f4bfdb17a06200bdc817e8": "ZLoader C&C",
    "1a3fa8f856d4da6483f07b294041cf842eb4e9b5": "KINS C&C",
    "1a44fa70e56a20a454b3bf72cdbe772e538a50cd": "Dridex C&C",
    "1a450af1e42f98a2832216401bcb17bb73ac1d32": "Gootkit C&C",
    "1a4c350ad08f5f81f5a05b67d1fad34b1d6c1e49": "BitRAT C&C",
    "1a626a33ec91a63d9aa380e533810252419d469b": "Malware C&C",
    "1a823c07cdb46ec942d791ec9499764280c2cdbb": "AsyncRAT C&C",
    "1a876128e6630d6a0431ef912f6ad12a084d8e26": "AsyncRAT C&C",
    "1a94d28c2094796b536d3031709de0fe712a132a": "TorrentLocker C&C",
    "1aa715b7e4ba8c33eb1077501e16df02763b8f4f": "BitRAT C&C",
    "1aa863afb27b9d4f9b2b1c556ece869e0179e909": "AsyncRAT C&C",
    "1aae3da8a49944a854ec12c94665bce708f48904": "QuasarRAT C&C",
    "1ab33d5041e4176509923d1212133343860427b3": "KINS C&C",
    "1ab80697792c1fc2aacf513a69b43853676967d7": "JBifrost C&C",
    "1ab80a1ebece5ead35b68e2c19ebceef6e431888": "PandaZeuS C&C",
    "1ad2cdb45867cb9040bf20ab53f288c1d529a0ac": "TorrentLocker C&C",
    "1ae281e32a786acf8afd28c270e6a50c8a290233": "Quakbot C&C",
    "1ae81afd9dd888d8b5b603c9a010de1b558fc5b1": "DCRat C&C",
    "1af0896977207047015f85b6a3635362d02b8146": "Dridex C&C",
    "1b002f4ea75a30d5a630f080a325edff70f80e69": "Shifu C&C",
    "1b1df7078d718053312037ccfe1f867dcc593ec5": "Malware C&C",
    "1b1eedd19f9f11337ebae28a03c4a9d660eeb3a8": "Gootkit C&C",
    "1b2bf7868b703311129104fcb9be4908a8f73879": "Gozi C&C",
    "1b2ceb32ec9c5527dd38ad5fdcbac485b1dc6afc": "Gozi C&C",
    "1b2fa07caa334d92fd41b75ae0976bf239b7eb6d": "DCRat C&C",
    "1b3f559bb10450a58b6d6b94250881bec3db1bb4": "Gootkit C&C",
    "1b3f952755d51433ae041d282ea04832cc6de62d": "Qadars C&C",
    "1b43bb82f2fe80e5cef4de6e4b317fff51ba83b7": "TorrrentLocker C&C",
    "1b55e71e5b641a7ba5ea0e99ee0e6f1980ec9ae3": "Malware C&C",
    "1b5669cbe7b2c6aebf8d308ef14ef27d3e8bc181": "AsyncRAT C&C",
    "1b61d02d820bd711087c850557a81bbfaf53246c": "Ostap C&C",
    "1b665ce21b592dd2bcc9951888dbc0f19f5bede3": "Dridex C&C",
    "1b69f368717d715d3f49a1673a0a6bcff72e6f2a": "AsyncRAT C&C",
    "1b72dde69011e499e5ecf401e4932bb4c5cb3f6e": "Dridex C&C",
    "1b823730663d26e723ffe308c19e7c68702a5724": "Quakbot C&C",
    "1b89f8c0744f50d49148afcf64e965e0bbb4f23f": "AsyncRAT C&C",
    "1ba278e48f1ab7ff017f3766f583f4642b38768c": "AsyncRAT C&C",
    "1bccac6e7f395c5a30c6ec51b8fa055a641a0d68": "Vawtrak MITM",
    "1bcf273e38e55a8d42a4f11ae01e2758a8934a17": "Dridex C&C",
    "1bd1fee41dac6fda021becc6ed67c26e7e7315ed": "Sliver C&C",
    "1bdc6317191e320b3c26e8f6320eab0c5dd26dc8": "AsyncRAT C&C",
    "1bf386bcc5b992f960f9a1401fc32beaa737978b": "CobaltStrike C&C",
    "1c0cd2c265feed1d7dad510295723d8bd8b29534": "AsyncRAT C&C",
    "1c186e8ed5a6f7ac91044eeabc1b3e597aa9adbc": "QuasarRAT C&C",
    "1c1a4fa6febde82d9b6391e0f54b776deac7b81c": "AsyncRAT C&C",
    "1c1c14190830bed5ba8af1245cf1cbd7313bbf3f": "Shylock C&C",
    "1c206fe2b1c382f22179c8f268d56c9716531e49": "KINS C&C",
    "1c317a7d728191ee04e40e6f11b24c4d8d14dfcf": "Malware C&C",
    "1c36e99a8f39bd2a9b2c3c9c9ff0b1bc6ca237c6": "BitRAT C&C",
    "1c3bc6eebb136c6cccafbd2f86f69210d3501ade": "KINS C&C",
    "1c3f5b11b68ada7a4cf526452a7fcd69bbc9f5e2": "AsyncRAT C&C",
    "1c47e75c2431e72d5444f11fc93784e757e15e96": "TorrentLocker C&C",
    "1c6015f3dd25f72b91788279e0166d6ead7d2c94": "RaccoonStealer C&C",
    "1c641e4a64a82788d5c309bb060b6c9b1cd1ad5e": "CobaltStrike C&C",
    "1c64a05353c25a90a1f67bafe7c0580f63fe85c6": "BitRAT C&C",
    "1c68db743335417ae984655b326d8ba3bb1e7b16": "Quakbot C&C",
    "1c6c184dd8b085590af57f02d0592fcdf9b7c0ac": "DCRat C&C",
    "1c8357ec564ea1f638165801224701f565f1d3d8": "Dridex C&C",
    "1c8bd95b67ad70abdde9f73787fc15f0881ea33f": "ZeuS C&C",
    "1c8f24d625931079c21d02c1a3f40fa7c9d95550": "AsyncRAT C&C",
    "1c9953976e24e6b7591253647441988a71b3aea9": "Dridex C&C",
    "1caba6026a5faaae62f1ca2c5b34d9ead5e15197": "AsyncRAT C&C",
    "1cacedb7c2515f12d8233e37c678a7225552e7b0": "Quakbot C&C",
    "1cb536f2bbf07c9c6d97b158aa81b2efecec0330": "TorrentLocker C&C",
    "1cb99cecea1516d9d6d591b81033dd353ae54125": "QNodeService C&C",
    "1cbb0d8ad6ad3977ce317140264fb7c5e7179e5f": "QuasarRAT C&C",
    "1cc10e046c2f0d1c1bb824a34658e6e7b9688bfc": "DCRat C&C",
    "1cc9679b0f86575fb584b2c2a3c2c3519708333f": "Gozi C&C",
    "1cce2d93403e748a7aa175511d897e2da6f50920": "Gozi C&C",
    "1ce2503b89ff0364cb659aefe1b469e194099d2c": "RaccoonStealer C&C",
    "1ceec6bdf4d587383d8c66ff606f84d8bf5190f9": "Quakbot C&C",
    "1cf9050f75c9310e5961fecda4202870d5e3ace7": "Malware C&C",
    "1d05c6fef14d2671d759a05b496464b831c650e8": "Gootkit C&C",
    "1d1b4f67f070df5cae8f39553978f0adb3abd0c0": "Gozi C&C",
    "1d24f76b652957735a93544173b1832343dd46b1": "AsyncRAT C&C",
    "1d3a5463a0940a8587d361b23b3bdb1f0570895f": "AsyncRAT C&C",
    "1d3c6df1be3a9c41f300f70ed354eca7a9ca5ceb": "AsyncRAT C&C",
    "1d4be8f125619bbe6ed8153579e878debf7369a4": "Dridex C&C",
    "1d515bdb771dad480db077e214ac7de947e593ff": "BazaLoader C&C",
    "1d5762f9dcf7273d104fdede9774de773090c5e4": "QuasarRAT C&C",
    "1d5e2f6283f47a5e2794b54841bd45125de89e77": "KINS C&C",
    "1d68f86401bb75017c01a9a553fff337c2a737c6": "ZeuS C&C",
    "1d6d1f2bfbcade17be4233c88dedd2ceb802602e": "Gootkit C&C",
    "1d8393b9fd9aa0b4c77eaabd53cb341db11ba41e": "TorrentLocker C&C",
    "1d8fc298b9b8325a64adfe2844fe45b05b60b6fc": "Gootkit C&C",
    "1d99bb4724514e2a87f5ddde8c81a803c504accf": "Chthonic C&C",
    "1d9c0e06ae5d470dd383c35c2f1ae0df4677f16e": "TA505 C&C",
    "1d9d3aa621b6cc838d31d0b2688fa04a0d030669": "Dridex C&C",
    "1d9d452d95886def36659e0401fd66f23f727754": "Dridex C&C",
    "1da50d2a6e5d411f5a57b0c97839506fa2f3d763": "AsyncRAT C&C",
    "1dadbb519b76371a157feffe8c2d146051eba3b6": "AsyncRAT C&C",
    "1dbed7df4f964d7ac83f2c6ec9efc6bec5be3c42": "AsyncRAT C&C",
    "1dc5c46e4dbe9dc6e204c108555e67c3dec912da": "ArkeiStealer C&C",
    "1dcf5d5599d439001b15e94e026d136bc05ecb15": "AsyncRAT C&C",
    "1df8c7cc29f06b376f353591d04f94a0c23bc5e3": "FindPOS C&C",
    "1e09601c154e7afedfa331ca3032578f77e260d5": "TorrentLocker C&C",
    "1e0a269dac505f8ac2fc13c2fb57d43be52b1728": "Dridex C&C",
    "1e0d5a4814e076940d602638385082d86b5678ec": "TorrentLocker C&C",
    "1e0f3d1442f9522b242515cb6968a10b08f4857c": "KINS C&C",
    "1e153b4cccda96fdcf7f415f4ca146181304408b": "BazaLoader C&C",
    "1e17a83863f2bf0449abe6f4b07b080ac7197c34": "QuasarRAT C&C",
    "1e24bd29837c1767d844ecd86558e8fb900874fe": "IcedID C&C",
    "1e3a369aa316162e31b77d6790370fa9913b8129": "Malware C&C",
    "1e3c13ce5b42cb60f461f50322274fbaac72ccf1": "IcedID C&C",
    "1e44c8d7647a41dfd9893a6d2a43a7372cc4f2e2": "BitRAT C&C",
    "1e5ea2749884d3aac805979eadd0e45f9848a95b": "Gootkit C&C",
    "1e5ec7faedc4b316c16ab33923b779c1030ce8c0": "Dridex C&C",
    "1e6553ad8bb984de0fa068e4d42c03742a4329c7": "TorrentLocker C&C",
    "1e6cc2869d485f1f648c96a3025b6b3ee7689b72": "AsyncRAT C&C",
    "1e740b1dabc0406d463592d09e999530bbfdb4ea": "Shylock C&C",
    "1e7a0c9003f332a7010fec127f79dc283ebec65c": "PandaZeuS C&C",
    "1e85b559a3c52d45c4b68282d10b21bba3a878a5": "Gozi C&C",
    "1e885708ec7994808f1d373d2c3ac34d2d27f5de": "Shylock C&C",
    "1e91a2722e50be38a46c42aff62f125069ba572f": "AsyncRAT C&C",
    "1e91b370248131946127bca8dc21322ad1000653": "Malware C&C",
    "1e91be5bb22234bd19cea3d2ec8b7ff1c19cbe37": "Quakbot C&C",
    "1e92bdb5f1e566418e9e30b6daa8da806394cc5e": "IcedID C&C",
    "1e9967d3e5dcbde8debd27a79222a093ef8e4e65": "Malware C&C",
    "1e9abbafe265e85949f155beee44c0ce893dbe8e": "CobaltStrike C&C",
    "1ea6cdbb0e9fe784f482b330ea1dabafde31c80f": "Dridex C&C",
    "1ea9f91da2978db63d857c0b5cffb9a8af689b5c": "BazaLoader C&C",
    "1ebab6eee5e7347ba07ae7e24ac97210bb461eea": "AsyncRAT C&C",
    "1ec4fde0fb1048ecaad1a8c39a848fbecaa7f3e0": "DCRat C&C",
    "1ee167be7ec215474f0057f2cd7bcbf667c548e3": "Dridex C&C",
    "1eef63b91afaadd5a510cfb67d3d1ea33af18c49": "Chthonic C&C",
    "1f02e525130415326196c9a3946558d662fe8cbd": "KINS C&C",
    "1f0428ee84bacae5bda953dbe1c88946afe08346": "Malware C&C",
    "1f05947c827dc679a17e02d82876e30b79ab343d": "Rhadamanthys C&C",
    "1f0eddff3174fe3ebcfa4c625fe9f619a58e282e": "Vawtrak C&C",
    "1f19e7fa82edceb0dff122b0ff43b80e736a2ad2": "Gozi C&C",
    "1f1b5b22785b418905047f62dc392f657b49761f": "Gozi C&C",
    "1f1d4a59b9d720d69ddfcd65b90d51e52366a2e3": "PandaZeuS C&C",
    "1f1fc1a9235b9b514f00e295902548137d5c01c9": "QNodeService C&C",
    "1f2093d33c6aaa0f1e9365991f37cc27623e2cf7": "FindPOS C&C",
    "1f2a30efc5fd503aa7ef1f0f8ef4139cc77fb48c": "Dridex C&C",
    "1f2e055d51ee10fb8d65dc280fbfc8d4615efa16": "BitRAT C&C",
    "1f3fe69029e80d0670de01552e860a2db9b37684": "KINS C&C",
    "1f406eed3f646a1a30cfe95667e1dfa3884763e9": "DanaBot C&C",
    "1f561dd91d46b24f143c852d64ffc543916c86d1": "AsyncRAT C&C",
    "1f628f0b2cd0ec19289dba30b30d59132fdf1d18": "OrcusRAT C&C",
    "1f7341b052d1f27b19763cd0c8265af8a13105d2": "TorrentLocker C&C",
    "1f8415dc09695fa6723d2ced3350f69fbd4c6ed8": "AsyncRAT C&C",
    "1fa2ee1c7752378de3661c2daa6c1754749bb313": "Dridex C&C",
    "1facb1de1a463de4b6d5213c7ccd62835d2b6a36": "TA505 C&C",
    "1fb76339b075198c34d2ee2c96fb55d14df218ba": "TorrentLocker C&C",
    "1fbab9e8dec5233afb480ea9e3ace7bec1dc98bf": "TrickBot C&C",
    "1fcac1c039dd9dd58a4b933caa034a7a91391700": "Dridex C&C",
    "1fcadc6537b365be3ae9fbfb7d60098b9e2de3d2": "Malware C&C",
    "1fd08b6dc564cb355c79fa0519290dad5f23238d": "Dridex C&C",
    "1fd6266345a9d7c82378bd46c0895a85883112d1": "AsyncRAT C&C",
    "1fdca43040731e80d0abb11d0e2aae696e95cd6a": "AsyncRAT C&C",
    "1ff61565f9df63c853015bb23058186b6c60a221": "Dridex C&C",
    "1ffbbee095a80d292d5c833f2def8458571121db": "OrcusRAT C&C",
    "1ffd8b1b0e1caef876c9101f8000651bc569ad5a": "AsyncRAT C&C",
    "200239a80dd96c66741e3033dbe243a5095e3979": "Gozi C&C",
    "2009d392b9dcfae2cccd842c9fdad56b64737b80": "Quakbot C&C",
    "200af7afa0a93a12e877199a0780b9ee5f5c99fe": "BitRAT C&C",
    "200de49d4e0940cc38c9eaae24d5652c4043c5f8": "Dridex C&C",
    "20186ce250bbdedd676c458e61ae9c245b1bff0c": "Dridex C&C",
    "202f6d7d9acbc1936c72d8b76a25ac01a018331a": "BitRAT C&C",
    "20373e4d4d11ba0e839378737ee9fc49cb164bbd": "ServHelper C&C",
    "204259238edf443722a594d3bb06b64a71f0207c": "Quakbot C&C",
    "2042da83877890fc69a5851a9ca66e234ffd7412": "TrickBot C&C",
    "204664bb3239063463ef1797d111a01f90ead09c": "FindPOS C&C",
    "205970cfe065bbc3d031ded9f7291c0f5e169f94": "TorrentLocker C&C",
    "205c00271c9c2dcedc37159bc44425636c837d89": "Dridex C&C",
    "205c56cc3703f8630564936991c368cafd9fb216": "CobaltStrike C&C",
    "2075622156efe61490388aaa95e56286d5abc42a": "Malware C&C",
    "207a209e4b7a5651405af780edc2406eb0bfb658": "Quakbot C&C",
    "207a31fb22bde2b236d36bd4647622064efcdd6a": "TrickBot C&C",
    "207c6e0b8d9471ec2e3d520fa5011139224d009d": "Dridex C&C",
    "208bde39ff57b84f63ff640643ae17e7a0c8e304": "AsyncRAT C&C",
    "209a837a368bbea883bcb8d5798c24748c41b8e4": "ZeuS C&C",
    "20a061392e5a4d0b0e9b0273e18474aa25e15b59": "Dridex C&C",
    "20d66b71749f52092fb9e2afeaa2b9cce8a57520": "Gozi C&C",
    "20d96db327cfbb1a03370d1261b2d4cdf0e77bc0": "QuasarRAT C&C",
    "20e8c5461fd7bf1b8c38aa8e2e4bda0ee1effb42": "AsyncRAT C&C",
    "20ea6a62a371fce9393309e6f3c727e0b8be250d": "AsyncRAT C&C",
    "20ec8ad208df3ad4eda29e329d0f9f0bfd1f5479": "Malware C&C",
    "20f577ce759b61da9151a143ce0297ae44d46b23": "ZLoader C&C",
    "20f9b306c1840aecbab917e34d6cdca1d778730f": "Gootkit C&C",
    "20fd51ec42d884dbe27366bbbc01727b9b2fa2c8": "DCRat C&C",
    "20ffea17d34c832f7e773a6a037cfc5900211a2a": "PandaZeuS C&C",
    "21077c31aa388b81c616b9761f503b7e6d8a0222": "AsyncRAT C&C",
    "2107c1e36090a546ee56c4d1a842e5e9c60ce221": "Quakbot C&C",
    "21109fc470c30a87514a4120d970f3062ab74728": "BitRAT C&C",
    "211a3b7693718d157ecedf07584edd99c69fc3e2": "AsyncRAT C&C",
    "211e0b2e2b5062d36d57000f0068b39b3e6fba13": "Dridex C&C",
    "2126965507ebde325e1bc42ca14d3d1f681b96eb": "Dridex C&C",
    "212c93da8961b88fa935582c5836bad8063d9624": "Quakbot C&C",
    "212e665ea0decef61aa4dedd4d945ff0c4953a91": "AsyncRAT C&C",
    "2134c5df177277f2a2bec37eb88309c54b2e69e1": "QuasarRAT C&C",
    "213a72f525f83c88f15ce2646af341bcb40692be": "AsyncRAT C&C",
    "2145dfa39e0e50702aee09aea1b68a9a1e7555c3": "Ostap C&C",
    "2156dca1e39a76ffb03189b3721bf2af5bd50fe4": "TA505 C&C",
    "215a0886f1b3d5fb663a19c1f21017486584d034": "PandaZeuS C&C",
    "216e5db3539f0ed97fc438a55b0a428e2b223cc1": "Vidar C&C",
    "2170bc4d61093774686b8ab06c19744615d86e8a": "OrcusRAT C&C",
    "21780e91024a45a1b8067af4c0903d657c30d922": "ServHelper C&C",
    "2178ba5544742fb6df5eca2bc85e52be4d90f065": "PureLogStealer C&C",
    "2191afabafd50d4181c936d9486b855f30e1dc57": "QuasarRAT C&C",
    "2193fd033d695c69b0e42d190843cde97dd80507": "Shylock C&C",
    "21967736369cf93deaa3f18cc4de6647e57a0931": "TorrentLocker C&C",
    "21a044ee092ab5955dd3353c7d19e5bc88a8811c": "DCRat C&C",
    "21a1c4b97d84ecd3eb6950c1b9f03135719e5dc0": "Gootkit C&C",
    "21a9a89089af313e5e35c9a330d63f0b0bbbd4fb": "VenomRAT C&C",
    "21ac11e8f3cfcc86cf79d789e7451bdf95b5140a": "TorrentLocker C&C",
    "21b3c901e7f01ed6590e198ad3512cb53105f018": "IcedID C&C",
    "21bc5cb3661d433666b0b968443061561b8218f8": "Dridex C&C",
    "21c603fd0d9a1c1173fe04f03a80e67bb97a3a98": "QNodeService C&C",
    "21c6db5ab5fb416ae989a08bf955f715b60b010d": "QuasarRAT C&C",
    "21d01a5a57d6b77b759095aa9e38e7aaf0db9c04": "AsyncRAT C&C",
    "21f0eb5d4b32bab8e2283e78365f268047e81833": "AsyncRAT C&C",
    "221d035e441c0ee3595e24d3e4debdca878d0bfb": "Adwind C&C",
    "221f4b123d3b19e62a94fcf510579535fd91fd4f": "OrcusRAT C&C",
    "221f77dd0ecc627baa6cf2cd6dd7dd87f16c8125": "AsyncRAT C&C",
    "223225b636c3411f9e7db0eb5d5d13284f529b23": "AsyncRAT C&C",
    "22328238ec374821383f0e3e59cf4857c2914e36": "TorrentLocker C&C",
    "2238b9d3ed9c988cb12d3ef38c0fb973742d5a3d": "AsyncRAT C&C",
    "223a9ad47544dc45698ad6c9b4261f58aaf1b47e": "AsyncRAT C&C",
    "223f3276bdd796070e22a30a0a18c08a40d7c7b8": "AsyncRAT C&C",
    "224f8cdfa3b33f4396d3989e5150bb366a24156a": "DCRat C&C",
    "2259088cbffb54476e7eac7261e81c191e460837": "BitRAT C&C",
    "2265744f5147da609828afcd23d058afd43a6823": "BitRAT C&C",
    "226a7600dd8a09c2e59dc50c42a53b1547c31d31": "AsyncRAT C&C",
    "226c62e4b217d48fe37376e977faf2a01718bd14": "Dridex C&C",
    "2279509fe83c09195fbdd5120949701eb5224371": "AsyncRAT C&C",
    "22812ad387632e1b4d1ccf5e911686fdc5aa265f": "Ostap C&C",
    "22835d4711260cfccf644e120f007222ca02896a": "Dridex C&C",
    "229918d65d7bb2186ecfb9e86a25c4655aa91bda": "Gootkit C&C",
    "229980d62053470eaacd873ec6c503ba544e03a5": "TorrentLocker C&C",
    "229b730d6aab35540a31dd85e303be2153481a30": "ZLoader C&C",
    "229d13a49dfae48ad6d433226de26020f2b8d9e5": "IcedID C&C",
    "22a701745fdfa2080e44c9f339a911f97ad17bd0": "OrcusRAT C&C",
    "22aa5aefe569e7176ee1dfb166db45fab4cc7b35": "Dridex C&C",
    "22c42716cd8f181b90df9d1b991a88dbff056849": "Vidar C&C",
    "22c5ece6639c9ced35d6a2d45d7dc18f9d4f5256": "TrickBot C&C",
    "22cb55b88aeeec8b0842d30f8e1377b3cce3322c": "Gozi C&C",
    "22da4d7ca081b110b6c2a183a3205967337e9e86": "Quakbot C&C",
    "22f54e90fab6d8ee7f6d09384946737751900c4d": "PandaZeuS C&C",
    "230f98673b0956f8652bab0220a010f83d381f4c": "AsyncRAT C&C",
    "23182c4e27c1fb9a09e222c4c94646537d10b3d4": "AsyncRAT C&C",
    "2318868881bd92674e8685b4bbc25f2ea2dbef55": "AsyncRAT C&C",
    "231aba69dc9ef4b0c61c9fc03eef37f6e78d8b07": "Dridex C&C",
    "2329a359e76f51d38d130697a26322cc2cfc9d17": "Gootkit C&C",
    "23469d6212b566ad905c3e556543beccd420f610": "AsyncRAT C&C",
    "2351fc811f3bb277d91702e8581991c92f6c036c": "Malware C&C",
    "235b673cf750b75b971b45c867f1f6aa23c584ac": "Vawtrak C&C",
    "237c75e15031a9ee6426d936c1f07641fa8bfe83": "Quakbot C&C",
    "238d8b89fb1d48577fe72d4bfc6abff83483358b": "AZORult C&C",
    "238e3f7e72fc2784f5c7b3dc5760f8f02bb177c4": "ServHelper C&C",
    "23917e4c4d0a6bb7dd3351456f12948df745bce4": "AsyncRAT C&C",
    "2392b4196b28baeac7944374b1696d55631877e7": "TinyNuke C&C",
    "2393122267ee7388b92ee1eecc649d671472a5c5": "AsyncRAT C&C",
    "2396cf6f9d9f75f914861b50446f38104d189f74": "Dridex C&C",
    "23c4717f94738482d466ab8c33dda128ef6a6c8c": "QuasarRAT C&C",
    "23e79082bb21e20deaf53863da6459adf04c0f33": "QuasarRAT C&C",
    "23eabda9c67f0a0dee3a12fdcef1fde584a00f44": "Dridex C&C",
    "23ebde2e7481c21583cd6f0dc96761255587aee8": "BitRAT C&C",
    "23ef5839e14148d0754b27a374cffc832f5ae473": "Quakbot C&C",
    "23f6edd8ef8cdec8e179175db7fca47b98c9c16d": "Malware C&C",
    "2407aa417a9f0bf5641fbd04bb9ecb479ba84626": "RaccoonStealer C&C",
    "2407f51aa1f746914c8119ac30b64be33ff5f323": "DCRat C&C",
    "2409e48693a4ca3af70dd944d8773327e6a8516c": "Dridex C&C",
    "2410a7813a2d22835c72d3062ca89ab2ebd2ec48": "Dridex C&C",
    "2417b58cccc92098fd99dc0c41549f32410bf562": "Malware C&C",
    "24200d6be5dc2b91cda6e2fecbbdedbbd51b8f9c": "TrickBot C&C",
    "242726515b5501f1df9e2dbd8b3bdf4ce2fed3a9": "Gozi C&C",
    "242eed6d11b9c07ec9103b63758595b8c21affd3": "PandaZeuS C&C",
    "24337a9f03cf23b96452b19c0d1f2e105eeaf3f2": "Dridex C&C",
    "243a25a11fe06205831a3f6516e21c3f4f33801f": "AZORult C&C",
    "243c88c0ecb2da0f201e5e123908035af055db34": "ServHelper C&C",
    "24429c6fecf2c925b996ab0abbdb7e2c92be0c9c": "KINS C&C",
    "245a5430eeb796494c4408caccce06ff6baaded6": "BitRAT C&C",
    "2461a9767f1a8b5b0c13702f633b1dea59eb805b": "IcedID C&C",
    "2467d18c4d1a749b0e0c03177b225966000aced9": "Dridex C&C",
    "24b621824151585b035905519ae7e2fefc18c036": "Malware distribution",
    "24bbbe147a1a2941f70a4f6e60ea87760fd06f06": "Gozi C&C",
    "24c109a93c820c3812f0be525e508830a7bc811d": "Malware C&C",
    "24c12267a4b4a91820b1cf90ba7a80115757f929": "AsyncRAT C&C",
    "24c3bbe542a92106a0e731231711c3871a07c6a6": "Dridex C&C",
    "24cf04ddda2982e78746251fc4b6b7e61b64c681": "AsyncRAT C&C",
    "24d6c9afc6c8991f63f842cf65354d46149e01fa": "ZLoader C&C",
    "24eb69f3d1b94e496b15195433640ed6991bc05a": "PandaZeuS C&C",
    "250330b539ae6c712f9e7d07f95193e590c08bc2": "Quakbot C&C",
    "25121a7e32e29ea2ea4e293a45f1c3aa4ed82cfa": "KINS C&C",
    "2513f1d9b84f88d646f485391cd722f323295c93": "TrickBot C&C",
    "251a9df415e2a81e93979453ef1a8874f75d70fc": "TrickBot C&C",
    "251be2d816494466bb6a23bc3df9bc73bdeceab0": "Quakbot C&C",
    "252102a8dbbf30c6eb057cdf5c76a97ee574a999": "PandaZeuS C&C",
    "25260cf7dc0c50679463e0a29a4df5b90f829fe8": "BitRAT C&C",
    "25407e0829ea688cc753b0403793b43a72266a22": "AsyncRAT C&C",
    "2545223931258e62619e8f8f83f713ec861d47be": "Gozi C&C",
    "255f664c2f3a8e8e216d9659b3e730657d853b14": "AsyncRAT C&C",
    "2560934369b6b086061e81fe5e2f24eac1410079": "AsyncRAT C&C",
    "2566b0bffa8eb0c2496c841c56c82567058d74b4": "AsyncRAT C&C",
    "2569e55f5f42541942dacd2016db43aa39187d1e": "Gozi C&C",
    "25745ac1e225f656827d67adfa0b562fb77e45ef": "Malware C&C",
    "259500493b3d962686644a9a0529b1c1a060cbcc": "Nexuslogger C&C",
    "25952b83aadce99ac0f06d8674ad0b836354c407": "BitRAT C&C",
    "25aa5897a07c71b77f6492d67de10407c5ed19f8": "AsyncRAT C&C",
    "25ab5cec7ad98edf3061f7f9f6727ba4fb810b90": "Malware C&C",
    "25bc4a243608ef3d0210092fe29bd27e0337c165": "AsyncRAT C&C",
    "25c3396d47d5df12faafdd06687e7e69f8fc6fe8": "KINS C&C",
    "25c40ca83f45f32abfad18ca50a7ac14d4b02af8": "Quakbot C&C",
    "25cbde5ded2a6b4327062e8a645ca5029e7cb79d": "FindPOS C&C",
    "25d0ed698d994ea8d9b9110e300c1e1f9259be12": "Quakbot C&C",
    "25d2222be72191de03ccda98c13b1bb7a6cf2810": "Dridex C&C",
    "25da7d0e93d898cfa0965a118fa6d7ec7169a122": "AsyncRAT C&C",
    "25e03f9570a020b833d42041f5155634278bd9ca": "ZLoader C&C",
    "25e578f1e094e3a9b020cda1dda6f96212c52334": "AsyncRAT C&C",
    "25f6475d1a6dc6cc5ec253e064e8b10df6fb5752": "BazaLoader C&C",
    "25fd0ba7660d05524745d6dcad0cbd7d8bbcb169": "Quakbot C&C",
    "25ff662d8d6f25f15c4cb69d75d4339ba02d2539": "QNodeService C&C",
    "260035eb9720d879951be4105915df6329c9c0e3": "Quakbot C&C",
    "261087ae8029e6846df0b24617a5a04389b3ba45": "AsyncRAT C&C",
    "26173dc19b47141e7282dfe512a2f02219b572bf": "AsyncRAT C&C",
    "2630758f206fa94892ffbd10940c86a886ac1814": "Gozi C&C",
    "263a0a4e673140d079eebfa2c88d91ec3c8ddfc6": "Malware C&C",
    "263e2563abcda99fdb65e15eea4712f9de031178": "AsyncRAT C&C",
    "2661bcb4bf738bee645bc9881b0d48a66f778167": "AsyncRAT C&C",
    "2662e232d7da6ef5213e362275a05fc236ad9e95": "Dridex C&C",
    "2680888450c9f79cf7d3c6ea9f2e4af98f96cfef": "OrcusRAT C&C",
    "26b9b5664416b56e8f6171783be81cafb411b8e3": "KINS C&C",
    "26dd0e9d9867934f75b25e25dd02881995b4be42": "Quakbot C&C",
    "26e130af6c109cb7ed1d4111119c83e8357e8f9c": "TrickBot C&C",
    "26e7eae8092ef626153db8e755370e1f0539801c": "AsyncRAT C&C",
    "26ee21afcf20567f80d6d2f835672c9c5783f1bf": "Dridex C&C",
    "26f065749abc568df0a713aac4507f9a4048f0e4": "OrcusRAT C&C",
    "26f2615d18e3900b1a72b41ea55b8c20ef7bda66": "TorrentLocker C&C",
    "26fc5725d66c4ba767ad0765bbb94966672a13ee": "Qadars C&C",
    "26fe5459021f27ee1112ac413998184532a9877e": "DCRat C&C",
    "2713a6c1faa14572df4cc9493632dfd2e40bb8d3": "BazaLoader C&C",
    "271e87985f3d6be39e94a125e1766d996f3f1e6c": "Gozi C&C",
    "27240e974abb90570d763ad531768d35545a36fd": "Dridex C&C",
    "273948230a9d97231ec56fd82631167dc81a8e37": "BitRAT C&C",
    "273b0fab7efde36525632e74989b3ea5383f3e05": "PandaZeuS C&C",
    "274c4cb45396a47039f9292df2a754dc52225502": "QuasarRAT C&C",
    "274e6b65834c29ac9cf760e435d2744ecbf25736": "Gozi C&C",
    "2758304126acd2f8aecb146623f9f51da321e94d": "DCRat C&C",
    "2780a59011b8db11a49e4efb8a5a7392d47bda21": "AsyncRAT C&C",
    "2780ffb6dba7b56df6c0e28a0ee7c27f840fba48": "Malware C&C",
    "278243f6e9f124655036adf3af542ed563f2d59d": "QuasarRAT C&C",
    "2786a5a6a662fc449b2558811da641780d635113": "AsyncRAT C&C",
    "27879436526183bf047b7fb99e64f5a349093c61": "Gozi C&C",
    "278a38972a62a8c26cf017ab61ae747417a5e687": "Malware C&C",
    "27947b1c9826ea3cbfc3bec8b6031c9e790dc9da": "OrcusRAT C&C",
    "2797597a7bc6b3b45f9e5ec6de4710537126fc03": "Quakbot C&C",
    "279c807de6cb27726d4cc57fa47cac9450b9c69e": "Shylock C&C",
    "279da6bba24d23db0af675e431225cd596f185bb": "AsyncRAT C&C",
    "27a5bad421fb64b906ba079baddd0e5c6eb7936f": "TrickBot C&C",
    "27ab0c2a759d6c8182c7eca9a2c53f3bfc0854db": "BazaLoader C&C",
    "27aeee3105afb6fd5ada060deafa61c797bf4a69": "ServHelper C&C",
    "27b0deeac23c90eafaa59a410de5e11f3e6c4f17": "Gozi C&C",
    "27b9f5b79209d95f1e70a789dcfba68231eac10e": "KINS C&C",
    "27bb8d2c446dfcfee4654079ef8f00b0afdbc333": "Quakbot C&C",
    "27c05cab2948ea9ceca33a98296a7484cd1ba830": "BitRAT C&C",
    "27c2d8e9f11c1a83af9e5e01c8476b1e832ab4c8": "AsyncRAT C&C",
    "27c9b12108a76adb3e9e5c5ffbe02060494437f4": "AsyncRAT C&C",
    "27daefabb995741355963370953a6aac97ef015d": "AsyncRAT C&C",
    "27e0f88c5ec5c41e6a030e704cd04fb461c871d0": "BitRAT C&C",
    "27f3c83869dbfc96b1aad8ae07797de6dc3eaede": "BitRAT C&C",
    "27fc1e59181f38788c4987086c3338c1af107820": "KINS C&C",
    "280106f5028c00bf9fa86e86a1086a7c12f8243a": "Rhadamanthys C&C",
    "28096defde6bfa8e87c9077bb83c4f2c3e6f3ded": "AsyncRAT C&C",
    "2816278e8bbecf9da5d2f4877b6749d43b196c95": "Quakbot C&C",
    "2818d4135cc5163d2ceadfa64248a0c455f7a4f7": "AsyncRAT C&C",
    "282183e64c464841edc424163e36456a489213fe": "Gozi C&C",
    "2827c410ec754e242c3c8b8feeb9bdc486812a3b": "Malware C&C",
    "2832ce5b1e60d77daffd963b6f6fcc4fc2f9a39c": "AsyncRAT C&C",
    "2842a6999e167f4690bd28912ff8f727514ff109": "AsyncRAT C&C",
    "28488d788ea4783b04bfecc247ad544023f81e84": "Quakbot C&C",
    "2849e847e0d5ba85bf59182a92e53541d55fa8dc": "KINS C&C",
    "284f595fa57372c72d2e1823f5bf30ee8cf9fc2c": "DCRat C&C",
    "28514bd40bfd607c85926fd330b7ceb48033fe93": "AsyncRAT C&C",
    "28579be67cf58041a22fb8b82c8c3118a67d70f8": "BazaLoader C&C",
    "285946b15d55b97c25eecffa22bc2e4247ab405d": "Dridex C&C",
    "28643fd75c7bc45f8d3374e15f7a49e33d5f0ca8": "DCRat C&C",
    "286e90609dcca58a00fce4eecfb068bd4682f1cc": "TrickBot C&C",
    "28864133d3c5331f2282d866e3d5ff0c182b1bad": "PandaZeuS C&C",
    "288ced57369ac720fc97db30eedb250715b1a781": "IcedID C&C",
    "2891714bf49e145099faff05fc1647fdba906ff1": "BazaLoader C&C",
    "289499bec90a5c76774bdc4eaa6aa6ab3d12eef7": "Gozi C&C",
    "28b511d09f7a0f654d220b9b049f92ab3bb513fa": "Quakbot C&C",
    "28ceade18497aea4122df1de38706e80536891b6": "QuasarRAT C&C",
    "28d41a178f3bb456355759c2f2fe9728d1326d89": "KINS C&C",
    "28e271dc3d86eb530e78d6c05da2303a491698ca": "PandaZeuS C&C",
    "28fe3777df7a27bbb2aaac03d44e83a08c26b4d7": "AsyncRAT C&C",
    "290cde5d039e78feb18af0c212fa019247036702": "AsyncRAT C&C",
    "291593ff4d75ea47cf97c53473e89e7203816b27": "AsyncRAT C&C",
    "29293a3f0dfd2f1ff29c5d6ad0f6891ba0c3bf58": "KINS C&C",
    "29489e12a9074a70024350cbd9d0d59445f9a655": "Gootkit C&C",
    "294cbe3d194320e78d33ba84787d35ba7757f911": "QuasarRAT C&C",
    "294f53c01b598d6f3ee963e9c01f3db9861bf7bc": "CryptoWall C&C",
    "294f8c2d54a6d42887ea5ba29ab0b0df3bd7a08e": "DCRat C&C",
    "2957ca089cc5412901d16f14c983f62417c72710": "BuerLoader C&C",
    "29636440aae6579e3a178fe27f15e5133e626dbc": "IcedID C&C",
    "29646969f68f416db8ae8ca413d4d2900ae5e814": "Trickbot C&C",
    "29699b849f963cb7febde159087eb1d71841aef0": "Malware C&C",
    "296ebae2d8577f078617ad01d6aaa4c0dcb9a55a": "TorrentLocker C&C",
    "2973494a8c677e0e7b237b8e1a92fd73db3f9394": "Dridex C&C",
    "2973534ed68921f23242b03583e1ffade1f2039f": "TorrentLocker C&C",
    "2978e97bcc2d507d04d64df93155fcf378a2295d": "Dridex C&C",
    "2991b587994bcffa5695214345bd8c8245d7786c": "TorrentLocker C&C",
    "2999b5922e988590853f1ad83c08322e7bb5b2b0": "AsyncRAT C&C",
    "29af53f22280549ffbfff5dc41d9d81e4a26221b": "AsyncRAT C&C",
    "29c8478a7c47926146955982de6bb2f64361b82d": "DanaBot C&C",
    "29f122fc3983d5ae144e32481e0880631eedaeab": "AsyncRAT C&C",
    "29f1a0d5c837694d3a7761a5749a86b9217baf15": "AsyncRAT C&C",
    "2a0a86070be32a4bd2243d5475354b7d652fde3c": "Dridex C&C",
    "2a1b79495761dc5bb0cc2010060c5bd7a47f1129": "Dridex C&C",
    "2a1d3b3fb321292413b3894d086addf3d684aeca": "AsyncRAT C&C",
    "2a21fd57c3aa865ac9cfa6fe6a0843d0072aa18b": "Dridex C&C",
    "2a2b4ba8e36765e6eef4461521db6d7a679a8409": "OrcusRAT C&C",
    "2a5d840ba99228082bf70aa8ae416ffd4f868051": "ZeuS C&C",
    "2a5db016a7078bba81fba85dac9751f21f9340bd": "Shylock C&C",
    "2a7072bd26a5adbece9aa46e62c23aa0c099419a": "ServHelper C&C",
    "2a9de62e24070e3f1ba418dc3a7994c63cc3dd8e": "IcedID C&C",
    "2aa1c1bfcc8d4b6a04f20f80a89b6419eacfc50a": "Dridex C&C",
    "2acf28c2200b63680549396a732921ca97768c21": "PandaZeuS C&C",
    "2adc56200afc05574c8ac4c10394cb319f84d453": "ZLoader C&C",
    "2ae65244aa20d992d774d4af37016543e7ff460c": "TorrentLocker C&C",
    "2aea630958d53871e9b20430f87f555bc54c763e": "Quakbot C&C",
    "2afda37273f3bcb08763c36525bfeef9276d7bee": "Adwind C&C",
    "2b0084c889c017a7074a09b5bb6e58e4d750dde7": "TorrentLocker C&C",
    "2b06b538ec425b543ce2bd07701780fb1868218e": "Adwind C&C",
    "2b083b952d9a7a22d11578cdd6ad37a496ea2a06": "TrickBot C&C",
    "2b0a76178cbe81a7c17627fd3615da090c747892": "Dridex C&C",
    "2b1402a17537d45dab39cfc124173d77650a772c": "KINS C&C",
    "2b21b18207a4fd80b4a5a628d664e52524f441bb": "AsyncRAT C&C",
    "2b2968f04bb6556ec291b8443c2304754c9ad7f1": "Quakbot C&C",
    "2b447b896117f28cba936b5602170c78cf9c3b77": "Dridex C&C",
    "2b52fb881d5795906e07ede273e4452e7f355755": "Quakbot C&C",
    "2b60bf5e1f05a4c844dd393571d2959e56eb6cac": "TrickBot C&C",
    "2b83fa06ef38adcf63a3c89ff0d595375847ab4f": "FindPOS C&C",
    "2b971d445c7f212574717c7f8c3c6c28fba7a18a": "QNodeService C&C",
    "2b9b0df90371bc7a0c919233bf724b2a6b82aeae": "CobaltStrike C&C",
    "2bb362e2913b9e2c0edbcbdbddaaf2331233a991": "Dridex C&C",
    "2bb8ba239c8693cb0f48d885f212ebc300a8eb56": "TorrentLocker C&C",
    "2bbf9389f2b625b46d747755c9e1f0c331fa377c": "TorrentLocker C&C",
    "2bc0c635dda7e20d09c481bb27da4e87f6a6b9a7": "AsyncRAT C&C",
    "2bedff8e519fe40b3377d7a2854621f038e16093": "Dridex C&C",
    "2bf975f9c1efc6e2837cc59e0b59f409bfee6e9b": "Gozi C&C",
    "2c0e54a7775195744ba8b29572285671abdd2e05": "AsyncRAT C&C",
    "2c1121e67f969c0bcfc36ed31b9640ca93e812f0": "AsyncRAT C&C",
    "2c1312485a22b1d547835742b690ee62b0668fc6": "AsyncRAT C&C",
    "2c1495470f7d4537f2c76d5016b36f3fd0706fad": "QNodeService C&C",
    "2c347127a733330951af90bd391d4cb25cf68620": "Gozi C&C",
    "2c3932737f3ee82fa41923172de816773a898715": "DCRat C&C",
    "2c4414fafdebe3eac6f62c8c7758f6203bcb03ee": "AsyncRAT C&C",
    "2c4eb1f15a4a4100206726b5c8f9e2b8d372ac06": "KINS C&C",
    "2c542e32c6cba4b499d142f957519706ac533a1f": "Gootkit C&C",
    "2c5b140483cacc2f0539eb866574eef1182bfe13": "VMZeuS C&C",
    "2c5bdffc535cb08b23bcff4ecd5dd9ecb769badf": "RaccoonStealer C&C",
    "2c8a9be6ded4eaf864bd5c1b06de0dc337baca84": "AsyncRAT C&C",
    "2c8e11bb12626d6b02a7d3d913fba24adc2e4ca3": "QuasarRAT C&C",
    "2c8ed10a087bd1809646482b07435b82297993f0": "Vawtrak C&C",
    "2c9b72ae66ebd14cbf558c8ab0d3837a44409b98": "IcedID C&C",
    "2ca6e7b0ef8268260a132ae76b738e90d306ef19": "DCRat C&C",
    "2ca9488a77c862710839826dffacce81aaea2cb2": "IcedID C&C",
    "2cc3ef4ac0869da85546e2f487ab722f91d83c0f": "Gozi C&C",
    "2cd15e80906f0407e3a8a169404c514a14c1f4d5": "AsyncRAT C&C",
    "2cdda53904712fa2fd15c34826cd05f27c94f967": "Shifu C&C",
    "2ce4b50326d29f72ded5a42cd1d05580deb22999": "AsyncRAT C&C",
    "2cf80fa78c7ab8031d801a8af329c48c99bf79f5": "IcedID C&C",
    "2d170bbecfaacfd85ca11a6107e54f94062c774a": "Malware C&C",
    "2d1a3994d3c8e5c6071e7048589030f3e389ddc7": "AsyncRAT C&C",
    "2d2bf324d7f352d9e6d49bb0d96e05196df793cc": "Dridex C&C",
    "2d2e5f4d60474c9e3fa684ce3d3ddd3fbe36a351": "Gozi C&C",
    "2d3aff96a0a8dc98015de81e2dcd8b7c9b92d376": "Gozi C&C",
    "2d410c4cb749343c0d322c2a074b3b28d933c3fc": "BuerLoader C&C",
    "2d51179eb55ccc48cfc7164e3a936904a40d7b88": "RM3 C&C",
    "2d71c5c274749e83894988e84f576b802f57418b": "AsyncRAT C&C",
    "2d8015f6f76cfca56a46e70cd511d2fe16b5ee57": "AsyncRAT C&C",
    "2d8743d8e62c4f68d5c486a0031220d0bcca3e11": "CobaltStrike C&C",
    "2d9fb5761f3c2a369e1b65250b3b6230d91b8547": "CobaltStrike C&C",
    "2db064e4cbe1bc5d4c8f34369f408c09856ca32e": "AsyncRAT C&C",
    "2dbbeb3fabe1dee0d1bb934f442c3cb2e8821a9f": "IcedID C&C",
    "2ddc4c0df24ee954dffe62d79ba4ff5f986bc691": "Malware C&C",
    "2de65adb4038cc50d726bc98e5cb348ebddbb04d": "Metasploit C&C",
    "2de7a61d409e5f0feccfd58652ed1d5cf399e70c": "PhoenixRAT C&C",
    "2de8c19900140ce5ee9e82447d008e69cbdc8f8e": "TorrentLocker C&C",
    "2dee941df3dd2f65481ff4618dcd152f986afab6": "Dridex C&C",
    "2df009d991ab4654d2532ff51c0767539309faf5": "DCRat C&C",
    "2e00b16db09e78007248d54383b97ea9ef3b54a4": "Quakbot C&C",
    "2e086072007899177d4aab3887a9f430f9c31867": "ConnectWise C&C",
    "2e096eb55c49ac9070fc2038c3c02a626f472fdb": "KINS C&C",
    "2e140f074bffade9c9207e3c60d27b2716fe6a63": "Shylock C&C",
    "2e1674f9284dda60a0b48354a1551794c653b8a8": "TorrentLocker C&C",
    "2e3519b7cb61a3cd6167f727df993f68311085ea": "DCRat C&C",
    "2e37721f752b4ddfd80ab91b04f2638a140460a7": "QuasarRAT C&C",
    "2e4a9128ea31dd8c6a789f47757847ba89cad228": "Dridex C&C",
    "2e55564a1b31a992932e21880086cca5df72916b": "Dridex C&C",
    "2e725d98fb644a05120065bd627e947c45ad1d43": "AsyncRAT C&C",
    "2e796e28e2aadd7f657cdbc853226ff2f84980e4": "Dridex C&C",
    "2e8300eb0831fa63a3fdbd4f2aa98cf6c99c23e9": "Dridex C&C",
    "2e8a4b1b2abe35177d343d1c81dd2522c16bb48b": "Malware C&C",
    "2e8e3e0d51c3ddaef3a0912724d9ce837502612f": "TorrentLocker C&C",
    "2e97745aa304af85b47eea3df6fa84e015c4e160": "TrickBot C&C",
    "2e9e5d5ec3befbda86a32131d059d87ab5e37e8d": "Adwind C&C",
    "2e9f0fc97db1fa25006975b8aff004c55b9ab32e": "AsyncRAT C&C",
    "2ea58d6d8798ddfc22e63b648518eee10cc93d7b": "AsyncRAT C&C",
    "2eabb53c05fd869724103468e4626ff62bd5ccdf": "ZLoader C&C",
    "2eb8fd06a96ed0b2278a200897c9b4c11b8ec20f": "AsyncRAT C&C",
    "2ecb96972aff84a86537aa3d75c258e300f4d767": "TorrentLocker C&C",
    "2ed070ceaa3202932b75e7bf63ebe15d38ef89f3": "IcedID C&C",
    "2ef006ec84c0e6baac9abb9c585a97d4c43213f6": "Ransomware C&C",
    "2ef2ab8eda495fcd0aa240d7628f16b633416209": "TA505 C&C",
    "2f0dbd5a56a5ef0e779c1ac61be24fd5b1765ca9": "AsyncRAT C&C",
    "2f4639d43d4de28abb27add8b93fe7176d0c2d37": "Malware C&C",
    "2f6539107763ddc6d4240a5dbde625b1831a2e04": "Gozi C&C",
    "2f6ece7897cfe2067490a27d0a0155212e7c94fc": "TrickBot C&C",
    "2f73848a076c43e361cff2fd3f4bafe9871443e2": "PandaZeuS C&C",
    "2f7ff3f6a856a22da91779833bf66fa50fc51be2": "IcedID C&C",
    "2f828ebb21a62d88887bc0978db73d007dcd36b7": "Gozi C&C",
    "2faceeccfe2dd3d74daabaffaf001f1baeed3b25": "TorrentLocker C&C",
    "2fae8a3913fb570a74f19030cd3231f23a53b678": "DCRat C&C",
    "2fb5d4e169d7d03b13ab55462731c6ed439b363a": "Malware C&C",
    "2fb8c460294b26de7ea3c7647c5268841258113e": "Malware C&C",
    "2fc9afd5d4fb22ea31258424c2444af7c7a01139": "Gootkit C&C",
    "2fcd3cacdb387dee756236f6c7b79937787d0ce5": "AsyncRAT C&C",
    "2fce7bd2f5a22853bdb7e7dc2d6603b7b254e701": "Vjw0rm C&C",
    "2ffa564af83caeec708ce1e9e8393fa04d0f0864": "AsyncRAT C&C",
    "2ffdd88a849a801c96a46570447f7a6b9c562346": "Dridex C&C",
    "30152974713e1a64ea8be47d26de2daa16e249d2": "Dridex C&C",
    "30272e19924b32af5de23cb295ece5861178dd2e": "KINS C&C",
    "303480f03af13112cba97d26bd9996e22e0a9d78": "KINS C&C",
    "30393a4686c732ebdef60e3a2ab42bb27f73b363": "Malware C&C",
    "303ae86554dcd9551174db8b4beed82ffa50ff36": "AsyncRAT C&C",
    "303fa0848c1a98ba90b3c07402ca2a985c4b89d1": "Dridex C&C",
    "3044739c06ea1dc1b3ce54b7f6e00ec25d6e36da": "KINS C&C",
    "30461864272d38d8dcdea03d2b35061a7d471434": "TorrentLocker C&C",
    "305ad9e95dc028db9c87ad73eb617038a7f283c8": "RedLineStealer C&C",
    "30616920ac76997a7ea08045a7d33b8fd9cbbd83": "Dridex C&C",
    "306a40fc5326f013946d38c8fbed452e54f590cd": "QuasarRAT C&C",
    "306bb0847c94daf438328861794f64df13830d8d": "AsyncRAT C&C",
    "3073675b92c8e242faf364e3faa57b6011b77184": "Zebrocy C&C",
    "308e4e2ae362128a26e34f4cc6b9cef142086f5a": "AsyncRAT C&C",
    "309268db81186f4914bb0c08c44133a6952dd603": "Malware C&C",
    "30a07bc8beb337565a30c4c9375953a9096a216b": "CobaltStrike C&C",
    "30c139e4c9470d78c529c5083392591bf1e6f79d": "Dridex C&C",
    "30d3e1d414c30d1ea34009f706ffe098da7d01d3": "AsyncRAT C&C",
    "30d56d86cd6e5f56e07a073efbfe01673c6b8e0b": "AsyncRAT C&C",
    "30f44ffb61f162163e7a9fed9533ab25455b6add": "AsyncRAT C&C",
    "30fe0fcbab854bc45906d354cebe5a7cddaab78e": "AsyncRAT C&C",
    "30fe2b51ec25d0d0d55dc8d5cae0e799ec11de0c": "CobaltStrike C&C",
    "311010a340d9eeb211c86d5535ef0a5d68b7154c": "Malware C&C",
    "31162cd45c41ab8eb5e7e3630808bd1e4e2425ee": "Gozi C&C",
    "311a67f798674cc2cf946abe9465aaf117d644ac": "IcedID C&C",
    "311e1114f1783a4a9a668431b0d6aceaca69d4db": "Dridex C&C",
    "31262cbb377cce57123fcb4dc8bd37ae84dd5ec6": "Gootkit C&C",
    "312c8b5a062852b5ea205ef04822b5fca99697da": "Dridex C&C",
    "31310a942ebe74dbcbf72a54334b57f416fb0f5a": "Rhadamanthys C&C",
    "313b7cc078756ba4565679a48877bc516ac41af4": "QuasarRAT C&C",
    "3145298725ba5e0dd56e87ffe3f8898ea81e6eda": "QuasarRAT C&C",
    "314c8004ed1ef9a502c9dfc72524157c7b6b134c": "Dridex C&C",
    "314f0e84b04f543fdfe1e994a36ffc60f97aef2b": "AsyncRAT C&C",
    "315336e7513eba5b06736495cabccce94c58f8d0": "Gootkit C&C",
    "316dcc5627b8bfd6065740fc34e886a7a1b1df6b": "Dridex C&C",
    "31710abe6215f9938e43eb9a4352299df006a59d": "Quakbot C&C",
    "317b0197ce59196ef68f01cb88fa86ae055b4072": "TorrentLocker C&C",
    "31840ea28e21e99c1e5c8d483b20daaa0778bb76": "PandaZeuS C&C",
    "31960e6e70fa4ed2270a5542b8bb3fec984a3a32": "FindPOS C&C",
    "31bfc8fea6c399e69e7ece771999af1e23f74445": "Adwind C&C",
    "31d050946939f84c48ac249bcbc6e16551b5c9fd": "Dridex C&C",
    "31d2d913ea305ddfa3c275184f3d138627a0c86e": "PandaZeuS C&C",
    "31dbac5ac93b59d69ffeb0eaeb2110a50bc86beb": "Dridex C&C",
    "31de61950f11fa1b00431be048412f0e85482495": "IcedID C&C",
    "31e19fee08ae91aae7f2547979e2d57f13bda383": "BitRAT C&C",
    "31fa8d4fb907ed282194b197c049d48342c26072": "KINS C&C",
    "3207f78f765bc23346c9ddada24319a8c3a2d8bb": "AsyncRAT C&C",
    "320a2db7002e9d0e66c82fd73955a1d470263b7e": "Dridex C&C",
    "3217fad97ef79c5ffd0224629befa8df5e7f92ff": "Gootkit C&C",
    "323186e1015bf0388e0fa3c3324e802c9f1ab23a": "AsyncRAT C&C",
    "32321cf3065cf5c3d8f503ee365e7201be0d317e": "AsyncRAT C&C",
    "3237d2016d901477c3f2d8fdf94d0482e3e52621": "QuasarRAT C&C",
    "3250302bad47da42cd0b8cc8c114b58aafc4aedb": "BitRAT C&C",
    "3250841f19dedd734b530de21857b99dfe9df057": "Dridex C&C",
    "3252570eff94fb841ccab14c3443c36e3f9f40bb": "AsyncRAT C&C",
    "32660e3b487dc58b5f97db12492a2744af449a94": "Gozi C&C",
    "326b877c66a63b671e88412f03047c13ca39e012": "AsyncRAT C&C",
    "327bb0d9abdff7b4c0ac35341275435104b5d5bf": "njrat C&C",
    "32a4857db68c7c84d1803e4613a1f3e61be95df4": "Malware C&C",
    "32a637c1997f86f2c3edfdccf12fd81ef4540970": "Dridex C&C",
    "32aa3d194269f092cda5d3ec249c28ea2fbcb576": "OrcusRAT C&C",
    "32b0ff554b649ee6db9fe6bc23ec2b7d561a7276": "Dridex C&C",
    "32b28105c1e751fb416d78751cf36125d6433422": "ZLoader C&C",
    "32ba23fb7506622945edd5723e8dafe7215f71c9": "AsyncRAT C&C",
    "32ca92799cde5f058c48a4189562cd8acba9076e": "AZORult C&C",
    "32cf4e659ff1cc2042e57df96e2e182d6954bce3": "AsyncRAT C&C",
    "32da5d003e8aead22205b8eefc4c16675d637373": "AsyncRAT C&C",
    "32db2f1d8b39a3126de23093659dcb90179237b0": "IcedID C&C",
    "32e2ff19c09abbcdb5649425ad6739e91c946923": "Quakbot C&C",
    "32e3a55caf2d8be887e57fa9896f0b7498c8c5b3": "Dridex C&C",
    "32e8af29084982f5e8668906a1210a0da690e6ad": "AsyncRAT C&C",
    "32ead4e018f6c1fe24972022c1d4ac5527503eb4": "Dridex C&C",
    "32f17990b7741a84f01a905dbdb21032c1deeded": "Dridex C&C",
    "32f18c5bf6c1d331c34b78e4002bd51aa337b7fd": "OrcusRAT C&C",
    "32f24b2194785f9696491154f2d1b5b0e170d0bb": "GuLoader C&C",
    "32fac37a393d6fdcd2a2f1b978917b7130703f59": "Quakbot C&C",
    "32fdc08f0e5bbd94d948723f5bd186ffab9638ee": "PandaZeuS C&C",
    "33227d25c834dbb073c58c96216d0a6a6f8ae183": "KINS C&C",
    "3327ed6460b67141b8ce5eea307dd86d8bab626c": "Dridex C&C",
    "333e215f805480e6de39231b96fe6a64e9611a22": "Dridex C&C",
    "3357a4de44490bce5f495d27c2741c19fb56cc0d": "BitRAT C&C",
    "3360d8590e7519d9b0e1ef1789090b9d67df3344": "PandaZeuS C&C",
    "3360e0e0e94c0fd6fed4e09393d6e9bdb6b38754": "Dridex C&C",
    "336c3ccda369bf0c6e498622e43d9a6f2e9cf76f": "IcedID C&C",
    "338da403ddd4fd9e2cae23fe49cb0bb154005a18": "AsyncRAT C&C",
    "3397a19b379a944d6a93c716467ba76f56e1596e": "AsyncRAT C&C",
    "33afe62dc50b6d53054b7db3e8205c48ab538895": "Dridex C&C",
    "33b2ccdeb59f88e8e071cecb23c702dc7fee3227": "Malware C&C",
    "33c3d1f2647624cadda3f0f986084108bb2a941b": "Gootkit C&C",
    "33caec34b466161b6e4d7af2385a35d1e6402d50": "AsyncRAT C&C",
    "33cd359517b2afd229eb8c9cda328d5f56158838": "VenomRAT C&C",
    "33d6735dd105c2d0d900df603c16bb69a39b6f5a": "TrickBot C&C",
    "33ecb0cde6598b79f982a37aeb54fee0f1d1d173": "Vawtrak MITM",
    "33f93f890866d7f4b9955f3e29a7854342414ac5": "Malware C&C",
    "33f991636358302579fdfb11c074ee004c8f2a43": "KINS C&C",
    "33fe7809ab2d77ccea19e1125fb3646322a940de": "Dridex C&C",
    "33ff7c09706cc1551b5bb5bff4a96f2ea4716c04": "BitRAT C&C",
    "3406adb20f2859f893d5a170c5497f823ab2121e": "DCRat C&C",
    "3407d4127719e1cf0dc996b5c8723217a9eb8218": "TA505 C&C",
    "340fbe800a2e9373f4c86e8db8a888ecd30cc317": "KINS C&C",
    "342d428b8c061de35c3f5c5ced44124d7f20fdc0": "Malware C&C",
    "344c90fd31f711dab2e4270b0617181cec5091c1": "TorrentLocker C&C",
    "344d47f340f535f5301e6d7a6d07cf05be1ef7d4": "Gootkit C&C",
    "346160fdd36f63562b60e3ed39d1fd65b3e5d282": "Gozi C&C",
    "3465fc307c1439a01cf6562b7d0f4c25aee49eb5": "Quakbot C&C",
    "346ce508bc4492432b00d0888d90d9c7abd777b5": "DCRat C&C",
    "346e1ba000e1a91fb5a1dbb97ffeaa1dde412c5f": "Dridex C&C",
    "346ff72994504549d53f733734dc5df3881718a0": "Dridex C&C",
    "34766e3b5a53ea039d0d7bf644694514034c26aa": "Quakbot C&C",
    "348e8fa305d8b1e5fed53c071edd58e7a0c9d9d4": "KINS C&C",
    "34a163998daf248a58aef54047007df6a35eaf55": "AsyncRAT C&C",
    "34a92e41d4cf61f1fc510e40afd362d2ddc00ff7": "Qadars C&C",
    "34aa83727f2be543fecc45f474fc5af46cc77287": "Dridex C&C",
    "34ad00dfbaa61d0f037a8c32d92df77ed63838ec": "Gozi C&C",
    "34aeca221f8ef6abca6861955f5da2ca15ba88cb": "DarkWatchman C&C",
    "34b6b380f1c32fd92a4d58e1a5185d5267e05fd4": "BitRAT C&C",
    "34b8d2b09ced8ed183d89adfaf2c1b40bb2d0e64": "Gozi C&C",
    "34dc882d28b3c17ff3df9a6bbe406145449f288e": "BitRAT C&C",
    "34ddf4389bc43a41632f271f1e94af2ea3b5b7da": "DCRat C&C",
    "34eaa505d1db50ee025558a72f9f26647208f015": "QuasarRAT C&C",
    "34ec292847223cd5600896fd6e457b9a09c4f9c5": "IcedID C&C",
    "34ee15eef0ca1974ba60e083bc6ed0693cca3cc9": "AsyncRAT C&C",
    "34f06057eea1ba0ecd0734fb7890e5b54b3f89dc": "TrickBot C&C",
    "34f44658c096e5a0b4754de569614eceb0d170fc": "QNodeService C&C",
    "352c39c3b80f00f77b49a0d3f916b7a0a6e856f8": "Dridex C&C",
    "35308eeae255b7d8c553888460821c76181b8563": "AsyncRAT C&C",
    "35355b2b06da6c70f5fe2fc261b97a847b026f45": "BitRAT C&C",
    "3535b616a008419a523cebd505af9119b4a1bd49": "Gozi C&C",
    "3542c9f3bef6cdace69a35f56a1b9465e26ed712": "Gootkit C&C",
    "354f08dfb9fea2e2423dc762ea096656aeb12551": "KINS C&C",
    "3559c3296b950279d31b4e5a75b35f1322c7d956": "AsyncRAT C&C",
    "355ae6ac55f651241232ea299b9b67fb6ad38848": "AsyncRAT C&C",
    "3566219391b9566188b4c8021ea3ebc61c9735c3": "KINS C&C",
    "356da18bb53c57d5371d10c9e0beeb02dd136b7a": "DCRat C&C",
    "3577587df92f9c5fdfdf7492aff31b4a589af02c": "Dridex C&C",
    "357d83cac3a1167d8387d4e73d3196fe845eacdb": "Gootkit C&C",
    "3583d51f40329a49282b52bafc8251d55531faa1": "Dridex C&C",
    "35962b05f2defddfe334a459e912219a32ed325c": "Malware C&C",
    "35a2b2d784b0e1261a12cd3f619f55d85936763d": "Gootkit C&C",
    "35a88a6364e2efefdba589ec2c8a9e260dc7e9a0": "Adwind C&C",
    "35b9d1cf1a0d23fabf3b7d419299e4df395f8a1a": "Gozi C&C",
    "35baf29f7fa23e3d46fb16e79fb0235405a1998a": "Gootkit C&C",
    "35c3eea12cbad13e91608f78aae0e619f1881477": "OrcusRAT C&C",
    "35d5b5e82cf63f0cd47f6154da2e98411c118d7c": "Dridex C&C",
    "35fa1d3f1b032407472a7639654b33801c124cea": "Gootkit C&C",
    "35fcaef2eaa6d3addf86745c59c1c12b08212960": "Malware C&C",
    "3613c84ee41ebb8e837e9619ffa88a8ba2c24e30": "VenomRAT C&C",
    "3618656fed15f9c1699b47e4e0e869bf45c939e7": "IcedID C&C",
    "361bb30954b8aade81d8e501c19578706e228754": "Adwind C&C",
    "36350bea7d403d03ccc61b0bb2a32a1841dd320b": "AsyncRAT C&C",
    "3649e65d154727db2f70e6a84573b101f9debb7e": "TrickBot C&C",
    "364b8917a3e1afca0796d02d4384fd5741cd9593": "Chthonic C&C",
    "3667f599b35d29fd083a878e3a776b6eb666f58e": "Gozi C&C",
    "366d7e58651876de4f700812eb613c260e00bc08": "IcedID C&C",
    "366f2727c6a286a87819a764e4edbfbc5ab4bca1": "Dridex C&C",
    "367882bfc2b9cfaf5aecfaf9c920c07c92043ea1": "OrcusRAT C&C",
    "368e6beb6f8d2f6049831fe25dd397287823c5e6": "TorrentLocker C&C",
    "368eee190f7a3e368ffc186997ba4324e329200a": "OrcusRAT C&C",
    "36935f2083b0888107d9bc097c24c62ac5c6c8c4": "CobaltStrike C&C",
    "3695c901eba63ba3989db3baf338e8787af7135b": "AsyncRAT C&C",
    "36ae197c21cac2560f6d6edca50c463ea049f152": "Malware C&C",
    "36bd8b8d49ae51262b0a8748d9ac63240c642b60": "CobaltStrike C&C",
    "36d0b9f7c0cef3c27b32073dcc19ba076794e0ed": "Dridex C&C",
    "36d28699e16b629661e430f888c7a7c305484e4a": "TorrentLocker C&C",
    "36e6be16d1807ad1b5d0003f6c263fd860df3747": "CobaltStrike C&C",
    "3707228a2ebf2c43b4415f337177a825ee8fe108": "TorrentLocker C&C",
    "371c66be0eb45d10627faf8dc3868300c30793ed": "TorrentLocker C&C",
    "371e76ef8385f7f251dfd786e90dd8c4982eaa82": "TorrentLocker C&C",
    "3722b4e06382080319e0a326a545adaf43565022": "KINS C&C",
    "3723fc26f5796147454cff205b68bb940804e1b1": "QuasarRAT C&C",
    "3724bf2ea77ff13ea836ee0fe8ecb7fddcb8cd76": "AsyncRAT C&C",
    "3729803335dfa5e627abab2bbbbbfcbbc30ac29f": "Dridex C&C",
    "3730d557d44ce4e6be974a038d4343d8d67976da": "Malware C&C",
    "3732abdae5dfb059d920b51a4f99f654411ca6f7": "Gootkit C&C",
    "373a97ff1673029d1daf67253707dd89d61f2f13": "ZeuS C&C",
    "374c24ceee9208a1881b73367ad24146ec8c23bb": "Quakbot C&C",
    "376bba56e4ea4af8778e1dc800833a7e66c70923": "QuasarRAT C&C",
    "3776dca68d8e9254efce853fc0d76382b32eceb4": "BitRAT C&C",
    "377710a8b05930366e6fb26ce2a79815c04764dc": "AsyncRAT C&C",
    "37830c935a7dba47513e24b5792bdecbfadf2a73": "TorrentLocker C&C",
    "378344803525c82d3e134dcd2222cf2cfab0c338": "Gozi C&C",
    "3784422d67a6ae0c82d60eeaf3850960a9896cb2": "AsyncRAT C&C",
    "379e90d3901ee28735beadd25b54b9d0b3a5af3c": "BitRAT C&C",
    "37a3a14b4ecbac5e32147c0ddda5e9d6bddbb4b9": "KINS C&C",
    "37a523f9523fbfd98feb3ed062b50f058f8bdff2": "TorrentLocker C&C",
    "37c1d9553cdba24d3da5ae0505a03e2442ce5296": "DCRat C&C",
    "37dcede93c356b1e87c9594c2ff76219d17e14a6": "QuasarRAT C&C",
    "37e1066c8ec78d3403fb17aec2f33dcd0f2d4a36": "Rhadamanthys C&C",
    "37f211b8024c7206e40150dca938f5c838a629a3": "Quakbot C&C",
    "37f2d0b820333ee282ac147752c9b1671bac39e8": "TorrentLocker C&C",
    "37f5caec6916965a7f9c2a4d2622334ae5f14c3a": "Chthonic C&C",
    "37f73eafaedbe5bae16701ea937b1146d96d080a": "BuerLoader C&C",
    "37f7d3a0f5acac3169e6dfb0f0f925f95fed4be6": "Malware C&C",
    "37fc1f1adacd745a49be53e92ca1434f7d6e1908": "AsyncRAT C&C",
    "3802238df45133d9f401e32c813099c27a2968c6": "BitRAT C&C",
    "380793fde8622ae61f797772e9a72205f090671e": "AsyncRAT C&C",
    "38172a66a2a6d7e99a317390b75c6ad9a9bdb8e7": "Dridex C&C",
    "381774d77d04aec07963b65cc2c9c5945f9d432b": "Gootkit C&C",
    "382e2fe1ca91b426827a127d93aeef8c0535e95f": "Gozi C&C",
    "3837e4301924fd867b241b02d1273f3148773b83": "PandaZeuS C&C",
    "383841428de15c4cb67bd414d07c4c956882b1af": "RaccoonStealer C&C",
    "38474447e18be8bcf2520b8937caa61abf3ccddb": "Gootkit C&C",
    "38510c8f0d405e92eec89ad4abedb0f4d7e6c456": "DCRat C&C",
    "385cb6855c71b3ae761e8dbe3deabed403fff023": "BitRAT C&C",
    "385fc0e4f3e0c9a77aea963da70bbdae1b8909cb": "KINS C&C",
    "3883e2f730574057d5cdf91eae562b9c56e5b50d": "Gozi C&C",
    "388d99592d32b7607e5ccbfff60878d14ec2163f": "Gozi C&C",
    "389db7a99498891649f3fe3e3814612c46b67e9f": "AsyncRAT C&C",
    "38a0cf1a724c498ae9bd64c077a60c4232ffeab3": "Gozi C&C",
    "38a42948a8fe12e0c8e36a40805862247a0821bf": "AsyncRAT C&C",
    "38aea70904795dcbaf1cbe9510075e3d9ce4fc02": "TorrentLocker C&C",
    "38b06e5de344378b5daa7552746792913fabc095": "AsyncRAT C&C",
    "38b896036e33461b431ff4a04f73c3bc22d47b76": "Dridex C&C",
    "38baa294045fbfa1194ba56810f8a1f29d439268": "TrickBot C&C",
    "38d0ec38b7d9aa07e11f6835987f709d3eea3791": "AsyncRAT C&C",
    "38d28ad2bc285654c7bed83a7e2b0debef0eb791": "Gozi C&C",
    "38d50be8831f4a2ae931dd3156a8cd8e1217bd53": "Dridex C&C",
    "38dc61760565a70562592833b6767e05c3801d95": "Dridex C&C",
    "38e1c48dfe29df43547cc3c1d036aebbc9e1d3bb": "IcedID C&C",
    "38e42a2e5a0f33a1854e76a1620c855ea4c52449": "AsyncRAT C&C",
    "38ecc7c543c90d25571eae05fbd1948a310761b7": "Dridex C&C",
    "38ef17d3c7a11ae05ef78b9b4b42dfa13b6992b2": "Dridex C&C",
    "38efcbd4c2895f8b93bbfe5821102ac0b094faf1": "AsyncRAT C&C",
    "38f4fd164cc438508c424f2e44d90f6995dadf9e": "VMZeuS C&C",
    "38f564f5b0ec5549f1a9c516dc34df21b2ab9523": "AsyncRAT C&C",
    "38f957a7714ebe6fc27e56c6eab8badc987f5e2b": "QuasarRAT C&C",
    "390d36815dd2f7913b4fc02ae403469deb0da09f": "QuasarRAT C&C",
    "390dc2b05f3abb7068a10df8d30ffcd33b34c3e3": "KINS C&C",
    "3912faeef78e1e5f6c9ccaa352ea37f67614e640": "BitRAT C&C",
    "391a54c41d8dac789a8749bea96d81fe8153448f": "Gozi C&C",
    "391f20c839c242fc3c5c910e9059e290139fd399": "AsyncRAT C&C",
    "3947d0e9fd01c485ed0b61662b8f6993fcc4267c": "Cobalt C&C",
    "395c98e8da883cc824a1ec77cdf495f8c955332b": "Stealc C&C",
    "39651dd1be23369f801b4779ac2d7db865e7a246": "Quakbot C&C",
    "3979fde3b5025f8b331ee90a998bdef8fb741c6d": "Gozi C&C",
    "398b913ada3f5962e924486dbae668cdf9c0dc72": "Qadars C&C",
    "3992bdf1b82e697c8ea2b8542c03c64f678e936d": "VenomRAT C&C",
    "3993c85ac1788eb4e7f36b027f135aa655573d82": "ServHelper C&C",
    "3999302944cf1b07abf827008771c45dcf69f6fe": "Gozi C&C",
    "39a412479325729f5f660e85a27f359a99c5b84c": "RaccoonStealer C&C",
    "39ad79bf7241475b725430053492ed28bacdc9f9": "Dridex C&C",
    "39b149a669a50b67940ddaa3588a8b134fe552e8": "BuerLoader C&C",
    "39c483c2572f6965933e45c97c5e5abea1a2fc35": "Gozi C&C",
    "39d09bd84e038a58d255ccb57751887311c6d6a3": "Dridex C&C",
    "39d1e06bc75253ac2e946e704f2f946a56b9dd19": "AsyncRAT C&C",
    "39d3db18792efcd78bb50eba9203ddf4aca1ddd3": "AsyncRAT C&C",
    "39d5e374dd9a145b3603e018026566b324b8dda6": "DCRat C&C",
    "39d7751181d9b7af450e3e25b9bb920f50afb5dc": "BitRAT C&C",
    "39da64e94d8f6a826f0e5288378202491034d2e2": "AsyncRAT C&C",
    "39da9c2402f9da3f5c44616e3cea439cf185ff71": "Dridex C&C",
    "39db50ef0184102a266ca2e3cad0f98fefb89c82": "TorrentLocker C&C",
    "39ecb00b6ee846a76c6509e00c527682ccb399eb": "AsyncRAT C&C",
    "39ee7e5aa0090a1d06e4a6e2e4c0a2750f55b5be": "ServHelper C&C",
    "39f16b69448d9611093a8188cc4a9b74f09127de": "AsyncRAT C&C",
    "39fa8e880ea3174775e14275bb4613f40a5f522f": "Gozi C&C",
    "39fe99ebb158a5f06b2c872918ff51bbc03e3b74": "OrcusRAT C&C",
    "3a021e3c558b8e36268f518918a06a1c830ccff9": "AsyncRAT C&C",
    "3a15147543e6cb16c79c545a7830d2661a9cb6c3": "AsyncRAT C&C",
    "3a16544da676cabec738cc2cf48dc4b559bfe728": "IcedID C&C",
    "3a1f60e1650fc92979c622648fbee15ece6c7a69": "Gootkit C&C",
    "3a3a52d014bdeb3be6daee6dab0fc276bbc19867": "AsyncRAT C&C",
    "3a40d6b91d59d02a5a9a9c51ce2621e896f45286": "QuasarRAT C&C",
    "3a425957b89d51048f136557559acbdf5f95a818": "Gozi C&C",
    "3a436c30b427960931908061278b85aed67a7e67": "AsyncRAT C&C",
    "3a4578aeae28ec5e2cc54a8a8a72f3362afad9df": "AsyncRAT C&C",
    "3a57b9f08a008fb38b0a63db33b843327cc88775": "Dridex C&C",
    "3a62b329546a881780ad2ca935bc1449a2f273dd": "BitRAT C&C",
    "3a716ac245917611dac7f57ad393a81957e0f386": "H1N1 C&C",
    "3a719d77508b45fbc422471d2059ef79ff558a4d": "AsyncRAT C&C",
    "3a746880638449efabe00e00929eb4014b5dfd3d": "AsyncRAT C&C",
    "3a8843fca6f4e206bdf69ae150cb65756a2e8795": "MarsStealer C&C",
    "3a9c066e76bd13f2e4c60859d7b4d9ff6e666cf0": "OrcusRAT C&C",
    "3aa5039faf5cc5fe6d47023c6f019b23f880311b": "Gootkit C&C",
    "3ab4d6e97ec26d1ab194f44f1968eccd35fc66ae": "Corebot C&C",
    "3ab571e1e3ddb3c0b7175d75eb238e6c69390b4b": "Dridex C&C",
    "3ac34436873b71bd7dd1444534fce2bc2ba560e6": "IcedID C&C",
    "3ad3f41c7332657b42e9995dd368b7c94ce24b10": "Vidar C&C",
    "3ae3c30d9a0a79c56dffadbc447afdece45eebc4": "BazarCall malware distribution",
    "3ae6f60da16b99c5807fe93e4729ad7c2f4ffab3": "TrickBot C&C",
    "3aec772694ed6d115a82d21fa0ca8ae4bb1f2c35": "AsyncRAT C&C",
    "3aef431f8bb8bbf38b9ff74e7fa23695cbb676e6": "Gootkit C&C",
    "3af61c2d7b1e30849cd1dc9f14bbdae2bf1b2d53": "Malware C&C",
    "3b05348b3f4de2b833cf935a6c9e03a2cb7cbde9": "FindPOS C&C",
    "3b114de690dc2f7c6a2239aa233917f93009bd9f": "AsyncRAT C&C",
    "3b2db83c88073c59b010951ebe98140042a8c679": "Matanbuchus C&C",
    "3b3725dd24b8bc468ce38bcab7692100b5855077": "PandaZeuS C&C",
    "3b4980d76d79ed58ef1600468900ac3b13edc289": "DCRat C&C",
    "3b4ef65ef0b5af89ec9853aead53051f6dff5c0a": "Quakbot C&C",
    "3b5b7680243d3e0949a7f8fc59722bb537becbb5": "KINS C&C",
    "3b60bd7af0577bd42e28c54329d5faa2129494a7": "DCRat C&C",
    "3b670ea0f803c163c004b54a92cf7c4094b568fd": "Vjw0rm C&C",
    "3b68a586da5454b58d8986a9339328e63f6a8f64": "AsyncRAT C&C",
    "3b763cd8d1961ea985d5bb884aeff66e51e62a40": "Dridex C&C",
    "3b83d6f6dd0b941c47367d6750c94bda02909d84": "QuasarRAT C&C",
    "3b893658bd45dc0e09a59bce3de2843337566505": "RaccoonStealer C&C",
    "3b8d8d869939910437d9e2602833b6ff9d92c5df": "VMZeuS C&C",
    "3b93128329c38c48f427d31f51401deda79dbce6": "DanaBot C&C",
    "3b991caf1d06b6b4d96b68ac4035dc26b4a56762": "AsyncRAT C&C",
    "3b9eb3ae78bbd23b8f1ab12a17c8c8a3df07ec6e": "AsyncRAT C&C",
    "3ba6269e31f435418e1ec8249671cc9eb7a47b2f": "AsyncRAT C&C",
    "3ba714519b3ef3dd3c75f1cbe9919e15064f606d": "Dridex C&C",
    "3ba76a8f584031ff3ef289da6b8a7123d290218b": "QuasarRAT C&C",
    "3ba9318686327d793834f165964bbd6e354aa74d": "Vawtrak C&C",
    "3ba9d829ac97f929db1a5590d01f2903067e0bb5": "Gozi C&C",
    "3bbb0df272f6e208cfe571d889e0c398ea3b87e6": "AsyncRAT C&C",
    "3bbe5e9733b0b9f5c4eac5ffc3899cb64018c015": "AsyncRAT C&C",
    "3bc8e09f9cd4a29f1d57fadc70ca35d91a79e36e": "AsyncRAT C&C",
    "3bc9e34b9f00e3c92e18e837b3d2f8771b0f3180": "AsyncRAT C&C",
    "3bdb2f4b219cb08dbfbae4dc0881a16237e7ad68": "Dridex malware distribution",
    "3bf13682e2462c30d409e7f28e27266f976cd2d0": "AsyncRAT C&C",
    "3bf93effd477a726e66d3923f0c809adc6b688e2": "Teslacrypt C&C",
    "3c0f57093d800de75f32a1eea554e75e3aeadeec": "Dridex C&C",
    "3c14e7aa18061e9adcc78044c4607766b4a8d0c0": "Malware C&C",
    "3c388cad30b3eeec1394dae98bc6b817042eb6f2": "DCRat C&C",
    "3c392d20e315771d276556c7da3707f081701f78": "Gozi C&C",
    "3c3bb9140767037a0d1d6e922b6f978235999817": "AsyncRAT C&C",
    "3c401a1f40c5fd68d7f1c76effcb6c7391e4b026": "BazaLoader C&C",
    "3c54692d86969086a5fb50fd4b88cbdcfab5a60e": "Shylock C&C",
    "3c77218c95f042530292b841a2887723e0d02140": "Dridex C&C",
    "3c875da14a71bc660bb7c90db79aaa69c76fd0e0": "Gootkit C&C",
    "3c9a9256403d8a277b402fd1acd377bf331a6d3b": "KINS C&C",
    "3c9b8de76921830913644016a93b09a67fb0d8f4": "Dridex C&C",
    "3c9bb44480fad3577c516b21869f784b1043bd21": "Vawtrak C&C",
    "3cadc499eadfd237f62d1747bccefb78a89ef295": "Gootkit C&C",
    "3cb38fead363d5480a2a23d26b269ed434fa078f": "Chthonic C&C",
    "3cb43fae55eab4ae0a935f3888d0affac19afd4c": "AsyncRAT C&C",
    "3cccaf276c8f31452a9a44c8d2aeea649a92b675": "ZeuS C&C",
    "3cd7c88708d5b03c5f6a46969b70675b7c8e089b": "TrickBot C&C",
    "3cee08dc89088da5ca35f8cf1229ea42a678f2c5": "Gootkit C&C",
    "3cef917bbc88ff17ae96fabb7a4e76539562d22e": "AsyncRAT C&C",
    "3cf19053ae2af4c1c38745d84233eaf965d93187": "Quakbot C&C",
    "3cf394369bc8245b1eeb00e6b5ee74528d0fe01f": "PandaZeuS C&C",
    "3d03cf13a857b6d28f323f7bab32e92ce476ff6b": "DCRat C&C",
    "3d12352bd1e105a710cd4e0abc1449317bd8f15c": "Matanbuchus C&C",
    "3d174a0fd49467201332992a1f7218414f3bfe23": "AsyncRAT C&C",
    "3d1d67c61b6cf96945107419df6875c354f1e186": "BazaLoader C&C",
    "3d314af395559724456b601fe775ce6eb9137212": "Dridex C&C",
    "3d741ff6725860f0b406f434bea78cf9ea71059b": "Dridex C&C",
    "3d781b99e0860c934917dd47e8d2df8475cc7fc8": "BitRAT C&C",
    "3d84a2c629713881e26b4134204b5cb4f127a143": "OrcusRAT C&C",
    "3d8574f330266185f8da9f8981a7b39b1d2270d8": "DCRat C&C",
    "3d933dd92bbe6aa0f4fc055aa5d67260440256b0": "AsyncRAT C&C",
    "3da73737906c665a36b19eebe0314f5c97c46c12": "BitRAT C&C",
    "3da776da8fbbe74cd4944259a8e982a0b2ac9581": "VenomRAT C&C",
    "3daa7cbcb216c83a041a89b32d967a8e20f9479d": "PandaZeuS C&C",
    "3daf499976ab20e561704c9e561f43f26bf8c394": "AsyncRAT C&C",
    "3db0611abfb19d1bfe5e2835bad8854a50e928b0": "Dridex C&C",
    "3dcf2a17aecd0af267f98ee5efb6fc739c80b84d": "Malware C&C",
    "3dd0fbef1a0638e0c1ca9b2b1af7cd619154d4df": "TA505 C&C",
    "3dd4b610ff093100313ca7dbe24f062ca80ad6e1": "Gozi C&C",
    "3de6fd47b3638a36863c47c99a168474c75453aa": "Gozi C&C",
    "3df43035b3d1c665d55a334e41c5bcd3a6a5fc67": "TorrentLocker C&C",
    "3df448e14c99f7a25d86724dd83dbe6cd136b42e": "Dridex C&C",
    "3e034e54c92a3a88f3e2f9ee4de0fb7742df3b42": "PureLogStealer C&C",
    "3e03570ff45155d6201dd615ad8a79b1e70977f1": "AsyncRAT C&C",
    "3e0609e875693c68a07ada48b68c8ed4a7ca96ef": "ZeuS C&C",
    "3e0a89f45960324c9255a39d4a9612be5a90270a": "Malware C&C",
    "3e187af7c1e6dac2434476839b57e412bcd3e679": "Matanbuchus C&C",
    "3e26b4464170a159497c7998168524dde565a2f1": "Gootkit C&C",
    "3e340d99e74c1f8dee3411c64dd6ea8109932af6": "KINS C&C",
    "3e40b58f2c7afa5c10aabf58fa64c6d15dfae2a8": "TrickBot C&C",
    "3e4a4b3c0d3f4f71a14ddbe985d18e4a445c93f2": "AsyncRAT C&C",
    "3e4fd8e850da0a9b14c060d19a28758320b6d9e3": "Smoke Loader C&C",
    "3e894872308ae701245f2cd8ebb030b139f79352": "Gootkit C&C",
    "3e8b078bc47eec1a74d1d30cf6dda744afd58783": "OrcusRAT C&C",
    "3e945933e9ee8b3304ee2c9bf90687a431685c3b": "KINS C&C",
    "3e9e141ad83c5bd6ce91880c0e256e15401ec674": "QuasarRAT C&C",
    "3ea57cb7d6455f30e3d7e942013b808092867e3d": "Malware C&C",
    "3ec2498483f940604a30666df94086216543017a": "Adwind C&C",
    "3ec635e00f20b5e288fff483419de725dd42f497": "Dridex C&C",
    "3ec88afa3b123134713cfae33c0d453b3cf1316b": "BitRAT C&C",
    "3ecd22a76155f63c9a83206a22a01279fe386ea5": "Havoc C&C",
    "3ed16cc4f0ddebca7f789af2c249fc3cdac4e177": "BuerLoader C&C",
    "3ed3f40447b41704ea2541b2bb86848c332b14c3": "Gozi C&C",
    "3edb18a6acf74370461afd11c64421ac0fb1d370": "Gootkit C&C",
    "3ede14289a58b5539a699927e22938447fc6bd62": "AsyncRAT C&C",
    "3ee053d38a7f3d80a47aee374b2d491e06b62609": "Gootkit C&C",
    "3ee7874bd4ddb3f0d450f9245db7e468dc051ecd": "AsyncRAT C&C",
    "3eef3d7311a2b60b600fab18bd722185836ad3cc": "BumbleBee C&C",
    "3efa842c761c8dda5f3483a2b9e347852bc7a017": "RaccoonStealer C&C",
    "3f03cd3fd366adcd3c6cdbf835ae72e272c5c904": "Gozi C&C",
    "3f0f5942b09801aa96f3bb06635dc8eee08bd629": "AsyncRAT C&C",
    "3f18b768e30cdddcec508857737eebd4fe22ef1e": "IcedID C&C",
    "3f2b5f892b5e565db4ddcc19b398db2bd0bf57fe": "BazaLoader C&C",
    "3f3919c49f3e2a188cdadaf94ba8db3e2cca3803": "DCRat C&C",
    "3f3d226511275a3cf9b5f17ea58322030df79298": "TorrentLocker C&C",
    "3f44ba28bdf03c75f168fabc4fd5507a1e4c84c2": "Dridex C&C",
    "3f476828cf24d1fdbd176ace93d74a666eb70a16": "Gozi C&C",
    "3f5e785b932417d800d480ed03b292adf21fc913": "ServHelper C&C",
    "3f64b4f12467b6280e7feb46828e0ba28e5dd132": "Dridex C&C",
    "3f66241b807bb224a1256b7b00626da6541b6d6f": "DCRat C&C",
    "3f68cdbfbd6e7f74c07797e77380cedc0524d960": "OrcusRAT C&C",
    "3f7831d6dd20bdd6d99593cae7f398718da04ef6": "CobaltStrike C&C",
    "3f7e877519d5ff64520cd296095ea09abb090f45": "Quakbot C&C",
    "3f91f6bf6f1808e5bd12e8ed58b2a0fe23dfa3aa": "AsyncRAT C&C",
    "3f9ff233186cf48138a90190b0af5801404064f8": "BazaLoader C&C",
    "3fb18e1a7374f2c24b4e404414d1c093935dd724": "KINS C&C",
    "3fc462a529a2356263aac72abd1b517597b75d7c": "PandaZeuS C&C",
    "3fc46743e6f6c3489e0bfececc98cfc634cdcb95": "Gootkit C&C",
    "3fee5c28b28ef06782aa18899be116c9ab0b4ffc": "Dridex C&C",
    "40005ac5bc2478d6f588b3161bb3e25914a90f83": "AsyncRAT C&C",
    "401ddff319e46d1a25066d7dff7e45c2ded8c0db": "BitRAT C&C",
    "401f41fceafbed65a1567b5a3f45b2fd84f19b15": "IcedID C&C",
    "40215ae376a70f622cc42e532c387a8c125696e1": "Gootkit C&C",
    "4048187e494e0a98640d8420986271518e242ff8": "Dridex C&C",
    "40750c8022596b02fc6a1725993a7fff21100c6d": "DCRat C&C",
    "408696c2824d4c8ab6f6a9ca3680a190c5761630": "Fabookie C&C",
    "408e8bae749f15a465abf4841734ee4ff6bb7f3b": "QuasarRAT C&C",
    "408f387e3efefa210cb5cce367d440d8f888a814": "Malware C&C",
    "409b75893e22f22b724a136a6fddacdccac8fb53": "AsyncRAT C&C",
    "409f65d36ad67c47e20e3db12050f8f643a519f7": "Dridex C&C",
    "40a558b1d436eeb6be5f6a938284f468cc30a725": "Dridex C&C",
    "40bab998f75f015f8933deeb3c4db172dd4cbe33": "AsyncRAT C&C",
    "40bdb664eb084b0ee4326d4872cedf13e0c3b4c0": "ServHelper C&C",
    "40c1f6887d46387b185ea93deffc9543ab6e21fe": "Gozi C&C",
    "40c799e166d5d89a826f1a556bab0700b2c02108": "DCRat C&C",
    "40caa9baa19076efb7a01b9a17867799c12ff506": "Malware C&C",
    "40d4fefe24510420a97a1d7d34ec5c4743cf1e86": "Dridex C&C",
    "40e6f0fda8c8000ef9d99952de7c4d5ca1371983": "AsyncRAT C&C",
    "40e74305790c9e5b761156746126d961d029231c": "Dridex C&C",
    "4105811b72d6fffcf42984a5bd0c0b5ae213cbec": "Gozi C&C",
    "410ec2431307d0505db7f4a09cb92fbd372ab369": "Vidar C&C",
    "4111eb4e3452f3046c6f5dfe90f84f08d3e1bb9c": "QuasarRAT C&C",
    "4112fd7e6a5f6d4990ef99d310c1e2031523be38": "OrcusRAT C&C",
    "412150dac65e08548fcd43b1ced8857696c50630": "AsyncRAT C&C",
    "41295a7e73ea49c1254196b2f2a7bf4e9459600e": "Quakbot C&C",
    "4132662ada64a29d65005578c9de1c6e05d62378": "Quakbot C&C",
    "413820202525ec6122adb587a215a9ddd2ef86f0": "Dridex C&C",
    "415a586a121158602392d56394a5903dfe222a0c": "URLzone C&C",
    "415d675fe28739b263dd69d7b3c3881384dfb381": "PandaZeuS C&C",
    "418b04ace2a841e0382a274dcb600729c4c0a521": "Rhadamanthys C&C",
    "41a180cfb9e2ec1b709d2fe8c62dcf5a7e8c911e": "Gootkit C&C",
    "41a62fa2e2d958b67595c26469da07cdaa29fa5d": "Adwind C&C",
    "41bc67d1c66f845016c3adee74d5995b11a4c77f": "Malware C&C",
    "41c3cf52efca981f2a2c4b11eeaadecab1e2dc49": "QuasarRAT C&C",
    "41c82d5dc9bd75f67b776bb0d341f576a0dfae30": "Ostap C&C",
    "41d662031536fd5a297ec93aed5ed182eecc2262": "Qadars C&C",
    "41e5c147583cb7e5b5d3132376aef7696d53dc35": "PsiXBot C&C",
    "41f033bf58d1adcf456cdc56c13f234edcc695d8": "BitRAT C&C",
    "41f2382bb212a343cc992f70c0f1de97e86b4c0b": "Malware C&C",
    "4238209c55762c71c6f61041a98437aed7fa20d7": "BitRAT C&C",
    "424c62a786382cf4b20aec00bfd5c3f00c103dde": "QuasarRAT C&C",
    "4273d103c5fec2ede6f9cad092a83417a43fe741": "Gozi C&C",
    "4275c1288b76983cd6ec48b47908992f13416354": "Gozi C&C",
    "42853894e39c464e8c91f9b6c00bb09bb43815a3": "CobaltStrike C&C",
    "4290401916563b1ae8f39f08eeae091bea58e22b": "Dridex C&C",
    "42a6026de7af57893e8b91f005eb032206caa82e": "AsyncRAT C&C",
    "42b2afaceb4d270a194b83978020fd4711e928e2": "Dridex C&C",
    "42c34ec2cf084df07531129e227504685985e766": "Gootkit C&C",
    "42e10cdf46f99d2b42dcc2c35f71254915dee156": "Malware C&C",
    "42ea2a4de65640100d7223e9752d0783cf56ad58": "Gootkit C&C",
    "42ff09b169b36e4872fa91c3348a8fc174878568": "TorrentLocker C&C",
    "4300082bee55ae92825f94f5faf4fe3e433a723c": "Dridex C&C",
    "430063c604a4b279d216f9c28a0b8def1938e00d": "KINS C&C",
    "4317d46833511a217f6f0b1cc01ded628caffa7a": "Malware C&C",
    "4318d6680672f33c222730a0b9e4a7cc57a7c101": "AsyncRAT C&C",
    "431cc78f86bcca3da5742814c512a0ca0eed6f3c": "Dridex C&C",
    "432062f50c4ea979b8a5ced15ae86f261ed707f4": "TorrentLocker C&C",
    "4320d2357d0a95ad13b583d1bd1e65c8aeefcde3": "Meterpreter C&C",
    "4325212f60da8090771b27403c7f49e70bab53aa": "Dridex C&C",
    "432858025a19d6a9bcb47ec372c9105bf3466f31": "TorrentLocker C&C",
    "4348b0d340cbdcf6d405d0c7fa4ee2b84d9dbd35": "BitRAT C&C",
    "4352d54c897de9b235e8dadcff70cb046ddf0ab2": "QNodeService C&C",
    "4358125f70e735fb0136fe48c95e17de430868b4": "DCRat C&C",
    "435c84f8dbf9dfc192383813701bf1caf827fdbf": "Dridex C&C",
    "4363262d043654c257e4541b3cb014f494b8d320": "QuasarRAT C&C",
    "4363599da41d9347e82e9ca93c2e1a900eba0b2b": "TorrentLocker C&C",
    "436b7cfa7e2fa5fd57eadb1c4e63f014283abec1": "BitRAT C&C",
    "4373a5e637ba655086a7d2a0153df96a60f52952": "DCRat C&C",
    "4384dd0268c5b7a60bae8a5164f737e311b1bddb": "Quakbot C&C",
    "43855804f0a42b76ed9057b8209280f756f536ee": "Dridex C&C",
    "43886c9bf4293f78dae0b6a11cbc3d0775d02f7d": "RaccoonStealer C&C",
    "438d55ce367216ce4c8347f559bc3b153faafae5": "ZeuS C&C",
    "438f8af414255d74911ac7183477a42398969010": "TrickBot C&C",
    "439547153383c533972649ed0268c92eda9ffb48": "Malware C&C",
    "439b32934ab596ddcef47ab13bbcd51a1b269896": "Quakbot C&C",
    "439bd7279300820164d60efbff016f3b51ec57ac": "BitRAT C&C",
    "43a378a9e7c6572e5579e57a0e16c4c76f089288": "AsyncRAT C&C",
    "43ad82f2bb31f44c9d43dffa170139c9f3418ed2": "TorrentLocker C&C",
    "43b2091bb1cc23b00e1cb232d68fa3038aa10792": "Gootkit C&C",
    "43b8b7abd07e7db875d5c2495f5074d1bc1497c9": "Dridex C&C",
    "43b9858b9457cc10a021a4fbdad1d290f78a0213": "KINS C&C",
    "43ba138a61b97df778e29216252eecef9a5c2b2b": "KINS C&C",
    "43c9a4ced4410bfe02d4ae69428d764a0116e753": "BitRAT C&C",
    "43cbf3ff699b3ddc582917bdff41ed5913c7398a": "KINS C&C",
    "43dced0fb9415d53df980cf3bb80bc892e1dcb94": "QNodeService C&C",
    "43fbe0db763d3d6e3709ac8a7b4669e4b3d8e5ee": "Gozi C&C",
    "440075f2650e943111087335c92002c6d6da20b7": "Gozi C&C",
    "440c3b495f952a16cc5a82fcb4ec01e50ae7b836": "QNodeService C&C",
    "441b7661e2b201e414980a5180d15ac71cbc50dc": "TrickBot C&C",
    "442992b3e82796c9b38c65684cb1dc5e9ae55da1": "PureLogStealer C&C",
    "444c314e8a913ba69d8e40f0b4533d28778f5909": "AsyncRAT C&C",
    "446789002238261eca3856bc9f81e2f7c6be6afe": "AsyncRAT C&C",
    "4468ced956decf1439e9e4531362d1a394fae8fb": "Quakbot C&C",
    "44693a7605380b9da9f64e527e2b0e382202d9c3": "Dridex C&C",
    "446ecf82fa1aec7f00a047ffe24b2b597c9ac08e": "Quakbot C&C",
    "44770e573937dd930e08a42665c866c1ce882788": "AsyncRAT C&C",
    "447f91676e92665aa04b08cc1229ca65d0544744": "Gootkit C&C",
    "44966d7c275e9d28935274d8dd31a6598b7b8579": "AsyncRAT C&C",
    "44983614b60ed7f3360a7da39fe45c8d1e94c76e": "AsyncRAT C&C",
    "44ac70dc37af67cf18460e6ebd04b9581624ce4a": "AsyncRAT C&C",
    "44c07a2ff99bc110e1d8d04ec55133a63e4d674c": "Shylock C&C",
    "44c1626e4964d869b528261b44b0f202fd8998b0": "Adwind C&C",
    "44d218a87602f65f9e0021a1ad1e95189be8aaaf": "Gootkit C&C",
    "44d4ecb4ade081bcee23742b4909072e307a5003": "AsyncRAT C&C",
    "44de8f4bd78bb4ff83370286de5e4c0deffb8195": "Gootkit C&C",
    "44e5eb4d2b9b65e4b4441a0d397e96a08733abad": "AsyncRAT C&C",
    "44ec76d8386caaacd78fd90662a777c23dcc8b4b": "AsyncRAT C&C",
    "44f7f3c842a6f6d0bed5dcfecf3465179b2a8cd3": "BitRAT C&C",
    "44f8adec42af1fcd0280996c46b51086273917b1": "IcedID C&C",
    "44fcf51b2fb55efe3366ef2777a4959177b9c2be": "Gozi C&C",
    "45003a24f23fd076d3ba50e9aa1f69afadf18cd1": "Malware C&C",
    "4500f29c4434c0ef3e70cf7d63eaef69bf757fb2": "Dridex C&C",
    "450f887a4af0194eb581d56080a3babfbc1d12b4": "Dridex C&C",
    "451861a464eb4f8517d84442a619489839f8e491": "Malware C&C",
    "451a95ace7f48cd762c4d2e3e4a029439786adce": "AsyncRAT C&C",
    "451ea61cdc995a9cefaa821c490e427c3ae214c5": "PandaZeuS C&C",
    "4534bde6bc86c0a868ec74566c4cbe16e7581670": "Quakbot C&C",
    "4535bf9ae7e786d77ee482d74b9a22cbe099be2e": "Gootkit C&C",
    "453935d1b191a9d0d7476a5a3ac2428875f1bd91": "ServHelper C&C",
    "453ddce5e7e5f649abf4e489e6c3e252bc19fab6": "AsyncRAT C&C",
    "453f2f895d94402b546136ded9f34635eec07b70": "AsyncRAT C&C",
    "453fff432996f050cff7304b0b74f5248ce0c036": "Dridex C&C",
    "4544f891cb3c190366bc5d0d331ae17e254b26e6": "Malware C&C",
    "454b35f97d645e681dec92f2c0404167db166810": "QNodeService C&C",
    "455d8e384d214c17d34522413a98dc002352b78e": "Gozi C&C",
    "455e6be30d7786bc85bde4ba7eb909a75e88af63": "BitRAT C&C",
    "456914031e5d5788d6ad41b7211b7a01c04d7cae": "TorrentLocker C&C",
    "458d77bfcaad1be4f7fda923a94c16df8f700166": "Dridex C&C",
    "4598bdaba95157b5c5766f20ac2dc0d96b914a56": "Dridex C&C",
    "45a8f1dea55d947dfbd7447769c1582bddae8e14": "CobaltStrike C&C",
    "45ab47e522c3b5600618427db5c570a0cf2f1db7": "Dridex C&C",
    "45b6c8ce24f43ef76a0d6c172a05c0cadca23767": "Gozi C&C",
    "45bd0d3bc92ec04a4ec64d638e1863b06d3a8d4a": "AsyncRAT C&C",
    "45c52fe72277ad0aec85d06d8d335dc7e5806c20": "AsyncRAT C&C",
    "45e3f95f3b01ca7981ce44f415396b5d53ea2f37": "Quakbot C&C",
    "45eedc152073582614e2cd382ce52863f570bf35": "BuerLoader C&C",
    "45f80817d011664f233db3354940e08012886d17": "Quakbot C&C",
    "46073f8bc2f994bb8f7931f154918e1a200cd52d": "Dridex C&C",
    "46263f945d8ec0d2d1e2cf97e9083efab21cd81e": "Dridex C&C",
    "462ed40626793613c739dd0456a98dbbad10a818": "Malware C&C",
    "4633e10aa763b9f960f69cedc63d6ab18b3f2380": "Quakbot C&C",
    "46371330700611773c8fdf04d60a84b00b0aa5fb": "Chthonic C&C",
    "463e044c0adf20fc8267fec7f648d8a6195b7187": "Dridex C&C",
    "464bcded2595722c00c244709806b64b95fd52cc": "PandaZeuS C&C",
    "465be3ddee3c514e51ae9877ba54d16522d9ae8c": "Dridex C&C",
    "467705f53be6860cca861e30a562997d9bad627d": "AsyncRAT C&C",
    "467be7aceefb78e795ad38521d4b4f9191992467": "OrcusRAT C&C",
    "4681f0e7e7b6ea90cdea2223ca9cd70166b046a1": "Adwind C&C",
    "46aa930d144ea327eed4c33c4402233d520c4f8b": "TrickBot C&C",
    "46bd7bb0eedb1b0e055230eeb76ed1dfdb41dafc": "TorrentLocker C&C",
    "46bd9297859e039f9533980e270ffcd3c23b0295": "AsyncRAT C&C",
    "46c0ba6847ebc766cc16ffc1d95d9dfcdf8ef33a": "KINS C&C",
    "46ca79cbfe52874fbae298108c3a75c4911bca0a": "CobaltStrike C&C",
    "46dab7a086be277c88d4efc7b2a087475dc30949": "RaccoonStealer C&C",
    "46de9d8b9e02637401bd242806ba18dcfac8fd4e": "OrcusRAT C&C",
    "46deba70b2f5e17ba854cf0226ec5bdf8fb0067b": "Vawtrak MITM",
    "46edd8d44951650a5be5aea5fed3914cdf5a3ad0": "Quakbot C&C",
    "46f0f03f6fc98c7fc6e70fd2d7bdefcdd5116f73": "TA505 C&C",
    "46f16df30911fc3f3aef088d206a873236c870ea": "TrickBot C&C",
    "46f5e2fd0e153d61900445f9bbd5d90026db917c": "QuasarRAT C&C",
    "46f788b5d3915a151823a5d4844029955e4fd6ee": "AsyncRAT C&C",
    "46ffef697f4021093660586dbdfc0087a0489571": "Dridex C&C",
    "47122f7861b7488f6711c999e40caaa5e560630b": "Rhadamanthys C&C",
    "47139bbc3c5274a9e4444367ae51ab2265f850ae": "AsyncRAT C&C",
    "473bfca8b7e88556482731549abeb9659aa1b8f8": "OrcusRAT C&C",
    "473ff424c0392f3ce90287e35ef19c3413119e65": "AsyncRAT C&C",
    "47464198fc475a2ea1761838b1f80deae799d05f": "KINS C&C",
    "474daa5df9cfd4ed6f2d0d024ae94c92a76a60bd": "Malware C&C",
    "4751d4a2bb7e4cae6d51f743c73c2d5f92530be5": "Adwind C&C",
    "475d443b1c1f0636dcb68b8d8513a1fc9965fc70": "AsyncRAT C&C",
    "47605347534161675a96f7fed3f05f85417a339c": "DCRat C&C",
    "4777bf5f0de57fcfa0b0e18a728a86957b99863c": "Quakbot C&C",
    "477df74e79b930feaaf92bf504a229eaecf8eb25": "Gozi C&C",
    "4785083178d87eb2ad342d8849d0672ae29f1744": "QuasarRAT C&C",
    "47884c3fad44950dd46ee5bab753ea8adf823418": "BitRAT C&C",
    "47888750b56a105263fda90a5a87354c41f43ba7": "QuasarRAT C&C",
    "4795eb97a05ae5f4e669d4b7fff6608d94fc9027": "QuasarRAT C&C",
    "479d98c937fa9d89e76cdbc276d4136cbb7e2c8a": "AsyncRAT C&C",
    "47a02af8d665c8710fc431b452ccba46fa172984": "BitRAT C&C",
    "47aebdb0a0836d26cd342e3757cfa22eebde8baa": "BuerLoader C&C",
    "47bb5dec744547f62cc678b0ac89733cde514039": "TrickBot C&C",
    "47deb622884518545da4f800242638faf99dfc91": "AsyncRAT C&C",
    "47e512d9b8b37801fc0bed77f2a10d61d54ae572": "TorrentLocker C&C",
    "47ed3656a93ea5bbe5350daaaab288dc356d9707": "Malware C&C",
    "4800507318a6dc985496a5463f86499096ab10f3": "Dridex C&C",
    "480f1001358288473085a54b5d11246f9ed4b188": "Quakbot C&C",
    "4825f4a2cb224d1174bea71004356b943e42a2a4": "ZeuS C&C",
    "4830df5dda220b596e1331621474ba89fbaa5f81": "KINS C&C",
    "486aafc0058ff15e080cedc549d0f60d64fb91c1": "TrickBot C&C",
    "486e3fb277a25b9f4cb6a2f109a0b517f815193f": "Gootkit C&C",
    "486f40e19a9e3ea53a10785811269ddadfef1e8d": "OrcusRAT C&C",
    "4874594cfb32ce7c38d453b3ef56b835d43dd2ac": "BazaLoader C&C",
    "4875cc103716818a007756365965dc137158b1f0": "AsyncRAT C&C",
    "488287cad10b680dd3ab4b416b8fb0a26afa67c9": "AsyncRAT C&C",
    "4884f75f6b4c318afc86632df4bfd657308a3628": "TorrentLocker C&C",
    "4887f01e3b9ab0aa944cc5fe4cc7cd7c595c6659": "Malware C&C",
    "48998f33d02ea1266a95f46f37562d54000bf6d5": "AsyncRAT C&C",
    "48a117aee3bd89228df65f0978073a12b2615340": "BuerLoader C&C",
    "48a96c06c41377bac8d2c1d2df33681c3a6956d6": "Vidar C&C",
    "48adff041d35a89cc2a9df5d80fd6579c240c8b8": "ZLoader C&C",
    "48b9564072a61660bb620bbae431558524cda74f": "Dridex C&C",
    "48db2aea3ecb1ab4441338685d35b9653e24f4e8": "AsyncRAT C&C",
    "48fd38089871b87f2e6b1c4a5793ce67ec5e818e": "Quakbot C&C",
    "4902c7e0f27f35a0bdcf1dc34cdbd0dd90c404f9": "PandaZeuS C&C",
    "490ecce4cae8a0b1ea807bb6d3663c2d08f7c659": "QuasarRAT C&C",
    "491876522bd298148c46937ec5b37bb363669df7": "BitRAT C&C",
    "49329a24bcb298d8fb9247fdb2d779c513cce642": "BazaLoader C&C",
    "49398e9d0b1716c067f546b35dc2f6c2b32d1a7f": "TorrentLocker C&C",
    "4948cd471fd293a92d4fb68d870cb0be545db926": "TorrentLocker C&C",
    "494d4ba855f13e46a490fb9212e214b8814bfea1": "BitRAT C&C",
    "494f0560e120b75b107ddc3a221758cc152a8385": "Gootkit C&C",
    "495daa71be4c93361272ebbbcef6009a46fddeaa": "Dridex C&C",
    "4964a6d2e876a5adc3769d9298f5c07714091cf1": "Malware C&C",
    "496746fdbb98f4d848ad62b14cb380600f184ee1": "AsyncRAT C&C",
    "496b5d55929e4df8b6d5565c30100e0d27c0d069": "AsyncRAT C&C",
    "4974f2b8ff674eb3af28b852a4c854e6a34329a8": "QNodeService C&C",
    "497517a679098c1b2dbbbb3ae51d68e29a9bd557": "BitRAT C&C",
    "498934345cf35bfb0083d3ed7f64db3939b8a839": "BlueBot C&C",
    "49987f4cdfa4d24ac2de713fa251f3733f7df62d": "QuasarRAT C&C",
    "49b767736a0cee6c3c0470f1defa1a586d8eb96a": "OrcusRAT C&C",
    "49b775b0cdae2793141e4923bb564147d83f82d4": "IcedID C&C",
    "49bf5a48970d914c7e70f494a8e16b5efa3ab6a0": "QuasarRAT C&C",
    "49ea065dab9deadc766145e7210ec23242f38e27": "AsyncRAT C&C",
    "49f27d39c4f9ed9fe3cca06bffb957583264ad3b": "DCRat C&C",
    "49faf85c97bb43af1e641011d48ab0ebc58c478e": "QuasarRAT C&C",
    "4a0335273f262e32be7595b2cdac213c2f79bd53": "QuasarRAT C&C",
    "4a0557913a4b6e5a8e69745b41149e5b16f8964f": "Quakbot C&C",
    "4a070497081dfaf89f324f4896a91edb9c425c0c": "Quakbot C&C",
    "4a136f05b57f0442b7fcaadd1368d748446f1ea4": "DCRat C&C",
    "4a23179249b1fa855597f4f82eb997f23c26b614": "QuasarRAT C&C",
    "4a268fea4cde0bbccba9429002a1e4fc638e58b8": "Quakbot C&C",
    "4a3a4e20c5207ef834e7fef6fbf89fe05969d2a2": "OrcusRAT C&C",
    "4a48decfeb6a4aea4410a77ad308f1b0108ceaa5": "Gootkit C&C",
    "4a5171cf80f8d9950be32fe3dd220a92a3116fa6": "Dridex C&C",
    "4a545fcdb65b433b8b0bd6186bd9b371f14f1ad8": "Dridex C&C",
    "4a58112d591850450fd539cdf86fd1da9c66e170": "AsyncRAT C&C",
    "4a691232210adeb583e11d54999d4f3cc90ec82a": "OrcusRAT C&C",
    "4a6de860d483637c00657ed03150cf20a6f25633": "ZLoader C&C",
    "4a7bdeaf428406baba73d725171ba6aa070792d8": "Quakbot C&C",
    "4a80cc5007e923823effdc4fb7fafad0628026b4": "AsyncRAT C&C",
    "4a90b8956d73dc5d1a2fc8633f6bb48ce9239068": "AsyncRAT C&C",
    "4a9a974d5ce5cd5a785cfd01ff26b5dc812cc371": "AsyncRAT C&C",
    "4aa02828567a232798763f7531ce90e0167ef9ab": "Gozi C&C",
    "4ab3d75c4d15a775686b1921a38259d9eae64620": "Gozi C&C",
    "4ab71173657918b6b7fd00cbdba6b572f46eba79": "CobaltStrike C&C",
    "4ad22dace37d1ce4454ea0d02debd58ef43d660b": "Gozi C&C",
    "4ad277c5b7fde7ccab014a6559b7b1cfeec0218f": "TrickBot C&C",
    "4ad3abefb8ce8193f5653abe3ad2d92dee625492": "QuasarRAT C&C",
    "4ad59d3bf643ce1b35da6ebcb564af0359f0f036": "RaccoonStealer C&C",
    "4ae4bfb137f176a9efe07c07349dd9c18ac30bf1": "Dridex C&C",
    "4ae5a579dbe6c2a230fd1821ecb99e2f3ccdfbe9": "Ransomware.DarkSide C&C",
    "4aea815804d89286875eb0547008674bbacfdbca": "Gozi C&C",
    "4b00c23c4200f2545ed2eaa1d4f82f7b5eed9df0": "CobaltStrike C&C",
    "4b059a6dddedfc62a00584478672facbd9f2e3fc": "Dridex C&C",
    "4b1d64c1637aae427aa07d6c756c13b977715603": "Vawtrak MITM",
    "4b64bae5ad7293d4a31b176d9935b5d475719d73": "BitRAT C&C",
    "4b6c675590f8f3e1bfaf18e42bf037feda8fc9e6": "AsyncRAT C&C",
    "4b8b11e5bcfd805cf07e64f823de37eeeb6d7ea9": "Dridex C&C",
    "4b955d2b7bb2e7deb6688b8e0c1357857437c0b2": "AsyncRAT C&C",
    "4b96aa7371b9d55df6f92e9ec8075d93a31155f7": "Dridex C&C",
    "4b9c1b7366162a65f20fcfae7404326adc5a9960": "Quakbot C&C",
    "4ba1e8855b47ce1619e2baef19dbce1df5b3eb2c": "TorrentLocker C&C",
    "4ba43c2c746a17d8429a997827fd897a4364e2d6": "AsyncRAT C&C",
    "4bc8d66248dd64b6f35558c33297a47602d85a9c": "KINS C&C",
    "4bd10c594b1f75b6af86e99383fe077e4b14d296": "Dridex C&C",
    "4bdd42de62856a64315d2dc612b3ce8794f90895": "Quakbot C&C",
    "4bfbd8d9a5719c9b1f19415ee940e6f2b4e851c0": "TorrentLocker C&C",
    "4bfd1a63d24e3eb102c200d9dbee28835f5ad77b": "AsyncRAT C&C",
    "4c0ceb0914d93ea85705460ecd772d865bcba3a1": "Malware C&C",
    "4c17e173f746b68cbc68eb38e6a358c0544ec718": "Dridex C&C",
    "4c1c1aaa5880317458798a04db76428ece55f140": "KINS C&C",
    "4c27cd564b05486119e47ec299f476c0f9f0dbfd": "Quakbot C&C",
    "4c319ec8b5a66a256a0137d70cd0f9a76bb23fd7": "AsyncRAT C&C",
    "4c3a66ec938719d1b92d0018cfed49500aa9aac6": "Gozi C&C",
    "4c5dcd6a01674a5c3f141e970aa5b11cbd8df778": "Dridex C&C",
    "4c8d70ec7efb4b3806ef1e8649dc9f4738a27c98": "Corebot C&C",
    "4ca091a99acc47c73f948a749a621a9f50b58a5e": "OrcusRAT C&C",
    "4caa72708ac98639ee067a2a11b864fac182f0a8": "TorrentLocker C&C",
    "4caf3f1cc0086325ff3006b7a264a32d2d93d37a": "BazaLoader C&C",
    "4cb7816f238214b35070ce972ecb6d388a913302": "ServHelper C&C",
    "4cb83103c463052235b64c3b2656049624708352": "AsyncRAT C&C",
    "4ccbe21d74a8b2066c143e18390e5bc86c4a4368": "Malware C&C",
    "4cd59b2fcd10702a001c190a3b01d88471d7533e": "CobaltStrike C&C",
    "4cd7fe36f55cc8ead23e764e8c0eac4767e752ba": "ServHelper C&C",
    "4ceb549c9acc186e22fd314b1dde55399d7d53c8": "AsyncRAT C&C",
    "4cee86a4a3dffe67ff90dc30e4dd7692fba2d1dd": "PandaZeuS C&C",
    "4cf13433ad8784cae053fe51a38643a8b5dc2b3e": "TorrentLocker C&C",
    "4cf359be1c8849b785c33e4fdaf13f48228b8def": "AZORult C&C",
    "4cfaadec5cb5e4ac6fd75421a6accb7a5fe909e1": "Gozi C&C",
    "4d0f1f0f9685eff124e56a31192a2beae788d88b": "KINS C&C",
    "4d143a5b5f5fe1428fa15b944e13a79f14aba985": "Dridex C&C",
    "4d16c33b6525c2d3d482a32b8cca518e4c0cf9f7": "BitRAT C&C",
    "4d3975517f835248a5c428d210f96973344c534b": "Gozi C&C",
    "4d3e570bfe824d295563a290605bb134039aba24": "AsyncRAT C&C",
    "4d47e2a19fd90192dc3b2d1789a060372bc5cd48": "Quakbot C&C",
    "4d561c674610b1521a1e0b2b223279930c47007e": "AsyncRAT C&C",
    "4d6ce63030ced85f183231c5a6dec50b35dee7ce": "IcedID C&C",
    "4d7ee547535bffdd2d27034fc7eac1a3cf2acadc": "VenomRAT C&C",
    "4d861b8a8650e3e6f145e47da8ea2dcc7bd43883": "PandaZeuS C&C",
    "4d86d16300c82fa53d306290912ec4afe2749f36": "BitRAT C&C",
    "4d8ae62d0ce12e00ef3a4b1b14b3139a761cbe66": "QuasarRAT C&C",
    "4d8dc80054356a315548669b9f9e9416dec042ba": "Dridex C&C",
    "4d8e9319ba4b8d205dc7c08d280ef00f460898cf": "PandaZeuS C&C",
    "4d973d263ef9788acf4ebccfbc5afb960e25a903": "Dridex C&C",
    "4d9ddd9eefd45886532adc566ea5e8b99b9c2546": "AsyncRAT C&C",
    "4da14224452c1fe61f46b1112c43ecfd9f322c82": "Rhadamanthys C&C",
    "4db1ba4ef3ca53dd88dfa09420a076912bd5b956": "Qadars C&C",
    "4dc1bd19a1cc3d43232eeeea1f9976561ea4d215": "TA505 C&C",
    "4ddd49700ab52e37c78d016f144d65727cfb2bfa": "AsyncRAT C&C",
    "4e063cd8a403641d037929a52ebafa47d47f8afa": "TrickBot C&C",
    "4e0c78385eabdae8ec84329fee838d446c2bea08": "TrickBot C&C",
    "4e1c98bd2640f3ac8e1c9ab20cb835bd33b79da1": "Dridex C&C",
    "4e293e899910ef7435ae25e28c082420d748f8bd": "QNodeService C&C",
    "4e37fce8596565789fd873422fb7742722767064": "TorrentLocker C&C",
    "4e38b276fb2d3adedeee50ed3aa0c0d86589e24c": "PandaZeuS C&C",
    "4e4a0b29f8f5765f07f7f84b244c185316c5b96a": "QNodeService C&C",
    "4e612d352fe600118dd54b22e77961181e0804e9": "QuasarRAT C&C",
    "4e6a4b497681b4c09e2bf44c656fa4b8c376aa37": "Gootkit C&C",
    "4e74836afe9eec154e6839d3d05454e255fee2a3": "Malware C&C",
    "4e82fde55c2c527c1d2c3a3a5b569ee61c4cc3a1": "BazarCall C&C",
    "4e9f6744a02c5613ded827bfcd91e5a1775818e5": "TorrentLocker C&C",
    "4eacf7ce463dffaeb240cbd97a09f0dd4208e748": "KINS C&C",
    "4eb569e30034fd389f24af2bbc74740356403854": "Malware C&C",
    "4ec0fbf2d44886ebeb8b960d150727262480ac01": "BazaLoader C&C",
    "4ec974448fe04ab3697ac708cc6542efd4b3e46c": "KINS C&C",
    "4ed2b04c2579c3d4ce655d707eb264a96f6a0327": "AsyncRAT C&C",
    "4eeef583ffe158ea511e3208d82e03756aa79132": "AsyncRAT C&C",
    "4ef1547b5db5058dcceb6a60d48a54c35026d8d5": "QuasarRAT C&C",
    "4ef2cce6edaecb12652259cdf9815b656d1da27a": "Gozi C&C",
    "4f10475e13d14881530aea9ef64f67f04241f14a": "BitRAT C&C",
    "4f32170b76e7a393a69306bcdde027d29c8924ec": "KINS C&C",
    "4f477d33bd995632c6f46fbb828125b2b832e5c2": "QuasarRAT C&C",
    "4f4988b7db2630641b562790b0fbc9693f4cf7ae": "Quakbot C&C",
    "4f678d318586381a7722e5fd88145e91e7b30d2c": "Gozi C&C",
    "4f7d628b38ca922d6bb190220b885cbe1984e30e": "QuasarRAT C&C",
    "4f7f8531cf375b2759da14d3a3a2bab30bccffad": "Dridex C&C",
    "4fa99c8bc17b90c2e36120c34f12eda47477d7ff": "Dridex C&C",
    "4fb4c81ef5c1bf0e2e533d8c46634067a15f25fe": "KINS C&C",
    "4fcc70afddffd834951433cd38e08a55a0d4e900": "ZLoader C&C",
    "4fdcc62bdb0a66c1e32adf81d99e9409de5d767f": "QuasarRAT C&C",
    "4fe275b29402d87b9453b76be72f63a1b5d764b6": "IcedID C&C",
    "4ff36a9b0ddb2aeada45e3a93847a33852886853": "Gozi C&C",
    "4ffa3bad4e19abb8f28816d38f8fa2128f4e46b7": "TorrentLocker C&C",
    "4ffab6863cc37fa2bdb1b64496adec4561070472": "Gootkit C&C",
    "4ffbee3013a464df8ad3423bdc0aad40b1b112f2": "Dridex C&C",
    "501c8225e87b6fb858df2e05937509dd33a34b58": "Quakbot C&C",
    "501e280c05ae94fe21d7b74db60860b7636a9306": "Nemesis C&C",
    "5023e172981bf4708d82ce4bbdd5a607d6c1631c": "QuasarRAT C&C",
    "502c918952cec33ef1f03094f9113c70e67d4f1a": "Gozi C&C",
    "502e4e7092c6dafa75586c10d7cc2d5bd9ffce8a": "AsyncRAT C&C",
    "5039c2e2958a26393e50037fac0446c5248f7f88": "AsyncRAT C&C",
    "503e00ecf0bbc9389d72944f71a9485a0d87755d": "AsyncRAT C&C",
    "5050c6c789d71ea7af3e0a1411297c25c57945ed": "Gozi C&C",
    "5051275d21297becda89e4ad67e36d34d52ca179": "QuasarRAT C&C",
    "506bd97e7ed0f9758bc544c300f722732c01b49f": "Malware C&C",
    "5085133cceda8ece760f4e66e87777533cd9dafc": "RedLineStealer C&C",
    "509df02a7022bb5da85fcf556bac689d664d6d4c": "IcedID C&C",
    "50adf0203f3d9102a6424819ea36e4dd5e38025a": "URLzone C&C",
    "50c1e861d02ca23505174ef7c074a8636cfa5f90": "Gootkit C&C",
    "50c83b6006ba4761e260aa97fa95f98f9085ec82": "CobaltStrike C&C",
    "50ce57063f81527b3257f476924b7a783c916ce8": "Gootkit C&C",
    "50e763a940d095710e09c07edb0f12692426a0c6": "Malware C&C",
    "50ea19986300e1f313d781128f6fdd8b8fef57c8": "Quakbot C&C",
    "50ee4fd682beec0b482640b4cd45b170d8d544a3": "AZORult C&C",
    "50ef774f2d86659b55e2411f3790199ce3fa3c5e": "PandaZeuS C&C",
    "51089085e7dd7c309d4c834fc0db84e5419b07c6": "AsyncRAT C&C",
    "511a8a5c4ee09140fc38d57fdc3c38db9d5715db": "AsyncRAT C&C",
    "511cdfe4eb4b2aa10b6e4e153c7f8d2fde0baaa0": "BazaLoader C&C",
    "512263416240f664f5b6c8e765498c0ffd45729e": "TorrentLocker C&C",
    "512827b9db3a35da94e5807a71ddf2d12854d615": "Gozi C&C",
    "514c275606f0491b6600892c7e527852d9432c2d": "Shylock C&C",
    "5176d7ea820b96f766b23c17c366ac4d950e37c1": "FindPOS C&C",
    "5177b2282858a4e755b1980a657cd2cbd4af324d": "AsyncRAT C&C",
    "5179ef06820bd5323b5b2b1f0249794cd7f25d4e": "Gozi C&C",
    "517b6af310f70f9d9d943431b2742926714d0d0d": "AsyncRAT C&C",
    "519af40067c719749b8626479fac81c14e248b48": "Quakbot C&C",
    "519bf06684ebdb7e5172bc6153181d9aa85f27cd": "Gozi C&C",
    "51a405e1791e14af11208387348a1399e6e63195": "Adwind C&C",
    "51bc52465d5a6028cc939f0cdf93981bef6962a5": "Gozi C&C",
    "51bd25d56619187facf38a5014cddb49669a84f6": "AsyncRAT C&C",
    "51c05bbcb0baae6481370c47d6c638fde8685925": "AZORult C&C",
    "51c6e4d34c37e031a2392ef8981e14cb1374ee89": "AsyncRAT C&C",
    "51d6643cf468549810175ee49f8379f7606aebd0": "Dridex C&C",
    "51d932051a797e9c73fa52097f019e26699f26d6": "OrcusRAT C&C",
    "51e4aa3b04782dc6222f0ba1275b1f5de0951bf1": "AsyncRAT C&C",
    "51f2d3af6fa3fbec031d6b606afb6a512749cede": "BitRAT C&C",
    "51f81c3866685cc2fd3d82c46d7e9d0a8059f06e": "Quakbot C&C",
    "51fa6c8107cde55976a035992e490e6f100a1ca1": "TrickBot C&C",
    "52160f0433ecadd78669567fb0ea3e6dbe586261": "Dridex C&C",
    "52486e1b4990a1e0f54c29b5d61e32b72a4b94d7": "Dridex C&C",
    "525d1186844863e1859360619be7d4af2165af1d": "BitRAT C&C",
    "525d2ef8dff4e72119cecb764748285c53f21327": "PandaZeuS C&C",
    "527099bd97e1c8e877091378066e918b1563ef8d": "Gootkit C&C",
    "527831abf9ec62b08c759c9c146fe9c38b8c694a": "Shifu C&C",
    "527b13ac93094f4e7c8ece75ff6878f0685241ec": "QNodeService C&C",
    "527bb47fbce634b622978f024966681c7d71082b": "Dridex C&C",
    "528d9d1dec94e346b834d420b7d8aa79c9dc434e": "BitRAT C&C",
    "5293bdb3680e323126b7d71396e15395af39d9a3": "Vidar C&C",
    "52a252a714d391228c4f791b4a0bfee13df36a93": "Gozi C&C",
    "52a91873f745b4491709b1d166d169769021bd00": "BitRAT C&C",
    "52aac154071582b32fb4e9f2ca1937faa2ded4fb": "KINS C&C",
    "52b6df64f92cc95379365c79b227cdf6fe1fad5d": "Malware C&C",
    "52bfe9b13e5cbac49794cc83e1f34c3c538083a0": "TorrentLocker C&C",
    "52c5bd2348333d832ed34f8d9d76b4d84c1e3a9e": "AsyncRAT C&C",
    "52c881ea52f0d290473b6a0595c1942d0c8785ec": "RaccoonStealer C&C",
    "52c91beacfdf24ddf2ffbbceb32e61efd86db70e": "Rhadamanthys C&C",
    "52c99b8b5c5d6934ee8cf8d15c84a8f7a12a57ed": "DanaBot C&C",
    "52d93148bfa06853df1582301fff21120a0b1796": "DCRat C&C",
    "52db5aab6299a4fb57f36983bcfde6793abd5687": "Quakbot C&C",
    "52db97a80cdc42b424cd842f1b2fc03c8cee66d9": "Gozi C&C",
    "52de995a2469c6fd5f434b1e9a328799558926c9": "Dridex C&C",
    "52e8c59b8846a016b2c00e7d07c9f09f50f70b81": "Dridex C&C",
    "52ead7a03c1c6689b29f234290ab5a49ca0b0070": "IcedID C&C",
    "52f64f54e23f6ac4de36ea6e6ed98857227cbd5e": "RaccoonStealer C&C",
    "52fbd8b60b564f4936824dc8226b5c52505ddddb": "Dridex C&C",
    "52ff2fc2519cffd61b48db6215c4b18eb0090a95": "DCRat C&C",
    "533160b4fbccb21a34ca963e15473d987aad58f1": "DCRat C&C",
    "5336381a246b848e4dab1f248fc75cd4b5ce71f3": "Dridex C&C",
    "533971787f4a42c8b4c30b1322058d8338aa6144": "Dridex C&C",
    "533a4d578c8948a53825ca52e3705f2f269b588a": "Dridex C&C",
    "533db50c5bcd82d72d079c2aa843aa57cfe69d01": "TorrentLocker C&C",
    "534734397c0fa9a1d28f061ad75df4100bff5787": "QuasarRAT C&C",
    "534a699da77337a8c4b76c55482a5038ccb61702": "BitRAT C&C",
    "53584969dc1d06b9153c78ef29846db0457efa87": "OrcusRAT C&C",
    "536c7fa55bb42078b319b5197e6aebf9cef3db72": "Gozi C&C",
    "536db0b06cbe1c92f30d817f24b646cf8494ce31": "ZLoader C&C",
    "537c76842ea741976cc4fb645ecd47a51718366f": "AsyncRAT C&C",
    "537fcc1fd2e99fa758c68005a73229f80a676606": "Malware C&C",
    "5381adcf3c17b7f862281a5a08920692e50c45f4": "Dridex C&C",
    "5386b21e8df07d7296cd933de240c609da5464ad": "BitRAT C&C",
    "539512b45a6b0e13c5733e3ef50ad7ab6695e1bf": "CobaltStrike C&C",
    "53b2df9d44f4eb56c2ac24c1f5b724f27b66ef1c": "AsyncRAT C&C",
    "53ba46ad70662e1d3eebce454cd4062512f717c8": "Gootkit C&C",
    "53be8a62368d11ca6d9051bba2894d19dbc13e98": "BuerLoader C&C",
    "53c8881e8ea00aa1270e23322b403f8657e028dc": "Malware C&C",
    "53e7c3c6cd355eab07f43b18a80604834f4ce5fb": "Malware C&C",
    "53ea6643efeb0f3f88acde3459d95d9515d8d6f8": "TorrentLocker C&C",
    "53ebe91628432d2d1dfd42cb2a998bdc61bb024d": "Dridex C&C",
    "53f353bf17fb83809c7a3669ae72b08f275855df": "TorrentLocker C&C",
    "5404fc7e892763f16ad1108e5cee825a5db6fc69": "IcedID C&C",
    "54068589045384515a4584883c7d39385354c8de": "Quakbot C&C",
    "5406ece23c1268548e39d28388c33ce1fc4be310": "CobInt C&C",
    "5408d22b1786246723bd60fe82fcf930b42b10e3": "Dridex C&C",
    "5410844ffd3e3fc65f1ca3b7904ff2148192867f": "PandaZeuS C&C",
    "543b6adf0c6794e27e181f8f1281700e00f697a0": "AsyncRAT C&C",
    "5440e8d0187cd8734ec2409b8967417f2923e615": "QNodeService C&C",
    "54568c967d5d5cdf30206141387211da6ba86fb4": "TorrentLocker C&C",
    "545fe2349ae30645dfba8461455cdd19084439a9": "PureLogStealer C&C",
    "546d66a723cf6c4586cf0413f169597c3586394f": "Corebot C&C",
    "5471511e19eed1a64ef4ca4d4711948041745f21": "AsyncRAT C&C",
    "547c2fb11a13671c4951d613cdaba9f2f6a0161f": "Malware C&C",
    "5484dbef83467aba83c0e638c0661b7e312bb1f0": "IcedID C&C",
    "548ee6e2cd5279c71f4df6d84c0d11b7f0363721": "PureLogStealer C&C",
    "5490615e13fda292cc46b5c50a639cdac26dc07a": "Malware C&C",
    "549263bd72dd751a0e0dbf721dc74ba5195e3493": "DCRat C&C",
    "54b0ac0bbc4d2e7eaf81fc8ea2efc22d86cec64f": "Quakbot C&C",
    "54b1a952c046bfcfc32f247ce108dd79156aaa64": "AsyncRAT C&C",
    "54c030c8d7b56f42502fa9c86fa705574809445f": "Adwind C&C",
    "54d4b6c48ed207e2a411e0d804088d9ae000c85c": "Dridex C&C",
    "54e13bd7350176817c2a0c589967ea7e00199357": "Malware C&C",
    "54fad4708bc4f7a7e4c608b1eb9dd27a3187263b": "AsyncRAT C&C",
    "54fd0d8d9188290f21c470e964b0e44dab0b19dc": "Dridex C&C",
    "55004483a0ff8aceb9e1c65df40761d7457663ad": "Chthonic C&C",
    "55008fce9054e47b5b1461b766c2443bb273c4b1": "Dridex C&C",
    "5509e95f7331a6f65427dd9a3c82a91669e0c554": "BitRAT C&C",
    "550ce633bb6dc4d572f1d52b918012c266fdd718": "Gootkit C&C",
    "550e1cde5c59d03b6f3b9bd3ebfc4af6c7dbec48": "Dridex C&C",
    "55291c87ab7008b4a2310e223574df8928c75db2": "TorrentLocker C&C",
    "552b287c36d53f9d00c26151090ec6d9482ea341": "Gozi C&C",
    "552d2348f101374db7d9a3249f4fd9a37f5270cf": "TorrentLocker C&C",
    "553cbb17c65d590a0374048c65489ca9021ff249": "AsyncRAT C&C",
    "554435b1c4ab1f241a08a7a08a188a05d37f5a74": "TrickBot C&C",
    "554f893c80d06786f7ca89693ef8a58ef2b417cd": "QuasarRAT C&C",
    "55833267b862bb543310a65610484ca0ab62e666": "TorrentLocker C&C",
    "55abbf415e485192b1bb1fdf7ed1212dc986c351": "Corebot C&C",
    "55acd543d56abec1956f2d5a0b29e119bdd8a0e6": "Dridex C&C",
    "55ae985ba6453d5cd74337f0ffc80753baecf441": "Dridex C&C",
    "55d1224bce61e06d06b38192ae12004b07adb753": "ServHelper C&C",
    "55d35fb2df020f4068e690909e68db677923e19b": "Dridex C&C",
    "55d72e3e7c4450b2f1356dced3be706cb48864d0": "OrcusRAT C&C",
    "55e02c78e8a0f85fab9f05824647aba712e7b0b7": "DCRat C&C",
    "55f4453623477bbbddb5ef8709efc93e300f3535": "Malware C&C",
    "55ff21477942a2adafbc0adcd4ab5857b24a71d5": "TorrentLocker C&C",
    "561a72267ade93d27c59bac17e08ea411321548b": "PandaZeuS C&C",
    "561eb48716285bbb84ce04c9bd1a1531b9f3e0bd": "Dridex C&C",
    "562a2a148a57d83f6d81aa64b08f26fcb82058f9": "BazaLoader C&C",
    "562e7f2f7b3d5913a6ca64f25854d131e56c4ff7": "Quakbot C&C",
    "56336f6152b23dca860fa189975204589c598b5d": "Gozi C&C",
    "56564c88fff339a77309d39f97fca5618ca85ecb": "Dridex C&C",
    "5666476ee83f70a6ac219366d7aa67b6c19cd929": "AsyncRAT C&C",
    "566705fc52976b71a9ab48c4108f62d987099fc0": "AsyncRAT C&C",
    "56819c672fc1d97e95b9215ff5915cdc03463102": "QuasarRAT C&C",
    "568fb38f29a446a99c63bc31eea794853036deea": "AsyncRAT C&C",
    "5695629c539072e33395ea2cb381c97edb1ccf7a": "Quakbot C&C",
    "569837e0cbe35af9901d82aa3efbd02eae8735bc": "QNodeService C&C",
    "56a5df00770dcfc105ad5f489c9ad477b90df7d6": "AceRAT C&C",
    "56a9aa61d3667c96a3ffeb941cff22ee9ea8da10": "Malware C&C",
    "56b2e42c07c9266f599b57b37f4b0404bce6e911": "IcedID C&C",
    "56d7271a71d673a76b43f2a98fc910c2fe117f24": "Quakbot C&C",
    "56e8cc4d4dc3d89a87eff68d2ce5286992dc7e2c": "Gozi C&C",
    "570007a8a90f9a537cab39224af0956cfabfbace": "DCRat C&C",
    "570736ded57f298dcb0f3bf7d423a4eb726e2b72": "AsyncRAT C&C",
    "570dfd12b407695c2a046cd2caf5cea41142066e": "TorrentLocker C&C",
    "571fc6e9d1fc25e1c016a48cfa68d0901cef9f77": "Shylock C&C",
    "572efc1d71cb6a4911c14393f1825857793a1869": "Gootkit C&C",
    "5737ba25af59ef5e97b63b9a04ee86aa08b977ec": "AsyncRAT C&C",
    "574021bfd9fbdc88b63ce91383630a83e8464a89": "PandaZeuS C&C",
    "5742d4a59148a395c5eddae41c469f0894a7f277": "DanaBot C&C",
    "575acb1056e6e6898c3f063d4804c6d7e9d619e4": "PandaZeuS C&C",
    "57600086f446f893b99852b7e1952cf8979ffd4b": "Dridex C&C",
    "57813237d29518845b9d3db085c2eaa24dbf3c85": "AsyncRAT C&C",
    "5791fefc4808c73dfa297d6da678c0c73dcbf70c": "Dridex C&C",
    "57b7849a53f72b06da11bfac40879b0783aa4ff5": "Quakbot C&C",
    "57b7a77146f40cf0146fb75fab348ee28dd3c3be": "Dridex C&C",
    "57cdc8e734e55de5bc3e012c1137dab3af9babbd": "AsyncRAT C&C",
    "57d28ca6b5584440fbf1febe8762e7723bf11e8c": "Malware C&C",
    "57d57ea6a2d715fdf5e01a43a464df56fd9fa1ff": "AsyncRAT C&C",
    "57dcc7f7fadc43046b6a1e4a2ea0fc4c558c5464": "RaccoonStealer C&C",
    "57ec2b34c4c5742441effed05b54a38815a4e940": "CobaltStrike C&C",
    "57f667877c1fcda6663e2fdac6fb8cfde3cea957": "QuasarRAT C&C",
    "57fa5aa83b888e92bfa44473ab4f95d7265782d9": "RedLineStealer C&C",
    "58190db527639d7fdeeaab63b6c77121771c2ded": "AsyncRAT C&C",
    "5833ac02a590bf14e46f8ebd7de2713caf507af4": "AsyncRAT C&C",
    "5840c9e5bd8cb39de75bc28c20b9fe09eada256b": "Stealc C&C",
    "584feefcec6b7245bf82e4936e433d2ed6ac3a93": "AsyncRAT C&C",
    "5852492e6fb4119f448f154b6f7ece11251c03c7": "BitRAT C&C",
    "585bd2482905dc032c4249fb2bc177abec52f71c": "Malware C&C",
    "585cbe8aa2b6d50107c16d29a0f9e27da7ad51d1": "QuasarRAT C&C",
    "5860c1fbdc9c9914c3986390440f24459097d33e": "Gootkit C&C",
    "586cc950529af455107c1029ead6ee210dc815ad": "AsyncRAT C&C",
    "58706cc0c8da4dae3b6ba6808820be333e41862e": "Dridex C&C",
    "58739fad9de85e90d0faa14337c535a30f9c4fb4": "DCRat C&C",
    "58a177ffb40e14641babd651f130a91aab302234": "DCRat C&C",
    "58ac4d22d31e576a72940c4b45b098458acc6a7c": "Gozi C&C",
    "58aeab46c6cdfec4667f683ed15b84d541513857": "TrickBot C&C",
    "58c4c5d0873094ae1553fa3d7b5a033d75bbdeb9": "Dridex C&C",
    "58f271bd587f8e0e2594769ee8435b49d2f8ef5a": "Malware C&C",
    "58f761b1fa52403ab850709f13350e07e1295b62": "AsyncRAT C&C",
    "58f8fabcaccfb77ca54815d1c813023fc870172d": "Gozi C&C",
    "5919bed195e8c50719a64d610fd65742d31e1f32": "DCRat C&C",
    "591c0e6cf0e5024f4405b7ceaebcb512766b4380": "AsyncRAT C&C",
    "592bc72a43dedf222c7d4435e02dad0d8a8a2a55": "AZORult C&C",
    "593c9308f5965fdc0bb78d6b9055cd33c94c2b7d": "QNodeService C&C",
    "593ece78efc1a55a8e63ee092758c3af1a94ebc0": "AsyncRAT C&C",
    "594a00cbf13e2a75f3abfaecd0e4ceb0c4fe462b": "Malware C&C",
    "594d3c2a3871d155e49e33b097e7f4d17fa17655": "BitRAT C&C",
    "59527a7c3b1231c72988585a5777f50976968561": "Dridex C&C",
    "595589943db1507250b02ddd3b7b4424bbbfb679": "AsyncRAT C&C",
    "59615b462f9c3958a9beacbac2db85606d6c2357": "TA505 C&C",
    "59629a72dffb81c2054298397674200059e4a910": "Gozi C&C",
    "59711bd3b823351fb5ffe685100adb6e7b1549cd": "PsiXBot C&C",
    "597cf696f8e2b18d01399bc4a0611acb557b4d36": "DCRat C&C",
    "597d94ab682f74ad4221b62e302740b2fbc833a8": "CobaltStrike C&C",
    "5980320f98881d4b53f60f822fd149fb084a5538": "Dridex C&C",
    "598348c9b87a059ce668fbf1073efd83c300108e": "AsyncRAT C&C",
    "59996a91fccc3665507b53e03817bfb1922b31a5": "VMZeuS C&C",
    "59a0e463b752672b045368cd0e5f4f2b90ba34f5": "AsyncRAT C&C",
    "59a21c17c6c9bf8ad2afe6e353385dbe556e69ca": "AsyncRAT C&C",
    "59a92039f951e5069c9f50fd9f340e759713b058": "QuasarRAT C&C",
    "59b19bf434118d75adc14c66973cfde3e4dafcea": "AsyncRAT C&C",
    "59b365979cba4a770b425ef8dbcc71d0a420c4ab": "Gozi C&C",
    "59c1d3551cd54355391072030d21577ac65a4983": "Vawtrak MITM",
    "59cbdd7a37cbd4d7aaee444ede7b4682fbb19cb8": "AsyncRAT C&C",
    "59dadee6d837d3f49fe04d422fecd2a6aafa2029": "TA505 C&C",
    "59fb366eb959188285a8c322b54a99ed3a74ed8d": "Adwind C&C",
    "5a006b5d23a5bd86cac4cca069745bc8136b04a6": "QuasarRAT C&C",
    "5a1721840c7fcfa52998d9f98f97f4b8137e6734": "QuasarRAT C&C",
    "5a2cd979b7e3a8194de42365e1d64f7f096be7d8": "TorrentLocker C&C",
    "5a3b91b1d271551267c810dfde3d50a3cf5d222b": "AsyncRAT C&C",
    "5a4e01e0cea58394c64bce65a7e3ef28531465d1": "Quakbot C&C",
    "5a57d7c64f505d46923a466546ac1fd036557566": "QNodeService C&C",
    "5a5d28918cc144bfb4a31f5c9260e3d40d6b811d": "Gootkit C&C",
    "5a663b6a0aabe447bb52abb9e0cbc8b7daf05e7b": "Gootkit C&C",
    "5a9bab138267f8d19b17bc07eff7d849cef7db1e": "AsyncRAT C&C",
    "5aabab54f633abe8e559b0a94aafd68a659a564e": "AsyncRAT C&C",
    "5ac8259f3989ba8c515f6ca97061368f5bab216d": "Dridex C&C",
    "5adb3872bf6c63f6596452c52a275b41aa4698cb": "RaccoonStealer C&C",
    "5afc236d1dd00c9c45457b75226b501b815a59c7": "Shylock C&C",
    "5b00237bd209bf778ca8dd467dd644d02efca5aa": "Dridex C&C",
    "5b038598fb63ca7c935fa8ac7b7ab71fde89bd6b": "Quakbot C&C",
    "5b03d8de9310ac1b2b6fed9207494436fb82c21c": "KINS C&C",
    "5b1b69fcd23817df9945059b2e5d6f8a6a7714d7": "Dridex C&C",
    "5b24189a79a3962da889a2e8f9cb337383c20e95": "KINS C&C",
    "5b29ac19aeb72d287d080125109f51330be07c4d": "ServHelper C&C",
    "5b389efeb4adf5e07045f9c8eb4143eae00dae78": "Malware C&C",
    "5b38cd658f78a02010ba1ee6efd52b97809209c3": "IcedID C&C",
    "5b4211d71bea47b65fdcd526b17a6ef32af65c5d": "Gozi C&C",
    "5b46cd45714e1458f8d495b296682cd9ec658dcf": "AsyncRAT C&C",
    "5b5fe57a168acaee77580bb8b9d54818a964243d": "AsyncRAT C&C",
    "5b61e2844b4db1a4b1757dc0d79590aed7cb89ca": "AsyncRAT C&C",
    "5b66b10aeca30b93d2c776c92b3bcb02d6d36ae5": "Gozi C&C",
    "5b6e131ef5774fdd27f79ecfcc9afd7bff7c8a71": "Dridex C&C",
    "5b7379d104ce79021f8b5abac54949e18f123855": "BitRAT C&C",
    "5b82e5eb980f59186ba7dfa8c997ea7c0db158e6": "DCRat C&C",
    "5b82f45082309b455d50a2fe8a346d87f9858adf": "AsyncRAT C&C",
    "5b86f5a2ee790cdfdbbbe1aae14a308888df0e4c": "RaccoonStealer C&C",
    "5b8a6e1e0714fd71836092fbbebf49243a97a376": "Dridex C&C",
    "5b9286165a842e62798f27d4393315b8cd1b4fe8": "OrcusRAT C&C",
    "5ba0b7147211b1394da47e06648f768fa69a1c21": "BitRAT C&C",
    "5ba5af609cf33f85f7d6eb92940fb286b6d164f9": "BitRAT C&C",
    "5bc6e48ddf8424b52f1daf1b6108c8f93516cdfb": "TA505 C&C",
    "5bca5343b1dea0096ed7b207fcd3d3831ea6d130": "TorrentLocker C&C",
    "5bcfebc85e951c5684fab6004da8e45283ee2c2f": "CobaltStrike C&C",
    "5be56e0660a001a12c8ef250ff86369c50ca73a8": "Sofacy C&C",
    "5beafce006a6c557144edd6a399bcdfdaf42b1f6": "TrickBot C&C",
    "5bede836fa1162bf19a1ba2df97dae8c2cbd6dce": "Gootkit C&C",
    "5bf67792483922b92a67df11c99c03b97e5e86e7": "AsyncRAT C&C",
    "5c048b96c222cab62063a737138df049e70842ef": "Quakbot C&C",
    "5c185056e75d41b71afd7664fded33795df1edb5": "Dridex C&C",
    "5c19cc1f79f68f542a5f31349b48798310c9f1e4": "Gozi C&C",
    "5c25f5dc34c14eaa54446186436226bafa24c96a": "TorrentLocker C&C",
    "5c2d86ced061c67ff072e29cbc674475da20e486": "TrickBot C&C",
    "5c44bc164d9a6740453266429b52bb4136fd8742": "AsyncRAT C&C",
    "5c498beff2d6507d0d051a15f08b5516602476ae": "Dridex C&C",
    "5c55d2f51caf871c956a137bf61c474a14bea854": "Gozi C&C",
    "5c5c05c49583420f365a08748b3f77af6d0e1093": "TorrentLocker C&C",
    "5c67e2d3e488622d200fbb8bf3418206dfe05a5b": "DanaBot C&C",
    "5c8097e42822b094bd2feee2219dfc7e5c02b007": "AsyncRAT C&C",
    "5c87384624ab2b04c92fb703c6446c44ab5c9ecd": "Gozi C&C",
    "5c88e48e29ccaf884378b06c0b7fa1307f29e0a8": "AsyncRAT C&C",
    "5c8eef8f30afaeb92752217c3ed1820f93e80551": "Shifu C&C",
    "5c955db96ebe42deea35db8992caf943e2a33db1": "Gootkit C&C",
    "5c9ef8d387ed9b3993f071ab0749fd3ba5eab6ae": "Dridex C&C",
    "5caf105fbaf4059bbc516a524d9eba3d2fa8da9a": "AsyncRAT C&C",
    "5cb0f8390c9a07a8a1a97d88ad4935f9d35d92e7": "TorrentLocker C&C",
    "5cb24e0ccaa131fb5d44d9619fe2ad3c9103b8f5": "TrickBot C&C",
    "5cb25ac54ce040e124c4523dcafcc26864aa9277": "Dridex C&C",
    "5cb64c59c5a9582e6afcfdb109bb639a09aa48c3": "Malware C&C",
    "5cd739986ad9cf128d4bad0317dcd0ab81c2cf2b": "Gootkit C&C",
    "5ce22c06006a86af4b70b977202c94c25ced6cc8": "Adwind C&C",
    "5ce283a09090ec9d2d73bbba3b5db815372ebeb3": "AsyncRAT C&C",
    "5ce2ba0aafba416b18d5ff23d5c49a941d6da9db": "TA505 C&C",
    "5ce42b1e73a09f7a74dff8e2897007ad8b08d979": "Dridex C&C",
    "5d0e4f8038bf483af1749e7ebc5a217a4bbd43e0": "Dridex C&C",
    "5d1ba6d925dff84b63557c2c7d32d9ff5fa930c9": "Dridex C&C",
    "5d231bd188441809eab34d25e0904f0c31e82452": "Quakbot C&C",
    "5d307fdde2d2f678056c1b6e7878fc89f48fed6f": "Malware C&C",
    "5d406e44b890d6855c44fae388bca3bd828ac7ff": "Malware C&C",
    "5d47e102ad3ac8ff5910aa411ca5520482b4f05f": "Gootkit C&C",
    "5d5d9de4a7874071c361d9279507da432d55175d": "AsyncRAT C&C",
    "5d64578798fe792c1ff4c671d3c08db426dc55ca": "BazaLoader C&C",
    "5d66cb877090cf88420b3414a3bf01b4fa50fb47": "Dridex C&C",
    "5d6cc2cd235a231bf317e43abd3ebeef870eea83": "Dridex C&C",
    "5d6de69515dc79078a918478a1ba352652652f5e": "Dridex C&C",
    "5d6efa1e8dd9d2d9678a16b9cbc981473b1196ed": "Gozi C&C",
    "5d76750e8ae29fa1bdc51b9cbf18b46d76acc408": "DCRat C&C",
    "5d7a8cd9c02e2a2237f5ff7c991bdf9cde222612": "AsyncRAT C&C",
    "5d8536de1f50741b8408a720140289ec38beb8c2": "TorrentLocker C&C",
    "5d882be732982677ba3e57e9dc95ae77d039abcc": "Quakbot C&C",
    "5d8988a9f406b077f2bf4cbedbccdc07345453d6": "Dridex C&C",
    "5d89a1aa03d88c958038cca610638f2ebbf047a1": "AsyncRAT C&C",
    "5d8e26000d2c35f407e9aabe58aa00c67fc30b8b": "Gozi C&C",
    "5d8e431ea58eba5044d7d72f0b9cbe0b811a5266": "BitRAT C&C",
    "5da036f6ae0a0252caf4261c6fce9599e97071b7": "PandaZeuS C&C",
    "5da58a8adbfce0807e8e1ebe8f54319798ec174e": "Dridex C&C",
    "5dbb1533b040670cbdcc7da4af530dd9896e1185": "AsyncRAT C&C",
    "5dbd10b55039fcdfe8e49aea5345794d4fe2194f": "OrcusRAT C&C",
    "5dc1f7199d988a4d08ac662ee8222373b8874823": "AsyncRAT C&C",
    "5dd1aa1ab8a14392044041a20ad8013f207aa18f": "Dridex C&C",
    "5df46a0f65a899031fdf54cbccec1c4a88a8a939": "RaccoonStealer C&C",
    "5e0b97df7ba79631010dc6bd1059b8fbfb651ed1": "Quakbot C&C",
    "5e17825efed0e6d9c403a017536aedb1be5deb58": "TorrentLocker C&C",
    "5e1976143dd1408bb2a154a37c2f0f2320316fde": "BitRAT C&C",
    "5e1f1e82f234de089b876c3e79b1adfeca3bd716": "RaccoonStealer C&C",
    "5e21634242a75344d3ac3ea4bf0ac66eae04f627": "Dridex C&C",
    "5e21f804856b3d64d21d5fafd5c04403fec943c8": "AsyncRAT C&C",
    "5e264cb4fc216dcddfa6fe06c90d8add7427e13d": "TrickBot C&C",
    "5e337ab1cc16d9bf3a76be37ec0927baad256f26": "KINS C&C",
    "5e391e5bc78903881ee123e44a224d2948044eb7": "AsyncRAT C&C",
    "5e458076915a382006c5f22cf6d62051d8ea6e7b": "Dridex C&C",
    "5e4691b567c8ab03316c7f583cd80a133ce4917e": "IcedID C&C",
    "5e488a46826ee418e6bba56ad9037290d3f8be52": "Dridex C&C",
    "5e5950d6a468ac4092eb6deee308ef27fa4aa817": "AsyncRAT C&C",
    "5e65430becc5c5b111332b6f57da36f260be13b9": "TorrentLocker C&C",
    "5e7a48ca367364030394e34c81e9cb76ad0bd5c4": "BitRAT C&C",
    "5e7c239541ada7230e39b6fc2e61b67ffde91007": "Dridex C&C",
    "5e826319abeaf20f0d90e9755d5ac4a62e64931a": "TrickBot C&C",
    "5e89e6078cbeb221aef736e7490c031c748818f6": "TorrentLocker C&C",
    "5eb43e37e17b5c6c856b33fdde78177d7b8a0442": "ZLoader C&C",
    "5ef5f705a9a5b297cbe5fe8e412bb7582c209bfd": "Gozi C&C",
    "5ef732aad133946a275fe491e31e7754fa95f607": "Gootkit C&C",
    "5efd89f9dda9bbecec266cf0a5c5dd658fc84b03": "Dridex C&C",
    "5f0d1d7250d7befb918bb47efa9c75ed056de188": "Dridex C&C",
    "5f15b50e24f14e097df45bfc67d6c44ba131d673": "KINS C&C",
    "5f1b33d7614df1323652370ce6a892ce72d514f7": "Gozi C&C",
    "5f3cbefd7463d0ccd3dc599e8a9d94fe0830cc06": "QuasarRAT C&C",
    "5f4af875f90b39d1531bf95261367ebcf8fcdfba": "TA505 C&C",
    "5f51049f3f47b4ec355031c08e4daeb1ff40b52a": "Gozi C&C",
    "5f623fb213f68f95fe6ac53c93c8bfdadc3195c1": "Gozi C&C",
    "5f636d3360700e956a2c58b6dc45b7a9a7484f6b": "Adwind C&C",
    "5f6410207fda5abbe01b9add33a77418e567b71a": "AsyncRAT C&C",
    "5f66d8e91102fc2e03d55f90bd6f598b123d0aa7": "KINS C&C",
    "5f6760029d364933e8f7af7d6b45a46c4a177703": "AsyncRAT C&C",
    "5f69c698b2377d63494c3db9f9c4a261964dc4a1": "KINS C&C",
    "5f6d618ce906e0666c14a9496f29d66c7dd13692": "Dridex C&C",
    "5f70ecdd48a49c3569b5cf51b178ef9dbe4282d0": "TrickBot C&C",
    "5f83c8d640c172cdf75f723c3d2e5cae955be89a": "Malware C&C",
    "5f94d58a9c98ce494855e6bf4fa20ce9d7698a3e": "KINS C&C",
    "5f987ab1757e82afe20f24ec2718ff1e294467c5": "KINS C&C",
    "5fa1042e38d8a3b3d3a6a64e8597a84a91754357": "ServHelper C&C",
    "5fa19859c4df2f7692d068a17d7721e30f512b3c": "TorrentLocker C&C",
    "5fa3c518f6fc2b1e65601b71c78db1d34873898a": "TA505 C&C",
    "5fbd2e36bb4f0e0e2436029e20ce9a7fe6ee36f0": "BitRAT C&C",
    "5fbdd82f54d38f98eb94a69c14c82f93f79cffb6": "Dridex C&C",
    "5fbdf263056fb0af93e77e71884aa62cc37fbd3a": "Qadars C&C",
    "5fcb5b418f779a542b7148f2ddea211495787733": "ZeuS C&C",
    "5fd116bcf792174ff8433b8432b577d3f38dabd9": "Gozi C&C",
    "5fe1db5777405c41eff2ad9140bbf2ce31315ec6": "AsyncRAT C&C",
    "5fe9ff168207c20da27dddad16c6ba12e28527d3": "AsyncRAT C&C",
    "5ffcfe0700eb0108510d86f92311dbed791afa6a": "QuasarRAT C&C",
    "600294e0460dd9472765b06daa0300847e03cc9e": "Malware C&C",
    "600791a650995e12048961fd7966daf60cda7a2b": "ZLoader C&C",
    "6010018e505e1fc31f96aea5022bfa9febd29c14": "Malware C&C",
    "6011782272803ed6c30a3e9156c8a718c99c3974": "Gozi C&C",
    "6015022b12f4f137b45d7238efcd329b277f7736": "Gootkit C&C",
    "601948d4495b083f24dd80a29776ac481b0efbd0": "RaccoonStealer C&C",
    "602114ea68aa61e7d5a245643cc4f4a66ffb1757": "AsyncRAT C&C",
    "6021b68253435c0a98d2b2d193c95ed1c18c4572": "CobaltStrike C&C",
    "6025763d1cf761d510ca13991442bd62e634a9d6": "ZLoader C&C",
    "60260af7e01f041e44c5c7b91067267e90b48f7a": "OrcusRAT C&C",
    "602c5dbad07fd4c9825a2dfc160446497c396bbd": "TrickBot C&C",
    "6031faf273af88453d5dcae14f02c1ff6364950f": "OrcusRAT C&C",
    "60341a66474e4d2279db15ca1d3acf975a325594": "RM3 C&C",
    "603613e9d47ba125578d833771d3822a653fef21": "Dridex C&C",
    "60423af3f1cd134cc8f5219cf128a199883352d2": "OrcusRAT C&C",
    "6043130d0a4d804f1a4816a4bc19755f33639534": "AsyncRAT C&C",
    "604345c0edd52fce1c546a4a79a4947a41361916": "AsyncRAT C&C",
    "6045181f0247749da4407dd27c4e012fb6ab4a9c": "KINS C&C",
    "60463457bd23b048ba3c2c5fc624d57467d3a39b": "AsyncRAT C&C",
    "604c15528860f0f9def6a5ace419105f133a886c": "Gozi C&C",
    "604f56f4023db5bec9f400651803af5cc1a81729": "IcedID C&C",
    "60574f1741a0786c827af49c652ab3a7da0533d1": "QuasarRAT C&C",
    "60598489eb06310a48ab6f5aa19a095934d609e8": "AsyncRAT C&C",
    "606070e1721179adfcc7d2a9ca96b8acd6f02049": "Vawtrak C&C",
    "606353d44d707da46679b462a2f5b168dc038fa1": "Rhadamanthys C&C",
    "606e9d7bf5a028e1b013bf8bf36b47f713d94b37": "AsyncRAT C&C",
    "607cbcbd2ed68c7497c8a0709489f87627085ddc": "RevCodeRAT C&C",
    "607fed0bf52c70078f672c697db685ede62f6ef5": "Malware C&C",
    "608399379d28895ba7a35f983440f199fb66f9d7": "DanaBot C&C",
    "609d6866ef001b9411fe9a95e472957fef282e38": "Dridex C&C",
    "609f56d068fdc88aa54bbb559f2ad9adeddc71cf": "BitRAT C&C",
    "609fedc606738c12e1d24c302ec64f41d52d1b1f": "AsyncRAT C&C",
    "60a3277501a92e68e7b70331985a3836679e72df": "Quakbot C&C",
    "60a3767ef8b680c7867195638369b051ceb545d7": "Gozi C&C",
    "60a78130c20e36bf189a8a0b4651289faacd646b": "TrickBot C&C",
    "60a7b10e070465b959eb18a9e8100fddc6202f34": "Malware C&C",
    "60e56e90ace079183b215bb007eab72e1614215c": "AsyncRAT C&C",
    "60edf4253a2b81ccf0d69cac6fe1ecb1bc3b667d": "Dridex C&C",
    "611728f523c632704d53751a5c42baf65177d30d": "Dridex C&C",
    "6122138b3639f92c58df5056cda29de7e39f74ad": "VenomRAT C&C",
    "61283eae0d2b4104c1ae7255574cda72bec128bd": "AsyncRAT C&C",
    "61288d93748122070507cbd37db038c3bb3c4741": "AsyncRAT C&C",
    "613c868a52bdf1c7d4d8c6e670b01d217ed6f44a": "ServHelper C&C",
    "613c9682e987177bee34a4400d5b08b78b42a5b5": "Dridex C&C",
    "613e2c8b8aec17710220832dbfe384e1f94e86cf": "OrcusRAT C&C",
    "61415604ee0f459d849012b9d314b2efed919bac": "CobaltStrike C&C",
    "6145cb406e2fcd03a2e6d113efae6ca2c388eb8b": "Quakbot C&C",
    "6170cb38eaabde35c936fe422a51e485cf1247a5": "Dridex C&C",
    "617611986332d256d22abb7c750b6f423db4223a": "Malware C&C",
    "617f1e68b4fefe1d9da843f90b4df7dad744d677": "FindPOS C&C",
    "6186aeb91badfee61d970d596469707dfab75392": "Gozi C&C",
    "618ffa46fe592bdf61fef3acd7d04aa6ebc4d4f3": "Quakbot C&C",
    "6193e145d07ad6b83c3879d98758729a2bfd77ff": "IcedID C&C",
    "619ca1450450b91cd172b309373a79c459173787": "Malware C&C",
    "61a86157b2970b2eb09b7a0c3a2b8e433aac7cd8": "DCRat C&C",
    "61bb6f3dad350716e71af3267aa0800876f3a106": "IcedID C&C",
    "61c214d616d9a80a18774d77edbc99276eb630a1": "QuasarRAT C&C",
    "61c6d4d5ef7aef36275897d6635bb7a58a3e5b11": "Dridex C&C",
    "61d991d7063e5e7470daa3059357f8282e680bb7": "Gozi C&C",
    "61eaf739f5a9ce3b3efb76f3b62e5078dd0db193": "TorrentLocker C&C",
    "61f60a65b61a5be7b3186954ebcf89ba2c0ea963": "KINS C&C",
    "61f67c0f96d59cdf954e90c86509735a011de93c": "QuasarRAT C&C",
    "6204982e47f5dbccb4453a6e5d3f7996f0586de3": "KINS C&C",
    "6206d313856cc7eb81e54cf955ce05a1ee9e9d9a": "VenomRAT C&C",
    "620a0625e79e3aeec7b77abf4ed6345994c3c14b": "KINS C&C",
    "62101d5a2989919f19092eb6b73d1a39ce1c00d9": "Dridex C&C",
    "6228c39fbc97544eaff534ffb4cb11a2c3b98d58": "Malware C&C",
    "62300822fedf082223715f4102ea40ff9011d52a": "Quakbot C&C",
    "6239a74618886b29924f8dfcc4df059919cdf22b": "Vidar C&C",
    "6248f3db15be70ceebc21c9162fbaf714b1bc828": "Retefe C&C",
    "6258621fec54d504f51a166785da5a5369c0ad72": "Dridex C&C",
    "627b8cce9573b2092183ff8472fee068a2e84627": "Dridex C&C",
    "62913f92e00b745988e8a4609ac7994776889317": "AsyncRAT C&C",
    "629ed49f00e65e1328561e5232f568290053485b": "Quakbot C&C",
    "62ac628d4ccaf85db91843cf30cacb2d6652f3d6": "KINS C&C",
    "62ad46bad4ed2a83371609a51d3ba572e3ab7067": "DCRat C&C",
    "62b0050fbfd9bfe4014aa1d49feec2c215e986cc": "AsyncRAT C&C",
    "62b5b327eafb32388a81e265cff1778cb27616cf": "OrcusRAT C&C",
    "62bdb404038f4d32a75199d7ac01d091bbe446e2": "Gootkit C&C",
    "62c30b50ece6ce29031d5b1f3866b15fbd656a6b": "Dridex C&C",
    "62d026a9d660d6e533907efeafe23afa2287fb42": "Latrodectus C&C",
    "62d3a25aa746c71cd74fb2eec2d9e30d43c0127a": "IcedID C&C",
    "62db4dedd08c629eafd8dd93bf4b377a61f46c8e": "Quakbot C&C",
    "62e930b13d240fe4caef561c90d4889e9b25119b": "Quakbot C&C",
    "62f71cf2b7a4d216cb041f10bf437d0093358be1": "KINS C&C",
    "62fea672d5bd77c0a9b6e7ea502e2216f0771f87": "BazaLoader C&C",
    "6316c873f5fa10919bef9a7ab40a2ba316fc882e": "IcedID C&C",
    "631fc2f66070ec883857a666399f51d3f59c0817": "BitRAT C&C",
    "6322a9e17ba00b8abeae60ddf2f0d93b7ab5cd94": "Gootkit C&C",
    "634bda131a93328ae698b628e756cca6f56961d7": "Quakbot C&C",
    "6375b28275fa7c95912ca1200c9e0287a65aadef": "Gootkit C&C",
    "6389bdd684230201cb25425c604e22978ab83c63": "QuasarRAT C&C",
    "638e8335a7ef426ba2c1a536d2e01bbef66af5fc": "BitRAT C&C",
    "63a58c8ec0bee00687f5047781be02340adee8f4": "PureLogStealer C&C",
    "63ac5bc0c4b0dc072a9ec66fd0698aa72ef5103b": "Gozi C&C",
    "63ae556f4379b1caa73c09b37f726ebacf3572d0": "AsyncRAT C&C",
    "63b98550d1cd85249c856d04b2eb27ec8a81b6c9": "TrickBot C&C",
    "63b98696509246c6b79ac745c0e959ac0d7b9316": "BitRAT C&C",
    "63bfabcfd345f94ec99afd5f6200fa3d4487f764": "Dridex C&C",
    "63c21ac1aad8ddbe822ee58b62569027190ee3a2": "Dridex C&C",
    "63c6b854daa6b2ae7f355d2403f6e128404e9a58": "Vawtrak C&C",
    "63d06f676f4a3c47d7a78345c1d68b84bbbdc128": "DCRat C&C",
    "63d16ce6207e16c73b3868efeff3032b9290f3c6": "TorrentLocker C&C",
    "63ebbb74f1b0b66f942b113def3927e85a3a2491": "Dridex C&C",
    "63efda4506df0e6e0478fb9dad449ec47560c630": "ProxyChanger C&C",
    "63f387290b406ae58bfc6383e04c1f2f2151845a": "OrcusRAT C&C",
    "6405eea1c8a1f5a436c9d3b0fc530e28c5cbc10f": "Gozi C&C",
    "640e0e9a76ca710eecc79211f3de6f9af8cde92f": "AsyncRAT C&C",
    "64255dd32d7ae6c0188c6cb72d52e4a35622aac6": "AsyncRAT C&C",
    "642c55bebd7da95c30658bf9b3bcc90785d32cd7": "AsyncRAT C&C",
    "6434fedd08ec89e20a2ff7d9a1199021edaef86d": "VenomRAT C&C",
    "64440ff2d7a0bf979d478a933aab00a6874f1762": "KINS C&C",
    "64455813ff85644f572ff27013afd5bcf9cfd116": "TrickBot C&C",
    "644b1512af6fbcbb3aa4ccee4b12cbedfe4f3cf9": "Gozi C&C",
    "64622563122945dd98a71e7cec922e1661a167d0": "DCRat C&C",
    "6464d7e4c9633cae8e9746d087aa913ab03c1d2f": "BitRAT C&C",
    "64720729263e98b5df0babc43345a6b9b94210be": "OrcusRAT C&C",
    "64732f9895df35627ba0828d64c6d27a71d9e419": "BitRAT C&C",
    "6475fece0d52e4eb387331073d60fa86802d033d": "Malware C&C",
    "647ad94bb465bacf6b271059c7b822c59aeac77f": "OrcusRAT C&C",
    "647c00a1f727bb2f1c97553d4f4ba4b51842ec74": "Gozi C&C",
    "648aad169c99e9977ef95bf2201010f888808222": "Gozi C&C",
    "648f542b0700eb777345e119b7581eaad75be123": "AsyncRAT C&C",
    "649725b11ed79367154d36d207d7796a7164c058": "QuasarRAT C&C",
    "64aebdab0fcaecd9671ee836abf09d5228dd368b": "TorrentLocker C&C",
    "64b96d9811b9f9ae735c5f78758d9a7b3780b989": "Quakbot C&C",
    "64c842147942b6e7a7fb09d902766696ad07de89": "Gozi C&C",
    "64f2420cfa4bbac2e99d18b9680a1790ab4ddaaf": "TorrentLocker C&C",
    "64f57005ebce8529d156c465eb1944f63d228711": "Quakbot C&C",
    "65058a2a003f61572cda9611797f596a2039e104": "KINS C&C",
    "650ed89735f41f23daabbc106360f68b874b6df8": "CobaltStrike C&C",
    "651fce4f01fb5171fe68facf2b245d9e3e6d8c47": "Dridex C&C",
    "6538fb5f1e712485d256040c21946c35d51e6244": "Dridex C&C",
    "65390d8344f382e295d8a89df6d86a98c4588edb": "OrcusRAT C&C",
    "6545006ab41b38bbc2181170927173bdeeabb5bc": "Gozi C&C",
    "654d4f33b1fb15020ede870de6d3d7d438ea2506": "TrickBot C&C",
    "6550c5fd133683b3330870c778b7db73e923f472": "QuasarRAT C&C",
    "6557767f907e6768e4e9711cd2d492ce13b520c8": "ArkeiStealer C&C",
    "656b00be7f39b4373cf8f5363244da842dd43fb0": "KINS C&C",
    "657a3d402ab17751d6ad1b712a06f0fad3304380": "DCRat C&C",
    "6584574257f32a01c54da4e0b125f6091d6a5400": "OrcusRAT C&C",
    "65a77d36d1b53665f60d19718924504f7d3f9508": "KINS C&C",
    "65ad26c741559c717c42c5f30a9f21e70551edc2": "DCRat C&C",
    "65ad2f12e13f62e1ca6de589d163be234ed77596": "AsyncRAT C&C",
    "65b1f88a669959d0fbff2458265b3841a357768a": "AsyncRAT C&C",
    "65c0c10619caaf5dfabae0469f284e9ddfb292fb": "Smoke Loader C&C",
    "65c982ba7dbbacc5dce730bae04863a65e0221dc": "AsyncRAT C&C",
    "65e5402a7e46e441668952a191c4383cddbc1d85": "BitRAT C&C",
    "65f1c795619f2589cc4f228a590d01e48ddb2e88": "Quakbot C&C",
    "66050b1389f3e0229940a5c49a510f835a636cf0": "Quakbot C&C",
    "663c9261c6502f856e260751096f6778e1b1b00d": "OrcusRAT C&C",
    "665b5658822a406d497cf726a1454c6e2e2fb913": "Shylock C&C",
    "665c8b508ec328b12f8f1a2a20662bf0dba9f069": "QuasarRAT C&C",
    "665d62ba17477c9ca393bfa808f4e558509f9876": "PandaZeuS C&C",
    "6661baa60d1a1248be576b0cf4035df772243860": "TrickBot C&C",
    "666fb7be4d5c547425e2dfa63ea55fb5ea03b0c6": "OrcusRAT C&C",
    "669f16d43846942f011fd152562fdb1f62f3ffb8": "Gootkit C&C",
    "66a1a037e82968051b63ecf0221fe642c8231029": "Quakbot C&C",
    "66a606ec3f3358d2c0591fcb67c231150c6e0cff": "Ransomware C&C",
    "66b3401e21f877cc3cc2cdd81dbef567baea72e0": "TrickBot C&C",
    "66be36b5b3c7a9cc91d5149706bb5cd3b7b305c7": "Malware C&C",
    "66c825a3640115b300eaacb78b6d098fd14392a6": "KINS C&C",
    "66d00fb9ddddf5501ce720fe9ac491f748539886": "TrickBot C&C",
    "66e87d1e559f4c28c45cef852f74d137212a0e6f": "TorrentLocker C&C",
    "66eb66a197a4e6ec1332feed8290cac1a919b085": "QuasarRAT C&C",
    "66f408e1eefebf7ebf940e9045a318f2462484b9": "QuasarRAT C&C",
    "66f692631bd7c5825c69fe941a6847b9968fd72f": "Gozi C&C",
    "66f7345d6718f254834d7529878f58e2d3ddb431": "KINS C&C",
    "66fb925cf78de71ce1851e4b69c7c07b3d6d9a48": "Quakbot C&C",
    "6709e752fd6e05bcd444a84f4694c7d3089e97f3": "Gootkit C&C",
    "670d2b3b354c6ed1fc653c9e0901e0148c389317": "AsyncRAT C&C",
    "672f29f8cfcdb9494ef2c643d6208c19b68e953f": "Quakbot C&C",
    "6732f74de6a04cd975176f3b87c8a3b2a65e0b41": "Retefe C&C",
    "6735a108e9bb80f6cd3a280a4755bad1a7bbeb1a": "AsyncRAT C&C",
    "6746072c2f7c0577e405562e3e2172c9d300370d": "Gozi C&C",
    "675eb515bc1c3c50cdce9ae9090bafba44dbb4be": "OrcusRAT C&C",
    "6764dd6c1937fc4fbc3399d74ab6d59096faae01": "AsyncRAT C&C",
    "6765060660f3bca115775fe4426a1352d8ee4af9": "BitRAT C&C",
    "6775a9caffab7256b5cb30fe5da9783c18b107bb": "Quakbot C&C",
    "677ba3ca93a14ed21921e76cdfaadef9d4e79629": "QuasarRAT C&C",
    "6788d7dc2b818c988e07d891139b963c39615d8a": "Neutrino C&C",
    "678e688d5ca6c29c2d7ec9a1fcb140157e19523a": "AsyncRAT C&C",
    "6790b34bfdda7c4908521ff69f50a947cd1d8077": "AsyncRAT C&C",
    "6798308190fb070536af19023ae89ba4bd54e9b6": "Shylock C&C",
    "67ab40f57fa84354859ba3eadf6a4107d35a8dba": "BitRAT C&C",
    "67b0706b75bd7fc85c393c55bc21fdc1752117dc": "Smoke Loader C&C",
    "67b6db23299daea2a766afc6387e4f4478a8c209": "AsyncRAT C&C",
    "67c0182798556a6a0e97d9d2a31f6e381f3cdb5d": "BitRAT C&C",
    "67c73b14456fe6e24118bdaad3aef7fb780f94bb": "ZLoader C&C",
    "67d457d491afd80a81de885370317b0b841d68c8": "PandaZeuS C&C",
    "67d8ace75adf779e6a2ed799b8792dfed468ecaf": "PureLogStealer C&C",
    "680f48fbb81b9f7c8503b9077b15b0dfb3cc8e79": "DCRat C&C",
    "68126a310649a24b203b32b12dc488a54b602580": "QNodeService C&C",
    "6817d3c86709965f057c4654e94666eabd2871e4": "Dridex C&C",
    "6818c8a5168eb20f0c397d2e717f53ae065abd38": "TorrentLocker C&C",
    "682cc869544e6beebe37159bded9b2f61591378f": "Dridex C&C",
    "6856caf69d38e96ebcdd43701674938abe646d4e": "AsyncRAT C&C",
    "686c67077f27a8b01920db38ee016f4b492ac0a3": "Dridex C&C",
    "6878b4783cf1ab6847161ebb101a63843f06a98e": "Gootkit C&C",
    "68a506447d7c0e829a8ce832886eb46f70b44afe": "BuerLoader C&C",
    "68a75e9aecbc1dab86c305e4b1dd60bf379063b0": "AsyncRAT C&C",
    "68a9c2fbc4c7ffd01af53202f97279366b0d3bae": "Malware C&C",
    "68b15d44c82ac52fa008af2023da1a74d55db8d6": "TorrentLocker C&C",
    "68b4fc7da837c64332b9f019adaef4c7038ec85d": "Gozi C&C",
    "68b579acdc0790f1e627ab1779b7a5da2a60378e": "BitRAT C&C",
    "68bc7ed7ea6bfd68b659c20e1d11087f8b2d54a2": "Meterpreter C&C",
    "68cec2a6a6c461bb019dd925f06a99ad2070dbe9": "AsyncRAT C&C",
    "68d9045b9ae896ed4e26d1d0e3e1a6825af1d977": "TorrentLocker C&C",
    "68dec51d9d27fdd6efc57bb5581b54243fb60aeb": "Malware C&C",
    "68e37da08922448041119e432c2a3057992c586e": "Gootkit C&C",
    "68ee30194f35b7936882bab12df59811d7553cd4": "KINS C&C",
    "68f0a2ef0a7eadc2e055203327309ba7abdb8b61": "Dridex C&C",
    "68f0e824d17d04ab7425c650a00ca39e45caee30": "AsyncRAT C&C",
    "68f5c30143a0a676ec392580b52bd8ae5bcafa44": "AsyncRAT C&C",
    "6916a631ff34630072a28fbf94cf56007359e356": "Vidar C&C",
    "691839fbead70ae9fea3148373dd09ae65514d73": "AZORult C&C",
    "69250d3691c42a53708cb582ab6c1b44ef94a2fd": "Malware C&C",
    "692dad49768975f1e320e145a3140b927d31c2a1": "AsyncRAT C&C",
    "694fd8709eb5a18e7e947550f7684fb3c9634b70": "QNodeService C&C",
    "6953081218a0bd0229b1b0bf6397378ead0660cf": "TA505 C&C",
    "695cb54dcd5b074df14c0516b0522689f2411547": "AsyncRAT C&C",
    "695fe4b0581767967e6d9c7541c75cc7092ec788": "QuasarRAT C&C",
    "6980ef376703a3a8b42fc7a861f63045f39f0e20": "ServHelper C&C",
    "698c3cd0bec7a9e0f541cfb025030200e04e54a6": "Gozi C&C",
    "69960acaeca0352847d88794bd317e7aa0e38a7e": "Gozi C&C",
    "699ae29fd30a7723a696578b4b8ffe089ead8e9b": "Gootkit C&C",
    "699d261e2a7b0463fceaad043442491e0ba68247": "AsyncRAT C&C",
    "699e1850231baeb2e5871054f4e193f1e261c7b3": "KINS C&C",
    "69a3f444141f3008993e8966b7e6dd333c88f0fb": "AsyncRAT C&C",
    "69a670c5f6078b33c01e1ca597d6e85b8d35141e": "Malware C&C",
    "69a7a32f40f47c450310c440d6566219c8c14f13": "QuasarRAT C&C",
    "69a903dc37e5958d62b20ee9864c1cf735ed3546": "AsyncRAT C&C",
    "69b2f234922dead5314911c15c18caf61a666db6": "QuasarRAT C&C",
    "69b9c4fd2834e467b2bbceb4c37d1592962d661f": "AsyncRAT C&C",
    "69c678707bfd4836291571fbae400459c90b9eed": "KINS C&C",
    "69d69d6deec4efa2c8ea37698d1570b6a03cce0a": "TrickBot C&C",
    "69dca2804355564143f21cebcd428b5ccad08311": "Quakbot C&C",
    "69dd95de03dbde5eb20fef559965fed52f7de1a6": "Dridex C&C",
    "69e398f05bcee1b4ce52665dd1d3737238b9c3ab": "BitRAT C&C",
    "69f476aebc36cdcb235187230cf3f99552bd1703": "QuasarRAT C&C",
    "69fdf0eea24052986678d0e849de279205b1beb6": "Gootkit C&C",
    "6a03502e919a07c69691d1246ac24e2ed803e4f1": "DCRat C&C",
    "6a1352f99b9a48d538169cacbf57ace327168499": "Adwind C&C",
    "6a13917daa4ec20277cb509daf143d15f4048d8f": "TorrentLocker C&C",
    "6a3513d609ea9b59536bcb8675dc3a22b689861b": "TorrentLocker C&C",
    "6a374cbbf0044a47d7101d9f1d264d6e38fdaf2a": "ZLoader C&C",
    "6a39a53b51796f0a32d55d1efd550010f311e8ef": "Gozi C&C",
    "6a3fb41b1a0553ebac223e242dd1d3b9e41c7a36": "OrcusRAT C&C",
    "6a4a692dc5ae230e255b64f56fa71fa6bec64bc6": "AsyncRAT C&C",
    "6a768ac60bce875538395333137afb385f8e6a10": "CobaltStrike C&C",
    "6a7ed658ecd04e8d38ed8b314e3fa4c7b26700c7": "KINS C&C",
    "6a94edcb9f47ee5aee6b28dda59861203f602190": "Dridex C&C",
    "6a9f7c5990fb4d3082658b0e92194786f4e75d4f": "KINS C&C",
    "6aab71caa7d4a0c44603c588ec330db10be0518c": "AsyncRAT C&C",
    "6aad4d9b0ea4a2ff8b25037a5b170d54fff75e7f": "KINS C&C",
    "6ac05718a0ab32b0c5df219adf810ac4cfc77083": "Dridex C&C",
    "6ac2d779ec464a589d0a686e0813f453c69c8536": "Adwind C&C",
    "6ac9eb9a044a60cf671a9ddc6cdd86984c1e6a74": "RaccoonStealer C&C",
    "6ad71b163cfc3aa1cf0cfd786d87fd1b198da3ba": "Dridex C&C",
    "6ae5aa534457e6c0d226353a234f84318492ca6a": "Havoc C&C",
    "6aeca8f9e102cacc4df52ba75400470dced6f690": "Quakbot C&C",
    "6aecd84ad1abba45cb2dbb6f2659bd78bf5a88b2": "Shylock C&C",
    "6af12e343b64352e19a779a1a504fce6721ea8e7": "Malware C&C",
    "6b019fcd64e1e1c8a39e03be074608f1bcdf253c": "TorrentLocker C&C",
    "6b08fa26e411a2daf9377b7da2f2c70d8d91ade7": "AsyncRAT C&C",
    "6b0d9cdfbf22251a89f554e059b7463c8cde0f0c": "QuasarRAT C&C",
    "6b1675355588ac8adc1a87c302eef2d10868caa8": "Gozi C&C",
    "6b1ee9ad97729ad13858faae6378ae63554da7ff": "Quakbot C&C",
    "6b2ea05d5aab7b06af6e86282e23837e023db0b8": "AsyncRAT C&C",
    "6b3e3be7be8cf383bdf4b0919732231146d6b28e": "KINS C&C",
    "6b59048f16e2a50ba6e4601b42ba99a3195d2d1f": "Malware C&C",
    "6b5b7798f8bbadbd6d3494129e481ef9fad8a7ac": "Adwind C&C",
    "6b6710997cbb00db5b50bb7615e76d54ff36d3f7": "Dridex C&C",
    "6b68f4ae807d6b1f6b14ae63d4c33b8a7b8023c7": "QuasarRAT C&C",
    "6b7130229dfbdbcf38e5725153a9cd96f0032ae2": "Gootkit C&C",
    "6b7c95dc3cfd5d1b1f8296b9c31749d8a5188d16": "AsyncRAT C&C",
    "6b98918ff1330834083464a7f9f55c2f8ed58b5e": "Vidar C&C",
    "6b989ad31844a89c4cef094983cfa67ac04eed37": "Gozi C&C",
    "6ba0288a54a4acdce001e9e3d2a6bb69edc50532": "TorrentLocker C&C",
    "6ba8e7def8ecd8962f31970bf8ef2521400c7863": "OrcusRAT C&C",
    "6bb0facc3a170236634a92b62fc6e67705da3fbf": "Gootkit C&C",
    "6bbd37a03c68856ccfa1d0445269a4301432d9ee": "Dridex C&C",
    "6bc7b5686cd01f590941ac52603d95534f7d4812": "IcedID C&C",
    "6bcd24dcafe8ebbf4955ae559a720a2189ed0be2": "TorrentLocker C&C",
    "6bce07f1a111839ead9d3947caf01c94f7f65493": "CobaltStrike C&C",
    "6bce6bd7fa5d268b32e3432d286c246790a30833": "Dridex C&C",
    "6bcf172ea022156150dff8a46ed00fba2957ecce": "Stealc C&C",
    "6bdb302e1dd3a6af6e22f319da1898b46eeb9c55": "DanaBot C&C",
    "6bef207908bfad6b19580067ce770bc820d3d2ef": "CobaltStrike C&C",
    "6bfef0de617a6b91b28db47338d0771dd68456c9": "BitRAT C&C",
    "6c08885c2abaf9adf0840da1cbe7c9debe736b2e": "Gozi C&C",
    "6c08a8514aa4194cefde7e1f8ccc108b3e67b0a5": "AsyncRAT C&C",
    "6c0cd4440674c8e4c7f8d6c1bd44fae8934fa869": "IcedID C&C",
    "6c0d0db6d2d31ab9b6e27b00769cfbb9e52a484e": "Gootkit C&C",
    "6c1cd5f3b4f1a6da97a199397b1bae8226aac7bc": "Dridex C&C",
    "6c31e6103f87934355f7dc02ef9ed486bf52e2da": "Dridex C&C",
    "6c3973dcd684e1b4eb41d9c5b6cac562fa87c67a": "Malware C&C",
    "6c3d1ef60ef14cb548140a64d6c60bafea1aa98a": "AsyncRAT C&C",
    "6c5b9427c6d63c06bd1d6e30748dcb94c3763d1c": "BitRAT C&C",
    "6c8ac09ce668d2a4b7f3c658a5eece3065025def": "CobaltStrike C&C",
    "6c94e4fd43e4fc661bf2b2f63e1c6140226ce37a": "PandaZeuS C&C",
    "6ca86b5f28ce1182eacbc9e19231dc39fc4f920a": "Vidar C&C",
    "6cab789e2aaa53f8bb4c37ae0ff8787f4ed46bce": "Malware C&C",
    "6cb450b73fcb2350cd1b6edef6392a7e59bcbc88": "Malware C&C",
    "6cb527f1c6b5a6cf41eb34d34136a5445e57df40": "Downloader.AuotIT.ZLIB C&C",
    "6cb56ac71f9af3a9463a49de13eb6d7a90248fb8": "AsyncRAT C&C",
    "6cbd84b6935472bc4b101892fc5ccd77ce2964a6": "OrcusRAT C&C",
    "6cc1865473ca53ecb72f059a897dcf5e649c7f1c": "DCRat C&C",
    "6cc6b5a8765a38922d6501f21cb0e8eab559516e": "IcedID C&C",
    "6cc95dcc35ca96326bc78934984a190f09e10d03": "Malware C&C",
    "6cccdf1bf06b94bdbbee4de9cf095d003feaebb3": "DCRat C&C",
    "6cd24eef0f84baba4f2a4b2a55a9c5fcb7bf44a6": "IcedID C&C",
    "6cd7a727eb9f3a77e3fed0c38567efbe1d88157a": "AsyncRAT C&C",
    "6ce24db4586c488b9c29f9a2a7b60da10c3e1272": "KINS C&C",
    "6ce3740140128cf5500b56e1b5020bc22de647a1": "Dridex C&C",
    "6cec09bcb575352785d313c7e978f26bfbd528ab": "AsyncRAT C&C",
    "6cf7055703022f18dc3328192314be94da237b04": "TorrentLocker C&C",
    "6cfebb47098abd1b3e1ecdcc14e294a3368488fa": "Quakbot C&C",
    "6d123ae9ca8e3aa50e59a042f0a3e4f501e91b3e": "BitRAT C&C",
    "6d28e9c22dea118cb62e543fc366b83260a86e0d": "PsiXBot C&C",
    "6d325bfaa6b6e19bca228d73bb0ad441619fd1a0": "Dridex C&C",
    "6d40c27dbcac2ddb1c52531566784043380c1404": "BitRAT C&C",
    "6d4179000363e8a715aaccdbbe28938964fb58de": "Gootkit C&C",
    "6d54a64b57b9fdcffdab43323b1755356a136d42": "DanaBot C&C",
    "6d568e22bbbf439104f6d3842cde8ab74115c472": "DCRat C&C",
    "6d5f3cc22e17cd61cf7c08224d3740cc34dda8a1": "Vawtrak C&C",
    "6d5f9bfb1b768c3fda90466d96bb1551dfd9ee0b": "Quakbot C&C",
    "6d6d4f29828cc0863704eb5cfefba779ce3b714d": "BitRAT C&C",
    "6d780688dab9bccd022dcaeda94a53236a83500a": "AsyncRAT C&C",
    "6d8dd8afa58b698a00d63e51bd01ce146b0cc67b": "KINS C&C",
    "6d98de4aabc33bd10528b73b633ad49ce24f5704": "VMZeuS C&C",
    "6d9a2a0e9a93e28f616df8a58e8c6f2804ce8917": "Quakbot C&C",
    "6d9bdef333af6df03bc85311181e98a07be63f5a": "DCRat C&C",
    "6d9c39e6b781fe482538f8ba564db4d7710d9af8": "Malware C&C",
    "6d9e2cfeaa96070c8f540997e267cc375e7ffe57": "AsyncRAT C&C",
    "6da001bd6c6276995240688dd6532a416fadb825": "QuasarRAT C&C",
    "6da89eaa62a7f12dc6a3d0ef4c074938d560f14f": "AsyncRAT C&C",
    "6dbab1c941d574e378175d7887a33a762a327e42": "Quakbot C&C",
    "6dbcf6c041c55190c285ddd96c210dfec70016b1": "QuasarRAT C&C",
    "6dc62ba3d443223e31c419bc41882902663d5833": "njrat C&C",
    "6dce909b990ffea59852d39829aed18df52f4b79": "Vidar C&C",
    "6dde75ca5cfbc0fda3b18579f5d849277432af78": "Dridex C&C",
    "6df3da6254fe884f56320ae28acaa7880748ea96": "Quakbot C&C",
    "6e0378b98e8bb4ea8edc154f2c829428704a9839": "Vawtrak C&C",
    "6e1e106af3820b4f984e7ec8afd76439a399b1f3": "TrickBot C&C",
    "6e383f6adfcab3666eb5752e7c1e59e0760854e0": "Gozi C&C",
    "6e48d8f576b137a6b3228828370d77b21ef88adc": "Dridex C&C",
    "6eaefc284c6cbdc80d92a0305beaeca726dd9377": "Quakbot C&C",
    "6ebc65b326999b45343b636b7d22efc085f7c674": "Dridex C&C",
    "6ece5ece4192683d2d84e25b0ba7e04f9cb7eb7c": "AKBuilder C&C",
    "6edace5350997ab9c932850b1d8f0ba35a00ebe8": "TA505 C&C",
    "6edd06f71bb868a3e721f6603905c145ab97790c": "Dridex C&C",
    "6eeff6fc73ac467603562969c3f244eddc6a9500": "Malware C&C",
    "6ef4fae09ef3a3fc81e21da6f47a8cb9b2996af4": "Gozi C&C",
    "6efb3ed85502b2e19c31e2e5acef93cd6ee141a7": "BazaLoader C&C",
    "6efbca01b14a61a1519543db33fae38d22e99941": "Malware C&C",
    "6f08c96dd7cfc5da1b89aa9b762a913ceaf17252": "Gozi C&C",
    "6f13e741251c107db3294cc4d1d8e8522c4b810c": "AZORult C&C",
    "6f227b05e32d37c2d59d465dd18c70795c0ab356": "Quakbot C&C",
    "6f40b30816491b235effb30297af5078957db75e": "Dridex C&C",
    "6f47c31a7ab7b0d3234cd617d5f4af0b016dcfa9": "Dridex C&C",
    "6f4bb25cc36d1cbdf535d06f4b3ed4e45babbdd4": "Dridex C&C",
    "6f5596f3c304a5877e16764352142ca646c5927a": "QuasarRAT C&C",
    "6f5ec1213fa024feae270b6535740a39795c1116": "OrcusRAT C&C",
    "6f6ff1e5c197ad2422150f6c5e159cd2520a2eaf": "AsyncRAT C&C",
    "6f7b9453f07134380688c7232695c1d3139e4111": "QNodeService C&C",
    "6f7bddd72432668d16d429504598e8889865f50e": "TorrentLocker C&C",
    "6f8906a70c04b951bbcdd4a7c42ccae9c46c31ea": "AsyncRAT C&C",
    "6f9fa7d7fa5dc993e0823371c8e374e9de136265": "AsyncRAT C&C",
    "6fb23d09fa946b5fef1090f952702933414547f9": "Qadars C&C",
    "6fb3f5e9059a30d7a6ba4464a37db39bba69e716": "PandaZeuS C&C",
    "6fbcae7b3ffa53def52195e187364adca0030719": "Vawtrak C&C",
    "6fc7cde8ad0cad37b2eb004dbf59e25de6c71dc3": "AsyncRAT C&C",
    "6fc7fe77aaac09d078cb50039ec507f964082583": "Dridex C&C",
    "6fd6052eef50707b348a0032f8dd633ad1c6fe77": "AsyncRAT C&C",
    "6fd6603f04bab782acab760e0238a550a87337e8": "QuasarRAT C&C",
    "6fdf5429fa84c5585ded4fd9a17fd37e95711b4b": "Quakbot C&C",
    "6fe1806a42158720a236f30c475ec19f16ccc690": "OrcusRAT C&C",
    "6fe5159dcd442148ba1626970d46395f60a3381c": "TorrentLocker C&C",
    "6fe7c0428113cd5138475fb6c7cd51e957a81d87": "AsyncRAT C&C",
    "6fedd77dddf2dc6b636a6d3063a44c6d8d43e124": "Dridex C&C",
    "6ff33235bfa8594cac5bf678da5ab57905bf8dc5": "Gootkit C&C",
    "70027f40af91b7cf5f77c0d9049e8bb249f2b81e": "AsyncRAT C&C",
    "701379685c8634db5807046b4971ed4c8d4d7f31": "KINS C&C",
    "702a14ea45ebb8466f05f5c5f6e7726c936f981d": "AsyncRAT C&C",
    "702d015c520fd5b76ee7ed49b38f8892372ac54f": "TrickBot C&C",
    "703f8e0542fdb6ea84c15eabd4d7cac8b3474ef1": "AsyncRAT C&C",
    "7041b78030cd28d97b8df054ecbd171f7e0f2530": "BitRAT C&C",
    "704443ffbe380fb0b93d12211e03b3d8efee20fb": "RaccoonStealer C&C",
    "705066391f2b7f8cc350467bb337648cc1768256": "Quakbot C&C",
    "7082208f279b695c53e3c5b58b0744aac7458531": "Dridex C&C",
    "708c15567f0516f3a3a4b1c98c1ab0037591f82f": "RaccoonStealer C&C",
    "708f3b3af3a2027115a7e73d6ef72d69a13e37fe": "CobaltStrike C&C",
    "7092b47fc480b42029b81db21b6d8753a3326395": "AsyncRAT C&C",
    "70bf60e172c43d076571cfafbba3a6ba69a25084": "Dridex C&C",
    "70ce928698f7a4874a7741734d0322f3dfe0fb1a": "AsyncRAT C&C",
    "70d419afc742e456b442cafd24d703b7c7ae0193": "OrcusRAT C&C",
    "70e1cc07a431a0d0fc866bba2faee20b4e14ac9f": "AsyncRAT C&C",
    "70e90c3e40fdb8b004f9a5ec13f3f28fd00caa44": "Dridex C&C",
    "710a387e98a602ca0b3097ffd3eef2135c23e5fb": "Dridex C&C",
    "7112c502625cec0a0211714f8d5c2972868963d4": "Gozi C&C",
    "7128e2ca3643a8ccc4c7e4cf3f7be66202af9b43": "AsyncRAT C&C",
    "716071f35273a4cff5f2267b9795abe239556263": "DCRat C&C",
    "71610ac2b12af63e568d6f3a84edfb89a66f2f43": "OrcusRAT C&C",
    "7164e7a7570cac95f4eeb6c728ba37dcd123ab94": "BitRAT C&C",
    "716665789c85bcae3843309b61994d2e6cb92975": "Dridex C&C",
    "7177248707fbfdc635f434c345e625c76f409d27": "QuasarRAT C&C",
    "718e06df0d91e407aae8053a1917d2526e581130": "RaccoonStealer C&C",
    "719cce11b3f0ea6f1e0fff0fb434ecbb6caa3540": "BazaLoader C&C",
    "71c8b3707500733dd28c05e5b82008e174677759": "DCRat C&C",
    "71ea04fcee9fbad2cc626af14e88833048b82209": "IcedID C&C",
    "71ecb581a291c23e9968b88c58b0b9b07baf3f05": "QuasarRAT C&C",
    "71ef80bdc6203b26e45feefcc4ed69695aef0a51": "TorrentLocker C&C",
    "71f87d11e51073609573f591fb926770ef450758": "IcedID C&C",
    "7217b1227336156c6b5eae9d85e4107e2f74d8d0": "AsyncRAT C&C",
    "721f6351c54780af14724247fe44208381782446": "KINS C&C",
    "7220d8f55a6baeaab5c6432001708ce109babba4": "Gozi C&C",
    "722b944fb512349b7f7200259b9d491ebcf6768e": "Gootkit C&C",
    "72302e9886f9ec7e6948f1152ae7c2ce7b40bdec": "BitRAT C&C",
    "7235cf3ee7b619a2c49dbde02556a87b889b43df": "OrcusRAT C&C",
    "7238822758be10e544507520035312215db40460": "KINS C&C",
    "723ad7c118e322c5dd0f7184d27b795f0a9b20cf": "Vawtrak C&C",
    "72894e2a5890e7605e82efbd83eab693c31ae363": "Dridex C&C",
    "729e1c86f46bd539c2204cb0227e6dec16621264": "PureLogStealer C&C",
    "72a563444b6cf33fb6e022a01b876656e1edee40": "Dridex C&C",
    "72af2a37c9040f9abea02975eb8b8cc9876ec562": "AsyncRAT C&C",
    "72bdd3b75f4abb8d9da0ac9fca98af772fc7703d": "KINS C&C",
    "72ceed5539c60fe7efdbc87e777f731c75d3ffea": "KINS C&C",
    "72df115b1c9812d7d8774a2cfe695ae429c1d6d5": "QNodeService C&C",
    "72e61364d9f0fe15e5cd0fd6afc4b212cfcd6470": "TorrentLocker C&C",
    "72e9aef3008a5b24cd048c150db3ec6a6bf959d7": "Malware C&C",
    "72f1bdd9608261b11643994c950b70e6619c8ab9": "BitRAT C&C",
    "72f24ca3d56583a28cc3ec90aeff6b16e22d1eea": "Malware C&C",
    "7314ef4bedb9c0a5b85a6b3e9c9d63cf82e207bb": "AsyncRAT C&C",
    "731c589ff2874c29da6b937d23aecb2dc902c5f7": "Worm.Dorkbot C&C",
    "732acc7bf975acbd3243b5f08c68ad2968c39228": "AsyncRAT C&C",
    "732b1b658b4a878c23888f613c6846f1b530067b": "Malware C&C",
    "732bc431d9d422401c185370f481cc2ceb9d8326": "TorrentLocker C&C",
    "7332640210cc4cf0157a7d6843e9793f7d5e75bb": "Vidar C&C",
    "73332589f7b95bd3aef28dab94a4101f169d3b41": "Dridex C&C",
    "733336c3826c84c4d0ba3a3d431278d3ba5063dc": "TorrentLocker C&C",
    "733afe38870f2f38f5347cabcf6df68eb77b8937": "DCRat C&C",
    "733b2eb49c5d190355d0cbcd86cd015085de517d": "Dridex C&C",
    "7352fe071b95e726c1c5ffcbf258c4d291eb20fe": "QuasarRAT C&C",
    "735892ad2491e9feb0314ceaaed2a66d288d9dea": "BruteRatel C&C",
    "736ce32aa038d723891771801cb7ed5c76a96aa2": "ServHelper C&C",
    "737013b183034e749e524a761c171077ccb3eb11": "IcedID C&C",
    "73743f8e80db8dd4209ea9d0cec71e43584858e5": "Dridex C&C",
    "7374b2809bba52954dc61b4bcfe7005241e2c653": "Dridex C&C",
    "73b1ac5c4d9da2753429c758f344c27bde9f3c25": "Malware C&C",
    "73b25af58c1ffc52190c62d3b60e3a88d7ebea24": "Dridex C&C",
    "73b388587e7c4eacf93e9b72fb896fd9c15ee490": "TrickBot C&C",
    "73ba25920c9859e84045fe0033a48faeaf627806": "AsyncRAT C&C",
    "73bbe130c50f1fb459e39c151a0859cfb97b9402": "Ousaban C&C",
    "73beebdcf34c7601ada44e682e521be8965b87fc": "DCRat C&C",
    "73c34b9498934f5f781a4687bac29017f6c95fac": "Gozi C&C",
    "73cb76a3cb40b8310d13e82faadf58f628a1966d": "Malware C&C",
    "73d8ec1f29195ef2d9e0b618e72f3c80c0ac6ba7": "Gootkit C&C",
    "73dc7523ccc6be65b1b12a9fa82409a445c733cf": "BitRAT C&C",
    "73e2667810e03ae248c57cd7791e12d75b413922": "OrcusRAT C&C",
    "73ece1b64a6dc90a4de27d74884c57a67d8d09ef": "Gootkit C&C",
    "73f88fe673ebeeb1ef4d6fc7927b46c8f48ac450": "AgentTesla C&C",
    "7406457d942ebc79e491454cd57dfcf9bcc895af": "KINS C&C",
    "741f7925499abe4689e61fc0681a491e48c45815": "TorrentLocker C&C",
    "74279120256bc0961ba27acd52d041f4164e863f": "Dridex C&C",
    "742de1818c41b66396ed96286e601c3a58336950": "Dridex C&C",
    "742e6bcc977a03c512d05a4a1c0b10e081be901f": "BitRAT C&C",
    "7439d501757795b6f90f56af10c9bc5dc7db94c0": "Dridex C&C",
    "743ac4d714f4af4f2cf76d14101992faa9e620db": "AsyncRAT C&C",
    "743e0f396d6e0bae34450c8216633c652bc2902a": "Malware C&C",
    "743ebef69416d429937637b21bb62e393271500d": "Corebot C&C",
    "7448ea4e971a9b61ac3ec576edb47b6ad3ec7e53": "DCRat C&C",
    "744fca3ea19abf015b805b2bd71fed773737fc88": "AsyncRAT C&C",
    "745d36f3e1ca7fec7fb3a49ecf0577b9584f2611": "Malware C&C",
    "745ef3ba796607bf126840e1a0f9fef8649b2dda": "Malware C&C",
    "745f7f9ee8ec74a2009f4040d6443abf12d6d22a": "BitRAT C&C",
    "7467e9d4e466f5fff2543d0e196638f2a2e2365b": "BitRAT C&C",
    "74722474093f099b0de73077c5f22d2576077c3d": "KINS C&C",
    "7486ac5b2af44413003697968d5c2f46faa649ca": "Ostap C&C",
    "748a291dd83f4ae3a1e48d3520f25d7b4001d928": "TorrentLocker C&C",
    "748e318f082328d05e1ae68b88e5139ffa734b5a": "Gootkit C&C",
    "749a64dc1032e0b0e733370752e35c0e6150b36e": "Dridex C&C",
    "749b34da4ac89cbbe64cf3805f981616257fb85b": "RevengeRAT C&C",
    "74ab9ce79f5afdbd64046a11cd34ae4141822bda": "KINS C&C",
    "74da056deb7dd9a0cefb8023614d542b79f41d01": "Dridex C&C",
    "74f329646906a52a929b064f86aa7cda3c015bf1": "AsyncRAT C&C",
    "75002bafc6e9a7556098c39b81c4a48b4f42a2bf": "AsyncRAT C&C",
    "7502e55deb4d19b96ea9612634824b2fb6ad966d": "Vawtrak MITM",
    "7504a0427e33a20331e8a676a992ab82b9f98b13": "AsyncRAT C&C",
    "75101bde05222242a1ca5b08042ca40db740e1c2": "Gootkit C&C",
    "7516f70cb9a1d4f2f3a57156771c707d045cf143": "Gootkit C&C",
    "7520f23b99d6fea63f0c1baee0c83db035a1ddd1": "Dridex C&C",
    "75369373888fecb5a1e0cc4fcdc46dbfc1b19a41": "BitRAT C&C",
    "75670e16b0574f3e618b73766628dbd3b7a0806a": "KINS C&C",
    "7567fd346d5155d739300864a0b1974089b0b430": "AsyncRAT C&C",
    "756d229b875de95163749330de2b61cf2d790b39": "QuasarRAT C&C",
    "757ec439a769e69a74b1211e6ae57928d7eaf351": "TrickBot C&C",
    "758462a02eb4460201d68255cb3f39ce4bdbf0a5": "AsyncRAT C&C",
    "7584b6d8528712da45bdcf94e160fcd894a59b7b": "Quakbot C&C",
    "758673e30b58671ff3ad1a40e2392b76f031dbc1": "Malware C&C",
    "758c1471e8764184e4ec4344419c688d5b7f52af": "Gozi C&C",
    "75901d7fa713b3615cf0dd0a1ee91f917f280d5c": "Gootkit C&C",
    "75988b854b33e272c758b2bd1421923795def02c": "PsiXBot C&C",
    "75c2c8039f6aa0acd8aeb6f10d437752f1ade615": "TrickBot C&C",
    "75d10311e40dbf0fa7fe4dde14b5af8b3cac77ee": "Dridex C&C",
    "75d178798681cf815785952503752af65b9d3a53": "AsyncRAT C&C",
    "75dbd588311aa3cbc7dbee58ec4171faeb46803b": "AsyncRAT C&C",
    "75dcb0f98c1cc6c123942289edda891f54ee6751": "Gozi C&C",
    "760273130d14067352b2caf994eb38f386d3c213": "AsyncRAT C&C",
    "7608080396c6ed01d9740bf6cb48891b75eb3838": "AsyncRAT C&C",
    "760887d65b34074637f02f960ab3b3a59a379b5d": "Gozi C&C",
    "760bb4765c671e0c057b778d67f5b5ea947084f9": "Dridex C&C",
    "761aa02e86542bd5dd13abb83b595af236a738a9": "Dridex C&C",
    "762e04c8cb4d0f4cacc822028e7a8473c27f1f50": "Gootkit C&C",
    "762e0c3878529a1d09dfabca4ef8df26ca6b7712": "IcedID C&C",
    "76355cc7125f9c31620b6648d42c3bc5c71d3cfb": "AsyncRAT C&C",
    "764059d7bfd25e98fc6664bc8282b799df639140": "KINS C&C",
    "765d953ea83674769196d30de329b1b9a321fa4a": "CobaltStrike C&C",
    "76654eb65dbfb6e0521b1943edbe8ff446916dbc": "AsyncRAT C&C",
    "7669103ea0a2e900179e5220a13bf3415438b665": "Dridex C&C",
    "7673af21a60a70f50691d9b1a07bb517c4d9a228": "RaccoonStealer C&C",
    "768efe87e0b95e975262afb35e0350c5fe10c868": "FindPOS C&C",
    "769bc6c089c0343ad1f7bd17967ee80de823dd29": "Dridex C&C",
    "769cf6e5144ea7ddabc4c21f1fba6961927e2ea8": "AsyncRAT C&C",
    "76be2015186a03afbf39806ce719842f9339e2ea": "Quakbot C&C",
    "76c7c090dc323f56e2c03111ca92ae67efa58db0": "ZeuS C&C",
    "76d93e08065baa09df32a4f8678fa99e11e80d73": "BitRAT C&C",
    "76e271116e033a5f45a8d41f1f94dbdd055a79a8": "AsyncRAT C&C",
    "76f3a46ee4efa9bec5eaa1440fee7cb74c24fd25": "Gootkit C&C",
    "76f47d399ea1b628a9587a2f6d412872304d40bd": "TorrentLocker C&C",
    "7706be29ae63190c4ecd69e72f0dfa4d7037ad3e": "Dridex C&C",
    "770e544e3c278a10b717f0d79101621ba199af27": "Dridex C&C",
    "77169e38c783cecb65a7d1e89079455ddd1a4ef6": "BitRAT C&C",
    "772c8f46f11ba3c7612b0fddc01ef4348f21483d": "AsyncRAT C&C",
    "77323847515762733c9463db651291e7fdace94f": "ZLoader C&C",
    "773bb121214696294101a73318fe30bfc32c2dcf": "Quakbot C&C",
    "7743a82b472bc6fb2670576d2c3025ed2a25668d": "AsyncRAT C&C",
    "77457b9dc245ec9cffb2e33883b3bfdf373dfeca": "Gozi C&C",
    "774870240b62a895612d5005d69bc3914f9902d1": "TrickBot C&C",
    "774d9ea98b048e604318fd52aa2e5b6bffafeb82": "DCRat C&C",
    "774ed35032868dda3e7f36df6d380ec2456f1e58": "AsyncRAT C&C",
    "7750df982f35fa4285de8c7ec831e11334e87067": "Dridex C&C",
    "775c581b0896480ed3298920836268edc30853db": "CobaltStrike C&C",
    "77614b1910584d0e241775d08f28fa967c65360f": "VenomRAT C&C",
    "77619e1035ec379d9c3b76ebdd61fcca3713ce84": "KINS C&C",
    "776384c49cc893139b680fa92da82a11d754a25f": "Gootkit C&C",
    "776539482ea8317c8c59df9e052bbbb1fcccd507": "BitRAT C&C",
    "77663672e346b91c83c3bce74cfa14098c7e445c": "Dridex C&C",
    "776b2a5737a0da80b984c7883ed262425584ac7f": "BitRAT C&C",
    "777bbab7e83ff8e24cf6f2d59cdb33f43cc32a92": "Rhadamanthys C&C",
    "77943020f237f2f19eae2563eb4e618693a5b37b": "AsyncRAT C&C",
    "779d2a1502e4e70a73c4d09c925031dc83e35e41": "BitRAT C&C",
    "779e4cdcce1ee1e9db3faf8dcc665ced8e4eeeea": "BitRAT C&C",
    "77b66d0d5a709488ab7fd4fee38e27eea28eb402": "Dridex C&C",
    "77c1912e2a4f806849034416fbaabbafc14622df": "Dridex C&C",
    "77d64a9e7d6f983a450481ef78d99f3a6b8a5925": "QuasarRAT C&C",
    "77dd2a783df077068fb06b819ffb1e0a42e9988e": "Dridex C&C",
    "77e1b32ba4185330a30582b98da963944574ee54": "Dridex C&C",
    "77e1ce64c90713d69376a654f4c56c1e0262c545": "QuasarRAT C&C",
    "77f0b3ef2a939f801dc7e761e072e71b3413b1c1": "IcedId C&C",
    "78050c4a44be78898c56c40684c6f85514a58cb3": "AsyncRAT C&C",
    "780e3b977fc119e7a0e1cd5192909ba0ba95c8c7": "KINS C&C",
    "7824e53f1ec2c9e8896e2469519ac860153450de": "Quakbot C&C",
    "783591efd623cf4dc9838d308bf5317912756e72": "Quakbot C&C",
    "7836ecdf37afa3d9d0aead7465e43c1464082a35": "BitRAT C&C",
    "7839b6073e05919840ba0c75474c97ca9a82ab7f": "BazaLoader C&C",
    "783a7c78df32dad92190fbadf0960a2224340a08": "DCRat C&C",
    "783b413f99782dd64de77af0fa2c8ecfab1a2fbd": "AsyncRAT C&C",
    "783ea8ddf7494cc9360bb035f2dfc45ad06047ab": "Dridex C&C",
    "78436c6a8632250c2b598d0695b92669126abb74": "QuasarRAT C&C",
    "7857c5f28c4f52a4bfc9eb35afd7ee27229a40e8": "AsyncRAT C&C",
    "78585dc94df48489122df9a2da6f44e43fd6697f": "AsyncRAT C&C",
    "785a45f84f05734852e2af57af8eeeffbcfcc269": "AsyncRAT C&C",
    "78615ea1d467bb076e091fa9b13cc309c5c69b00": "QuasarRAT C&C",
    "786938e85fa494c1a2f1aef77d65a631fd7d0b6f": "AsyncRAT C&C",
    "78821d7f7c206bc0f9226c2d9d45994c832ebda9": "AsyncRAT C&C",
    "788d24640fa077f22266219843b2fa851b585e9b": "KINS C&C",
    "7890dec71d555e50ccff00fac9943365b96a23cc": "Malware C&C",
    "78a0e7f73b08ebb223e1e14aba50d67c35fd2f0c": "RaccoonStealer C&C",
    "78aa4a83bf663fc1d6d87462b7db352fc41cfa70": "Gozi C&C",
    "78bc50021362b61652204981b13fe17e053a03f1": "QuasarRAT C&C",
    "78bfbd931ddde8b1c23767e11679983a3b97a42a": "OrcusRAT C&C",
    "78d6b430f148d52493fec0173ace29584612ebb4": "AsyncRAT C&C",
    "78fbd20c5cd27850140fe4fabc869b72ce782c05": "Gozi C&C",
    "78fe7c561c4352bb9c161c12a02938b1c42e70cc": "PandaZeuS C&C",
    "790bd6d1c1540ae1bfb811f2dc1e0185525c5dcb": "QuasarRAT C&C",
    "79227eb9434eac8389a5f90e0192be724caa93dd": "TrickBot C&C",
    "792418c297203344559c6a74a1175d3367ff4810": "Dridex C&C",
    "7925d921383067b60717f7410402aeef3ba7903e": "JBifrost C&C",
    "792cf0afe37db099d98d3ec9523749424e0ffdd4": "AsyncRAT C&C",
    "7944a34939efb5ae8826dc51af2b1d9f3db4105b": "KINS C&C",
    "7946c5206f32ef5433b38840e7c3519aaccf6dbd": "OrcusRAT C&C",
    "794d0f0ff4ada97436722c92020d1bd3c53aee55": "TorrentLocker C&C",
    "795ae7766804580ee7d3db01ce24a178df9ede23": "FindPOS C&C",
    "79638e1cd0d80f38c94b8440469bdaaf9368bdf9": "CobaltStrike C&C",
    "79661a6420d242bef734139763e03d53797ab6fc": "Malware C&C",
    "7966acafe2f5a95bb0efbc224ba1133b2e613cf3": "TorrentLocker C&C",
    "7967bbdde9c117468d26cddedb20e21c4663bdd7": "ZeuS C&C",
    "796a99bc9f7db31acdd48b5a761f70b3b2170bf9": "Dridex C&C",
    "796c40c57d5e4bf22484ab54dc56619c171621d9": "AsyncRAT C&C",
    "7970c2029edbb83e6bd65073be18684ac9ff3f48": "QuasarRAT C&C",
    "7972b9a89645d7696ed0542a8b944fdc24f47fb2": "Gozi C&C",
    "79845a4e02fa724232120e67c048000a9dc74239": "Teslacrypt C&C",
    "798c126d302c987e4d48ad054e317d592ce8d484": "AsyncRAT C&C",
    "798d6f8e469e73ceae4dbeda4cf17743e3c65f3a": "AsyncRAT C&C",
    "799873897bdbccaea0eeedb9df13cea9387b906f": "AsyncRAT C&C",
    "79aab50a24664798dc5fab9e48fa9f936303d3cf": "Quakbot C&C",
    "79b1d8166a5cc7fa8db696b6a3b8da53a84cb066": "Shifu C&C",
    "79b37357b4158ed84f18f4e85b7713cf2d04a0d9": "QuasarRAT C&C",
    "79c06bbf063402b668f92d014aa3a4921b256668": "AsyncRAT C&C",
    "79c5dbe07d5e14a382987916a2d9eeafc41d1441": "Malware C&C",
    "79d5054a1f0b146cfd6eeb9e6833c05747ad483a": "AsyncRAT C&C",
    "79d67a81e7801d9ad7bbc6c42443a0b8e401aca6": "QuasarRAT C&C",
    "79d85504a4d04b486bd156d49cf712d3300c0c68": "Dridex C&C",
    "79e10a84017c36a7890f49fcab7dc7cf192826d8": "TorrentLocker C&C",
    "79e234304465ff5c7674223424a185a70bc4528a": "Quakbot C&C",
    "79ee250c741f4b69168e02cb41b5f4e9160a4bc6": "Adwind C&C",
    "79f4fdc70e5b91b8883bc77e91331893808fddaf": "AsyncRAT C&C",
    "7a03a2d9f0cf405cd3ec2b1a10e26aa1b63657b1": "Dridex C&C",
    "7a04d2da1df0816f7ab6595d5bcff8416e36e140": "Dridex C&C",
    "7a0b0fca51e497c9aa0dc4daaa142f563705fe43": "TorrentLocker C&C",
    "7a1a474a59a16e536e8b6921275a583c6698f6ec": "AsyncRAT C&C",
    "7a1e2ed59077a42703315cfab940a4e8f7c2ae59": "AsyncRAT C&C",
    "7a25e4a3ee1939afce7f01781c04bac2e31c5430": "AsyncRAT C&C",
    "7a2775c71e27e386153fbf3ff8b3cdc52c780aa1": "AsyncRAT C&C",
    "7a366fef4ff8d571d815a9f5a73574ea2eeaf40c": "AsyncRAT C&C",
    "7a3f9f314e4d99e041ffc80c8ed8b1b42fff321b": "KINS C&C",
    "7a405bd5258669dcd689732aecefe90df250ae2c": "AsyncRAT C&C",
    "7a4d1217958c457ba268f6ccc0d3be6a70345751": "KPOTStealer C&C",
    "7a4e7ec90f7b390dd82b67eccba8e775420b7645": "Malware C&C",
    "7a5dfe85e08ad51b28aa628274027df367199fd4": "PandaZeuS C&C",
    "7a668d51bf57bd86b0da616ef41be1a1d44742f3": "Gootkit C&C",
    "7a909eccac2bcdd241e183942b46ff6141dd17af": "Malware C&C",
    "7a998d76531087293b250f1248b2a1666ed9b2c5": "JBifrost C&C",
    "7aa3b93585b419305ac16463d03a8937c886f0ee": "AsyncRAT C&C",
    "7acc9a3244425c97d532f4aeaf9d3c292992e14d": "QuasarRAT C&C",
    "7acd43e7e46007f493a8c0f7d98d4a51604638de": "TrickBot C&C",
    "7ad0b9d028790dffa8f77b4b1bf890b4470edf96": "zgRAT C&C",
    "7ae791cabce914eb58df74faea876ff3abffb998": "DCRat C&C",
    "7af1e61fe72a1625f9ec0baaf50f86ea00ae8356": "Malware C&C",
    "7b022285514f710704ea146913f0fc755a53b1f0": "AsyncRAT C&C",
    "7b07ff1fe7813b14975d5677513b9e38ff7d61b4": "AsyncRAT C&C",
    "7b0e1241ded2789e6a82ebfac3a2d6d19a44305b": "ZLoader C&C",
    "7b18e4749fbb7312733fe808240cb20d1958d99a": "AsyncRAT C&C",
    "7b19f4fdb1efee2ec7381dd9286e939eaecc3491": "BitRAT C&C",
    "7b21cfddcf88de4c3832a07d0a0f22b232ce251b": "Gozi C&C",
    "7b3353c205155b2aa653351274a4bfa83b1c2b62": "Ransomware C&C",
    "7b37a715de1ac0cda35388184b8e95e606a78453": "QNodeService C&C",
    "7b3cb66ed1fbee0f68fecda8d257d96b8de623cf": "AsyncRAT C&C",
    "7b579d4dc295bbc4d60570a44a77e0aa8e1d75db": "BitRAT C&C",
    "7b5a8f289dbd708e98a7f8df1e05fd0ab4e28fec": "Gootkit C&C",
    "7b5ebaebd48e20472bad60dcc71e9879cd461dde": "DCRat C&C",
    "7b607e83bca7c152ff93df807331ff4df6763183": "BitRAT C&C",
    "7b62ef2b599c7002bef6c9a6c0c833a55e65fcfc": "KINS C&C",
    "7b6bd2c94ef805fee0d6a6f417e6b88b92bb1012": "CobaltStrike C&C",
    "7b72316fe4a9069c8b4f973dbb2868f1b9e9fa63": "Gootkit C&C",
    "7b7842508e74b0a6c2b84f7118ee4ea73d0dd12a": "Quakbot C&C",
    "7b88365aeb508b4883dafd96306c7095344555a3": "AZORult C&C",
    "7b95d2b5010207676c351e9df8876f1ea6c3f9e4": "ServHelper C&C",
    "7b976d83a18acdd0a0bc6d74c7c61e9563aa4f48": "Gozi C&C",
    "7ba226e0538c234638beae091ba53f0282fa9fb6": "Gozi C&C",
    "7bac56082cd7b49e82cd4f66844aa19ef9bb81d6": "AsyncRAT C&C",
    "7baf03316e2ba90127ff3c9bdaa72f571ed896b0": "Gozi C&C",
    "7bb416b0a0d5ac87f5d3bc05fd23c4361b14297d": "CobaltStrike C&C",
    "7bbced9e278eacdb84db99a8941600df88f1ab36": "Vidar C&C",
    "7bd329dc50b3bc0084b0b7bb5eadd28cc5e13b9d": "AsyncRAT C&C",
    "7bde4476d18e87837c1508cf57aff9429f17b7b0": "Dridex C&C",
    "7be59f8f0811aabcb73c9f1c7df3b3e66f964ca0": "PandaZeuS C&C",
    "7be6ede110795fa542c0e6d3501659698971abec": "AsyncRAT C&C",
    "7bf1fd8b0dddeddcba4b881bd8b8d4e0fe42f39c": "Dridex C&C",
    "7c0362463cc2bbdd16b9d2e246f0e4489b1fc3b7": "Dridex C&C",
    "7c1cdfad432163480d483d7663117861e7ee84ad": "Vawtrak C&C",
    "7c29b512f52f6353605cf4232ef8d861f2ab8e61": "Gootkit C&C",
    "7c53955ed331be728cdda7198a8f191051457266": "Malware C&C",
    "7c5588f72d859a2b37ad72f0723274a0fe49ec2a": "PandaZeuS C&C",
    "7c58c7ec9ecd0e5e6f022bd72af415aa4f52ad10": "PandaZeuS C&C",
    "7c5be457986ac6a7d76d20a48f38fcdaf4863dab": "Dridex C&C",
    "7c5ee09b5e3a1611b0787ca508fd88a2c21859c0": "Qadars C&C",
    "7c6bfeac60440917138d9572571ead8a772c184e": "Dridex C&C",
    "7c7ca5ce91b1c53867e229929656ae8652da086a": "QNodeService C&C",
    "7c80e02d0de344fe45dbdca500ebf4eccadd0262": "Malware C&C",
    "7c8fbb4f62136b1f2ad1815172a0a8c179d2b722": "AsyncRAT C&C",
    "7c919d192569245deca6ae6c000dd85253141655": "TA505 C&C",
    "7c9a3967b2467bf3547298b15fb7419271cbe046": "OrcusRAT C&C",
    "7cc7345c838f4c8539cf520a7e29255a9a469366": "AsyncRAT C&C",
    "7cd80bc6f1e5a55682660870db521198253eaef9": "Latrodectus C&C",
    "7cf30da5d9708f1705d9f82faefc2057c9d30ac1": "AsyncRAT C&C",
    "7cf902ff50b3869ccaa4715b25bbea3cb18a18b5": "FindPOS C&C",
    "7cfe275ceae4245c73e08763124d17ccaa19bf44": "Vawtrak C&C",
    "7d06e7bdf3523257608afd256ec9f3235208dd8e": "BitRAT C&C",
    "7d08c9fdfed175f12915eded8a403fbdfc2bc2d3": "OrcusRAT C&C",
    "7d0afe7852118019f1a21bba512e8d88aa95a506": "Dridex C&C",
    "7d0e5b26795bbc73e78bd0a150040086c93ca050": "Malware C&C",
    "7d0f8a9e44bef4e3cd204c169ea16f9c3602c710": "TrickBot C&C",
    "7d1f6fe3a4372d9a5b5dda2678e30855bb9ab1c5": "AsyncRAT C&C",
    "7d2b10413540ac41fefa9330129f56c8cc51c9ac": "Dridex C&C",
    "7d2e9e8b18eb3e32ea4c1973787cb63405c2f77a": "TrickBot C&C",
    "7d2ee42f4f0a70863a3c8d045999524bd22f62bc": "Gootkit C&C",
    "7d3ad8ccc748e0a340d5c59a86de52506e577a40": "Corebot C&C",
    "7d5a718a2a41d26a15e4452da7b2cb36f339e8f5": "RaccoonStealer C&C",
    "7d5e86565d82bd2828f7e6ca9dbffc1b5fe5c940": "DCRat C&C",
    "7d72398d29af30c779c5840e36edb106d43df60a": "OrcusRAT C&C",
    "7d7f4abdd7ba8a7a8f568534c94d638936f35399": "AsyncRAT C&C",
    "7d914eee0deacbf6b4eadff93eedda6a540a4806": "TrickBot C&C",
    "7da454e73d546a8d3f84a8feb557a90486c2515b": "AsyncRAT C&C",
    "7dbc4f75622101a927b04a2718b37a8d2280b5a6": "IcedID C&C",
    "7dbfa218cefe836e16c39d79fc56670d237d9c58": "Dridex C&C",
    "7dc516b0436dc0be8296dcb675cb96a819fe0f68": "Gozi C&C",
    "7dcf447248994cc80ddeb4c596a53fbe16f739ef": "Gootkit C&C",
    "7dda9ab438a3b2d47b4ab07ed506073fb8812373": "Dridex C&C",
    "7ddc1dad5c73f406b56f48d716bbcac171b693e2": "AsyncRAT C&C",
    "7de01a6d6300c5f9afc47fbf45f2d530c1d0c9de": "AsyncRAT C&C",
    "7dea4f9356c8470ff95cc850af22090474f9deeb": "Dridex C&C",
    "7df458e26a20581d2d9fd78fdbf2b450bdbb643d": "DanaBot C&C",
    "7df535647619f38f5fe9a9f413906ab4e355909a": "TorrentLocker C&C",
    "7dfe9c512c65a720f76f904e0a494010ed7de8fd": "Malware C&C",
    "7e07b1ffc24b295ee807124f79ff43db53cfd885": "KINS C&C",
    "7e11e70ac0b255b64a9e7ece14e90042abbc242d": "IcedID C&C",
    "7e1789fa7e4d346980c1157eeacc0d492dd5bea4": "Dridex C&C",
    "7e1905f5f7a6dc4a209362fa1b21c42c63c8422b": "AsyncRAT C&C",
    "7e1ed88eeb98d523422bbbf22f0a7dcfa790ded4": "TrickBot C&C",
    "7e255875b6e8175a6854850232c560d6c5de935f": "CobaltStrike C&C",
    "7e2afd004e7856ab98f96c8eb1158c1e5e87b605": "BitRAT C&C",
    "7e2feb5c7eaf880e8587b349d3dee94a77650dd4": "TrickBot C&C",
    "7e460f1c30c684342fb8f96e4547f67b1d3aee9e": "Gootkit C&C",
    "7e4d4066c55d43bf6bd603703a492a30125ac42d": "Dridex C&C",
    "7e55fb8767150f5655cd0ab853c46ccd83e0e26c": "Gozi C&C",
    "7e57f51778614cbb572d28fba245b87d0bc5f9b3": "KINS C&C",
    "7e625c5331bc095a2a09d739f01deed7b82eec4a": "Dridex C&C",
    "7e75cdf922b9a24f86da31581ae4c62dc1bd25b0": "RockLoader C&C",
    "7e8556d024b39d5b6924e3e0b3735669fb38bac9": "AsyncRAT C&C",
    "7e8d6ecd36190c8564808594d70552851de3f6e8": "AsyncRAT C&C",
    "7e8e411b646d5ed8373d5c867f23a4a405aa7238": "Quakbot C&C",
    "7e9a9e35fcb7539615728d08c2754b8721560134": "CobaltStrike C&C",
    "7ee02116738ff4c6d430cc5e9ca3aee07960af1b": "DCRat C&C",
    "7ee0d03c2dd96572905a4d86bc0a6dac25c7377d": "IcedID C&C",
    "7ee1218b40e55a31e8e598adad1912ba729e4fe0": "AsyncRAT C&C",
    "7ee2090ee29ff160f8c1b5f71b0cf12be9b9f086": "Malware C&C",
    "7ef9fa16b91542f409aa62db1b932ec1325855b1": "Dridex C&C",
    "7efaf5f1dbb6339757f5215393a5f1731348cdee": "Dridex C&C",
    "7efcb520cad9ac926a653d4dbaa8faee59faf927": "TorrentLocker C&C",
    "7efff09f97443114ea57e5cf3409476afc63064c": "Gozi C&C",
    "7f0af1cb4f4d7df78d041c4111587afec62841e6": "Malware C&C",
    "7f102bcc0a6fdad4d161773baabb0843173ea76f": "KINS C&C",
    "7f21ad9d828bfd8502ab3ec896eb746d710cfe47": "AsyncRAT C&C",
    "7f23d0bf557e5bc58cb781da34a5486769183db8": "Gozi C&C",
    "7f2af7c4ba2d50cc359c9894b54c0c0e9459cafa": "VenomRAT C&C",
    "7f48d4aacf7949e3de646c610b9c5979c68ec52f": "ZeuS C&C",
    "7f4adb5eda82724cd6bdd1eb33a23efc2cc15104": "AsyncRAT C&C",
    "7f5172b4cafe330560d8852c116c010405d9bb82": "Quakbot C&C",
    "7f5609196fc5fab93b46442f417a4c3b90b108f6": "AsyncRAT C&C",
    "7f685ae416efef9d6528a680b1aca6699f12f484": "KINS C&C",
    "7f9b36d5678ba5c7eb1a1ac4f1ff59e10046a674": "Vawtrak C&C",
    "7fcd2c5608477d34c2a39e0a743a2052dcde94d1": "ZeuS C&C",
    "7fd9da4afb65569f0f48d0ccebb9acb8ede7ca9b": "CobaltStrike C&C",
    "7ff2f135b28aa1da693556deb53cd8abcd652d9e": "TorrentLocker C&C",
    "7ffccb887e7f10c3f6bf43736ea86d1a91f4a3e8": "KINS C&C",
    "7ffd7bc990c3eb7849ef9c4635d8c5a8fb16a7bf": "Quakbot C&C",
    "8000f03554af7cc9fed8351f33e421b0bd37095d": "Dridex C&C",
    "80013e039d9b45e0f05aaaf941d5dba9f7f5b452": "Dridex C&C",
    "800f1f322b78efffc7ba6de1d3054b5dd88ba9da": "OrcusRAT C&C",
    "80176a975ce454147df65b359ea1e6e3e1613dba": "QuasarRAT C&C",
    "802018d0950eda31a304f42c25e7743aa39a2ab5": "TrickBot C&C",
    "80383b3a06ed0815969c5356fb3431945fac19b2": "KINS C&C",
    "803c69a457c40afea53b9877315903b5cc64a026": "IcedID C&C",
    "804c89b228e9b2c6e57c19d2fda63add46479c53": "AsyncRAT C&C",
    "809eccb2e416b827d452d53793ecbf8c28e32884": "Gootkit C&C",
    "80a7161e8f1429e0b95dd190ed1e482f01cae0f2": "AsyncRAT C&C",
    "80ac8f7ca8c6dd1b5b231763e909505240a9d1a6": "KINS C&C",
    "80b911fdaf5503b844c9b49123f06e1b6574f327": "AsyncRAT C&C",
    "80bc79954a2f635e430123fdb24560890bdb7789": "AsyncRAT C&C",
    "80c2c5f2c649d17987d7769e1b58cbe4aacacf2b": "AsyncRAT C&C",
    "80c37278d342f8b4719523d36981b1227acaeaca": "AsyncRAT C&C",
    "80c8327fb0226378d1009e749c5e9121df9a7524": "OrcusRAT C&C",
    "80cbd68251613e2ab1d98cf7c1fbe059a4a7be46": "Gootkit C&C",
    "80dcab9a1b687f8f718b70071c21477b6259cb38": "Malware C&C",
    "80e38f4f18282b4c6ee0c6658ea79bc0f25d84db": "OrcusRAT C&C",
    "80e5b2af6ae13ff2231b6efc92c9fae46741a917": "OrcusRAT C&C",
    "80ec6970979151cae83ce1a41e2640d89ec746d1": "Shylock C&C",
    "80f6f9e3190507c27fb63f74485c7e3bc06a726a": "Malware C&C",
    "80fb1c50e80881ca4e07b12b191135efa10d37be": "Dridex C&C",
    "80fffed849f615fd531d74e5e6b326e4f018dfc6": "Dridex C&C",
    "810aa48d49e57d8e47ccc07846e3ca88c57e360c": "OrcusRAT C&C",
    "8119085b4f7a8d869e4b47c162fe3ecf1ee27837": "Gozi C&C",
    "81253a003f0003c9305d6a02c985dfc1be0dee51": "AsyncRAT C&C",
    "813529391d643765ec6ba55167a95a36171030fc": "Gozi C&C",
    "813af38ccb46961c68c2594673d4b2ae7e6d0991": "Malware C&C",
    "814cae810c29fd37d75ca2657d73a0d35c2840d8": "Dridex C&C",
    "8157cb4be0602934ce302ed06f479e28ff37f3d6": "KINS C&C",
    "816c8eedc2632de8a88b777e28f91a4f3f7e8936": "IcedId C&C",
    "81741ec7a864c7af3b5b4cafae49b03311186cc3": "AsyncRAT C&C",
    "8177aa396c1c82c0ed7dd48548e13647de853ac4": "BazaLoader C&C",
    "817cb6bae5342a5f7206ed67faac9ba5f7aba910": "BitRAT C&C",
    "817ce4c9b036bc5f76e27bfe5f02fddcb6bb8a80": "Gozi C&C",
    "817f60e0ced415d17a269db2f9b7b30f25b110d1": "Dridex C&C",
    "818cd927c3d52c8b576f9daa2f965a60dac3be23": "Gozi C&C",
    "81a92cf2479e7d547aef7cef42aad468b9755224": "KINS C&C",
    "81b0b0668987305b07735c579dde92e093fe9659": "PandaZeuS C&C",
    "81b62037f9d53aeeb06a9b39411ca9a30e8c6216": "PandaZeuS C&C",
    "81bb1ae8ba48256d19e1b826a057073b7bf8e6f0": "IcedID C&C",
    "81bf497b5615bd4557b870b5213ba018e6113d48": "Dridex C&C",
    "81c6eb5c917e4301cc81840c74938e9207bccee6": "Dridex C&C",
    "81fd0066e70f35afaffc21391d798b3ba595d669": "AsyncRAT C&C",
    "82053c5158ebd88c5ae8553b7efe18200ec0307f": "AsyncRAT C&C",
    "820738dfdaedb04c5a1713b4f1f50ffbf5baec5c": "AsyncRAT C&C",
    "820ed5d62feaf0695ee04e3ccb7dc9be82ce8a1e": "QuasarRAT C&C",
    "8223968fa0f4e8b386a61543fc03968b38a84682": "BitRAT C&C",
    "822683caec7dfe137bf47bf9ca176a9e94d9dc8b": "Gootkit C&C",
    "8229efab8216df19437cda4482f4c782bd5f6554": "AsyncRAT C&C",
    "822a45779a26117dc99e021aa319f7c4c4b2d725": "AsyncRAT C&C",
    "8237130d23102b8e3c9e395ff09dca34ec7cd3d2": "DCRat C&C",
    "823ca6c868b1c6b7dc995cd2424db8a7a76f3c2c": "KINS C&C",
    "824e1d886f9c048579cae1823f02a59819a9aba9": "DCRat C&C",
    "8250113c6e43e80c65596eb9d5dbf9c0c994879f": "QNodeService C&C",
    "8264b3520a1d927a3bb5af19f66bb897a8d885fd": "Gozi C&C",
    "8266ae61fc33271df633ab92f577b4ebed6019fe": "QuasarRAT C&C",
    "8280526369cfbb46ed5d8799f651b0e69a73099f": "Gozi C&C",
    "828880eeb4f67bc5e53a3d66b21824ee8cb0f74b": "DCRat C&C",
    "8295353c13fac975dc940bdfe7a5bda380a7716f": "BitRAT C&C",
    "82967d9227534bd7c5344308118c6f803a2b10df": "QuasarRAT C&C",
    "82a34db6eb6f1fa2d6383ff0d2675f096ba6bc1b": "Dridex C&C",
    "82ae6a008a3051f7f6dcc0040f0299fc1cb97aa9": "AsyncRAT C&C",
    "82b913eed8831b65393f24ebb0f4b3ec07635123": "DCRat C&C",
    "82c01da1b88b9f3a1cea2e0447907110ea8024c6": "Shylock C&C",
    "82c0a97f058893a77f8a2a27bb75b5fb7ad230ac": "ZeuS C&C",
    "82c7fea2a93ad0beab7841dc4a283e65ee905736": "KINS C&C",
    "82cb38fcf49a17e0e54ad22c095c2b24e6f85de2": "AsyncRAT C&C",
    "82d40e82a9ccccdacdecb827d7d1c5c3a1ab66a2": "VenomRAT C&C",
    "82e215a96a60b2effd68d89c35e4aef0f8ca6349": "KINS C&C",
    "8305cb9f39638dad87bbc1bfb84f8de1630e2b32": "Dridex C&C",
    "830f59685711410495b976fbc6aea388bd7b8213": "Dridex C&C",
    "83112eb8c6f735ef54e621e080e746b706458129": "AsyncRAT C&C",
    "8315a2dc688a96cb7025e069329ccd5a0a6ac4d1": "PandaZeuS C&C",
    "8317a85eaf39ec5a6f0380a3b9744b8e3ff3abe6": "TorrentLocker C&C",
    "8318861aa690c87c2d7a1eb65212ec4cbfcb73e8": "CobaltStrike C&C",
    "831d2aa2412a6b68cd4999d81e0cf15738f99c4e": "Gozi C&C",
    "832171b108d6f9e2a0a9d4533e1c6accfbba8072": "OrcusRAT C&C",
    "8332843c84514672c19e1cf122d02fe148a6a73c": "AsyncRAT C&C",
    "83487d170ed9ba794c9ab7bdb78c99c00de37445": "QuasarRAT C&C",
    "834f8f2f5cd9749543227d7fede9ee9e5e07c9e8": "KINS C&C",
    "83536e0392e3bfa78a090f749e00716aee47f192": "Dridex C&C",
    "836ea24d2b094829c52dbae3485095d5c894247b": "AsyncRAT C&C",
    "837c7256f942bd563c6c167b4084025a4ae10bae": "Dridex C&C",
    "83841b27ff3a4066b9c167513326eb7d3fe57db9": "AsyncRAT C&C",
    "838537c08c4bd5656449b37fe357e37fd173ee39": "AsyncRAT C&C",
    "839b990172b7349f5d5ba8045847b6849ce7dff9": "BitRAT C&C",
    "839f4fae14ec3119d5128f5de82d000a1c0e6d1d": "Malware C&C",
    "83a419c1b49a13f134a80fc8af968869163f8022": "Dridex C&C",
    "83acb5bb507651cc3c8d928d537d28ca261f0ea3": "PureLogStealer C&C",
    "83c3f86d5079e5cb5a8ef6b9c4ada54569324ee4": "KINS C&C",
    "83cf659616c22b7d3defb05775d60aef953ee6ca": "QuasarRAT C&C",
    "83d093cd475a0ee927fd304397ad238ae31d84e0": "AsyncRAT C&C",
    "83e415ea3f9e867fa13ae8003883740a4dbb8d36": "CobaltStrike C&C",
    "83fd752733df423532ae3041b825d0b7b923cad4": "TorrentLocker C&C",
    "83fe26aad844f101036726afcd7f28cf377d20af": "QuasarRAT C&C",
    "8403ac68010b33905b45a3b2ea6e90a8ba59ac3e": "DCRat C&C",
    "840c7a759f583023960df5f755cf28b58f7caa93": "DCRat C&C",
    "840fa744943b03c78120c664912b26ac51ed1e74": "TorrentLocker C&C",
    "84131421f3930400f0a5bdf2af99e1d075f69b3a": "AsyncRAT C&C",
    "84260b67bb540e01384d2254ad8a7dcfefc81013": "DCRat C&C",
    "84282d72ef4392694b946b6a34ed66fadd9ffb61": "Malware C&C",
    "8432bb1d1a78ddda1094cd4de0b4087040ca9cd0": "AsyncRAT C&C",
    "843f76bd25ed1570ee9086de2ae19c015d3b5394": "BazaLoader C&C",
    "8443081eef391d360ac01c59635c53b9ecbd6b54": "QuasarRAT C&C",
    "8469750ba59fd8261749d7af6e7fa1adc9d34cbd": "KINS C&C",
    "8475e7380a3f0cb06f595081698706a4775319f1": "CobaltStrike C&C",
    "8476c6f28a8e7ddfbf9ad2bdd277cd62ac989b7f": "AsyncRAT C&C",
    "848ce43530972c4aec6c57d2f00efeb7985b9eed": "Gozi C&C",
    "848f985fd6917eed4c39318e75a999ca41c726ff": "DCRat C&C",
    "849079a5855a6b6d50728445d1261bf3e8885bef": "Shylock C&C",
    "8494f0c094c24a1fd2c11226896019b097febccf": "Dridex C&C",
    "849fbeaa222971310da76faad5631ebb462765dd": "BitRAT C&C",
    "84c4d012ae29024ed37d4680fae29e1663b3abcf": "Downloder-Bot C&C",
    "84de1fd33d95407784d0b3773e49d95d96b2a0a3": "AsyncRAT C&C",
    "84ec9d5d579caa0983fe30917e09aa355af9fe3c": "CoinMiner C&C",
    "84f24ec9f40fe865c8fad7eb7d7c8971828fcae1": "Malware C&C",
    "84fa28bc4a69561a09fd1c419c5bea687a7da58a": "BazaLoader C&C",
    "84fbd72d1c9a08b5d6c21df81a7ef239f4c5f63a": "OrcusRAT C&C",
    "84fd8283d1736fa418c6a3ea5161ff1de79eb2dd": "Adwind C&C",
    "8509b1f800609cceee7f136179ca0f532b8e1a19": "Malware C&C",
    "850ce544ab68875cbc3510de8050a37878ad6ee4": "Gozi C&C",
    "8511a150034031aaccb25f8a4b89f13d92146d1f": "AsyncRAT C&C",
    "851471ad803a2d58302ce4e7091b84456443626e": "Cobalt C&C",
    "851ae021344b31eaa08150b7faa15a57fcb155c3": "Quakbot C&C",
    "8527973dc06a76ea86d0bf2414c5a0341fbe7e4b": "DoNot C&C",
    "8542001911dd975b3f493b892e8c77a453e6dc13": "AsyncRAT C&C",
    "85480e2ef70aa91df73c7226d412957b5de4ba67": "Dridex C&C",
    "854c68ab7ad70b6f95f76ec64b8a46c145997629": "AsyncRAT C&C",
    "8564cd4e73702c534bd9d69f13328264449e9380": "Dridex C&C",
    "8571f1a701013b48afea908cf6a2fc4bb8b410fa": "Dridex C&C",
    "8574e1e3a41aaa411cb75316f68459140ea34798": "Dridex C&C",
    "8578749c7ee09141050253138246463fd7f85980": "PureLogStealer C&C",
    "85792af20e1a8de4c15da9cc3ab97a6496ffc8a3": "Malware C&C",
    "857ca737bd9f19b6b10152a85f424d1074a4d834": "AsyncRAT C&C",
    "8599bb3aee4b0ee460b37db26dbba3a806b1a29d": "IcedID C&C",
    "859d05bc51e253d6d28675630d1eac2f1e1ff4ae": "Dridex C&C",
    "859e9118b87e442ee349760f1777b9656f572ad1": "TorrentLocker C&C",
    "85a09bfc4868952e0228a38dbf2c4a45c19b4a70": "PandaZeuS C&C",
    "85a8d80b1683293a8d3a2494e045e1e444f5edd3": "Retefe C&C",
    "85b4310a34543c6930b1c17abcd73a5b45c59f5d": "Dridex C&C",
    "85c90c84643743d7889928221fba7ea77b5d1a5a": "AsyncRAT C&C",
    "85f3fa890d7294fa936e60607a60d52987882d4e": "Matanbuchus C&C",
    "8644711545fc8d1ba02fd4e4424290a06815c320": "Adwind C&C",
    "864832b27dadf4e5a241cbd38f0ced26d875f946": "Malware C&C",
    "86612c00600ba14118be76c7f87ddde7e74dd5bb": "ZLoader C&C",
    "86614a676d069e27dae4eb6ee6db1d983697ea48": "Gozi C&C",
    "86714f5c1b87678d5020f8de869cd916d289e342": "Quakbot C&C",
    "867a5fce1bf823c587788dd68ecdbaf4e2d1c25d": "BitRAT C&C",
    "867f3d924828f93b0bd30641dfb01d51351aeac9": "Ransomware C&C",
    "869147520faf5cca143b56a41f7cb9cef7ba4ea0": "IcedID C&C",
    "86998d9ddfa7adbfa26c2ca4995fe70fddcf18e4": "OrcusRAT C&C",
    "86af392e9b42ec50e287f6429ef7484c48bbbd95": "PandaZeuS C&C",
    "86b2b1e98483a0b96a922ae781ed7979c1f77623": "QuasarRAT C&C",
    "86b5c4461302fe88f936958eb55aff551128f02a": "AsyncRAT C&C",
    "86b75b2979870bb571ecb957349f5e3ce1c9c26b": "Dridex C&C",
    "86bca833e8c2805625a0b90a0facc45c7f198f56": "Shylock C&C",
    "86c3a161a90000dcbb6b75542a0f79d81152081d": "AsyncRAT C&C",
    "86c7984ab348a4c84d8f8373367921c47194f8f3": "ZLoader C&C",
    "86cfa4414e480684de39ecc0f462afbeae58c471": "AsyncRAT C&C",
    "86d6aade4ba1414a91b1e7fb3cdd7d503692f410": "Shylock C&C",
    "86d7713792bfd1ee51615c808b8bd6920a0530af": "AsyncRAT C&C",
    "86fd7e1c080bd4d1507c6f2594c7be62df0844e9": "Dridex C&C",
    "86fe3f998c40051767e9542766129e833365241f": "PandaZeuS C&C",
    "870219586352bd3193b32e8d2c71fc90ee6be830": "AsyncRAT C&C",
    "870ca74fa1b058f929dece4fa216409c8c68db9e": "DCRat C&C",
    "870e01c67aa2236f127c8d78ebf6e5f1393aa257": "AsyncRAT C&C",
    "871bfc422610b94861c17b01ba14b11e6720aed9": "Quakbot C&C",
    "873148800a8bb1c09c417134c29eaac6325decc0": "TorrentLocker C&C",
    "873570456240bfcaac84c5773c17cfc14be6c8ad": "AsyncRAT C&C",
    "8743e030cd1a78910acb8deb15e2a684956f68bc": "IcedID C&C",
    "874d2458df138cb34e4aefb89b11a8e499b1abec": "Dridex C&C",
    "874f4208c8eb91d8a2f5d2f155e94138d969b2f6": "TorrentLocker C&C",
    "875a1cf4a0d5d64b87dd4736c8ecb4a2d401d13e": "QuasarRAT C&C",
    "875c0d65006ebdf72b8f7bc61ac34425dbd41e54": "AsyncRAT C&C",
    "87615bb01fc6fa61881bf433386a49e0178c91d4": "TorrentLocker C&C",
    "876b62cd1be0ef1e2a96751b959e773e277b510a": "AsyncRAT C&C",
    "877b5bd7e0e4b140e5ef8f0ac640d09041ecd1da": "AsyncRAT C&C",
    "878645d2ae902067e8a8096060e9d27593cda7c4": "Dridex C&C",
    "8791b47aef867b5bffdfa33c9b4681934ee5bf75": "BazaLoader C&C",
    "8792e6874147f53b4b6df6d52dba7ddd56bf2464": "KINS C&C",
    "879c445c7a5b319ee04e3a1d1e3424f46b15064e": "Malware C&C",
    "87b9011d00d506952665a9e4e4c1084e605059c3": "OrcusRAT C&C",
    "87cac3d8c16ce0728e86bf9e69596ffdcaf9db8f": "Dridex C&C",
    "87d4dd71553a815cee2c71b645188768090877a9": "Dridex C&C",
    "87d90725875d825bd5fec46a2a0b3ce8e2716e58": "QuasarRAT C&C",
    "87df1fb48ea4fff8b9e95bfc6e985446e45c4df9": "BitRAT C&C",
    "87eb3e4d618b9a54ead2363e0fd207f674898965": "ZLoader C&C",
    "87ecd7ccd07325fe2fa067ce10bb99123c98ce4c": "AsyncRAT C&C",
    "87f2a424a702d0a2396e60705349174f8d59440a": "TorrentLocker C&C",
    "8808ccbbcf3df310d4a4d8c685209dc1685e3b42": "DCRat C&C",
    "881ace0d30fdb1ca08789647bb55fc40bc2efc13": "Malware C&C",
    "881e44b08a810b2d87acca60dff884dfab064900": "ServHelper C&C",
    "882916f327b2f561808c4d0121673fc78cb0da5d": "AsyncRAT C&C",
    "882fe98030f01e7c2f6383d48b0321fee08597a2": "AsyncRAT C&C",
    "883719f44536fc17fe8326c9269fcccf6bd1c180": "Latrodectus C&C",
    "8837c6822f45d9b99ceb582f5d98c82789477ea4": "Vawtrak C&C",
    "883bdbd533bd49b610c250cf4c8998a93c7f8ae2": "OrcusRAT C&C",
    "884b85290c109635c56d9f776840cfd370e0e2d4": "QuasarRAT C&C",
    "8865fb17f050fcea174f4bcc68b9b5339eb698d3": "PandaZeuS C&C",
    "8879535050fd1e972ceb9c42b717e66ac6c677ea": "URLzone C&C",
    "888730fb84c11dd0aeff4999104b4779a8f6deb0": "TorrentLocker C&C",
    "8888a7cd6c9ae656a4afd21a5e378f6a0dd469e6": "Gozi C&C",
    "8889596565d7dfc668bc0efb6e22dd72869b06e7": "ServHelper C&C",
    "88abc3450041acf680b5d7b006b9e61690d834bf": "Dridex C&C",
    "88ac12a7fbe828e76d9abb12fa065a7cd47d91c3": "Gozi C&C",
    "88b3c101bcc58d22178355b7445930904b50afe6": "AsyncRAT C&C",
    "88b61228952bf3ad1e597fde77be8a6675d3c508": "KINS C&C",
    "88bc316bf543b3555004ce69d3b1bbc43e0dd53b": "AsyncRAT C&C",
    "88c022bd8875beb6439ac1d8be8592e13ef3d918": "KINS C&C",
    "88ccf424ed71871b051bc08627670e9afd20a6f0": "AsyncRAT C&C",
    "88dbfd1f7087f99f2ae178bb41e8b9b47fe3fa25": "AsyncRAT C&C",
    "88de16f44a04d2f67a3b1e81172fd82b850e713c": "Malware C&C",
    "88ebb21692b2adaddc520ce5e7b6c474907a2504": "Gozi C&C",
    "88f7c7ed461814f70d38ce1e8640ead2e0b853b9": "AsyncRAT C&C",
    "8914357cce21cbdcb491c9eb2dd9bfc164ec55d8": "Dridex C&C",
    "891fbb78d42e3eb693a9ca7ccf5028fd25caf8a7": "Dridex C&C",
    "8928ff0d7b5af201974b073fe05065490e88138e": "AsyncRAT C&C",
    "89310b5c35e50726e852a58342f56e3d362446f3": "ServHelper C&C",
    "8938a6d496334e1dcf7ce02f8e3dc9e5590690aa": "AZORult C&C",
    "8944242fa3fc77afba95509812a917674ffea6e6": "Malware C&C",
    "895172c42fe6b9288300ff47f5ce5b090b87e410": "Steal C&C",
    "8956b711c184bc52434aea0da568c81e168f7de6": "AsyncRAT C&C",
    "8964f9caf2c4e688a395f4666db072b165f9c28e": "BitRAT C&C",
    "89795b384e7ef8ed70123f376d4ee1360a673235": "Malware C&C",
    "8990759bcbb9ed72ccb016074e89f8cfd768f62a": "Dridex C&C",
    "89a13b5a9f5e95f68a7ade54157860e9f0578e71": "TorrentLocker C&C",
    "89b0ee08a58d1d3b962e9ff962d116cecddafe06": "Malware C&C",
    "89bb3111a0cd8cc5d83754fe3c9863cd3b1a5e8e": "AsyncRAT C&C",
    "89be3a840c2d1896e44f151482e52e932fd02b9f": "TorrentLocker C&C",
    "89ceed02b51d5d5f5feb3295a8627b7fc06903d0": "QuasarRAT C&C",
    "89d680a4965fd65aec354ee76a8ccbcd377629ed": "Dridex C&C",
    "89da54e823be88de8cf176046d5a3dd7101bfabd": "CobaltStrike C&C",
    "89df939f76dbfc4c381472475f58042c56481e19": "TrickBot C&C",
    "89f01fd3655167342d71ebdee5152a11849e0caa": "Adwind C&C",
    "89f70f43f5d81a48f48acd5cdec9d37fd8a04bba": "Gootkit C&C",
    "89f9bf318b85abfb7a333c4e2e7b7c2fa62444a1": "QNodeService C&C",
    "89ff12a215187fe8e9005c0ce2fe0ba414163d45": "OrcusRAT C&C",
    "8a00e97c2e6aefc61eb3c059b61ce2644d31de58": "Gootkit C&C",
    "8a189ef3c949c38ba238103efff4e17a39b9c3df": "TorrentLocker C&C",
    "8a2a7b58f2803115ff796e733c7311493928333b": "Malware C&C",
    "8a2aa2c8c97aad7a1bfe0cbf429d570c103ec1ac": "DCRat C&C",
    "8a3e1ed787c1e7babad7344ae5517fa90aec04d8": "QuasarRAT C&C",
    "8a3ea6279a7f8e40e9e223b746a35b52a3f36ddd": "Malware C&C",
    "8a50ad9529984df894b8591e7e193fce30eb9fa8": "TorrentLocker C&C",
    "8a587b07c7086256d8cc52e3c524e7912890b359": "Dridex C&C",
    "8a5ad798b4542cf68f3add68bc1aa3e7bba9f533": "BazaLoader C&C",
    "8a6a4ea803df4d10e661ebb56d801191f1361f85": "Dridex C&C",
    "8a76221fcf8431518ad09500e2e5b3ad8227168a": "AsyncRAT C&C",
    "8a789c338ecd22b9aa6ff00f0efcc1c748e5654c": "AsyncRAT C&C",
    "8a8fe76feee34416525f8be5d50faa5d585b13cf": "Dridex C&C",
    "8a9aabe3cb98608e65d10c9cf0b4c53af9a8fb6f": "PandaZeuS C&C",
    "8aa6dc434dd290a617c819fb8d73374435031659": "DCRat C&C",
    "8ab7cd8a35a336d65bdb9b84c9cbd856ee84f7b0": "Dridex C&C",
    "8aca9c997052932459d2c2a1eca541004774d41e": "AsyncRAT C&C",
    "8ace7ec9c8d64c013055547466c8a5084eef159a": "AsyncRAT C&C",
    "8ada65cf9bdd8160415b028dc4fb15288b8e5677": "Dridex C&C",
    "8ada691783c166f750bbbf340d637169a9e8d6f9": "Dridex C&C",
    "8adcad74167f5b27d47a4f629d11aa187710fd41": "Malware C&C",
    "8af671bf0c5ae8406eef17c7877521cae30d1ed3": "OrcusRAT C&C",
    "8b00d3787a5bc6599d6cdef4544f2ccdadd12dc2": "TorrentLocker C&C",
    "8b14044f38674150ab70e8744f1dcd039a9c4098": "TorrentLocker C&C",
    "8b14c8c84240898215cf306e6688fda438741ae1": "Gozi C&C",
    "8b14d1399fc3cc42d58752978fe04c9a2eec5c1e": "DCRat C&C",
    "8b1c37e30343ca2ecbe17b5906959baa430fecc2": "Malware C&C",
    "8b2f81381d663272764bf929aad9b800b2561a22": "Gozi C&C",
    "8b3191e6a74e86db8865a595ab65ac3d0f825e10": "Quakbot C&C",
    "8b356c2a7c085704c59959ba06dbd0171f74fbd5": "Dridex C&C",
    "8b5fbb3bf67cd991f0134afeea0362394422ef46": "AsyncRAT C&C",
    "8b604402e670210987a7a22d2cafd66a57f39bae": "DCRat C&C",
    "8b63501058e8c9c253ed23d185c909316b6de0e7": "Malware C&C",
    "8b73bfd664004a1a37b34581722677b3581970a1": "ServHelper C&C",
    "8b97ff8864d49f702957ba87b456452e44278556": "Quakbot C&C",
    "8ba239a29ee0e4350000ebac930b1dcfef301254": "AsyncRAT C&C",
    "8bb6c7c3ab951315ac88dfcb127984ea0343e34d": "AsyncRAT C&C",
    "8bc266f7bbf42448e87cbff1567a65e60847df34": "Gootkit C&C",
    "8bc41e0d9176e94b4712da03a88a613e01bbcf2c": "AsyncRAT C&C",
    "8bca5f91825d0db7965652bd16c23170727b68c8": "AsyncRAT C&C",
    "8bcf4b429da1a42b077d8e7350a5b4c6fa0bbe2a": "BazaLoader C&C",
    "8bd014e74bccc0146fcb52c17951ede81869b012": "QuasarRAT C&C",
    "8bd38c0a321db5527f59ded48eb011ba7ea69365": "KINS C&C",
    "8be4dbc98014e32bce0341f6754a232449c77d3d": "Shylock C&C",
    "8bf9db8fff027b7c42b53e2e0e8008d765312047": "Adwind C&C",
    "8c24b603dc1d57daf57c53d1c29c8ad2942f7b7c": "Malware C&C",
    "8c2a10d9fdc2278476225fcff9a3baf0255a1d05": "AsyncRAT C&C",
    "8c2c9e7cf1b0b4fe1433c10fa0cadfe222e32358": "Gozi C&C",
    "8c2f1d4f1be9094d836c0c160d6e0be69e66b4d9": "AsyncRAT C&C",
    "8c4f2bee35971694acee603a5e166e029797ed40": "Gozi C&C",
    "8c6ee9c3f5cbe05a7cabdd474a89bfc2dcce4e17": "Gozi C&C",
    "8c70438414b6571d7e3b18d070a73b6b05d706ae": "OrcusRAT C&C",
    "8c76ad34074075f4dc9a7a1c293293739b2cfdc0": "OrcusRAT C&C",
    "8c82e0b1f163bbf4717df8f7fd698300aa219c07": "PandaZeuS C&C",
    "8c872a336b8baa11ecbf7edf2cec4fd719e33fe7": "OrcusRAT C&C",
    "8c8af1723166752e4d2f2ce911761ae3f961bf3b": "TrickBot malware distribution",
    "8c8b0025bb8acaf1ed25b7dfb2f8222d6153b4d8": "PandaZeuS C&C",
    "8c8e66961ff09841529bb7bc1f091f1e7ed8ef7a": "Ransomware C&C",
    "8c91ea762394e094aaec333ab50bee0dd24e1102": "Dridex C&C",
    "8c95e67d321e829d0a40ebf564597617c261cc4c": "OrcusRAT C&C",
    "8c9e713fe711b4a9f87c757072e53068d51fe78e": "PureCrypter C&C",
    "8cb06568b4cfb30b8b2504f6e5f7edff42042887": "AsyncRAT C&C",
    "8cb6486f88e6f229a4550c98cb9b4da7cd475b5a": "Gootkit C&C",
    "8cc59a2c86a6dc854f2894e01fd632480784ed8b": "QNodeService C&C",
    "8cc8478b20f1701f8d58410559da0057782f2258": "Gozi C&C",
    "8cd7595ce7e79c1d7d8831ebe87f1a421417b113": "KINS C&C",
    "8ceae1726075a4d1690764fd72ed55b67a5bdf84": "Quakbot C&C",
    "8d0feeacc57dbe08ec25a2721154d47f94a6d89c": "AsyncRAT C&C",
    "8d3595cee506d4855fe345ccebaa12c839e68ff8": "IcedID C&C",
    "8d37705610b04f8a62e387c0f0b187bdebac5a19": "AsyncRAT C&C",
    "8d62412c9c2303a473e6cce72b9438f0405e36e3": "Malware C&C",
    "8d6801dbf53b1e0e9042b6d463b51800f4325d42": "Ransomware C&C",
    "8d6e05c2a3f271100fd12deeda7abcccc5c9f7a5": "Rhadamanthys C&C",
    "8d7182c4f946f4f7a0df42f95486e70cc9dc320e": "QuasarRAT C&C",
    "8d8867de05fbe3a59d49a919e8f49f09628cc0a5": "PandaZeuS C&C",
    "8d99327ffd974b82ffd788649da4887b3bc0c006": "AsyncRAT C&C",
    "8d9daa2cbc906d692f8f5d40e29c4decb263b979": "Dridex C&C",
    "8da3df71aa80c84018cda695dc2b79c52344f53b": "QNodeService C&C",
    "8da5602aa7f948432f7aff1541b002bff4aed46d": "Retefe C&C",
    "8dabf91f5c686235871cb263aa4d70ac27be5316": "Dridex C&C",
    "8daea52a3ab6c0c21ac992a7634d000680b47c94": "QuasarRAT C&C",
    "8db2f477384ffba008b77d54eabf4dab246546b9": "Malware C&C",
    "8dbbad6531d9d301b8ae64097e5f9c8ca2c901ef": "Gootkit C&C",
    "8dc90d59f9c79274f128269febc4a3bc3da079d1": "NanoCore C&C",
    "8dceaa6c43394cf8a9c3cc3c3feb9ba3c26a64c8": "Dridex C&C",
    "8de7ceb1cdc1bf1a03bc60f245de8d099998ea60": "QuasarRAT C&C",
    "8de9ddb634efd833ad59c3559a13567991e50537": "TrickBot C&C",
    "8df0d5165b66591597e7ac6889309132a06b1a21": "Gootkit C&C",
    "8df677e9dd1aa92892c9f6b0bad769666f797521": "BitRAT C&C",
    "8dfb928389c4b40889b1adeb506ca6d62ae3422e": "Quakbot C&C",
    "8dfc455a319f2af4ed17f37e19e7ccf0053411d9": "PandaZeuS C&C",
    "8dfffaccfd16b00d2313a85f89e1a02140d8fc95": "AsyncRAT C&C",
    "8e09af5a080eacfa451f3b1ad3cde0c5011b5a6e": "Dridex C&C",
    "8e0e604ac612ccede39461d005da57ce0b2db32f": "AsyncRAT C&C",
    "8e1c102bae57d6b08db5057a057a569c38376c85": "DCRat C&C",
    "8e294947d357fd2b76097edb2f30b2eb0e618717": "Dridex C&C",
    "8e33a7242a640578031621c69de7cf31ebffec63": "CobaltStrike C&C",
    "8e37e33ddefede5dded94a52e6edb1a84aedf14c": "DCRat C&C",
    "8e443089f6c370d239053c93f9d869cd60524469": "Malware C&C",
    "8e8b2eac14f55e75effa46b4efa364a2efca129f": "BitRAT C&C",
    "8eaf58223b10a7c144b20ccad3d3b1b06c6d0970": "CobaltStrike C&C",
    "8ec9d31e23c6880e160817705cd466c93a7f2d16": "QuasarRAT C&C",
    "8ed5d769bd146a02f929bcb5e0c87e444add60d3": "AsyncRAT C&C",
    "8edda51f6d0a8ce16d6a675ec14a70b7601fb6cc": "DCRat C&C",
    "8edf97196a8315b122d69520145419aa17ac0b2e": "QuasarRAT C&C",
    "8eeda18cf978e78b71c679f37bd48869f0c6fd2a": "Dridex C&C",
    "8eef8e5d5119d23d259264485fce706df2411e52": "Gootkit C&C",
    "8f05034708e0649f2e7abd7c9cd48714aa0ea44c": "DCRat C&C",
    "8f0c9589674c20f84211cf27e704defc07daf7b5": "Shylock C&C",
    "8f2be1bb913b54a168c0394affc674272eda9eeb": "Vawtrak C&C",
    "8f2c03956c26395b0dd216d1667c840ea3acde55": "KINS C&C",
    "8f3776154099b6c2dc34b8c37ff521172144a9a4": "KINS C&C",
    "8f39ba6ac8aae959c26dece65df178dc69ea1a12": "Dridex C&C",
    "8f3dae90faf0f9a470611117d9c6cb3ddf3e64e3": "Gozi C&C",
    "8f49540210fadbc6d67365c11c5390317928afd7": "TorrentLocker C&C",
    "8f50f40c14495fd7ff50212e3435f6a903239c40": "AsyncRAT C&C",
    "8f6bf7cbcf014bee0a42ec652bc96a2fa98aee36": "AsyncRAT C&C",
    "8f72082ffea68640e77d185ad0301e8f98c04d52": "Dridex C&C",
    "8f7e4e31ce316e3fab9ba5346cf42ebb0fed2d85": "ZeuS C&C",
    "8f81f18cee57c4438a8b8dae9f34ee846c61922f": "TorrentLocker C&C",
    "8f94b8f979a07b51199754584781c52cd0812905": "Vidar C&C",
    "8f9a5e3a7a215a185014770d7d5d6b537f49a172": "KINS C&C",
    "8fa4f1cb96bfd25040cfe4e4f095d31c5ba0a806": "Malware C&C",
    "8fae62c928556c3c3fe707a4cbd30f17febe9944": "AsyncRAT C&C",
    "8fafa99c7314e9eb3c64269fdcf342b6175b019e": "Gootkit C&C",
    "8fb831fa2b9eed40e8b418eaab8e156023ef6b8c": "ServHelper C&C",
    "8fb9ef1a517f64990e895cc29b374f52fc645241": "AsyncRAT C&C",
    "8fd28ebcf77af751b84d5b887bec9d1283ff7ea0": "Gozi C&C",
    "8fd477fe79eaa92a13bb01606d8100bf191b5771": "QuasarRAT C&C",
    "8fe03528d46afde9e6e3e9521c6e9dbe8daa92bc": "KINS C&C",
    "8ff4f4e082f6206bebd7094c76203a387daa7d7f": "OrcusRAT C&C",
    "8ffe38ac421cccb17e622f0f776347f57debba3e": "Dridex C&C",
    "900660708e658a294257340679afda71492e90ce": "PandaZeuS C&C",
    "901006fb67aabea7c7404e7846da5780b771aaba": "Gootkit C&C",
    "90166915ce29490779f2f33ed96ffbedfc3470e9": "QNodeService C&C",
    "901f02c25e0508884149cea277717028da2fa6ce": "Chthonic C&C",
    "902132c32d01e0eed9207aadffa4017b469ad9e8": "Quakbot C&C",
    "902703c569f3a5b5516700c83d2aa1837d2692d5": "Gozi C&C",
    "902a46fe662e84f137f58c7beb73f44bdd499835": "TorrentLocker C&C",
    "903dfdbe81a8016d5fc405e1e76f229ddee5045c": "Gootkit C&C",
    "904495e30122d37a39063bcb10baeedb3bca3ae8": "Dridex C&C",
    "904bf7874ad3930fe57473d00ce8538b4a4f31a8": "Quakbot C&C",
    "9051ab9aa200ac186fd171f9eee342ae9d0ff7bb": "DCRat C&C",
    "90651b6cee662295345ae91d8ec50702fabcaee3": "TrickBot C&C",
    "9073e71b44ed8a5187a61012e00d40cd7a932339": "Gootkit C&C",
    "90747d756c9f296f0ba1a3a1e8b6006813ea70c8": "BitRAT C&C",
    "907c73ee890f4fb789b20d17e4352debf1b0f8f9": "Gozi C&C",
    "908adfd05532c9fa420e1e0f4f39bb6a69b529ec": "PandaZeuS C&C",
    "909fc297de60762bf4867bd27bf64c0acf914c97": "Malware C&C",
    "90ac758820db52ef9ce198d359c538a44c26ab59": "AsyncRAT C&C",
    "90b2201f73e3ed1c368947aeed55ec1967001eb0": "BitRAT C&C",
    "90c9bc917ad221fa8a98b21eb38da88cf1638a27": "IcedID C&C",
    "90cbe1c178892572f2427945c280c889b37a82bd": "Gozi C&C",
    "90e1fa60b72f0ad0e0964ed40cdcbac75b4c53ee": "Ransomware C&C",
    "90ed3519afb15b9de6a04646f0adf8fd7cad4bf6": "OrcusRAT C&C",
    "9115ed8cd0e190b5629aca3996b864015155a333": "Gozi C&C",
    "911a6648e73b891a588904e1faf8c8901de9f08d": "Dridex C&C",
    "911bfbc76d3c056b8f61aece042fefccd2be0741": "Godzilla C&C",
    "91247650e075eb5a0cde4558b7c53759609705e8": "TorrentLocker C&C",
    "91352237c646c0756aa9ae7a7746859d562ec8ba": "PureLogStealer C&C",
    "9145d997963a50b9107c45f057d95107a63296c3": "TorrentLocker C&C",
    "9155e4cda16ddf0654c0e83da82a3eaaffda9962": "Dridex C&C",
    "915675c55e2ebbe2b2f26ddad2ff8a0860412b91": "BitRAT C&C",
    "916929efb627856e866df6321b7e9aa8167a53ad": "Gozi C&C",
    "916ba48c05fc16b739d6dccfb51d2f0c5768df20": "OrcusRAT C&C",
    "916c55cba3aa72bd000085e952f8e7f5faf438b3": "Ransomware C&C",
    "916cbedb7b911a80cadef2fba8ef65e17500503f": "QuasarRAT C&C",
    "91759ae9b81bd79cf6fb485da202264d5b370ab2": "zgRAT C&C",
    "917601caecb0fe6033595216e0ce2da4f8d3be86": "QuasarRAT C&C",
    "918f16c092ce9f9b317ca522f50efe063c0da17a": "Quakbot C&C",
    "919bf402cf404d4cecd9b263d319a68687f360a3": "CobaltStrike C&C",
    "919d91b870c8d9a50c05fd5f3bd9647a8a31282e": "AsyncRAT C&C",
    "919ddb610118c848a74055fa572656917de2a4af": "IcedID C&C",
    "91a47b299912f1204fdbe2974e27262bf89a0a06": "Malware C&C",
    "91b568ea952cbf4ad655cc321590fc65cdff9de6": "Gozi C&C",
    "91c94ee298fcbda32eed9c6759979204a1637cbc": "Malware C&C",
    "91ca400a836a85a395a3d525ee963c4619ad4dcb": "Dridex C&C",
    "91d3285d2a72d26332154690c37f06a4916cabfe": "AsyncRAT C&C",
    "91da281375737133e76b4a02f6dc56ff41da6936": "KINS C&C",
    "91e05ef0663bdfd9693a5c68735a4b7be13c941e": "TrickBot C&C",
    "921a998e8d4e74fcddbcf6c0802298f7d38008c4": "DCRat C&C",
    "923ca62c8a68e9366addd983ce1f8b2f7849e57c": "AsyncRAT C&C",
    "92423f824a666d95b12e63a56efde3ccc1ae7fc7": "Dridex C&C",
    "9245fcd592e3f8a43bc04bd003b8fb741410fdef": "BitRAT C&C",
    "924ca1d68ce08d3cb4e5dcfd8a9b13808d57bcaf": "Quakbot C&C",
    "9255dc0f9891311afe8b3365912b83653e877452": "Quakbot C&C",
    "925a118469c5d7fc087d35541420864266e0b323": "AsyncRAT C&C",
    "926a179e2c1db3e6ef7b73b30daf2cafd6d9e940": "AsyncRAT C&C",
    "926cc8c2f4ea22637c2ca12462ec7da850706439": "AsyncRAT C&C",
    "9275d52740c0b01ce952323d0f5368d78a74ffbf": "TrickBot C&C",
    "929b101cd60f9b02b9e8b11b891c34918accfb7a": "DanaBot C&C",
    "929f7e2f736a21a802b518e60ed1763cd6e1d4c3": "BuerLoader C&C",
    "92a0b1daaa7fcd4ee0759397d8c38c3503c6ce01": "Dridex C&C",
    "92a40df9f2da4632512f6843ece0686a79713564": "AsyncRAT C&C",
    "92aa18f04998201d53cca6a4b1ee19068e956ba2": "Quakbot C&C",
    "92ab6e291bb5d7f21b60bec9517a150cf6d1c4f5": "AsyncRAT C&C",
    "92b2686b8f007b93772bfdde74bdcbd82d4643cc": "Gootkit C&C",
    "92b62dd1bc7cc2e2b7eb3165eca1dd9dcf3c809b": "OrcusRAT C&C",
    "92b864819eae20f755d7092387253bba59041346": "Dridex C&C",
    "92cf2348cde2f4ee5a5a80331e6270fb50979a30": "AsyncRAT C&C",
    "92d88cfe0bed5b10a2a1e8dba36cafe8e8fb45f5": "Gozi C&C",
    "92e2ef7f7ebf622ad3c614ff9e5b7670b5d1f218": "AsyncRAT C&C",
    "92efe0bbe681fbbe3cf5f536b0056e5f08fe59b6": "RaccoonStealer C&C",
    "93085497ea7511d47594d004142d13b69f2e4847": "PandaZeuS C&C",
    "930be326b1335b0ce83f0b2d60391009c9d44684": "Vawtrak C&C",
    "9325003b383965fda1d346950304bbf7681be82c": "Malware C&C",
    "932a35451d9b0d1635ff062276179afeae69c62d": "IcedID C&C",
    "932bda3c73f8be1dc54bcc57bc55fc725e5544e7": "Malware C&C",
    "93322844d20407ec7181d7389b88d0309d26302c": "AsyncRAT C&C",
    "93395a318efb299c0fb928bea6f0029f5423c532": "DCRat C&C",
    "93451cec2fb6853fbd6fb5053bae747162e0feaf": "Ostap C&C",
    "9351cfa5ebd1feecaf8a0e0d1caf34323e86e8fa": "ZLoader C&C",
    "93532606c0c01ce794f9c725fe63a1c9bb1c9a7c": "Quakbot C&C",
    "9356b152df663437a72196b5a1b44389e85ff6ac": "Gozi C&C",
    "935b2394da5f69524cfd29c5538872f267c8253b": "QNodeService C&C",
    "935c76426a91f4bc38a0f876b53b0bc27a57ba83": "Dridex C&C",
    "93608084d386c5aa30139ad216873ba50fa91b59": "AsyncRAT C&C",
    "936c784df6bfbcb86d89edf1da8425e6d70dcfbb": "QuasarRAT C&C",
    "936e540af3a2ccdc95f851b5ffc414b40c60b09c": "AsyncRAT C&C",
    "937479060f4ea93617587849b258b4fd891334d5": "Gootkit C&C",
    "93820f721811629ff0d3510a5ae3ec72f2f926ef": "Dridex C&C",
    "9392da5f2d054998861e88a6b80e527419aa384c": "Malware C&C",
    "9398665081c94043360a0b48b35ea84bee5d883d": "CobaltStrike C&C",
    "939bf58efe71b54d81ad9d182ca0822871dab6ed": "Malware C&C",
    "93badc9f18a70852a7a5c04641f5a02ad53169c8": "Malware C&C",
    "93d539edad8aaa04c77801ad93cf0d76a912cb60": "QuasarRAT C&C",
    "93d8987eb1ca50c3336aa78258503f8f24b16bb7": "Dridex C&C",
    "93e10a63a84e81e0b46d39fe3c8a26c5a9c9db53": "PandaZeuS C&C",
    "93e24ace7ffa02f1927a56c62cfefabc58e6463e": "QuasarRAT C&C",
    "93e7a0bafde177f090fc962c9e25983337476473": "Gozi C&C",
    "93f158ffbbedced5ac14cfddf3e008158ab711b3": "IcedID C&C",
    "93faa27d7a5fdd4e45fc7daeff835fdb31bc379e": "AsyncRAT C&C",
    "94012108903a08562140bd744a3d7483072ff02c": "AsyncRAT C&C",
    "9404a1e815f3f010acd08a8c9ee7a82f3efc0289": "TorrentLocker C&C",
    "9407c6f02a1b9958fcce892d60a66a2b10ce42cc": "Dridex C&C",
    "940fb0c3a989d7faeb968a90a86d9c6f3bdba8fd": "Malware C&C",
    "941217d7f194d05b086db5132ee04a63918ea6c4": "Dridex C&C",
    "942a323034a80e0670d3697b6e6e1f18e37455bc": "Gootkit C&C",
    "94307fc231543b66fd1f07c8344dc01eec70073c": "TA505 C&C",
    "94365b84bac5d2e0e7db9fbf8bea49aa2240525e": "AsyncRAT C&C",
    "9442bb9e31815fe78ef89a45617582c35022eb13": "Dridex C&C",
    "94433458d4ad9300f1ee8d3fe9007ca11b5e20cd": "TrickBot C&C",
    "944a7cac49c00ac4697006c4f7274c6bffc425c3": "RedLineStealer C&C",
    "944af8c1836eb67178bf64f7795b528e913be790": "Malware C&C",
    "944b428c4ce889dc4988f8f3312fdf66414eecaf": "QNodeService C&C",
    "944deff79fa8c1980366ea747746231c8368c9fa": "AsyncRAT C&C",
    "94540c502bdf5b61c93097259aee2891b5f72737": "AsyncRAT C&C",
    "9461eb51bf2bae4fd9ba15239354ac2d771e8372": "Malware C&C",
    "9473c50d4be7cec5ed4f544b1c6fdd040ce29c18": "NetSupport C&C",
    "9475a7c4d19d9dac68ce0977a9ec4623c7c395b7": "Quakbot C&C",
    "947a87b37430a5350581feaa681979f4194e2a87": "AsyncRAT C&C",
    "9481e610f0518e489c33ef0bfa08b56591baddef": "KINS C&C",
    "94904f5e96d7499195f2e5494b5db4bc9d780e60": "AsyncRAT C&C",
    "949354e6f45d8f567e0fa8322040e9c29e30b271": "KINS C&C",
    "949b65504744febff820374f89a2a833b54ec611": "Malware C&C",
    "94a16d3f87db44957564e98f1b2dab9f8ff0ec46": "IcedID C&C",
    "94aa3e6337ac3a93821899bf3866de6c0ebfefc1": "OrcusRAT C&C",
    "94af13ef5433ff1565a19ab84ee2406f08f24159": "BitRAT C&C",
    "94af8c88f2bfb4676b2dbbc58262d07678463311": "Malware C&C",
    "94c96b10a43c6a48b4a2f07dd073ab958cc61e94": "Dridex C&C",
    "94cfc58c0a6d445327cf458953102b5617e7fe29": "Gootkit C&C",
    "94e127494b7a361821646ea577e3deb5766c16b9": "AsyncRAT C&C",
    "94f127e645d4a57e4d7d33bca0264e5573d15ee1": "KINS C&C",
    "94f606fec2761baee1f58f32f8eb7443ca1ed488": "AsyncRAT C&C",
    "950cb0cfd0a0869adb19fa009db74b83ea6da4dd": "Dridex C&C",
    "951431e18b12186b0b1d743ebc8fd7782f4e83fc": "AsyncRAT C&C",
    "95259b0670613bfacc6f815640a5159ce3f4f0e1": "BitRAT C&C",
    "95265183f30a411a1798d9344a077ac5e959e1fa": "Shifu C&C",
    "9527b73ebecac9ebafce589a9ff95c18e3c72565": "OrcusRAT C&C",
    "95351c56e6e3bd18eb0f5d53f01cf641d2bbbd32": "Gozi C&C",
    "95375f69c1dae0bd3b35a191ac67d1c58ff39ac6": "Quakbot C&C",
    "9537db6272040ea5036cf20062e8dc20ac98cc87": "BitRAT C&C",
    "954995cb4bdfd0dd6126a3bb79b95c9e051aa139": "OrcusRAT C&C",
    "956105c5cb1e4a33946d2997d9f7e407ae13dfa0": "Dridex C&C",
    "95678e0529473bf8b297010ac08e9f5975dfb873": "Gozi C&C",
    "9567a491c3a3805c484b46d6a826eaa254c3bc93": "TorrentLocker C&C",
    "956f15c0045f84c091420941a5b95dbee72e4b6d": "TorrentLocker C&C",
    "958793994f2e5c40a2264cfdcc93014b693954cc": "BitRAT C&C",
    "958b5f154dc1913ecfde2809b062259aa707b9f6": "Dridex C&C",
    "95c5f203354b2d79fc26ff27ad4be30a8d77e3b0": "Quakbot C&C",
    "95c9d9c3e8e04f3b7479f158baf0ea27140fbf61": "Gootkit C&C",
    "95f15521e637f05a5793226b68f90e3b623f0d64": "Malware C&C",
    "95f4fefc1e91d3aaf776b20db278a257473b5edc": "DCRat C&C",
    "95feaa574c70866e1b2030d31b0bb448cec35c8a": "Gozi C&C",
    "960d5ecaa953b88e52afa5d54e6b2c61ac9aed6b": "QuasarRAT C&C",
    "960e32f529e3c6ceeb5c1803ef47024d23ff19a1": "AsyncRAT C&C",
    "965722d59c7fd9d82e3ab43511332eae38e92543": "ZLoader C&C",
    "965fe45490928e2212530d3ade73f2adbad02676": "IcedID C&C",
    "9663b6799ba20d68734cc99aa83d6bbb0506f064": "Dridex C&C",
    "966c7ba762e357d247888176fd1d336b8efbe544": "KINS C&C",
    "9671579d3f105a8685de1ae4934266a695b7628f": "Quakbot C&C",
    "9678e0ec2f0910e0ff977b57c6e0920dfa1982e5": "AsyncRAT C&C",
    "968519d805c985b457be0a2afe98a0d044ef99c2": "Dridex C&C",
    "969c33c3269f349a78fdb9f8589bc5dda314930f": "TorrentLocker C&C",
    "96a2d441b23a8c26348f4f68c2b26bf49d59e94f": "Quakbot C&C",
    "96a345a23ae826bba3c4da2470ac02b40c078ec6": "Gootkit C&C",
    "96a49fe87be0f47599a1b0f2bdcffc9326131e65": "DanaBot C&C",
    "96a67a5080f5be0865b0ea80556646652e1c4e6f": "AsyncRAT C&C",
    "96a72a65c2409ffbf27e99dc46f3b56e1df86ada": "VenomRAT C&C",
    "96b3bf65a5f6cbdeb1606cf82f520d6427faa8fc": "DCRat C&C",
    "96b4f29670af670e1d6b852e6b54e61d9cefec30": "BitRAT C&C",
    "96c59452811e491eaf8906ce593577f52ab5e88c": "AsyncRAT C&C",
    "96f244cc929e2d15202bc34cdfc259e076e60807": "Dridex C&C",
    "96fc9cafa67fa6616c881760fcab36d227bebd2c": "Dridex C&C",
    "971173d0d485fce935874f0db37a7840190338c5": "AsyncRAT C&C",
    "97142ab7ff130a3dfc8cb57de1a1f2a01593c42b": "Dridex C&C",
    "971bce994954361221bafb42aefe1a74e187ebd4": "BitRAT C&C",
    "9732f0d1347169e449b7ed8393a307b6e65098cb": "Malware C&C",
    "973fcf9ef8d1bd26e981c98931b01d9fc9ddd60e": "Dridex C&C",
    "974c474b1a1e76bd58e894e5a2db8bc576412dd6": "Dridex C&C",
    "975306e75ede7cad228074db0eed4b42c6bb5fb7": "Gozi C&C",
    "9763d962a9c6baabbc5cc945ef11d215206ff3ba": "KINS C&C",
    "97692ebd03cffb41edbc13f31e57d3ff01caa249": "BitRAT C&C",
    "9769f31ac0430f24d971db5d022af05683f178a4": "KINS C&C",
    "977432d5a846a3d869a6bee2f7c15d519ae9d9a0": "NetWire C&C",
    "977ad455903f766e8b6f9295c9191aa24e4fef9a": "Malware C&C",
    "97a12fda4e08497efc134e81039212fe55d77f21": "KINS C&C",
    "97a9ee9f0a0711f26f6ce01a172d6ac9243b6ebe": "OrcusRAT C&C",
    "97af5cc8e72796f4fae487044536958a8c6d68f6": "Shylock C&C",
    "97bea2f24d9208a314efbb886ac0791bd000b608": "TrickBot C&C",
    "97bf1fdcf446a7218fa05296fd8d8f0c41a6b1e7": "QuasarRAT C&C",
    "97c0eaf895cad2c9aba3311fe3858309e9b39cfa": "AsyncRAT C&C",
    "97c47b0bec5a12c42dc4825fb20d3ed9c89545b5": "AsyncRAT C&C",
    "97de758a7c3c861c32f159f39d08abd0499d9383": "Chthonic C&C",
    "97ef89ffcd19d6bf00032f20bfa2d3c2a1407ddb": "Gootkit C&C",
    "97f480afd18b078bdcdbaf4cb14583954161150a": "QuasarRAT C&C",
    "97f8b6687ab03d2ef5b3ea9d2495e28abf2fe9d8": "Quakbot C&C",
    "97ff7be1c1d9ac2beace122dd463a2f7aa2df5d7": "Malware C&C",
    "98025cf05cd78f7ff35349166abe6267bd433ab1": "AsyncRAT C&C",
    "98207ee726ee75fcf780c0c13bd92bb47d4b84fe": "BitRAT C&C",
    "98229560c6349ea054d6719f5319a0a25388b08b": "Gozi C&C",
    "9823e2d9199a05602d8ae05ffd2d3dc4523a9ee1": "Matanbuchus C&C",
    "98293ff5b005d9f9a7399fe41672d121709270bb": "Quakbot C&C",
    "9830556f4d8f99733c5ffa5e0ea4ce8e14a20fe5": "BitRAT C&C",
    "9849890d6e4cdb974c1ca9af43ff4171277f051a": "RaccoonStealer C&C",
    "984b3c4ef83e14ed69ff2f6a4463031271e65a86": "Vawtrak C&C",
    "985523607f594efc155b64229088cdaec779b317": "DanaBot C&C",
    "9868fdc9a9dd1497ce4fadad7c8d441407e0afee": "Malware C&C",
    "986f0d816360163f03ebb8dd37249b699e65cc24": "Malware C&C",
    "987cf99d2b22c0511ae92ea534dcbb3a29fb5eec": "TorrentLocker C&C",
    "987ef1c359d79880b9e5d29f22ab63b948a0b09e": "Gozi C&C",
    "98820bcbb455a8226e072166b185ad5a4da7a575": "AsyncRAT C&C",
    "9882dd65376a4b6e935e4db36b5ef60ea135164b": "IcedID C&C",
    "98837fa5f8e40e04172618ddf2d368e67bff2579": "QuasarRAT C&C",
    "989c734942f4829175009bed753c9d4c1d29d78e": "AsyncRAT C&C",
    "98a6d68d800405d033921024b37d54510c72c4ce": "Vawtrak C&C",
    "98c16e815205ac920be9da61d9d1395f5b953669": "AsyncRAT C&C",
    "98c97ebcf9a16f604136307bcf251f9e00755d99": "Gozi C&C",
    "98d9e62e6d2b66cd3008d4c93dc9a1b65e18c7c6": "KINS C&C",
    "9921ce1f4ba8825970ee2e478d31778b9552aa23": "VenomRAT C&C",
    "9925d0f77abb064b70136c1af66c149321e5c42b": "BitRAT C&C",
    "9938974f71d1715479dc6ddb5b58311c177af08e": "Quakbot C&C",
    "993da5486c11062f3b3a1f1936fa2416513d8c4a": "Dridex C&C",
    "9940ace3d2fb71d9ee07fba881f5b7e1efb58830": "TrickBot C&C",
    "9955aae5249f8a44f5f8692bea5b8ff2331c835a": "DCRat C&C",
    "995f276f64b4c127c82952604ecab84989615e1b": "CobaltStrike C&C",
    "99691f034c745e33f7a87feeecf6a1e32b90045f": "CobaltStrike C&C",
    "9991db977ca6f565cfb7004223d697915f84c2f4": "ServHelper C&C",
    "99a2698a141989ad69c5d4295b1cef08c1f35117": "Dridex C&C",
    "99b5cdc1503899e6532ee82ddc2e42d59bcb6284": "Dridex C&C",
    "99b87e84b83e1680484ccdc5a02fcc6f2a0a8fc1": "QNodeService C&C",
    "99cb82d4ef44fdbaef3e09ad59d2218ce13f1ce6": "AsyncRAT C&C",
    "99d76bc2abd334b383167edf35dce11f2241aae4": "Gootkit C&C",
    "99d9534224017db5bd28709ae3d06f1f89fc0e48": "BazarCall C&C",
    "99d9d01f4781e0e4d1b2a73cfdd6aa026a8d2ca9": "KINS C&C",
    "99ef3d6a22a0ae441b972e13fc3fc935c530d305": "BuerLoader C&C",
    "99f9f7e5718c4d4676e3b38ca1bd5dbcedb69f61": "KINS C&C",
    "9a034b350f517322a9f8e90d5774519108c4f299": "TrickBot C&C",
    "9a044753daa1d6856d7dcc1d2942a114921b6c74": "Shylock C&C",
    "9a0d73d7dd558cd3de7853586d4ad06c21803500": "Gootkit C&C",
    "9a15d8e114feedbe52816c8cbc70089b0dc1420d": "DCRat C&C",
    "9a1b73c21f19bc8f811c96ffe50511c9b6498902": "AsyncRAT C&C",
    "9a27cabce74385bebf0e9e41d834e9c1ed223985": "Dridex C&C",
    "9a2a8d1211ddb7eeb0fd7e9805942d796b0b58f1": "QuasarRAT C&C",
    "9a33871bed66f35f374e5ab37a3acedd3c11f055": "AsyncRAT C&C",
    "9a57379949f734b11f32bb8462db1f3fd8898722": "DarkGate C&C",
    "9a5cd3e9909d743584957bc9c88b34d93ed78761": "IcedID C&C",
    "9a6ce930a549006a704d766a2540df1731e1579c": "DCRat C&C",
    "9a6e347e4bc544ecc269ca2fea7ba292998cbf83": "AsyncRAT C&C",
    "9a6fa1bde6bad75c55178197b8123cc4ed658f50": "Dridex C&C",
    "9a7305174576c09660e1609556e5ab89919a1ad7": "QuasarRAT C&C",
    "9a79974e664d4ca41a68b9f1eea1d6e529263764": "AsyncRAT C&C",
    "9a7dabd7d2e46202d33702e9a90baa02bbfe8940": "Gootkit C&C",
    "9a7fa8b710571594e57182aaac8fd5c907ab493d": "AsyncRAT C&C",
    "9a80f11cbfc7b094beabc03a84644f7252d78a5e": "Dridex C&C",
    "9a8b74cfa630480b224eaef06e960ca154abdffb": "IcedID C&C",
    "9aa15660a0a0db415a7a0820021ed5d0d9c89163": "PureLogStealer C&C",
    "9abe56b1857cbdc5d576fd9971a24bc3c9009220": "AsyncRAT C&C",
    "9ac2229566c65862bbec96ad6a48f427662e3315": "Dridex C&C",
    "9ad9da059ca79944fdd02900e18355ebe4dd3acc": "TorrentLocker C&C",
    "9b0ad0329f65958cbfb946fb0d622e37c56f886e": "AsyncRAT C&C",
    "9b3fd7d40ebb5e60b1c3d75983b4b756c32e9560": "Shylock C&C",
    "9b5430b6d6c30d2d4e3c565f128357cecbb244a0": "BitRAT C&C",
    "9b585b4014ef6cc5eabc235f63b81a01b6a7d091": "TrickBot C&C",
    "9b61ca62824b5a790cef04a344bf957a5d467d17": "BitRAT C&C",
    "9b71130e301ed450a8bd2aba3a7f8ceb808cb626": "Dridex C&C",
    "9b73cd49f84f44efb01cc5b0f45d636c029b36e3": "CobaltStrike C&C",
    "9b840e757379c100e6c6b6b17a6d0d2dd2832320": "OrcusRAT C&C",
    "9b9745ca285a390dededcae553df508b3b450127": "Gootkit C&C",
    "9ba1f631caafb333f3c8faf82719a72642955927": "Adwind C&C",
    "9ba59e04a7c8be3d94025d5319160d9cf016a843": "Chthonic C&C",
    "9ba796f169218425c8f86a9892802b9b1bc703ee": "IcedID C&C",
    "9ba8a59ac8e07a96d5004c406409869793c30992": "QNodeService C&C",
    "9baa5175652e634c3fe49d0aaf05dcec88f29965": "CobaltStrike C&C",
    "9bb10b12b951d4020613cec9f1d40dd2ee861bd7": "QuasarRAT C&C",
    "9bb1d7089e1beb8fed165d8ba9ff7184680f4d6b": "CobaltStrike C&C",
    "9bb31f526f6835d3b02100999eeca42f46aa2b1d": "OrcusRAT C&C",
    "9bc0719a6b45027c6b18c3c6a92284c636510a65": "Gootkit C&C",
    "9bc8514e8cb800285800519ab3a7de058fc7466b": "Malware C&C",
    "9bd0285923bea2c2bc6634edb6229d4c44dad537": "AsyncRAT C&C",
    "9be47170095e6c828fcba747205c12be0f8707ec": "BazaLoader C&C",
    "9be4ab3cd58a132b652ec39fc50e41f2cc93a44b": "Gootkit C&C",
    "9c03355ec0ec54850ba326d08542bff5c24e207b": "Dridex C&C",
    "9c0a863f8fc3eda45718ba005e11ad6891b75631": "Gozi C&C",
    "9c151eb9a0dbbd17722074a748153d56bf64f723": "QuasarRAT C&C",
    "9c26b4f3b37e8117f9713596b9c1259628ea1dee": "Malware C&C",
    "9c29b18c091c3171a87274b0d95ed798246179c4": "PandaZeuS C&C",
    "9c2c8dba701a07a3ca4d6fc473f3b3d052f7fe98": "AsyncRAT C&C",
    "9c31420220917a09fa3f26ce826c83da3dc3d409": "Dridex C&C",
    "9c371f240e90a0190a14397a5ada03bcd56f046e": "AsyncRAT C&C",
    "9c5381e6689f0accf378c010736ae6d21f311d57": "Dridex C&C",
    "9c55b057d63d335c3de8a9c267e2b49d8e668f56": "AsyncRAT C&C",
    "9c5a9cb15b9c3f86acfc7a1d820f1f8de7161f21": "OrcusRAT C&C",
    "9c6d80bd524275aaab7c35f9e1c8d17aca14da56": "AsyncRAT C&C",
    "9c7adac07988a1f8777e3550fae5de6a341a86d2": "DCRat C&C",
    "9c8516275652a9fbb9c0f3838817377e484d4092": "RedLineStealer C&C",
    "9ca28260ea17906f5c133df4b882e3e5a836b118": "AsyncRAT C&C",
    "9ca6eacf82b6c34f34063430c97b71d9c1f7fa7b": "IceXLoader C&C",
    "9cab35a0e719706dad7f7fc285c931f1798c212d": "Quakbot C&C",
    "9cba11bc18d26a31faa76270299d456aa62bc44c": "AsyncRAT C&C",
    "9cc23c9402d18ae6741e0bd2bfad79d0ff5710f1": "Dridex C&C",
    "9cc93e0add5efdf43bc566836e5666d7049701ed": "Gozi C&C",
    "9ce6b5cbef1b5a5d25c7ac04a9cbb49e8674ffd0": "CobaltStrike C&C",
    "9cf486c4e0966c6368558b8a1fddb69dea27daf4": "Adwind C&C",
    "9cf940d85c05a9518767e23579b21421e6838e27": "AsyncRAT C&C",
    "9cfa5b74928b9ea447b938153edb3e521632b17f": "Retefe C&C",
    "9d00d62b06a97c1e439750ed2c5d44c303683202": "PandaZeuS C&C",
    "9d078c3a02a0c18a5b0cfe553dce4be35c0eb0a2": "AsyncRAT C&C",
    "9d1fc90b3a11ae53ec56639e02b6fe89d048a775": "Adwind C&C",
    "9d283f393effdcaffb1a651fd1bbdc3c43b544eb": "Shylock C&C",
    "9d2a255f7702902df8f1df9a89e4b55cae5bda58": "Dridex C&C",
    "9d2eaa284777cea1cecdba13e5fc6f7fde5fbb24": "zgRAT C&C",
    "9d3aef40cf17fc4018c03bb6f2556c1622972638": "BitRAT C&C",
    "9d3d77b151a1710f6b16052364e50cff17120358": "Adwind C&C",
    "9d4f2ef665a785dcc9b9a37330fab1afc930ad05": "AsyncRAT C&C",
    "9d51763ba3fd4d4fb1601349826f0e8a58452275": "Malware C&C",
    "9d5f4bbd0081770e674331e9a0dbe745c985e850": "KINS C&C",
    "9d71bd006a0f2fd32a5c736c7b1560a9286684fd": "Rhadamanthys C&C",
    "9d83e37a823726b2b5a881917a7c3957c3699e68": "BitRAT C&C",
    "9d84877586544f17158b8310c2f5759764ba4234": "AsyncRAT C&C",
    "9d863fcb327ad4411841ee0713293ea4a52adf95": "Vawtrak C&C",
    "9d88bd71428950a549752e6c26eaf597ea94e990": "IcedID C&C",
    "9d8c5f0ade8a857effbd315dca50c0e335314dda": "RedLineStealer C&C",
    "9d95f5400641b5773800e4ad177a04cad23fcb0e": "Malware C&C",
    "9d9a361da812ec3f2e5358296f4ce30004572e09": "Dridex C&C",
    "9dafef751ef9be794e97b3aaa5e0bfe51fede7b9": "Dridex C&C",
    "9dc84b079ff257f39e0b81d61c88f4f48f6cdaf7": "AsyncRAT C&C",
    "9dd8d8aac944cda65214995036048b5042b69765": "AsyncRAT C&C",
    "9e0626623e416cfe23dd33d211b3525c02288492": "AsyncRAT C&C",
    "9e0764b6a38ca00b413e415740b92687263b6e23": "Dridex C&C",
    "9e1c95c370b0d1e10c47b1ae2922b7e82fe4b0f1": "Dridex C&C",
    "9e1d7bd86fbce609d0183c2827e48b4c56107eeb": "KINS C&C",
    "9e330c6d642572f6cefbac38a138c23b8e7aee51": "AsyncRAT C&C",
    "9e3a7e6adfae7c3907a524596327b06ab6c14d9d": "Malware distribution",
    "9e3d96b56c4362cec7d2a293f169f9df4b8f3f22": "AsyncRAT C&C",
    "9e547a7847118e02fb82ab6358a1e8534934c912": "CobaltStrike C&C",
    "9e5d382d1201a40e81ceed697a08e90fa09349b0": "AsyncRAT C&C",
    "9e61f8d92b303885d9cb6f278d0d443e11ad8ca7": "TrickBot C&C",
    "9e77fb7a5f9c9dccbc4eecf6b66f911f525a010c": "KINS C&C",
    "9e86138b10960d54b3f71b87d6bfc15982da9c71": "Ransomware C&C",
    "9e935b1f30af15da280de099ec7258978b69c756": "Dridex C&C",
    "9e9b3535523990de10ea2ebc7b4a1fa5d2cb8f70": "OrcusRAT C&C",
    "9eb50f5c2872d0ce0a410648d896605769f91fce": "Gozi C&C",
    "9ed32cf21ca244a785da6a6254c2a7b8f41e6153": "TA505 C&C",
    "9ed452878d7dd90285d2b10a50d4281341cf3aba": "AsyncRAT C&C",
    "9eda7e5cc4e1cbc0b5213fbb71822cf9574dfc63": "Shylock C&C",
    "9edc51f3bc900c7eff234276d5d98b5805644e12": "Ransomware C&C",
    "9ee1e2f7250a987349b3ce137cb733b0fe5e51c8": "OrcusRAT C&C",
    "9ee665dd3ff75c2dd8474fe62bbf30f4541a117f": "AsyncRAT C&C",
    "9eed1b7d6e8ffa2c046f59574d262777d3a1730f": "QuasarRAT C&C",
    "9efb1ee3ebdcbdad8599b92e85f8353c689f2d70": "AsyncRAT C&C",
    "9f12912f9bc3419e0670a729f9c4c16ed8fb43fa": "AsyncRAT C&C",
    "9f25a7d6ea5063b3cc5319210eed4667588fd6c4": "AsyncRAT C&C",
    "9f47cb1f50dce2bd73cedb976c21d6199ae6ebe7": "Dridex C&C",
    "9f54a72ac8f4839a19bcefd13c54736498b2903c": "BitRAT C&C",
    "9f5e83cf4ead1b51e34a8d5f82e492881ab9ff3b": "QuasarRAT C&C",
    "9f61ebe4e9af3aa9fd34f8f3ee82a3ffb30d0f5a": "KINS C&C",
    "9f6d403e2b068a96b410c3406ffd406f3f566d10": "AsyncRAT C&C",
    "9f79b209ec51390787189663796c433d905df50c": "ServHelper C&C",
    "9f8babc9282d3ceb833dd63334e6e6540423bb74": "BitRAT C&C",
    "9f910c6ab300a367e97f540828a6eae974aa4515": "Adwind C&C",
    "9fa148ddad4f3ddde0ad4b9249a383e0c13fc4cc": "Vidar C&C",
    "9fcb399a79c0f6316d90332d81058bec1b04d435": "DCRat C&C",
    "9fcc5c1e8ec32f56e975ba43c923dbfa16a8f946": "CobaltStrike C&C",
    "9fd05b2d9d791816087ba4a146b3e48080433a4f": "DCRat C&C",
    "9fe4695a087639ece002f512e118ff1883186ae7": "TrickBot C&C",
    "9ff068907672098a14ff916192d5d6a836159e24": "CobaltStrike C&C",
    "a01e508e823abbb7dd19fab55148e660e0f4af69": "Malware C&C",
    "a01f76dab74e1ea95291240596887d42b18164f4": "Gootkit C&C",
    "a034095822b2cffbeb9635321dc524a57e03bb64": "Dridex C&C",
    "a03d0109ff27cec20deca348fd4b916a3168a818": "AsyncRAT C&C",
    "a04b2ea975dd4de3beaa35d08a9c609d5b4715a1": "TorrentLocker C&C",
    "a060d43f584a7d2f838b6d64aff4076df766a1b9": "Ransomware C&C",
    "a079a1694467fe94e6eee95b0ead9b652b69f774": "Quakbot C&C",
    "a089ce650fe205c0e00d85ea10efbc5f097227eb": "AsyncRAT C&C",
    "a08ea0d1bf17672f478c90d0b49cf6f680977c70": "OrcusRAT C&C",
    "a092979fdc86be59f60fb69c6e3539f36cba6599": "Gootkit C&C",
    "a0aff4d892578e754be039986241ee424fdd561f": "Teslacrypt C&C",
    "a0be43662c34c6f0fe99730283613ad53699a5b5": "Malware C&C",
    "a0c4d541d75553fe96512f22999896b0edfc735b": "Dridex C&C",
    "a0cec960515d324a3497055be26ef1677d95a4f0": "KINS C&C",
    "a0cf3ddb0fa7f0bdc42c025c84d9dd0e2331f832": "AsyncRAT C&C",
    "a0d78b3ddb27cd4f110a0292cab800beadaf9bd2": "AsyncRAT C&C",
    "a0f563f0083497a72cf492b7d8e1c9cf9c31b252": "CobaltStrike C&C",
    "a1017187c852e87b300868034e8aeab1a21f73f3": "CobaltStrike C&C",
    "a1046c8bb49efda573d187f55e3d5222f2c8066f": "AsyncRAT C&C",
    "a106364d5442ba177d4674f10db4b88d7566a131": "BitRAT C&C",
    "a11cdccee959cc41efcd1180f8fa52322d0718b9": "BitRAT C&C",
    "a12f2e1d7a5d22fda1a36a6ccaed1dd9b9996457": "IcedID C&C",
    "a14971d2d9bc0cb54e114d3c34e6fe348873613a": "Dridex C&C",
    "a19275bc887e0eba38435726439bca9e6ad43452": "AsyncRAT C&C",
    "a1957e2dfc19e1bb4c007caf29923f79f427a454": "Dridex C&C",
    "a1a5d7c2340ee89dcf9da7ed68f2511e5ff0ea6e": "Dridex C&C",
    "a1bc247f4d9e2bb510f912e08691ccb0a55e10ec": "Latrodectus C&C",
    "a1d406d05403f235c061c5af7552adf703d39737": "ServHelper C&C",
    "a1db30fa029755100648c00558eb3274c4c98b1d": "PandaZeuS C&C",
    "a1e6cc33a4a957f2f2210298388860164dc08404": "Quakbot C&C",
    "a1f38c72cd303be4690734614cad6b6eec673e7a": "AsyncRAT C&C",
    "a1f8672246a55dfafa317bfdc5f14c91a5b344b9": "QuasarRAT C&C",
    "a1fb81abf5e0453e6fb129b5e2583b171bfde416": "Quakbot C&C",
    "a214fc15ee324d8f2fbd4b3a4673111457036593": "EmpireRAT C&C",
    "a21793161e08cced105dbd0d5f63cf22af13224d": "Malware C&C",
    "a231e47b96ad210c1fd500ac543382d0e5f07871": "Gozi C&C",
    "a239ed1a80532b741fb9e094cd51b05cea9b6ffa": "PandaZeuS C&C",
    "a24597124a584ad45c7ed85562fe9a40af008dd0": "Dridex C&C",
    "a2482129dc5f2f077506a308f95ddf7d8a4afedd": "AsyncRAT C&C",
    "a2556055343423ad37598da09e9a7bf452255140": "Quakbot C&C",
    "a26772cc0b66ca189d36a07616607f7451e35125": "Gootkit C&C",
    "a275768461b0ace4a35e3a5f9310437683c0087b": "Gootkit C&C",
    "a27e731874ac56905e7b1b81db556420faee9868": "Gozi C&C",
    "a29d95a4efe62460420ded10f847c4c1a0a75e0e": "AsyncRAT C&C",
    "a2b776685316bfbc6aa7199461cdbc132eee5e6f": "Vjw0rm C&C",
    "a2c3883cccd035ae19fec86236e3fdc1bdd06772": "AsyncRAT C&C",
    "a2ca09f48394afe0e78a23b5b4cfc89ab738460c": "Gootkit C&C",
    "a2cf23f58198f0b178f59e500af476e57ef2dd06": "QNodeService C&C",
    "a2d82bdd7dc3ab6a3d48198953cb131dab8717a0": "Dridex C&C",
    "a2db2b8e321110608da4d7fbce45988ff8eaa048": "Gozi C&C",
    "a2dfecb727e76ded3df310f86704e5cb74dc0871": "AsyncRAT C&C",
    "a2e2d30e55e3443068e6ebcf807071766864530c": "Dridex C&C",
    "a30202f42c88497e508e87f69d18dae156c69b27": "Quakbot C&C",
    "a30527ca8ade21871e7298d5b32e750b9e58d79d": "Hancitor C&C",
    "a31e078a7cc45d3676d5ae3fb460c3e365219397": "QuasarRAT C&C",
    "a32fa1ea3b5d64a35d22b0589d14e6c3ce608b27": "Shylock C&C",
    "a33fe508cb81f344b9d0d1e61c88ece9bb9c8cbd": "Dridex C&C",
    "a341d99ac79f2cb590e7532b13ff64b29b7c80c3": "Dridex C&C",
    "a375c665f1443e8aa5860b5891f42974eda366d9": "BitRAT C&C",
    "a385b68106919439721925a7eb0c3f3d02e89c1d": "DCRat C&C",
    "a38610b6e4897a29a18282466194beef68278337": "Dridex C&C",
    "a393d201ba27f55b3cd986151d02f8681597602c": "ZeuS C&C",
    "a3a7dc38b90f718d3b34ea0fc6bec39c8f2f7a8c": "Dridex C&C",
    "a3a8dae53a7fe156efe505253f4cc8f00fd22732": "Dridex C&C",
    "a3c23a7781772d9f9df95dae22cf3aa2d1820aab": "Dridex C&C",
    "a3cdb118ca89734856db947b205849a1dca81667": "AsyncRAT C&C",
    "a3d55482a8e9037d9beebb4e1e6b245eef5e9594": "Gozi C&C",
    "a3d6e080b1653df8620f34563afaa3538ad642f9": "BitRAT C&C",
    "a3dfb68609d149a6e057416b1d20aff98ae4cd7d": "BuerLoader C&C",
    "a40ec85016a08c59053868c79e231470d45c1583": "AsyncRAT C&C",
    "a41f5375729b3273b82a5d810fba67b4c0254b08": "Gozi C&C",
    "a4235dbbdb7a42ad7c019a532e413d69f410a512": "Dridex C&C",
    "a4374da4f2b0d70c730b4667078b4ec8a1cec6be": "Malware C&C",
    "a4596c32c6a260ffa4c5edee33814f73ff53620f": "AsyncRAT C&C",
    "a45b2548a56c44687fb87f2dfa4b7e23e215a5fa": "QuasarRAT C&C",
    "a484c722430142d81a771d0bad6a0b33b94be95f": "Dridex C&C",
    "a48addc49583a5fa52a234b148f8161338e27617": "Malware C&C",
    "a48fcb663de8dbbadcd17b8f836e2c5d4ed3b330": "TrickBot C&C",
    "a49752cb14be2df6f284ec7b251584a23534fd69": "Dridex C&C",
    "a498705d59fdfbe66f67fb479b42e90efcccf9d7": "Dridex C&C",
    "a4a78cadde73170c715e85942ce156e223ba5ff3": "AsyncRAT C&C",
    "a4b0d9118e836988769090a50f840e65cc3bb103": "RaccoonStealer C&C",
    "a4c025ebdecb998eae3b62bc0658705a8e738b0f": "AsyncRAT C&C",
    "a4c6c6772eabb48adc16271241057c22a0409c36": "BitRAT C&C",
    "a4e55c3c545911a8fff93a328b985ca92cfb5045": "Dridex C&C",
    "a4e7536868639b8c1d940f72a7400c2333240704": "TorrentLocker C&C",
    "a4eb1441a0d23f946c95eaf83f867e4b83be51e5": "DCRat C&C",
    "a4eeb4aec0547e9e07e314e5160f78737873e6dc": "AsyncRAT C&C",
    "a4f059b0fbd2a4a868e565d162e61526594f026c": "Dridex C&C",
    "a51f499232c7fc8cb13d3d3720328826c5ef4b8b": "AsyncRAT C&C",
    "a5401a4121b05930f9ada2f9f2faea0f3198793c": "Malware C&C",
    "a540856244cfc352f6bdb7d36366ec273cd0afe9": "BitRAT C&C",
    "a54980fcf6deb05377d094d2ff07112d7ec105cc": "Dridex C&C",
    "a55746f9c81010dc23427c6a8a7925d5de8c2727": "Malware C&C",
    "a55847bc3ab92101a7050d07e9d042a2272afd77": "Gozi C&C",
    "a55a8724504104e5b79ad835df80df9489372fd8": "Gozi C&C",
    "a56249d94826c1377665a6fed55354d321311803": "OrcusRAT C&C",
    "a5681a6c92f8060540baffe518f65c98cb86cff2": "AsyncRAT C&C",
    "a56af233b0c457d0bcdca5a5ac084b67d738e3ff": "IcedID C&C",
    "a56ced67e43bd667f829161a91d487016ffb9672": "Vjw0rm C&C",
    "a571fb26952c9f6ecad7c6aec928bda870aa0d31": "Smoke Loader C&C",
    "a574e4f99bfc08aa3bd32f0eb77143952a770ab9": "Quakbot C&C",
    "a5822f2beabc6facc369328e3d8136d110614635": "TorrentLocker C&C",
    "a585fb98c171bd5e2c91fbb5a32364df6e136f1f": "Gozi C&C",
    "a59766bfae6441990d72bc785268056e5f03ed23": "AsyncRAT C&C",
    "a59d3eb9981b9dfaf7bbaf6a33405d8156f75a47": "Vidar C&C",
    "a5b4206ab66bbde854c2281ee152f949a1b550bc": "AsyncRAT C&C",
    "a5c957a6f5a25e4ef547d96a4184a5bfa190a6c3": "BitRAT C&C",
    "a5cc5f0fb63db7ef4f8c99cf4928753cea90295c": "Vawtrak C&C",
    "a5d38f17fbfb1ae0b929bd1d7d3bd9ae2d166c28": "Chthonic C&C",
    "a5d700a98f78954201843486f334fd75718f91ed": "Malware C&C",
    "a5dc766d11837fcf6e23b281a5c9c102699259e2": "PandaZeuS C&C",
    "a5e812ef7e2ac54340120af8afe8b414abfd5d83": "DCRat C&C",
    "a60fad8ba7ada09b99836e2239a5d909422c0fa1": "Gozi C&C",
    "a610c803df570d50574c004683a7157bbdd71dfa": "Gozi C&C",
    "a62037da82ab89612ddfbb3150bb08e6bb58a332": "KINS C&C",
    "a631ebbfab523d3a7986d7ed0286f39e9423890e": "OrcusRAT C&C",
    "a635d22129e6eb47ee2ee9f18424b6e7aeb6ae26": "Retefe C&C",
    "a64da9de2a182fc41849ffc7ed8b0285052a3031": "ServHelper C&C",
    "a65118560780ca37f86875b68bd7f280152a8f7c": "Nexuslogger C&C",
    "a65b625b66a21a07320558cdce87d6fcd155c6ab": "Dridex C&C",
    "a662ddb231a544a30427db3b75be80550ccfa840": "DCRat C&C",
    "a668711df42010835385145722bb421635fb5bec": "TrickBot C&C",
    "a672ac43cf28e66916275bc21bd874b50ee791f2": "Dridex C&C",
    "a67b7681f2a85d9c8df7e80b8deaf1ac2b92e5cb": "Dridex C&C",
    "a69d3b3659049add79862c54e09643b013601669": "Malware C&C",
    "a69ffc5b4fa1aee02d795d91cfc1c009c33a1294": "OrcusRAT C&C",
    "a6a61388a4b379bdc6c680ec1160c5bef762212f": "AsyncRAT C&C",
    "a6b0e89642bbb60b698f1661c1536c0e46729d8c": "Dridex C&C",
    "a6b1dddbe0723b5cbb6818c5235edcbd5eb9331c": "Dridex C&C",
    "a6ba8f3e1863b395ec752a6f55ac61084a3b09e7": "Dridex C&C",
    "a6cbf1d86dbc3c09483cfd3d2834008b05a03fd9": "Quakbot C&C",
    "a6d5e05f8dc855e16c194b3578258f942e1e5537": "AsyncRAT C&C",
    "a6d81e31ccfdc5eba74ace2902caf23d9d9a912f": "Dridex",
    "a6dcd92ff112e9827fcd6548d18a66de26c6dc3c": "ZLoader C&C",
    "a6fe084606cd645e200391ac52514c5305145121": "Dridex C&C",
    "a6fec07454160afc2ea227e4285c4bfc303c8317": "BitRAT C&C",
    "a709c25c607b050b2acbb98996c63b8e913a7082": "Dridex C&C",
    "a70c1cd9a90128e6d59aa04b80d31d7901381f9e": "Bebloh C&C",
    "a71442e65bba03e9dd5deef83eeb3442b014170b": "BazaLoader C&C",
    "a71690efb3cf8aea1738c6f05c88dba8e7e799c1": "BitRAT C&C",
    "a7188f3ac0478582e902a40f1aa099ddf4b132fc": "Neurevt C&C",
    "a71d3839a8f333034d76d68530fe7cf41bc1aba1": "QuasarRAT C&C",
    "a71f899adeab0b88222b8166c3a6536d202a2d02": "QuantLoader C&C",
    "a7315907c3cf4c2960d8209d5846777e48a172d0": "BitRAT C&C",
    "a74dab7a38fff112767280632912ba0370904801": "Dridex C&C",
    "a76952943b5ed3ca2bc1d0a52a3f0064f4b5c786": "BitRAT C&C",
    "a76dbfaae146437a1366b5a32d5995948e6300d1": "Dridex C&C",
    "a7783adbedbf02e360d65eea1722e8aae77bf77c": "AsyncRAT C&C",
    "a7d4da75e84cc2c1d09da32242a658d459618143": "AsyncRAT C&C",
    "a7da82eb15e98709ba625c843dbbe7add3246ac9": "CryptoWall C&C",
    "a7dd7c6c5210fd2c8ec9526798b2dfd4388cf4fa": "AsyncRAT C&C",
    "a7e07bca128b36b9f1e43d5bfa5b28eb7421dab7": "Dridex C&C",
    "a7e8a1ded6183d239ab174edb47e841927e5a5fe": "AsyncRAT C&C",
    "a7fd8298f3238f519d01de462d75ef111f3d9c10": "AsyncRAT C&C",
    "a7fe080b0a32e4661ac5bc7ed6e3c1ef5db3197c": "AsyncRAT C&C",
    "a800e5b186ed5c2102b79765a4d32455b4f3658e": "TrickBot C&C",
    "a80d3787929725ecfd01270be57807bfbc3304e6": "AsyncRAT C&C",
    "a80e28d662474d38b468dafcf30ca92f0f6ad920": "IcedID C&C",
    "a80f80724722cd774b80388f4b853ec5d4270ef3": "Flokibot C&C",
    "a827afb8a4f46d06637aac056ea3913fbcabd8bc": "PandaZeuS C&C",
    "a82dd258544acf0a109296493421262397741db7": "Gootkit C&C",
    "a82e6d70fd4e25df80ea0c69a6f31bd502ab8904": "AZORult C&C",
    "a838ffd695033908b3a3f0bad7653c38edceebb4": "Gootkit C&C",
    "a83b245941cc1556442e0cc3de6b2edd2b364ed7": "Malware C&C",
    "a83bdb30e75941ef71b7d55d4862aeafad57e8b2": "CobaltStrike C&C",
    "a85eb17f498c6f5eb4bba80670766aafc3060600": "CryptoWall C&C",
    "a86c842d624ff7b0fa1bb2d5a10a22af6f2e7554": "DCRat C&C",
    "a8725c3c2cb07b5ce59c499314cf3acf2c43c217": "QuasarRAT C&C",
    "a8786760a04aeca072f8a2baf849c2aead9c3a72": "Vidar C&C",
    "a893ecd617c024aee544e6a6b28b7c2569198e73": "TorrentLocker C&C",
    "a8a119832702691ab0a7b0fc6a42427aa297d748": "Chthonic C&C",
    "a8a1dc5d2088cbb33ebb61edc91c3062595d9a4e": "BitRAT C&C",
    "a8beb8e0e32fa37926936a6710619fe7e5b5c76c": "AsyncRAT C&C",
    "a8c77904f3e61e6d182d7a691525c409ff12ef86": "KINS C&C",
    "a8c9dcfebc03e211ee558f863cdbf176066401c6": "AsyncRAT C&C",
    "a8d1eb836f40b6c9f42610297e99e3b68d1066a3": "Malware C&C",
    "a8db303f1b5aecceaeb4a92352df35af880c5ab4": "TA505 C&C",
    "a8f8d4d44e364de3000bf77e0a9abe33e4a73cb9": "AsyncRAT C&C",
    "a8fb10cb9a222372646f0b7b3a6e4d228ef254d3": "KINS C&C",
    "a8fe3b60b2ebcad5042a4c61a850cde1e13eb076": "AsyncRAT C&C",
    "a90328dc8df080df601e673f3059a703c0c40684": "Gozi C&C",
    "a9240e124ab94f16744d54c250f2df461ddc392b": "KINS C&C",
    "a92afba12b15143b090dcd832f60a98879fa30dd": "KINS C&C",
    "a949d46c29a87d825ed5c2520d679b3fdf0214c4": "Quakbot C&C",
    "a94a8940c9dfc18abd470de2e07325b732f7d189": "DCRat C&C",
    "a951154cb3e1b0c263da2f135733e21f694a5980": "BitRAT C&C",
    "a9617027e4254fd19870e2f4877f3928252e3ecf": "QuasarRAT C&C",
    "a9650a4522140d42e5ca4529da54805625eebe64": "TorrentLocker C&C",
    "a975aa78296bbfe0c9b319e79f4122839444798e": "BitRAT C&C",
    "a97b7616d3cfe7fec84f270d15cdd149d30ecdc6": "Dridex C&C",
    "a9829a4e5b55839e4b41a52037754d6bdf212420": "KINS C&C",
    "a983734f00ca479c4e788df7b76e3d47ab1cdf28": "AsyncRAT C&C",
    "a98f9d286b45b39f307b71cf43a25d0f7529abb8": "Dridex C&C",
    "a9990103ef2745e7deac94dbfe252f14cb4d63e9": "AsyncRAT C&C",
    "a9a00d3740ff31ba5cf716a96fe4617a53b7e8f0": "CobaltStrike C&C",
    "a9b138b9d09b20e3e6406430d3660bc58ea5c299": "PureCrypter C&C",
    "a9be6c691a96792aa5c81a4c1740eace896094f1": "AsyncRAT C&C",
    "a9beae4fe4b80345cabb17fed82acfe04868c458": "AsyncRAT C&C",
    "a9bf88872255e1d7c1202f668bb08bede3897123": "AsyncRAT C&C",
    "a9cdc9f74a9d669a9f511095c0996ac20f9dcf7f": "Dridex C&C",
    "a9d1294df9442ab03d50745cbf879bba777a09cd": "AsyncRAT C&C",
    "a9e3aa65a1e17c0611d5cadde53dd882ee437c10": "AsyncRAT C&C",
    "a9edd0d97cfbf1cddd6b101938140140b8b36be3": "Dridex C&C",
    "a9f92a278122c92d17aeedfce52c7f57d4cc95b7": "Dridex C&C",
    "a9f95a2602c4820c3f9488241f61b5c48459ae87": "CobaltStrike C&C",
    "a9fb2f7d881c4369fc7bd072f6fc9eb710dbc23b": "AsyncRAT C&C",
    "aa1bc542365bcac74c3e0f8b195ce16f963302a3": "TorrentLocker C&C",
    "aa1e69d13fc190b5917ef69fa1abf3863f2115aa": "Dridex C&C",
    "aa20c7f082e874d92a5ceb20053509c21c1d5727": "AsyncRAT C&C",
    "aa22bad89ababb3272d3ba0e839aed3204b89555": "BazaLoader C&C",
    "aa23785343965f2e0c8231fa5764ea15822e9376": "TrickBot C&C",
    "aa24d02b71190708790812e758c47a6aef044cf2": "AsyncRAT C&C",
    "aa372a6b176f2d90f285d3a63b4330c0be4ba34e": "QuasarRAT C&C",
    "aa3875b3f9cbde32f2e1a59c72f4481bd2a6a180": "IcedId C&C",
    "aa3c5a4d930667dbcb38a502db7a2509a8aa95da": "TrickBot C&C",
    "aa42733a1aaf65d4f77325fd2b2d0904df0461d2": "Gootkit C&C",
    "aa4d980d9e2b3ce6d6b1b636f61e78e59e1d205d": "Dridex C&C",
    "aa67d3daa22fc2556b1e8177fbacbbb24f668577": "Gozi C&C",
    "aa6a2c1d61be293408a1bdaaf3da51da49c542e1": "Dridex C&C",
    "aa9172a64ec2d4ef1843c20809a1b0b300db2b8e": "AsyncRAT C&C",
    "aaa80da0d9fb8490ca731e67ee78207ebff4753c": "BitRAT C&C",
    "aaaa549e6e6cd5233a228b4cbb7206a759daf4cb": "Dridex C&C",
    "aaab6aa305aaaea6b083c808501af6252e41915a": "Malware C&C",
    "aac64caa32df3e078436713d8320a4b06b5dd67d": "KINS C&C",
    "aacb941b4f9c4bdfc11fa424afc1e97f6ee05e8b": "BitRAT C&C",
    "aad0d8ff51dbfc07032157e3e05216da9e7cb5b2": "KINS C&C",
    "aad71a0852773e76faea27ed184489f69c45d181": "BitRAT C&C",
    "aaf87e4d1b4c9ec7db694529293227c55e000c32": "Malware C&C",
    "aafe56948513f46f19271c235012fe18e064ea4c": "AsyncRAT C&C",
    "ab069629b9bcffd4a7616db3df65dee2c877a465": "IcedID C&C",
    "ab1663e4a6cb0380ed98bbd5715cdb65b2d669b8": "Shylock C&C",
    "ab1989b9d86f6b6bbeee3e7d04cdebfd0d897561": "OrcusRAT C&C",
    "ab28a084e889754ebbf7c729e2f4ca853e0e6bda": "Dridex C&C",
    "ab315c687a153e56b031eac2449ec146b72221d1": "AsyncRAT C&C",
    "ab3b0d4e557000e79af4354be23916873ddf92f0": "RaccoonStealer C&C",
    "ab3b24fcb2df8b4a4f8df3236c2388a9c0cc27a6": "Vidar C&C",
    "ab4ec261cfea459e217097dbb9fcf61963ff890e": "Gozi C&C",
    "ab540530f1e1fb0ce98c6980053b9d09100ab6e5": "VMZeuS C&C",
    "ab5e9661956ad1cd7c3ed09aaef0bf5549d4bd9b": "RaccoonStealer C&C",
    "ab631d10a29527795c171ada34a3a73107ebcfbd": "Quakbot C&C",
    "ab6b8304b7130f3dfb591f40ea217669447b9e4d": "BitRAT C&C",
    "ab7262eda1fea69b003cc5f2b326abc0633d6159": "DCRat C&C",
    "ab7ecaf8df4fd062749884c5fe1c920ee93199ec": "AsyncRAT C&C",
    "ab84a1e1771493f5646e3bd5e5d4d9cc42798023": "Gozi C&C",
    "ab871da01ccb96e48ed3634518556262f5b735ae": "Malware C&C",
    "ab92dbcc120545361d3accc550d4e57967d48571": "KINS C&C",
    "ab97718748d79a4cf900b0354be1ae9a81b4d05a": "Malware C&C",
    "ab9b79a4022b8b4acc9c2e43a10265565a6ffcc9": "AsyncRAT C&C",
    "aba20df9def8eea67e9bd4513e3b4eaa84d7470d": "Quakbot C&C",
    "abb291f39ba9844cc5f134b40c16c59a2e9970a1": "BitRAT C&C",
    "abbc90752a3d953d55af2f9ab92deccc3d128d03": "IcedID C&C",
    "abc0eeb8f6b291e2daf1af6ec6ff74ab790fba40": "BitRAT C&C",
    "abcb077b0058479aff49352923501f26ed45ce81": "AsyncRAT C&C",
    "abd34c09da5f043d82112f9eb286792e4743ed39": "Gootkit C&C",
    "abd876ef7ec74dfbd004d3303bc05275f4669715": "DCRat C&C",
    "abe186523fbaea20472cb30a36fc8a57f5919cf6": "OrcusRAT C&C",
    "abe4dc7a9c30079a7c3aff4603f9b1fb28756548": "Dridex C&C",
    "abf5ce4f1c125257600159681825152a8ae87e1b": "TorrentLocker C&C",
    "abf9ea90a6e2fd62adc09733c0307a79bae881c6": "Gootkit C&C",
    "abfad148c8e43ff7516887c3733b2290602361c9": "AsyncRAT C&C",
    "ac0172a41590d4274a12ee9c92d5e523ee6fd8e0": "AsyncRAT C&C",
    "ac0fe81cb6262b0b787c25ed7df6b398700c6d21": "ServHelper C&C",
    "ac1df39c13e4783f37de774c0bdf8bf1ed9a3f8e": "Dridex C&C",
    "ac2bb72816fb804c4320ada77f90caffe49515ba": "AsyncRAT C&C",
    "ac2d7d26062d68bc48870cfe1afbc1dd42a24341": "IcedID C&C",
    "ac2fcc2c6a6fd7757e24f269a8f93f2187f04a6e": "PredatorStealer C&C",
    "ac5c1f1aa5753df82a1d587d3cd8415069613b61": "Gootkit C&C",
    "ac5fadf96354c7dd78f5473a0a27387de9b12d5e": "Malware C&C",
    "ac648538411ef873fe49093728e836ba51923ffe": "Dridex C&C",
    "ac7c42306d777fc0de5113290890ceae2a4aa255": "Malware C&C",
    "ac7f51af5e0cf0ea0a59b7e96d43f41e6fc5f60c": "TrickBot C&C",
    "ac894dd3a62d498c3f6317a45cd6e22dccf1bdd2": "PsiXBot C&C",
    "ac8f6f9b657e86e52631c720157808b3d17cab69": "AsyncRAT C&C",
    "ac9929988cab800a653b0112ba316c4725d19fc3": "ZeuS C&C",
    "ac9c263cbf3c21bd7f9abf32b6e131135374f6dc": "IcedID C&C",
    "acac86d292b53c83876125808f63a0a1b1ab7257": "PandaZeuS C&C",
    "acad786cc04eb077502bda9f49c9d5948278582e": "TorrentLocker C&C",
    "acb131d031b871cf13862571426b6353fa4a3fe3": "AsyncRAT C&C",
    "acb96e00e0d811742d7281bb616198cc803c371b": "Dridex C&C",
    "acbb66698b5c41ea5d5a7c9c7a91e97903800031": "ZLoader C&C",
    "acc35621f4ff679f60b1080a4f13f896766ad2cb": "IcedID C&C",
    "acc746d61742cbbd583fa51d78abaf537cfe0047": "TrickBot C&C",
    "acd343270afbba88a43eefd11d8b30e4bb0202c8": "QuasarRAT C&C",
    "acd53a9afe1eccf413140519935dabf752b4434b": "Gozi C&C",
    "ace94d19d9d78c915d9ee080bf60cd41ac8db91a": "TrickBot C&C",
    "acee60a27036f51507cc3923e467b0536ff8a068": "PandaZeuS C&C",
    "acf5f31e13481f446256f4145d007035d812cfae": "AsyncRAT C&C",
    "acf672eb31d04df611cb940bf67764ad73641d22": "Malware C&C",
    "ad04514444aa971bc84c16e6c00e575be0588d93": "QuasarRAT C&C",
    "ad09e42ad862e9f6b53fee3df0aabd9b0cb933c7": "Dridex C&C",
    "ad142ea9154275048e4ed1882110be8ad8f998f5": "AsyncRAT C&C",
    "ad1bfc7df1e872816f8b06673345aeda5148cdf3": "ServHelper C&C",
    "ad3ab063e6de4eeeaeb67318c105d8552094dd06": "Malware C&C",
    "ad47207d0716e2c3721115bf8a32e3c8216d81f1": "AsyncRAT C&C",
    "ad723fdf004b0c35f3cc37a8b05bee79c124ab54": "Quakbot C&C",
    "ad789f6890c32ea4f15adedaf206941aa840e2f6": "QNodeService C&C",
    "ad7ac36bf6a1c8b8aca460b87278c44dbf77946b": "Malware C&C",
    "ad8103b5e6150660edb317ad69a93e80370ba9c9": "Dridex C&C",
    "ad9301536bb94d13211cf3f7ed3e130d295119bb": "Dridex C&C",
    "ad9be728997e45bbbc06a2a591a6b4ddcc55a863": "AsyncRAT C&C",
    "adb1c86b00ed2ad38e00428d8f348d53d5f85967": "Gozi C&C",
    "adcdbb4671229de15dce69a470de2ef42cb19e58": "ServHelper C&C",
    "addb92d43f976c8e4f417a3a87cb1a7735e52a96": "QuasarRAT C&C",
    "ade6611982c40d1184c9c2b8710787fca4f4b9cc": "TorrentLocker C&C",
    "adf0ae94a3d1ca30f0cbc23bfffb93b5d01c6fda": "Dridex C&C",
    "ae038786e50e26e99d030a4223b3284a44de8ff6": "DCRat C&C",
    "ae0424d2370382139989ac0f12268ef886caa2ce": "AZORult C&C",
    "ae0e9c61665a8941ca72f27abc0501f74d8f3e88": "AsyncRAT C&C",
    "ae1a4000be2c8351161af721c8a8297aa318fa82": "Gozi C&C",
    "ae2c1d70ba8bece5de991266d554e81b09015f49": "DCRat C&C",
    "ae486ea3aa0fa0c0d484f102de286042fb860a44": "OrcusRAT C&C",
    "ae4e28155555786c41d494acde649c087b141ef4": "BitRAT C&C",
    "ae5a23a8836a3c9e91a8cb4c510c29ad4f76c286": "BitRAT C&C",
    "ae625f32faeca9995d2019c067b0ca8ce6fc014b": "PandaZeuS C&C",
    "ae67490ca34a6d4948398d85c1a6b030909ae336": "Dridex C&C",
    "ae77c01a080b665ab39bd81ef218f05968611b49": "BitRAT C&C",
    "ae7c42e5843f1b2ef1f7363d27df1ab0f7b01111": "PandaZeuS C&C",
    "aeb9224f65875ce095c79270cb61643fc00ab232": "Gozi C&C",
    "aebfc425916f7d4119d8fa016e1b18fb6c24e04f": "BitRAT C&C",
    "aec50481bf00a4b4c3b5695ece992cb034507bd4": "Dridex C&C",
    "aefd273bb6cf4bf2ce87f61aa82a2c55bfa7146e": "QuasarRAT C&C",
    "aefd38c555440159a6fbd7696a7cf3db3c982341": "TorrentLocker C&C",
    "af01a859ba00dced9ea61ae537bfb4cb5d3deb0a": "TorrentLocker C&C",
    "af1927d2140e3d1f5da46a58b9af064b9ccb4e4b": "VMZeuS C&C",
    "af1a9c4611650dce08bb906ae61abeb58f76a170": "AsyncRAT C&C",
    "af3590c1313edcbd4b9a3b89617b3177bf41600c": "BazaLoader C&C",
    "af45f6035c17cd809e33c46b116e5aed11edcef0": "ServHelper C&C",
    "af490a3938edf530c770aaa9468c6c59a1b50cc1": "Dridex C&C",
    "af50d0afaaf5c0bf5a6b046d93839ad402564005": "Quakbot C&C",
    "af6378cd74975b1553f8ac15f3ff9d71efdb1bda": "AsyncRAT C&C",
    "af6ed04f88a7d5a30a325a6af5b4a16a45974bb0": "ServHelper C&C",
    "af7424d7b388bd981345e555a675f156875b52ec": "Gozi C&C",
    "af8afbec4b5d4413db8d55ccdb53536280c90eca": "Dridex C&C",
    "af8d9adafc003111285c8780e1a6687eb00bc0ea": "Stealc C&C",
    "afc731e5e4e636a70e2078382cce170ef83d93f6": "Dridex C&C",
    "afc8d119cad2f1177e1c51248153cb26a367cdbf": "Quakbot C&C",
    "afceeb97abead6b35073c41a102006af913e66b7": "Quakbot C&C",
    "afddb5a191edd94bd5554259fa2e051ea11720c0": "AsyncRAT C&C",
    "aff34ffdf35760c66997022c82a0a3f523ab80c4": "Gootkit C&C",
    "aff4f3a728f165bee5ca7cdc1f9471d17d491a62": "TorrentLocker C&C",
    "aff50d829b825b1fa2f78e8eccc97120c684d1cd": "AsyncRAT C&C",
    "aff7e866ddef40f62913695131bead1a55e7ce34": "Gozi C&C",
    "aff9fe9ce8f57eaca7f541c6a6c9b8d1504d8f7b": "BitRAT C&C",
    "b00080d004ca5f05813832a22c442521bf58ff0b": "Malware C&C",
    "b003443ef12b5ff44b5a00a268d2095b43d2a86f": "Shylock C&C",
    "b00eb82eafdf6f0351c731d61ed7799d3ba4e541": "TorrentLocker C&C",
    "b01c26c47cb28deafd2f4e080c5b6a4b2969d2be": "QuasarRAT C&C",
    "b020184552137bfe2069b1bc6432435aa523687f": "Quakbot C&C",
    "b0238c547a905bfa119c4e8baccaeacf36491ff6": "Ransomware C&C",
    "b02b3d3d90a0e02b108707081e1b1b4f6734c0d0": "KINS C&C",
    "b0326395ac2d48856cae22978a087df5dcf5816d": "AsyncRAT C&C",
    "b0392840a44b490513e47944920d12fa8faf20c4": "Malware C&C",
    "b0407930dcd7c38615c8e660c4d39121375b1172": "AsyncRAT C&C",
    "b04537497c482e283f41f82c02ec81c67f43224c": "NanoCore C&C",
    "b045bec6fb6122b0747bc2743850aaab7868e62a": "Dridex C&C",
    "b05166f5429ec47c2d582337a043bb23986724ab": "CobaltStrike C&C",
    "b05d8bff3cd860c005fe98dac3b38ec14f46bd7b": "Gozi C&C",
    "b063bcea698932429aca7d185d7f6fcb08dfa2aa": "AsyncRAT C&C",
    "b077c0bbcfd6397ef7341f91276faeda592b7ff3": "Gootkit C&C",
    "b07a5acb95a4585b18077793dca9a6397f04da84": "AsyncRAT C&C",
    "b082c7f23c49391c033d05374cade344e6d0a095": "Dridex C&C",
    "b08a4939fb88f375a2757eaddc47b1fb8b554439": "Shylock C&C",
    "b093aa012857b3dd4d5bb30d2d98b7c9774747ab": "Dridex C&C",
    "b093d2ee304ee3f3aa7b3eac7a848fce0e4b9095": "TorrentLocker C&C",
    "b09bca1e01bf3bf55bb45471f835d2bb8b8dadf9": "Quakbot C&C",
    "b0a533c26fd73a2e928fb19b250df37e104b081c": "QuasarRAT C&C",
    "b0b11f67592a0583c4bf283453fa31b41c6bb8b2": "AsyncRAT C&C",
    "b0bbe3dae1eb458064c619801d05a8dc5e233934": "Send-Safe C&C",
    "b0bdfb8daea38d57461fbc9d777a4414d62c9a2b": "QuasarRAT C&C",
    "b0daa39138e228d7370180555d32dc341d319e71": "IcedID C&C",
    "b0e59355af6bfbe66974f1c0d38a93a351974679": "IcedID C&C",
    "b0f3122c1ab28fcd3fa56e7d88737bc05e095854": "Dridex C&C",
    "b10a61dc74182fe8218134dfb20805cc2627a635": "AsyncRAT C&C",
    "b10c7d8d08295f4f6738646da8c1dcd0c3bbfd5f": "Dridex C&C",
    "b10e8878f9db248f7633d3569d37e483c9f96a7c": "Dridex C&C",
    "b118cd1a010f9e0954599b3743ef5ea8c161ca5f": "Malware C&C",
    "b119db0e778c000ff5ea7415852c88a47e4064ab": "AsyncRAT C&C",
    "b11da21566067826d2ac179efebbb1f124d917db": "DCRat C&C",
    "b11e5db4da0a1eb419ec3d14443b10616daa0233": "Shylock C&C",
    "b14306e4da103a336e7688d93fe63dbdac89494b": "AsyncRAT C&C",
    "b143f31e058af895dbfe9e47f4fee3620f4c94ab": "AsyncRAT C&C",
    "b15b34caa47158b17b5d64fcce462119355cdb16": "Gootkit C&C",
    "b18cc270ff799c56ea5ed1917752201891c29c6c": "DCRat C&C",
    "b1a1f738f7e4c36de39c4f4622b5e8b4d15862e7": "Gootkit C&C",
    "b1aa79cd8ac349d43c61771f1d03f2943cfcc313": "BuerLoader C&C",
    "b1afaaf41003bc8bccb4951f89b035f6aec78373": "TorrentLocker C&C",
    "b1afea2433147d38043d7b05d4cb6c4a29a779f1": "Dridex C&C",
    "b1b6141ddff2246bc2b653bcf6ee862ce3b309f6": "Gootkit C&C",
    "b1bc81f0ac315827e3a260d18bd151f448daf710": "Quakbot C&C",
    "b1c24828ee6174869f6852657a9dee6819850e08": "NanoCore C&C",
    "b1d51e8c095d01ef20c76b7f4ca768431ea04628": "Quakbot C&C",
    "b1d87ef0a0c28d550667aab3fc00361559923e64": "AsyncRAT C&C",
    "b1de7fbe0939b51515ab108001125c5974fa2481": "AsyncRAT C&C",
    "b1e91ab8b31a132dbcfb2b618fd368a4faaae721": "AsyncRAT C&C",
    "b1f363cb165b4add4702fd386a0a1054bfed678c": "QuasarRAT C&C",
    "b20d20ac3b2492f11a2775d800fd726e14fc6fa6": "Qadars C&C",
    "b21c9517c2f53cebdbf1f0a1a78252a475b79d61": "Dridex C&C",
    "b21e502fab5b5d684d29b0ae73751eaf65384677": "NanoCore C&C",
    "b21e678cb60964071a4e76805a8639cb8319c9c9": "AsyncRAT C&C",
    "b21eb5fc2f3aa11e5d9ff643a5b3c2ce70f8b250": "Shylock C&C",
    "b22eb2d8681247bcfc5153bf3a7bdaf511e55af5": "Dridex C&C",
    "b23de895084ada8f648fafeacfc51b2b3fab592b": "TrickBot C&C",
    "b24f1cbec103286733e4bd670f41a3f5523f9236": "AsyncRAT C&C",
    "b26d84efa47990b9135c5b0ce18e3137b279e8eb": "OrcusRAT C&C",
    "b271ec2a83aa2a624585808dfd2f6651c035c889": "QuasarRAT C&C",
    "b28616ecac37a3dfa13b56c754700cd5b5964117": "Gootkit C&C",
    "b289040e4b971dd68b6480b60218660010e5945c": "BitRAT C&C",
    "b28f9b74db9c21725ab50a5b33d735bd010735be": "AsyncRAT C&C",
    "b297b5f86730a8ebf9ed9c8e9473f4640239e981": "AsyncRAT C&C",
    "b2abffc753d55576e19f2237807e691e2abaf3af": "Quakbot C&C",
    "b2b3a1fcd2301f0ce04cea0ab70e3068879efcb6": "KINS C&C",
    "b2b9011985d67012bf984b7edc42fca5cce154d4": "AsyncRAT C&C",
    "b2c206219cee241386a35e0d329b5b31782837db": "Malware C&C",
    "b2c38a5b495e2c490680cea7cd71228a56bfcb44": "QNodeService C&C",
    "b2c671313ab30e229cf2bf12b492c5dcbbeab591": "AsyncRAT C&C",
    "b2d08782b7bfd7661e28ea34027576819b820ab4": "DCRat C&C",
    "b2d0d8f003f06f104866e0d416b4b756a9ec0aaf": "PsiXBot C&C",
    "b2dcf0beee69181365a7da7ad4921bcff96461ec": "Malware C&C",
    "b2f5b84c0d70dd02efe659cd883026a9a85783be": "BazaLoader C&C",
    "b2f784c1ca507901bb08c606fedf999edbbc7ac6": "TorrentLocker C&C",
    "b30fc96088dfe64831595227b8ec33ed6b308e2c": "AsyncRAT C&C",
    "b328ae723042d79e76f37234de91dc228d88b57f": "AsyncRAT C&C",
    "b32d3c8803382a8672aa6a3f49329132dc51df8a": "BitRAT C&C",
    "b331526a0949f88ce218555edf1060c4a02de5a2": "Rhadamanthys C&C",
    "b331adfa0aac3f0c7e4806c4b12dd1599e52f271": "AsyncRAT C&C",
    "b33291e63e30ab0ecd6a1af9f86c93eb3ba89bea": "AsyncRAT C&C",
    "b33ea789c1770a7236c8bda7f143b2928987f799": "BitRAT C&C",
    "b34d5253e05a0f6bc09d15e16dcbaac3dd07dd86": "XWorm C&C",
    "b3581099d7aa93fdd58221372c7997304b56ca1d": "Vidar C&C",
    "b36cff6d8fc62b06a545e698505732c1e70445bc": "Quakbot C&C",
    "b370df40445b8723ff2def9e76a3fcef08641988": "QuasarRAT C&C",
    "b377ef630d8298589b19cef5b6906bb8868b91f8": "AsyncRAT C&C",
    "b38a8655ecb569de29434ae8c7b187c93b84b606": "Dridex C&C",
    "b3a42136ad8b2b3517e41d90d9f83290c06658ab": "AsyncRAT C&C",
    "b3a9715c0f9994b7f8d9412d4cdfd40ef36cc14b": "AsyncRAT C&C",
    "b3cdccc5ed03a1bc14a2ccba98ca2c359a278346": "DCRat C&C",
    "b3d37297ce0fb5d6b95fa20db11dc2408b4b7377": "TrickBot C&C",
    "b3ff91c310bf2b6873c90bfc870806ef4eaec49a": "Shylock C&C",
    "b401c003b25e952e63aa240986ffb77f9f4ff17e": "AsyncRAT C&C",
    "b4158d49431c9d2c27e2a99cb9ea4184b72cb9dd": "Gozi C&C",
    "b4430a3e2913a567054bc8cf624af0c42b13a9fd": "Dridex C&C",
    "b44b594d09b3825ac44b5f243343c9bfb76cfec7": "Quakbot C&C",
    "b46db9187793b1668f86fb727eedab4d5b2414e4": "AsyncRAT C&C",
    "b46e5c69c4e7eff1718e0a9cb21894d6e07be10e": "KINS C&C",
    "b491371e62d54abf942259e142b02655340ee663": "KINS C&C",
    "b495265fc8f9966ebd9df7589a14659e91eae6e4": "Dridex C&C",
    "b49cd73e2bdeb2d12fe8b08fd5e18d77fe89c37e": "Adwind C&C",
    "b4a38c8e65cbc1b1be24b8198837cccd79855d90": "AsyncRAT C&C",
    "b4a73b854389dbe35eca2cc2a1ea7f63348a7a67": "Gootkit C&C",
    "b4a8b55ed500a08f3c83c2f4708aea66a5d521dc": "Quakbot C&C",
    "b4a9294818898d8495aa539f079d7a78800107fa": "Gootkit C&C",
    "b4b60b4a4a7d2fca07e26859e65c4b563600af04": "CobInt C&C",
    "b4bc174c1dd33972ed980f1e98ff709a3eb43ff2": "Havoc C&C",
    "b4cf3f78786c43c6de23be91bd90013a8c29b3ea": "BitRAT C&C",
    "b4d54568218b3649fe0b50eae6ca0e0b410e1a81": "Dridex C&C",
    "b50831a1d3199b41d52d4376c5caeacee05a4ae3": "Qadars C&C",
    "b516cfa2673ac7d5ff055ae2cb231a781e3947f6": "OrcusRAT C&C",
    "b53702cc09cf8a1862183337957f8715c38cb733": "Quakbot C&C",
    "b53adf2d2173e4b5919d1ba25fdd97be5ae1d47b": "AsyncRAT C&C",
    "b57092f7efbb48a12187e7a456f1b012d207184f": "TorrentLocker C&C",
    "b5842e892e61bee844e30e182c76243f26af3eed": "Dridex C&C",
    "b58680d6a6c2c868de0fca1d4ab6f3d360cf5dc9": "TorrentLocker C&C",
    "b58ab87f554b5c99aaa048d56a030f28c43977a4": "Gozi C&C",
    "b58ad69478b00e97620a70818f8cf39bb271ba76": "AsyncRAT C&C",
    "b597beb8d4cf6e056cf6b0d943398eacdbddcc0a": "Dridex C&C",
    "b5aa4dd38099be1ce3c9e3de7fade8c81a651354": "OrcusRAT C&C",
    "b5ad8c783c57efbd676491a5d2d7a863163d9e14": "Dridex C&C",
    "b5cd5878a1453aa7da65478876b3bea9ddf6d479": "PandaZeuS C&C",
    "b5db73d94ec0166b233096bb00ef8b11fefe2b90": "AsyncRAT C&C",
    "b5df7ee788cf69d89b2edc8a5044806310c6bcd8": "Dridex C&C",
    "b5e6473db864cad75cbb11f47c41121f6e84614c": "AsyncRAT C&C",
    "b5fb3b5dede380b1408ceceb2f86bf96dd3d1d52": "PandaZeuS C&C",
    "b5ff48e0d2152e0483f18d506041467a55d1fba8": "KINS C&C",
    "b6028517c10fe9e31048f02e5853e5c1741fefb8": "Vawtrak MITM",
    "b604c821ae0f81ab9b0e9fc4318db5e09220204e": "Gootkit C&C",
    "b605c666e19d5dbc06f573a41f3594d1c931faf1": "ZeuS C&C",
    "b62af52ff56389ee60d2306aabf4ffd1f058d2dc": "Gozi C&C",
    "b62fa5a0a6c385b388f91f08e1759f2fa35295c5": "PandaZeuS C&C",
    "b642c4372cc66be45bffcc4edf74161e1b53c9c0": "DCRat C&C",
    "b644bdc6b7406d08e839b98b97e1cc309a00e60c": "OrcusRAT C&C",
    "b65ff0e2f1a61cee55392fb6239136aec3bd2ce5": "BitRAT C&C",
    "b66fd679bdcc361c3036b37ff1830c7e18e25804": "OrcusRAT C&C",
    "b67aff5e0d5ec86327008a1ed35fc03e2cc4d3da": "IcedID C&C",
    "b67c5e03dd648d00feab7501364c3b50ffdf8543": "OrcusRAT C&C",
    "b69e3bcc8e51e108741f1526a55748af350727cf": "IcedID C&C",
    "b69fcf67aa114ae3e607519f927d2b82b780f946": "DCRat C&C",
    "b6ae0c2159014f92f4be94f106a9a12bedca47de": "AsyncRAT C&C",
    "b6ba50486444a16aa602bb2ef59d6d3e872f80c9": "AsyncRAT C&C",
    "b6c0211be4e0201d2e412989f7ae98614cd9552f": "Gozi C&C",
    "b6c04695b713e3f6f2428d303dc77bd088caaeb3": "Dridex C&C",
    "b6c2dfa6712c2d55aef07161c45fbf3ba87aa4ed": "Gootkit C&C",
    "b6c2e92c6763f0d8f5ab53e7f858cfc94c05c319": "Malware C&C",
    "b6c30a7e5997398014cbb41d0c5eca4452555490": "Gootkit C&C",
    "b6c51cfe0db2023a4b8b9d373eddf0b3a395d892": "AsyncRAT C&C",
    "b6ca75f3c7f03ae2f5610cfe720f480a1652d831": "BitRAT C&C",
    "b6d7852ae1ca325f7728d46412448b0141940bc9": "ZeuS MITM",
    "b6d85d96313e99a28bc1e8efb817ac6fe38cbb98": "QuasarRAT C&C",
    "b6eaf9c4d05b7764870db1ed76e7fa648fce28bd": "Dridex C&C",
    "b6ed274a89074c5bd50237cd5d72f211ba37edbd": "AsyncRAT C&C",
    "b6f84c4ce2413e59d9d7a895b9343f64819890d5": "PandaZeuS C&C",
    "b70207353e5915ff2875cdd7add9d46090e58bd5": "KINS C&C",
    "b71368c8779f24889888f46e14542f55829781a4": "BitRAT C&C",
    "b716ac6b4ca64d9d9c42e242e9ab966292523f29": "TA505 C&C",
    "b7234f3ad1a59c7001a58a9a2e425fdb3d15baf1": "AsyncRAT C&C",
    "b73187681b573a5cede782a81d857b76560ad2b0": "Gozi C&C",
    "b736867cd516c8b6fb67365adf945a5fc6943067": "QuasarRAT C&C",
    "b73f505399a847316de105b8c678399f37a73a66": "AsyncRAT C&C",
    "b746921e214a79b7a370648a4b47d75a82f1a24c": "Gootkit C&C",
    "b74f34392c6d36a7102fad9b72d8baa1e7f6fc41": "BitRAT C&C",
    "b75eae2b4f1069d4c5a402e877d62d39782d1e17": "KINS C&C",
    "b7686213e984fdae631d10ccc94197e3246f43c2": "AsyncRAT C&C",
    "b7744101d07dd43fc0d062c4f488f43b4f0cf6a9": "AsyncRAT C&C",
    "b781c52d5b3a566dd0659181ff3d14848c0445be": "IcedID C&C",
    "b785d1a9e5784703b98a96698ad05dff5e07229a": "DCRat C&C",
    "b78f69a49658dc63405c19829f8d1c20f98011da": "Dridex C&C",
    "b78f932315e7357478de18c1d6f09b2546ec3a1c": "Trickbot C&C",
    "b79afa34a7e7728d48bc5abc0ee9a643b18f44ca": "TorrentLocker C&C",
    "b7a0646de2acde90c1c99556789ff190faefd359": "Vidar C&C",
    "b7a0bcdd9a64c5da08ef2939676b91f98c9147c5": "BruteRatel C&C",
    "b7a4743e885675b9ac54f73b4217ef60da84f73a": "Flokibot C&C",
    "b7ca9219f3fff09ce2d8ac6a0322df3f21b0bcf3": "Gootkit C&C",
    "b7dcf408fdca094dd17f5bae03fc9bb8466f51dc": "KINS C&C",
    "b7e7d9217d8734ee1cf523f1d37ceb3935d391b9": "AsyncRAT C&C",
    "b7ebcbb5353ff4c6db732c1b39beee591fb9eb6e": "TorrentLocker C&C",
    "b7fb6058e5fc1df08a13b6f2ac8b0eda4ca1a2db": "Chthonic C&C",
    "b805e6a35ed0f5fd0642ea84082b84bf9036ede5": "TrickBot C&C",
    "b80ca1c9ccaa128ff81fecc1b9730fb1c69e0560": "DCRat C&C",
    "b80d52b82967b943d6328bb270067412d19a3a78": "TorrentLocker C&C",
    "b819211e7a693e6e016df5c8de60449eb3568578": "Malware C&C",
    "b81edbffb889f6cac88432fa15cb8699eb3f42aa": "Dridex C&C",
    "b821b99a945a8ab05a8518c4c1ec2f45f1ed6065": "Shifu C&C",
    "b822cb45a2e4e8422a845fd95fc99d5b12b7b87c": "Dridex C&C",
    "b83e21100175bfa795dbe1837fa8229d636d5ace": "BitRAT C&C",
    "b8403ca531a4d62394d432763c576ce678f91d17": "TorrentLocker C&C",
    "b850ca993a06d929f0d76c963f0393b06f256a55": "T34loader C&C",
    "b8558901483d33ff0f4daedda1e5e2d28993ef6e": "AsyncRAT C&C",
    "b865e84aeb038ff2d58c6ff90b9f388c371f15de": "DCRat C&C",
    "b86bccf6f9bfd782f15e2b0d252ab3de593ebe4b": "BitRAT C&C",
    "b875e257ca8ccf1aaae2536da4e539b47ef84835": "TorrentLocker C&C",
    "b8828daafe0224d6de457ed1a526a3800ace57ab": "Corebot C&C",
    "b88b2d3992f2d401548bbff4a067e4a8dac18f72": "AsyncRAT C&C",
    "b88ef6bcd46535e4581890c6544ced2a54e8c954": "Quakbot C&C",
    "b8a0e2a02f3f73d0d0c0063592cbdf481abf0316": "BitRAT C&C",
    "b8b9209dad7eb59dbf9ab6c22a77b62007c68ac5": "Quakbot C&C",
    "b8bb08f501a56aa7f0f280b34e1417a0b05dd561": "BitRAT C&C",
    "b8d44c010f86fb6aa12b0a935513f76788d331df": "AveMariaRAT C&C",
    "b8e3ed1bb59bac1a0d18725e751a7b43b462df59": "Malware C&C",
    "b8f910c7f8ce9a7ce3918a2438afddbe013be80e": "PandaZeuS C&C",
    "b8fae9bb49f585ec2dd18f3b2f4ae032624b55e8": "AsyncRAT C&C",
    "b909971970998c8953f0ed5ac23186ab126cee68": "AsyncRAT C&C",
    "b90d9a43f7c3bf3bba75403410e571b5f80ba7e1": "QuasarRAT C&C",
    "b912d1a63232e822f43b7d5f79b5bb6be6a7d372": "AsyncRAT C&C",
    "b91572365a7eb71c324f67dc08ac0f96b0a10bf2": "Gozi C&C",
    "b925720e959b8d6f855e87b0bd3eacfdeb88ce2b": "OrcusRAT C&C",
    "b92dce4fd4da525dcb3571c1e40f684b7ca1f7ff": "AsyncRAT C&C",
    "b9467cee532fc0a825f9377a582d8bfe4317ce93": "AsyncRAT C&C",
    "b957c8025aac4edacc8f3a9b3bcd9b2c30977805": "Gozi C&C",
    "b95a90c2b5ce0757159d363b1022f040d4591bea": "Adwind C&C",
    "b95beaf30f84511c9a03b3a84729b144e1695a9a": "ZLoader C&C",
    "b964217c37ce3f8dbee14e93d0f959ac3073e746": "AsyncRAT C&C",
    "b96b2bcc55e4a1b86cb5dc2434f047a96f048a6a": "BitRAT C&C",
    "b98625050c50cdf71bf2a006fe3d005a138c00cf": "BitRAT C&C",
    "b98eec2f3847c5f3b08d9142f4f6ef1eb5045ef7": "AsyncRAT C&C",
    "b9aee8ccc7a3f5280991dbef6628bbb1af9e857a": "Quakbot C&C",
    "b9bd5534c274a67049a4fd5d0d95d82840916044": "PandaZeuS C&C",
    "b9db1fc8b77ceeb2ba861e576ae1bc6438b24962": "BitRAT C&C",
    "b9ea1c3b6b0e357ca8e07c21475da347bd5831e1": "Dridex C&C",
    "b9f4a46da2f64e6468c6f568e344a6b6637e7e00": "IcedID C&C",
    "ba0b4ebe6f07d2f34f98d2c602188a9d1cd8a709": "Quakbot C&C",
    "ba0f36f7c8d5ded0ec585d570ece030225269a11": "RaccoonStealer C&C",
    "ba154864e963cd9bf93322e68d98de7f3eabe10e": "DCRat C&C",
    "ba2454d522edc49135505dd3fbe871ed94c7bbbd": "RaccoonStealer C&C",
    "ba2dfb2dc7e3ad2be535bd87db5cac641d840724": "BitRAT C&C",
    "ba307427816d18404338bcc8c9802c776fdeec95": "Gozi C&C",
    "ba3c943a486154cadeca7e14e0de11e9e4819f27": "Gozi C&C",
    "ba400a4d016037cb0f244ea3ef0b04e2142b9c9f": "AsyncRAT C&C",
    "ba421e58624effe45f5578797e82e5e8b0406585": "Dridex C&C",
    "ba5a62497efa9a509c2eb8df28c91615c9afd1d1": "Adwind C&C",
    "ba66b8103d8fa5c30eb64649bd24cfcb0893bf37": "Gozi C&C",
    "ba6abc5d165a65c50b17c9aada0d8fb280ff7586": "ServHelper C&C",
    "ba6c9797221f841e9f488bcc2ed08059397091bf": "TorrentLocker C&C",
    "ba7c40be7dc0682a668d1631585ef288a6247d4e": "Quakbot C&C",
    "ba7fb55047595574e5e9d8e76fd681284db7a506": "TorrentLocker C&C",
    "ba875be474a8c9c32de8b1e44c36367cacba5ca9": "Gozi C&C",
    "baa0456c5339b1d1f88a92b077ce09b42c6915c4": "Dridex C&C",
    "bab568474efe17dc22df629f434c2574c8ba52d4": "Gozi C&C",
    "bae6e456b7239d2e01cd2abb6a10139d963c7314": "Vawtrak C&C",
    "baf1016e1e94309672f715f0d97dec729d639aa0": "CobaltStrike C&C",
    "bb02791fe1b44c69e38d2bc7b824749c57aebb13": "Malware C&C",
    "bb07bd6f839f236b8edd495e1a361f3f5f702e71": "JBifrost C&C",
    "bb14ff3982ae18b46ae35032ff44caed0ba1d05a": "Dridex C&C",
    "bb2cab20d47b84ff96432f516d72ebba5aa09067": "Malware C&C",
    "bb53aa5ac3ec91522ba6fa32b6d19e0d16630c8a": "TorrentLocker C&C",
    "bb560cdf0350e8418a6f60742e5c8a18ff0f8040": "Gootkit C&C",
    "bb56e3d9b370cff33769c11812e10fe094b31800": "Ostap C&C",
    "bb589afd40efeb2830011aabff549ad7aaa47cd8": "Gozi C&C",
    "bb5915865e2f7e2074e9fc70284f99618f86b31c": "AsyncRAT C&C",
    "bb694169bae7ce98f5ba83890fe4515f41abc805": "Gozi C&C",
    "bb764a470ac3821d3cf665eea35a9ee953948b81": "DCRat C&C",
    "bb821abe673afa8d361ff182312c9fef3f3aa754": "AsyncRAT C&C",
    "bb82a5fe49ee29a721807b06637ec7141b622278": "AsyncRAT C&C",
    "bbb05b540bfd17c177e52f7cd97cab7c830ba90c": "QuasarRAT C&C",
    "bbd4380bab668d9a7f9259b44ffc5c93b991e99e": "JBifrost C&C",
    "bbd5449b9ff167315fd31f164a6e360a783c72e5": "AsyncRAT C&C",
    "bbda52d7c569f972597704f1ddffbb722a798f8e": "OrcusRAT C&C",
    "bbdbbc5c9c29aa274f48deab62cd97f88aa066db": "AsyncRAT C&C",
    "bbe16a1cd469b6d1ab99bc5dc4b2438fb6801e60": "Dridex C&C",
    "bbe9ee9d5c04b4aedf00586a526b500103e176bf": "Dridex C&C",
    "bbec7f09e23697eb0d5d772f3855b35893fc307a": "BitRAT C&C",
    "bbf3e6b60c9dec810fcff6cb12926aeb9d76e298": "Gozi C&C",
    "bbf4db18c36dab916a86efc695bf4663a83f031d": "Vidar C&C",
    "bbffb5a90866ba64d90b691d40de609a1aa5fc81": "AsyncRAT C&C",
    "bc083eda9c3a84fabf6d39237ebb7ad865540b56": "KINS C&C",
    "bc0b43606882f9b581918ca6bf5f53796aebdb86": "AsyncRAT C&C",
    "bc2a55d2bcb8c1f7ae755801d8b0709034144ece": "TorrentLocker C&C",
    "bc3e590d118dfb4690999a4733e5bff53451d123": "Gootkit C&C",
    "bc43a0946513b2250c788052222568beafec1952": "Gozi C&C",
    "bc4fe24d90e311d4538816ce6f2879c5ef228910": "AsyncRAT C&C",
    "bc532d0559006d8989d667d5421a3b7a2bd913fb": "Dridex C&C",
    "bc6ac5d00e9918d6df8a74e80426e0fcc67328c6": "Quakbot C&C",
    "bc740fb35c31872ede78dd85192de4d19b9301c8": "KINS C&C",
    "bc7ee34cc1063a835583cfc9a44ccebc9cf2f903": "Malware C&C",
    "bc97aa494fe02b5ff293ec69cbdc1a25b55e35f4": "AsyncRAT C&C",
    "bcb475ace809b2dd4c5781e212d271a16fc8c881": "AsyncRAT C&C",
    "bcb65e658a6d21d82a7d1eb1d4e4e72686a7028a": "CobaltStrike C&C",
    "bcbfc9ba9eb05536dc9224bb39502b9086bf80eb": "BitRAT C&C",
    "bcc8b2e2018ce5138879751bd00653a8c27f1c48": "Vawtrak MITM",
    "bccd88ae63c39658e7a5a3fc3511dc7bee2938c9": "Dridex C&C",
    "bcd88c50e5e610f9b21eada9892255dffc989a5e": "AsyncRAT C&C",
    "bcd95cb668a7d0f1cbd69c0821ceafbf5cc9354e": "Shifu C&C",
    "bcd9ec59159718fd3d692b3a2360db91c0bf2b38": "DCRat C&C",
    "bcdd9dbd603e10d9794443e7368467add9213f6b": "Malware C&C",
    "bce2805b28d455734ac98ab7df9791d2f22a9756": "AsyncRAT C&C",
    "bcf855796de018a63176d6920fb0b6c708363100": "Gozi C&C",
    "bd2a7ad937839a608c56606bef85e43acd094e4e": "Quakbot C&C",
    "bd397b0541a583d86f22ef8778b599674045ca5e": "RaccoonStealer C&C",
    "bd4b79f7dad6cb0c082559af025be1ef89ca6548": "KINS C&C",
    "bd74f36b99c22bc3113887c814d831cd99ac1223": "Dridex C&C",
    "bd8372816efa5a4eacbd26a125046f0886c83f35": "Gozi C&C",
    "bd98ed72327f6d3eba4ee73cd6bc52ab925a595e": "BitRAT C&C",
    "bda248fe426967f226a0ccb444935e68a1e575c4": "BitRAT C&C",
    "bda4a5997f232009c2127bc24079ebde715e91bd": "Malware C&C",
    "bda79390acda199cd462ad56941b320d30fc8e55": "Gootkit C&C",
    "bdaececb12914485a4fb2e935b24a609b97659e9": "AsyncRAT C&C",
    "bdb74ec221c2c45052d1c7b13ab921857b29c4e6": "TrickBot C&C",
    "bdbb46f512c75e53c652869a280b2d76fc1a6404": "AsyncRAT C&C",
    "bdc26ef662728ae51a14ff288c0f4bbcdba60e69": "DCRat C&C",
    "bdd352d90eb1ba49347324deb020f7154ebec18d": "TorrentLocker C&C",
    "bdd78030c894dbd5d72cd63ed8c28d55dea6dd3f": "Dridex C&C",
    "bddcc02c866592a8d7adf6d9082e1b9d53eb9a33": "QNodeService C&C",
    "bde7379c4f4597377eb09200ea4520b2e4305704": "Retefe C&C",
    "be0b4dfee0a20515a30de25b22d165a43dfbc07c": "Corebot C&C",
    "be1a584a85c879f8555d984fc36bef69db6d8ad5": "KINS C&C",
    "be1b5d9944900feb0813790bf504c70ad2ca97e8": "BitRAT C&C",
    "be1e0d976042919725594f46e7ba9145a7ab46f2": "Dridex C&C",
    "be3281a334e9e955e7d4379f57983754bd5421c2": "AsyncRAT C&C",
    "be4d4f077bdd90618367eb2ab88f9f3074ccb7aa": "AsyncRAT C&C",
    "be50d6861353bf627a02825e6db11955baa62398": "Quakbot C&C",
    "be54f000f84c6762d630cb950486718200d15186": "AsyncRAT C&C",
    "be5a2c97670327290032f120edcd0796295b5eac": "DCRat C&C",
    "be691786564d7246b3ba9563e8e9620641c363c4": "TorrentLocker C&C",
    "be741a5045c0ca95f8b78683d004e4a34562e3a9": "BazaLoader C&C",
    "be779dc495e7c16a61c5bd3b3daef5d6f484bd02": "Quakbot C&C",
    "bea64b690d3bdc2d4c00598b21d9841a83692257": "DCRat C&C",
    "bea936419e548d67a79030f40ad4beed008b1898": "Gootkit C&C",
    "beb35774f7d6294167ee03a915e79c3bb95e0acd": "Malware C&C",
    "bebb7cda0610e6204f2941c379233ac122aab973": "TrickBot C&C",
    "bec4805887edc128073c39174889368527616761": "Dridex C&C",
    "bee33d5a9b29c02938b31cf8e8ab995c4a3671e1": "Malware C&C",
    "beeb2a73ea8a829457e88ece92e56ab6bae25199": "PandaZeuS C&C",
    "bef3d68fb962f1b668e53ad7fac6282e2eb0601c": "Quakbot C&C",
    "befc88848e203fdc465c0fca03c3f6e40ee4305c": "TorrentLocker C&C",
    "bf0e7fbe28eca379529d30950f2e65905c8167f6": "AsyncRAT C&C",
    "bf1097415b976ad46e3f8c20f885fcf4829ef9fb": "ServHelper C&C",
    "bf1daf81ab7bc7a153ceef911c095edc3fbafc99": "Vawtrak C&C",
    "bf24d69a0984d084e5936b40ade129e2be40aee8": "IcedID C&C",
    "bf266326f5fc4244d45c149912df8e2954c094af": "AsyncRAT C&C",
    "bf27a5c07bf63a2e0bde908fa62f91e48c0219bf": "AsyncRAT C&C",
    "bf3b154df297a93e5d3225a5d8033e97f8794bbb": "AsyncRAT C&C",
    "bf45527acf51839e803695010dc77eca56f2cda5": "TorrentLocker C&C",
    "bf4d87aba677c15c9a34630f8baa0ede663a115b": "ServHelper C&C",
    "bf563789af160d4a32c901d83ff6b658128c0327": "BitRAT C&C",
    "bf5838a9934b995561acb7893a70127540424ca4": "Dridex C&C",
    "bf5f36fc130b9e143a4455cb823d469dd7e9a8d1": "Dridex C&C",
    "bf77fa0743ff57046ba6caf97da5a4b3d2ef1112": "TrickBot C&C",
    "bf7ade50fdefaf43e6994f8b4565ab1992da086d": "Quakbot C&C",
    "bf7ee4fafadf739f8d767c50bec5f0e471ccad3d": "IcedID C&C",
    "bf8091e124227ccae72fcf08706e31d6642e61bb": "AsyncRAT C&C",
    "bf989cf042a2b14c28c11bba564cddda9b3554e4": "Gozi C&C",
    "bfa44398aee915fcff0e2a8398700527490ec721": "CobaltStrike C&C",
    "bfa804a6558dd12bc24c464e88e7b18da838e42a": "AsyncRAT C&C",
    "bfc4118ff82166163d5a5a5b7cdd7ab13979ed32": "OrcusRAT C&C",
    "bfc78d1eb6631bf17550474ff4351b96207e98f3": "BitRAT C&C",
    "bfc8c3e02d01f0f1c3de2f761d52991a5dc45b0b": "Stealc C&C",
    "bfcf9cb6e267b06037039b5aa7cdc403bb92fac2": "Vawtrak C&C",
    "bfd580574197751ef63921b59c9a7caff14306c5": "Dridex C&C",
    "bfd7857756f519b155a1dfd61a8ab8b438a9ce95": "AsyncRAT C&C",
    "bfd9a5b9cc08ab5dbf5a5d7a6b64aa235fba51f9": "Dridex C&C",
    "c00ad85cc28f513346d9c303106ef9b0a0bed313": "AsyncRAT C&C",
    "c024ce97c0469e7275fd0ba85f6628a8e2c6064e": "DCRat C&C",
    "c034bab67b6dcb776389b7744d78ab1482de4cfb": "Dridex C&C",
    "c03ccbcc77bf65d0edfcad1fcba246e30abe5298": "DCRat C&C",
    "c03da439fc961d3c84ccc1d0c44640a0f307d05b": "VenomRAT C&C",
    "c04a0fb7bc2f61fdcec6d2ece8fdd113483a323a": "TrickBot C&C",
    "c04ba0ac4876d5548baa4bcbc27ec3d8998af048": "DCRat C&C",
    "c05d8be1bb8db73d625e77e8de0cd6254a8f0d75": "Gootkit C&C",
    "c0742fcfac0826954d1fb66f1eab22b391b17590": "AsyncRAT C&C",
    "c09100e7c409e1e5d9a2b4ab9d20704b6a3f2932": "AsyncRAT C&C",
    "c09ae48dfdb986cbc34a096d3eb368e0ae4cd521": "KINS MITM",
    "c09d8b14f192fc4ec91ce94aff7c1d52f81fa555": "Quakbot C&C",
    "c0a4842590f506b2bde42660680876dbf1073b17": "Gootkit C&C",
    "c0b06ecee5d1acb1a7f7b07f9ea7503c9ea5f4af": "Dridex C&C",
    "c0c144eaafe32391891e1ed1270bdac6cd0ff1ab": "Malware C&C",
    "c0c5629b2a906a67b056617c0158b0fcb1dc3ad7": "Dridex C&C",
    "c0cd4f71a9c1920aa4d2d0711fd555be1e1bde8c": "QuasarRAT C&C",
    "c0d8ce575c6797356517d8491a83d3061db6323b": "Dridex C&C",
    "c0dc9ca0bf92bd069ea1285435bcc4cc7bb4557e": "BuerLoader C&C",
    "c0dcf44191f4e4100ba53e970a0b2f9dc5265b53": "Dridex C&C",
    "c0fdb6f6f869ec6922de639c586b6cea95dc9edb": "PandaZeuS C&C",
    "c101c26500f63abcd49eb5573c2aea1cdaedff8e": "Dridex C&C",
    "c10baaa40751e2d2c547ae627fee7a6030e84015": "BazaLoader C&C",
    "c1160eb972662be97e30ba2c41ff3c0f81752c59": "BitRAT C&C",
    "c119d08b5135fe421d5d562b84243abb13911efb": "Quakbot C&C",
    "c11a6e5081bc8d13c9483db2af04f52882ec1bf0": "RaccoonStealer C&C",
    "c11e5e7755f24522120cd6e6d31795cf6a79a319": "BitRAT C&C",
    "c12420badce59d7a6f50e5c15487e1f724b36845": "AsyncRAT C&C",
    "c12ec7ea7046337031ee6a1777f79dba2198def6": "QuantLoader C&C",
    "c1383e781ea183075ae977f6fdb84caf7e20226e": "Gozi C&C",
    "c1389159e5e3e954d9d71b13e3c5d4d85c46cde8": "AsyncRAT C&C",
    "c13f38a385f237978e7793ae928b45bae5c93d58": "Vawtrak C&C",
    "c14fe834a2e4cdb43cf5c92ea48d4d84487eea5b": "Dridex C&C",
    "c1589ef424f77018cd488e8307c8c1df199c8a42": "QuasarRAT C&C",
    "c16644ae155453011f36dd3f4c459cb3b2ee8ce7": "AsyncRAT C&C",
    "c1770cbe6b232f7e281c4805a57600fed3c9ea02": "Dridex C&C",
    "c17c2bb738627e819e9339f57e8b98967e09f3cb": "Gozi C&C",
    "c188e52374bb089b9cdcff20dd9ff253c370ff93": "AsyncRAT C&C",
    "c19504c30758138303316016c1f7c8fd71c146ea": "Dridex C&C",
    "c19c48ca9bbd9d98c31d30f8319ea2b8f495fada": "Dridex C&C",
    "c19fd8ca51fc948163f72f214636dd92a42dd7b2": "IcedID C&C",
    "c1a1e871a086a31233a17d24ae4cfd89fa7618ef": "KINS C&C",
    "c1b17774c16cd6179a6c49d1f5b6f17a2b08e3ed": "Gootkit C&C",
    "c1bda1ea8c1f4f9ead798d7495a898b3d447a771": "Malware C&C",
    "c1bf18394086da31afaa5a470e02f362ac31ade6": "AsyncRAT C&C",
    "c1cd0d73ac78051821a3d82c4a1c816d57f0909d": "OrcusRAT C&C",
    "c1ce35ab005171c246edede1d3d06a1be0254ee1": "Quakbot C&C",
    "c1ceb84de2d505eb7488dece1286e417a88b016a": "Dridex C&C",
    "c1d7912b6a176b02a9c7de1e94a5ea36794e7b20": "IcedID C&C",
    "c1d9ae76427eaecdc523126a1e2d20335922b154": "KINS C&C",
    "c1ec4f82e7f198c4fdd4009d6806644d01f2f810": "Quakbot C&C",
    "c1f1a26e4d7e2afe19c690a081328989de440fc6": "CobaltStrike C&C",
    "c1f87bec7cd36db02855527a8b47555425c1504e": "Gozi C&C",
    "c21a0755878a55f9407a364d21014fe899f21770": "KINS C&C",
    "c220d20495403225aabacb660587e25551839eef": "TorrentLocker C&C",
    "c228176169b8c5836fb63ab14417ad468bbddc26": "OrcusRAT C&C",
    "c22c7c48e700c93674c141fc0136a7823bd04f16": "Gozi C&C",
    "c23155e71534ff5b1dcb09a5979147ee7fea1461": "KINS C&C",
    "c238c622ca6e48cef9ebabe408674f31db7f79b9": "Gozi C&C",
    "c23cd8be625811441c681d84dc70ea0f5ca7e42f": "AsyncRAT C&C",
    "c26e2c33fff65721eddea5e632ce124e9e7129b2": "TorrentLocker C&C",
    "c2788a698b49cef3e09a14d74bb1b78fb1a45f47": "Havoc C&C",
    "c27ac6f1cfc1545928ecbdfffa696de3c27a42af": "AsyncRAT C&C",
    "c27b5bb9723e3477488d604bc3906f9d78f2d701": "Gozi C&C",
    "c27d1314aadf966164c555fb05d7875bdb71f003": "ServHelper C&C",
    "c2ad5eeb248e3b79e1c9d6baab07cf9daac5ae6c": "PureLogStealer C&C",
    "c2b5eee7fb4c99ba03371e83ee3f3a27998ebe23": "Vidar C&C",
    "c2b6704d1a2d2f349844fe10c38262114b879473": "AsyncRAT C&C",
    "c2cac9c1c64587be0f10b1d290eced1e2515b2af": "IcedID C&C",
    "c2da79a6fe703ce96ce63f6446f89e299f998494": "Dridex C&C",
    "c2e2a68f941b001c06ba8a8491de73d2e20d96e9": "DCRat C&C",
    "c306f567cd3deb0d8cf493f1b3e147b91f2ebef3": "Gootkit C&C",
    "c3074b662543f3041adb04bfe01f4a088d498698": "AsyncRAT C&C",
    "c309eb88fed49b932554885279b9aa05719ccd61": "PandaZeuS C&C",
    "c30bf68aff79898cb19ee744dfb0079514482782": "PandaZeuS C&C",
    "c3119e049e972072675bcc408c496633a60f305d": "Dridex C&C",
    "c324abf6a66cb9d20ffcad124a9d9b9f405c8e82": "AsyncRAT C&C",
    "c32bcf0d53cb6f62725f3b8e1e7ec9e3da5bdd5e": "Metasploit C&C",
    "c33b19da4e4376b2fba6ae0107c96957e220b0f2": "AsyncRAT C&C",
    "c33c0dd2e115cc7a8abb3a0669954f0001a85973": "QNodeService C&C",
    "c3473f7c3923a533025f20688369d9f663283594": "AsyncRAT C&C",
    "c349300f2038a5321fbdf57a25a4361aafe81e42": "AsyncRAT C&C",
    "c35369c318213bdca2d6b3d76b23516477544954": "QuasarRAT C&C",
    "c3551c597372249225c36b6984f248bba1cbe513": "Matanbuchus C&C",
    "c35ad069ff08727c688b65874e8815091d616cd9": "Gozi malware distribution",
    "c363f30af6021c5bf33e31b6ef4f8329b6cd0868": "Malware C&C",
    "c3654a252b2d2fa4acaf8a59295021d3884bf8ab": "OrcusRAT C&C",
    "c36a687d6a5dd29262744a152acb4d073203f389": "Gozi C&C",
    "c390e62881f25347c39cde51024a9c687d49675f": "QuasarRAT C&C",
    "c3acadb5007c3b5a7109a9d36efed3ccec73f345": "AsyncRAT C&C",
    "c3af8b87c2ea470ee8711891919523a2b3635e1d": "AsyncRAT C&C",
    "c3c4d615600ada76d590859671d2f226a9a95fde": "CryptoWall C&C",
    "c3c4ea891b58699e241eab46a984bbdeb3ce7037": "Malware C&C",
    "c3ca0b70d91ed84baa00bc596a7d64b88d71e92e": "TorrentLocker C&C",
    "c3d4aef8809519b14077adb70f7b520b8533d569": "Vawtrak C&C",
    "c3de7af62db8a15473eb12eb5f4f716100050469": "TorrentLocker C&C",
    "c3e17edee4986cb63bbed85720c94e0fa2841011": "Gootkit C&C",
    "c3ebdeb683097cd94ac53de97e1580f89a1d5b52": "AsyncRAT C&C",
    "c3f49c54cf574b9dc3e9763e8585003da031b6bf": "AsyncRAT C&C",
    "c3f745af14b0fe220254f372600c32367ad4eab8": "Gootkit C&C",
    "c40c61c5ea7bcea51239592224428d5ae72d6b8c": "TrickBot C&C",
    "c413dec0d85e70ab16f697219de0008af581ed92": "AsyncRAT C&C",
    "c41f277c6495b299ae1bd028a0a57fc17b6042de": "Dridex C&C",
    "c426793f8b0433559e10396d3769e4c206cf10d3": "Gootkit C&C",
    "c42d2a84cbf79b6c091f01e338e514112c2bfa0b": "Qadars C&C",
    "c4393cc437ac79b206f8301595bab5689b415752": "AsyncRAT C&C",
    "c45b954b517bc6c7544f013defa51d41cf0f5fb5": "BitRAT C&C",
    "c468c4fc3077d3c512ede9040bc60ab2adb318d8": "Qadars C&C",
    "c46fa929a34024cb6749417ad8ac3540f32d1aa8": "zgRAT C&C",
    "c47755a7e2882793d7abd6f7f057c5b57169fbc5": "Gootkit C&C",
    "c47a9341572d059d6427d24df965267a012bd9b7": "TrickBot C&C",
    "c47edb0055a4159e456837b53cc20f727a7322e1": "AsyncRAT C&C",
    "c48edeba9a63b131461649d20fe65a784a5a3fad": "Quakbot C&C",
    "c4941b3a4ae90ab293a77877ff7618b50c9f1196": "TorrentLocker C&C",
    "c4bceff55f713b0e1add1d61df69b0eafb56bb93": "AsyncRAT C&C",
    "c4c785aea2c1dfaab844c44f22a71e9c65296e79": "OrcusRAT C&C",
    "c4c9e808a53b52d8c4c02fef5bf78033bd95301c": "DCRat C&C",
    "c4cb7f0d4f658f71c3b132f2730659da60daaeac": "Quakbot C&C",
    "c4cc25a2889256b8eca16d4c3442175dc184cd43": "Qadars C&C",
    "c4d608de17a85769eda8b3aeb3adea6a58f21107": "Gootkit C&C",
    "c4de336516ff8555ebf59d5af58739fe96f2defa": "AsyncRAT C&C",
    "c4fe0be35ad3cc041650e8dc975704eeebb9eccf": "OrcusRAT C&C",
    "c5036f5e25b19c8d376e175283500bbce4a4d19a": "Dridex C&C",
    "c510e8debbf95855be7c5decebac2a8c3b0b2bcd": "AsyncRAT C&C",
    "c516d44f192c7e729ff93155f357cc582cf3b57b": "Dridex C&C",
    "c5263361ea096498cf9dc63b8a967c9e2692470b": "Gozi C&C",
    "c52be0b193a41a39508ba9c106222d7998d4369d": "AsyncRAT C&C",
    "c531068ce6275aa311475bf9ba54897f03db3498": "Dridex C&C",
    "c535afd24374e03f739d081d0d3cf9da42d583ba": "Shylock C&C",
    "c538f6669280c684961171a7604f318257dbe789": "Quakbot C&C",
    "c53dfce63ec4c1bcd446196ff3639afee93da024": "Dridex C&C",
    "c54c9f727f72c5549c6e6ad5b6536ae5c13eebe1": "ZLoader C&C",
    "c580ef00d7f1b85895afbbe0789461dd27f590c1": "AsyncRAT C&C",
    "c586f46135098d38ae9019b12d83ac9501dbee34": "PureLogStealer C&C",
    "c58a93feaa2e7c7529593c8f5c07af04e94abeef": "CobaltStrike C&C",
    "c58cff5d7de762b5f13b6da34413bd82b52e20ce": "AsyncRAT C&C",
    "c5a5625b3ed733f2f4fa83b739f156a042c72566": "OrcusRAT C&C",
    "c5a7344fb50bdd8d71a7a395e91d110e423ded0e": "BitRAT C&C",
    "c5af4dadd46507731bd89095873125b0ab0eb269": "AsyncRAT C&C",
    "c5bdbf8676e3c45e1a810577012abfa6102b169b": "AsyncRAT C&C",
    "c5eb474d4049481f5478dbadb45caf66e95fc442": "AsyncRAT C&C",
    "c6073630d49a7e3a5c45acade6e50ee5a1571944": "Malware C&C",
    "c611655c84ac0749bd8105ea3dec1f4cdf148fb5": "TorrentLocker C&C",
    "c618bbb668fbc1d83eb7d5b7aec7c6d6957b2f16": "KINS C&C",
    "c6317f341b090801e02d8153c90bab22c66da9fc": "Dridex C&C",
    "c63321c0e720ce0052ab08cd5c393a5de7caceda": "TorrentLocker C&C",
    "c639fc88cd675f76e6c29e36d2147cee31553238": "QuasarRAT C&C",
    "c63bf7dfeb127b49ada2b5c8780f3ae3b99cc18e": "AsyncRAT C&C",
    "c63e9e0ae6755777d4904e1d8ddf146ceb8373f8": "QuasarRAT C&C",
    "c65e76a5547c16417f36a2f9127b196ecd86a8ac": "Quakbot C&C",
    "c6724845350b1745f02d1430a5d27578a44a9e19": "DanaBot C&C",
    "c6a2aa37631e9e64ef711a48008c8f00e33d26fc": "AsyncRAT C&C",
    "c6a83da05c0ad8d2f28498b072d67a1a4e439b0b": "QuasarRAT C&C",
    "c6ca3a3e4986b9d5d3fa36c1b856e7f605d40509": "AsyncRAT C&C",
    "c6cc6770b261de7dcf480229e14261fcc9a4551c": "AsyncRAT C&C",
    "c6cf08845203a4b1fda667d3410ab43b9e368526": "CobaltStrike C&C",
    "c6dadfc9593f2d6812ac406212155e52f35d8327": "AsyncRAT C&C",
    "c6e23ba70e45ce89d8440b15de0bc14e55c6817f": "OrcusRAT C&C",
    "c6e422fd5f599ece5d0ed65112005bf21892ca16": "Cobalt C&C",
    "c6f8289477fb6480f58594eb1d84096994fad6ee": "Shylock C&C",
    "c6fe0fe2ae5063b3ff96b243ca9b46c9a92f0f27": "AsyncRAT C&C",
    "c6fe66a34a6fc3411ba76af8010eebd53bf5034f": "Adwind C&C",
    "c7018ce8cab9277d6149d218d23c9f81709133da": "IcedID C&C",
    "c701fa6cfebc577a6c20f7745c85a9938507b8a3": "TorrentLocker C&C",
    "c70950e538746d42cb1d5ebca381a0137be58b29": "AsyncRAT C&C",
    "c70e2a54f2e0023666b95f675015413aa58e58f2": "KINS C&C",
    "c70fa50f27aeefeb9d92927562101445c8ffe461": "Vidar C&C",
    "c716756738aafa0129431e69f673abca2b140975": "Gootkit C&C",
    "c7169e67473f6feed0c1fc482107e083125d2dad": "Dridex C&C",
    "c71ae23d0c0223a2b2228bfe8c9e0bc75157086a": "KINS C&C",
    "c723b660999de42fbe72b040a4dd489e462a6407": "Dridex C&C",
    "c73440bdea2bf8eb4c3c4a3aa95ed39e4fe1c8fa": "Gozi C&C",
    "c73788bc59b4f3659e796b94c2f22a0ed092e915": "RaccoonStealer C&C",
    "c738430d1f0c75a1481d4a8f282c129054c0df4f": "AsyncRAT C&C",
    "c739152c6f052820444b2c84443048d8d36d862a": "Dridex C&C",
    "c73e040ca80d692831798bd149e5a51d050dd9ab": "AsyncRAT C&C",
    "c7460a72f88611c1fcd7f4d6938cda80c94f9c71": "Dridex C&C",
    "c75ecf9ecc51bed868450fa6d00bc66135800c9d": "TrickBot C&C",
    "c76d4a349383506251ffd9002146d2a38217bacd": "Dridex C&C",
    "c77cc49c342e463cd6489c765fcaef0b22773f96": "TrickBot C&C",
    "c79d5ee80e79058e35ca9dae7752fe407d60f8c6": "Dridex C&C",
    "c7a8be1fb471f0a1ed8572a10d211801c3327add": "OrcusRAT C&C",
    "c7f6c02c8808f6e49b4fd1f4b0fc08ede61e5ded": "Dridex C&C",
    "c80b6fdfa7cc4526713cdfde78c4fac3855a485a": "DCRat C&C",
    "c83cf22f6324af29aa622ce1a3da4eb23af1bd2f": "TorrentLocker C&C",
    "c8401f25322f6607e5bc122cdece95c2ccb8157b": "Ransomware C&C",
    "c841e471e9c0c2761f5ed51fe8aec2d6b08ea871": "Gozi C&C",
    "c8432be3add81d083b3eaf67235ebe546de9d7b7": "BazaLoader C&C",
    "c84cb6134701741c5122a14facdb67c8cfa9c0ab": "QuasarRAT C&C",
    "c84ce8c44bb659eda3114a0ce7b5f54c7d868cff": "Trickbot C&C",
    "c854ce955879abd278695aa3723aa5b8b36f0e59": "Gootkit C&C",
    "c8557c6419a869ab7ab27e50a09354dda887f4d6": "TorrentLocker C&C",
    "c857168c8662ce35630661a7dcb4c962be03d06b": "AsyncRAT C&C",
    "c864633bd7c432ff8ab87b5cb1a3b33ca8629926": "Malware C&C",
    "c8686582d7f64b076aa5280daddac5610e11fb22": "RaccoonStealer C&C",
    "c86e4f26df15861614ca9bd4736cb9ad29c4b647": "Qadars C&C",
    "c8726c6d97d5d4aec5b918a742062172b68cbc3a": "OrcusRAT C&C",
    "c87588873a0bf887e6abd0262057e8d1b074889a": "BitRAT C&C",
    "c87eeb707575e5238d7773102df173072abbbf0b": "KINS C&C",
    "c88092cf532a46b3c9fabdff6361f8a338b7d292": "TrickBot C&C",
    "c892276273a62acbdff9f6ce6885d09f4f95c944": "OrcusRAT C&C",
    "c8a237c907b33ee1e3431c45d3abdd76f96f8e43": "PandaZeuS C&C",
    "c8a58bf56c233bf176b82e1a12e676a97e85133f": "BitRAT C&C",
    "c8b9effa43d9ed325c7b2a2a24db7a1314e43b2d": "AsyncRAT C&C",
    "c8ba3c1b9dae95396378007f1bb556379c1a1afa": "AsyncRAT C&C",
    "c8bfc445d133d9c3a6e4606f105e0dd8b19948a3": "Gootkit C&C",
    "c8bfd012db4b42d492f03e53d34f6e70bfc0e813": "QuasarRAT C&C",
    "c8c768bed2573285257eb409279cf3d7393a8a51": "Quakbot C&C",
    "c8d9fcad7eebb3a7a9fab97478b19934bb98bdfa": "Dridex C&C",
    "c8e67f6165a563148ed01693a866d2eae1290d7b": "TrickBot C&C",
    "c8eeba31451738184ef80939aa8f0b12bb90f784": "PandaZeuS C&C",
    "c8f280d012f339a992092a3cba7298861f7b1148": "Dridex C&C",
    "c90401a468bdfad20cd6166d9111f7b9ed3f1b9d": "AsyncRAT C&C",
    "c906ecac4e49b4465529d39edaeee8f16d014db9": "AsyncRAT C&C",
    "c90b3cd4d517db4ade4f65bbe35b0e1da151856a": "Dridex C&C",
    "c912ab3c45a9bc88da39876113e6375d8f4bb902": "Gozi C&C",
    "c922417e8cbcfe6a824675a8e2ede1c8e2052a8b": "TorrentLocker C&C",
    "c9253e410b5ee3a33d7e1c0e854b1aeea42df7fe": "PandaZeuS C&C",
    "c925a946d3b60d09cc81c46e31e9e5dc0021f504": "QuasarRAT C&C",
    "c9267f47e443b130d6ace16cfc61e75b1102eaeb": "KINS C&C",
    "c92ac9797c30f788cd4b280ed5e0cf74e930603a": "Gozi C&C",
    "c92df6e1c9588dd96796b11c0cc80279631bbba8": "Malware C&C",
    "c950c17e663216d5175fa1c3f56a4a5c46c10152": "DCRat C&C",
    "c961350e68e14d3f1bbb77833cb876669d3d7f2a": "DCRat C&C",
    "c97256ba1423b9dd724a89bdc8dc4b8a882f54e7": "Gozi C&C",
    "c974f1b02b4317637aad55c6ce33e1b8de2520c5": "TorrentLocker C&C",
    "c987fc2473d3df2f6d61094515653be8a5c75441": "DCRat C&C",
    "c993d881edee5ad2ebbfe4585d3b39a39d3efe60": "CobaltStrike C&C",
    "c99edefe6bbd8bf189a0476e6b8aaa28241705c1": "AsyncRAT C&C",
    "c99f54bb51361c0f225e6f853210557d532cc909": "AsyncRAT C&C",
    "c9a6345f69103f14a9c40cbfcf9480bd1c7a05b5": "Quakbot C&C",
    "c9ad5cd2877f354f75d5d42b564caba80f705e7d": "KINS C&C",
    "c9ae758fef9766146db0c0dc54f11ddb223daacf": "AsyncRAT C&C",
    "c9b097d62d6f7b365f88fcec1da94ded5ed9321f": "KINS C&C",
    "c9b271daa17b9be4f493348b2e08a1fe4eaadbac": "AsyncRAT C&C",
    "c9bc046b617dd0f608706b9640c8d97c327969fb": "QuasarRAT C&C",
    "c9beddd9e861e801f9dba536d6642b0335fa9ae2": "Malware C&C",
    "c9c963ce2af615137c5b07e122968e9595b77d58": "Dridex C&C",
    "c9d1dc292a4852cdb99ce02b3cb7539d84c320e5": "BitRAT C&C",
    "c9d525da0eaef56f12a9ea04ddf6f8529659c2f5": "AsyncRAT C&C",
    "c9d813179ce2afbcff6f734887c4ff6be0335e0a": "Quakbot C&C",
    "c9fd94b3c7ce91577094bf0e4661d229697c29e4": "AsyncRAT C&C",
    "ca0a1f12325ff7ac080bcc1a739866245d723090": "QuasarRAT C&C",
    "ca17e70b7290445d049d9f538976e4fad8f872a0": "Quakbot C&C",
    "ca2b303ee7383e1dd7125d3a42b93ed386eeab4a": "Malware C&C",
    "ca2e435bb8836081ffa61c902db05a4e0e11c78f": "Vawtrak MITM",
    "ca31e1cf30441ba122734451f744c967151e523b": "Dridex C&C",
    "ca3d33bae17617a6d1a3b6fddafd36222f3c67c9": "Vidar C&C",
    "ca3fd51c5633ff7c543fab2f6fc39218b2e02db7": "AsyncRAT C&C",
    "ca446ef01f7139169b6fefce44d94b0234df20e0": "BitRAT C&C",
    "ca5eb0930dac1a7bb0d2058cebb3133bd0110244": "Quakbot C&C",
    "ca7d35ea0a3e63564007f8003ee113a2d61db61d": "Dridex C&C",
    "ca7e77938cb8ca7c09fa524137d5042d6f83e21a": "Quakbot C&C",
    "ca826aaeef5b9845febb18ca4505253b127695b7": "KINS C&C",
    "ca9652069f676b140195382dde3dac88510b7623": "QuasarRAT C&C",
    "ca999c30d1d488a4c0f9cf50b28d4203d5beef0c": "AsyncRAT C&C",
    "ca99d2b2f9bf4d45083ff8783f5589324755104f": "VMZeuS C&C",
    "ca9d3739efa575e4271a47ce7f12b73251d61a21": "Malware C&C",
    "ca9e2eb07d8f756a97741f129411de939f1c67e1": "Gootkit C&C",
    "caa30ad08bfebfe96bb86622aca43201ba539de1": "PandaZeuS C&C",
    "caa4746705d7823a39b0ffa707ee6dec2af4d3d5": "Quakbot C&C",
    "caa6f00aab2138224c991ad44c941039b9f99cc8": "VenomRAT C&C",
    "cac6218fd68183c95a65c89ee7d0b94747d7faa8": "BitRAT C&C",
    "cad232bbfe05d3e9a112e3a053f390f0b4fc0d41": "ServHelper C&C",
    "cade0ed9c0b09a241694f93ee51b6facbc671230": "Dridex C&C",
    "cae1542c5d83cd78163d00969168080325d4ac4f": "Gootkit C&C",
    "caf13f64b47f523d8d319afa2b55d9d632fe6f13": "RedLineStealer C&C",
    "caf3c89b047e8073acc4962ff6a59fd8db7c868e": "BuerLoader C&C",
    "cafb354de95a9a7253e0cdfe8078e24d8f73a167": "KINS C&C",
    "cb03d45fc2366a1cc4b566e3e0bb290840b946f8": "Dridex C&C",
    "cb06cd0cdd50db37647e444a9a092ffc3a298e95": "PandaZeuS C&C",
    "cb18cf0f6c6419a0199cec929479ae34d5423f6d": "Dridex C&C",
    "cb1ebcb2684b2c127f67319b1117ae39e765b1b7": "AsyncRAT C&C",
    "cb3fa6679f3dff6374480c12f092df6799ccc9cb": "DCRat C&C",
    "cb41bd862488f47caa7b74d20254242c6549bf29": "DCRat C&C",
    "cb660b8e58fa3e8b85f7a475f37fb37a3e072e4f": "PandaZeuS C&C",
    "cb761e890e7494afd051f9761e7acf4b553969b3": "TorrentLocker C&C",
    "cb7857c2fed43e6a8bb248c07fa03d9191ce4467": "AsyncRAT C&C",
    "cb7efc25c971bc44a568af3d6651d8a224439f62": "Dridex C&C",
    "cb863c3128dba445f9589d70c79cb6a91a65880c": "QuasarRAT C&C",
    "cb9097e27d1c16ff6d0574c2cce0fc0d066f0f8d": "Gozi C&C",
    "cb98d0d2481b3ac3e4f9de53eb7f86cdd08e8da2": "Shylock C&C",
    "cbcf9e269d6035128c953604109713b91e507a91": "KINS C&C",
    "cbdf14076162a9156ec3d4981ad6c25fb2c2b2e3": "Arechclient2 C&C",
    "cbf68e899c14cdbed25b20d398ce6724d60de0a6": "KINS C&C",
    "cbfa1596b18db557d3f1a72d0a4f67eb94cb98f7": "KINS C&C",
    "cbfb79def9bbd76d3e06eb11c133d7a74f93b707": "IcedID C&C",
    "cc09f35423a1c108c992854fab1fb77f44755782": "TorrentLocker C&C",
    "cc1c9fc84201246c7150de88f65a0d6f14cc2a78": "TorrentLocker C&C",
    "cc2a6dc9acf43d86a21e8bf41ff895278be3aedc": "Quakbot C&C",
    "cc2a8e3f3fcf0d5262f5fb0ef2477329c6382733": "QuasarRAT C&C",
    "cc63ce7602e3918cd01c8c3dc27508026b3d1bb5": "AsyncRAT C&C",
    "cc76f1957e9eaaf201d6f153c9f5a862b17b9216": "Dridex C&C",
    "cc908637d13e34a8b9742523413968d9172350bd": "KINS C&C",
    "cca0288edd2e6e2d7a15e22e31adfbab698eab71": "Dridex C&C",
    "ccc059dd4706d432cc5600e8ed0a787b79c10b25": "QNodeService C&C",
    "ccc17ae2628354e54e4f3925b4832673f535afb8": "DCRat C&C",
    "ccf9263de3eb09b908c791bab10ac1f738c0d9e8": "Dridex C&C",
    "cd08b5571bd2d5cbdab97f00e5ee8d64c6d5d6c4": "Dridex C&C",
    "cd1469268438c0175a742767877ecf77046e1d49": "BitRAT C&C",
    "cd2506a1932fccb6721bec437b6f22849c392859": "RaccoonStealer C&C",
    "cd256efac6809f14bb84c390a89819c0822c24a2": "Quakbot C&C",
    "cd28723c9b4621e61d4efc60b3fe28f670d1cc4e": "AsyncRAT C&C",
    "cd3067c8b66b09fe55df192462291203fd87c9cd": "AsyncRAT C&C",
    "cd3b43da614f64319bbab871b5e9badac265f9a6": "Gootkit C&C",
    "cd47a91bba81a0f01b992070ceb7001b5a90dfb0": "Gozi C&C",
    "cd48bd25003a233387c6a3991d9474dad364ca9a": "Dridex C&C",
    "cd56f2d65689a9b3c5d1ea718018c4d914c2ced3": "Gozi C&C",
    "cd6fef4f948365722aff07eb62f7b74a849a9b86": "OrcusRAT C&C",
    "cd78c18b97454e693f41c3e9704cb8428833054f": "ServHelper C&C",
    "cd88cc0a598699a781864bdef18f50dab06f818d": "Gozi C&C",
    "cd927a05cfcb7be32752ebc022b66e67b7da69df": "CobaltStrike C&C",
    "cda6ebfeea003dd90d79ab6b341eed2569439c2d": "PandaZeuS C&C",
    "cdb0cd3b9ba771e95c696437253c260479dc4cd3": "Gozi C&C",
    "cdb548cade0afb9d70daa7fac43a51fd23048540": "Corebot C&C",
    "cdbc8bc2e963ee6ce518e06a9242a54a2819eb7f": "KINS C&C",
    "cde944a00bde38bda5aeca3a026a3ef8484b5c65": "AsyncRAT C&C",
    "cdf92c96bb32e9b1b78bc5726662a12a9be6a9f4": "AsyncRAT C&C",
    "ce17fdb620ce334514282bf3abd56aec1682cbc0": "AsyncRAT C&C",
    "ce1c1a0e53d310d7fce4ba516ccd9b11cc4dfd08": "IcedID C&C",
    "ce270bde797d938596efd74f983461f62bf04069": "Malware C&C",
    "ce28892401cc4517a5305717a7495d4b2da8cdce": "AsyncRAT C&C",
    "ce30b00cf259d1f5e527918953d19e7d6560e5fa": "IcedID C&C",
    "ce30fa24a8f2e269649743641663613158b63aa6": "TrickBot C&C",
    "ce31c707fe042fff0dcb553eaf27039f1cddb7e6": "Dridex C&C",
    "ce429e13e7767d9bd5c6a1d4a808161c2636f720": "AsyncRAT C&C",
    "ce5298b9c6a5d2197c0c24af2ff9fd0e711790de": "PandaZeuS C&C",
    "ce530a62a9e43e8921db1329fa63dad176d1f5ff": "AsyncRAT C&C",
    "ce672e4f9947e5d5b7c9ca3fa838bcd6e51ffcf2": "BitRAT C&C",
    "ce67e9a7900f427492cdfe09a14dbd20a52d1765": "Dridex C&C",
    "ce6c4661f7043dbf0f9af5b8b5ff0a8edd743555": "Quakbot C&C",
    "ce75308787706e09e3bdc190b99df49ba8d7f59b": "QNodeService C&C",
    "ce7c5b4a2607c48a1e3428ce45582aba1da21812": "Gootkit C&C",
    "ce7d80d42f2179be220a6d3ac343386919d9ba8b": "DCRat C&C",
    "ce7fabbc4394511cf9be45d776d2c944a709b53e": "Gozi C&C",
    "ce8365cff99b4309666a661af59550be8ca07f8a": "Quakbot C&C",
    "ce85d4f2814f41468c99e4c4bfc7a1a8a9a45dd1": "BitRAT C&C",
    "ce8a339e031b961686958a645e4b4766fb5c621d": "BitRAT C&C",
    "ce8cbfffa197754007ef657a51a2f4039fac5f03": "Quakbot C&C",
    "ce9d5068446a3372a70abe8ebd0d7f0cbc814b08": "QuasarRAT C&C",
    "ce9e4d1c207a26c4c0bd4c7583aeb622a9c2c1e9": "Dridex C&C",
    "ceadcbb8ab06ce4e237592495d2b669ce7b25cfa": "Malware C&C",
    "ceb8616d116b0bcfeefc3a1b15dde6e004f8cc1a": "Dridex C&C",
    "cebca390cdbc05a7a9d3dcd88dcc871f3e97b853": "Malware C&C",
    "cec3a8ffa861ca556fcc590472acb8c80465b0f5": "Dridex C&C",
    "cec8efab6c0d767ffdc8de9fdaa550eaa79c4596": "TA505 C&C",
    "cecef405ec05435fa3b0637b4744084968cf26b4": "AsyncRAT C&C",
    "cee8ba23db82bc5f4c18830943aa57a5a45b3da2": "ServHelper C&C",
    "ceeff1605454fad064683335f9e90f696021f331": "ServHelper C&C",
    "cef4c2038101231156b0593fe20a40e313275a07": "Dridex C&C",
    "cf03053bb79f2256153b17314d58724a07f133b1": "AsyncRAT C&C",
    "cf08e3035ac6324301b3211ce62e8783e70755c1": "AsyncRAT C&C",
    "cf200a4ecc0953059bcb2797cc70fad6e4b7f818": "Dridex C&C",
    "cf27cce53a520081d05ca4dc28a8990b74f60380": "TorrentLocker C&C",
    "cf29b6fdffe3315e8b60b65d5e20daecc2a070a4": "Qadars C&C",
    "cf2b014938c36b30f7d57708003ed5e67aaef0e4": "PandaZeuS C&C",
    "cf31d2f8e419d76517b0bc6c3ead1f246b950a42": "TrickBot C&C",
    "cf3304bd321b3b209df07878f24d528c5f1b5557": "IcedID C&C",
    "cf38656e149dda84cfcb94f3b35034e418ba7fe6": "Gozi C&C",
    "cf3bee45f87827fa2c5ddbc50987ac6a5e5aba6c": "OrcusRAT C&C",
    "cf44b575fe4069badd8f1e8a1355cde6f99461a5": "ServHelper C&C",
    "cf59bc1848f3fcbef9e218560acc7668346ccca9": "DCRat C&C",
    "cf5d04ddec07a64ae92454cb4e881f1d94b23050": "DCRat C&C",
    "cf5f9a814a7f14a8692513458a98c08626db3134": "TrickBot C&C",
    "cf6571b192560b2733a9038db2e1bbaa5b1a77f3": "KINS C&C",
    "cf66ea3b6088b8100b699e316f84cd7de7fc76ab": "Gootkit C&C",
    "cf6e3a44ecf9d531e69e4a7955d6d2847585c001": "DCRat C&C",
    "cf7a4a2221b03ec1e60496223b8c85ce32abede6": "Gootkit C&C",
    "cf7dc0ae08ac82cac30afcc9a766d7b47ab8abfe": "KINS C&C",
    "cf85ecc687129c2f1014334b36134d878fdc1a18": "AsyncRAT C&C",
    "cf9ab362350c235bb290250f9a6233ac12729ab2": "Dridex C&C",
    "cf9c47c1b2a03a618c09b7f9a20f32ef3b0d8337": "Dridex C&C",
    "cfab4ce6f2259d74e8aa41e30ec7e1ce983f9a17": "Gootkit C&C",
    "cfb171e903186d969dc28750bbf777c4ee4861f6": "Gootkit C&C",
    "cfb4f4ca022c9b6355a56391e851519d74d8996a": "QuasarRAT C&C",
    "cfb7bd1b086619a1fa1b3b68b9883a3b75d010b2": "Dridex C&C",
    "cfb7dd20e4ab3b30e2b219b650947d87724b101d": "AsyncRAT C&C",
    "cfb86f7a5edc30cbceefcf572d8912e18eebc583": "Dridex C&C",
    "cfba3a230f38b1ce2c0f6c84854fb1f1dbe74d46": "Gozi C&C",
    "cfbb8665d52d17bf981767107e43905ebde5d785": "Quakbot C&C",
    "cfbe77d1659d1aaea28f212b68702e333ea26bb2": "AsyncRAT C&C",
    "cfbfa6724515b3829cc78435918094c86d608429": "AZORult C&C",
    "cfcd0759e20f29c399c9d4210be614e4e020bee8": "QuasarRAT C&C",
    "cfd109e48fa5464e66594388dc81092eee671a59": "TorrentLocker C&C",
    "cfd8c3f0068bd5b81880f38ebe1ba62539b746b9": "BazaLoader C&C",
    "cfe3e4d2cedfc5b02b327a3c7d57e097802ce2d5": "AsyncRAT C&C",
    "cfe913a8fbaa2eacc1e79aa6583c8462c25ffda1": "AsyncRAT C&C",
    "cffb49208d80e651992f22665a06e8fcf985ab82": "TrickBot C&C",
    "d00b963737a779fffdea3be7804d213f8b77b7b4": "AsyncRAT C&C",
    "d01a12dbffefc6c94a3b3364ab1aee9ab1d9b598": "TorrentLocker C&C",
    "d02bde779e853c84617fac740bcd47659af2f375": "Gozi C&C",
    "d0340217c2968245ee46d0997794b70912f2c51a": "Dridex C&C",
    "d0351b59fdd6e82b260780f2b60c156e25303fa4": "PandaZeuS C&C",
    "d05e2e91f57561106cb08383e6996ea72ad9a035": "Malware C&C",
    "d067d998eea247d924f0cbb530ce87a056ff5933": "TorrentLocker C&C",
    "d0689173fe154fce3a6bff9264839cf6c5b91742": "Chthonic C&C",
    "d094bcae1eff3b8af47811ee28dc2fd867763966": "BitRAT C&C",
    "d09e0dc756b743efa04f1061737afce19fa3e7c3": "BuerLoader C&C",
    "d0a8e8e534e60c34ed2341435a1823b11c3ba605": "OrcusRAT C&C",
    "d0a96ccc289b51b7c0656efe7df9b87734d45da9": "AsyncRAT C&C",
    "d0b3d0f104339bb28ef3f16e6a321f44613411a7": "Dridex C&C",
    "d0bf5d403379d6b9508c7f0f84dd3a58ed6abc53": "TrickBot C&C",
    "d0dbc01b5ffe6f801816b48af9d857d0176debce": "BuerLoader C&C",
    "d0e65db2f76b9d71687013a14eba90d14fada597": "Vidar C&C",
    "d0eff5312ad4858ad201e35e5535764973fb4a3c": "DCRat C&C",
    "d0f17091244f892ea27aacd3d64adcb9822832b4": "TrickBot C&C",
    "d101789ba068fc745adb51a320ef0163236aa9f7": "Dridex C&C",
    "d104c8abc15e27716554f3b31d2cbda9b75e10fc": "AsyncRAT C&C",
    "d10cadba6aa847ffc709846f1778c79c42341558": "TorrentLocker C&C",
    "d10e6cd013949c081db7117cbbb169640b2c260a": "DCRat C&C",
    "d110b1f8e68ae36bc9a8e4ef718d9317e5d6d54c": "AsyncRAT C&C",
    "d125063788107c4275be9fade697bf031f3190ee": "Chthonic C&C",
    "d127d8b7a1516f8c1f5f018ebafa6c1da18211f9": "QuasarRAT C&C",
    "d137108cb24d526f6c177c9cbba7f0e556ac273c": "KINS C&C",
    "d13bd230b696f6c3bb65b5a0f199fd5c58792c21": "Trickbot C&C",
    "d145d8275bae962f4673fe7f62b0594579d1b95e": "Dridex C&C",
    "d14ca3af3427b4214a94912752a866db72d70abf": "IcedID C&C",
    "d16d62482255b1e807fca8baf4f6e21ff4994946": "AsyncRAT C&C",
    "d16db8ecf16e60468bd0199b07c84008b007f496": "BitRAT C&C",
    "d1744677216a12e4cc4ed090f82fa359c3217613": "AsyncRAT C&C",
    "d18d014fcf4e4f0173ed93d680ce77450b098b65": "Gozi C&C",
    "d1925192105bbd8875d0d5bb58bddae9eebee85c": "AsyncRAT C&C",
    "d197587bbc145b81eb2eac5b067f027f3d17d0c3": "TrickBot C&C",
    "d19f901f4f9ff3a09939a379bd770ddc97f21ddd": "KINS C&C",
    "d1a1cc526231861e2ea9aa69b25834e279861d38": "Malware C&C",
    "d1a2e7ae91821e3ebac461a08dc0ddcf6b3ca5ae": "Dridex C&C",
    "d1a67e962698f2d86210a60db4366fd028aef0f3": "Gozi C&C",
    "d1ac8871c0115e68601f1f93dba821d2dd0933f3": "Gozi C&C",
    "d1b0f9b528b3cbded38d93a07b203c932c70ffd6": "AsyncRAT C&C",
    "d1bfbe77d703223661cbec893b4e7cb5d9ce2cd0": "AsyncRAT C&C",
    "d1c74082fa5137905b8675aa054a0baefa5f7650": "Dridex C&C",
    "d1d7c699b9f29013336269634f99b5af91dc3fa1": "KINS C&C",
    "d1f73dcc4411728050d3fc4a2224263baffffcdd": "Dridex C&C",
    "d1fa32b413e92712082253f5edc4f5799006e294": "TorrentLocker C&C",
    "d1fa73ccdb4b36113709adff3c8ee80cbcf6e2ce": "Quakbot C&C",
    "d1fee10f340312c8761064d6b193036ac5fd36a0": "QuasarRAT C&C",
    "d2074387b1d975fe5255f5285e1c754d95095a24": "Chthonic C&C",
    "d212e26514301923dd7ecbb56eeb8fa5c5277478": "TrickBot C&C",
    "d2186c235f70b7fefbcfc4d9db83f372480d57b7": "Quakbot C&C",
    "d21b16ed8894e7c23a40248331a637f66915e068": "RaccoonStealer C&C",
    "d21b49539c3ea494897d43cf75cbf5f989f0792a": "QuasarRAT C&C",
    "d21d323e19d75d1fd7b85c0b4a50f06c9271159a": "Shifu C&C",
    "d224e5bebbcb3ab7206d7030e15158ac1ef88f7c": "OrcusRAT C&C",
    "d23fe30d123c77771ca65eff801bc3bd6cec2236": "Malware C&C",
    "d25a2b8cb241da84bddcff0c2fff90987b7fa30d": "BruteRatel C&C",
    "d2841fbecd05f93c93b7a6915ed716649bce9264": "Malware C&C",
    "d28be4346efcd87d17d3595d0d8c86d222e05420": "TorrentLocker C&C",
    "d29d61cb5257a851da02608f4530a944adaee071": "Gootkit C&C",
    "d2a51b61a32277dfa61d494dc20654675feef47f": "Quakbot C&C",
    "d2a73aaa3def6d01c20d0b604ec829495393a455": "AsyncRAT C&C",
    "d2bb3acfc2bb4d2179c7d5165df8e1d9fe44e150": "AsyncRAT C&C",
    "d2c2beeb9facdfd12b8ca406f8e155de9d70849e": "AsyncRAT C&C",
    "d2c542576024a746d4713da9cb263806ff62f8bd": "KINS C&C",
    "d2e357141df539275ab047e7d7a67ff860cf2168": "Dridex C&C",
    "d3282ba83245f7dff4c0f8eb257f2cf78ef40360": "Gootkit C&C",
    "d33298d1fe3d43ecc087c2883fba8a6cc124c42e": "Smoke Loader C&C",
    "d33dee92f0f5de07110354caff484fe1e6b54886": "DCRat C&C",
    "d340fc077847ac746cf866412ba9edef5f1085c7": "Gootkit C&C",
    "d3410426728a105c506b631ae5a9048ed210df46": "BitRAT C&C",
    "d344310c0ffc00c43b2483d62b580b1ecc3a74ed": "Qadars C&C",
    "d34ad02fa23233b6493e363d6337e8358d9747d7": "Malware C&C",
    "d35112fd835606f91065dbe2043e9a2ca2bf60ba": "OrcusRAT C&C",
    "d3516025e24dd3fd8fd44a91158243cc53f0c547": "Ransomware C&C",
    "d36a6852eebf986c2d6f796fab28097bdb8160c4": "QuasarRAT C&C",
    "d370343a1c20c309ff598601a106ec9b385c55c2": "PandaZeuS C&C",
    "d3749570795a041a5b9b7f71d15cd539096dc336": "QuasarRAT C&C",
    "d38330c098847449671c0846d31af5d9da0079ff": "BitRAT C&C",
    "d39020961412eecedf654db494332dcb0b76ca71": "QNodeService C&C",
    "d39d27d2267c5e3c26382699e038be6e9270dc13": "Redyms C&C",
    "d3a8152a00f425dccd7535ffcfdf4ccd33dac2f8": "Gozi C&C",
    "d3ba744f7c409b46fd625e6e806d4b86d6e3b227": "AsyncRAT C&C",
    "d3ba8f886732afee1cc0b69d9a3a59237121dca7": "RaccoonStealer C&C",
    "d3c486b5a0bf9a41d85802337e221815b0dc9088": "AsyncRAT C&C",
    "d3ca534e40ccbba21a9722c2165329947627e349": "AsyncRAT C&C",
    "d3dd5d3ee345ee6edebee2e83de13dc9ad98818d": "RaccoonStealer C&C",
    "d3dd706d4dc25ee63a5502b07fd2063214a94651": "Dridex C&C",
    "d3e893a44a0446e559168fde5b331ec44d64944c": "TorrentLocker C&C",
    "d3efe0960e2239fa6dd877e022414c82321dd396": "Gozi C&C",
    "d3f923e9dedddc65f5280ac9c07084ca82ac4c22": "AsyncRAT C&C",
    "d3fcdcbe1fd7164f3278b853c0cfd38c632f9499": "IcedID C&C",
    "d3fe24a0f76a0d21e7a3e41928cab7be18575e53": "Quakbot C&C",
    "d4244108f94b6931141c13b2aee83db325ee05bb": "Dridex C&C",
    "d42b5012180b45542b4c80d9bf115cd1cec99c67": "TrickBot C&C",
    "d43dc9e2f76e6d1476c3a2b2501d2a65e143c8dc": "DCRat C&C",
    "d4446d1363895ec5ba7b2b12ac84023c5bb55c5e": "QuasarRAT C&C",
    "d448afe5af01eb9cd1c1343d46d267ea513ae47c": "BitRAT C&C",
    "d45176621e4875d850f7e7c7de5eecc657b6c671": "Vidar C&C",
    "d473ab95f74d7590d5aa0dedfcf7de6490371abc": "KINS C&C",
    "d4861e9b06e07d34ad125d8803c461a6a7a37e21": "KINS C&C",
    "d49251a9a78623c0f60b3ae5ecb8225aec9dc6bf": "TorrentLocker C&C",
    "d496422a7934df513c1683844c8a6869e6462f6f": "Gootkit C&C",
    "d4a6636b43f896afc503eb976a662d237e06fa9e": "Dridex C&C",
    "d4ad3a76552ef62fac1bcbc0aee1c6f1f085137a": "Dridex C&C",
    "d4b5d39efceb8266f1e69926a8513129f28d4966": "BitRAT C&C",
    "d4bb3b06b50067ccf5b922eaa67cf5fe0e6cc9ff": "Gootkit C&C",
    "d4d79d2488106199fa0f89cf9f4debfe32d7c81b": "Gootkit C&C",
    "d4e260f0f3e7bc6b5852f3ada034d40e4693850f": "AsyncRAT C&C",
    "d4ef49244a3e94bde7a6ef69e7c7095cd3944500": "Gozi C&C",
    "d4f3ef1bef3d140ad91e83c18aaf28ad3ac87980": "Vawtrak C&C",
    "d4fa6554b5f6243a50eb1453e440bba58da56f61": "KINS C&C",
    "d4fcc5a202853022a61cbf06f35dc52025dede3a": "TorrentLocker C&C",
    "d5000b9ab5d215e8ebb9363de2741c6794068c7c": "AsyncRAT C&C",
    "d510f1212ebfe321a47013941fd9814e7316f9e2": "Gozi C&C",
    "d52380918a07322c50f1bfa2b43af3bb54cb33db": "Quakbot C&C",
    "d5279c609f96ab1e2869831af55f695b88e11552": "KINS C&C",
    "d52f348a50ffc7e7f3ef398d121b5517d06cd8df": "QuasarRAT C&C",
    "d555b6ef35d35718404a8fd663b73968b358d941": "AsyncRAT C&C",
    "d556703530c7b2fabb8022a777fbfffdfc95b16c": "PandaZeuS C&C",
    "d557cd4edc37e8329b00b8dc09a475b97197f584": "BitRAT C&C",
    "d55b0c3e2bc6df6f06a5c41fbbdc157cd3216ec0": "AsyncRAT C&C",
    "d560b145a754c98318e3915ecb09d7cb59692b09": "DCRat C&C",
    "d564e3c1f3cbf256d976bd8c07bb224009c39a0a": "Dridex C&C",
    "d57021bf03616b89cd2409b23b36c6a4afa26bd4": "KINS C&C",
    "d5882f4373e671a4bbe7f7144cd7c57dc66b70da": "AsyncRAT C&C",
    "d5a9589ad3b30d250c6d0c41ae7284b812ff4591": "BlackGuard C&C",
    "d5aeffa5547fceff7d6c3ec11e474ddb10ef4dae": "BazaLoader C&C",
    "d5bd8c2262d85dce890163571078747e05a8da49": "CobaltStrike C&C",
    "d5c7e05011a9f2fffb214d0ad221b45d9be2e214": "CobaltStrike C&C",
    "d5d8e48a94e1ae5359cde5831ebfdd36b0352629": "AsyncRAT C&C",
    "d5d9e52e289a1487c04a99eaba7f8f4a8916ae2b": "Gozi C&C",
    "d5df6ecb230a6c3e80a84121b667c6996e49d18a": "KINS C&C",
    "d5df9f23b3d4de6cd38e30e0e029f3a8715cd9f6": "IcedID C&C",
    "d5f034953ca1c9e50a6c0c45473ae021d6fe7e93": "Ransomware C&C",
    "d5f2a9a6f58bd4a40f19acbabcad04c5b68e83e7": "IcedID C&C",
    "d615c629331ee52aab9ae2d12d141b7cb3d797e0": "Malware C&C",
    "d61beb58b1662e6499b62a0df393955b9fe46ffb": "TrickBot C&C",
    "d62e065311dffcecad9f8e92c316aafb6019394b": "Adwind C&C",
    "d63bbb1843184a048fdf1f86ae54ae3192cc8d99": "PandaZeuS C&C",
    "d640420a2380270f2b845fe24aa5a7cff6e235ad": "TorrentLocker C&C",
    "d64049222b4aa4ceab279611264b3b82780cdf45": "DcRat C&C",
    "d6412db50df662b5af43a2a20dfe58e00cab0996": "IcedId C&C",
    "d64357623c6f1ca7861e78ed0b42badcb3c9d9ba": "TrickBot C&C",
    "d65f32e7a6f1c3b39fdcd5ea4260a4fc7ed99ab4": "Dridex C&C",
    "d686411c699cd842004f6bd689571f1ebbc8501a": "TorrentLocker C&C",
    "d6923ba06e28e7681f0a0ce34f06719d3630bf4f": "AsyncRAT C&C",
    "d6941b24a30df5c48fe96243884120aa3c1641c4": "Shifu C&C",
    "d6949facebaebcd508d8bf2b1207d9ab18feb70e": "AsyncRAT C&C",
    "d6b0b484416a8f1a76df3fcf9f9d46425a2e727b": "OrcusRAT C&C",
    "d6dd966c1f699c2320d98519f14d4bf56ca7d5ee": "AsyncRAT C&C",
    "d6e146db651d3d37e2d073e8d82de6f2250b9791": "Dridex C&C",
    "d6fa47d0cfc98fcc9d3cb5603472df2fc62722c8": "QuasarRAT C&C",
    "d6fffef0fde4a1cca7ef0247a5812b3f6aba06db": "BuerLoader C&C",
    "d702e1c9c12f7506f62fd8c13803b5905f7db89d": "QuasarRAT C&C",
    "d711b34f3a6cd9ee82a67699183eaee86959cb3d": "Gozi C&C",
    "d73163331b6bf512a1e8f74ce340037c549798fc": "OrcusRAT C&C",
    "d735697295bf1aa41b2eb5fdabb415f5da618ee4": "IcedID C&C",
    "d74775abb872f6110353227e4543885da00cea76": "AsyncRAT C&C",
    "d74b24a0a4fbbe4b97fe8597879abb6db76c6183": "OrcusRAT C&C",
    "d75596adb6049205420ff5ae8e671c45c73e42b2": "Shylock C&C",
    "d77443015ebe92c69ff459e620f85446241020e0": "Dridex C&C",
    "d779c73cafd2c012b134b3c039de24865bc78288": "Loki C&C",
    "d77d5c09f604688796cc602633dfe5086d2a87f3": "Dridex C&C",
    "d78d84736095b51c914c63aba80651c4b28bd8b0": "Dridex C&C",
    "d7918ee6eef01a3c7136de175b4f62eb453b09ed": "Malware C&C",
    "d796221f8eae06e925f29c017016c31f9648be59": "DCRat C&C",
    "d79b4861808af8f3a9af8b35a89d0d472455bd41": "Gootkit C&C",
    "d79efeaf55c90aea4c0eb53b87a66a499badb764": "QuasarRAT C&C",
    "d7a19b9edafb2fbb7d404fc79c0ccdef5a1279c1": "Quakbot C&C",
    "d7a35f4bf9e622a0ef22d2d44061a4f56eb6deb3": "AsyncRAT C&C",
    "d7a8e8281282bb30fcd8b180f9a70b017d407df5": "Dridex C&C",
    "d7b119966c5b41dd99b2e1e1c8745fcb65f809de": "KINS C&C",
    "d7c6d48d712546c55b9ada70c0f82f2e34ac86c9": "ServHelper C&C",
    "d7e3f2f1a45f0178fa93291bc8e09c5814535f11": "FindPOS C&C",
    "d7f7a7ad8e0f1850588387c3761788966f94f0dd": "BitRAT C&C",
    "d7fe8eb38babd34e3ef84712e72f8735e774fdcf": "URLzone C&C",
    "d7fff5487676b18def88d83f43914fd434990c0a": "Malware C&C",
    "d8086905326794d0e553bd6a7ad9a06498b1ce4d": "Ransomware.Nemty C&C",
    "d80a79c13a7d6a869ee659d97c17245389bad338": "Dridex C&C",
    "d8243044554c90e8d94e70ec9c8a107f69f38c00": "KINS C&C",
    "d8275a0d7ae32768797ec2ccf1c0fc2ff598a1ae": "Zloader C&C",
    "d84510b4a9e83e5d266d82798b97a42abaedb29c": "DCRat C&C",
    "d846024118499c9c1ee2cec748c9265f18a2df6c": "ZLoader C&C",
    "d858315e4c36dd7d51c98401fc9033e3714114d9": "Gozi C&C",
    "d8591a222c18e30700073e5c2593d47a91613478": "AsyncRAT C&C",
    "d85b16b753442836c5e6c9c17f68d1e48c5e51c7": "AsyncRAT C&C",
    "d86dc72aa641bbdcee8ef7eac4a87a67cb6deb71": "Dridex C&C",
    "d873ec4c0099932edcd94b41cbeeab70048c598a": "QuasarRAT C&C",
    "d877d13c4da290c0905ccb94a0fddc5e33633ef9": "Malware C&C",
    "d8908716fa08a1c1f2178cf8f9857198fb8c5b0b": "AsyncRAT C&C",
    "d8ac679503128d58bfac22065d90e9ed3fc09cad": "Vidar C&C",
    "d8aedd31daf385b538255e1fa5879e1919db64b1": "PredatorStealer C&C",
    "d8af2f6a1a2ba2b1b6e1a260e791fcab88cc2c8d": "Ransomware C&C",
    "d8b12e83595f43996c831d7c000bf4cb9ba9e51a": "Dridex C&C",
    "d8cc446def18160fff1cb6d4b5500f9133aa4890": "IcedID C&C",
    "d8eb24f90848872fdbeca39db34be1004f1b030d": "Dridex C&C",
    "d914528392418a85ab4f93877ad586fecfb1a140": "AsyncRAT C&C",
    "d9190610dd0725db8ed22589e516f54078a08402": "Malware C&C",
    "d9232aeff9e823a4d8c3dc77674a6bdd88ed6e9b": "Dridex C&C",
    "d932fe11f6e20d5c59e45cea2547d8a5590b269a": "Dridex C&C",
    "d937f94968e0cdd1b7df1099e61f867524a1ad81": "Gozi C&C",
    "d939155400494051d785fbeae33933f64a2d6cce": "Rovnix C&C",
    "d93cbcee944ba766f2f024ad5a2275b25804b2f0": "Malware C&C",
    "d94b4b9d94b1ab1979bb3d3b66e89bcd8e31594c": "AsyncRAT C&C",
    "d9592d6246c32f60096891f066653c87d614199c": "Quakbot C&C",
    "d97a031cc4fa1cd9a082a690230e9428a0cc2156": "QNodeService C&C",
    "d9853b642206cd4897d69f78c64b274243823e83": "TorrentLocker C&C",
    "d994423f92118b755212754090c04fc696447685": "ServHelper C&C",
    "d996af9ab6c590a27a73358ddf377add5bf8c05e": "ZLoader C&C",
    "d9b58c374f81305fb5b545b6f9a93b99bb81070a": "Latrodectus C&C",
    "d9c8f9703d8b30e8525330401d249fe8d9fce0aa": "QNodeService C&C",
    "d9dd7d1e3816830695bc3e532f35eab264ece7a8": "Quakbot C&C",
    "d9ea8c49ad8560e191e242de5ebd49b0d6c0c180": "TorrentLocker C&C",
    "d9ee1ebc5d05647e9e57c9805a2dc8565c5c60f6": "Quakbot C&C",
    "d9ef3dc964b67f5a99bfcd6188248e2a641c2b6c": "Gootkit C&C",
    "d9f09e18aeddc3ed5c0a5d1c8bcbb131af34cf0f": "BitRAT C&C",
    "d9f52c1ee0277088b7141ed97f86ea0b9fb6f1ce": "Dridex C&C",
    "da0252bb3edaefc37cc49ce54b40c1d756b0c032": "AsyncRAT C&C",
    "da12602e1aa5e64c3c002a182ef8d9983a3cc832": "OrcusRAT C&C",
    "da15d55af3864699361f8eaf83a0cbc24b764459": "IcedID C&C",
    "da15e73d14a6e4ef122c628452a97c0b1408f518": "TorrentLocker C&C",
    "da3f0f317fde6365a79b815606305074ce9719ab": "AsyncRAT C&C",
    "da3f731e1f54cba11c01dd4eb3c48efe354c6ff9": "Dridex C&C",
    "da4689b96c811d32ab3707e588009319f96e569a": "AsyncRAT C&C",
    "da4c0b87928ebe310fac277443fed978f13616d7": "AsyncRAT C&C",
    "da5472c304251f99b79d944c7138d7513c8dd264": "QuasarRAT C&C",
    "da5d2a4e6b404555ba5ba99c891b18cb6f96e056": "OrcusRAT C&C",
    "da5dc1daca7989db13166f03372062bf2a11c1eb": "Gozi C&C",
    "da5e5dbf5a863b6d2923ebfdce4a280d8bdf0374": "PandaZeuS C&C",
    "da6ff7d6343ca218e71fceffe1c84498155f2671": "TorrentLocker C&C",
    "da74a97a9f62e471c12fa362b36e5bcc6643cf51": "Shifu C&C",
    "da9153f51cf1f99339329b11aa4feec860a5713b": "AsyncRAT C&C",
    "da9b7eeee81ab8a75e21cb60f390c2faaa0f1a09": "PandaZeuS C&C",
    "daa31bce584f1642500b7ae2eb6fed5b040a95c6": "KINS C&C",
    "daab669cbdeb35419e76e9fb4a1438880a67467b": "Malware C&C",
    "daadd88d8ee8a1e2719bdf5d386c744f93ebc025": "PandaZeuS C&C",
    "dab673b107f521848a3563ff2573764818e67f84": "BitRAT C&C",
    "dabe87245589729ed881f4d15d42ec09f0fcae6c": "Gootkit C&C",
    "dac8439fe100098db04e9626a1774b306394cec6": "Dridex C&C",
    "dae9e02e5e04d59d9af2aa1d5e82248d5919ac6a": "QuasarRAT C&C",
    "daf1bfd25cfb24e7abbbee90991acc20c97fa248": "BitRAT C&C",
    "db16d18d72499c0f97ed983429e76d77067b0867": "RaccoonStealer C&C",
    "db20b739720ea60c0d110e8a2e2a08773b1d5b1d": "Gozi C&C",
    "db24814f7647f915719b06c4bcd7d963822fd507": "TorrentLocker C&C",
    "db293c3d5e788d9feabe07acc5115d026b49d892": "VenomRAT C&C",
    "db2cdf3171d92d90f11fecd21163599f3c5fb7c4": "Upatre C&C",
    "db39fb926ca9355080ef7983f1feac668305a0f6": "QuasarRAT C&C",
    "db3e4f8db90be12aa838169190d66eaf0f0ddccf": "RaccoonStealer C&C",
    "db410956afc97cc53de070278c24439380b4596f": "Quakbot C&C",
    "db44ff75334b434ae540ca4125dfec299e858db7": "KINS C&C",
    "db49fcd449e1b214df6939e16916def506ccaacb": "Ransomware C&C",
    "db517c5a64bd5d2c4e8e084921ba04ad28206391": "ServHelper C&C",
    "db58aef68ae7d50525998e3c7dce7604ab35d9c6": "DCRat C&C",
    "db59b95d8749a779b90ee7d3b93cd7b4b1666bfe": "Quakbot C&C",
    "db6529fa0325310d9e0b74f841ecea06704d8bed": "CobaltStrike C&C",
    "db8aef4c7e33fec5c3cb235668fe8a5350fa11ba": "VenomRAT C&C",
    "db97cbb725588868ac8a9036e096aa4f0117a99b": "TorrentLocker C&C",
    "db9af549aea6740d596c7dde164e83f5c2285c09": "BitRAT C&C",
    "db9f2faddf0061a6d8c63a138c2aaf14e975b21d": "Shifu C&C",
    "db9fd1a356c0dd0bdf8c3e19e1d4da5d7342883e": "Gootkit C&C",
    "dba233fb04b2299aec6ce0541049cdeeac306240": "DCRat C&C",
    "dbb106223514dd44b10180f72d148a8743143dca": "DCRat C&C",
    "dbb4e3f0b3932768ccfbbb7384d1c095c7a4f7b1": "BazarCall C&C",
    "dbb7ed309f6eb45e65441233632a042b2fd6804a": "AsyncRAT C&C",
    "dbbb73cf1ca87929c23b9cfb8f2cee17ec910ae3": "Malware C&C",
    "dbc269e438ec2ed7592d40d4357ec0a4ed0920ec": "Gozi C&C",
    "dbc68d66eae28337b890c2f58bb6fc2abd09bd50": "Malware C&C",
    "dbca3441a2047f58f2f4f2493016a1cb97b73e6c": "Quakbot C&C",
    "dbcc6a0ba2f36ec90e83aedf59d51d4952533021": "Dridex C&C",
    "dbcd9c87fec52100283fb2f0e40ce0f35b5e5f02": "AsyncRAT C&C",
    "dbe32814429058d019e9c042a8e2328f5fc4ed75": "Gozi C&C",
    "dbf0337b21436fb62e6e79e888bdd90f2668b31f": "Dridex C&C",
    "dbf18b0b491ed86fe005cd0cc322a85fef226e3a": "AsyncRAT C&C",
    "dbf322887ff4ae75f6bb51f9294a5071999a412a": "AsyncRAT C&C",
    "dc09cf47d9296e75cd5140182699738215ece3fe": "PredatorStealer C&C",
    "dc0b372edebdebbf282999874e91a139e0538006": "Dridex C&C",
    "dc1306d5d7e24d24af3ca8a87e2b26f8be2dea45": "Gozi C&C",
    "dc36b587d53b01131bb2542069365f43f1e948f9": "AsyncRAT C&C",
    "dc39c2607c2cb0ad7465fd6b8f99d237a4a08a71": "Malware C&C",
    "dc402fc311def4fea7961e235b2f7a23ecaef3c9": "IcedID C&C",
    "dc441ed1e1335b90451ccd046b8373e73afcb097": "Quakbot C&C",
    "dc45c45ac1bd2cfd2163ec61da7000599cd45aaf": "Gozi C&C",
    "dc53a8ebe98674f5974ecd10ea79ed9fd040df43": "AsyncRAT C&C",
    "dc58638ff02978a31f8e489e46cb446572de5cf8": "DCRat C&C",
    "dc818e71e0558b0ba3625771c80456d932d45b0e": "LockPOS C&C",
    "dc97fb4bf132fc0e026887c1664ba157275b6fe4": "AsyncRAT C&C",
    "dc9dfda5146dce11bd46bc4752798e43a5edf9d1": "Dridex C&C",
    "dc9ee157941ca7f6efe49c2ae64ba9514e8ae40d": "Malware C&C",
    "dc9ff49cfca995e2666e3f6d23ec95a6aa823697": "AsyncRAT C&C",
    "dcb0d37a8c107a0e842be4edbbf61ec2332977f6": "CobaltStrike C&C",
    "dcbe920e3d0cba40be80fba5e23a6b4f9a706dd4": "TorrentLocker C&C",
    "dcd623109bc4808ffc362435addcd149342ffb73": "BitRAT C&C",
    "dcdc9d5ca94aaa2b39788c7b675eb243127260ee": "Dridex C&C",
    "dce0615a75e1a4db9da9222b1f968d9f02f75882": "BitRAT C&C",
    "dce3028028028e5b2cd6ff51a6b6e5659ab1d748": "Quakbot C&C",
    "dcf0f5d059d5554414f1dc1a809de78e7018024a": "Dridex C&C",
    "dd082f01b97f6ef169962507236cee4283498316": "Dridex C&C",
    "dd0966fb66cc22783d1afc06e6dc8c426acca926": "OrcusRAT C&C",
    "dd0b681f326ee47172569a5d68ce0ca786c3c366": "KINS C&C",
    "dd1d74bbb0b26c09a955956e224f2a8849d5fea1": "DCRat C&C",
    "dd2b51ae50c8ba78f15e4839d679a149d20f5c5a": "Shifu C&C",
    "dd38f445874516929c531ff4222548ba1df4e5cb": "IcedID C&C",
    "dd442a61a37908de830e2026c2625940c1bcc79a": "ZLoader C&C",
    "dd47417878546993a538949173a8763650569b87": "AsyncRAT C&C",
    "dd4f68c456e0f0a5c267033e7f7afd7314e50a5a": "QNodeService C&C",
    "dd58922e2b2ff10cabd4b3b7ec2f4155b982e835": "AsyncRAT C&C",
    "dd5cba599374d8b588986bebeb99a0c55b9e1c4b": "BitRAT C&C",
    "dd79af836bd99bd2fc3d66a0613f83fc8a50a5ca": "QuasarRAT C&C",
    "dd7e3cfb312ef1b20d6108b9e2fbd5451b997157": "Dridex C&C",
    "dd92ad90f3903d6a03fc98d522e12a16c5acbafc": "TorrentLocker C&C",
    "dda8ad6d9d7c8476a5add6bc37a3eab1f5e46c9c": "PandaZeuS C&C",
    "ddab8f6391e855c751ee825662bd83c9cf2d9bc3": "Dridex C&C",
    "ddae0c37e83a8f1d9ba9a9285298591743590ed5": "Gozi C&C",
    "ddaf18c7834a5729a105e50806a6fd7840f73191": "BuerLoader C&C",
    "ddb24237f8ff55ea54d16d632803b9768c4c17e0": "QuasarRAT C&C",
    "ddb4ab26044273f7c61e90bda2acc0c7840f1f79": "PandaZeuS C&C",
    "ddb59d8cc93688bbf4925c7d27462b70e53225cb": "CobaltStrike C&C",
    "ddbd8027403bbdf217e634530bee7240ced68a8e": "Vawtrak MITM",
    "ddbea7ab02afe44d5bfc1dbef090f26c8b01e823": "Gootkit C&C",
    "ddca8f15caf12feb0a8777d2196d8cfea6d25f01": "QuasarRAT C&C",
    "ddd1ebe1a7156091eefd8a1f66ff09fc99e2410a": "AsyncRAT C&C",
    "ddeaa7f2df2b38e364ed38ed821bd766b61d5fe8": "Gootkit C&C",
    "ddeb9c78d43d909c3bc3196b807b1d5f21cfd060": "Dridex C&C",
    "ddfba983d91a8bd5a9bcb684dbe47bc8cc5accaf": "AsyncRAT C&C",
    "de281b0331352390c2977ed39e4c62472d2dabe4": "Gozi C&C",
    "de2ae713eca7050f1b5aa1e9f88f2bf0351176f7": "AsyncRAT C&C",
    "de2fcb515c44968fd32470f8e1e373fefa8bfb60": "TorrentLocker C&C",
    "de469d74342cb8e772016efbc08495e43b7b75de": "Gozi C&C",
    "de538ff247ffd45f7bd04128c7cb9923321fe11a": "Adwind C&C",
    "de5e17c7f220acbaeb8dbeb4ef5c8b36c1ddc12e": "Gootkit C&C",
    "de6420f691749b275dee88469a088209359cef29": "Dridex C&C",
    "de73dca7d158b381495f57632787ed7a83f603f0": "AsyncRAT C&C",
    "de8019406cb50a7c5382ed8c86cb468b06ee6e24": "TorrentLocker C&C",
    "de8950e9a78a8ed54cac1bce080eff21d15f836d": "AsyncRAT C&C",
    "de980db3a9f4c4fe34d8abed0eae9653cc83206e": "Dridex C&C",
    "de986431ff37f7dcbd7c7013aa47bed4f21483c3": "Ostap C&C",
    "deaecc4fcabeab05a4fd7a8e2f6316c974be6a40": "Dridex C&C",
    "ded0f2f452cf448b64ac9e475c3e621edd7a7f87": "Gozi C&C",
    "ded1f277d9bec1f6e6ba23794c5a5a80b39aeee4": "Gozi C&C",
    "ded272f306f9a8147d00b7b5d37544f63f70bb35": "Quakbot C&C",
    "ded68c5f7707c18a9ccc37a12127d06a95e9e97e": "Gootkit C&C",
    "dee61e7d12223cb2d0fc9c30fa7e4ad1c8e07518": "Gootkit C&C",
    "deeca23554546130163aa4eb0b718093a16fb13a": "TrickBot C&C",
    "df4b2f329f19f8a50233e4f51ee1616eb80dc7f1": "Vawtrak MITM",
    "df62ac9afdbea306ffd2ceebc9cf118466713e6e": "Dridex C&C",
    "df68a878f3eaa35672a3baed6e1bd4ffb336842d": "Gozi C&C",
    "df771db44d520709fb8246624571f9d1449f1fe2": "QNodeService C&C",
    "df78b019bc298bc97217bee62327fcc6970ae454": "Dridex C&C",
    "df7c34c79789654c9d2f3503db38cd55ef8d8477": "BitRAT C&C",
    "df9c32ddba0be96f0852bc593da3d78212b1d545": "KINS C&C",
    "dfa307f4b62ff4303b424a9015b6166789df7dde": "BitRAT C&C",
    "dfa54f6e3078098e4cd6e320303798f27a640096": "Quakbot C&C",
    "dfaf2a46c7268b575cb17284e128aa02795276e5": "Quakbot C&C",
    "dfc233225ef8e57b28e198e523e03eade9757387": "AsyncRAT C&C",
    "dfca93b24b408ea6ea5f937fc31a602a66b722d1": "Malware C&C",
    "dfceaa124fdcc05115d3589c6e2f493620df59b9": "Ransomware C&C",
    "dfd898e92beae06c3b479673676643bec433199f": "Shylock C&C",
    "dfe1a7f8a00288bd501361e472187b9f714bea21": "RevCodeRAT C&C",
    "dfe25ee5c5aba87a81d6f95c3aa7b5ac5e5ab6b2": "DCRat C&C",
    "dff6ef75f8f5c88c1a4b49fd2999d858d09c17b0": "BazaLoader C&C",
    "dff991d6d9b0c947272bb3d7800b4177be492f91": "Gootkit C&C",
    "dffb56f3207df4d4865a3b49edbf8f27d6c71a8e": "TorrentLocker C&C",
    "e00428f71b202386aac431cc90068e9204f3d586": "PandaZeuS C&C",
    "e01278f6490736f0c6300b6798569094a9caed9b": "DCRat C&C",
    "e01844c6a6063b6235653127cc54ab384e34cec2": "Dridex C&C",
    "e01ab594e9296ae3a772d0118c72a8892a8e5751": "AsyncRAT C&C",
    "e01b1d771bac35167c79e138912554a160577f3f": "PandaZeuS C&C",
    "e01d4101fa930fae382a95be9d51156a6c37d9c2": "BitRAT C&C",
    "e0214388a794383b4e41fdface6912b332b0457b": "Dridex C&C",
    "e02dcdbdafbdc836dcb35fd1c61ff7dbf6886865": "IcedID C&C",
    "e03e335629b882f1f03f091123511eaa3fc2d6b1": "Sinkhole",
    "e04357f4449151ec420113ca909664579ccc2b45": "Dridex C&C",
    "e04f0b8655bd732ed8625eed26cdf19417082b1e": "CobaltStrike C&C",
    "e08016a907528083127bed6e4b902f417554a1b7": "Gozi C&C",
    "e088194730a9b38cdaa2a5871e8c83c4d7e9bc9a": "AsyncRAT C&C",
    "e089cf29d8494a9e1903a30a8bc99c456143633d": "IcedID C&C",
    "e0a0a4d3b78a7d09e383d7ea066a5c7231eb0976": "AsyncRAT C&C",
    "e0ad8a3bfb52d12f21f0875c762071471b56ffc3": "AsyncRAT C&C",
    "e0cf9d948a14077a450d15d329c180acf41cb2f5": "AsyncRAT C&C",
    "e0d903bbddc642e5f7820b22d86eae9e15a7b2f8": "Quakbot C&C",
    "e0dabc3055f7f9f637ac862df4a64ba5ae44e8a6": "AsyncRAT C&C",
    "e0f2b50a2510a1d675e8bb48994b18dc2a08578b": "Malware C&C",
    "e0f7072057c5deeb21c598673740debc7f6eb8a1": "Gozi C&C",
    "e122469082c09f12ff4777fb5203739e6d9a8fda": "DanaBot C&C",
    "e12b8859e2195f69a0c4e8d7025d91c844cb8b49": "QuasarRAT C&C",
    "e138dfe937254481ad5c47b07dc89cb2c47b12f3": "Gozi C&C",
    "e13cf9c72eee40604c949bbe29935b19db5a7c91": "PureLogStealer C&C",
    "e144d95184b13e6f3b86a7add4d4687decefb775": "Dridex C&C",
    "e1473219dad1eb82d9e43cab21bfa6789bd61c63": "RaccoonStealer C&C",
    "e184e31f5e2cd9fe44cd81f3f3b7a69e1c5b5ffb": "AsyncRAT C&C",
    "e1864e8f7f6d63cf175f98417184bba1034fda63": "FindPOS C&C",
    "e18a8380949aec89305df7b6ee4b0007af3052d3": "KINS C&C",
    "e18c66d73302244d158ebdd0f141dc395a488ed4": "Dridex C&C",
    "e18da4f148058c7770370192fcf0c9e18100c79e": "Gootkit C&C",
    "e1a58a146e229cc30d47759a18d6da6be3b8b70c": "Neutrino C&C",
    "e1b20d36a9eadd5d88493e4cebfd0aeaa6b27ddc": "Gozi C&C",
    "e1b8af166d6e0e1c899a97d50518daffe69512d1": "Ransomware C&C",
    "e1bc1a010968a6549f67c308ef779d4999e0c687": "Dridex C&C",
    "e1bcf47e9ae4070cd8706477722483f0cbee60ca": "Shifu C&C",
    "e1bf9e9f22cdfb1f05f6f3eec8100f159b07503c": "Malware C&C",
    "e1c28c32fd4d57e990aaeb98117069d86c7deef8": "AsyncRAT C&C",
    "e1c38c6767fb7d608a8117884398d45b797ee438": "QuasarRAT C&C",
    "e1c8499dc6829eb9a276f38a0b3af5b7787bef1b": "TorrentLocker C&C",
    "e1cd4a7306fb0f5eadf6caa71162559423ea45fe": "Gootkit C&C",
    "e1d38d99d7b3d19dd3c40e8da7ecd4d8b85b675e": "ZeuS C&C",
    "e1e89a1efeddbb2f2771f3dffb67c19f22d3c95d": "Meterpreter C&C",
    "e22f2e4c0636e8dbaf4199cfb9111dfb30c7ca5b": "Vidar C&C",
    "e24994e2fba3dfefbff76e35ea37b9b883bf1034": "Quakbot C&C",
    "e24e79c70bf774546074e0f3293fec8772c1b8a2": "Dridex C&C",
    "e25074007931003c76ae51dc741303b86be6fa06": "Dridex C&C",
    "e250cb647f6bd0c0cf712c55f1a66faf1e3cc630": "Dridex C&C",
    "e251f288707ba7e21d3e5666f00deffd804cea56": "DCRat C&C",
    "e265599c761510f99b95987f42b6209e5e6f4485": "Dridex C&C",
    "e26e603c563b41ede29be1b80a5af08e2a599627": "Malware C&C",
    "e270466a42c2e88a72c4ba413b57568ef3b8eb92": "TorrentLocker C&C",
    "e272c00025b27847f2e439016245ec3a9e8f844d": "AsyncRAT C&C",
    "e275ed913d9f04088e2067d41b49ca90f498f235": "Qadars C&C",
    "e279811f74ac192ded19522eb8cd5b88bafd47cc": "Downloader.Pony C&C",
    "e28a4804abbc42429db89ee4fa6882546d38ad16": "Gootkit C&C",
    "e28dd9914a5a18e5c083dbf8291f018faba09fc0": "Vawtrak C&C",
    "e2953d271afca7017089dbe642675d213894d2fa": "DCRat C&C",
    "e2a779c8f685b7aa54e7c54a02d791d247029678": "OrcusRAT C&C",
    "e2b04b6f8a4940395b3670ed6956bf3d35b58a11": "Dridex C&C",
    "e2dd65fc90a92968994d76c1ec492a4d8fd1ccee": "Malware C&C",
    "e2e6132d8711903283d2db764e259bd581b526ee": "Malware C&C",
    "e2ee253a7bef95558cc92dae92a7cf764cf93e4e": "AsyncRAT C&C",
    "e2f21854fa46f47010c1e438fc893356644ef1e2": "Dridex C&C",
    "e2fc027294235c8625cd1aca7948328c1e85325c": "Dridex C&C",
    "e307d38bb19dec485d44598ec614ca36c77fced9": "AsyncRAT C&C",
    "e307da6dd84ba921de22181e13bf8fd401e354d7": "TrickBot C&C",
    "e30c678e4feda17883f87f9f68726f6d3b30f151": "Dridex C&C",
    "e31a3f2a8acb88601f4a99569c2086473780c1fd": "DCRat C&C",
    "e32277ba5842218586eec7bc725605f3f3fa6f2b": "Malware C&C",
    "e328f462dc20a7fa2c7225ea8d08c4e528099c34": "Dridex C&C",
    "e332d7327434acd5681adeb8242df3f9e2829bbf": "Quakbot C&C",
    "e343834970dfdb631a79459d95898507618c1524": "TorrentLocker C&C",
    "e343fee3adbf70e5343707d29bf34556bd0d3f27": "Gozi C&C",
    "e34c59dde04859fb3b6a37857ed253501a52d288": "Malware C&C",
    "e34f0a7d95992d754c78bad7d307c7eb01290a05": "Malware C&C",
    "e353d23f26d93aa026741c9cdda38b16fcaaa77b": "Dridex C&C",
    "e357b57c8ac410c5096c3b6a09c428d7eb2d8e8b": "BitRAT C&C",
    "e357ec145e21fb4a28a71afa35b05d4bd8056e71": "PureLogStealer C&C",
    "e38388e79ca7c59f6cba7a8176767b6f9c77becc": "Gozi C&C",
    "e38e1628f6768ad5771e07dea425653b54ba85d4": "Dridex C&C",
    "e3a04003bddf50478da4fbe2f76a301a262251f6": "VenomRAT C&C",
    "e3ac42a25d0fe0c91e77049c86aa1cc03d04c21b": "AsyncRAT C&C",
    "e3bc92325729e8df8a097b5b9deaf85fd1484a29": "URLzone C&C",
    "e3bdaa15f6c63139c28e57fa5a3289190dac0a12": "Gootkit C&C",
    "e3c59893af55099aaaf2f0b1bbbc51d5f5b69296": "BazaLoader C&C",
    "e3cc23ba7fb9b1cc676bc6d719b86c787c1b06d5": "AsyncRAT C&C",
    "e3dace16db61686d46073cd7b718b4590443ffeb": "DCRat C&C",
    "e3f00ac19ca047ba89d43a74a9a2c312f41d6039": "IcedID C&C",
    "e3f0b8e94b65fe399dfbc0979984e2d049533251": "AsyncRAT C&C",
    "e3f780b08e361aabca36cb81eddbae22e49da829": "DCRat C&C",
    "e3f9325fdcf7cbe474db678812431e432d3171b2": "QuasarRAT C&C",
    "e3f95eefcaa5d6d2c5829531ca02f9f38cda12dc": "TorrentLocker C&C",
    "e4038d79c9899d5846bb96b8b1615ac6a128c86c": "KINS C&C",
    "e404611578427b919cfe99560ccd55f9b0afa4ad": "AZORult C&C",
    "e408642f440d4adf4591ddcc2a26e6c4b12c5864": "DCRat C&C",
    "e429f24e279e8b25742d0f5347151b0f90d031ca": "QuasarRAT C&C",
    "e42ce4dbdaf0344bd734dbf98774423641e48f5a": "AsyncRAT C&C",
    "e433179371c43c714efa4d6078f7415c69e2190c": "AsyncRAT C&C",
    "e4385d6d8614c019e920b8b3650baa3654b6f17b": "KINS C&C",
    "e439e47dddf9bc6bdb61783ef0659e32e4bda86d": "Dridex C&C",
    "e443cbe368299c6e5ecb67d55f63882f4b4adfc8": "AsyncRAT C&C",
    "e46084aac20e919634c38141f1c9b44ba05623ee": "OrcusRAT C&C",
    "e462ab3c9df3b7b73e156522935b72d7028b6a11": "KINS C&C",
    "e467111a1c5c1e660849e93fc0c18ece89fed6fd": "AsyncRAT C&C",
    "e468834d835d8e69d3f004da970fbebdaf9c0f5e": "Quakbot C&C",
    "e47b9accd950fb28db375c9144d7cb260bda2999": "AsyncRAT C&C",
    "e48a5b0875c5abda355353b68d9020aeca0f80de": "AsyncRAT C&C",
    "e48fd5b75356e96776f6ff4a30ff1b701036212e": "AsyncRAT C&C",
    "e4afee41dbf6e5c5e4a29fed9cedd988c8d709f7": "Dridex C&C",
    "e4bba16c2aa6563e30a7eafccbcb5f43e4b72f68": "DanaBot C&C",
    "e4d7f26143bf447270ca9581041a6d20be6f2c56": "Vidar C&C",
    "e4e15195a5073ddf3bd0f68bf96027ccb3e61bb6": "Gozi C&C",
    "e4f016c855c67db90e124eb3f5c7ea95f8313f9c": "Latrodectus C&C",
    "e4f8151c9d72e85380e475df0abae11f9862eac0": "BitRAT C&C",
    "e4faef8904a7e1bc7da376c82e4bed8c1514e26f": "AsyncRAT C&C",
    "e5067ba7fb1ccd3c8128b361db19664ef1dd0ad8": "AsyncRAT C&C",
    "e50691f11ebf3d9160a820d7c905e2b00f6c2d9c": "Dridex C&C",
    "e50ee990a312b9e2e68c46d189e1e92381741bf9": "KINS C&C",
    "e52c7f68ec015434f421cc0b4e40ec9398165412": "PandaZeuS C&C",
    "e53deb952fadb39a2c0cf5681cd12846c234808f": "AsyncRAT C&C",
    "e554aee3e2bcfc3346a6b0467d167663aac9f6e0": "KINS C&C",
    "e55c476b3b8abd1567491aa93913410a9bb9be62": "Dridex C&C",
    "e572f2a6cfc438594af712ea063d97b3a5e0435e": "Gozi C&C",
    "e57a82a8a38158194339c44361be385d3afc74d4": "Ransomware C&C",
    "e57cd25801eef10b7874407a413c86420bb8be50": "IcedID C&C",
    "e58f32e9101b928fa98ab0f70cd9b5846813b523": "TorrentLocker C&C",
    "e5bfefe66b52e3890337e55d93d95953baea8f10": "TorrentLocker C&C",
    "e5d49e0b12012e40498cc991ae586b3ce05bf2f6": "IcedID C&C",
    "e5d62c28d43fcd358f445e30c3164f7ce4cffdc6": "BitRAT C&C",
    "e5e6e47e7d0b6a2828f983604775e0579bcf0002": "BitRAT C&C",
    "e604801b826db8dc01843ed2bc1c7143746663a4": "Dridex C&C",
    "e6106d70265f3a8ee14ef50f08f5961e3c5ff2a1": "DCRat C&C",
    "e61fe399d15541ceda021e215c095aa22f836b1f": "PureLogStealer C&C",
    "e6221c213bdc828e5098e81522460cb4eaf2e383": "Matanbuchus C&C",
    "e62c7d7ff9565b651f24a98ac18ec9634a572896": "QNodeService C&C",
    "e6319c4c8f4e1766a0cde0f8fc858ad4325386bf": "QNodeService C&C",
    "e655e78506cbfb32d40863263366f26d7492d715": "AsyncRAT C&C",
    "e689be7ccf2bfec68c5fda339905b1983fb6c11a": "AsyncRAT C&C",
    "e68de808904893e738e0be4eb7a340fdc8d2d8c6": "BitRAT C&C",
    "e697bcdf3bf5dce1ccc3a4a059b3ed11a3d14961": "AsyncRAT C&C",
    "e69e102dd8fc10965e5b24dc8edce39e71aa9cbf": "Gozi C&C",
    "e6c36ae1c584a3a5f0e0acae9cc88ffde9dbc9aa": "Dridex C&C",
    "e6d30cd041d19d3a3e9c82e0b9e3e167ad0fee9f": "KINS C&C",
    "e6d837214a818176711a61646bdb39aa02328644": "Quakbot C&C",
    "e6e1a4eb3cd220231e06e28b1a4e09b2c2ea822a": "AsyncRAT C&C",
    "e6e7f73a579cd08f000beacb9fd19f7b56023534": "AsyncRAT C&C",
    "e6eb19b96e1cdd3a5faaf1dbca3bcbc6ba573e34": "Quakbot C&C",
    "e711b002bbdcbc2ae518e548dbfb0d20a0afb0a6": "TorrentLocker C&C",
    "e72a6056bb82f267764bbde3a7c4ff8848634d13": "AsyncRAT C&C",
    "e72adb6e9bc7efcc298888dcf570ef96372e510b": "Dridex C&C",
    "e730fbd6f3c4ac163e08bbfab7f7c897722874c2": "CobaltStrike C&C",
    "e745c2dc4dc1f96ac44086bd5a05ca9234558a34": "OrcusRAT C&C",
    "e753381a551de0bbdb38562e3ff916516fe085d3": "AsyncRAT C&C",
    "e753df3fb3628432103f78f9b5a156157e895ebd": "AsyncRAT C&C",
    "e75559f9e8fb93eafbdc93be5a68fe8d2803982b": "Vidar C&C",
    "e75b04999562ea1c29e769d2c6bcf5d07822d646": "AsyncRAT C&C",
    "e76858cc6964b10dc40fc29dacbc11f97b6a25e1": "Gootkit C&C",
    "e79e38904328f44dc9a2a4bc97302c4f38100438": "VenomRAT C&C",
    "e7a1443716f9ad88eb285dc6b69f674fe733727d": "Dridex C&C",
    "e7ab8e4d903a37a38e644a5427c91a2574bc1169": "QuasarRAT C&C",
    "e7ad528a97a48086ccd53a37bcdd91d46dfeb2d0": "Quakbot C&C",
    "e7b2eb155c98d1e71ca09d688cde06e79d7741da": "Dridex C&C",
    "e7bb6cb5e7154e794d101cc3a49dfdef68beb299": "PureLogStealer C&C",
    "e7bee1409d97a342043e806de8f4eee7c3aac0ce": "Malware C&C",
    "e7ca9d1b7f1268b7a8b518009cdb7b01cd04bf7d": "Dridex C&C",
    "e7cbf27da2b43de27027a2da0fa66562607db8d9": "AsyncRAT C&C",
    "e7d78b56b7934e74fb77b473e5407d40d4083c19": "KINS C&C",
    "e7ecc943ad1c50e416f7e7d0ec25d59d282498ba": "Malware C&C",
    "e7f8d944f4a6ee9e7bd9ae6fe37e2a79c9f7a91c": "Gozi C&C",
    "e7fc4b658c64f9f7defb825a9d855cbfa65c3781": "AsyncRAT C&C",
    "e80ccf7d26fecfe9a91028521464c8a20a88b6ef": "QuasarRAT C&C",
    "e80d4f88e3029641a44b023a5fda1f95d50d5e40": "Gootkit C&C",
    "e814a1ca9c80d963bf43e98f6833afeaa8738108": "Quakbot C&C",
    "e82c2cbeec954a6d47bcaae8fd23b9a80995e450": "Dridex C&C",
    "e84a7f1de9756678aef510894b4e5d6d5c10ee3c": "Dridex C&C",
    "e852a3e8cd0beb2d28df622e2ca4d54df43ccc9f": "Vawtrak MITM",
    "e859a0cb76eb8486df4fc960842249f49ee9b3db": "AsyncRAT C&C",
    "e86a7defd83717d229b28f263ccb74300eff6b9a": "Quakbot C&C",
    "e874e15cebc2e8de0a1f3724366d841e9db10a0d": "AsyncRAT C&C",
    "e879105ed7219b0b884a8773611addae6c506e1f": "Bolek C&C",
    "e88037afbd4b7897be96a3ddb8708778eabe2cde": "AsyncRAT C&C",
    "e8820b3bb7b7cebb3572d387915b9ffa08b823a1": "AsyncRAT C&C",
    "e883fea800a47b3b853a04ddcd0d162e782b41b7": "QuasarRAT C&C",
    "e88cae4f690af11276242161ccd373d914a1bea7": "DCRat C&C",
    "e892d00abcaf5281e6d75ae0a33a881c83dc5d3f": "AZORult C&C",
    "e8995733f6eaa12202df81206d0dd469e79d94c7": "Gootkit C&C",
    "e8a174bd7896e97dca77eca0e5eb1cab6d680894": "PandaZeuS C&C",
    "e8a9f30e99e3a9f64e32aa375c2b0c2ece06ade7": "Malware C&C",
    "e8abeaa10e1bbce22c21a0ce22624d90d1bc1b6a": "Gozi C&C",
    "e8afd11a9f68e037f481116123db5320a5cef884": "AsyncRAT C&C",
    "e8cc06a8b19072660db72229be2c80b48336852e": "Nexuslogger C&C",
    "e8ddfcb24457e0642c69f567e58e51d03654614c": "ZLoader C&C",
    "e8f267404048ccd953daca3c06facd889fa78404": "OrcusRAT C&C",
    "e8f3afd3a03436218fff3dc0a0d7a671c8231353": "Gozi C&C",
    "e8fa662e7986339fac8f3548729ca627d02a78fa": "BitRAT C&C",
    "e904d0bdb394443967a8b65d4321a08f5cf124c6": "Dridex C&C",
    "e9063d83470b70a1770b9ca57fb75bbc1c01aa15": "Dridex C&C",
    "e9064128b55dfaf07acb7aae0fcd7628090082e2": "KINS C&C",
    "e918a56beae75aebdc7aa14a9e782e5d1a19d780": "Malware C&C",
    "e91c1605801894946c0ee40651cf984884f54cb9": "Gozi C&C",
    "e927610a7a36e0e220e6ce54a1f46853c5d44bbe": "TorrentLocker C&C",
    "e94da8a3d6af466be92a0ec023a1a8a506e2c446": "AsyncRAT C&C",
    "e95061ed3d62873c2232c2fce27244978c77b2d1": "QuasarRAT C&C",
    "e95a3388c2a796fbe05ec11e1ff5bcb4b67260f5": "Gozi C&C",
    "e9665d2dcd5b06c8c13daa53d2f0e08b0d27398f": "Dridex C&C",
    "e9675107f7d0f18a2716481a81bd930b7123af30": "Smoke Loader C&C",
    "e96bef097fd16d126b93d117f7108b1f4610e9d2": "AsyncRAT C&C",
    "e974a418a760d43041bfd9502b4b6a2ce8835b82": "Dridex C&C",
    "e975bed42061b58ef76dd44cd69c8e82b039d730": "Gootkit C&C",
    "e9761aa8442c5a77d2d367cb6b4c5b0db97cda64": "PandaZeuS C&C",
    "e97b4e172ce809d5eef12b9963214cd0b71ff656": "Vidar C&C",
    "e97c6cd3030a68776bb844bab1ccdcc5ed8fd5cf": "Dridex C&C",
    "e98bd75cf7e992847dd164397a62dfaac036d14b": "Malware C&C",
    "e9a1283d36d1790a4da723f3183d2061ec099b37": "TorrentLocker C&C",
    "e9aa08bc79edd6ad35a8e06be57644f8735d8e1d": "AsyncRAT C&C",
    "e9c198256da376cc76fb7adf8287bd669fecd3ec": "QuasarRAT C&C",
    "e9eb0cd771b9cecd2782869c1cb9b159b60dd6f0": "DCRat C&C",
    "e9fbf9ce3a3eea7ba2bdadbab163cff2148dc9e7": "TrickBot C&C",
    "e9fee6698c791c33fa36d1a8da3e8073c12fa6da": "AsyncRAT C&C",
    "e9ffe94c89411bcbc58f3a8a3b6368f024367302": "Dridex C&C",
    "ea1702f30ccd285501c0e81101a9dbe83e14d1c2": "Vidar C&C",
    "ea17685cb3c6b4d225a0d1ce213a2f6c2cfde824": "DiamondFox C&C",
    "ea19705164b4c900d4a57c8a5b6c4a10d9cf4541": "PureLogStealer C&C",
    "ea298280acc74a78d90a4f63e1ec994f190da8bf": "QuasarRAT C&C",
    "ea415e004720a18eb6900e6f5d0c6ac072594ef4": "AsyncRAT C&C",
    "ea588ff32f4bce1a85c211d1ba09db6e6bb09ebd": "BitRAT C&C",
    "ea5e48946d37e5d0c456bc68b090616716f27145": "PandaZeuS C&C",
    "ea6b22f882d4886de44d28f97f63aa80e739a4fb": "Dridex C&C",
    "ea84510ce3b3131f42c443b98e17f27a876ecbea": "Dridex C&C",
    "ea8ccb141f7fb5d43e30416c2886fb09353a9c45": "AsyncRAT C&C",
    "ea911df57d64f2fab3d0aad9b5157ec7e7dcaebd": "ServHelper C&C",
    "ea992c0b18a331354a0958a4a6d96b2ead99829b": "Gozi C&C",
    "eaab3ca37694c89d57b921b4f3930bafde022de0": "Vawtrak MITM",
    "eab4034dbbdd510051d9d34d60a8db173c15b207": "QuasarRAT C&C",
    "eab6d2ce07f6a21782322a1c938d13d6db0438d9": "AsyncRAT C&C",
    "eac1fb26860836ab6ec49a9f7f73d4395623ac47": "QNodeService C&C",
    "eac4ced359ad5f028e6f8944069ebb9777bc79db": "Adwind C&C",
    "eac948ef2aeaa042c7e1311e3f36751be33aafed": "AsyncRAT C&C",
    "eacc287e577db99e610432cbcc87597979310536": "AsyncRAT C&C",
    "eae719ff45923073223a8ffe065bb733b2f0f6b6": "Gozi C&C",
    "eafad74bb7ad5626bbcc9cf27cc528a39e4047e6": "Adwind C&C",
    "eafd09fc5bdc3676676f6a0ceed19190ad18497c": "Gozi C&C",
    "eb30fa30a7672bb59fd5f818684f5a1705478f8a": "Dridex C&C",
    "eb31e9096e1a340fbdbfc8a95e97fe21cc8dae0f": "QuasarRAT C&C",
    "eb4b94a0ca9a0ea2675f199dddf38fb7dc8c9524": "TorrentLocker C&C",
    "eb4c033edca27eb686a618f5c66dc3643bc98a4b": "QuasarRAT C&C",
    "eb528589e1b42305c6780a059609b89b9079b7f7": "Gootkit C&C",
    "eb599d1177ef6d64a8b4927c0b010e575eec0598": "AsyncRAT C&C",
    "eb5a14fab223ec62ca25069e1e9368c1bade62f9": "AsyncRAT C&C",
    "eb5a22da952b36782d45164e66e9de9cf3d79226": "TorrentLocker C&C",
    "eb655bef01a970ec00ff5b3bbfaeae96b8027a06": "OrcusRAT C&C",
    "eb73bbbbda71d50d1a25502dace6227465ca597d": "AsyncRAT C&C",
    "eb84133c8978541c09ace6044728e621add30726": "Shylock C&C",
    "eb865ad6ff29405552f768c33c3acc4cb8d9b7dd": "TorrentLocker C&C",
    "eb8df50d4ed4c4055dbc4601c3f3ee314f602168": "AsyncRAT C&C",
    "eb929908c56efbf6d9ef1a606f15aff728cfcc77": "Gootkit C&C",
    "eb9520fcba1066dc55658bc8b1bb81255822a605": "TorrentLocker C&C",
    "eb98f00e43e7a132e53f5a2d03208d4758e40b56": "Dridex C&C",
    "eba05a715c783b03874b0ec34db4210c613a118b": "Vidar C&C",
    "ebb1d5b5cac9c0c1c256a8e96c4b387dfd1083b1": "DiamondFox C&C",
    "ebb746f9e966d952191f5e2b300b98282137315f": "DCRat C&C",
    "ebbbb605447acd812b22d5911c3c310a3784c598": "IcedID C&C",
    "ebc29e39378afa480aef794bbb6e89b4abd5e516": "Qadars C&C",
    "ebd99519da72873ae03f9210996f49af6b169fa0": "TrickBot C&C",
    "ebdceb4038c9481d120e2f2cf6e6faf202ebd1df": "Gozi C&C",
    "ebeeb7386aab769f4db88fec70322eac46a229b0": "AsyncRAT C&C",
    "ebf5c5c613400d9b168b711395e8c5a6a1647e6a": "Dridex C&C",
    "ebfd615c3ce5d98749b64a7cf676fba0000d572c": "PandaZeuS C&C",
    "ec08892079475eb36c230465f69d26104f05077c": "ZLoader C&C",
    "ec18e0406f3eafa3eed3caff61f59e2e5ce26fff": "TrickBot C&C",
    "ec21cd3a9b2d4a0a5dc6d18c714bf4eab92213d2": "Chthonic C&C",
    "ec2cfd443bd46769cff78138a95f884f32726387": "Quakbot C&C",
    "ec3fc068bc4418a63e2406bcb8674aaf11408b50": "PandaZeuS C&C",
    "ec5b81f7e1eab37fd7d66172d88ef691fdddff06": "Dridex C&C",
    "ec5da21456fb52c583f42cadd3d1012f4a10ac42": "PredatorStealer C&C",
    "ec8157af1fabc64a3b31e7e684a11775b5b60874": "DCRat C&C",
    "eca6d47e511e72aef8130d3b0d0c78cea0aa2d30": "Quakbot C&C",
    "ecbcd841f33ec6a40a26f3ff77e0e18f8a7e4949": "njrat C&C",
    "ecc658862ad72dfa143d7c2426521a54f666b9df": "Gootkit C&C",
    "ecd6ec44a30b047d6e75401202b220a7648bd4cc": "Malware C&C",
    "ece2719a4d357e7ea70024f651af8d9cce43256b": "Dridex C&C",
    "ece42941d00448379da12bf1e532f3b968d28e95": "KINS C&C",
    "ece6be6f19ffb87666a86600c5fdb5a5cc82520e": "Gozi C&C",
    "ece782a88b9378cbbfde68e04c05dd38d3a0c083": "Dridex C&C",
    "ecedfc674b724569c01c4da4536fd7f8ed60650f": "Gozi C&C",
    "ecef03ad9fe7b88142526bcab52978136f95db1d": "TorrentLocker C&C",
    "ecf0bd4a55d1343ce71f55ed5e46bf6afa08185f": "AsyncRAT C&C",
    "ed00e70602b2beaf8e3f47ff645abe7e92897d3e": "OrcusRAT C&C",
    "ed087e5e8b6ee08c50a20b0b3575f1bdc1ca59f5": "TorrentLocker C&C",
    "ed0c166e2af7f79874a89c97d038349e10e9cea9": "Gozi C&C",
    "ed1161f81ddbd9a02642d45610b27daed2a4c5d7": "Dridex C&C",
    "ed28a9c76b5b20605b2de661dd64e643d7a0290a": "Gootkit C&C",
    "ed2b5ba7e14516e39c0202ac062695e6b0484a89": "AsyncRAT C&C",
    "ed652d410d5bd72634fc2660982ed2da1694d4b5": "KINS C&C",
    "ed766b757fbef9bf965df3eb98123ebfa17eee87": "Qadars C&C",
    "ed95a99ed1c548d8463698889f2e113ea54346a9": "Malware C&C",
    "eda1c1288cea6b372ab48f92a6c7fad782f64e50": "Adwind C&C",
    "edab543dae2094567a5f48a2ca2d7d9d34084110": "BitRAT C&C",
    "edb88dd3be674a9cf4850f4e40325681b6aac8d3": "Gootkit C&C",
    "edba78e217edb77ecb17d46f62bf75f35edc6e69": "AsyncRAT C&C",
    "edc89e34633002830525537ccc2fcf65ab2f43dd": "Adwind C&C",
    "edcc103bb4e46e06335f27c6a17a4d9019b5303f": "Dridex C&C",
    "edd6ac43ebc2449f0c318c4b49e0e1786ed801c8": "PredatorStealer C&C",
    "edf8ab0a1c4c29dee09581fc8785387278227377": "Quakbot C&C",
    "ee00d6e4e629498cf1aef0d744973bdf09053674": "AsyncRAT C&C",
    "ee02f43eda45754325ccc2227709228eabdf0946": "AsyncRAT C&C",
    "ee073debe88091b53d409011900b7ec283b2572b": "QNodeService C&C",
    "ee1227280b5be831cd0d666dd36fb4b40978a610": "AsyncRAT C&C",
    "ee14e4ab0b243b397315e094935f5b74a67a1bc7": "Malware C&C",
    "ee195bbb70b4baa1067df4b363ae58a7e429f53a": "Quakbot C&C",
    "ee1cf7039a792a953ad0aa335033da8d0d1622b5": "QNodeService C&C",
    "ee4b052c626b1cc9137588349626d10798b2000b": "BitRAT C&C",
    "ee4d6411bc8a56610756ecf6c82217dfc9608528": "TrickBot C&C",
    "ee539b1e90a8db4d00793bef1f1dc57e5aba9706": "Dridex C&C",
    "ee5d259b2cd5fcd055b6634e8cf56280952c2e4a": "AsyncRAT C&C",
    "ee5f2943516bf23b75353ddaa9266aaff982d3e6": "QuasarRAT C&C",
    "ee6def59cf1e0cf36bb4c237566a5c22a6fd681e": "QuasarRAT C&C",
    "ee73d4ae1daad868add728adae3d58487a4d67d1": "CobaltStrike C&C",
    "ee7b36e2e454b4ea28aac43af0a4621198823fb9": "PandaZeuS C&C",
    "ee882e313d72643dcda040cb6754ccc7ac79d95b": "AsyncRAT C&C",
    "ee8a023b40b244bf8b1db9bbd54c82f892544de3": "AsyncRAT C&C",
    "ee90552bae63b3f8c874bb66a96e1f7bb1e0a595": "FindPOS C&C",
    "eeb18010fb1a8261ed1aa51a202c59a577504583": "Malware C&C",
    "eeb56d5c76d0c5455c34b447e30d200db67c982a": "TorrentLocker C&C",
    "eeb6d6641adf1d480fa1de96517497c3db50784f": "QuasarRAT C&C",
    "eec7bf78cf94a4f7f75c64bcec4a2c4dcd260eab": "Quakbot C&C",
    "eec941e2c867349dbaab786768fc82494d5275e9": "AsyncRAT C&C",
    "eecfab4c2072e9e1e31bcc7104bf6ac834e1d5af": "IcedID C&C",
    "eedb481d5e2cf73521022a6f7878b38000fa5e42": "AsyncRAT C&C",
    "eedeee244ad58bb62a9ea02c779efab8cbecc4c0": "Dridex C&C",
    "eee3799af1c7db6e28efc941acda1a1788d74a47": "AsyncRAT C&C",
    "ef054f54df0fa67fc454bf8894c643e44c28ec3a": "DanaBot C&C",
    "ef4977b906349caaad8afa2a8884dd2950efda5f": "Dridex C&C",
    "ef4d210c9777029a7292b6bd4477a99e6a02eb27": "IcedID C&C",
    "ef511b0001aec7af20b61afff7ff93b30fdb1d66": "Dridex C&C",
    "ef5c968aaf51839c90964c17a98c054c7b69b93d": "AsyncRAT C&C",
    "ef5de08d65ed0629fc7b95bffa22c2c62792d3dd": "Dridex C&C",
    "ef87ebfaa1a3eab641cb602f6d7eb1254549434c": "OrcusRAT C&C",
    "ef88a82ec4d853edf84928a5bacca4eac84cb5dc": "PandaZeuS C&C",
    "ef94f05498c7bfacaaf37456687032cb2b018238": "Malware C&C",
    "efa8c5eba6b4d0a74faa9ba835b24bbe3b01bd99": "Malware C&C",
    "efb9ace87998a21cc93613372f3868bf3f2c0c1d": "BitRAT C&C",
    "efb9eba14b8210a27a72d7da4550ad4445dc5024": "Smoke Loader C&C",
    "efc4050b5558b33cdd6b29c1ef6c9b0acccb352f": "AsyncRAT C&C",
    "efdbebf3f09c23873aa25c78cf5aac95e29ea7e6": "Dridex C&C",
    "efed79af32bfcb562d939563a5df85edfe418b5c": "Dridex C&C",
    "eff92af923295b894bf7b9a665784932bd73e81c": "Dridex C&C",
    "effc708c695fdd28da3e431c9c4d0b7d266bf7c8": "QuasarRAT C&C",
    "f00c4d0174c724bd69e4563efacb8e7f59a12d08": "AsyncRAT C&C",
    "f03ed035457bc131924f77a46599014fafc4bc9d": "ZLoader C&C",
    "f04a75e6507173faeec2bb82c564030a5e8413ff": "QuasarRAT C&C",
    "f05a898b08ce2bb63a4fa93c114cb0030fda03e8": "QNodeService C&C",
    "f05c0f5bf63997cb291eab492e336feb87328c01": "AsyncRAT C&C",
    "f063c1ed34c8a40858daf998d7471f9634ba617e": "AsyncRAT C&C",
    "f06cb2a949fe4893177700d0f7b7daeaa7e10317": "Quakbot C&C",
    "f0792a659b32fc570aadfcccdb8d930912ccf852": "Shifu C&C",
    "f07c0a8746068b5aa3119573de520ac3108993bc": "AsyncRAT C&C",
    "f08825aefaa296a6417e87ae67cf04af7558e3e1": "TorrentLocker C&C",
    "f0925571285e91bd7b58166ab1359aaec8cc8698": "AsyncRAT C&C",
    "f0a9253de5cb31fadc1c5f2e652905f50227e576": "AZORult C&C",
    "f0af9505c7af2bbfdf1d12aefbb7a7932205715f": "Quakbot C&C",
    "f0d7ca0b90d65db65b85dacbe6267dbe2325bdf1": "AsyncRAT C&C",
    "f0db8bdc4a5f125beacad8a3c6f20e7f018154ba": "Dridex C&C",
    "f0f4f439f64b13a44c2a749f0e95215abb294de0": "Dridex C&C",
    "f0f6302824cd73b2c8b6dd8e0cd325a3ef082409": "OrcusRAT C&C",
    "f101a8c2dff89362787a05381d96d130ebc02242": "Quakbot C&C",
    "f101c985f53d55e59037e32a90ca13d3a8855318": "KINS C&C",
    "f10c0a99cc1e1e5b8fdc8913409764a8dc213547": "TorrentLocker C&C",
    "f10c6f69a0252454792fc3cbcdd7f0e7bab3bb2b": "Malware C&C",
    "f13000e52367dbc28219025ec5e055c3350a4961": "Quakbot C&C",
    "f13c6501f6083f867574dfe86f04d95299d62b0a": "ZLoader C&C",
    "f14a785961f855f5d0802c5f20429a848f36acee": "Loki C&C",
    "f14af0229c29e21fbef5139f80485406c4cea9fc": "AsyncRAT C&C",
    "f14f1a83eddcdf14668e6f09426fc272d71dc371": "Gozi C&C",
    "f1533c0ec844fade128d25769dad0ca82ed338bd": "KINS C&C",
    "f1a82aea2322a8d4cce5eb6299a9bbde0943d800": "TA505 C&C",
    "f1d7c7947e3b966f6e627afe850fa01f835629e4": "QNodeService C&C",
    "f1dcb808f157215037a27642592500e2e8686c4c": "AsyncRAT C&C",
    "f1e4897dce73c9ee3e0523478c8f879372c0d700": "IcedID C&C",
    "f1e60bd93b0a19a6399d767e107f2d02adacd66a": "Shylock C&C",
    "f1f25bdc25e6247a9a53048c739acda60d750653": "TorrentLocker C&C",
    "f1fd92d5e4896eeeb923ac166c4f6553d76c539d": "AsyncRAT C&C",
    "f200296e058946933ff59162254c95d6a1ff1456": "DCRat C&C",
    "f214ddd5319caa664a3e30d96ceef116cfd95c63": "Malware C&C",
    "f21e8fcf83ba4b782a498f1c793fdd97916c6ff1": "AsyncRAT C&C",
    "f225e343f00efec291515b68b047db70519520bd": "KINS C&C",
    "f23d337652f355a469c3388fc88ba4b77c6e50e1": "AsyncRAT C&C",
    "f23f07fb0de5729e79b29b4c205d392b45dc98a9": "Quakbot C&C",
    "f243f6f587b936a6aab9951a1e0b97adaa5c2d9c": "OrcusRAT C&C",
    "f246460f048c74e514edc8cb6373e1bcde348197": "TorrentLocker C&C",
    "f24a1b37675f3452223f7c3fd731095c5da0dc87": "AsyncRAT C&C",
    "f25978bd8f6c897bea29bcbeb5daa0df8bb57f36": "Shifu C&C",
    "f26629995e1cde463b8e3db3de0cd81b334d03e4": "Chthonic C&C",
    "f26e1b10fdc41c569a7fae19b8f84643641297a0": "VMZeuS C&C",
    "f29bb1e3b919be7cafbe9cbbb27534257801af7a": "IcedID C&C",
    "f29e953dd278981877ae7b5368caa537856ae9f4": "Dridex C&C",
    "f2a1187d0e02b43874a94e37a6364ec5cfead80a": "Dridex C&C",
    "f2a61975cb541e6a62ed8ca5214020108d922a14": "TorrentLocker C&C",
    "f2a83f927aed31c0bc384884f932ea4aa96b2182": "TorrentLocker C&C",
    "f2ab363cc49bb125b0a36ca7cfd1ba8f5070d98e": "BitRAT C&C",
    "f2ae85469857271d455b6148d9f5873c16a9f6fa": "AsyncRAT C&C",
    "f2c0bc0e8aa1b9585f701db253d841dd8e30ac4d": "RaccoonStealer C&C",
    "f2d616c7a3ccbb99386ef61e4d43568c8b9b7f2b": "Gozi C&C",
    "f2d69e0ea5126b24e6917becc1de311eefdb4224": "AsyncRAT C&C",
    "f2ecfbc7bf355c45940ceeb5565450d95d6a666a": "AsyncRAT C&C",
    "f2ee4103e822987d62741e6df119d0fe5c3f0c60": "DCRat C&C",
    "f2f10a25f4d0d0543f5520c8c8bac500da1b1ac1": "QuasarRAT C&C",
    "f3199712226de38042c0a765a4889eb33e8d52bf": "OrcusRAT C&C",
    "f323232b41a18c9e75bf57a169a3b12d04197697": "AsyncRAT C&C",
    "f3360e039f069d0a5c4db8e848bdbf1a8bff461a": "Gozi C&C",
    "f33df712502bb0ce4b10d8d0846a267dfc6bfc68": "PandaZeuS C&C",
    "f33e94d143f22076d203382c011d129d93a01968": "Retefe C&C",
    "f35026cf90e2b76b8b74d945bf191fcc02c3bdc5": "PandaZeuS C&C",
    "f354fb31b50a0d8cd14d1ad012e5d35de07e021a": "Dridex C&C",
    "f355d0c78e9bf18767bb7156cce870c0ac2b883d": "AsyncRAT C&C",
    "f3599d7b0c05c035a831db2d89c8ebb616fb407d": "DCRat C&C",
    "f37110e51bac1eb72cf46dd309bf8535e76ada28": "TrickBot C&C",
    "f3757b64d9e4312e6b044cb20ee17507ca8923d3": "Gootkit C&C",
    "f377957491458ac8b16cc2ca13b305e7b18f99a4": "Vidar C&C",
    "f389a4bcedc23ede90056191548f5fac03bd2b18": "Chthonic C&C",
    "f396ac0ee9196554d78eaac055db54241c882a6c": "AsyncRAT C&C",
    "f39fcb3309f8789dbaf15b8907b2cf1650314123": "AsyncRAT C&C",
    "f3a3b0161112b341fbe6b3e0f785eccd76c35e19": "TorrentLocker C&C",
    "f3cbcedcbd89b6116ef5d61ca370b65958a076a8": "TorrentLocker C&C",
    "f3dc18df65884efceae09456e79930e6620d4df3": "QNodeService C&C",
    "f3e85ec8d7b20e45b9cc6491bef098df78bb17cf": "PandaZeuS C&C",
    "f3ef76781aef62dc1805bbddbdf38f57ee3fe1bd": "AsyncRAT C&C",
    "f405f949fd0935cab166084497433f66e0a19318": "Quakbot C&C",
    "f425dbd2bf772369c1a4606e4cc34baabffd6420": "AsyncRAT C&C",
    "f431164b5eeb0f2039dc684c8020e6c02c3fb579": "CloudStalker C&C",
    "f4387c38ff9e46dfe3480728fc5026c61e4878ed": "Quakbot C&C",
    "f457078aca7b2b936f2a91870c7729aed613fb80": "TrickBot C&C",
    "f4668e519fd9b6be8ef09cc3e5364bb0c34915d7": "Rhadamanthys C&C",
    "f4672fc446ef2d54265a20c390134a241419999a": "TorrentLocker C&C",
    "f46775f73c71cc9dae509e137950f308becab4cd": "AsyncRAT C&C",
    "f467d794b2e1081b6ad1ead5813afa74f053248d": "QuasarRAT C&C",
    "f469e0748b13286edc56a24c56b7e34bd376c3b0": "AsyncRAT C&C",
    "f478d66531d8646653db068c3b2a3b54958f28c3": "AsyncRAT C&C",
    "f48552e08a2e56b11738285f406eabacdee550f0": "Latrodectus C&C",
    "f48794cf898bb4c5b6223d4f472d7c5e4ad2ef9d": "QuasarRAT C&C",
    "f4884b0ee68f737d759e8514bbffda20a1eaf01f": "QNodeService C&C",
    "f4b17cb0f16ee87daf9d0ff5d81fc7b8f0ec6cc2": "Quakbot C&C",
    "f4b3a12d75ef34ed1de748c4daa7d35c525bb690": "QNodeService C&C",
    "f4b6202325103d6b2dadf0b80f030c05b5936052": "Quakbot C&C",
    "f4ba5e191d9e312902c7b49d085cb11fa16a961f": "Quakbot C&C",
    "f4c720ff5cece4eb369a1d2454d6f6234baaf2f5": "BitRAT C&C",
    "f4cb7c6222ce7480d378dc4e123ab1804c7a6249": "VenomRAT C&C",
    "f4d0e0cf532af45c502f64d18471ad76189f4a33": "Vawtrak C&C",
    "f4d25d53ac68ed0f7aa167faa9e45c3a5f81a6df": "QuasarRAT C&C",
    "f4da4dc373196c20172e4ca70d49a8e7b354daf9": "AsyncRAT C&C",
    "f4eb3c7de03b77768ba30ab3544c8790e546514f": "Gozi C&C",
    "f4ef6300b5cd5f9653c537d50d39f0d6e166a493": "PandaZeuS C&C",
    "f4fc70a7d2f52bff0fb35838821a51f8313936e7": "AsyncRAT C&C",
    "f50c118b695c9c911e6038885cba371732ec05ba": "AsyncRAT C&C",
    "f51918bbc32a6dbe2b3c4f3464b247435a2f064b": "IcedID C&C",
    "f51bdd17aba2001468c965ed10d501155cdacca1": "FindPOS C&C",
    "f51dd2f792020abd27bebc92a3226763c29793ac": "AsyncRAT C&C",
    "f53a1e3c317105f81c62ec899e915487598fe696": "AsyncRAT C&C",
    "f53a5c0e2c9f9f1708b1cf27afcd72cc167e842d": "Gootkit C&C",
    "f544c9829f107dc7cddc0d188ca6b121b8e63726": "CobaltStrike C&C",
    "f5572061fe5bf2ebfa3760c0c27d8149270c0b48": "OrcusRAT C&C",
    "f5594567de0afd129975b093a0f1881ef9383b3f": "BitRAT C&C",
    "f5639b20d13517445e5dfb6c01d1f24df616b034": "Gozi C&C",
    "f567ee512ddc88b8c0efc24a25f3613197c55a02": "AsyncRAT C&C",
    "f5799d920dc1e434b08733d379d8b2859a00ca24": "IcedID C&C",
    "f5878ad786db5c252c138904e8a832f58cfe46ca": "AsyncRAT C&C",
    "f59233b59e8f4667aaf84790c2f07aed41031f79": "AsyncRAT C&C",
    "f59262b53a42cab38cc614f5ab41548fa296a252": "BitRAT C&C",
    "f5999bffa70a09d8456c49e3f6fc6bfd6866d71b": "DanaBot C&C",
    "f59bca67271ee10062e5e532d0d9b118b65ac880": "AsyncRAT C&C",
    "f5a5b70f774536d601ba60820fab92fa609699df": "AsyncRAT C&C",
    "f5b74bd5ce11a611404d6c91113f47f69243e1e9": "Malware C&C",
    "f5c1535a672aa62647a8ddb8f35dda7be9d683c1": "RaccoonStealer C&C",
    "f5c3dbe6ccd9377820f42c7500ab9b85b568d55a": "PoshC2 C&C",
    "f5cf905b05cde4a48c0f525f123c8bfbf08cc366": "Malware C&C",
    "f5dffb463d8a2c196d64d3fe62c69b5fc8104adb": "BitRAT C&C",
    "f5e2b67a1e9249abacd04f68369b2a0dfb0b4fd7": "KINS C&C",
    "f5e5fc537991ac80eb8b629495bc0a686b718f44": "AsyncRAT C&C",
    "f5e726ccfd64dfa4813f1038fa54429c4950ffed": "OrcusRAT C&C",
    "f5ea2dcdef5f82e660f44fc5871dd507aac7478b": "OrcusRAT C&C",
    "f5f839a5a93a49c897024a25b6e413df006d88cb": "AsyncRAT C&C",
    "f5fd208c44a7403367bc23154b7d829e11fa47de": "Gootkit C&C",
    "f5fe9f02ba6eb35af43ccd1688a9ef6a403f8cfb": "TorrentLocker C&C",
    "f60112b49d8bfffeb9ef6082122a6b889c9a0a71": "Gozi C&C",
    "f604c80d2c60cb6b9edcc340551107841a74b8cd": "QuasarRAT C&C",
    "f62a9d0dba6d398467f37ae8e272d6c269d7eb5d": "PandaZeuS C&C",
    "f6426325d383179f4735565108cf1f247888a8b0": "QNodeService C&C",
    "f64526f0b8a4b26f0916a1fbe4bb3f575b8ed2a2": "AsyncRAT C&C",
    "f6539af4039bea25bfd1b3f67847fec8e85a3e29": "Dridex C&C",
    "f6541a4247de1d1026533a3a9b942adde5469233": "PandaZeuS C&C",
    "f6578ed18da0aa745926a909e681dcca56eecfb1": "CobaltStrike C&C",
    "f65838a98e2b13fe1e67648d8ddbf911bae2329b": "AZORult C&C",
    "f66cdd6a149413297115eeb728a9d4fbe725a47a": "IcedID C&C",
    "f66e2e8aa5838d391c490f70f23a6b34488323a8": "Gozi C&C",
    "f685d3972dc7c57e11aa54332238af1fe6e83275": "Dridex C&C",
    "f6894f8d4eeb48cb810d8be4a6b0e333a11da617": "Rhadamanthys C&C",
    "f68b61241b49e37cf0a17547cef742f16a595fea": "Dridex C&C",
    "f68d8f96e17431fa23f2f88195bd09b26e1557ce": "IcedID C&C",
    "f696b1943c1527bf1ec6c70346a6f0a820e73cd3": "Dridex C&C",
    "f698f10db075b64076e74161109e3320bb1ea92f": "TorrentLocker C&C",
    "f6adcf0d68265b5ff027caf52cebab00a664b7e5": "Quakbot C&C",
    "f6b37e5bcb5e86a46d98a3de6e6f1107044241d7": "AsyncRAT C&C",
    "f6ca1dff4431556f5d775676a4005d1b1abd97f4": "QuasarRAT C&C",
    "f6dac339e16f90b84d91588e7f581f35f20de2a7": "AgentTesla C&C",
    "f6e38442d96771a06547780e07fc2b5000cbb419": "Gozi C&C",
    "f6fc6088f949b341f472e152d71820af45ea8b6b": "KINS C&C",
    "f7051a8eb27edcf741a3f2fd0345e927578ea893": "ServHelper C&C",
    "f714e0b51845830d795277499a42912ba8c39f0e": "ZLoader C&C",
    "f71b355ed821a85085246720a415ce7eb060c388": "AsyncRAT C&C",
    "f7211b188b6a2341b619d60e99be44891898aacd": "Dridex C&C",
    "f727dc37c0a7d9e387d05f8534017046e72ebe72": "Quakbot C&C",
    "f7321dd6676d831daa9bc737068e222200f76115": "AsyncRAT C&C",
    "f741762ea8094a8d95ad84baea0d42e80ce584d0": "Malware C&C",
    "f74a5aedcaae8a110b36254b8df7a68c1a652c8c": "AsyncRAT C&C",
    "f74e3571bd6ba6680efe3d4f2aaec2ccba60e5a5": "Gozi C&C",
    "f75f189d71eabad87eb88818f566a1ea96da0c67": "Dridex C&C",
    "f75f6e5037f2c907509abb67904c024d87a8a0f0": "BuerLoader C&C",
    "f760eef17a056d0dbca8ffa7614ac2965997f8eb": "BazaLoader C&C",
    "f768990781e2a6d9b90313c7c6714bedd1ae162a": "AsyncRAT C&C",
    "f77133ad6a4014c92a13b38c306a737279e074f5": "BitRAT C&C",
    "f773476458ee9b2725f2c0a93804828b44690c7c": "TorrentLocker C&C",
    "f776077e937db280ce77eacd06121c7368da99d5": "Dridex C&C",
    "f778c57a703a49c5a55fa1ad06810067c403fae9": "Shifu C&C",
    "f77e84d10ff0b293b6c707b9bb79bb0acf8807a6": "OrcusRAT C&C",
    "f799e48221b5cdb6fbcaa46f1921a45fd0c15b84": "Dridex C&C",
    "f79bbe932d59f4c503a5338dbc3a24dea7c2f6ea": "IcedID C&C",
    "f79c19e965cf8f5066609140848c632eb87d337c": "DCRat C&C",
    "f7c0c28f368fb8281b04cb0306d9164a76c3c8cf": "AsyncRAT C&C",
    "f7d2cd5ee6b1583e78999113e8ac25282aa08a36": "AsyncRAT C&C",
    "f7dc34b2bc79658ced26b34cedf9703d384caee5": "PandaZeuS C&C",
    "f7e22d41301d7334c6464d4aa33fdc83c5c337f8": "AsyncRAT C&C",
    "f809a5697c17b157cddb6bcd35450dbb44168b02": "QNodeService C&C",
    "f82408fddfc8965d47e58f24259d0087028770cd": "RedLineStealer C&C",
    "f82e93d608e6a88c95360e1b9275f8b5a65800e0": "Malware C&C",
    "f84307de52052eeb50b72a9f3bcb8d9d250cc97a": "AsyncRAT C&C",
    "f8516d89a1dfd78bd8ff575bbc3ae828b47ff0e1": "QuasarRAT C&C",
    "f855db1014914807b338faa5fe7176271cee6f9a": "AsyncRAT C&C",
    "f865e16729af458b4a1ed832369c314bade948bf": "Dridex C&C",
    "f8681b1d329874e6b9be2dca072029dc6080bd1b": "AsyncRAT C&C",
    "f86c17234efffe588cec4448ac39032a5eb617a6": "AsyncRAT C&C",
    "f8743c5280b0d0f839092c972874caf3979c37be": "AsyncRAT C&C",
    "f87d2aff4148f98f014460ab709c77587ea1e430": "QuasarRAT C&C",
    "f890d6bc8790a29f913cb4b6a930370c38089a25": "Quakbot C&C",
    "f892b793a99d67d6cca8726b06302a441665c417": "Malware C&C",
    "f894136ef78994874de3b3de9ce257e308f303a8": "QuasarRAT C&C",
    "f896ce865434a5cfb5978f054f2aa949d05aece2": "KINS C&C",
    "f89bfc5c43a2d82b629fff3602378865df670f4e": "KINS C&C",
    "f89d3c496eec13be93706fbbdc0bdb745e44875f": "BazaLoader C&C",
    "f8a43f9e9e5c1beaeeda0a1abd27082a8056c759": "BitRAT C&C",
    "f8ad61e50c4ea7ea89cf3dccce6c78b892fc32f9": "DCRat C&C",
    "f8b043c2f0c348ee54e457bbbc4de92e7c326857": "ServHelper C&C",
    "f8cfb4790cd5b27105eec56de9dc2e2b5f4dc846": "Gootkit C&C",
    "f8d6eea111ec7c4c7b53024132caca8697fcabbd": "AsyncRAT C&C",
    "f8e77b396c9e89d584ecee41817b40541e957af0": "Dridex C&C",
    "f8e9976730d2d4efb2226cceb6b6417ff589d411": "Dridex C&C",
    "f8f7060991e73930cd564e5401396637f95c92d4": "Dridex C&C",
    "f9153b74105d6c51cd6347a3ea341d737def43b5": "AsyncRAT C&C",
    "f93a7f2ca1463140ca6d7ef4cd6b11674e869fb5": "KINS C&C",
    "f93cc7c5582ba57a77a8d429962898f2d08d82b7": "IcedID C&C",
    "f93db08ab840ecdd6239e33c565f5b78c3eae9c8": "Malware C&C",
    "f945cf93a3c6ab8550580fc9d8b748af12c3c607": "AsyncRAT C&C",
    "f95b24250003784f2a9597fc8e82add3ed25cf2e": "Quakbot C&C",
    "f9671b15d5b42172934695b6149a6f1c6b0485bc": "TrickBot C&C",
    "f96d5aa2bceea3e43c00bb45aa1ab148beb45b09": "AsyncRAT C&C",
    "f986e8fab555bbdb969ff24c488cd96609435eec": "Vawtrak MITM",
    "f98c646563eb13166dde4c922127a2f34696d1ec": "AsyncRAT C&C",
    "f98dfa3174ff9c4d465529e7e61f539c22674835": "TorrentLocker C&C",
    "f990198262e831a41879ab783eb7352696caacb0": "QuasarRAT C&C",
    "f995d2f8aec2f61df3a20c1f793fc3bed7ad8b17": "Dridex C&C",
    "f996f87d9052a7b6442bae488ddf15167cdd0a56": "Gozi C&C",
    "f998724caaffa66543e2850f525eaf191eaf1d47": "KINS C&C",
    "f998c19b07823d60d41fdce3407c277bcf63e0cb": "DCRat C&C",
    "f99e33b912b9733d99164d369c68dd76c1c7d248": "AsyncRAT C&C",
    "f9a6898fac27e139aa9ac3a4617e48f715e99b02": "CobaltStrike C&C",
    "f9a8253885ecf7b6003fe0e1371826936c05eb69": "AsyncRAT C&C",
    "f9aa3ca3b2abfc708b53501d4f986b64257be1e2": "TorrentLocker C&C",
    "f9b6531c4b8f43a8a68566db27eaf9b4b142871b": "PandaZeuS C&C",
    "f9c06ebd728d0a140e4d899adb95d97693445c2b": "Dridex C&C",
    "f9e82ff9dddeb318b6fe97ffb81764550a30341d": "IcedID C&C",
    "f9ecde7d48112d23a75ba94384d4899d4469866c": "DCRat C&C",
    "f9f3225b7b9ea4ac044289ffcc8a33ee3bdfa6ef": "TorrentLocker C&C",
    "f9f475501c6d2b1102a497eb1c3d52c90b8e007e": "QuasarRAT C&C",
    "fa04ad171528f9b716687c2912a2257b37bd4eb5": "Malware C&C",
    "fa30aaba5230377978455bb72794685ea4fcedba": "AsyncRAT C&C",
    "fa310de69957a073acb83219ebead3d3d8c2b380": "BazaLoader C&C",
    "fa3a5c9293dc2cd6de534dcbbf760b299f7abd72": "BitRAT C&C",
    "fa48731cbf535dfc43a3d42d3207e586220066c6": "QuasarRAT C&C",
    "fa504d7ea166b627d83838be08b808eac9381dc6": "TrickBot C&C",
    "fa586b92b3b786ff687184d1f08f7c2cd8f6beea": "IcedID C&C",
    "fa58741307705799bcd1e93b098580acfe9144dc": "Quakbot C&C",
    "fa5b710a9ba10d17ec4cf0f92262ee5afc9105bf": "AsyncRAT C&C",
    "fa5ec7359562e2d9d49170acaa10d53de7441946": "Gozi C&C",
    "fa629208abc9b9a2d9abc1b20599d482919f014f": "OrcusRAT C&C",
    "fa6920253a9383bdb026dc293a846aad6e756a23": "TorrentLocker C&C",
    "fa6cd2478a9a318c2ff83df132b75b4be72dab28": "Dridex C&C",
    "fa77c94345ed233853ee8209d8ebb6a391f8c5cf": "Malware C&C",
    "faa40cd85fe4f3143637d4372dfbaead0a242688": "KINS C&C",
    "faabeb0cd9bf15b92a6320b35bbce86ea8a1d0de": "ServHelper C&C",
    "faae5e0eb641f1eb53021a6d1b38b9fdcebea8a4": "Dridex C&C",
    "fab4de47f943eb411798dcbe937478dd76881e73": "AsyncRAT C&C",
    "fab9d15d8f2eadbb8f75bcce152e1cc7d73ed8da": "PandaZeuS C&C",
    "fac23c758897f59024566afdda8d9e6c98bb2d60": "ZeuS C&C",
    "fac2ec250de2ba8f8c775cebd91f81490f0a1018": "AsyncRAT C&C",
    "fad40ce0ba6fe331bbb7aefcaad269d8bc865cb2": "Dridex C&C",
    "fadb5240cc9b7283c436a6039643d9593dd43af1": "QuasarRAT C&C",
    "faff798e6eeb919255d3d36d461d46dd3fcc2cf7": "PureLogStealer C&C",
    "fb08b629defd129a4699774ec60b5005809eabad": "Qadars C&C",
    "fb0cd73b2589efa2bc1c7b3202aec07b36776207": "Quakbot C&C",
    "fb0e13607d045047c29ab44941f450950a349dd7": "Rhadamanthys C&C",
    "fb1b7dd8d8271011c9d579466b212bb54f6ca7e6": "AsyncRAT C&C",
    "fb2615624b31ec998f5a706de5f8739057beebc9": "Gozi C&C",
    "fb2846a2dfeffb12173a99426522f6b3f5c4c574": "QuasarRAT C&C",
    "fb3389b61b0e38560257a0fd76d5e0654b5b7ab6": "NanoCore C&C",
    "fb42775b5f117a0c940cb7d565a533696c6a925f": "AsyncRAT C&C",
    "fb4698643f78dbe5891ddd3229c7f8510ab8ce2b": "AsyncRAT C&C",
    "fb4c4855c6ad0ea22ebf94e531fe56dc61674273": "AsyncRAT C&C",
    "fb65e6176c22527101f65e123884dc55b3aa8593": "Gootkit C&C",
    "fb679d304a02bf0bf5040aa703c91b7238cdebb6": "Dridex C&C",
    "fb74ba4400a38914190a1d219f98741f67c121b3": "DCRat C&C",
    "fb78dc77f6dbe6c172c20d9ca9acd62e08f23fac": "Dridex C&C",
    "fb7e70ef2f34e48587b55bf81491fa449a805b0f": "QuasarRAT C&C",
    "fb7f14edd75f0686da73299d811f5d0c17c9c29c": "Vidar C&C",
    "fb8257cebe0ba267c25926c7ac59faa0cf70e765": "BitRAT C&C",
    "fba223148f25793aea78693781f3a9bb15a1f1e1": "DCRat C&C",
    "fba3fded7431cf442f6dc0e6df956c7bc663bfed": "Malware C&C",
    "fbc551bfc06f94f9460eab402137685b565f3985": "Quakbot C&C",
    "fbd2d6bf48f2f51451ceb46924d2e513767e8215": "TrickBot C&C",
    "fc06d503eb3849a3067f32d76ee224cb83df91e8": "Malware distribution",
    "fc0b2669cfda6d3f2c77be2c905c3286456e2ec4": "DCRat C&C",
    "fc0b6fb8e2b3b6389f4cc2a8430abd24328f03fb": "KINS C&C",
    "fc104d36d3dda98cc051074379cf4832ac048998": "FindPOS C&C",
    "fc178be5340e49c42778f3635a6d289ca22448db": "KINS C&C",
    "fc28b566b4a33cdbda415a6d83fd4e3369f098b6": "BitRAT C&C",
    "fc3fb557672e1794e4d79feb7dd7cce5b522ce36": "Dridex C&C",
    "fc491372e253cf8eb59a0b90fa725a0dce31eb9a": "TorrentLocker C&C",
    "fc628767558fabf9a5242733cfe792f9863f933d": "AsyncRAT C&C",
    "fc67ab8e0f635f00d8ea556fd98c0f5613057b56": "Adwind C&C",
    "fc6feb229dd7fb9c4afd825eb8087b51157abfe5": "Vidar C&C",
    "fc72a8a7b467b276324d9231c9e45fc3100c0cdc": "Gozi C&C",
    "fc7f30cad7f606e5212016a358cf1dced3f79c5e": "Vawtrak C&C",
    "fc802184e7d085d03650a9d6a880b2c89666d017": "IcedID C&C",
    "fc81ca847ebaed4dd99c5966e033750d0195ce50": "DCRat C&C",
    "fc8a5bbedb6bc56b80910d209ce6eb94df50c1eb": "AsyncRAT C&C",
    "fc8e8209ef08ca4a66d1f5045a2e210c28d61493": "KINS C&C",
    "fc8ebd3114767c335c5b85c3f7b5deff449daaf5": "Gootkit C&C",
    "fc9605c49576addcf5c9ee2f5f2b46d46d83c688": "AsyncRAT C&C",
    "fc9f191930f0f5ebe7fc888df959338d57455a1d": "TrickBot C&C",
    "fca2b0921e574223413db7cb85ef8fe18baf1da6": "Adwind C&C",
    "fcaad6769c1262c4cb43775c567410d02d19b3f9": "BitRAT C&C",
    "fcab10cf56459c8c257f5439d01151459de79363": "Gozi C&C",
    "fcaeb027b58875151a8c97e1ad253a4836404de7": "AsyncRAT C&C",
    "fcb2f09b7f23547520bf3ae4436d250d9802ecf6": "RedLineStealer C&C",
    "fcc41f77ed1aef50dcf2792d580562bfdf8a3955": "TorrentLocker C&C",
    "fcd33d8746b45111d0e3bdb0c40b36554d910603": "TrickBot C&C",
    "fce337e0e571d9384c7141e9390c3672d93e3a4b": "KINS C&C",
    "fce61ef31a71ac4ecef31d08256e91023daacfcc": "OrcusRAT C&C",
    "fce76546648e227ebfa670082509cc7d50849d61": "OrcusRAT C&C",
    "fcf3979d565feb03e2f8a36f743379022a44a923": "OrcusRAT C&C",
    "fcf57e831a5fe834b0cd2540d1c19af71baf21a1": "TrickBot C&C",
    "fcf5db845d993b620e12b5becf31305cb1fb6cd6": "AsyncRAT C&C",
    "fcf8ef46c24dee5cd4482465e5a2dfbf20267808": "AZORult C&C",
    "fd01f8e1903789cf6f3c7f7d9b2666b876c9e027": "Malware C&C",
    "fd028dcbdf0df69d701fca558bb30a8848ad4f3e": "Gootkit C&C",
    "fd05978a1bcdbab473f65a8f8620991d4bdaf9fe": "AsyncRAT C&C",
    "fd17ec0974133c75dfd974621c252097be33a71a": "Dridex C&C",
    "fd25c540f98325a66a6069a4913b1d193103e296": "AsyncRAT C&C",
    "fd26c5d36aeee389b7e837b6b79d157b57c5fe1f": "AsyncRAT C&C",
    "fd2b0f9885cb3025f2c35440d687f92de082e40a": "TorrentLocker C&C",
    "fd2de574af7e363a5304df85b3475f93a948c103": "QuasarRAT C&C",
    "fd3a1732fc5b272d167a5d401ebb86ce6d4abd48": "Adwind C&C",
    "fd3a76f4191c478f7de01491b4314fbd98b2e8ce": "AsyncRAT C&C",
    "fd3fb95bed57fc036158d5c6ec3c25fb33035650": "Quakbot C&C",
    "fd51bc1d198d9f42f98b4e22bca89a6e41be27c8": "Dridex C&C",
    "fd546d4c8e7459c3d116da83b7d60a83ea4a9636": "BitRAT C&C",
    "fd5bfccc78064829e5e2f3609e536d54685bb85a": "AsyncRAT C&C",
    "fd701504795d85f9c69fa0890ff1e133c807480b": "Dridex C&C",
    "fd77f1c057187f06c06ae834f04b07d04e39d738": "AsyncRAT C&C",
    "fd8aa2d4e1c4ea685f0466b50fc6efd4c1cc2deb": "Adwind C&C",
    "fd8e0677991eef5202bf555661afae70ab7eea47": "Quakbot C&C",
    "fd97514a5f2bbd20052a522707d1cfd4c4050feb": "Dridex C&C",
    "fda059b2818cbe1f7f034f1765ed3e6ad0e92bbf": "PandaZeuS C&C",
    "fdaa2fba83ec753043847e9b36a1a91729edb092": "Gozi C&C",
    "fdb1b3154f75d79572a320c1363dd256fdd32f24": "Malware C&C",
    "fdb2e6e41b38a3d64a3022ea17700e71376c6c17": "AsyncRAT C&C",
    "fdb390118fcc4f23f9e1dc61c3760e687f8a0f26": "Vidar C&C",
    "fdbacd060f6ae2a28b41c76e9bd9934fc6d0b329": "TorrentLocker C&C",
    "fdc0ada78668f422a80f3ccbd8118169ccc093e9": "BazaLoader C&C",
    "fdf058437190606cbd7f9638165cb4c8ae5824ea": "AsyncRAT C&C",
    "fdfb8c766b53ba00d81c88d65d73bbc2f40a0357": "BitRAT C&C",
    "fe15307fcfa19858bb54961a8e193f1f3f5bcf44": "OrcusRAT C&C",
    "fe19de108980393ab91f2824ce96b8cab0f84163": "KINS C&C",
    "fe22696e0228f91a5afeda787adf22abcf4961e8": "KINS C&C",
    "fe2ca5d3c3ed9beeb777fd68732ff54e72f37490": "DCRat C&C",
    "fe391fce692824a65c22a25d4a8715103d432e50": "IcedID C&C",
    "fe51c73bd63248404e4424b3377ded8b3b3ec5e8": "Gozi C&C",
    "fe51fba9e323ac4d879c38907011d8c593f26437": "DCRat C&C",
    "fe64ad56614e6669c1e074be62c44a2731936916": "AsyncRAT C&C",
    "fe6c4ae2f34eb1902cb9b500639be4b2a1923540": "Dridex C&C",
    "fe6c99e104e7bce14aa919ccafe564706c100dcf": "AsyncRAT C&C",
    "fe7095630128be297523276a0fafaf5c3866799d": "Gootkit C&C",
    "fe766ea57267b8d9fae9788b0265307b53d659cf": "TorrentLocker C&C",
    "fe80cd4db034b81850a6755239a1a46301efe2a9": "BitRAT C&C",
    "fe896fca5f12a0f65a12e2ae39588a505cf6d035": "Dridex C&C",
    "fe9896aa1fbb7792a2a00de502d497141632ed80": "Gozi C&C",
    "feb161face11eb168abf3895154a120953b1fd87": "BitRAT C&C",
    "fed056fa3e69f6a1bd950f905abbcf6ee4d1c9ad": "BitRAT C&C",
    "feddbee5afde60f1c2a07e8b322ddec32aa45068": "IcedID C&C",
    "fee88cfc81f85a9b2332658b062f34c93b621f2b": "PureLogStealer C&C",
    "ff018f74bdbfeb5760aea17fabbd0b9e012b86d7": "AsyncRAT C&C",
    "ff05d50d6b2ef030d62abe5ac2a450d27c28004b": "OrcusRAT C&C",
    "ff10a406afa697ceb60ca2ac743ebb928d5eddf7": "Dridex C&C",
    "ff1552d1df5cd00ec56900319e9f24804ae60c63": "Vawtrak MITM",
    "ff218c49251412428f0bd12dd418c7606f5107fe": "Dridex C&C",
    "ff2bb0f40748233a186c70b3ecadcb807d660e97": "AsyncRAT C&C",
    "ff42385359e54f2390dcd2f68b7fdd099c06059c": "AsyncRAT C&C",
    "ff42c4d852ed4ec12c76ebedef25594254b76f0d": "BazaLoader C&C",
    "ff42e458742bae07bff696c17f396628e1192821": "TorrentLocker C&C",
    "ff5d869250a5c8c08edcfe8325c1a10e283ecb1f": "Malware C&C",
    "ff6720e8f86f5ddc61c77488532fbf454687df0b": "AsyncRAT C&C",
    "ff79aa5a960009d8bedd890aba981936bfdf0563": "Qadars C&C",
    "ffc0320acadeba1553f8fd48d15fa57612e83186": "AsyncRAT C&C",
    "ffc3bf9b72df3df10e2261f570ed9974515e1e2b": "RockLoader C&C",
    "ffd2a7db141f140db5e30436ba7e21686d2f690c": "AsyncRAT C&C",
    "ffe39ade1d93169a5f3d17ee9800df8fc54d05da": "KINS C&C",
    "fff9310ee2ebb01360f02c6b542de52d75affc35": "Gozi C&C",
    "ffff8955e762caa27b97a22e2c6fe6d053a8f19a": "Quakbot C&C",
    # GENERATED_DATA_SSLBL_CERTIFICATES
}


SSLBL_JA3 = {
    # GENERATED_DATA_SSLBL_JA3
    "03e186a7f83285e93341de478334006e": "Tofsee",
    "08a8a4e85b25ac42e1490bc85cfdb5ce": "Tofsee",
    "098f55e27d8c4b0a590102cbdb3a5f3a": "Adware",
    "0cc1e84568e471aa1d62ad4158ade6b5": "Tofsee",
    "1543a7c46633acf71e8401baccbd0568": "Tofsee",
    "16efcf0e00504ddfedde13bfea997952": "Adware",
    "1712287800ac91b34cadd5884ce85568": "TorrentLocker",
    "17fd49722f8d11f3d76dce84f8e099a7": "Tofsee",
    "1aa7bf8b97e540ca5edd75f7b8384bfa": "TrickBot",
    "1aee0238942d453d679fc1e37a303387": "Tofsee",
    "1be3ecebe5aa9d3654e6e703d81f6928": "Ransomware.Troldesh",
    "1d095e68489d3c535297cd8dffb06cb9": "Tofsee",
    "1fe4c7a3544eb27afec2adfb3a3dbf60": "Tofsee",
    "2092e1fffb45d7e4a19a57f9bc5e203a": "Adware",
    "25d74b7b4b779eb1efd4b31d26d651c6": "Tofsee",
    "29085f03f8e8a03f0b399c5c7cf0b0b8": "Adware",
    "2d8794cb7b52b777bee2695e79c15760": "Ransomware",
    "32926ca3e59f0413d0b98725454594f5": "Tofsee",
    "34f14a69ad7009ca5863379218af17f3": "Tofsee",
    "35c0a31c481927f022a3b530255ac080": "Tofsee",
    "3cda52da4ade09f1f781ad2e82dcfa20": "Quakbot",
    "3d89c0dfb1fa44911b8fa7523ef8dedb": "Adware",
    "40adfd923eb82b89d8836ba37a19bca1": "CoinMiner",
    "46efd49abcca8ea9baa932da68fdb529": "Adware",
    "49ed2ef3f1321e5f044f1e71b0e6fdd5": "TrickBot",
    "4d7a28d6f2263ed61de88ca66eb011e3": "Tofsee",
    "51a7ad14509fd614c7bb3a50c4982b8c": "JBifrost",
    "51c64c77e60f3980eea90869b68c58a8": "Dridex",
    "52c7396a501e4fecbdfa99c5408334ac": "Tofsee",
    "534ce2dbc413c68e908363b5df0ae5e0": "TrickBot",
    "550dce18de1bb143e69d6dd9413b8355": "Adware",
    "57f3642b4e37e28f5cbe3020c9331b4c": "Gozi",
    "590a232d04d56409fab72e752a8a2634": "Tofsee",
    "5e573c9c9f8ba720ef9b18e9fce2e2f7": "Adware",
    "698e36219f3979420fa2581b21dac7ec": "Adware",
    "70722097d1fe1d78d8c2164640ab6df4": "Tofsee",
    "70a04365be5bbd4653698bebeb43ce68": "Tofsee",
    "7691297bcb20a41233fd0a0baa0a3628": "Adware",
    "7a29c223fb122ec64d10f0a159e07996": "None",
    "7c410ce832e848a3321432c9a82e972b": "Tofsee",
    "7dcce5b76c8b17472d024758970a406b": "Tofsee",
    "7dd50e112cd23734a310b90f6f44a7cd": "Quakbot",
    "807fca46d9d0cf63adf4e5e80e414bbe": "Tofsee",
    "83e04bc58d402f9633983cbf22724b02": "Adware",
    "849b04bdbd1d2b983f6e8a457e0632a8": "Adware",
    "8515076cbbca9dce33151b798f782456": "BitRAT",
    "8916410db85077a5460817142dcbc8de": "TrickBot",
    "8991a387e4cc841740f25d6f5139f92d": "Adware",
    "8f52d1ce303fb4a6515836aec3cc16b1": "TrickBot",
    "8f6c918dcb585ebbea05e2cc94530e3d": "Tofsee",
    "906004246f3ba5e755b043c057254a29": "Tofsee",
    "911479ac8a0813ed1241b3686ccdade9": "Tofsee",
    "92579701f145605e9edc0b01a901c6d5": "Adware",
    "93d056782d649deb51cda44ecb714bb0": "Adware",
    "96eba628dcb2b47607192ba74a3b55ba": "Tofsee",
    "9c2589e1c0e9f533a022c6205f9719e1": "Adware",
    "9f62c4f26b90d3d757bea609e82f2eaf": "Tofsee",
    "a50a861119aceb0ccc74902e8fddb618": "Tofsee",
    "a61299f9b501adcf680b9275d79d4ac6": "Tofsee",
    "b13d01846ad7a14a70bf030a16775c78": "Adware",
    "b2b61db7b9490a60d270ccb20b462826": "Adware",
    "b386946a5a44d1ddcc843bc75336dfce": "Dridex",
    "b8f81673c0e1d29908346f3bab892b9b": "Adware",
    "b90bdbe961a648f0427db21aaa6ccb59": "Tofsee",
    "bc6c386f480ee97b9d9e52d472b772d8": "Adware",
    "bffa4501966196d3d6e90cee1f88fc89": "Tofsee",
    "c0220cd64849a629397a9cb68f78a0ea": "Tofsee",
    "c201b92f8b483fa388be174d6689f534": "Gozi",
    "c2b4710c6888a5d47befe865c8e6fb19": "Tofsee",
    "c50f6a8b9173676b47ba6085bd0c6cee": "TrickBot",
    "c5235d3a8b9934b7fbbd204d50bc058d": "Gootkit",
    "c5deb9465d47232dd48772f9c4d14679": "Tofsee",
    "cb98a24ee4b9134448ffb5714fd870ac": "Dridex",
    "d18a4da84af59e1108862a39bae7c9d4": "Tofsee",
    "d2935c58fe676744fecc8614ee5356c7": "Adwind",
    "d551fafc4f40f1dec2bb45980bfa9492": "Adware",
    "d6f04b5a910115f4b50ecec09d40a1df": "Dridex",
    "d7150af4514b868defb854db0f62a441": "Tofsee",
    "d76ee64fb7273733cbe455ac81c292e6": "Tofsee",
    "d81d654effb94714a4086734fa0adad9": "Tofsee",
    "da949afd9bd6df820730f8f171584a71": "Tofsee",
    "decfb48a53789ebe081b88aabb58ee34": "Adwind",
    "df5c30e670dba99f9270ed36060cf054": "Tofsee",
    "dff8a0aa1c904aaea76c5bf624e88333": "Tofsee",
    "e330bca99c8a5256ae126a55c4c725c5": "Adware",
    "e3b2ab1f9a56f2fb4c9248f2f41631fa": "Tofsee",
    "e62a5f4d538cbf169c2af71bec2399b4": "TrickBot",
    "e7643725fcff971e3051fe0e47fc2c71": "Tofsee",
    "f22bdd57e3a52de86cda40da2d84e83b": "Tofsee",
    "f6fd83a21f9f3c5f9ff7b5c63bbc179d": "Adware",
    "f735bbc6b69723b9df7b0e7ef27872af": "TrickBot",
    "fb00055a1196aeea8d1bc609885ba953": "TrickBot",
    "fb58831f892190644fe44e25bc830b45": "Adware",
    "fc2299d5b2964cd242c5a2c8c531a5f0": "Tofsee",
    "fc54e0d16d9764783542f0146a98b300": "AsyncRAT",
    "fd80fa9c6120cdeea8520510f3c644ac": "Tofsee",
    "ffefafdb86336d057eda5fdf02b3d5ce": "Tofsee",
    # GENERATED_DATA_SSLBL_JA3
}
