/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.javadoc;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jpype.javadoc.DomUtilities;
import org.jpype.javadoc.JavadocException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavadocRenderer {
    static final int WIDTH = 120;
    public StringBuilder assembly;
    public int indentLevel = 0;
    String memberName;
    static final Map<String, String> SECTIONS = new HashMap<String, String>();
    static final String SPACING;

    public String render(Node node) {
        try {
            this.indentLevel = 0;
            this.assembly = new StringBuilder();
            DomUtilities.traverseChildren(node, this::renderSections, (short)1);
            return this.assembly.toString();
        }
        catch (Exception exception) {
            throw new JavadocException(node, (Throwable)exception);
        }
    }

    void renderSections(Node node) {
        Element element = (Element)node;
        String string = element.getTagName();
        if (string.equals("title")) {
            this.memberName = node.getTextContent();
            return;
        }
        if (string.equals("signature")) {
            this.assembly.append(node.getTextContent()).append("\n\n");
            this.indentLevel += 4;
            return;
        }
        if (string.equals("description")) {
            this.renderText(node, true, true);
            return;
        }
        if (string.equals("details")) {
            DomUtilities.traverseChildren(node, this::renderDetails, (short)1);
            this.assembly.append("\n");
            return;
        }
    }

    void renderDetails(Node node) {
        String string = node.getNodeName();
        if (string.equals("parameters")) {
            this.assembly.append('\n').append(JavadocRenderer.indentation(this.indentLevel)).append("Parameters:\n");
            this.indentLevel += 4;
            DomUtilities.traverseChildren(node, this::renderParameter, (short)1);
            this.indentLevel -= 4;
        } else if (string.equals("throws")) {
            this.assembly.append('\n').append(JavadocRenderer.indentation(this.indentLevel)).append("Raises:\n");
            this.indentLevel += 4;
            DomUtilities.traverseChildren(node, this::renderThrow, (short)1);
            this.indentLevel -= 4;
        } else if (SECTIONS.containsKey(string)) {
            String string2 = SECTIONS.get(string);
            if (string2 == null) {
                return;
            }
            this.assembly.append('\n').append(JavadocRenderer.indentation(this.indentLevel)).append(string2).append('\n');
            this.indentLevel += 4;
            this.renderText(node, true, true);
            this.indentLevel -= 4;
        } else {
            System.err.println("Need renderer for section " + string);
        }
    }

    void renderParameter(Node node) {
        Element element = (Element)node;
        this.assembly.append(JavadocRenderer.indentation(this.indentLevel)).append(element.getAttribute("name")).append(" (").append(element.getAttribute("type")).append("): ");
        this.indentLevel += 4;
        this.renderText(node, false, true);
        this.indentLevel -= 4;
    }

    void renderThrow(Node node) {
        Element element = (Element)node;
        this.assembly.append(JavadocRenderer.indentation(this.indentLevel)).append(element.getAttribute("name")).append(": ");
        this.indentLevel += 4;
        this.renderText(node, false, true);
        this.indentLevel -= 4;
    }

    void renderText(Node node, boolean bl, boolean bl2) {
        DomUtilities.combineText(node);
        DomUtilities.removeWhitespace(node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            if (node2.getNodeType() == 3) {
                object = node2.getNodeValue();
                if (object == null || ((String)(object = ((String)object).trim())).isEmpty()) continue;
                JavadocRenderer.formatWidth(this.assembly, (String)object, 120, this.indentLevel, bl);
                if (!bl2) continue;
                this.assembly.append("\n");
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            object = (Element)node2;
            String string = object.getTagName();
            if (string.equals("p")) {
                this.assembly.append("\n");
                this.renderText((Node)object, true, true);
                continue;
            }
            if (string.equals("div")) {
                this.renderText((Node)object, true, true);
                continue;
            }
            if (string.equals("center")) {
                this.renderText((Node)object, true, true);
                continue;
            }
            if (string.equals("br")) {
                this.assembly.append("\n\n");
                continue;
            }
            if (string.equals("ul")) {
                this.renderUnordered((Node)object);
                continue;
            }
            if (string.equals("ol")) {
                this.renderOrdered((Node)object);
                continue;
            }
            if (string.equals("img") || string.equals("table") || string.equals("hr")) continue;
            if (string.equals("dl")) {
                this.renderDefinitions((Node)object);
                continue;
            }
            if (string.equals("codeblock")) {
                this.renderCodeBlock((Node)object);
                continue;
            }
            if (string.equals("blockquote")) {
                this.renderBlockQuote((Node)object);
                continue;
            }
            if (string.equals("h1")) {
                this.renderHeader((Node)object);
                continue;
            }
            if (string.equals("h2")) {
                this.renderHeader((Node)object);
                continue;
            }
            if (string.equals("h3")) {
                this.renderHeader((Node)object);
                continue;
            }
            if (string.equals("h4")) {
                this.renderHeader((Node)object);
                continue;
            }
            if (string.equals("h5")) {
                this.renderHeader((Node)object);
                continue;
            }
            throw new RuntimeException("Need render for " + string);
        }
    }

    void renderHeader(Node node) {
        this.assembly.append("\n");
        this.renderText(node, true, true);
        this.assembly.append(new String(new byte[node.getTextContent().length()]).replace('\u0000', '-')).append("\n\n");
    }

    void renderBlockQuote(Node node) {
        this.indentLevel += 4;
        this.renderText(node, true, true);
        this.indentLevel -= 4;
    }

    void renderOrdered(Node node) {
        this.indentLevel += 4;
        this.assembly.append("\n");
        int n = 1;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equals("li")) {
                this.assembly.append(JavadocRenderer.indentation(this.indentLevel - 2)).append(String.format("%d.  ", n++));
                this.renderText(node2, false, true);
                continue;
            }
            throw new RuntimeException("Bad node " + node2.getNodeName() + " in UL");
        }
        this.indentLevel -= 4;
        this.assembly.append("\n");
    }

    void renderUnordered(Node node) {
        this.indentLevel += 4;
        this.assembly.append("\n");
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equals("li")) {
                this.assembly.append(JavadocRenderer.indentation(this.indentLevel - 4)).append("  - ");
                this.renderText(node2, false, true);
                continue;
            }
            throw new RuntimeException("Bad node " + node2.getNodeName() + " in UL");
        }
        this.indentLevel -= 4;
        this.assembly.append("\n");
    }

    void renderDefinitions(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if (string.equals("dt")) {
                this.assembly.append("\n");
                this.renderText(node2, true, true);
                continue;
            }
            if (string.equals("dd")) {
                this.assembly.append(JavadocRenderer.indentation(this.indentLevel));
                this.indentLevel += 4;
                this.assembly.append("  ");
                this.renderText(node2, false, true);
                this.indentLevel -= 4;
                continue;
            }
            throw new RuntimeException("Bad node " + string + " in DL");
        }
        this.assembly.append("\n");
    }

    void renderCodeBlock(Node node) {
        String string = JavadocRenderer.indentation(this.indentLevel);
        this.assembly.append("\n").append(string).append(".. code-block: java\n");
        Object object = node.getTextContent();
        if (((String)object).charAt(0) != '\n') {
            object = "\n" + (String)object;
        }
        object = ((String)object).replaceAll("\n", "\n" + string);
        this.assembly.append(string).append((String)object).append("\n");
    }

    static String indentation(int n) {
        if (n > 40) {
            return new String();
        }
        return SPACING.substring(0, n);
    }

    static void formatWidth(StringBuilder stringBuilder, String string, int n, int n2, boolean bl) {
        String string2 = JavadocRenderer.indentation(n2);
        if ((string = string.replaceAll("\\s+", " ").trim()).length() < n) {
            if (bl) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(string);
            return;
        }
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n3 = 0;
        int n4 = 0;
        int n5 = byArray.length;
        int n6 = 0;
        while (n6 < n5) {
            for (n6 = n4 + 1; n6 < n5 && byArray[n6] != 32; ++n6) {
            }
            if (n6 - n3 > n) {
                byArray[n4] = 10;
                if (bl) {
                    stringBuilder.append(string2);
                }
                bl = true;
                stringBuilder.append(new String(byArray, n3, n4 - n3 + 1));
                n3 = n4 + 1;
            }
            n4 = n6;
        }
        stringBuilder.append(string2);
        stringBuilder.append(new String(byArray, n3, n5 - n3));
    }

    static {
        SECTIONS.put("returns", "Returns:");
        SECTIONS.put("see", "See also:");
        SECTIONS.put("since", "Since:");
        SECTIONS.put("jls", "See Java\u2122 specification:");
        SECTIONS.put("overrides", "Overrides:");
        SECTIONS.put("specified", "Specified by:");
        SECTIONS.put("version", null);
        SECTIONS.put("typeparams", null);
        SECTIONS.put("author", null);
        SECTIONS.put("see", "Also see:");
        SECTIONS.put("api_note", "API Note:");
        SECTIONS.put("requirements", "Implementation Requirements:");
        SECTIONS.put("impl_note", "Implementation Note:");
        SPACING = new String(new byte[40]).replace('\u0000', ' ');
    }
}

