# Copyright (c) 2017, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

# external
from mixbox import fields


# internal
import stix
from stix.bindings.extensions.malware import maec_4_1 as maec_instance_binding
from stix.ttp.malware_instance import MalwareInstance


@stix.register_extension
class MAECInstance(MalwareInstance):
    """
    The MAECInstance object provides an extension to the MalwareInstanceType
    which imports and leverages the MAEC 4.1 schema for structured
    characterization of Malware.

    This class extension is automatically registered by the
    MalwareInstanceFactory.

    Warnings:
        Interacting with the ``maec`` field will fail if the maec library is
        not installed in your Python environment.
    """
    _binding = maec_instance_binding
    _binding_class = _binding.MAEC4_1InstanceType
    _namespace = "http://stix.mitre.org/extensions/Malware#MAEC4.1-1"
    _XSI_TYPE = "stix-maec:MAEC4.1InstanceType"

    maec = fields.TypedField("MAEC", type_="maec.package.package.Package")

    def __init__(self, maec=None):
        super(MAECInstance, self).__init__()
        self.maec = maec
