# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
"""TensorFlow Probability experimental python utilities."""

# from tensorflow_probability.substrates.jax.experimental.util.composite_tensor import as_composite
# from tensorflow_probability.substrates.jax.experimental.util.composite_tensor import register_composite
# from tensorflow_probability.substrates.jax.experimental.util.deferred_module import DeferredModule
from tensorflow_probability.substrates.jax.experimental.util.jit_public_methods import DEFAULT_METHODS_EXCLUDED_FROM_JIT
from tensorflow_probability.substrates.jax.experimental.util.jit_public_methods import JitPublicMethods
from tensorflow_probability.substrates.jax.experimental.util.trainable import make_trainable
from tensorflow_probability.substrates.jax.experimental.util.trainable import make_trainable_stateless
from tensorflow_probability.python.internal import all_util


_allowed_symbols = [
    # 'as_composite',
    'DEFAULT_METHODS_EXCLUDED_FROM_JIT',
    # 'DeferredModule',
    'JitPublicMethods',
    'make_trainable',
    'make_trainable_stateless',
    # 'register_composite',
]

all_util.remove_undocumented(__name__, _allowed_symbols)


# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
# This file is auto-generated by substrates/meta/rewrite.py
# It will be surfaced by the build system as a symlink at:
#   `tensorflow_probability/substrates/jax/experimental/util/__init__.py`
# For more info, see substrate_runfiles_symlinks in build_defs.bzl
# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
