rule win_isfb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2023-01-25"
        version = "1"
        description = "Detects win.isfb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.isfb"
        malpedia_rule_date = "20230124"
        malpedia_hash = "2ee0eebba83dce3d019a90519f2f972c0fcf9686"
        malpedia_version = "20230125"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? eb02 33c0 3bc7 741b 50 33c0 }
            // n = 7, score = 2500
            //   e8????????           |                     
            //   eb02                 | mov                 dword ptr [ebp - 8], eax
            //   33c0                 | mov                 ebx, eax
            //   3bc7                 | push                ebx
            //   741b                 | mov                 eax, 0x800
            //   50                   | push                eax
            //   33c0                 | push                esi

        $sequence_1 = { 33c0 e8???????? 3bc7 740f }
            // n = 4, score = 2500
            //   33c0                 | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   3bc7                 | cmp                 edi, esi
            //   740f                 | je                  0x10

        $sequence_2 = { ff7508 ff75f0 ff75f4 6822010000 e9???????? ff7508 }
            // n = 6, score = 2400
            //   ff7508               | dec                 eax
            //   ff75f0               | mov                 ecx, edi
            //   ff75f4               | dec                 esp
            //   6822010000           | mov                 dword ptr [ebp + ebx*8], esp
            //   e9????????           |                     
            //   ff7508               | add                 ebx, 1

        $sequence_3 = { 50 6a10 58 e8???????? 3bc7 7406 }
            // n = 6, score = 2400
            //   50                   | cmp                 eax, ebx
            //   6a10                 | je                  0xa
            //   58                   | push                eax
            //   e8????????           |                     
            //   3bc7                 | cmp                 edi, ebx
            //   7406                 | cmp                 eax, ebx

        $sequence_4 = { 33c0 3bc7 7413 50 6a10 58 }
            // n = 6, score = 2400
            //   33c0                 | xor                 eax, eax
            //   3bc7                 | cmp                 eax, ebx
            //   7413                 | je                  0x11
            //   50                   | push                eax
            //   6a10                 | add                 esi, 4
            //   58                   | push                eax

        $sequence_5 = { 57 50 e8???????? 83c40c e8???????? 3bc7 8945f0 }
            // n = 7, score = 2200
            //   57                   | push                ebx
            //   50                   | mov                 ebx, 0xea60
            //   e8????????           |                     
            //   83c40c               | jne                 7
            //   e8????????           |                     
            //   3bc7                 | push                ebx
            //   8945f0               | mov                 ebx, 0xea60

        $sequence_6 = { ff15???????? a1???????? 85c0 7407 83ee64 }
            // n = 5, score = 2200
            //   ff15????????         |                     
            //   a1????????           |                     
            //   85c0                 | cmp                 eax, ebx
            //   7407                 | jne                 0x14
            //   83ee64               | cmp                 eax, ebx

        $sequence_7 = { ff35???????? e8???????? 8bf0 3bf3 7443 }
            // n = 5, score = 2200
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8bf0                 | push                eax
            //   3bf3                 | xor                 eax, eax
            //   7443                 | cmp                 eax, edi

        $sequence_8 = { 5d 5b 59 c20400 8325????????00 6a00 }
            // n = 6, score = 2100
            //   5d                   | xor                 eax, eax
            //   5b                   | dec                 eax
            //   59                   | cmp                 eax, ebx
            //   c20400               | je                  0xe8
            //   8325????????00       |                     
            //   6a00                 | push                ebx

        $sequence_9 = { ff15???????? 85c0 a3???????? 7402 ffe0 c20400 }
            // n = 6, score = 2100
            //   ff15????????         |                     
            //   85c0                 | pop                 eax
            //   a3????????           |                     
            //   7402                 | cmp                 eax, edi
            //   ffe0                 | je                  0xa
            //   c20400               | push                eax

        $sequence_10 = { 3bc7 7406 50 e8???????? 3bdf 7414 }
            // n = 6, score = 2100
            //   3bc7                 | je                  0x13
            //   7406                 | je                  0x1d
            //   50                   | push                eax
            //   e8????????           |                     
            //   3bdf                 | xor                 eax, eax
            //   7414                 | cmp                 eax, edi

        $sequence_11 = { 5b c20400 55 8bec 83ec0c a1???????? 8365f800 }
            // n = 7, score = 1800
            //   5b                   | xor                 ebx, ebx
            //   c20400               | mov                 dx, 0x20
            //   55                   | dec                 ecx
            //   8bec                 | mov                 ecx, esp
            //   83ec0c               | je                  0x11
            //   a1????????           |                     
            //   8365f800             | xor                 edx, edx

        $sequence_12 = { ff15???????? 3c05 7506 84e4 7704 3ac0 }
            // n = 6, score = 1800
            //   ff15????????         |                     
            //   3c05                 | pop                 eax
            //   7506                 | cmp                 eax, edi
            //   84e4                 | cmp                 eax, edi
            //   7704                 | je                  0x15
            //   3ac0                 | push                eax

        $sequence_13 = { b8???????? 7505 b8???????? 53 bb60ea0000 53 ff750c }
            // n = 7, score = 1700
            //   b8????????           |                     
            //   7505                 | je                  0x21
            //   b8????????           |                     
            //   53                   | push                eax
            //   bb60ea0000           | xor                 eax, eax
            //   53                   | xor                 eax, eax
            //   ff750c               | cmp                 eax, edi

        $sequence_14 = { 8b4e10 83e103 740d 51 50 ff7510 }
            // n = 6, score = 1700
            //   8b4e10               | mov                 edi, ebp
            //   83e103               | dec                 ecx
            //   740d                 | cmp                 eax, ebp
            //   51                   | je                  0x10
            //   50                   | inc                 ecx
            //   ff7510               | add                 ebp, esi

        $sequence_15 = { 7417 8b10 2b55fc 8b7d10 }
            // n = 4, score = 1700
            //   7417                 | inc                 ecx
            //   8b10                 | add                 ebp, esi
            //   2b55fc               | dec                 eax
            //   8b7d10               | add                 esi, 8

        $sequence_16 = { a1???????? 3bc3 7512 e8???????? 3bc3 a3???????? }
            // n = 6, score = 1700
            //   a1????????           |                     
            //   3bc3                 | xor                 eax, eax
            //   7512                 | cmp                 eax, edi
            //   e8????????           |                     
            //   3bc3                 | je                  0x16
            //   a3????????           |                     

        $sequence_17 = { e8???????? 8bd8 85db 895df4 0f84c7000000 56 53 }
            // n = 7, score = 1700
            //   e8????????           |                     
            //   8bd8                 | jmp                 4
            //   85db                 | xor                 eax, eax
            //   895df4               | cmp                 eax, edi
            //   0f84c7000000         | je                  0x21
            //   56                   | push                eax
            //   53                   | jmp                 4

        $sequence_18 = { 2b55fc 8b7d10 0155fc 83451004 83c004 }
            // n = 5, score = 1700
            //   2b55fc               | mov                 dword ptr [esi], ebp
            //   8b7d10               | jmp                 9
            //   0155fc               | dec                 eax
            //   83451004             | test                eax, eax
            //   83c004               | dec                 eax

        $sequence_19 = { 83451004 83c004 49 8917 75e9 8b4e10 83e103 }
            // n = 7, score = 1700
            //   83451004             | jmp                 0xc
            //   83c004               | add                 ebx, 1
            //   49                   | xor                 ebx, ebx
            //   8917                 | mov                 dx, 0x20
            //   75e9                 | dec                 ecx
            //   8b4e10               | mov                 ecx, esp
            //   83e103               | dec                 eax

        $sequence_20 = { 50 ff7510 e8???????? 83c40c c745fc01000000 8b4610 }
            // n = 6, score = 1700
            //   50                   | test                edi, edi
            //   ff7510               | dec                 esp
            //   e8????????           |                     
            //   83c40c               | mov                 esp, edi
            //   c745fc01000000       | jne                 0xffffffc6
            //   8b4610               | dec                 eax

        $sequence_21 = { 8a4604 2404 f6d8 1bc0 83e006 }
            // n = 5, score = 1600
            //   8a4604               | push                eax
            //   2404                 | push                esi
            //   f6d8                 | mov                 dword ptr [ebp - 8], eax
            //   1bc0                 | mov                 ebx, eax
            //   83e006               | cmp                 ebx, esi

        $sequence_22 = { e8???????? 8b07 c6400731 8b74241c }
            // n = 4, score = 1600
            //   e8????????           |                     
            //   8b07                 | jmp                 9
            //   c6400731             | xor                 ebx, ebx
            //   8b74241c             | jne                 0xffffffc6

        $sequence_23 = { 6a00 ff37 ff15???????? 2b442414 }
            // n = 4, score = 1600
            //   6a00                 | push                dword ptr [ebp + 8]
            //   ff37                 | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   2b442414             | push                dword ptr [ebp - 0xc]

        $sequence_24 = { 2b4b28 894c2410 8b4b34 f6c140 }
            // n = 4, score = 1600
            //   2b4b28               | dec                 eax
            //   894c2410             | mov                 dword ptr [esi], ebp
            //   8b4b34               | jmp                 7
            //   f6c140               | xor                 ebx, ebx

        $sequence_25 = { 8b74241c 8b1e 6a00 ff37 }
            // n = 4, score = 1600
            //   8b74241c             | mov                 dword ptr [esi], ebp
            //   8b1e                 | jmp                 0xc
            //   6a00                 | xor                 ebx, ebx
            //   ff37                 | dec                 eax

        $sequence_26 = { 8b442414 8b4c240c 8907 8b442418 894110 836334f9 }
            // n = 6, score = 1600
            //   8b442414             | mov                 byte ptr [esi + 8], bl
            //   8b4c240c             | dec                 esp
            //   8907                 | mov                 esp, edi
            //   8b442418             | jne                 0xffffffc6
            //   894110               | dec                 eax
            //   836334f9             | mov                 dword ptr [esi], ebp

        $sequence_27 = { ff35???????? 0fc8 50 a1???????? }
            // n = 4, score = 1600
            //   ff35????????         |                     
            //   0fc8                 | push                0x10
            //   50                   | pop                 eax
            //   a1????????           |                     

        $sequence_28 = { 837b240c 56 57 8b3b 897c241c }
            // n = 5, score = 1600
            //   837b240c             | push                dword ptr [ebp + 8]
            //   56                   | push                dword ptr [ebp - 0x10]
            //   57                   | push                dword ptr [ebp - 0xc]
            //   8b3b                 | push                0x122
            //   897c241c             | push                dword ptr [ebp + 8]

        $sequence_29 = { e8???????? 85c0 740d 8906 83c604 47 83ff03 }
            // n = 7, score = 1600
            //   e8????????           |                     
            //   85c0                 | xor                 eax, eax
            //   740d                 | cmp                 eax, edi
            //   8906                 | je                  0x19
            //   83c604               | push                eax
            //   47                   | jmp                 4
            //   83ff03               | xor                 eax, eax

        $sequence_30 = { 897328 83c40c 8974240c c6401a00 8b44240c 85c0 }
            // n = 6, score = 1600
            //   897328               | dec                 eax
            //   83c40c               | test                edi, edi
            //   8974240c             | dec                 esp
            //   c6401a00             | mov                 esp, edi
            //   8b44240c             | jne                 0xffffffc9
            //   85c0                 | dec                 eax

        $sequence_31 = { ff15???????? 2b442414 50 8b07 03442418 }
            // n = 5, score = 1600
            //   ff15????????         |                     
            //   2b442414             | je                  0x45
            //   50                   | push                -1
            //   8b07                 | mov                 esi, eax
            //   03442418             | cmp                 esi, ebx

        $sequence_32 = { 6a0b eb02 6a02 58 5e c20800 }
            // n = 6, score = 1500
            //   6a0b                 | jb                  0xffffffc6
            //   eb02                 | xor                 edx, edx
            //   6a02                 | dec                 eax
            //   58                   | cmp                 eax, ebx
            //   5e                   | dec                 esp
            //   c20800               | mov                 ebp, eax

        $sequence_33 = { 50 8d4508 50 53 8bc6 e8???????? }
            // n = 6, score = 1500
            //   50                   | push                eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     

        $sequence_34 = { 7408 ff7508 e8???????? 8bc7 5f 5e }
            // n = 6, score = 1500
            //   7408                 | je                  0xa
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_35 = { 33ff eb0b 33ff eb03 }
            // n = 4, score = 1500
            //   33ff                 | xor                 edi, edi
            //   eb0b                 | jmp                 0xd
            //   33ff                 | xor                 edi, edi
            //   eb03                 | jmp                 5

        $sequence_36 = { c744242860ea0000 4c0f45c8 48895c2420 e8???????? }
            // n = 4, score = 1500
            //   c744242860ea0000     | mov                 ebx, 0xea60
            //   4c0f45c8             | push                ebx
            //   48895c2420           | push                ebx
            //   e8????????           |                     

        $sequence_37 = { 750e 837d0800 7408 ff7508 }
            // n = 4, score = 1500
            //   750e                 | jne                 0x10
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7408                 | je                  0xa
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_38 = { 752f 8b450c 8930 eb33 }
            // n = 4, score = 1500
            //   752f                 | jne                 0x31
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8930                 | mov                 dword ptr [eax], esi
            //   eb33                 | jmp                 0x35

        $sequence_39 = { 3bd0 7420 8b4a0c 3bc8 7415 }
            // n = 5, score = 1500
            //   3bd0                 | inc                 cx
            //   7420                 | mov                 eax, 0xd233005c
            //   8b4a0c               | dec                 eax
            //   3bc8                 | mov                 ecx, ebp
            //   7415                 | inc                 cx

        $sequence_40 = { 5e 5d 5b c3 8b4754 a804 }
            // n = 6, score = 1400
            //   5e                   | jmp                 0x11
            //   5d                   | add                 ebx, 1
            //   5b                   | dec                 eax
            //   c3                   | lea                 ecx, [eax + 1]
            //   8b4754               | mov                 ebx, 1
            //   a804                 | dec                 ecx

        $sequence_41 = { bb01000000 498bcc eb07 83c301 488d4801 66ba2000 ff15???????? }
            // n = 7, score = 1400
            //   bb01000000           | dec                 eax
            //   498bcc               | mov                 ebx, edi
            //   eb07                 | mov                 esi, edi
            //   83c301               | dec                 eax
            //   488d4801             | cmp                 ebx, edi
            //   66ba2000             | jne                 0x12
            //   ff15????????         |                     

        $sequence_42 = { 4c8be7 75c4 48892e eb02 33db 488b0d???????? }
            // n = 6, score = 1400
            //   4c8be7               | mov                 ebx, edi
            //   75c4                 | mov                 esi, edi
            //   48892e               | dec                 eax
            //   eb02                 | cmp                 ebx, edi
            //   33db                 | dec                 esp
            //   488b0d????????       |                     

        $sequence_43 = { 740f 488b0d???????? 33d2 ff15???????? bb01000000 498bcc eb07 }
            // n = 7, score = 1400
            //   740f                 | mov                 eax, ebx
            //   488b0d????????       |                     
            //   33d2                 | xor                 edx, edx
            //   ff15????????         |                     
            //   bb01000000           | dec                 eax
            //   498bcc               | mov                 ebx, edi
            //   eb07                 | mov                 esi, edi

        $sequence_44 = { 50 57 6a01 ff75e0 }
            // n = 4, score = 1400
            //   50                   | mov                 esi, edi
            //   57                   | dec                 eax
            //   6a01                 | cmp                 ebx, edi
            //   ff75e0               | jne                 0x12

        $sequence_45 = { ff75fc 6a0d 58 e8???????? 85c0 740d }
            // n = 6, score = 1400
            //   ff75fc               | pop                 ecx
            //   6a0d                 | ret                 4
            //   58                   | pop                 ebx
            //   e8????????           |                     
            //   85c0                 | pop                 ecx
            //   740d                 | ret                 4

        $sequence_46 = { c21000 55 8bec 83ec14 a1???????? 53 }
            // n = 6, score = 1400
            //   c21000               | xor                 edx, edx
            //   55                   | dec                 ecx
            //   8bec                 | mov                 ecx, esp
            //   83ec14               | dec                 ecx
            //   a1????????           |                     
            //   53                   | mov                 edi, ebp

        $sequence_47 = { 498bcc ff15???????? 33db 66ba2000 }
            // n = 4, score = 1400
            //   498bcc               | cmovne              ecx, eax
            //   ff15????????         |                     
            //   33db                 | dec                 eax
            //   66ba2000             | mov                 dword ptr [esp + 0x20], ebx

        $sequence_48 = { 448bc3 33d2 41c1e003 ff15???????? 4885c0 488be8 7453 }
            // n = 7, score = 1400
            //   448bc3               | mov                 dword ptr [esp + 0x20], ebx
            //   33d2                 | test                eax, eax
            //   41c1e003             | dec                 eax
            //   ff15????????         |                     
            //   4885c0               | mov                 ecx, edi
            //   488be8               | mov                 dword ptr [esp + 0x28], 0xea60
            //   7453                 | dec                 esp

        $sequence_49 = { e8???????? 85c0 742d ff75fc 6a0d }
            // n = 5, score = 1400
            //   e8????????           |                     
            //   85c0                 | push                0
            //   742d                 | push                1
            //   ff75fc               | mov                 eax, ebp
            //   6a0d                 | pop                 ebp

        $sequence_50 = { 33db 66ba2000 498bcc ff15???????? 4885c0 }
            // n = 5, score = 1400
            //   33db                 | dec                 eax
            //   66ba2000             | cmp                 ebx, edi
            //   498bcc               | jne                 0xf
            //   ff15????????         |                     
            //   4885c0               | dec                 esp

        $sequence_51 = { 6a01 ff75e0 68???????? e8???????? }
            // n = 4, score = 1400
            //   6a01                 | sbb                 eax, eax
            //   ff75e0               | and                 eax, 6
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_52 = { be01000000 8bc6 4883c440 415e 415d 415c 5f }
            // n = 7, score = 1400
            //   be01000000           | test                eax, eax
            //   8bc6                 | dec                 eax
            //   4883c440             | mov                 edi, eax
            //   415e                 | xor                 edx, edx
            //   415d                 | mov                 ebx, 1
            //   415c                 | dec                 ecx
            //   5f                   | mov                 ecx, esp

        $sequence_53 = { c60000 488bcf ff15???????? 4c8964dd00 83c301 4885ff 4c8be7 }
            // n = 7, score = 1400
            //   c60000               | dec                 eax
            //   488bcf               | cmp                 ebx, edi
            //   ff15????????         |                     
            //   4c8964dd00           | dec                 eax
            //   83c301               | mov                 ebx, edi
            //   4885ff               | mov                 esi, edi
            //   4c8be7               | dec                 eax

        $sequence_54 = { 53 b800080000 50 56 }
            // n = 4, score = 1400
            //   53                   | mov                 eax, edi
            //   b800080000           | pop                 edi
            //   50                   | je                  0xa
            //   56                   | push                dword ptr [ebp + 8]

        $sequence_55 = { 6641b85c00 33d2 488bcd ff15???????? }
            // n = 4, score = 1300
            //   6641b85c00           | pop                 ecx
            //   33d2                 | ret                 4
            //   488bcd               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     

        $sequence_56 = { 33db 6a01 e8???????? 85db 7423 8b0d???????? }
            // n = 6, score = 1300
            //   33db                 | sbb                 eax, eax
            //   6a01                 | mov                 dword ptr [esp + 0x28], 0xea60
            //   e8????????           |                     
            //   85db                 | dec                 esp
            //   7423                 | cmovne              ecx, eax
            //   8b0d????????         |                     

        $sequence_57 = { 83c604 e8???????? 3bfb 7414 }
            // n = 4, score = 1300
            //   83c604               | mov                 ebx, 0xea60
            //   e8????????           |                     
            //   3bfb                 | jne                 7
            //   7414                 | push                ebx

        $sequence_58 = { ff15???????? 3bc3 8b35???????? 8b3d???????? }
            // n = 4, score = 1300
            //   ff15????????         |                     
            //   3bc3                 | je                  0x13
            //   8b35????????         |                     
            //   8b3d????????         |                     

        $sequence_59 = { 4883c608 83fd05 72c1 eb0c bb7f000000 eb05 bb7e000000 }
            // n = 7, score = 1300
            //   4883c608             | dec                 eax
            //   83fd05               | mov                 dword ptr [esi], ebp
            //   72c1                 | jmp                 0xf
            //   eb0c                 | xor                 ebx, ebx
            //   bb7f000000           | mov                 byte ptr [eax], 0
            //   eb05                 | dec                 eax
            //   bb7e000000           | mov                 ecx, edi

        $sequence_60 = { 58 e8???????? 3bc3 7406 50 e8???????? 3bfb }
            // n = 7, score = 1300
            //   58                   | mov                 ebx, eax
            //   e8????????           |                     
            //   3bc3                 | push                ebx
            //   7406                 | push                esi
            //   50                   | pop                 ebx
            //   e8????????           |                     
            //   3bfb                 | cmp                 dword ptr [ebp - 4], esi

        $sequence_61 = { 4c8bc3 33d2 ff15???????? 488bdf 8bf7 483bdf 7508 }
            // n = 7, score = 1300
            //   4c8bc3               | push                ebx
            //   33d2                 | push                1
            //   ff15????????         |                     
            //   488bdf               | push                1
            //   8bf7                 | push                dword ptr [ebp + 0x14]
            //   483bdf               | mov                 edi, eax
            //   7508                 | lea                 eax, [ebp - 4]

        $sequence_62 = { 50 89450c ff15???????? 3bc3 8945f4 741a }
            // n = 6, score = 1300
            //   50                   | push                ebx
            //   89450c               | cmp                 edi, esi
            //   ff15????????         |                     
            //   3bc3                 | push                dword ptr [ebp + 0xc]
            //   8945f4               | push                ebx
            //   741a                 | cmp                 edi, esi

        $sequence_63 = { 85db 7423 8b0d???????? 0fb701 663d6100 720e 663d7a00 }
            // n = 7, score = 1300
            //   85db                 | cmovne              ecx, eax
            //   7423                 | dec                 eax
            //   8b0d????????         |                     
            //   0fb701               | mov                 dword ptr [esp + 0x20], ebx
            //   663d6100             | test                eax, eax
            //   720e                 | mov                 dword ptr [esp + 0x28], 0xea60
            //   663d7a00             | dec                 esp

        $sequence_64 = { b90e010000 41b800000100 4889442420 e8???????? e9???????? }
            // n = 5, score = 1300
            //   b90e010000           | push                0
            //   41b800000100         | push                0
            //   4889442420           | xor                 ebx, ebx
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_65 = { 33c0 e8???????? 3bc3 740f 8b35???????? 50 83c604 }
            // n = 7, score = 1300
            //   33c0                 | push                ebx
            //   e8????????           |                     
            //   3bc3                 | mov                 eax, 0x800
            //   740f                 | push                eax
            //   8b35????????         |                     
            //   50                   | push                esi
            //   83c604               | test                byte ptr [eax + 4], 8

        $sequence_66 = { 50 8bd7 e8???????? eb02 33c0 3bc3 7413 }
            // n = 7, score = 1300
            //   50                   | mov                 ebx, 0xea60
            //   8bd7                 | cmp                 dword ptr [ebp + 0x18], 0
            //   e8????????           |                     
            //   eb02                 | jne                 0xb
            //   33c0                 | push                ebx
            //   3bc3                 | mov                 ebx, 0xea60
            //   7413                 | cmp                 dword ptr [ebp + 0x18], 0

        $sequence_67 = { 8bd5 488bcf bb57000000 e8???????? }
            // n = 4, score = 1300
            //   8bd5                 | dec                 esp
            //   488bcf               | mov                 esp, edi
            //   bb57000000           | jne                 0xffffffc9
            //   e8????????           |                     

        $sequence_68 = { 8945f4 741a ff750c 668918 68???????? ff75f8 }
            // n = 6, score = 1300
            //   8945f4               | push                edi
            //   741a                 | push                esi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   668918               | push                ebx
            //   68????????           |                     
            //   ff75f8               | cmp                 edi, esi

        $sequence_69 = { ff75fc 56 ff35???????? ff15???????? 53 56 }
            // n = 6, score = 1200
            //   ff75fc               | mov                 eax, esi
            //   56                   | je                  0xffffffa5
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   53                   | xor                 edi, edi
            //   56                   | jmp                 0xf

        $sequence_70 = { 8b8c2490000000 83bc248800000000 4c8b442440 488b542448 }
            // n = 4, score = 1200
            //   8b8c2490000000       | mov                 ebx, dword ptr [ebp + 8]
            //   83bc248800000000     | test                eax, eax
            //   4c8b442440           | jne                 0xb
            //   488b542448           | xor                 ebx, ebx

        $sequence_71 = { 8be5 5d c20800 8b4330 a804 0f8451ffffff 8b470c }
            // n = 7, score = 1200
            //   8be5                 | add                 ebp, eax
            //   5d                   | dec                 eax
            //   c20800               | mov                 eax, dword ptr [esi + 0x10]
            //   8b4330               | dec                 eax
            //   a804                 | mov                 dword ptr [edi + 0x18], eax
            //   0f8451ffffff         | dec                 eax
            //   8b470c               | arpl                word ptr [esi + 0x1c], ax

        $sequence_72 = { 85c0 0f8544010000 8b472c a801 }
            // n = 4, score = 1200
            //   85c0                 | dec                 ecx
            //   0f8544010000         | mov                 ebx, dword ptr [ebx + 0x28]
            //   8b472c               | dec                 ecx
            //   a801                 | mov                 esi, dword ptr [ebx + 0x30]

        $sequence_73 = { 0f854affffff 894330 e9???????? 55 }
            // n = 4, score = 1200
            //   0f854affffff         | lea                 ecx, [eax + 3]
            //   894330               | inc                 ebp
            //   e9????????           |                     
            //   55                   | xor                 eax, eax

        $sequence_74 = { c744242000010000 ff15???????? 4883f8ff 488bf8 7442 }
            // n = 5, score = 1200
            //   c744242000010000     | jne                 0xb
            //   ff15????????         |                     
            //   4883f8ff             | xor                 ebx, ebx
            //   488bf8               | mov                 dword ptr [ebp + 8], ebx
            //   7442                 | jmp                 0xa

        $sequence_75 = { e8???????? 85c0 0f8586000000 8b4720 }
            // n = 4, score = 1200
            //   e8????????           |                     
            //   85c0                 | dec                 ecx
            //   0f8586000000         | mov                 esi, dword ptr [ebx + 0x30]
            //   8b4720               | inc                 ecx

        $sequence_76 = { 57 ff750c 53 e8???????? 3bfe 740e 57 }
            // n = 7, score = 1200
            //   57                   | mov                 eax, dword ptr [ebp + 0xc]
            //   ff750c               | mov                 dword ptr [eax], esi
            //   53                   | jmp                 0x37
            //   e8????????           |                     
            //   3bfe                 | push                0
            //   740e                 | xor                 edi, edi
            //   57                   | jmp                 0xd

        $sequence_77 = { 84c9 0f8992000000 8b4f30 f6c104 }
            // n = 4, score = 1200
            //   84c9                 | mov                 ecx, ebp
            //   0f8992000000         | mov                 eax, dword ptr [esp + 0x210]
            //   8b4f30               | dec                 esp
            //   f6c104               | lea                 ebx, [esp + 0x1f0]

        $sequence_78 = { ff5214 8bf7 8bfe e8???????? 5f 5e }
            // n = 6, score = 1200
            //   ff5214               | push                esi
            //   8bf7                 | push                ebx
            //   8bfe                 | push                esi
            //   e8????????           |                     
            //   5f                   | jne                 0x30
            //   5e                   | push                ebx

        $sequence_79 = { 83632800 e9???????? 8b4330 a840 0f84e2000000 }
            // n = 5, score = 1200
            //   83632800             | cmp                 dword ptr [ebp - 4], esi
            //   e9????????           |                     
            //   8b4330               | je                  0x17
            //   a840                 | push                dword ptr [ebp - 4]
            //   0f84e2000000         | push                ebx

        $sequence_80 = { f6400408 752e 53 e8???????? }
            // n = 4, score = 1200
            //   f6400408             | mov                 dword ptr [ebp - 0x10], ebx
            //   752e                 | mov                 dword ptr [ebp - 8], 0x57
            //   53                   | mov                 edi, 0x119
            //   e8????????           |                     

        $sequence_81 = { 56 ff35???????? 8945f8 ff15???????? 8bd8 3bde }
            // n = 6, score = 1200
            //   56                   | jmp                 0x3a
            //   ff35????????         |                     
            //   8945f8               | push                0
            //   ff15????????         |                     
            //   8bd8                 | jne                 0x10
            //   3bde                 | cmp                 dword ptr [ebp + 8], 0

        $sequence_82 = { a840 0f84e2000000 8b7334 8d442418 50 }
            // n = 5, score = 1200
            //   a840                 | push                ebx
            //   0f84e2000000         | push                1
            //   8b7334               | xor                 esi, esi
            //   8d442418             | cmp                 dword ptr [ebp - 4], esi
            //   50                   | je                  0x15

        $sequence_83 = { e8???????? 33f6 3975fc 7410 ff75fc 56 }
            // n = 6, score = 1200
            //   e8????????           |                     
            //   33f6                 | xor                 edi, edi
            //   3975fc               | jmp                 9
            //   7410                 | je                  0xa
            //   ff75fc               | push                dword ptr [ebp + 8]
            //   56                   | mov                 eax, edi

        $sequence_84 = { ff15???????? 53 56 ff35???????? ff15???????? 5b 5f }
            // n = 7, score = 1200
            //   ff15????????         |                     
            //   53                   | push                ecx
            //   56                   | pop                 edi
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   5b                   | ret                 4
            //   5f                   | push                ebp

        $sequence_85 = { 488bce ff15???????? 488b0d???????? 33d2 4c63c0 }
            // n = 5, score = 1100
            //   488bce               | inc                 ecx
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   33d2                 | pop                 ebp
            //   4c63c0               | inc                 ecx

        $sequence_86 = { 33d2 ff15???????? 483bc3 4c8be8 }
            // n = 4, score = 1100
            //   33d2                 | push                0x122
            //   ff15????????         |                     
            //   483bc3               | push                dword ptr [ebp + 8]
            //   4c8be8               | push                0

        $sequence_87 = { 6a00 ff35???????? ff15???????? 33db 6a01 }
            // n = 5, score = 1100
            //   6a00                 | test                edi, edi
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   33db                 | dec                 esp
            //   6a01                 | mov                 esp, edi

        $sequence_88 = { 48890d???????? 410fb64103 488d0cc3 48890d???????? }
            // n = 4, score = 1100
            //   48890d????????       |                     
            //   410fb64103           | push                ebp
            //   488d0cc3             | mov                 ebp, esp
            //   48890d????????       |                     

        $sequence_89 = { 48890d???????? 410fb64102 488d0cc3 48890d???????? }
            // n = 4, score = 1100
            //   48890d????????       |                     
            //   410fb64102           | je                  0xd2
            //   488d0cc3             | test                ebx, ebx
            //   48890d????????       |                     

        $sequence_90 = { 8a4b1c 488b4558 4c8b4d30 4c8b4510 }
            // n = 4, score = 1100
            //   8a4b1c               | push                eax
            //   488b4558             | xor                 eax, eax
            //   4c8b4d30             | cmp                 eax, edi
            //   4c8b4510             | je                  0x15

        $sequence_91 = { 448be8 418b4310 41394308 410f474308 }
            // n = 4, score = 1100
            //   448be8               | push                ebp
            //   418b4310             | mov                 ebp, esp
            //   41394308             | sub                 esp, 0xc
            //   410f474308           | and                 dword ptr [ebp - 8], 0

        $sequence_92 = { e8???????? 85c0 7507 33db 895d08 eb03 8b5d08 }
            // n = 7, score = 1100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   33db                 | xor                 ebx, ebx
            //   895d08               | mov                 dword ptr [ebp + 8], ebx
            //   eb03                 | jmp                 5
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_93 = { 33d2 ff15???????? 8b05???????? 418bdd }
            // n = 4, score = 1100
            //   33d2                 | dec                 eax
            //   ff15????????         |                     
            //   8b05????????         |                     
            //   418bdd               | mov                 ecx, edi

        $sequence_94 = { 5b c9 c20400 51 56 ff74240c }
            // n = 6, score = 1100
            //   5b                   | mov                 eax, dword ptr [ebp + 0xc]
            //   c9                   | mov                 dword ptr [eax], esi
            //   c20400               | jmp                 0x37
            //   51                   | push                0
            //   56                   | test                edi, edi
            //   ff74240c             | jne                 0x10

        $sequence_95 = { 4803df 410fb64101 33d2 488d0cc3 }
            // n = 4, score = 1100
            //   4803df               | jne                 7
            //   410fb64101           | push                ebx
            //   33d2                 | mov                 ebx, 0xea60
            //   488d0cc3             | push                ebx

        $sequence_96 = { 33d2 498bcc 498bfd e8???????? 493bc5 7405 8b38 }
            // n = 7, score = 1100
            //   33d2                 | dec                 esp
            //   498bcc               | mov                 dword ptr [ebp + ebx*8], esp
            //   498bfd               | add                 ebx, 1
            //   e8????????           |                     
            //   493bc5               | dec                 eax
            //   7405                 | test                edi, edi
            //   8b38                 | dec                 esp

        $sequence_97 = { 4885db 740c 4c8b0d???????? e9???????? }
            // n = 4, score = 1100
            //   4885db               | mov                 ebx, eax
            //   740c                 | test                ebx, ebx
            //   4c8b0d????????       |                     
            //   e9????????           |                     

        $sequence_98 = { ff15???????? 488bcf 48870d???????? 483bcf 7405 e8???????? }
            // n = 6, score = 1100
            //   ff15????????         |                     
            //   488bcf               | push                esi
            //   48870d????????       |                     
            //   483bcf               | mov                 esi, ecx
            //   7405                 | add                 eax, 0xfffffefe
            //   e8????????           |                     

        $sequence_99 = { 33d2 ff15???????? 4885db 740c }
            // n = 4, score = 1100
            //   33d2                 | jne                 7
            //   ff15????????         |                     
            //   4885db               | push                ebx
            //   740c                 | mov                 ebx, 0xea60

        $sequence_100 = { 745d 488b0d???????? 33d2 41b800040000 ff15???????? 4c8b4608 }
            // n = 6, score = 1100
            //   745d                 | push                eax
            //   488b0d????????       |                     
            //   33d2                 | push                0x10
            //   41b800040000         | pop                 eax
            //   ff15????????         |                     
            //   4c8b4608             | je                  0x15

        $sequence_101 = { 50 57 e8???????? e9???????? 68???????? }
            // n = 5, score = 1100
            //   50                   | cmp                 dword ptr [ebp + 8], 0
            //   57                   | je                  0x10
            //   e8????????           |                     
            //   e9????????           |                     
            //   68????????           |                     

        $sequence_102 = { 8bc3 5b c3 a1???????? 83c040 }
            // n = 5, score = 1000
            //   8bc3                 | mov                 ebp, eax
            //   5b                   | dec                 ecx
            //   c3                   | add                 eax, 0x2d
            //   a1????????           |                     
            //   83c040               | dec                 eax

        $sequence_103 = { 8b02 43 8acb d3c0 33c6 33442410 }
            // n = 6, score = 1000
            //   8b02                 | jmp                 0xc
            //   43                   | mov                 ebx, dword ptr [ebp + 8]
            //   8acb                 | xor                 ebx, ebx
            //   d3c0                 | mov                 dword ptr [ebp + 8], ebx
            //   33c6                 | jmp                 8
            //   33442410             | mov                 ebx, dword ptr [ebp + 8]

        $sequence_104 = { 8bf0 8932 83c204 ff4c240c 75e6 5e 5b }
            // n = 7, score = 1000
            //   8bf0                 | push                dword ptr [ebp + 8]
            //   8932                 | mov                 eax, edi
            //   83c204               | test                edi, edi
            //   ff4c240c             | jne                 0x10
            //   75e6                 | cmp                 dword ptr [ebp + 8], 0
            //   5e                   | je                  0x10
            //   5b                   | push                dword ptr [ebp + 8]

        $sequence_105 = { eb08 488bce e8???????? 488b5c2440 488b742448 488bc7 }
            // n = 6, score = 1000
            //   eb08                 | mov                 dword ptr [ebp + 8], ebx
            //   488bce               | jmp                 0xa
            //   e8????????           |                     
            //   488b5c2440           | test                eax, eax
            //   488b742448           | jne                 9
            //   488bc7               | xor                 ebx, ebx

        $sequence_106 = { 72dc 8b45fc 5f 5b }
            // n = 4, score = 1000
            //   72dc                 | mov                 esi, eax
            //   8b45fc               | cmp                 esi, ebx
            //   5f                   | je                  0x45
            //   5b                   | push                -1

        $sequence_107 = { 8bf1 05fefeffff 33db 33c9 }
            // n = 4, score = 1000
            //   8bf1                 | xor                 eax, esi
            //   05fefeffff           | push                dword ptr [ebp + 8]
            //   33db                 | mov                 eax, esi
            //   33c9                 | mov                 eax, dword ptr [esi]

        $sequence_108 = { 53 ff7614 ff15???????? 85c0 7512 }
            // n = 5, score = 1000
            //   53                   | push                ebx
            //   ff7614               | push                dword ptr [esi + 0x14]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14

        $sequence_109 = { 85c0 7512 ff15???????? 8bf8 81ffe5030000 750d }
            // n = 6, score = 1000
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   81ffe5030000         | cmp                 edi, 0x3e5
            //   750d                 | jne                 0xf

        $sequence_110 = { 8b3d???????? 56 ffd7 53 56 ffd7 }
            // n = 6, score = 1000
            //   8b3d????????         |                     
            //   56                   | mov                 eax, dword ptr [ebp + 0x10]
            //   ffd7                 | mov                 cl, byte ptr [ebx + 0x1c]
            //   53                   | dec                 eax
            //   56                   | mov                 eax, dword ptr [ebp + 0x58]
            //   ffd7                 | dec                 esp

        $sequence_111 = { 8ac3 5b c9 c20400 53 56 8bf0 }
            // n = 7, score = 1000
            //   8ac3                 | xor                 eax, eax
            //   5b                   | cmp                 eax, edi
            //   c9                   | je                  0x1f
            //   c20400               | push                eax
            //   53                   | xor                 eax, eax
            //   56                   | je                  0x1d
            //   8bf0                 | push                eax

        $sequence_112 = { 3bc3 7fbd 83c701 e9???????? 488b8424c8010000 }
            // n = 5, score = 900
            //   3bc3                 | push                0x122
            //   7fbd                 | push                dword ptr [ebp + 8]
            //   83c701               | push                0
            //   e9????????           |                     
            //   488b8424c8010000     | ret                 4

        $sequence_113 = { 33d2 ff15???????? 33ff 4885ff }
            // n = 4, score = 900
            //   33d2                 | dec                 eax
            //   ff15????????         |                     
            //   33ff                 | add                 esp, 0x40
            //   4885ff               | inc                 ecx

        $sequence_114 = { 33c9 bb26040000 48870d???????? 4885c9 }
            // n = 4, score = 900
            //   33c9                 | mov                 eax, dword ptr [esi]
            //   bb26040000           | mov                 ecx, dword ptr [eax]
            //   48870d????????       |                     
            //   4885c9               | push                ebx

        $sequence_115 = { 41b905000000 488bd8 ff15???????? 488bcb ff15???????? 4533c9 488bd3 }
            // n = 7, score = 900
            //   41b905000000         | mov                 eax, dword ptr [esi]
            //   488bd8               | mov                 ecx, dword ptr [eax]
            //   ff15????????         |                     
            //   488bcb               | push                edi
            //   ff15????????         |                     
            //   4533c9               | push                dword ptr [ebp + 0x10]
            //   488bd3               | push                dword ptr [ebp + 0xc]

        $sequence_116 = { ff15???????? 483bc3 488be8 0f8458010000 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   483bc3               | and                 dword ptr [ebp - 8], 0
            //   488be8               | ret                 4
            //   0f8458010000         | push                ebp

        $sequence_117 = { 483bc3 4c8be8 0f841c010000 448b05???????? }
            // n = 4, score = 900
            //   483bc3               | push                ebp
            //   4c8be8               | mov                 ebp, esp
            //   0f841c010000         | sub                 esp, 0xc
            //   448b05????????       |                     

        $sequence_118 = { 4533c9 4889442428 215c2420 4533c0 }
            // n = 4, score = 900
            //   4533c9               | add                 eax, 0xfffffefe
            //   4889442428           | xor                 ebx, ebx
            //   215c2420             | xor                 ecx, ecx
            //   4533c0               | mov                 eax, esi

        $sequence_119 = { 49bb00c0692ac9000000 488bcf 4c019c24d8010000 ff15???????? 6641b85c00 33d2 }
            // n = 6, score = 900
            //   49bb00c0692ac9000000     | mov    ebp, esp
            //   488bcf               | sub                 esp, 0xc
            //   4c019c24d8010000     | and                 dword ptr [ebp - 8], 0
            //   ff15????????         |                     
            //   6641b85c00           | push                edi
            //   33d2                 | pop                 ebx

        $sequence_120 = { 8d442430 50 8d442430 50 8d442428 50 8d442428 }
            // n = 7, score = 900
            //   8d442430             | je                  0x1f
            //   50                   | push                eax
            //   8d442430             | xor                 eax, eax
            //   50                   | cmp                 eax, edi
            //   8d442428             | jmp                 4
            //   50                   | xor                 eax, eax
            //   8d442428             | cmp                 eax, edi

        $sequence_121 = { 741d 3dd2100000 7416 a1???????? }
            // n = 4, score = 900
            //   741d                 | je                  0x15
            //   3dd2100000           | push                eax
            //   7416                 | push                0x10
            //   a1????????           |                     

        $sequence_122 = { 458be0 bb08000000 e8???????? 85c0 }
            // n = 4, score = 900
            //   458be0               | mov                 ecx, dword ptr [eax]
            //   bb08000000           | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   85c0                 | mov                 eax, esi

        $sequence_123 = { 4c8be0 0f8583000000 488b0d???????? 4d8bc5 33d2 }
            // n = 5, score = 900
            //   4c8be0               | push                0x122
            //   0f8583000000         | push                dword ptr [ebp + 8]
            //   488b0d????????       |                     
            //   4d8bc5               | push                0
            //   33d2                 | push                0

        $sequence_124 = { 8d45fc 50 ff750c 33ff ff7508 217dfc e8???????? }
            // n = 7, score = 900
            //   8d45fc               | pop                 ebx
            //   50                   | xor                 esi, esi
            //   ff750c               | cmp                 dword ptr [ebp - 4], esi
            //   33ff                 | je                  0x15
            //   ff7508               | push                dword ptr [ebp - 4]
            //   217dfc               | push                esi
            //   e8????????           |                     

        $sequence_125 = { ff35???????? ffd3 8bd8 85db 7476 }
            // n = 5, score = 900
            //   ff35????????         |                     
            //   ffd3                 | je                  0x19
            //   8bd8                 | push                eax
            //   85db                 | push                0x10
            //   7476                 | pop                 eax

        $sequence_126 = { 7416 a1???????? 83c004 50 be???????? }
            // n = 5, score = 900
            //   7416                 | je                  0x15
            //   a1????????           |                     
            //   83c004               | push                eax
            //   50                   | push                0x10
            //   be????????           |                     

        $sequence_127 = { 488bce ff15???????? 4c8d4c2450 4c8d442458 }
            // n = 4, score = 900
            //   488bce               | pop                 esi
            //   ff15????????         |                     
            //   4c8d4c2450           | inc                 ecx
            //   4c8d442458           | pop                 ebp

        $sequence_128 = { 4c8d442458 8d5001 488bce e8???????? }
            // n = 4, score = 900
            //   4c8d442458           | pop                 esi
            //   8d5001               | pop                 ebp
            //   488bce               | pop                 ebx
            //   e8????????           |                     

        $sequence_129 = { 488bd6 ff15???????? eb14 488b0d???????? 4c8bc7 33d2 }
            // n = 6, score = 900
            //   488bd6               | pop                 esp
            //   ff15????????         |                     
            //   eb14                 | pop                 edi
            //   488b0d????????       |                     
            //   4c8bc7               | mov                 esi, 1
            //   33d2                 | mov                 eax, esi

        $sequence_130 = { 41be01000000 33c9 418bd6 ff15???????? }
            // n = 4, score = 800
            //   41be01000000         | and                 dword ptr [esp + 0x20], ebx
            //   33c9                 | inc                 ebp
            //   418bd6               | xor                 ecx, ecx
            //   ff15????????         |                     

        $sequence_131 = { 448b05???????? 8b0d???????? 8b05???????? 410fc9 }
            // n = 4, score = 800
            //   448b05????????       |                     
            //   8b0d????????         |                     
            //   8b05????????         |                     
            //   410fc9               | xor                 edx, edx

        $sequence_132 = { 4c63c0 33d2 4983c00c ff15???????? }
            // n = 4, score = 800
            //   4c63c0               | add                 esp, 0x40
            //   33d2                 | inc                 ecx
            //   4983c00c             | pop                 esi
            //   ff15????????         |                     

        $sequence_133 = { 53 56 8bf1 05fefeffff }
            // n = 4, score = 800
            //   53                   | push                ecx
            //   56                   | push                dword ptr [ebp + 8]
            //   8bf1                 | mov                 eax, esi
            //   05fefeffff           | mov                 eax, dword ptr [esi]

        $sequence_134 = { 6a03 8935???????? 8935???????? 8935???????? }
            // n = 4, score = 800
            //   6a03                 | xor                 eax, dword ptr [esp + 0x10]
            //   8935????????         |                     
            //   8935????????         |                     
            //   8935????????         |                     

        $sequence_135 = { 803f2a 750b 4883c701 83c3ff }
            // n = 4, score = 800
            //   803f2a               | mov                 eax, 0x10000
            //   750b                 | dec                 eax
            //   4883c701             | mov                 dword ptr [esp + 0x20], eax
            //   83c3ff               | mov                 dword ptr [esp + 0x20], 0x100

        $sequence_136 = { ff15???????? 488b0d???????? 448bc0 8bd8 33d2 4983c001 }
            // n = 6, score = 800
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   448bc0               | mov                 ecx, 0x10e
            //   8bd8                 | inc                 ecx
            //   33d2                 | mov                 eax, 0x10000
            //   4983c001             | dec                 eax

        $sequence_137 = { a1???????? 25efff0000 0bc2 e9???????? }
            // n = 4, score = 800
            //   a1????????           |                     
            //   25efff0000           | mov                 esi, eax
            //   0bc2                 | mov                 dword ptr [edx], esi
            //   e9????????           |                     

        $sequence_138 = { e9???????? 488bcb ff15???????? a810 }
            // n = 4, score = 800
            //   e9????????           |                     
            //   488bcb               | arpl                ax, ax
            //   ff15????????         |                     
            //   a810                 | xor                 edx, edx

        $sequence_139 = { 4533c9 4533c0 33d2 ff15???????? 85c0 7511 ff15???????? }
            // n = 7, score = 800
            //   4533c9               | add                 eax, 0xc
            //   4533c0               | dec                 esp
            //   33d2                 | arpl                ax, ax
            //   ff15????????         |                     
            //   85c0                 | xor                 edx, edx
            //   7511                 | dec                 ecx
            //   ff15????????         |                     

        $sequence_140 = { 57 895df4 895df0 c745f857000000 }
            // n = 4, score = 800
            //   57                   | push                ebx
            //   895df4               | mov                 eax, edi
            //   895df0               | lea                 eax, [esi + 0x18]
            //   c745f857000000       | mov                 ecx, dword ptr [eax]

        $sequence_141 = { 53 8bc7 e8???????? 8d4618 8b08 50 }
            // n = 6, score = 700
            //   53                   | xor                 eax, esi
            //   8bc7                 | xor                 eax, dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   8d4618               | add                 edx, 4
            //   8b08                 | dec                 dword ptr [esp + 0xc]
            //   50                   | jne                 0xffffffec

        $sequence_142 = { 750a 488bcf e8???????? 8bd8 488b0d???????? 4c8bc7 33d2 }
            // n = 7, score = 700
            //   750a                 | xor                 edx, edx
            //   488bcf               | inc                 ecx
            //   e8????????           |                     
            //   8bd8                 | mov                 esi, 1
            //   488b0d????????       |                     
            //   4c8bc7               | xor                 ecx, ecx
            //   33d2                 | inc                 ecx

        $sequence_143 = { 57 4154 4155 4156 4883ec50 488bf1 }
            // n = 6, score = 700
            //   57                   | inc                 ebp
            //   4154                 | xor                 ecx, ecx
            //   4155                 | inc                 ebp
            //   4156                 | xor                 eax, eax
            //   4883ec50             | xor                 edx, edx
            //   488bf1               | test                eax, eax

        $sequence_144 = { 5f c20400 55 8bec 83e4f8 81ec9c000000 53 }
            // n = 7, score = 700
            //   5f                   | jne                 0x12
            //   c20400               | cmp                 dword ptr [ebp + 8], 0
            //   55                   | je                  0xe
            //   8bec                 | push                dword ptr [ebp + 8]
            //   83e4f8               | cmp                 dword ptr [ebp + 8], 0
            //   81ec9c000000         | je                  0xe
            //   53                   | push                dword ptr [ebp + 8]

        $sequence_145 = { 6a20 40 50 ffd6 }
            // n = 4, score = 700
            //   6a20                 | mov                 eax, esi
            //   40                   | test                eax, eax
            //   50                   | je                  0xffffffa5
            //   ffd6                 | xor                 edi, edi

        $sequence_146 = { 488d542438 488bcb e8???????? eb02 33c0 85c0 }
            // n = 6, score = 700
            //   488d542438           | push                eax
            //   488bcb               | add                 esi, 4
            //   e8????????           |                     
            //   eb02                 | cmp                 edi, ebx
            //   33c0                 | je                  8
            //   85c0                 | push                eax

        $sequence_147 = { 5e 33c0 c9 c20400 55 8bec 51 }
            // n = 7, score = 700
            //   5e                   | jmp                 0xd
            //   33c0                 | xor                 edi, edi
            //   c9                   | push                ebx
            //   c20400               | mov                 eax, esi
            //   55                   | test                eax, eax
            //   8bec                 | jne                 0x1a
            //   51                   | test                edi, edi

        $sequence_148 = { 488b0d???????? 4889040f 4883c708 492bf6 }
            // n = 4, score = 700
            //   488b0d????????       |                     
            //   4889040f             | mov                 esi, 1
            //   4883c708             | xor                 ecx, ecx
            //   492bf6               | inc                 ecx

        $sequence_149 = { ff7508 8bc6 e8???????? 8b06 8b08 57 ff7510 }
            // n = 7, score = 700
            //   ff7508               | pop                 esi
            //   8bc6                 | pop                 ebx
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [edx]
            //   8b08                 | inc                 ebx
            //   57                   | mov                 cl, bl
            //   ff7510               | rol                 eax, cl

        $sequence_150 = { 7417 4863461c 2b6e1c 4c03e8 488b4610 48894718 4883661000 }
            // n = 7, score = 600
            //   7417                 | xor                 eax, eax
            //   4863461c             | cmp                 eax, ebx
            //   2b6e1c               | je                  0x1d
            //   4c03e8               | cmp                 eax, ebx
            //   488b4610             | je                  0x11
            //   48894718             | push                eax
            //   4883661000           | add                 esi, 4

        $sequence_151 = { 33d2 ff15???????? 83bc241002000000 7416 488d942410020000 4c8bcf 458bc4 }
            // n = 7, score = 600
            //   33d2                 | je                  0x11
            //   ff15????????         |                     
            //   83bc241002000000     | push                eax
            //   7416                 | add                 esi, 4
            //   488d942410020000     | cmp                 edi, ebx
            //   4c8bcf               | cmp                 eax, ebx
            //   458bc4               | je                  8

        $sequence_152 = { 21b42410020000 eb0d ff15???????? 89842410020000 }
            // n = 4, score = 600
            //   21b42410020000       | cmp                 edi, ebx
            //   eb0d                 | je                  0x1b
            //   ff15????????         |                     
            //   89842410020000       | cmp                 eax, ebx

        $sequence_153 = { 488b8c2428020000 488364242000 448d4803 4533c0 }
            // n = 4, score = 600
            //   488b8c2428020000     | cmp                 eax, ebx
            //   488364242000         | je                  0x11
            //   448d4803             | push                eax
            //   4533c0               | add                 esi, 4

        $sequence_154 = { 488364242000 448d4803 4533c0 488bd3 ff15???????? 488b8c2428020000 8bf0 }
            // n = 7, score = 600
            //   488364242000         | mov                 edx, edi
            //   448d4803             | jmp                 6
            //   4533c0               | xor                 eax, eax
            //   488bd3               | cmp                 eax, ebx
            //   ff15????????         |                     
            //   488b8c2428020000     | je                  0x25
            //   8bf0                 | cmp                 eax, ebx

        $sequence_155 = { 807de502 764d 0fb645e5 83c0fe 33c9 }
            // n = 5, score = 600
            //   807de502             | push                ebx
            //   764d                 | mov                 eax, esi
            //   0fb645e5             | cmp                 dword ptr [ebp + 8], 0
            //   83c0fe               | je                  0xa
            //   33c9                 | push                dword ptr [ebp + 8]

        $sequence_156 = { 418bcd e8???????? 8b842410020000 4c8d9c24f0010000 }
            // n = 4, score = 600
            //   418bcd               | cmp                 edi, ebx
            //   e8????????           |                     
            //   8b842410020000       | je                  0x19
            //   4c8d9c24f0010000     | je                  0x11

        $sequence_157 = { 488bcb ff15???????? 8bc8 ff15???????? 21b42410020000 }
            // n = 5, score = 600
            //   488bcb               | push                ebp
            //   ff15????????         |                     
            //   8bc8                 | xor                 eax, eax
            //   ff15????????         |                     
            //   21b42410020000       | cmp                 eax, edi

        $sequence_158 = { 33c0 ebe3 55 8bec 83ec18 53 56 }
            // n = 7, score = 600
            //   33c0                 | test                eax, eax
            //   ebe3                 | jne                 0x1d
            //   55                   | test                edi, edi
            //   8bec                 | jne                 0x10
            //   83ec18               | cmp                 dword ptr [ebp + 8], 0
            //   53                   | je                  0x10
            //   56                   | push                dword ptr [ebp + 8]

        $sequence_159 = { 4883c428 c3 488d82204a0000 488982284a0000 }
            // n = 4, score = 600
            //   4883c428             | je                  0x4b
            //   c3                   | mov                 ecx, dword ptr [esp + 0x90]
            //   488d82204a0000       | cmp                 dword ptr [esp + 0x88], 0
            //   488982284a0000       | dec                 esp

        $sequence_160 = { 7415 397b44 7510 488b0b e8???????? 85c0 0f859b000000 }
            // n = 7, score = 500
            //   7415                 | mov                 ebx, dword ptr [ebp + 8]
            //   397b44               | push                esi
            //   7510                 | push                edi
            //   488b0b               | xor                 edi, edi
            //   e8????????           |                     
            //   85c0                 | mov                 ebp, esp
            //   0f859b000000         | sub                 esp, 0x48

        $sequence_161 = { e8???????? 488b0d???????? 4c8bc3 33d2 ff15???????? 488b0d???????? 4c8bc7 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   4c8bc3               | push                eax
            //   33d2                 | cmp                 eax, edi
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   4c8bc7               | je                  0x1d

        $sequence_162 = { eb0b 8b434c 84c0 0f89a3000000 8b434c a804 7415 }
            // n = 7, score = 500
            //   eb0b                 | push                ebx
            //   8b434c               | mov                 ebx, dword ptr [ebp + 8]
            //   84c0                 | push                esi
            //   0f89a3000000         | push                edi
            //   8b434c               | xor                 edi, edi
            //   a804                 | mov                 edx, edi
            //   7415                 | jmp                 4

        $sequence_163 = { 8b4348 a801 742c 488b0b e8???????? 85c0 0f85e8000000 }
            // n = 7, score = 500
            //   8b4348               | cmp                 edi, ebx
            //   a801                 | je                  0x16
            //   742c                 | cmp                 eax, ebx
            //   488b0b               | je                  0xa
            //   e8????????           |                     
            //   85c0                 | push                eax
            //   0f85e8000000         | cmp                 edi, ebx

        $sequence_164 = { 4533c0 33db 89442430 e8???????? 483bc3 488905???????? 0f84b9020000 }
            // n = 7, score = 500
            //   4533c0               | push                eax
            //   33db                 | xor                 eax, eax
            //   89442430             | cmp                 eax, edi
            //   e8????????           |                     
            //   483bc3               | je                  0x15
            //   488905????????       |                     
            //   0f84b9020000         | xor                 eax, eax

        $sequence_165 = { 488905???????? 0f8431020000 817424302083b8ed 8d7b01 }
            // n = 4, score = 500
            //   488905????????       |                     
            //   0f8431020000         | push                eax
            //   817424302083b8ed     | xor                 eax, eax
            //   8d7b01               | cmp                 eax, edi

        $sequence_166 = { 0f8480010000 448b484c 41f6c108 7415 }
            // n = 4, score = 500
            //   0f8480010000         | test                al, 0x40
            //   448b484c             | je                  0xea
            //   41f6c108             | mov                 esi, dword ptr [ebx + 0x34]
            //   7415                 | lea                 eax, [esp + 0x18]

        $sequence_167 = { e9???????? 488d942498000000 488d4c2430 4889442420 e8???????? 85c0 7574 }
            // n = 7, score = 500
            //   e9????????           |                     
            //   488d942498000000     | inc                 ecx
            //   488d4c2430           | push                esp
            //   4889442420           | inc                 ecx
            //   e8????????           |                     
            //   85c0                 | push                ebp
            //   7574                 | inc                 ecx

        $sequence_168 = { e8???????? 85c0 0f859b000000 4863533c 488b4608 488b0e 48035334 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   85c0                 | cmp                 eax, ebx
            //   0f859b000000         | je                  0x23
            //   4863533c             | cmp                 edi, ebx
            //   488b4608             | je                  0x16
            //   488b0e               | cmp                 eax, ebx
            //   48035334             | je                  0x11

        $sequence_169 = { 4c8d40cc 33d2 33c9 e8???????? 85c0 0f8561010000 8b4348 }
            // n = 7, score = 500
            //   4c8d40cc             | mov                 esp, ebx
            //   33d2                 | dec                 eax
            //   33c9                 | mov                 edx, ebx
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f8561010000         | mov                 ecx, dword ptr [esp + 0x228]
            //   8b4348               | mov                 esi, eax

        $sequence_170 = { e8???????? 85c0 0f85e8000000 488b4608 488b0e 4533c9 448bc5 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   85c0                 | sub                 esp, 0x1f0
            //   0f85e8000000         | xor                 esi, esi
            //   488b4608             | xor                 eax, eax
            //   488b0e               | sub                 esp, 0x48
            //   4533c9               | push                ebx
            //   448bc5               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_171 = { 8bd8 85c0 0f85f3010000 4c8b842418020000 8d5808 }
            // n = 5, score = 400
            //   8bd8                 | dec                 eax
            //   85c0                 | add                 esi, 8
            //   0f85f3010000         | cmp                 ebp, 5
            //   4c8b842418020000     | jb                  0xffffffcd
            //   8d5808               | jmp                 0x1a

        $sequence_172 = { 89442428 488b842410020000 4889442420 e8???????? 8bd8 }
            // n = 5, score = 400
            //   89442428             | jb                  0xffffffc6
            //   488b842410020000     | jmp                 0x13
            //   4889442420           | mov                 ebx, 0x7f
            //   e8????????           |                     
            //   8bd8                 | jmp                 0x13

        $sequence_173 = { 4533c0 ff15???????? 8bd8 83f801 }
            // n = 4, score = 400
            //   4533c0               | add                 ebp, esi
            //   ff15????????         |                     
            //   8bd8                 | dec                 eax
            //   83f801               | add                 esi, 8

        $sequence_174 = { 4885c0 7427 488d542420 b901020000 ff15???????? 85c0 }
            // n = 6, score = 400
            //   4885c0               | cmp                 ebp, 5
            //   7427                 | jb                  0xffffffc3
            //   488d542420           | jmp                 0x10
            //   b901020000           | mov                 ebx, 0x7f
            //   ff15????????         |                     
            //   85c0                 | jmp                 0x10

        $sequence_175 = { ba10000000 488bc8 e8???????? 48898424e0010000 4885c0 }
            // n = 5, score = 400
            //   ba10000000           | dec                 eax
            //   488bc8               | add                 esi, 8
            //   e8????????           |                     
            //   48898424e0010000     | cmp                 ebp, 5
            //   4885c0               | jb                  0xffffffc3

        $sequence_176 = { 488d542440 e8???????? 8bd8 85c0 7541 }
            // n = 5, score = 400
            //   488d542440           | dec                 ecx
            //   e8????????           |                     
            //   8bd8                 | mov                 ecx, esp
            //   85c0                 | dec                 ecx
            //   7541                 | mov                 edi, ebp

        $sequence_177 = { 4c8be8 4885c0 7508 8d5f08 e9???????? 8b842420020000 }
            // n = 6, score = 400
            //   4c8be8               | je                  0x10
            //   4885c0               | inc                 ecx
            //   7508                 | add                 ebp, esi
            //   8d5f08               | dec                 eax
            //   e9????????           |                     
            //   8b842420020000       | add                 esi, 8

        $sequence_178 = { 4c89642448 ff15???????? 8bd8 83f8ff }
            // n = 4, score = 400
            //   4c89642448           | mov                 ebx, 0x7e
            //   ff15????????         |                     
            //   8bd8                 | dec                 eax
            //   83f8ff               | add                 esi, 8

        $sequence_179 = { 8b4c241c 01d1 894c2414 8b4c2424 01c1 83c304 894c2410 }
            // n = 7, score = 300
            //   8b4c241c             | mov                 esp, edi
            //   01d1                 | jne                 0xffffffcc
            //   894c2414             | dec                 eax
            //   8b4c2424             | mov                 dword ptr [esi], ebp
            //   01c1                 | jmp                 0xf
            //   83c304               | jne                 0xffffffc6
            //   894c2410             | dec                 eax

        $sequence_180 = { 59 89ec 5d c20c00 60 8b742424 }
            // n = 6, score = 300
            //   59                   | lea                 ecx, [eax + 1]
            //   89ec                 | mov                 dx, 0x20
            //   5d                   | add                 ebx, 1
            //   c20c00               | dec                 eax
            //   60                   | test                edi, edi
            //   8b742424             | dec                 esp

        $sequence_181 = { 8b5304 83c304 01f2 8b4c241c }
            // n = 4, score = 300
            //   8b5304               | dec                 eax
            //   83c304               | lea                 ecx, [eax + 1]
            //   01f2                 | mov                 dx, 0x20
            //   8b4c241c             | xor                 edx, edx

        $sequence_182 = { 0f869c000000 eb04 8b742428 84c9 742f }
            // n = 5, score = 300
            //   0f869c000000         | mov                 dword ptr [esi], ebp
            //   eb04                 | jmp                 4
            //   8b742428             | xor                 ebx, ebx
            //   84c9                 | mov                 byte ptr [esi + 8], bl
            //   742f                 | mov                 ebx, 1

        $sequence_183 = { 6601da c1ca03 895510 3010 40 c1ca08 e2e4 }
            // n = 7, score = 300
            //   6601da               | mov                 edi, eax
            //   c1ca03               | mov                 ebx, 1
            //   895510               | dec                 ecx
            //   3010                 | mov                 ecx, esp
            //   40                   | jmp                 0xc
            //   c1ca08               | add                 ebx, 1
            //   e2e4                 | dec                 eax

        $sequence_184 = { b101 3b5c2428 0f8266ffffff 5f 5e 89e8 }
            // n = 6, score = 300
            //   b101                 | add                 ebx, 1
            //   3b5c2428             | dec                 eax
            //   0f8266ffffff         | test                edi, edi
            //   5f                   | dec                 esp
            //   5e                   | mov                 esp, edi
            //   89e8                 | jne                 0xffffffcf

        $sequence_185 = { 01cb c644241300 30c9 eb67 8044241301 0fb6ca 01cb }
            // n = 7, score = 300
            //   01cb                 | dec                 eax
            //   c644241300           | test                eax, eax
            //   30c9                 | dec                 eax
            //   eb67                 | mov                 ebp, eax
            //   8044241301           | je                  0x5f
            //   0fb6ca               | dec                 eax
            //   01cb                 | test                edi, edi

        $sequence_186 = { 034510 39d0 75c3 5e 5f 5b }
            // n = 6, score = 300
            //   034510               | dec                 ecx
            //   39d0                 | mov                 ecx, esp
            //   75c3                 | jmp                 0xc
            //   5e                   | add                 ebx, 1
            //   5f                   | dec                 eax
            //   5b                   | lea                 ecx, [eax + 1]

    condition:
        7 of them and filesize &lt; 2940928
}