import { ESTree } from "meriyah";
import { ASTNode, NodePath } from ".";
import { PrimitiveValue } from ".";
export declare const isNode: (candidate: unknown) => candidate is ASTNode;
export declare const isNodePath: (candidate: unknown) => candidate is NodePath;
export declare const isLiteral: (candidate: unknown) => candidate is ESTree.Literal;
export declare const isPrimitive: (value: unknown) => value is PrimitiveValue;
export declare const isUpdateExpression: (value: unknown) => value is ESTree.UpdateExpression;
export declare const isAssignmentExpression: (node: ESTree.Node) => node is ESTree.AssignmentExpression;
export declare const isMemberExpression: (node: ESTree.Node) => node is ESTree.MemberExpression;
export declare const isIdentifier: (node: ESTree.Node) => node is ESTree.Identifier;
export declare const isFunctionDeclaration: (node: ESTree.Node) => node is ESTree.FunctionDeclaration;
export declare const isFunctionExpression: (node: ESTree.Node) => node is ESTree.FunctionExpression;
export declare const isVariableDeclarator: (node: ESTree.Node) => node is ESTree.VariableDeclarator;
export declare const isVariableDeclaration: (node: ESTree.Node) => node is ESTree.VariableDeclaration;
export declare const isBinding: (node: ESTree.Node, parentNode: ESTree.Node, grandParentNode: ESTree.Node | undefined) => boolean;
export declare const VISITOR_KEYS: Record<ESTree.Node["type"], string[]>;
export declare function isScope(node: ESTree.Node, parentNode: ESTree.Node): boolean;
export declare function isScopable(node: ESTree.Node): boolean;
export declare function isExportSpecifier(node: ESTree.Node): node is ESTree.ExportSpecifier;
//# sourceMappingURL=nodeutils.d.ts.map