import { type _Node, type SourceLocation } from './estree';
import { type Location } from './common';
export declare const enum Errors {
    Unexpected = 0,
    StrictOctalEscape = 1,
    TemplateOctalLiteral = 2,
    TemplateEightAndNine = 3,
    InvalidPrivateIdentifier = 4,
    InvalidUnicodeEscapeSequence = 5,
    InvalidCodePoint = 6,
    InvalidHexEscapeSequence = 7,
    StrictDecimalWithLeadingZero = 8,
    StrictOctalLiteral = 9,
    ExpectedNumberInRadix = 10,
    MissingExponent = 11,
    InvalidBigInt = 12,
    IDStartAfterNumber = 13,
    InvalidEightAndNine = 14,
    StrictEightAndNine = 15,
    UnterminatedString = 16,
    UnterminatedTemplate = 17,
    UnterminatedComment = 18,
    InvalidDynamicUnicode = 19,
    IllegalCharacter = 20,
    MissingHexDigits = 21,
    InvalidImplicitOctal = 22,
    InvalidStringLT = 23,
    InvalidEscapeIdentifier = 24,
    ExpectedToken = 25,
    CantAssignTo = 26,
    InvalidLHSAsyncArrow = 27,
    SuperNoConstructor = 28,
    InvalidSuperProperty = 29,
    UnexpectedToken = 30,
    AwaitInParameter = 31,
    YieldInParameter = 32,
    InvalidExponentiationLHS = 33,
    UnterminatedRegExp = 34,
    UnexpectedTokenRegExpFlag = 35,
    DuplicateRegExpFlag = 36,
    AccessorWrongArgs = 37,
    BadSetterRestParameter = 38,
    DeclNoName = 39,
    StrictFunctionName = 40,
    RestMissingArg = 41,
    InvalidGeneratorGetter = 42,
    InvalidGeneratorSetter = 43,
    InvalidComputedPropName = 44,
    InvalidGetSetGenerator = 45,
    InvalidAsyncGetter = 46,
    InvalidGenMethodShorthand = 47,
    InvalidLineBreak = 48,
    InvalidArrowDestructLHS = 49,
    InvalidBindingDestruct = 50,
    InvalidAsyncArrow = 51,
    StaticPrototype = 52,
    InvalidConstructor = 53,
    DuplicateConstructor = 54,
    InvalidIncDecTarget = 55,
    InvalidIncDecNew = 56,
    InvalidAssignmentTarget = 57,
    InvalidRestTrailing = 58,
    DeclarationMissingInitializer = 59,
    ForInOfLoopInitializer = 60,
    ForInOfLoopMultiBindings = 61,
    InvalidShorthandPropInit = 62,
    DuplicateProto = 63,
    InvalidLetBoundName = 64,
    InvalidNewUnary = 65,
    IllegalUseStrict = 66,
    DisallowedLetInStrict = 67,
    IllegalContinue = 68,
    IllegalBreak = 69,
    InvalidLetBracket = 70,
    InvalidDestructuringTarget = 71,
    RestDefaultInitializer = 72,
    InvalidRestNotLast = 73,
    InvalidRestArg = 74,
    InvalidRestDefault = 75,
    StrictFunction = 76,
    SloppyFunction = 77,
    WebCompatFunction = 78,
    ClassForbiddenAsStatement = 79,
    CantAssignToInOfForLoop = 80,
    InvalidAssignmentInOfForLoop = 81,
    InvalidForAwait = 82,
    InvalidTemplateContinuation = 83,
    RestrictedLetProduction = 84,
    UnexpectedLetStrictReserved = 85,
    InvalidCatchParams = 86,
    InvalidCatchParamDefault = 87,
    NoCatchOrFinally = 88,
    MultipleDefaultsInSwitch = 89,
    NewlineAfterThrow = 90,
    StrictWith = 91,
    IllegalReturn = 92,
    InvalidForLHSBinding = 93,
    InvalidNewTarget = 94,
    InvalidEscapedKeyword = 95,
    MissingPrivateIdentifier = 96,
    DisallowedInContext = 97,
    AwaitOutsideAsync = 98,
    InvalidStrictLet = 99,
    InvalidLetConstBinding = 100,
    InvalidLetClassName = 101,
    KeywordNotId = 102,
    InvalidImportExportSloppy = 103,
    UnicodeOverflow = 104,
    InvalidExportImportSource = 105,
    InvalidKeywordAsAlias = 106,
    InvalidDefaultImport = 107,
    TrailingDecorators = 108,
    GeneratorConstructor = 109,
    AwaitIdentInModuleOrAsyncFunc = 110,
    YieldIdentInModule = 111,
    HtmlCommentInWebCompat = 112,
    StrictInvalidLetInExprPos = 113,
    NotAssignableLetArgs = 114,
    ForOfLet = 115,
    InvalidInvokedBlockBodyArrow = 116,
    InvalidAccessedBlockBodyArrow = 117,
    UnexpectedStrictReserved = 118,
    StrictEvalArguments = 119,
    InvalidDecoratorSemicolon = 120,
    StrictDelete = 121,
    InvalidPatternTail = 122,
    AsyncFunctionInSingleStatementContext = 123,
    InvalidTernaryYield = 124,
    InvalidArrowPostfix = 125,
    InvalidObjLitKeyStar = 126,
    DeletePrivateField = 127,
    InvalidStaticClassFieldConstructor = 128,
    InvalidClassFieldConstructor = 129,
    InvalidClassFieldArgEval = 130,
    InvalidGeneratorFunction = 131,
    AsyncRestrictedProd = 132,
    UnexpectedCharAfterObjLit = 133,
    InvalidObjLitKey = 134,
    InvalidKeyToken = 135,
    LabelRedeclaration = 136,
    InvalidNestedStatement = 137,
    UnknownLabel = 138,
    InvalidImportTail = 139,
    InvalidJSONImportBinding = 140,
    ImportNotOneArg = 141,
    InvalidImportNew = 142,
    InvalidSpreadInImport = 143,
    IncompleteArrow = 144,
    DuplicateBinding = 145,
    DuplicatePrivateIdentifier = 146,
    DuplicateExportBinding = 147,
    UndeclaredExportedBinding = 148,
    UnexpectedPrivateField = 149,
    DuplicateLetConstBinding = 150,
    CantAssignToValidRHS = 151,
    ContinuousNumericSeparator = 152,
    TrailingNumericSeparator = 153,
    InvalidJSXAttributeValue = 154,
    ExpectedJSXClosingTag = 155,
    AdjacentJSXElements = 156,
    InvalidNonEmptyJSXExpr = 157,
    DuplicateIdentifier = 158,
    ShadowedCatchClause = 159,
    InvalidDotProperty = 160,
    UnclosedSpreadElement = 161,
    CatchWithoutTry = 162,
    FinallyWithoutTry = 163,
    UnCorrespondingFragmentTag = 164,
    InvalidCoalescing = 165,
    OptionalChainingNoTemplate = 166,
    OptionalChainingNoSuper = 167,
    OptionalChainingNoNew = 168,
    ImportMetaOutsideModule = 169,
    InvalidLeadingDecorator = 170,
    InvalidExportName = 171,
    InvalidExportReference = 172,
    InvalidSuperPrivate = 173,
    InvalidImportMeta = 174,
    InvalidEscapedImportMeta = 175,
    InvalidAwaitAsIdentifier = 176,
    InvalidAwaitInStaticBlock = 177
}
export declare class ParseError extends SyntaxError implements _Node {
    start: number;
    end: number;
    range: [number, number];
    loc: SourceLocation;
    description: string;
    constructor(start: Location, end: Location, type: Errors, ...params: string[]);
}
