import { ESTree } from 'meriyah';

declare const functions: {
    join: {
        fn: (result: Result[][]) => Result[];
    };
    concat: {
        fn: (result: Result[][]) => Result[];
    };
    first: {
        fn: (result: Result[][]) => Result[];
    };
    nthchild: {
        fn: (result: Result[][]) => Result[];
    };
};
type AvailableFunction = keyof typeof functions;
declare function isAvailableFunction(name: string): name is AvailableFunction;
type PrimitiveValue = string | number | boolean;
type Result = ASTNode | PrimitiveValue;
declare function query(code: string | ASTNode, query: string, returnAST?: boolean): Result[] & {
    __AST?: ASTNode;
};
declare function multiQuery<T extends Record<string, string>>(code: string | ASTNode, namedQueries: T, returnAST?: boolean): Record<keyof T, Result[]> & {
    __AST?: ASTNode;
};
declare function parseSource(source: string, optimize?: boolean): ASTNode;
type Binding = {
    path: NodePath;
};
type Scope = {
    bindings: Record<string, Binding>;
    parentScopeId?: number;
    id: number;
};
type ASTNode = ESTree.Node & {
    extra?: {
        scopeId?: number;
        functionScopeId?: number;
        nodePath?: NodePath;
    };
};
type NodePath = {
    node: ASTNode;
    key?: string;
    parentPath?: NodePath;
    parentKey?: string;
    scopeId: number;
    functionScopeId: number;
};
type Visitor<T> = {
    enter: (path: NodePath, state: T) => void;
    exit: (path: NodePath, state: T) => void;
};
declare function createTraverser(): {
    traverse: <T>(node: ASTNode, visitor: Visitor<T>, scopeId: number | undefined, state: T, path?: NodePath) => void;
    createNodePath: (node: ASTNode, key: string | undefined | number, parentKey: string | undefined, scopeId: number | undefined, functionScopeId: number | undefined, nodePath?: NodePath) => NodePath;
    getChildren: (key: string, path: NodePath) => NodePath[];
    getPrimitiveChildren: (key: string, path: NodePath) => PrimitiveValue[];
    getPrimitiveChildrenOrNodePaths: (key: string, path: NodePath) => Array<PrimitiveValue | NodePath>;
    getBinding: (scopeId: number, name: string) => Binding | undefined;
};

export { type ASTNode, type AvailableFunction, type Binding, type NodePath, type PrimitiveValue, type Scope, createTraverser as default, functions, isAvailableFunction, multiQuery, parseSource, query };
