### All in One Recon Tool

The purpose of this tool is to help bug hunters and pentesters during reconnaissance...

### Installation:

Can be used on any system with python3

You can easily install SR-71 using pip:

```bash
pip3 install SR-71

```

To use it, just type "**SR-71**" in your terminal

If you want to install it from source:

```bash
git clone https://gitlab.com/Edu0x01/SR-71.git

cd SR-71

pip3 install -r requirements.txt

```

### Help Panel:

```bash
SR-71 - All in One Recon Tool

options:

  -h, --help                    show this help message and exit
  -d DOMAIN, --domain DOMAIN    domain to search its subdomains
  -o OUTPUT, --output OUTPUT    file to store the scan output
  -t TOKEN, --token TOKEN       api token of hunter.io to discover mail accounts and employees
  -p, --portscan                perform a fast and stealthy scan of the most common ports
  -a, --axfr                    try a domain zone transfer attack
  -m, --mail                    try to enumerate mail servers
  -e, --extra                   look for extra dns information
  -n, --nameservers             try to enumerate the name servers
  -i, --ip                      it reports the ip or ips of the domain
  -6, --ipv6                    enumerate the ipv6 of the domain
  -w, --waf                     discover the WAF of the domain main page
  -b, --backups                 discover common backups files in the web page
  -s, --subtakeover             check if any of the subdomains are vulnerable to Subdomain Takeover
  -r, --repos                   try to discover valid repositories and s3 servers of the domain (still improving it)
  -c, --check                   check active subdomains and store them into a file
  --secrets                     crawl the web page to find secrets and api keys (e.g. Google Maps API Key)
  --enum                        stealthily enumerate and identify common technologies
  --whois                       perform a whois query to the domain
  --wayback                     find useful information about the domain and his different endpoints using The Wayback Machine and other services
  --all                         perform all the enumeration at once (best choice)
  --quiet                       dont print the banner
  --version                     display the script version
```

### Use:

A list of examples for using the tool in different ways

## Most basic usage to discover all subdomains:

```bash
python3 SR-71.py -d example.com
```

## Enumerate subdomains and store them in a file:

```bash
python3 SR-71.py -d example.com --output domains.txt
```

## Do not show banner:

```bash
python3 SR-71.py -d example.com --quiet
```

## Enumerate specific things using parameters:

```bash
python3 SR-71.py -d example.com -n -p -w -b --whois --enum # Você pode usar outros parâmetros, consulte o painel de ajuda
```

## Perform all recognition functions (recommended)

```bash
python3 SR-71.py -d domain.com --all
```

### Characteristics:

☑ Enumeration of subdomains using passive techniques (such as "**subfinder**")

☑ Lots of extra queries to enumerate DNS

☑ Domain Zone Transfer Attack

☑ WAF type detection

☑ Common enumeration (CMSs, reverse proxies, jquery...)

☑ Target domain "**Whois**"

☑ Subdomain Acquisition Checker

☑ Check for common open ports

☑ Checks active subdomains (like "**httprobe**" )

☑ Wayback machine support for enumerating endpoints (like "**waybackurls**" )

☑ Email Harvesting

### Pendency:

- Compare results with other tools such as **subfinder**, **gau**, **httprobe**...
- Improve existing code and functions

### Third part

The tool uses different services to obtain subdomains in different ways

The WAF detector was modified and adapted from the [CRLFSuite](https://github.com/Nefcore/CRLFsuite) concept <3

All DNS queries use **dns-python** 100%, no **digging** or any extra tools required

Email collection functions are done using the **Hunter.io** API with personal token (free registration)

##Extra

**If you find this project useful, I would really appreciate supporting me by giving this repository a star or buying me a coffee.**

[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/edu0x01)

Copyright © 2023, _Edu0x01_
