# Code of Conduct

This code of conduct outlines our expectations for participants within the [theZoo](https://www.github.com/ytisf/theZoo/) community, as well as steps to reporting unacceptable behaviour. We are committed to providing a welcoming and inspiring community for all and expect our code of conduct to be honoured. Anyone who violates this code of conduct may be banned from the community.

Our open source community strives to:

* **Be friendly and patient.**
* **Be welcoming**: We strive to be a community that welcomes and supports people of all backgrounds and identities. This includes, but is not limited to members of any race, ethnicity, culture, national origin, colour, immigration status, social and economic class, educational level, sex, sexual orientation, gender identity and expression, age, size, family status, political belief, religion, and mental and physical ability.
* **Be considerate**: Your work will be used by other people, and you in turn will depend on the work of others. Any decision you take will affect users and colleagues, and you should take those consequences into account when making decisions. Remember that we're a world-wide community, so you might not be communicating in someone else's primary language.
* **Be respectful**:  Not all of us will agree all the time, but disagreement is no excuse for poor behaviour and poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It’s important to remember that a community where people feel uncomfortable or threatened is not a productive one.
* **Be careful in the words that you choose**: we are a community of professionals, and we conduct ourselves professionally. Be kind to others. Do not insult or put down other participants. Harassment and other exclusionary behaviour aren't acceptable. This includes, but is not limited to:
  * Violent threats or language directed against another person.
  * Discriminatory jokes and language.
  * Posting sexually explicit or violent material.
  * Posting (or threatening to post) other people's personally identifying information ("doxing").
  * Personal insults, especially those using racist or sexist terms.
  * Unwelcome sexual attention.
  * Advocating for, or encouraging, any of the above behaviour.
  * Repeated harassment of others. In general, if someone asks you to stop, then stop.
* **When we disagree, try to understand why**: Disagreements, both social and technical, happen all the time. It is important that we resolve disagreements and differing views constructively. Remember that we’re different. The strength of our community comes from its diversity, people from a wide range of backgrounds. Different people have different perspectives on issues. Being unable to understand why someone holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that it is human to err and blaming each other doesn’t get us anywhere. Instead, focus on helping to resolve issues and learning from mistakes.

This code is not exhaustive or complete. It serves to distill our common understanding of a collaborative, shared environment, and goals. We expect it to be followed in spirit as much as in the letter.

### Diversity Statement

We encourage everyone to participate and are committed to building a community for all. Although we may not be able to satisfy everyone, we all agree that everyone is equal. Whenever a participant has made a mistake, we expect them to take responsibility for it. If someone has been harmed or offended, it is our responsibility to listen carefully and respectfully, and do our best to right the wrong.

Although this list cannot be exhaustive, we explicitly honour diversity in age, gender, gender identity or expression, culture, ethnicity, language, national origin, political beliefs, profession, race, religion, sexual orientation, socioeconomic status, and technical ability. We will not tolerate discrimination based on any of the protected
characteristics above, including participants with disabilities.

### Unacceptable Behaviour

Harassment may include but not limited to the following:

- Offensive, inappropriate, or unwanted comments related to gender, gender identity or expression, sexual orientation, disability, physical appearance, body size, race, ethnicity, national origin, religion, or age, or other protected categories under applicable law.
- Visual harassment eg. sexual imagery or use of sexual language at Docker community events
- Disrespect towards differences of opinion
- Deliberate intimidation, stalking, harassing photography or recording
- Sustained disruption of talks or other events
- Inappropriate or unwanted physical contact
- Intimidation or bullying (online or in-person)
- Unwelcome sexual attention

### Reporting Issues

If you experience or witness unacceptable behaviour—or have any other concerns—please report it by contacting us via [this email address](mailto:thezoo+codeofconduct@morirt.com). All reports will be handled with discretion.

Anyone asked to stop unacceptable behaviour is expected to comply immediately. If an individual engages in unacceptable behaviour the representative may take any action they deem appropriate, up to and including a permanent ban from our community without warning.

## Thanks

This code of conduct is based on the [Open Code of Conduct](https://github.com/todogroup/opencodeofconduct) from the [TODOGroup](http://todogroup.org).

Portions derived from the [Slack Developer Community Code of Conduct](https://api.slack.com/docs/community-code-of-conduct), [The Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/), [geekfeminism.org](https://geekfeminism.org/about/code-of-conduct/)  and [Docker Code of Conduct](https://raw.githubusercontent.com/docker/code-of-conduct/master/code-of-conduct-EN.md).

We are thankful for their work and all the communities who have paved the way with code of conducts.
