'''
This file is part of VoIPER.

VoIPER is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

VoIPER is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with VoIPER.  If not, see <http://www.gnu.org/licenses/>.

Copyright 2008, http://www.unprotectedhex.com
Contact: nnp@unprotectedhex.com
'''

import sys

from optparse import OptionParser

from misc.crash_replay_utilities import CrashFileReplay

opt_parser = OptionParser()
opt_parser.add_option('-i', '--host', dest='host', help='Host address to \
connect to')
opt_parser.add_option('-p', '--port', dest='port', help='(Default=5060) \
Port to connect to', default='5060', type='int')
opt_parser.add_option('-d', '--dir', dest='directory', help='Directory \
containing .crashlog files generated by fuzzer.py')
opt_parser.add_option('-f', '--crash_file', dest='crash_file', help='Crash file to \
replay. Alternative to the -d option, not to be used at the same time')
opt_parser.add_option('-c', '--timeout', dest='timeout', help='Send a CANCEL \
message for SIP INVITES. The value indicates the timeout to wait before sending it')
opt_parser.add_option('-r', action='store_true', dest='create_poc',\
help='Create a standalone proof of concept script for the file indicated by the \
-f paramater')
opt_parser.add_option('-o', dest='poc_file',\
help='The name of the POC file if the -r option is provided')

(options, args) = opt_parser.parse_args()

host = options.host
port = options.port
directory = options.directory
crash_file = options.crash_file
poc_file = options.poc_file

if options.timeout:
    timeout = int(options.timeout)
else:
    timeout = 0

# any validation of these paramaters can occur afterwards
# All actions will need a CrashFileReplay instance
cfr = CrashFileReplay(host, port, timeout)

if options.create_poc and not (poc_file and crash_file):
    print '[!] The -r option requires the -o and -f options to have valid file names and the -f paramater to exist'    
    sys.exit(-1)
elif options.create_poc:
    cfr.create_poc(crash_file, poc_file)
    sys.exit(0)

if host == None or port == None or (directory == None and crash_file == None):
    opt_parser.print_help()
    sys.exit(-1)

if directory != None and crash_file != None:
    print '[!] The directory and crash file options are mutually exclusive. Pick one\
    or the other'    
    sys.exit(-1)
    
if directory != None:
    cfr.parse_directory(directory)
    print '[+] Parsing files from ' + directory
    num_cf = len(cfr.crash_files)
    print '[+] Found ' + str(num_cf) + ' crash files'

    for ctr in range(num_cf):
        print str(ctr) + ' : ' + cfr.crash_files[ctr].name

    while True:
        input = raw_input('\n[+] Enter the number of the crash file you want to replay. Press q to quit\n')

        if input == 'q':
            sys.exit(0)
        else:
            input = int(input)
        
        fname = cfr.crash_files[input].name
        print '[+] Replaying ' + fname 
        cfr.replay_num(input)
        print '[+] Sent'
else:
    print '[+] Replaying ' + crash_file 
    cfr.replay_name(crash_file)
    print '[+] Sent'
