# frozen_string_literal: true

Sequel.migration do
  up do
    create_table :loot_items do
      primary_key :id
      foreign_key :workspace_id, :workspaces

      column :path, :string, size: 500, null: false
      column :notes, :string, size: 100, null: true
      column :type, :string, size: 50, null: false
      column :host, :string, size: 250, null: false
      column :port, :int, null: false
      column :created_at, :datetime
    end
  end

  down do
    drop_table :loot_items
  end
end
