# frozen_string_literal: true

module Wpxf
  module Versioning
    # Provides functionality for generating random OS versions.
    module OSVersions
      # @return [String] a random NT version string.
      def random_nt_version
        "#{rand(5..6)}.#{rand(0..1)}"
      end

      # @return [String] a random OSX version string.
      def random_osx_version
        "10_#{rand(5..7)}_#{rand(0..9)}"
      end
    end
  end
end
