# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::OutputEmitters do
  let(:subject) { Wpxf::Module.new }

  describe '#emit_success' do
    it 'emits an output event with a type of success' do
      subscriber = Object.new
      allow(subscriber).to receive(:on_event_emitted) do |e|
        expect(e[:type]).to eq :success
        expect(e[:event]).to eq :output
        expect(e[:msg]).to eq 'test'
        expect(e[:verbose]).to be false
      end
      subject.event_emitter.subscribe(subscriber)
      subject.emit_success('test')
    end
  end

  describe '#emit_info' do
    it 'emits an output event with a type of info' do
      subscriber = Object.new
      allow(subscriber).to receive(:on_event_emitted) do |e|
        expect(e[:type]).to eq :info
        expect(e[:event]).to eq :output
        expect(e[:msg]).to eq 'test'
        expect(e[:verbose]).to be false
      end
      subject.event_emitter.subscribe(subscriber)
      subject.emit_info('test')
    end
  end

  describe '#emit_warning' do
    it 'emits an output event with a type of warning' do
      subscriber = Object.new
      allow(subscriber).to receive(:on_event_emitted) do |e|
        expect(e[:type]).to eq :warning
        expect(e[:event]).to eq :output
        expect(e[:msg]).to eq 'test'
        expect(e[:verbose]).to be false
      end
      subject.event_emitter.subscribe(subscriber)
      subject.emit_warning('test')
    end
  end

  describe '#emit_error' do
    it 'emits an output event with a type of error' do
      subscriber = Object.new
      allow(subscriber).to receive(:on_event_emitted) do |e|
        expect(e[:type]).to eq :error
        expect(e[:event]).to eq :output
        expect(e[:msg]).to eq 'test'
        expect(e[:verbose]).to be false
      end
      subject.event_emitter.subscribe(subscriber)
      subject.emit_error('test')
    end
  end
end
