#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is a part of Androguard.
#
# This file is generated automatically from the data
# provided by PScout tool [http://pscout.csl.toronto.edu/]
# using script: extract_api_permission_mappings.py
#
# Author: Yury Zhauniarovich
#
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License"

#################################################
### API version: 17 
#################################################


AOSP_PERMISSIONS_BY_METHODS = {
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry$BirthdayData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/group/GroupEditorFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/model/dataitem/PhotoDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/HTML5VideoInline;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/ProfileProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PhotoView;-checkHideUndoBar-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine;-access$2700-(Landroid/net/wifi/WifiStateMachine; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebViewProvider;-destroy-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternView;-addCellToPattern-(Lcom/android/internal/widget/LockPatternView$Cell;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/IccProvider;-updateIccRecordInEf-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/DataUsageSummary;-updateTabs-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$AudioOn;-processConnectionEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserWebView;-zoomOut-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-parse-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onEndBatchInput-(Lcom/android/inputmethod/latin/InputPointers;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/SnapshotTab$LoadData;-onPostExecute-(Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/soundrecorder/Recorder;-delete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/SlideshowDataAdapter$SlideshowSource;-findItemIndex-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-vibrate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/webkit/WebView;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/videoeditor/VideoEditorActivity$23;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-handleKeyguardDone-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-resetInCallScreenMode-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-updateConnectionState-(Landroid/net/NetworkInfo$DetailedState;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/WifiService$NotificationEnabledSettingObserver;-register-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/SuggestionsAdapter$SlowFilterTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/googlecode/mp4parser/authoring/builder/Mp4Builder;-build-(Lcom/googlecode/mp4parser/authoring/Movie;)Lcom/coremedia/iso/IsoFile;' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/CropFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/sip/SipEditor;-saveAndRegisterProfile-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManagerService;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-mayEndBatchInput-(J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/launcher2/PagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/content/ContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-drawFrameLocked-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-doKeyguardLaterLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/content/ISyncAdapter;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/EventInfoFragment$QueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/base/FrameSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference$MyHandler;-handleSetVPResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/picasasource/PicasaSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-acknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/HTML5VideoViewProxy;-setBaseLayer-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-ndefWrite-(I Landroid/nfc/NdefMessage;)I' : ['android.permission.NFC'],
	'Lcom/android/internal/statusbar/IStatusBarService;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processNoiceReductionEvent-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/BackupManagerService;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/IAccountManager$Stub;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/Settings$LocalePickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CallLogAsync$AddCallTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/speech/SpeechRecognizer;-cancel-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/contacts/model/dataitem/OrganizationDataItem;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/MediaRecorder;-setVideoSource-(I)V' : ['android.permission.CAMERA'],
	'Landroid/nfc/tech/NdefFormatable;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/content/ContentService;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/browser/DownloadHandler;-onDownloadStart-(Landroid/app/Activity; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/contacts/model/dataitem/NoteDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/WebViewClassic$WebViewInputConnection;-commitText-(Ljava/lang/CharSequence; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDragging-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-handleBackKey-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/telephony/TelephonyManager;-getDeviceSoftwareVersion-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage;-access$1400-(Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq; Ljava/util/HashMap;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/server/wm/Session;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/phone/InCallScreen;-onStop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-doKeyguardTimeout-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDisconnectDone-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreen;-isBluetoothAudioConnected-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager$Stub;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$10300-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-computeAddress-(Lcom/android/gallery3d/util/ReverseGeocoder$SetLatLong;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpaceBeforeWritingToFile-(I Ljava/lang/String; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/LocationManagerService;-init-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-onDestroy-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/VoicemailStatusTable;-insert-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-doNotifyDataConnection-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/group/GroupDetailFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/DockService;-access$100-(Lcom/android/settings/bluetooth/DockService; Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$DreamSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/UiModeManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-onStop-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/IActivityManager;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/recent/RecentsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/contacts/CallContactActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhones-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/CropView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor;-access$300-(Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor$SimArgs;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/app/TrimTimeBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/VoicemailContract$Status;-buildSourceUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/bluetooth/IBluetoothHeadset;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/AndroidClockTextView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-stopLoading-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-access$200-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-drawEvent-(Landroid/graphics/Canvas; Lcom/android/calendar/Event; I I I Z Z Z)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/Phone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/PhotoDataItem;-hasKindTypeColumn-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-addNotificationViews-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)Lcom/android/systemui/statusbar/StatusBarIconView;' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/WindowManagerService;-addWindow-(Lcom/android/server/wm/Session; Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/inputmethod/latin/Suggest;-getSuggestedWordsForTypingInput-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; Z)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/DataUsageListener;-updatePolicy-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$AccountAnalyzer;-<init>-(Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView; Landroid/accounts/AccountManager; Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$1;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I Landroid/content/DialogInterface$OnClickListener; Landroid/content/DialogInterface$OnCancelListener;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateState-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/DhcpStateMachine$RunningState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/SlideshowActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$LocalePickerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment;-access$000-(Lcom/android/launcher2/WallpaperChooserDialogFragment; I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/WindowManagerService;-moveAppWindowsLocked-(Ljava/util/List; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/FrameSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-setSystemUiVisibility-(I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/exchange/EasSyncService;-canProvision-(Lcom/android/exchange/EasSyncService;)Lcom/android/exchange/adapter/ProvisionParser;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/power/PowerManagerService$1;-onProximityPositive-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-addNotification-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapUtils;-isProfileSet-(Landroid/content/Context;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewBase;-verifyUnlock-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothInputDevice;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/content/IContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/util/DraftCache;-access$000-(Lcom/android/mms/util/DraftCache;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/InCallScreen;-updateManageConferencePanelIfNecessary-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/ChartDataUsageView$DataUsageChartListener;-onWarningChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/AccountFilterActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$7300-(Lcom/android/mms/ui/ComposeMessageActivity; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/VolumePanel;-onRemoteVolumeChanged-(I I)V' : ['android.permission.VIBRATE'],
	'Landroid/media/IAudioService;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/NetworkTimeUpdateService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-setNfcBeamPushUris-([Landroid/net/Uri;)V' : ['android.permission.NFC'],
	'Lcom/android/server/VibratorService;-startVibrationLocked-(Lcom/android/server/VibratorService$Vibration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/WifiService;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/ConnectivityService;-setLockdownTracker-(Lcom/android/server/net/LockdownVpnTracker;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/LocalePicker;-updateLocale-(Ljava/util/Locale;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService$AudioHandler;-access$4800-(Landroid/media/AudioService$AudioHandler; Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/Search$SearchParser;-parseResponse-()Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/commands/bmgr/Bmgr;-doListRestoreSets-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onBindView-(Landroid/view/View;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/model/ContactLoader;-loadGroupMetaData-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/IWifiManager;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/ConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$TagService;-isNdef-(I)Z' : ['android.permission.NFC'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/UrlInputView;-onSelect-(Ljava/lang/String; I Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/VibratorService;-onInputDeviceRemoved-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-showBugreportDialog-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/gallery3d/data/DataManager;-delete-(Lcom/android/gallery3d/data/Path;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/ActivityManagerNative;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/contacts/ProfileProvider;-enforceWritePermission-()V' : ['android.permission.WRITE_PROFILE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/MobileNetworkSettings$MyHandler;-resetNetworkModeToDefault-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView$1;-onRefreshCarrierInfo-(Ljava/lang/CharSequence; Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/NicknameDataItem;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$DockEventHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-access$600-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/media/AudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3000-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccRecords;-onReady-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothPhoneService$3;-processChld-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/SearchActivity;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine;-access$17400-(Landroid/net/wifi/WifiStateMachine; Ljava/util/ArrayList;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ConnectivityService;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/policy/DateView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/GoogleAccountLogin;-invalidateTokens-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/DataUsageListener$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ConnectivityService;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-handleCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadThread;-notifyThroughDatabase-(I Z I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/net/INetworkPolicyManager$Stub;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/EasOutboxService;-acknowledgeProvisionImpl-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-clearHistory-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfo-(Lcom/android/mms/data/Contact;)Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/ui/ComposeMessageActivity$36;-run-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/music/AudioPreview;-playPauseClicked-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopUserLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/util/Log$1;-onTerribleFailure-(Ljava/lang/String; Landroid/util/Log$TerribleFailure;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/location/fused/FusedLocationProvider;-<init>-(Landroid/content/Context;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/SnapshotTab;-<init>-(Lcom/android/browser/WebViewController; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IRingtonePlayer$Stub;-stopAsync-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/PushReceiver;-access$000-(Landroid/content/Context; Lcom/google/android/mms/pdu/GenericPdu; I)J' : ['android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/StatusBarManager;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/browser/Tab$2;-onPageFinished-(Landroid/webkit/WebView; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab; Z)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/text/StringSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionUp-(Landroid/view/MotionEvent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/EditableInputConnection;-sendKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onRefreshCarrierInfo-(Ljava/lang/CharSequence; Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/NfcAdapter;-enableForegroundDispatch-(Landroid/app/Activity; Landroid/app/PendingIntent; [Landroid/content/IntentFilter; [[Ljava/lang/String;)V' : ['android.permission.NFC'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardStatusViewManager$1;-onUserSwitched-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarEventModel;-<init>-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-onBackPressed-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/commands/bmgr/Bmgr;-doWipe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-access$400-(Lcom/android/contacts/group/GroupBrowseListFragment;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/CallbackProxy;-createWindow-(Z Z)Landroid/webkit/BrowserFrame;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/gallery3d/data/SnailSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-access$900-(Lcom/android/systemui/statusbar/phone/QuickSettings; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/app/LocalePicker;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IThrottleManager$Stub;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/sip/SipEditor;-access$400-(Lcom/android/phone/sip/SipEditor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-setMessagePreferences-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/input/InputManagerService;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-access$3000-(Lcom/android/systemui/statusbar/phone/PhoneStatusBar;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/VibratorService;-access$200-(Lcom/android/server/VibratorService;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-setCurrentTab-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/emailcommon/service/ServiceProxy$ProxyRunnable;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/phone/SipCallOptionHandler;-createSipPhoneIfNeeded-(Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.USE_SIP'],
	'Lcom/android/contacts/editor/ContactEditorFragment$JoinSuggestedContactDialogFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/Phone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService$WindowManagerCallbacks;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipService$IntervalMeasurementProcess;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/CameraModule;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/model/dataitem/PhotoDataItem;-getKindTypeColumn-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/CallbackProxy;-onJsPrompt-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/handover/HandoverTransfer;-updateFileProgress-(F)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/DayView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/data/MtpDevice;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/webkit/AccessibilityInjectorFallback;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-scrollLayerTo-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;-stop-()V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/HTML5VideoFullScreen;-access$500-(Landroid/webkit/HTML5VideoFullScreen;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPage-(I I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosrc/MediaSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/WifiService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_MULTICAST_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-<init>-(Landroid/app/Activity; Landroid/os/Bundle; Landroid/app/FragmentManager; Lcom/android/contacts/widget/TransitionAnimationView; Landroid/view/View; Lcom/android/contacts/detail/ContactDetailFragment$Listener;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/server/sip/SipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/preference/VolumePreference;-cleanup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/wifi/WifiSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/CropImage;-getMediaItemFromIntentData-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/tech/MifareUltralight;-setTimeout-(I)V' : ['android.permission.NFC'],
	'Lcom/android/settings/accounts/SyncSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/AccountsChangedReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/hdp/HealthService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebViewCore;-contentScrollTo-(I I Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/VideoModule;-initializeRecorder-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/SyncManager;-sendSyncFinishedOrCanceledMessage-(Landroid/content/SyncManager$ActiveSyncContext; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-access$400-(Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/INetworkPolicyManager;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-access$200-(Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hid/HidService;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToDestination-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager$MulticastLock;-release-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/webkit/WebViewClassic;-reload-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/OrganizationDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-getContactCount-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/emailcommon/Device;-getDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/DeviceAccountLogin;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$FullImageJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/camera/SecureCameraActivity;-access$100-(Lcom/android/camera/CameraActivity; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-getContactMethodType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/commands/svc/PowerCommand;-run-([Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BluetoothManagerService;-disable-(Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$000-(Lcom/android/mms/transaction/SmsReceiverService; Landroid/content/Intent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/webkit/ZoomControlExternal$3;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$ContactLoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-shutdown-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService$Stub;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/LocationManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-determineScrollingStart-(Landroid/view/MotionEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService$AppDeathRecipient;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/ConnectivityService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-getInstance-(Landroid/content/Context;)Lcom/android/settings/bluetooth/LocalBluetoothManager;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/SmsReceiverService;-insertMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;-onResume-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/media/effect/FilterGraphEffect;-apply-(I I I I)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsStatusListener-(Landroid/location/IGpsStatusListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcTag$Stub;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/emailcommon/service/IEmailService;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-killApplicationWithAppId-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-reset-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ViewInterface;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/Utils;-showError-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/Phone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$200-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-wakeWhenReadyTq-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/GLTextureSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/VoicemailPermissions;-packageHasFullAccess-(Ljava/lang/String;)Z' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/calendar/EventLoader$LoadEventsRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/editor/PhotoEditorView$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/downloads/DownloadThread;-updateDatabaseFromHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/MediaPlaybackService$5;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-restoreNextAgent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/IWifiManager;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/CallDetailActivityQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/ui/AudioAttachmentView;-onPlaybackError-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/EmailDataItem;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$PersistTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/ConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView;-onResume-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneGlobals;-handleSetTTYModeResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiService;-enforceMulticastChangePermission-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-getRecentTasks-(I I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/gallery3d/ui/PhotoView;-pause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-invokeCodeInput-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2ForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewProvider;-zoomOut-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/EventInfoFragment;-showContactInfo-(Lcom/android/calendar/CalendarEventModel$Attendee; Landroid/graphics/Rect;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/PhotoView$1;-onClick-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/PowerManagerService;-access$800-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/inputmethod/InputMethodManager;-finishedEvent-(I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-getOriginalSyncId-(J)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/usb/UsbService;-systemReady-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-handleHeadsetHook-(Lcom/android/internal/telephony/Phone; Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine$CaptivePortalCheckState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DreamSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/LocalSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/XLargeUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-startScanning-(Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/ContactListFilterController;-setContactListFilter-(Lcom/android/contacts/list/ContactListFilter; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentialsAsUser-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler; Landroid/os/UserHandle;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/Tab;-createSubWindow-()Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertSettings-(Landroid/net/Uri; Landroid/content/ContentValues;)J' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton$1;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/ExchangeService$AccountObserver;-access$700-(Lcom/android/exchange/ExchangeService$AccountObserver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/PieRenderer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/display/DisplayManagerService$DisplayAdapterListener;-onDisplayDeviceEvent-(Lcom/android/server/display/DisplayDevice; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/CaptivePortalTracker;-access$800-(Landroid/net/CaptivePortalTracker; Landroid/net/NetworkInfo;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/vpndialogs/ManageDialog;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/SmoothPagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$ClassChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-executeNextState-(Lcom/android/server/BackupManagerService$BackupState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetoothManager;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-doFinish-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/power/PowerManagerService$WakeLock;-binderDied-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/preferences/WebsiteSettingsFragment$SiteAdapter$UpdateFromBookmarksDbTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-queueQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/net/wifi/WifiStateMachine;-stopTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/TechListChooserActivity;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/ui/ActionModeHandler$2;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/nfc/INfcAdapterExtras;-getCardEmulationRoute-(Ljava/lang/String;)I' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/TintFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ActivityState;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/phone/CdmaSubscriptionListPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageItem;-access$200-(Lcom/android/mms/ui/MessageItem; Lcom/google/android/mms/pdu/EncodedStringValue; Landroid/net/Uri;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/data/Conversation;-dumpSmsTable-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccProvider;-loadFromEf-(I)Landroid/database/MatrixCursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TetherSettings$TetherChangeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClassic;-sendBatchableInputMessage-(I I I Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/ImDataItem;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/LocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/accounts/AccountManager;-addOnAccountsUpdatedListener-(Landroid/accounts/OnAccountsUpdateListener; Landroid/os/Handler; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/accounts/AccountManager$2;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-adjustUserActivityLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/sip/SipAudioCall;-isWifiOn-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/data/ClusterSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/effect/effects/TintEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage$7;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/systemui/SwipeHelper$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-execute-(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onClockVisibilityChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-deleteSmsOnSim-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/Suggest;-getSuggestedWords-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; Z I)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2800-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-initialize-(Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/CropView$HighlightRectangle;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/exchange/EasSyncService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/btservice/ProfileService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/ApplicationSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-onScreenTurnedOff-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterfw/core/Filter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onImportParsed-(Lcom/android/contacts/vcard/ImportRequest; I Lcom/android/vcard/VCardEntry; I I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/browser/UI;-onBackKey-()Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/phone/InCallScreen$12;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onSeListenActivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$5000-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Landroid/net/wifi/p2p/WifiP2pConfig; Z)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-hideSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/sip/SipAudioCall;-transferToNewSession-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothA2dp;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/NullFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/nfc/P2pEventManager;-onP2pReceiveComplete-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/coremedia/iso/IsoFile;-<init>-(Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-checkFilterValidity-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/IThrottleManager$Stub;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/UriSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/dhimpl/NativeNfcManager;-notifyTargetDeselected-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/phone/InCallScreen;-access$800-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/vcard/VCardEntry$PhotoData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/webkit/WebViewInputDispatcher;-skipWebKitEventLocked-(Landroid/webkit/WebViewInputDispatcher$DispatchEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IccRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/PrivacySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/ConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/webkit/WebView;-loadUrl-(Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/ILocationManager$Stub;-addTestProvider-(Ljava/lang/String; Lcom/android/internal/location/ProviderProperties;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/browser/SnapshotTab;-destroy-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/EventInfoFragment;-updateAttendees-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-updateWidget-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Contacts$Settings;-getSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/WifiManager;-reconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/webkit/WebViewClassic;-goBack-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/WirelessSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-getIsGroupMmsEnabled-(Landroid/content/Context;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-getContactUriForPhoneNumber-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-snapToPage-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-onDestroy-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl;-getUsableInvitableAccountTypes-()Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/voicedialer/RecognizerClient;-onMicrophoneStart-(Ljava/io/InputStream;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/pm/PackageManagerService;-access$3700-(Lcom/android/server/pm/PackageManagerService; Ljava/lang/String; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/WiredAccessoryManager;-notifyWiredAccessoryChanged-(J I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-sendUSSD-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IBackupAgent$Stub;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/CursorEntityIterator;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processAnswerCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler$PhotoListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/sip/SipService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$PlaybackPositionListener;-onStartTrackingTouch-(Landroid/widget/SeekBar;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapterExtras$Stub;-getDriverName-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/RIL;-getIMSI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue;-releaseAllPointersOlderThan-(Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue$Element; J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-startDelayedRetry-(Lcom/android/internal/telephony/DataConnection$FailCause; Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-fetchRuimRecords-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onClicked-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setNumberOfPairedDevices-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/NfcService$TagService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-handleCallKey-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-open-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/AccessibilityInjector;-removeCallbackApis-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/videosrc/MediaSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Contact;-getPhoneUri-()Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/Gallery;-startDefaultPage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/accounts/AccountManagerService;-confirmCredentialsAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/accounts/SyncSettings;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/systemui/power/PowerUI;-playLowBatterySound-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-updateDeviceName-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/PasswordUnlockScreen;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/webkit/AccessibilityInjector;-handleKeyEventIfNecessary-(Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5Audio;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-computeScreenConfigurationLocked-(Landroid/content/res/Configuration;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/Context;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-access$2300-(Lcom/android/gallery3d/app/PhotoDataAdapter;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/pm/PackageManagerService$11;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplayDensity-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService;-buildInputMethodListLocked-(Ljava/util/ArrayList; Ljava/util/HashMap;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoViewProxy;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-bluetoothStateChangeHandler-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-haveSomethingToCopyToSDCard-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-restartRadio-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/webkit/PluginFullScreenHolder$CustomFrameLayout;-onTrackballEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiStateMachine$ConnectModeState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackActivity;-startPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogFragment;-updateOnEntry-()V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText;-onAttachedToWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/SyncManager;-onUserRemoved-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-doRecovery-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry;-iterateAllData-(Lcom/android/vcard/VCardEntry$EntryElementIterator;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/DataUsageSummary$ConfirmLimitFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/google/android/mms/util/AbstractCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onCommitDeleteImage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/ui/InLineSettingMenu;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-handleHide-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-handleSmsReceived-(Landroid/content/Intent; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/recent/RecentsPanelView;-handleSwipe-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/settings/TetherSettings;-onStart-()V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask;-restoreOneFile-(Ljava/io/InputStream; [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/SimPukUnlockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$AccountAnalyzer;-<init>-(Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView; Landroid/accounts/AccountManager;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionRequest;-checkUserChoice-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/TimerRingService;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothInputDevice;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowManager$Stub$Proxy;-clearForcedDisplaySize-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setBluetoothStateInt-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-onActualStateChange-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/webkit/WebViewCore$EventHub;-sendMessageDelayed-(Landroid/os/Message; J)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-getPackageGids-(Ljava/lang/String;)[I' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PickerActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame$1;-onClockVisibilityChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/commands/monkey/Monkey;-run-([Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/webkit/WebViewCore$3;-onReceiveValue-(Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneGlobals;-dismissCallScreen-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/telephony/SmsProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-onCameraLaunched-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-acquireWakeLock-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/inputmethod/InputMethodAndLanguageSettings$SettingsObserver;-resume-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/ChallengeLayout;-showChallenge-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/P2pEventListener;-onP2pSendComplete-()V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebViewClassic;-onTrackballEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/AllInOneActivity$2;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/EasSyncService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-loadData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/Ringer;-stopRing-()V' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$AudioOn;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager$WifiLock;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/media/NotificationPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoFullScreen;-pauseAndDispatch-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionDown-(Landroid/view/MotionEvent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/wifi/WifiSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothPan;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PreloadedTabControl;-loadUrl-(Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmReceiver;-access$000-(Lcom/android/deskclock/AlarmReceiver; Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnection;-access$2000-(Lcom/android/internal/telephony/DataConnection; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-wakeUpFromNative-(J)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pan/PanService;-enableTethering-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/NsdService$NsdStateMachine;-<init>-(Lcom/android/server/NsdService; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/LocalePicker;-onLocaleSelected-(Ljava/util/Locale;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-getAwakeTimePlugged-()J' : ['android.permission.BATTERY_STATS'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageUtils;-handleReadReport-(Landroid/content/Context; Ljava/util/Collection; I Ljava/lang/Runnable;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-onCreate-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-agentErrorCleanup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/commands/am/Am;-runKillAll-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Landroid/net/ConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PieController$1;-onClick-(Lcom/android/camera/ui/PieItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onDeviceAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onOptionalFieldVisibilityChange-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/PhoneUtils;-switchHoldingAndActive-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewStateManager;-onPageBeginMoving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ContactListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/camera/ui/TimeIntervalPopup;-updateInputState-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/location/fused/FusionEngine;-disableProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/PowerManagerService$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView$3;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment$3;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactsSize-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetooth$Stub;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/PhoneCallDetailsHelper;-setCallDetailsHeader-(Landroid/widget/TextView; Lcom/android/contacts/PhoneCallDetails;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/RIL;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkQuotaInfo-()Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/ex/variablespeed/SingleThreadedMediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/net/DataUsageMeteredSettings;-updateNetworks-(Landroid/content/Context;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/preferences/FontSizePreview;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/UiModeManagerService;-access$100-(Lcom/android/server/UiModeManagerService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-handleAccessPermissionResult-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/os/IVibratorService;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Landroid/speech/SpeechRecognizer;-access$100-(Landroid/speech/SpeechRecognizer;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/systemui/statusbar/phone/NavigationBarView;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/view/IWindowManager;-isKeyguardSecure-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/UrlInputView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-makeStatusBarView-()Landroid/view/View;' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onReplay-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangup-(Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/ScrollBarView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/Gallery;-startGetContent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/DataUsageSummary$UidDetailTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/CryptKeeper$ValidationTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/MessagingNotification$3;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Integer;' : ['android.permission.READ_SMS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.DISABLE_KEYGUARD', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/nfc/tech/MifareClassic;-decrement-(I I)V' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetooth;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-dialRecipient-()V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-onSystemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/ui/SlideViewInterface;-setAudio-(Landroid/net/Uri; Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onProviderStatusChange-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/AccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-sendMessage-(J)Z' : ['android.permission.SEND_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onResume-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/exchange/EasOutboxService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-ensurePaired-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-onDestroyActionMode-(Landroid/view/ActionMode;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/Controller$5;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/model/dataitem/DataItem;-getKindTypeColumn-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebViewClassic;-access$7000-(Landroid/webkit/WebViewClassic;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-access$200-(Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;)V' : ['android.permission.CAMERA'],
	'Lcom/android/bluetooth/btservice/AdapterService;-processConnectOtherProfiles-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHeadset;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$SyncHandler;-closeActiveSyncContext-(Landroid/content/SyncManager$ActiveSyncContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/NoteDataItem;-hasKindTypeColumn-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/calendar/event/EditEventView$TimeListener;-onTimeSet-(Landroid/widget/TimePicker; I I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/Controller;-openTabToHomePage-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/widget/BookmarkThumbnailWidgetService$BookmarkFactory;-loadBookmarks-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendShowPinReqToFrontApp-(Ljava/lang/String;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/view/IWindowManager$Stub;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-enableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAbsKeyInputView;-resetState-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/tech/NfcB;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/TelephonyRegistry;-broadcastSignalStrengthChanged-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-access$2100-(Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/model/dataitem/PhoneDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/DockService;-getCachedBluetoothDevice-(Landroid/bluetooth/BluetoothDevice;)Lcom/android/settings/bluetooth/CachedBluetoothDevice;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity$30;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasAccountService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/EasOutboxService;-sendPing-([B I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsUtils;-areContactWritableAccountsAvailable-(Landroid/content/Context;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/SlideshowView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/bluetooth/IBluetooth;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/Recycler;-checkForThreadsOverLimit-(Landroid/content/Context;)Z' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/CallManager;-acceptCall-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$5800-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Landroid/net/wifi/p2p/WifiP2pDevice; Landroid/net/wifi/p2p/WifiP2pConfig;)Z' : ['android.permission.GET_TASKS'],
	'Landroid/view/ViewRootImpl;-dispatchKey-(Landroid/view/KeyEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothHealth;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-bailOutAfterErrorDialog-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/provider/Browser;-truncateHistory-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/ConnectivityService;-access$1100-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DataUsageSummary;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/DockObserver;-access$000-(Lcom/android/server/DockObserver;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-stopBluetoothSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/MediaSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/BondStateMachine;-access$400-(Lcom/android/bluetooth/btservice/BondStateMachine; Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/MenuExecutor$MediaOperation;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Landroid/bluetooth/BluetoothHealth;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/UiccCard;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/IccCardStatus;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WallpaperManagerService;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/server/pm/PackageManagerService$7;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/NsdService$NsdStateMachine$DisabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/IWallpaperManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$Handler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame$7;-onUserSwitched-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/inputmethodservice/KeyboardView;-onLongPress-(Landroid/inputmethodservice/Keyboard$Key;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/view/IWindowSession;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/browser/Tab$SubWindowChromeClient;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordContents;-getLocalesList-(Landroid/app/Activity;)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/calendar/agenda/AgendaListView;-initView-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/agenda/AgendaListView$3;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-startSync-(J Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-transceive-(I [B Z)Landroid/nfc/TransceiveResult;' : ['android.permission.NFC'],
	'Landroid/telephony/TelephonyManager;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-finish-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$ErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingColors-(Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/ISyncAdapter$Stub;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/nfc/INfcTag;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Landroid/bluetooth/BluetoothAdapter;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-lookupAddress-(D D Z)Landroid/location/Address;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/media/IRingtonePlayer$Stub;-stop-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/DeleteEventHelper$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/vcard/ImportVCardActivity$VCardScanThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/PhoneFavoriteFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/HTML5VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UI;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfoUnfiltered-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth;-sendConnectionStateChange-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$SetIpForwardingDisabledErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/tablet/NotificationPanel;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebViewCore;-resumeWebKitDraw-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasAccountService;-parsePingResult-(Ljava/io/InputStream; Landroid/content/ContentResolver; Ljava/util/HashMap;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$5800-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/view/ViewRootImpl;-enqueueInputEvent-(Landroid/view/InputEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onApnChanged-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Controller;-onDownloadStart-(Lcom/android/browser/Tab; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/AccessibilityInjector;-injectJavaScript-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment;-setDeviceName-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/launcher2/Workspace$2;-run-()V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/accounts/AccountManager$3;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;-access$300-(Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;)V' : ['android.permission.VIBRATE'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Ljava/lang/String; Ljava/lang/String; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-changeVolumeBy-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarUtils$TimeZoneUtils;-getTimeZone-(Landroid/content/Context; Ljava/lang/Runnable;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView; Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/base/ObjectSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/providers/contacts/DbModifierWithNotification;-insert-(Landroid/content/ContentValues;)J' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IIntentReceiver$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/PhoneGlobals;-updatePhoneState-(Lcom/android/internal/telephony/PhoneConstants$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage;-initializeData-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1700-(Lcom/android/bluetooth/opp/BluetoothOppService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/DayView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/media/AsyncPlayer$Thread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/base/InputStreamSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStack;-activityPaused-(Landroid/os/IBinder; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/InputMethodManagerService$3;-onUserSwitching-(I Landroid/os/IRemoteCallback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processUnknownAt-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-handleGroupCreationFailure-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/inputmethod/InputMethodManager;-timeoutEvent-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$ScanningStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallbackProxy$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-finishState-(Lcom/android/gallery3d/app/ActivityState; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-startProcessLocked-(Ljava/lang/String; Landroid/content/pm/ApplicationInfo; Z I Ljava/lang/String; Landroid/content/ComponentName; Z Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/webkit/WebViewClassic;-commitTextBatch-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeProvision-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothInputDevice;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/text/ToUpperCase;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onBackPressed-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/power/PowerManagerService;-acquireWakeLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary;-onResume-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewInputDispatcher;-dispatchWebKitEvents-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/CaptivePortalTracker;-isActiveNetwork-(Landroid/net/NetworkInfo;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/model/dataitem/EventDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/provider/ContactsContract$RawContacts$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/net/NetworkStatsService;-bootstrapStatsLocked-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commit-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-updateIncomingCallWidgetHint-(I I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IThrottleManager$Stub;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onQueryTextChange-(Ljava/lang/String;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/data/MediaSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/LocalBluetoothAdapter; Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager; Lcom/android/settings/bluetooth/BluetoothEventManager;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebIconDatabaseClassic;-retainIconForPageUrl-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri;)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ActivityState;-onStateResult-(I I Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/phone/sip/SipEditor;-unregisterProfile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserWebView;-findAll-(Ljava/lang/String;)I' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/CheckedTextView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-attachApplicationLocked-(Landroid/app/IApplicationThread; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPin-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ChooseLockPassword$ChooseLockPasswordFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onRemoveViewAnimationCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/ActivityManagerNative;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String; I)Landroid/content/Intent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/nfc/INfcTag;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/browser/BrowserWebViewFactory;-createWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Landroid/view/IWindowSession$Stub$Proxy;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManagerService;-getAccountsByFeatures-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage;-asyncDeleteDraftSmsMessage-(Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/backup/IBackupManager;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-getSubscriptionInfoAndStartPollingThreads-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/IConnectivityManager;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/DataManager;-getMediaSetsFromString-(Ljava/lang/String;)[Lcom/android/gallery3d/data/MediaSet;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/ComboAlbum;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$PanStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/net/NetworkStatsService;-access$1000-(Lcom/android/server/net/NetworkStatsService; [I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService$19;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$LinkMonitoringState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-access$900-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore;-access$2400-(Landroid/webkit/WebViewCore; Landroid/webkit/WebViewClassic$ViewSizeData;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/SharpenEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-sendConnectionStateChange-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/ComposeMessageActivity$BackgroundQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-selectDefaultContact-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/RedEyeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/ContactEntryListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-delete-(Landroid/net/Uri; I J)I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/widget/DialogTitle;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/support/v4/net/ConnectivityManagerCompat$ConnectivityManagerCompatImpl;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewProvider;-pauseTimers-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/CalendarController$EventHandler;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/view/inputmethod/InputMethodManager$1;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-onCreate-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getDataUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-toggleRecentsActivity-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/contacts/group/GroupEditorFragment;-access$600-(Lcom/android/contacts/group/GroupEditorFragment; Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiManager;-setCountryCode-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/tech/NfcA;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$KeyboardLayoutPickerActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactPickerFragment;-finish-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/camera/ui/MoreSettingPopup;-onSettingChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DevelopmentSettings;-access$100-(Lcom/android/settings/DevelopmentSettings;)V' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/server/ConnectivityService;-access$2200-(Lcom/android/server/ConnectivityService; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/ILocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/model/ContactLoader;-loadDirectoryMetaData-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-addStatusBarWindow-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothDevice;-setPin-([B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/PbapServerProfile;-getConnectionStatus-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/power/PowerManagerService$1;-onProximityNegative-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/content/SyncManager;-sendCheckAlarmsMessage-()V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/power/DisplayBlanker;-unblankAllDisplays-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/PatternUnlockScreen;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-onFieldChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-pullVcardEntry-([B Lcom/android/bluetooth/pbap/BluetoothPbapObexServer$AppParamValue; Ljavax/obex/Operation; Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/app/TrimVideo;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView;-show-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentSlide-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/SlideModel;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IccCardProxy;-broadcastIccStateChangedIntent-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Controller;-closeCurrentTab-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/os/PowerManager$WakeLock;-release-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-setController-(Lcom/android/browser/WebViewController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IAudioService$Stub;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/contacts/calllog/ClearCallLogDialog$1$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/VideoView$6;-surfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub$Proxy;-setForcedDisplaySize-(I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/RetargetFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneGlobals;-initForNewRadioTechnology-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-onReady-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService$SettingsObserver;-onChange-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/debug/ContactsDumpActivity$DumpDbTask;-doInBackground-([Ljava/lang/Void;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ActivityBase$MyAppBridge;-access$200-(Lcom/android/camera/ActivityBase$MyAppBridge; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/InCallScreen;-delayedCleanupAfterDisconnect-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView$2;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/EditEventFragment;-access$600-(Lcom/android/calendar/event/EditEventFragment; I)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/sip/SipAudioCall;-access$700-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/AlertService;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Lcom/android/calendar/alerts/AlarmManagerInterface;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/http/RequestQueue;-enablePlatformNotifications-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/INetworkStatsService$Stub$Proxy;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/EmergencyDialer;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/WifiService;-startScan-(Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-access$600-(Lcom/android/gallery3d/ui/MenuExecutor; Lcom/android/gallery3d/data/DataManager; Lcom/android/gallery3d/util/ThreadPool$JobContext; I Lcom/android/gallery3d/data/Path;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-userSwitched-(I)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccount-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceAdded-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/GroupMembershipDataItem;-buildDataStringForDisplay-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothPhoneService;-access$300-(Lcom/android/phone/BluetoothPhoneService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/net/NetworkPolicyManagerService$8;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/ZoomManager$PostScale;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/SlideViewInterface;-stopVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserWebView;-saveWebArchive-(Ljava/lang/String; Z Landroid/webkit/ValueCallback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/speech/IRecognitionService$Stub$Proxy;-stopListening-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/gallery3d/app/PhotoPage;-requestDeferredUpdate-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/EmptyAlbumImage;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onLowMemory-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/AtPhonebook;-processCpbrCommand-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/onetimeinitializer/GalleryWidgetMigrator;-migrateGalleryWidgets-(Landroid/content/Context;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/AccountManager;-updateCredentials-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setRepeatMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserSettings;-resetDefaultPreferences-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/EventDataItem;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/WiredAccessoryManager;-setDeviceStateLocked-(I I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-loadUrlFromContext-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-startDelayedRetry-(Lcom/android/internal/telephony/DataConnection$FailCause; Lcom/android/internal/telephony/ApnContext; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$NfcAdapterExtrasService;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Landroid/filterpacks/base/GLTextureTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/NfcAdapter;-disableForegroundNdefPush-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/browser/AddBookmarkPage;-completeOrCancelFolderNaming-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/IccCardProxy;-supplyPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/Transaction;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppCrashLocked-(Lcom/android/server/am/ProcessRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/base/InputStreamSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/AccessibilityInjector;-onPageFinished-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onUserSwitched-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothInputDevice;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/PeopleActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/SettingsLicenseActivity$3;-onUnhandledKeyEvent-(Landroid/webkit/WebView; Landroid/view/KeyEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/PowerManagerService$DisplayBlankerImpl;-blankAllDisplays-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-userSwitched-(I)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyNoData-(Lcom/android/internal/telephony/DataConnection$FailCause;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/voicedialer/VoiceContact;-getVoiceContacts-(Landroid/app/Activity;)Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/gallery3d/ui/PhotoView;-snapToNeighborImage-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/StorageManager;-findSpace-(Ljava/io/File; J I)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue;-releaseAllPointers-(J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterfw/core/Filter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/soundrecorder/SoundRecorder;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$SequentialSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebViewProvider$ViewDelegate;-performLongClick-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/location/GeofenceManager;-scheduleUpdateFencesLocked-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-shutdown-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/webkit/WebViewClassic;-pauseTimers-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-openTab-(Ljava/lang/String; Lcom/android/browser/Tab; Z Z)Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/WebViewClassic;-pasteFromClipboard-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/users/ProfileUpdateReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-startRequestProcessing-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/Connectivity;-onStartDelayedCycle-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/SimUnlockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/data/DataManager;-getContentUri-(Lcom/android/gallery3d/data/Path;)Landroid/net/Uri;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub$Proxy;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-requestRemoveProviderInfoWithDelay-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndActive-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/systemui/statusbar/policy/NetworkController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClassic;-access$3200-(Landroid/webkit/WebViewClassic; I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptFallback-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String; Landroid/content/BroadcastReceiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-requestChildRectangleOnScreen-(Landroid/view/View; Landroid/graphics/Rect; Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-getRemoteName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/model/dataitem/RelationDataItem;-buildDataString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/IContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processKeyPressed-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-cancelTransitionsInProgress-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumPage;-onUpPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/webkit/WebIconDatabaseClassic$EventHandler;-access$500-(Landroid/webkit/WebIconDatabaseClassic$EventHandler; Landroid/os/Message;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipAudioCall$1;-onCallBusy-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-putInForeground-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Lcom/android/calendar/AllInOneActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/provider/CalendarContract$EventsEntity$EntityIteratorImpl;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/EasSyncService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaPerformActivation-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/downloads/DownloadService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pPersistentGroupsChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/DayView$CalendarGestureListener;-onScroll-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/AdnRecordLoader;-loadAllFromEF-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView$FullPicture;-draw-(Lcom/android/gallery3d/ui/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/vcard/VCardParserImpl_V30;-parseOneVCard-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-rescheduleMissedAlarms-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItem-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-albumShouldOpenInFilmstrip-(Lcom/android/gallery3d/data/MediaSet;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/vcard/ImportVCardActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/browser/Tab$3;-onRequestFocus-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/accounts/IAccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/accounts/AccountManager$5;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-<init>-(Landroid/os/Handler; Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/SecuritySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri; I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallerInfoCache;-refreshCacheEntry-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/WebViewCore;-sendMessageAtFrontOfQueue-(I Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-virtualUnplug-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/TrimVideo$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/ContactsContract$SyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-sendMessage-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/handover/HandoverTransfer;-finishTransfer-(Z Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AllowBindAppWidgetActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/view/IInputMethodClient$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onActionBarWanted-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/util/ThumbnailManager;-getThumbnail-(Landroid/net/Uri; Lcom/android/mms/util/ItemLoadedCallback;)Lcom/android/mms/util/ItemLoadedFuture;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/content/IContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/group/GroupEditorFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebViewProvider;-reload-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onUserSwitched-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/RadioInfo$12;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/base/ObjectSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-isSyncable-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/EditableInputConnection;-setComposingRegion-(I I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/sip/SipSettings$1;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/InCallControlState;-update-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hdp/HealthService;-getHealthDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/power/PowerManagerService;-handleBatteryStateChangedLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/UiccCardApplication;-<init>-(Lcom/android/internal/telephony/UiccCard; Lcom/android/internal/telephony/IccCardApplicationStatus; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-dontAddVoiceMailNumber-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NameLookupQuery;-query-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/editor/ContactEditorUtils;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Ljava/lang/String; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/ChangeIccPinScreen$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardScreenCallback;-pokeWakelock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/ActivityManagerNative;-getTasks-(I I Landroid/app/IThumbnailReceiver;)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/filterpacks/base/RetargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService$1;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DreamSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.PROCESS_OUTGOING_CALLS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/TwilightService;-systemReady-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-updateParams-(Ljava/util/HashMap;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/wm/WindowManagerService;-clearForcedDisplayDensity-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$TagService;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/browser/Controller$SelectText;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/research/ResearchLogger;-scrubWord-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/WebViewCore;-sendMessage-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onAttachFragment-(Landroid/app/Fragment;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentRegionMedia-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/RegionMediaModel; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothPhoneService$3;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/WifiService;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/app/backup/IBackupManager$Stub;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/PowerManager$WakeLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$800-(Lcom/android/contacts/activities/ConfirmAddDetailActivity; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/nfc/INfcAdapterExtras;-getDriverName-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.NFC'],
	'Lcom/android/emailcommon/Device;-getConsistentDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processPostDialChar-(C)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/CropView$FaceHighlightView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/location/GpsLocationProvider;-disable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowManager;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/media/effect/EffectContext;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAccounts-()[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebViewProvider;-removeJavascriptInterface-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/content/IContentService$Stub;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/content/ISyncAdapter$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-readPairedDevices-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/AlarmClock$AlarmItemAdapter;-expandAlarm-(Lcom/android/deskclock/AlarmClock$AlarmItemAdapter$ItemHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Preloader;-cancelSearchBoxPreload-(Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/webkit/WebView;-destroy-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-updatePersistentNetworks-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/DuotoneEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Contacts$People;-markAsContacted-(Landroid/content/ContentResolver; J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/list/JoinContactListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/commands/am/Am;-runDisplayDensity-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/sip/SipSettings;-access$800-(Lcom/android/phone/sip/SipSettings;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/browser/Controller;-closeCurrentTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/SyncManager$SyncHandler;-runSyncFinishedOrCanceledLocked-(Landroid/content/SyncResult; Landroid/content/SyncManager$ActiveSyncContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/PostalAddressPickerFragment;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.READ_EXTERNAL_STORAGE', 'android.permission.GET_PACKAGE_SIZE'],
	'Landroid/nfc/tech/MifareUltralight;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment;-access$000-(Lcom/android/contacts/detail/ContactDetailUpdatesFragment; Lcom/android/contacts/util/StreamItemEntry;)Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BluetoothManagerService;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/UrlInputView$UrlInputListener;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/view/IApplicationToken;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/BrowserActivity;-onPause-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView;-<init>-(Landroid/content/Context; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewCallback; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardWindowController;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView$1;-onCodeInput-(I I I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/sip/SipService$MyExecutor;-executeInternal-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-commandsParser-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/IConnectivityManager;-getActiveNetworkQuotaInfo-()Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipCall;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/ims/IsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifyServiceState-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/Ringtone;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-setDataSourceImpl-(Landroid/media/MediaPlayer; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/RestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J J)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/os/IVibratorService;-vibrate-(J Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/IAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDevice;-cancelBondProcess-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-resetMessage-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/HidProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothPreferences;-shouldShowDialogInForeground-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/FindActionModeCallback;-findAll-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-startExtraInfoQuery-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/calendar/alerts/AlertAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcTag$Stub;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/data/Clustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/policy/AutoRotateController;-<init>-(Landroid/content/Context; Landroid/widget/CompoundButton; Lcom/android/systemui/statusbar/policy/AutoRotateController$RotationLockCallbacks;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewProvider;-findAllAsync-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5300-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; Ljava/lang/String;)V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/wm/WindowManagerService;-displayReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-refreshAccessPoints-(Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/PreloadRequestReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-showNextSecurityScreenOrFinish-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendPhonebookOneVcard-(Ljavax/obex/Operation; I Z Ljava/lang/String; I)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-onDreamingStarted-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/IBatteryStats;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-onFinishInflate-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService$AudioHandler$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onBluetoothStateChanged-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ims/IsimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/dreams/phototable/LocalSource;-next-(Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestCursor;-runQuery-(Ljava/lang/CharSequence;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader;-startBackgroundThread-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/DayView;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/wm/WindowAnimator;-updateAnimToLayoutLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onPhoneStateChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/GlobalSearchSupport;-handleSearchSuggestionsQuery-(Landroid/database/sqlite/SQLiteDatabase; Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/browser/UiController;-createNewSnapshotTab-(J Z)Lcom/android/browser/SnapshotTab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$AccountSet;-buildDiff-()Ljava/util/ArrayList;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/location/GpsLocationProvider$3;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothHeadset;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CallCard;-updatePhotoForCallState-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/Utils;-getProfileDisplayName-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/ui/MessageListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/BluetoothAdapter;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/UiModeManagerService;-access$500-(Lcom/android/server/UiModeManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-scrollRight-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentials-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/downloads/DownloadService;-scanFile-(Lcom/android/providers/downloads/DownloadInfo; Z Z)Z' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/ThrottleService$MyHandler;-clearThrottleAndNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/phone/SettingsPanelView;-updateResources-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-access$400-(Lcom/android/gallery3d/data/LocalAlbumSet; Lcom/android/gallery3d/data/DataManager; I Lcom/android/gallery3d/data/Path; I Ljava/lang/String;)Lcom/android/gallery3d/data/MediaSet;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/GpsLocationProvider;-updateNetworkState-(I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/ContactsContract$SyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-disableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-loadMessagesAndDraft-(I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$3000-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setFacilityLock-(Ljava/lang/String; Z Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserSettings;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/pm/PackageManagerService$5;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.REORDER_TASKS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.WAKE_LOCK', 'android.permission.GET_TASKS', 'android.permission.WRITE_SETTINGS', 'android.permission.RESTART_PACKAGES'],
	'Landroid/media/effect/effects/DuotoneEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/AtPhonebook;-handleCpbsCommand-(Ljava/lang/String; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/browser/BrowserWebView;-saveWebArchive-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onSimStateChanged-(Lcom/android/internal/telephony/IccCardConstants$State;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-startDisambiguationQuery-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/app/IActivityManager;-killApplicationWithAppId-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyNoData-(Lcom/android/internal/telephony/DataConnection$FailCause; Lcom/android/internal/telephony/ApnContext;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DevelopmentSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/HTML5VideoView;-prepareDataAndDisplayMode-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebViewInputDispatcher;-dispatchUiEvent-(Landroid/view/MotionEvent; I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/TintFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String; Landroid/content/BroadcastReceiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/CalendarContract$EventDays;-query-(Landroid/content/ContentResolver; I I [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$DeviceFoundHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-doVibratorOn-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/systemui/recent/RecentTasksLoader$3;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnection;-access$2000-(Lcom/android/internal/telephony/DataConnection; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/RecognizerEngine;-recognize-(Lcom/android/voicedialer/RecognizerClient; Landroid/app/Activity; Ljava/io/File; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/DataController;-getInstance-(Landroid/content/Context;)Lcom/android/browser/DataController;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/CallerInfoCache;-init-(Landroid/content/Context;)Lcom/android/phone/CallerInfoCache;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DeleteEventHelper;-access$900-(Lcom/android/calendar/DeleteEventHelper;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$23$1$3;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/model/dataitem/WebsiteDataItem;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-activateSpeakerIfDocked-(Lcom/android/internal/telephony/Phone;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-getReport-(Landroid/bluetooth/BluetoothDevice; B B I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEnded-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-rescheduleMissedAlarms-(Landroid/content/ContentResolver;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity$BluetoothTransferContentObserver;-onChange-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-setPostDialState-(Lcom/android/internal/telephony/Connection$PostDialState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/EmailAddressAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/browser/AddBookmarkPage$UpdateBookmarkTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/WebViewClassic;-clearCache-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/DownloadCache$DownloadTask;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/model/dataitem/OrganizationDataItem;-buildDataStringForDisplay-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$GroupCreatedState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/calllog/CallLogFragment;-setMenuVisibility-(Z)V' : ['android.permission.WRITE_CALL_LOG', 'android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/nfc/tech/MifareClassic;-authenticateSectorWithKeyA-(I [B)Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/policy/BluetoothController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/soundrecorder/Recorder$OnStateChangedListener;-onStateChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/LocationSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CsimFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-copyMedia-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/RIL;-getGsmBroadcastConfig-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onSingleTapUp-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/BrowserWebView;-destroy-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/PhoneDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/TabControl;-createNewWebView-()Landroid/webkit/WebView;' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Landroid/webkit/AccessibilityInjectorFallback;-onKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/provider/Browser;-getVisitedHistory-(Landroid/content/ContentResolver;)[Ljava/lang/String;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/exchange/EmailSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TetherSettings;-access$300-(Lcom/android/settings/TetherSettings;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$H$1;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-onAttachedToWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/tech/NfcB;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/contacts/model/dataitem/RelationDataItem;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/NetInitiatedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/browser/BaseUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/ui/MessageUtils$3$1;-run-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage;-showBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/BlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPan$Stub$Proxy;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-virtualUnplug-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleBackspace-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/WebViewProvider;-findAll-(Ljava/lang/String;)I' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/WorkingMessage;-access$1500-(Lcom/android/mms/data/WorkingMessage; Lcom/android/mms/data/Conversation; Z)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/TagClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-fireDataChange-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephony;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/tech/MifareClassic;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/telephony/gsm/SmsManager;-sendMultipartTextMessage-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5600-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/NotificationMgr;-updateNotificationsAtStartup-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebViewClassic;-resumeTimers-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-saveRingtone-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/Gallery;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/ZoomControlEmbedded$ZoomListener;-onVisibilityChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/videosrc/MediaSource;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-loadDataWithBaseURL-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/InCallScreen;-showPausePromptDialog-(Lcom/android/internal/telephony/Connection; Ljava/lang/String;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-deleteInTransaction-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/AccessibilitySettings$ToggleScreenMagnificationPreferenceFragment;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterfw/core/SyncRunner;-performStep-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-silenceRingerInternal-()V' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/power/Notifier;-onGoToSleepFinished-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment;-setupEditorForAccount-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-wakeWhenReadyTq-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/INfcAdapterExtras$Stub;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Lcom/android/contacts/editor/EventFieldEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-access$300-(Lcom/android/contacts/editor/ContactEditorFragment; Landroid/content/Context; Lcom/android/contacts/editor/RawContactEditorView;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/PhoneApp;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontFromLaunchLocked-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.DISABLE_KEYGUARD', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH'],
	'Landroid/filterfw/core/FieldPort;-transfer-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/DeskClock$TabsAdapter;-notifyPageChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RadioInfo;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserWebView;-setBackgroundColor-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterfw/core/FieldPort;-setFieldFrame-(Landroid/filterfw/core/Frame; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHeadset;-isDisabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub$Proxy;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-setup-(Lcom/android/systemui/statusbar/policy/NetworkController; Lcom/android/systemui/statusbar/policy/BluetoothController; Lcom/android/systemui/statusbar/policy/BatteryController; Lcom/android/systemui/statusbar/policy/LocationController;)V' : ['android.permission.BLUETOOTH', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView$KeyTimerHandler;-startLongPressTimer-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/content/IIntentReceiver;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/net/NetworkStatsService;-performPoll-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/UrlInputView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/NullFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/CameraSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetooth$Stub;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiManager;-isWifiApEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/webkit/WebViewInputDispatcher;-enqueueUiEventLocked-(Landroid/webkit/WebViewInputDispatcher$DispatchEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-messageFailedToSend-(Landroid/net/Uri; I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ManageSimMessages$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/exchange/ExchangeService;-releaseMailbox-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-installSystemProviders-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/FindActionModeCallback;-onDestroyActionMode-(Landroid/view/ActionMode;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$9;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-access$7200-(Landroid/webkit/WebViewClassic; Landroid/view/MotionEvent; I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowManager;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/gallery3d/app/PhotoPage;-toggleBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$3200-(Lcom/android/gallery3d/ui/PhotoView; I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-setCurrentPhoto-(Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onLongPressTimeout-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/WifiService;-clearBlacklist-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-handleDocked-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-changeParser-(Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/TextClock;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$5900-(Lcom/android/mms/ui/ComposeMessageActivity; Ljava/lang/String; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessages-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment;-onDestroy-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getMediaItemFromPath-(Ljava/util/ArrayList; I I Lcom/android/gallery3d/data/DataManager;)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/timer/TimerFragment;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onCreate-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/OtaUtils;-setSpeaker-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/power/Notifier;-sendWakeUpBroadcast-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/speech/SpeechRecognizer;-handleStartListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/net/INetworkStatsService$Stub;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/VideoModule;-onResumeAfterSuper-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/StateManager;-restoreFromState-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onGenericMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/Contact;-getFirstWritableRawContactId-(Landroid/content/Context;)J' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthListView;-init-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/UiModeManagerService;-updateLocked-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/calendar/alerts/AlertService;-generateAlerts-(Landroid/content/Context; Lcom/android/calendar/alerts/NotificationMgr; Lcom/android/calendar/alerts/AlarmManagerInterface; Landroid/content/SharedPreferences; Landroid/database/Cursor; J I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ActivityManager;-getRecentTasksForUser-(I I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/IccCardProxy;-supplyPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/net/wifi/WifiManager;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/power/Notifier$1;-onScreenOn-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager;-clearBlacklist-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/socialwidget/SocialWidgetProvider;-access$000-(Landroid/content/Context; I Landroid/appwidget/AppWidgetManager; Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/agenda/AgendaAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/debug/ContactsDumpActivity$DumpDbTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForWatchdogToggle-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/ActivityManagerNative;-setProcessLimit-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothAdapter;-closeProfileProxy-(I Landroid/bluetooth/BluetoothProfile;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebViewClassic$WebViewInputConnection;-performEditorAction-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendThisDeviceChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/DeskClock;-registerPageChangedListener-(Lcom/android/deskclock/DeskClockFragment;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-startBluetoothSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncFragment;-onPause-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/GlobalActions$4;-onItemLongClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)Z' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/util/Recycler;-getAllThreads-(Landroid/content/Context;)Landroid/database/Cursor;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/http/RequestQueue$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/CallNotifier;-onCdmaCallWaitingReject-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/KeyguardManager;-exitKeyguardSecurely-(Landroid/app/KeyguardManager$OnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-clearAll-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/TransactionService;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/model/SlideshowModel;-getPduBody-(Landroid/content/Context; Landroid/net/Uri;)Lcom/google/android/mms/pdu/PduBody;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/wm/WindowManagerService;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppDiedLocked-(Lcom/android/server/am/ProcessRecord; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPairingConfirmation-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/server/net/NetworkStatsService;-getNetworkStatsUidDetail-()Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DayView;-switchViews-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephony;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/IAlarmManager$Stub;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/camera/ui/ListPrefSettingPopup;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StartTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TetherSettings;-startTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PhotoPage;-switchToGrid-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioManager;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/BrowserWebView;-reload-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-drawContent-(Landroid/graphics/Canvas;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary;-hasEthernet-(Landroid/content/Context;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/inputmethod/UserDictionaryList;-onResume-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/bluetooth/btservice/AdapterService;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/PeopleActivity$ContactDetailLoaderFragmentListener$1;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView;-onResume-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$ShuffleSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-connect-(Landroid/net/wifi/p2p/WifiP2pConfig; Z)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS'],
	'Lcom/google/common/io/ByteStreams$5;-getInput-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-keyPressed-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$1200-(Lcom/android/contacts/activities/ConfirmAddDetailActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/accounts/AccountManagerService;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$LoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/accounts/AccountManager$Future2Task;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ConversationList;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/FrameSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/HTML5VideoView;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavScreen;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setScanMode-(I I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-beginDragging-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/wallpaper/RenderScriptScene;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPINView;-verifyPasswordAndUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/SlideshowEditActivity$SlideListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/SipCallOptionHandler;-access$300-(Lcom/android/phone/SipCallOptionHandler; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.USE_SIP'],
	'Lcom/android/mms/data/WorkingMessage;-prepareForSave-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-onUuidChanged-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/calllog/CallLogQueryHandler;-fetchCalls-(I I Z I)V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/location/fused/FusionEngine;-setRequest-(Lcom/android/location/provider/ProviderRequestUnbundled; Landroid/os/WorkSource;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactPickerFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/alerts/AlertActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/input/InputManagerService;-registerPointerSpeedSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/AllInOneActivity;-onUserLeaveHint-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/CommandsInterface;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-updateParams-(Ljava/util/HashMap;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$2;-run-()V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/WebView;-saveWebArchive-(Ljava/lang/String; Z Landroid/webkit/ValueCallback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/month/MonthListView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/AlbumPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpace-(I Ljava/lang/String; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stopSample-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$3;-dismiss-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-requestSelectionToScreen-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/DayView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/wallpaper/nexus/NexusRS;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/downloads/DownloadThread;-processResponseHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState; Lorg/apache/http/HttpResponse;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/agenda/AgendaFragment;-onResume-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/VibratorService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/research/UploaderService;-doUpload-(Z)V' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/RecentApplicationsDialog;-reloadButtons-()V' : ['android.permission.GET_TASKS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView;-onWindowFocusChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/support/v4/net/ConnectivityManagerCompatHoneycombMR2;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/tech/BasicTagTechnology;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/providers/contacts/ProfileProvider;-insertInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub;-setNetworkPolicies-([Landroid/net/NetworkPolicy;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/Launcher;-showFirstRunWorkspaceCling-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/CallManager;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Landroid/content/ISyncAdapter$Stub;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/wm/Session;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ConversationList;-confirmDeleteThread-(J Landroid/content/AsyncQueryHandler;)V' : ['android.permission.READ_SMS'],
	'Landroid/speech/SpeechRecognizer;-stopListening-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/providers/downloads/DownloadReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/StatusBarManagerService;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Settings$KeyboardLayoutPickerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/SecureSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcAdapterExtras$Stub$Proxy;-open-(Ljava/lang/String; Landroid/os/IBinder;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Landroid/telephony/TelephonyManager;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/preference/YesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar$2;-onClickHandler-(Landroid/view/View; Landroid/app/PendingIntent; Landroid/content/Intent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/BlendFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/display/WifiDisplayController;-<init>-(Landroid/content/Context; Landroid/os/Handler; Lcom/android/server/display/WifiDisplayController$Listener;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/webkit/WebViewClassic$WebViewInputConnection;-sendKey-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerSession;-onGetSuggestions-(Landroid/view/textservice/TextInfo; I)Landroid/view/textservice/SuggestionsInfo;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onPause-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-onResume-()V' : ['android.permission.WRITE_CALL_LOG', 'android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView;-wakeWhenReadyTq-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue$Element;-onPhantomUpEvent-(J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/provider/ContactsContract$SyncState;-set-(Landroid/content/ContentProviderClient; Landroid/accounts/Account; [B)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/WifiService;-getWifiStateMachineMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/Settings$WifiDisplaySettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/editor/PhoneticNameEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/launcher2/Workspace;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/Controller;-stopLoading-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$400-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/camera/VideoModule;-init-(Lcom/android/camera/CameraActivity; Landroid/view/View; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/googlecode/mp4parser/authoring/adaptivestreaming/FlatPackageWriterImpl;-write-(Lcom/googlecode/mp4parser/authoring/Movie;)V' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/ui/DetailsHelper$DetailsViewContainer;-show-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$SoundSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ConversationListItem;-updateFromView-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-toggleSpeaker-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/net/wifi/SupplicantStateTracker;-access$200-(Landroid/net/wifi/SupplicantStateTracker; Landroid/net/wifi/SupplicantState; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/power/PowerManagerService;-init-(Landroid/content/Context; Lcom/android/server/LightsService; Lcom/android/server/am/ActivityManagerService; Lcom/android/server/BatteryService; Lcom/android/internal/app/IBatteryStats; Lcom/android/server/display/DisplayManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/inputmethod/BaseInputConnection;-performEditorAction-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/AccountSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/systemui/statusbar/phone/StatusBarWindowView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-onClick-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewProvider;-loadUrl-(Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-hasContentChanged-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/NotificationMgr;-init-(Lcom/android/phone/PhoneGlobals;)Lcom/android/phone/NotificationMgr;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SubSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/ContactsActivity;-onBackPressed-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/data/SecureAlbum;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$1900-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator; Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager$ShowListener;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/handover/HandoverManager;-createBluetoothOobDataRecord-()Landroid/nfc/NdefRecord;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/base/RetargetFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/nsd/INsdManager$Stub;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/EasAccountService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-access$300-(Lcom/android/internal/widget/multiwaveview/GlowPadView; I F F)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothVisibilityTimeoutFragment;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/display/DisplayManagerService;-setDisplayHasContent-(I Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/sip/SipEditor;-access$600-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteReminders-(Landroid/net/Uri; Z Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/os/IHardwareService$Stub$Proxy;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Landroid/media/AudioService$SettingsObserver;-<init>-(Landroid/media/AudioService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-validate-(Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5100-(Lcom/android/bluetooth/hfp/HeadsetStateMachine;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteAlias-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/Filter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-onStart-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-handleTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetooth;-setRemoteAlias-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/IAccountManager;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendVCards-(Ljavax/obex/Operation; Ljava/lang/String; Z Ljava/lang/String; Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-reportSimUnlocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnected-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView$9$1$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/google/SearchBaseUrlHelper$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Landroid/os/PowerManager$WakeLock;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-switchToState-(I F F)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/wfd/WifiDisplaySettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/BluetoothHeadset;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-flashAndSetGenericTrue-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/WebViewTimersControl;-onPrerenderStart-(Landroid/webkit/WebView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onProgressComplete-(I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Lcom/google/common/io/Resources;-toString-(Ljava/net/URL; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/providers/calendar/CalendarProvider2;-regenerateInstancesTable-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onEnableNewApn-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/detail/ContactLoaderFragment$ContactLoaderFragmentListener;-onDetailsLoaded-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/ISms;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-hasPendingChanges-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-<init>-(Lcom/android/music/MediaPlaybackService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitorCallback;-onSimStateChanged-(Lcom/android/internal/telephony/IccCardConstants$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/GLView$OnClickListener;-onClick-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/IRecognitionService$Stub$Proxy;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/WebViewController;-onProgressChanged-(Lcom/android/browser/Tab;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/EditEventView;-setViewStates-(I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/BrowserActivity;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/ViewRootImpl;-handleImeFinishedEvent-(I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/PhoneDataItem;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/VibratorService$Vibration;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/bluetooth/hid/HidService;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub;-getRemoteClass-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/media/RingtonePickerActivity;-stopAnyPlayingRingtone-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/HTML5VideoFullScreen;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/BluetoothHeadsetHandover$Callback;-onBluetoothHeadsetHandoverComplete-(Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-getLastLocation-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-updateActivityLockScreenState-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/WifiService;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText;-updateCarrierText-(Lcom/android/internal/telephony/IccCardConstants$State; Ljava/lang/CharSequence; Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/input/InputManagerService;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setEnabled-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-processResponse-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-startDeleteAll-(Lcom/android/mms/data/Conversation$ConversationQueryHandler; I Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/ViewRootImpl;-deliverKeyEventPostIme-(Landroid/view/ViewRootImpl$QueuedInputEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-inputDispatchingTimedOut-(I Z)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-handleNotifyScreenOn-(Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewManager$ShowListener;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserWebView;-postUrl-(Ljava/lang/String; [B)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-onConnectedInOrOut-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavigationBarBase;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/activities/JoinContactActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/search/SearchEngine;-getSuggestions-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserHistoryPage$ClearHistoryTask;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-<init>-(Lcom/android/contacts/activities/PhotoSelectionActivity; Landroid/content/Context; Landroid/view/View; I Lcom/android/contacts/model/RawContactDeltaList; Lcom/android/contacts/activities/PhotoSelectionActivity$1;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/Controller$6;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-queryExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreen;-onHoldClick-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/HTML5VideoViewProxy;-enterFullScreenVideo-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/P2pLinkManager$3;-doGet-(I Landroid/nfc/NdefMessage;)Lcom/android/nfc/snep/SnepMessage;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/LocationManagerService$Receiver;-access$1100-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothPhoneService;-handlePreciseCallStateChange-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/ContactsListActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/WebsiteDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothPhoneService;-access$400-(Lcom/android/phone/BluetoothPhoneService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/data/Conversation;-access$700-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-topAppWindowChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/google/common/io/Files;-toString-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothA2dp;-shouldSendVolumeKeys-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView;-onResume-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/SearchActivity;-onCreateOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/net/IConnectivityManager$Stub;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-createIntent-(Landroid/content/Context; J)Landroid/content/Intent;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/PasswordUnlockScreen$4;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createConsentDialog-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;-delete-(J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-restorePmMetadata-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/BroadcastQueue;-broadcastTimeoutLocked-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$8200-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/IRecognitionService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-fillDigitsIfNecessary-(Landroid/content/Intent;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-queryInternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity$3;-run-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/QuickContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/WebViewClassic;-onFixedLengthZoomAnimationEnd-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/model/dataitem/GroupMembershipDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-determineScrollingStart-(Landroid/view/MotionEvent; F)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothDevice;-setPairingConfirmation-(Z)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-killAppAtUsersRequest-(Lcom/android/server/am/ProcessRecord; Landroid/app/Dialog;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/RIL;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-canUnbindBluetoothService-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/btservice/RemoteDevices;-pinRequestCallback-([B [B I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/month/MonthListView;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/BluetoothHeadset;-disconnectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/content/SyncManager$ActiveSyncContext;-<init>-(Landroid/content/SyncManager; Landroid/content/SyncOperation; J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLRoot;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onTrySetupData-(Lcom/android/internal/telephony/ApnContext;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine;-handleScreenStateChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabControl;-createNewTab-(Z)Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/ContactSaveService;-renameGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$LoaderTask;-onPostExecute-(Ljava/lang/Boolean;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/FaceUnlock;-handleCancel-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-access$500-(Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView$2;-onStartBatchInput-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/WebIconDatabaseClassic;-bulkRequestIconForPageUrl-(Landroid/content/ContentResolver; Ljava/lang/String; Landroid/webkit/WebIconDatabase$IconListener;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addImage-(Landroid/net/Uri; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/browser/provider/BrowserProvider2;-updateBookmarksInTransaction-(Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/list/ContactListAdapter;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/HidProfile;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/net/NetworkPolicyManagerService$12;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onClockVisibilityChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetryScheduler;-setRetryAlarm-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/sip/SipSettings$3;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/bluetooth/hfp/AtPhonebook;-checkAccessPermission-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkState-()[Landroid/net/NetworkState;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onPageSwitching-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-requestRouteToHostAddress-(I [B)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/bluetooth/hid/HidService;-broadcastConnectionState-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/model/VideoModel;-loadThumbnailBitmap-(Lcom/android/mms/util/ItemLoadedCallback;)Lcom/android/mms/util/ItemLoadedFuture;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/util/StateMachine$SmHandler$HaltingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/exchange/EasSyncService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothHeadset;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/agenda/AgendaFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-getNfcAdapterExtrasInterface-(Ljava/lang/String;)Landroid/nfc/INfcAdapterExtras;' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/app/TrimVideo;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/telephony/SmsProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/wifi/WifiStateTracker;-setRadio-(Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/IConnectivityManager$Stub;-startLegacyVpn-(Lcom/android/internal/net/VpnProfile;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceRemoved-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/DisplayPowerController$Callbacks;-onProximityPositive-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/content/SyncManager$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/emailcommon/service/EmailServiceProxy;-<init>-(Landroid/content/Context; Landroid/content/Intent; Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/NameConverter;-structuredNameToDisplayName-(Landroid/content/Context; Ljava/util/Map;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/nfc/INfcTag$Stub;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/server/sip/SipSessionGroup;-processTransactionTerminated-(Ljavax/sip/TransactionTerminatedEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/HTML5VideoView;-reprepareData-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/LogTag$1;-run-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/BrowserWebView;-setLayerType-(I Landroid/graphics/Paint;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setOutgoingCallerIdDisplay-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/NetworkStateTracker;-setRadio-(Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/browser/BrowserWebView;-addJavascriptInterface-(Ljava/lang/Object; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/GLTextureSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$5700-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/SmsReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$4;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/preferences/WebsiteSettingsFragment$SiteAdapter$UpdateFromBookmarksDbTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService;-restartPortMappingLifetimeMeasurement-(Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-updateClustersContents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DockService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getCallHistorySize-(I)I' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/am/ActivityManagerService;-finishInstrumentationLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/nfc/NfcService$TagService;-ndefRead-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/browser/Controller;-dismissSubWindow-(Lcom/android/browser/Tab;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wm/WindowManagerService;-setHoldScreenLocked-(Lcom/android/server/wm/Session;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-buildAppWidgetModel-(Landroid/content/Context; Landroid/database/Cursor; Ljava/lang/String;)Lcom/android/calendar/widget/CalendarAppWidgetModel;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/MtpDeviceSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/WindowAnimator;-access$100-(Lcom/android/server/wm/WindowAnimator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-updateLocalProfiles-([Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebViewInputDispatcher;-drainStaleWebKitEventsLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ContactEditorAccountsChangedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebViewClassic;-setBaseLayer-(I Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewProvider;-findNext-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SmsStorageMonitor;-handleIccFull-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-answerRingingCallInternal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-openAssetFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/content/res/AssetFileDescriptor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager;-getWifiApEnabledState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/MccTable;-setWifiCountryCodeFromMcc-(Landroid/content/Context; I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/IWindowSession$Stub;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToBackLocked-(I Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/SnapshotTab;-setWebView-(Landroid/webkit/WebView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary;-setMobilePolicySplit-(Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-getDrmMimeSavedStringRsrc-(J Z)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/music/MusicPicker;-setSelected-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager;-onScreenTurnedOff-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onPrepareOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-observe-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/InputMethodManagerService;-showInputMethodSubtypeMenu-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$3800-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton$1;-onUserSwitched-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ConversationList$2;-run-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DockService;-connectIfEnabled-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/StitchingChangeListener;-onStitchingResult-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-access$1700-(Lcom/android/calendar/agenda/AgendaWindowAdapter; Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/data/DownloadUtils;-requestDownload-(Lcom/android/gallery3d/util/ThreadPool$JobContext; Ljava/net/URL; Ljava/io/File;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-onSystemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/util/Recycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveRingtone-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/BroadcastQueue;-skipPendingBroadcastLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/accounts/AccountSyncSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$3;-reportSuccessfulUnlockAttempt-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavScreen;-onClick-(Landroid/view/View;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-onCreate-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/net/NetworkPolicyEditor;-read-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/widget/SlidingTab;-onVisibilityChanged-(Landroid/view/View; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Ljava/net/URLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onBackPressed-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView;-recreateUnlockScreen-(Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView$UnlockMode;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment$2;-onChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/alerts/AlertActivity;-access$400-(Lcom/android/calendar/alerts/AlertActivity; J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager$Stub$Proxy;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/DayView$CalendarGestureListener;-onDown-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/research/ResearchLogger;-resumeLogging-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationDone-(Landroid/net/sip/ISipSession; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadsetPhone;-processChld-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPdus-([[B)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/Search;-searchMessages-(Landroid/content/Context; J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-savePhonebookPermissionChoice-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/DockService;-applyBtSettings-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/MessageStatusService;-updateMessageStatus-(Landroid/content/Context; Landroid/net/Uri; [B Ljava/lang/String;)Landroid/telephony/SmsMessage;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setCountryCode-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$AccessibilityContentObserver;-<init>-(Lcom/android/server/accessibility/AccessibilityManagerService; Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/SnapshotTab;-saveViewState-(Landroid/content/ContentValues;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-access$1600-(Lcom/android/server/ConnectivityService; I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onSingleTapUp-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPasswordView;-onResume-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDraggingWidget-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IThrottleManager$Stub;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ManageSimMessages;-access$000-(Lcom/android/mms/ui/ManageSimMessages;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-addVideo-(Landroid/net/Uri; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getAdapterConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebViewClassic;-displaySoftKeyboard-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/webkit/WebViewInputDispatcher;-dispatchUiEvents-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/WifiApEnabler;-updateTetherState-([Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/ConnectivityManager;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Tab$SubWindowClient;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-buildEntries-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/DataManager;-getSupportedOperations-(Lcom/android/gallery3d/data/Path;)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastStickyIntent-(Landroid/content/Intent; Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-isDrmRingtoneWithRights-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/LatinIME$BatchInputUpdater;-getSuggestedWordsGestureLocked-(Lcom/android/inputmethod/latin/InputPointers; Lcom/android/inputmethod/latin/LatinIME;)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/RIL;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameFetch;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewBase;-interceptMediaKey-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/EmailDataItem;-getKindTypeColumn-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/inputmethodservice/KeyboardView;-openPopupIfRequired-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCleanUpConnection-(Z I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/dataitem/SipAddressDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$000-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord$Token;-keyDispatchingTimedOut-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$StartingState;-enter-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService;-access$1200-(Lcom/android/music/MediaPlaybackService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressShift-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAccountView;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/tech/MifareClassic;-setTimeout-(I)V' : ['android.permission.NFC'],
	'Lcom/android/deskclock/AlarmKlaxon;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/google/android/mms/pdu/PduPersister;-updateHeaders-(Landroid/net/Uri; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Landroid/net/ThrottleManager;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/calllog/CallLogQueryHandler;-fetchVoicemailStatus-()V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$StorageUseActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/VideoModule;-onCancelBgTraining-(Landroid/view/View;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/WindowManagerService;-setUniverseTransformLocked-(Lcom/android/server/wm/WindowState; F F F F F F F)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/location/GpsLocationProvider;-requestSetID-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/gallery3d/data/UriSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/SpeechRecognizer;-startListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/contacts/calllog/CallLogAdapter$CallFetcher;-fetchCalls-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/location/ILocationProvider$Stub;-disable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler$2;-run-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebViewClassic$WebViewInputConnection;-finishComposingText-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BluetoothManagerService;-access$1900-(Lcom/android/server/BluetoothManagerService; Z)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-getSuggestionsWithSessionId-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; I)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService$ScoClient;-requestScoState-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/ContactsProvider2;-getType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/exchange/utility/CalendarUtilities;-createMessageForEventId-(Landroid/content/Context; J I Ljava/lang/String; Lcom/android/emailcommon/provider/Account; Ljava/lang/String;)Lcom/android/emailcommon/provider/EmailContent$Message;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterfw/core/Filter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/TintFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-userSwitched-(I)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BatteryService;-access$200-(Lcom/android/server/BatteryService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/AddBookmarkPage;-getUriForFolder-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/os/IPowerManager;-updateWakeLockWorkSource-(Landroid/os/IBinder; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService;-done-(Lcom/android/exchange/AbstractSyncService;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/CoreSettingsObserver;-beginObserveCoreSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-handleSetHidden-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/StateManager;-notifyActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/RIL;-setMute-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/KeyguardManager;-isKeyguardSecure-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Pending;-processConnectionEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/Recorder;-setState-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IEmailService;-validate-(Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthDeathRecipient;-binderDied-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/p2p/WifiP2pManager;-initialize-(Landroid/content/Context; Landroid/os/Looper; Landroid/net/wifi/p2p/WifiP2pManager$ChannelListener;)Landroid/net/wifi/p2p/WifiP2pManager$Channel;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/widget/TransportControlView;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/webkit/WebViewClassic;-setUseMockDeviceOrientation-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterfw/core/FilterFunction;-executeWithArgList-([Ljava/lang/Object;)Landroid/filterfw/core/Frame;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setFilter-(Lcom/android/contacts/list/ContactListFilter;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/DataUsageSummary$AppDetailsFragment;-onStop-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$NfcAdapterExtrasService;-close-(Ljava/lang/String; Landroid/os/IBinder;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Landroid/app/IActivityManager;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String; I)Landroid/content/Intent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/detail/ContactDetailFragment$AddToMyContactsQuickFix;-execute-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService;-setBluetoothA2dpDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleMultipartyIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/Session;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-notifyScreenOnLocked-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager$ShowListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-startCamera-()V' : ['android.permission.CAMERA'],
	'Lcom/android/server/ConnectivityService;-enforceChangePermission-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/SnapshotTab$LoadData;-onPostExecute-(Landroid/database/Cursor;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-handleCdmaSubscriptionSource-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/AllInOneActivity$4;-onChange-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-<init>-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CryptKeeper;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addVideo-(Landroid/net/Uri; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityViewFlipper;-reset-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/view/IInputMethodClient$Stub$Proxy;-onUnbindMethod-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/SaturateEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/inputmethod/BaseInputConnection;-sendKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/MessageItem$PduLoadedCallback;-onPduLoaded-(Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/camera/ui/RenderOverlay$RenderView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-getIntentBySingleSelectedPath-(Ljava/lang/String;)Landroid/content/Intent;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetryScheduler;-getResponseStatus-(J)I' : ['android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnectedProfile-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/AccountsChangedReceiver$DeleteRemovedAccounts;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/browser/NavScreen;-access$000-(Lcom/android/browser/NavScreen; Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/AccountUnlockScreen;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/Settings;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/Invert;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/RIL;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DisconnectingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/util/State;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothDevice;-createScoSocket-()Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/WindowManagerService;-startAppFreezingScreenLocked-(Lcom/android/server/wm/AppWindowToken; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-startLongPressTimer-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-storeMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/AsyncQueryService;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/PeopleActivity;-access$300-(Lcom/android/contacts/activities/PeopleActivity;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/AccessibilityInjectorFallback;-traverseCurrentAxis-(I Z Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/OrganizationDataItem;-hasKindTypeColumn-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/MtpDeviceSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/os/IHardwareService$Stub;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/Filter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LightsService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/mms/ui/MmsThumbnailPresenter;-presentFirstSlide-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/SlideModel;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/AudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/BrowserWebView;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onSimStateChanged-(Lcom/android/internal/telephony/IccCardConstants$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/PointerSpeedPreference;-showDialog-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/PeopleActivity;-showEmptyStateForTab-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/soundrecorder/Recorder;-clear-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/display/DisplayAdapter$2;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Landroid/content/Intent;)Ljava/lang/Void;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothPhoneService;-onCreate-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/HTML5VideoView;-prepareDataCommon-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveDraft-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView$PageSwitchListener;-onPageSwitching-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/util/JobLimiter$JobWrapper;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Landroid/bluetooth/BluetoothSocket;-bindListen-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/QuickResponseActivity;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/TelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService;-onSeEmvCardRemoval-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/phone/InCallScreen;-onDialerClose-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/wifi/WifiStateMachine$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService;-onSeListenDeactivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Landroid/accounts/IAccountManager;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/provider/Browser;-addSearchUrl-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/data/FilterTypeSet;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToPage-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/StatusBarManagerService;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-refreshProfiles-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/BatteryService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/InputMonitor;-notifyLidSwitchChanged-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/SlidingTab$OnTriggerListener;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame$Callbacks;-onCameraLaunchedSuccessfully-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPin-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/AccessibilityInjector;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-selectCustomFilter-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/StateManager;-startStateForResult-(Ljava/lang/Class; I Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/tech/Ndef;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/phone/MobileNetworkSettings;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/tech/Ndef;-makeReadOnly-()Z' : ['android.permission.NFC'],
	'Lcom/android/server/UiModeManagerService;-access$000-(Lcom/android/server/UiModeManagerService; Ljava/lang/String; I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebView;-performLongClick-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$12;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-postEventFromNative-(Ljava/lang/Object; I I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onDevicePreferenceClick-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-onPopupItemClick-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-showEmptyState-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/webkit/AccessibilityInjector;-removeAccessibilityApisIfNecessary-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowManager$Stub;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-initDevicePreference-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/PhoneUtils;-mergeCalls-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/browser/TabControl;-createNewTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/VideoView;-release-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/exchange/EasAccountService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabControl;-removeParentChildRelationShips-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService;-notifyProfileRemoved-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogListItemHelper;-setPhoneCallDetails-(Lcom/android/contacts/calllog/CallLogListItemViews; Lcom/android/contacts/PhoneCallDetails; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView$3;-reportFailedUnlockAttempt-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-parseIntent-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/gsm/SmsManager;-getAllMessagesFromSim-()Ljava/util/ArrayList;' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-handleNotificationError-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/EdgeView;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-isSecure-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityRecord$Token;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/EventDataItem;-getKindTypeColumn-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothAdapter;-disable-(Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-access$100-(Lcom/android/contacts/calllog/CallLogAdapter;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleCharacter-(I [I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-setKeyguardEnabled-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone; Landroid/telephony/CellInfo;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/common/io/ByteStreams;-getChecksum-(Lcom/google/common/io/InputSupplier; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/list/AccountFilterActivity$FilterListAdapter;-<init>-(Landroid/content/Context; Ljava/util/List; Lcom/android/contacts/list/ContactListFilter;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-loadAttachment-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hid/HidService;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/accounts/IAccountManager;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/calendar/DayFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DataUsageSummary;-setRestrictBackground-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/HTML5VideoViewProxy;-enterFullscreenForVideoLayer-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onCardEmulationAidSelected-([B)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Landroid/app/AlarmManager;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/BluetoothInputDevice;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebView;-loadUrl-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/ActionModeHandler$2;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Void;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/bluetooth/IBluetoothHeadset;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-fadeInChallenge-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/AutoCompleteTextView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarDebug$FetchInfoTask;-doInBackground-([Ljava/lang/Void;)Ljava/util/List;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-replaceMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAbsKeyInputView;-verifyPasswordAndUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/TransactionService$ConnectivityBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/accounts/IAccountManager$Stub;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-checkAppWidgetConsistency-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-snapToPage-(I I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/SnailAlbum;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/Notifier;-playWirelessChargingStartedSound-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$26;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/WifiService;-getDhcpInfo-()Landroid/net/DhcpInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/providers/downloads/DownloadReceiver;-hideNotification-(Landroid/content/Context; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-onPressKey-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/view/View; Landroid/graphics/Bitmap; Lcom/android/launcher2/DragSource; Ljava/lang/Object; I Landroid/graphics/Rect; F)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/debug/DataExporter;-exportData-(Landroid/content/Context;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/widget/MultiAutoCompleteTextView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-enter-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/ChooseLockGeneric$ChooseLockGenericFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-disableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService$UpdateThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-sendSettings-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/PatternUnlockScreen$UnlockPatternListener;-onPatternDetected-(Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-<init>-(Landroid/content/Context; Lcom/android/internal/policy/impl/PhoneWindowManager;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-updateScreen-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/UiccCard;-update-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/IccCardStatus;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ClassZeroActivity$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-dial-(Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/VoiceContact;-redialNumber-(Landroid/app/Activity;)Ljava/lang/String;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/am/ActivityManagerService;-moveTaskBackwards-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-wakeWhenReadyLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/vcard/VCardParserImpl_V30;-handleNest-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/WebViewCore;-sendMessage-(I I I Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/NicknameDataItem;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/SimPukUnlockScreen$TouchInput;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/data/MediaSet$ItemConsumer;-consume-(I Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarProvider2;-modifyCalendarSubscription-(J Z)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/BluetoothHeadset;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/ContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/WebViewInputDispatcher$UiCallbacks;-dispatchUiEvent-(Landroid/view/MotionEvent; I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/camera/PhotoModule$4;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/UiController;-openIncognitoTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/BluetoothPan;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/Utils;-getDayOfWeekString-(I I J Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/sip/ISipService;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createUserEntryDialog-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteEndpointDiscovered-(Lcom/android/nfc/DeviceHost$TagEndpoint;)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/contacts/group/GroupEditorFragment;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/vpn2/VpnSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-acquireWakeLockAndExecute-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-saveViewState-(Ljava/io/OutputStream; Landroid/webkit/ValueCallback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-addCachedDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/pm/PackageManagerService;-main-(Landroid/content/Context; Lcom/android/server/pm/Installer; Z Z)Landroid/content/pm/IPackageManager;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmKlaxon;-startAlarm-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$RecipientsMenuClickListener;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$10$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener$Adapter;-onCustomRequest-(I)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/bluetooth/btservice/AdapterState$PendingCommandState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/WifiService;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/browser/Controller;-onUserCanceledSsl-(Lcom/android/browser/Tab;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDeviceFilter$TransferFilter;-matches-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipProfile; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/app/SlideshowPage;-showPendingBitmap-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$1;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoPage;-updateUIForCurrentPhoto-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothPan$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-attach-(Landroid/service/wallpaper/WallpaperService$IWallpaperEngineWrapper;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/browser/preferences/InvertedContrastPreview;-setupWebView-(Landroid/webkit/WebView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/NfcService$EnableDisableTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/btservice/AdapterState$OnState;-enter-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler;-getDeltaForAttachingPhotoToContact-()Lcom/android/contacts/model/RawContactDeltaList;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1800-(Lcom/android/bluetooth/opp/BluetoothOppService; Landroid/database/Cursor; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/contacts/model/dataitem/StructuredPostalDataItem;-buildDataString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/editor/SplitContactConfirmationDialogFragment$Listener;-onSplitContactConfirmed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-internalSilenceRinger-()V' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/Settings$DevelopmentSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker$CompletedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/MtpDevice;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-isDuplicateMessage-(Landroid/content/Context; Lcom/google/android/mms/pdu/RetrieveConf;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/PushReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/Transaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$ApplyRoutingTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-rightButtonAction-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/GrayscaleEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/IccLockSettings;-tryChangePin-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-startRfcommSocketListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewManager;-onScreenTurnedOn-(Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewManager$ShowListener;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/DataController$DataControllerHandler;-doLoadThumbnail-(Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/FlipFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$2;-onAddView-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-closeDialpadInternal-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/music/IMediaPlaybackService;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/WaveView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage$4;-onSingleTapUp-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/ActivityController;-onPause-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.NFC'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/coremedia/iso/IsoFile;-<init>-(Ljava/nio/channels/ReadableByteChannel;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-startScanning-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$MyExecutor;-execute-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasAccountService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-onScreenTurnedOn-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-access$400-(Lcom/android/server/am/ActivityManagerService; Ljava/lang/String; I Z Z Z Z I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-findOnPage-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-updateLockScreenTimeout-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$NextAlarmObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onUuidChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadThread;-runInternal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/UsimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mms/ui/NoConfirmationSendService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountAdapter;-getChildrenCursor-(Landroid/database/Cursor;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/location/fused/FusedLocationService;-onUnbind-(Landroid/content/Intent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/calendar/SearchActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onBluetoothStateChanged-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/NavScreen$2;-onLayout-(I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/location/ILocationManager$Stub;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/LockPatternView;-detectAndAddHit-(F F)Lcom/android/internal/widget/LockPatternView$Cell;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/browser/AddBookmarkPage$UpdateBookmarkTask;-doInBackground-([Landroid/content/ContentValues;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$ProvisionDiscoveryState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/util/IState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/downloads/DownloadInfo;-isReadyToStart-(J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cat/CatService;-sendTerminalResponse-(Lcom/android/internal/telephony/cat/CommandDetails; Lcom/android/internal/telephony/cat/ResultCode; Z I Lcom/android/internal/telephony/cat/ResponseData;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-deactivateDataCall-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/PieItem;-performClick-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/AccountsTester$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/CropFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/contacts/vcard/SelectAccountActivity;-onCreateDialog-(I Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-startSettingsActivity-(Landroid/content/Intent; Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3100-(Lcom/android/mms/ui/ComposeMessageActivity; J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth;-connectSocket-(Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Landroid/content/ISyncAdapter;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/wm/WindowManagerService$3;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$TagService;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-access$1800-(Lcom/android/gallery3d/app/AlbumDataLoader; Ljava/util/concurrent/Callable;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/editor/AggregationSuggestionView;-handleItemClickEvent-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/base/GLTextureTarget;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-getSuggestions-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo;)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setLine1Number-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onLongPress-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-init-(Landroid/content/Context;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-access$1700-(Lcom/android/gallery3d/app/AlbumSetPage; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/ui/SlideViewInterface;-startAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/Phone;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebViewClassic;-contentInvalidateAll-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/sip/ISipService;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-setCurrentPage-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary$LimitEditorFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-createDevicePreference-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/location/ComprehensiveCountryDetector;-startLocationBasedDetector-(Landroid/location/CountryListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/HTML5VideoInline;-prepareDataAndDisplayMode-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/CallbackFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifySendFailed-(Landroid/content/Context; Z)V' : ['android.permission.READ_SMS'],
	'Lcom/android/server/net/LockdownVpnTracker;-onVpnStateChanged-(Landroid/net/NetworkInfo;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMALTEPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/LocationClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebView;-showFindDialog-(Ljava/lang/String; Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub;-clearForcedDisplaySize-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-setContactListFilter-(Lcom/android/contacts/list/ContactListFilter; Z Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setRemoteAlias-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/SMSDispatcher$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$4300-(Lcom/android/mms/ui/ComposeMessageActivity; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/provider/Settings$Bookmarks;-add-(Landroid/content/ContentResolver; Landroid/content/Intent; Ljava/lang/String; Ljava/lang/String; C I)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoFullScreen;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-getSuggestionsWithSessionId-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; I)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTimeZone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/gallery3d/app/PhotoPage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/TetherSettings;-updateBluetoothState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/DhcpStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-onClickOtaEndButton-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/os/IVibratorService$Stub$Proxy;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/AlarmManagerService;-setWakelockWorkSource-(Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-dismiss-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/TetherSettings;-updateState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/view/RotationPolicy;-registerRotationPolicyListener-(Landroid/content/Context; Lcom/android/internal/view/RotationPolicy$RotationPolicyListener; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockService;-handleBluetoothStateOn-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/ExchangeService;-serviceRequest-(J J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/BummerView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/nsd/NsdManager;-init-()V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactSaveService;-removeMembersFromGroup-(Landroid/content/ContentResolver; [J J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/ContactSaveService$Listener;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/app/ApplicationPackageManager;-getPackageGids-(Ljava/lang/String;)[I' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/net/sip/SipAudioCall;-setSpeakerMode-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPINView;-reset-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/IAudioService$Stub$Proxy;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsFragment;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/AccountManagerService;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-startGetCallerInfo-(Landroid/content/Context; Lcom/android/internal/telephony/Connection; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/phone/PhoneUtils$CallerInfoToken;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadingState$1;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/PlaybackQueueItem;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaShowProgramFailureDialog-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-startLongPressTimer-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-startAction-(I I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/display/DisplayManagerService;-scheduleTraversalLocked-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/ContactsProvider2$PipeMonitor;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/CropView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/browser/Tab;-removeFromTree-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/tech/NfcA;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/contacts/list/AccountFilterActivity$MyLoaderCallbacks;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifyDownloadFailed-(Landroid/content/Context; J)V' : ['android.permission.READ_SMS'],
	'Landroid/content/IContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/PatternUnlockScreen$UnlockPatternListener;-onPatternCellAdded-(Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/CropView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-removeTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/EventLoader$LoadEventDaysRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/webkit/WebViewClassic$WebViewInputConnection;-sendCharacter-(C)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cat/IconLoader;-loadIcon-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/CropEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/WallpaperManager;-setStream-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-showConfigUi-(Lcom/android/settings/wifi/AccessPoint; Z)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/webkit/WebViewClassic;-loadUrl-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneGlobals$NotificationBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-setContactData-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/SettingsPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothInputDevice;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/SimPukUnlockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardScreenCallback; Lcom/android/internal/widget/LockPatternUtils;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEventInternal-(I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/SearchPanelView$1;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/AlarmKlaxon$3;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/research/ResearchLogger;-latinIME_onWindowHidden-(I I Landroid/view/inputmethod/InputConnection;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/accounts/IAccountManager$Stub;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-userActivityInternal-(J I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onPress-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SettingsObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-isForwardable-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CdmaSystemSelectListPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/noisefield/NoiseFieldWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/app/MoviePlayer;-startVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewProvider$ViewDelegate;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getSelectedGroupPosition-()I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/IConnectivityManager;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-access$600-(Lcom/android/voicedialer/VoiceDialerActivity; I)I' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/CryptKeeper;-access$600-(Lcom/android/settings/CryptKeeper;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BaseUi;-showWeb-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/WebViewController;-onDownloadStart-(Lcom/android/browser/Tab; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityStack;-updateTransitLocked-(I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wm/Session;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/settings/RadioInfo$20;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView;-onPause-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppManager;-enableBluetooth-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/event/EditEventFragment;-onActionBarItemSelected-(I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataStateChanged-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/suggestions/MoreSuggestionsView$1;-onCustomRequest-(I)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-setRestrictBackground-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView$9;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-getDrmMimeMenuStringRsrc-(J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/provider/BrowserProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/RadioInfo;-access$4300-(Lcom/android/settings/RadioInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-documentAsText-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-addAudio-(Landroid/net/Uri;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/browser/BrowserWebView;-loadData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-addNotificationViews-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)Lcom/android/systemui/statusbar/StatusBarIconView;' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateFromProvider-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;-performAppWidgetSizeCallbacksIfNecessary-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/ConnectivityManager;-isActiveNetworkMetered-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserBackupAgent;-addBookmark-(Lcom/android/browser/BrowserBackupAgent$Bookmark;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onCancelled-(Ljava/lang/Void;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiEnabler;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth;-getRemoteAlias-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IActivityManager;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BreadCrumbView;-pop-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/data/FilterSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/IsoDep;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/soundrecorder/SoundRecorder;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/app/IAlarmManager$Stub$Proxy;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardScreenCallback;-goToUnlockScreen-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/MtpDevice;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-updateUri-()Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-animateCollapsePanels-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; Ljava/util/Collection; I)V' : ['android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadThread;-openResponseEntity-(Lcom/android/providers/downloads/DownloadThread$State; Lorg/apache/http/HttpResponse;)Ljava/io/InputStream;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClassic;-cutSelection-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LocationManagerService$Receiver;-<init>-(Lcom/android/server/LocationManagerService; Landroid/location/ILocationListener; Landroid/app/PendingIntent; I I Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-dispatchHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/InputMethodManagerService;-systemReady-(Lcom/android/server/StatusBarManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/quickcontact/QuickContactActivity;-bindData-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordFragment;-updateSpinner-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/google/common/io/CharStreams$4;-getInput-()Ljava/io/Reader;' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPageImmediately-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$200-(Lcom/android/bluetooth/pbap/BluetoothPbapService;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.DISABLE_KEYGUARD', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/AlbumSetSlidingWindow;-getLoadingTexture-()Lcom/android/gallery3d/ui/BitmapTexture;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/contacts/list/ContactBrowseListFragment$ContactLookupTask;-onPostExecute-(Landroid/net/Uri;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/camera/CameraActivity;-openModule-(Lcom/android/camera/CameraModule; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/gallery3d/app/GalleryActionBar$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-<init>-(Landroid/content/Context; Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame$Callbacks; Lcom/android/internal/policy/impl/keyguard/KeyguardActivityLauncher; Lcom/android/internal/policy/impl/keyguard/KeyguardActivityLauncher$CameraWidgetInfo; Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Tab$3;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/nfc/tech/BasicTagTechnology;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/server/WifiService;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebView;-findNext-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-addAppLocked-(Landroid/content/pm/ApplicationInfo; Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothTetheringDataTracker;-teardown-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DisplaySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService$8;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession;-start-(Landroid/os/Handler;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/editor/SelectAccountDialogFragment;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/vcard/VCardEntry$EntryElement;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/BluetoothAdapter;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPairingConfirmation-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiManager;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-getName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-reloadDataAndSetSelectedUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPINView;-onWindowFocusChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/NotificationPlayer$CreationAndCompletionThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/wifi/SupplicantStateTracker$ScanState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/imageproc/FlipFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/MusicPicker;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ClassZeroActivity;-access$200-(Lcom/android/mms/ui/ClassZeroActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/wallpaper/galaxy/GalaxyRS;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView$AccountAnalyzer;-next-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-proceedAndFinish-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DataUsageSummary;-access$100-(Lcom/android/settings/DataUsageSummary;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-doJoinSuggestedContact-([J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/FaceUnlock;-handleUnlock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getContactMethodUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-findMediaItem-(Lcom/android/gallery3d/data/MediaSet; I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/ContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/EdgeView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/nfc/INfcAdapterExtras;-close-(Ljava/lang/String; Landroid/os/IBinder;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Landroid/media/effect/effects/SepiaEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-determineScrollingStart-(Landroid/view/MotionEvent; F)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/handover/HandoverService;-disableBluetoothIfNeeded-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-loadFromUri-(Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setHdmiPlugged-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$PhoneNumberLoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FilterFunction;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingInsecureRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogEnabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-execute-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/hdp/HealthService;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity$ImportTask;-doInBackground-([Lcom/android/contacts/vcard/VCardService;)Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-refreshStats-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/BluetoothSocket;-initSocketNative-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserSettings;-initialize-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/Controller;-switchToTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME$BatchInputUpdater;-updateBatchInput-(Lcom/android/inputmethod/latin/InputPointers; Lcom/android/inputmethod/latin/LatinIME;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/nfc/handover/BluetoothHeadsetHandover;-onServiceConnected-(I Landroid/bluetooth/BluetoothProfile;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/IActivityManager;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/calendar/alerts/AlertReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-requestTraversalLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/ConnectivityManager;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/ConnectivityService;-handleCaptivePortalTrackerCheck-(Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertStatusUpdate-(Landroid/content/ContentValues;)J' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/TransactionService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/net/CaptivePortalTracker;-access$1800-(Landroid/net/CaptivePortalTracker; Ljava/net/InetAddress;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onRemovePictureChosen-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-getViewAt-(I)Landroid/widget/RemoteViews;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Landroid/net/wifi/SupplicantStateTracker$UninitializedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/GroupMemberLoader;-constructLoaderForGroupEditorQuery-(Landroid/content/Context; J)Lcom/android/contacts/GroupMemberLoader;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/EventInfoFragment;-updateResponse-(J J I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-sendDownUpKeyEvents-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setScanMode-(I I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingCalendars-(Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/PhotoPage;-transitionFromAlbumPageIfNeeded-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$10;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebView;-findAllAsync-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onSetPolicyDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-finishBooting-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-access$000-(Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/ChartDataUsageView$DataUsageChartListener;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset;-disconnectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/editor/RawContactReadOnlyEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/location/ILocationProvider;-disable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/WindowManagerService;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-keyguardDone-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/LocationManagerService;-switchUser-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/Session;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCreate-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView$2;-onPressKey-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/vcard/ProcessorBase;-run-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/sip/SipAudioCall;-endCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$NfcAdapterExtrasService;-setCardEmulationRoute-(Ljava/lang/String; I)V' : ['android.permission.NFC'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-onKey-(I [I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasOutboxService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Bookmarks$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/TintFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-setAndPersistDeviceName-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothPan$Stub$Proxy;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/editor/BaseRawContactEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/location/LocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserYesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/app/AlbumPage;-access$1200-(Lcom/android/gallery3d/app/AlbumPage; I)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/GeolocationService;-start-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AudioService;-dispatchMediaKeyEventForCalls-(Landroid/view/KeyEvent; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/WorkingMessage;-send-(Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDeviceIdentity-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/preferences/WebViewPreview;-onBindView-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClientClassicExt;-doUpdateVisitedHistory-(Landroid/webkit/WebView; Ljava/lang/String; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/PhoneUi;-showNavScreen-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$StartStopButtonListener;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-determineScrollingStart-(Landroid/view/MotionEvent; F)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-handleSandman-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/AddAccountSettings;-addAccount-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-onDataSetChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-loadDictionary-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestionsExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Utils;-getTetheringLabel-(Landroid/net/ConnectivityManager;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccCard;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/MtpImage;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onPictureCenter-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/PostalAddressPickerFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/WifiService;-access$1100-(Lcom/android/server/WifiService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$Download;-saveDataUri-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setSafeMode-(Z)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/FindActionModeCallback;-findNext-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/Tab$2;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DriverUnloadedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/SelectionManager;-getSelected-(Z)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/tech/MifareUltralight;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/AccountFilterActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/accounts/AccountManagerService;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/providers/contacts/VoicemailCleanupService;-onHandleIntent-(Landroid/content/Intent;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserStop-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/nfc/tech/Ndef;-getNdefMessage-()Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Landroid/inputmethodservice/KeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/webkit/WebView;-findAll-(Ljava/lang/String;)I' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onPageBeginMoving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DevelopmentSettings$ConfirmEnforceFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager; Lcom/android/server/ConnectivityService$NetworkFactory;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/btservice/BondStateMachine;-access$1500-(Lcom/android/bluetooth/btservice/BondStateMachine; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasOutboxService;-tryProvision-(Lcom/android/exchange/EasSyncService;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onUserSwitched-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/TetherSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PhotoPage;-onAlbumModeSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/CameraSwitcher;-onCameraSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/AsyncRunner;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/content/ContentService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/DevelopmentSettings;-resetDangerousOptions-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_EXTERNAL_STORAGE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/list/AccountFilterActivity;-loadAccountFilters-(Landroid/content/Context;)Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.GET_ACCOUNTS'],
	'Landroid/provider/Telephony$Threads;-getOrCreateThreadId-(Landroid/content/Context; Ljava/util/Set;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2900-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeDefaultPhones-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/IConnectivityManager$Stub;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ThrottleService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/FrameFetch;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager$Stub;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToPage-(I I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DisplaySettings;-writeFontSizePreference-(Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/AccountFilterActivity$FilterLoader;-loadInBackground-()Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine$Disconnected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager$Stub;-confirmCredentialsAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/AdnRecordCache;-updateAdnByIndex-(I Lcom/android/internal/telephony/AdnRecord; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-createContact-(Lcom/android/contacts/model/account/AccountWithDataSet;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-rebuildStructuredName-(Lcom/android/contacts/model/RawContactDelta$ValuesDelta;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/ISms$Stub;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-startActivityDismissingKeyguard-(Landroid/content/Intent; Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$1;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/wifi/p2p/WifiP2pService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/media/MediaProvider;-getThumb-(Lcom/android/providers/media/MediaProvider$DatabaseHelper; Landroid/database/sqlite/SQLiteDatabase; Ljava/lang/String; J Landroid/net/Uri;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.READ_EXTERNAL_STORAGE', 'android.permission.WRITE_EXTERNAL_STORAGE'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-()Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-animateCollapsePanels-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/event/EditEventFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/TabControl;-createNewWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Landroid/telephony/TelephonyManager;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/WebViewClassic;-access$7100-(Landroid/webkit/WebViewClassic;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothServerSocket;-<init>-(I Z Z I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/Invert;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothEnabler;-<init>-(Landroid/content/Context; Landroid/widget/Switch;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/SlidingTab;-dispatchTriggerEvent-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/NullFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/location/GpsLocationProvider;-access$1100-(Lcom/android/server/location/GpsLocationProvider; I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PieController;-onSettingChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/view/VolumePanel;-onShowVolumeChanged-(I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-makeWifiWatchdogStateMachine-(Landroid/content/Context;)Landroid/net/wifi/WifiWatchdogStateMachine;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/power/Notifier;-onWakeUpStarted-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-setKeyboardMode-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$16;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/google/common/io/Files;-copy-(Lcom/google/common/io/InputSupplier; Ljava/io/File; Ljava/nio/charset/Charset;)V' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-generateBinaryDictionary-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Disconnected;-processConnectionEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/graphics/Bitmap; I I Lcom/android/launcher2/DragSource; Ljava/lang/Object; I Landroid/graphics/Point; Landroid/graphics/Rect; F)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/SearchActivity;-handleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/app/IBackupAgent$Stub;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/ImportVCardActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/launcher2/InfoDropTarget;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-doQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/providers/contacts/ContactsProvider2;-queryLocal-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String; J Landroid/os/CancellationSignal;)Landroid/database/Cursor;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/widget/RotarySelector;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator$1;-onPhoneStateChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/MessagingNotification;-getDownloadFailedMessageCount-(Landroid/content/Context;)I' : ['android.permission.READ_SMS'],
	'Lcom/android/server/LocationManagerService$3;-onSomePackagesChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateCurrentCarrierInProvider-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/LocationManagerService;-getReceiver-(Landroid/location/ILocationListener; I I Ljava/lang/String;)Lcom/android/server/LocationManagerService$Receiver;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CallNotifier;-showIncomingCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/dreams/phototable/LocalSource;-fillQueue-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothInputDevice;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$400-(Lcom/android/mms/ui/ComposeMessageActivity;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/systemui/recent/RecentsPanelView;-dismissAndGoBack-()V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Landroid/widget/ZoomButtonsController$Container;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/util/AccountPromptUtils;-launchAccountPrompt-(Landroid/app/Activity;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothHeadsetPhone$Stub;-processChld-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/location/provider/LocationProviderBase;-onDisable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/widget/PinnedHeaderListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneUtils;-separateCall-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/ThrottleService$DataRecorder;-addData-(J J)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/ConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/hfp/HeadsetService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Ljava/lang/Appendable;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-pageBeginMoving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-goBackOrForwardImpl-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewManager;-show-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onCreate-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Ljava/util/Map; Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/MasterClear;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-initDevicePreference-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/SelectActionModeCallback;-onActionItemClicked-(Landroid/view/ActionMode; Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$800-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/development/Connectivity;-access$2100-(Lcom/android/development/Connectivity;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/dreams/phototable/PhotoSource;-findImages-(I)Ljava/util/Collection;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/Conversation$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-openMoreKeysKeyboardIfRequired-(Lcom/android/inputmethod/keyboard/Key; Lcom/android/inputmethod/keyboard/PointerTracker;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/alerts/AlertService;-postNotification-(Lcom/android/calendar/alerts/AlertService$NotificationInfo; Ljava/lang/String; Landroid/content/Context; Z Lcom/android/calendar/alerts/AlertService$NotificationPrefs; Lcom/android/calendar/alerts/NotificationMgr; I)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z)J' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/RIL;-processUnsolicited-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-enable-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performHapticFeedbackLw-(Landroid/view/WindowManagerPolicy$WindowState; I Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/wm/WindowManagerService;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/CameraActivity;-reuseCameraScreenNail-(Z)Lcom/android/gallery3d/ui/ScreenNail;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView$2;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ContactSaveService$2;-run-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$BrightnessObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onPause-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onScreenTurnedOff-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onFinishAction-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/exchange/adapter/Parser;-parse-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/ZoomManager;-onFirstLayout-(Landroid/webkit/WebViewCore$DrawData;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/usb/UsbDebuggingActivity;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-beginScrollEdit-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-delete-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-access$000-(Lcom/android/providers/settings/SettingsBackupAgent; Z)I' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/google/common/io/MultiReader;-advance-()V' : ['android.permission.INTERNET'],
	'Landroid/view/IWindowSession;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/webkit/WebView;-clearMatches-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-startRepeatKey-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/NonPhoneActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$6;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/CalendarController$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/WifiManager;-startScan-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isBusy-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performAuditoryFeedbackForAccessibilityIfNeed-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset;-startVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/data/Conversation$2;-run-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/app/ResolverActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Landroid/webkit/ZoomManager;-zoomOut-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/util/PduLoaderManager;-getPdu-(Landroid/net/Uri; Z Lcom/android/mms/util/ItemLoadedCallback;)Lcom/android/mms/util/ItemLoadedFuture;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleStatusReport-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-executeAndWait-(Ljava/util/concurrent/Callable;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-drawTopPanel-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Controller;-resumeWebViewTimers-(Lcom/android/browser/Tab;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame$7;-onClockVisibilityChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/EventInfoFragment;-access$1900-(Lcom/android/calendar/EventInfoFragment; Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/view/IInputMethodCallback$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasAccountService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/latin/LatinIME;-onEndBatchInput-(Lcom/android/inputmethod/latin/InputPointers;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/app/ActivityManagerNative;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/PhoneUtils;-restoreMuteState-()Ljava/lang/Boolean;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/GroupMembershipDataItem;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/location/LocationBlacklist;-init-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setName-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/preference/VolumePreference;-onSampleStarting-(Landroid/preference/VolumePreference$SeekBarVolumizer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarProvider2;-doUpdateTimezoneDependentFields-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-onMuteClick-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/wifi/WifiApEnabler;-<init>-(Landroid/content/Context; Landroid/preference/CheckBoxPreference;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-getPhotoPickSize-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/AccessibilitySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-clearSslPreferences-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-showPhonebookDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AlbumPage$4;-onLongTap-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onPageSwitching-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/VibratorService;-onInputDeviceChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-animateChallengeTo-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onPollPdp-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-getConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneGlobals;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/SecureAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onGenericMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/ClusterSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Browser;-getVisitedLike-(Landroid/content/ContentResolver; Ljava/lang/String;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/base/RetargetFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SubSettings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/sip/ISipService$Stub;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdatesLocked-(Landroid/location/LocationRequest; Lcom/android/server/LocationManagerService$Receiver; I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetoothHeadset;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/SelectionManager$SelectionListener;-onSelectionModeChange-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/musicfx/ControlPanelEffect;-initEffectsPreferences-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PanoramaModule$8;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/SuggestedMemberListAdapter$SuggestedMemberFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dispose-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PeopleActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/SelectionManager;-enterSelectionMode-()V' : ['android.permission.VIBRATE'],
	'Landroid/test/mock/MockContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/SmsUsageMonitor;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-requestRouteToHostAddress-(I [B)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadReceiver$1;-run-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$3;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Exception;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-onPrepareOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/AlbumSetDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/power/PowerManagerService;-updateWakeLockWorkSource-(Landroid/os/IBinder; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiService;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment$ContactLookupTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onClose-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/FdnSetting;-updatePINChangeState-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/BondStateMachine$StableState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService;-connectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/model/dataitem/DataItem;-buildDataString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/UsageStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEvent-(I I J Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/month/MonthByWeekAdapter$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-setUsbTethering-(Z)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/TransactionService;-update-(Lcom/android/mms/transaction/Observable;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/webkit/WebView;-removeJavascriptInterface-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/ConnectivityManager;-setGlobalProxy-(Landroid/net/ProxyProperties;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebViewClassic;-saveWebArchiveImpl-(Ljava/lang/String; Z Landroid/webkit/ValueCallback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/location/ComprehensiveCountryDetector$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebViewProvider;-freeMemory-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndHolding-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/telephony/SmsManager;-disableCellBroadcastRange-(I I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-playVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createView-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/RotarySelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/server/wm/DragState;-endDragLw-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/PhoneGlobals;-setBeginningCall-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/Connection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/text/StringLogger;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/sip/SipAudioCall;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/common/contacts/DataUsageStatUpdater;-updateWithRfc822Address-(Ljava/util/Collection;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-handleTimeout-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardStatusViewManager;-<init>-(Landroid/view/View; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardScreenCallback; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/location/ILocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pDiscoveryChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/NavigationBarPhone;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-handleNest-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$4300-(Lcom/android/mms/ui/ComposeMessageActivity; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothManager;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getReportItems-()Ljava/util/List;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothHealth$Stub$Proxy;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CdmaSystemSelectListPreference$MyHandler;-handleQueryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ims/IsimUiccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getBondState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/WebViewController;-doUpdateVisitedHistory-(Lcom/android/browser/Tab; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Connected;-processSlcConnected-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Contacts$People;-tryGetMyContactsGroupId-(Landroid/content/ContentResolver;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onShowMoreKeysPanel-(I I Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewInputDispatcher;-enqueueEventLocked-(Landroid/webkit/WebViewInputDispatcher$DispatchEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/WindowManagerPolicy;-finishPostLayoutPolicyLw-()I' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/DhcpStateMachine$RunningState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/cdma/CdmaCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/TrimVideo;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker$InactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_CONTACTS'],
	'Landroid/nfc/tech/MifareClassic;-authenticate-(I [B Z)Z' : ['android.permission.NFC'],
	'Lcom/android/settings/WallpaperTypeSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-initLoader-(Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/opp/TestTcpSessionNotifier;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/model/dataitem/EmailDataItem;-buildDataStringForDisplay-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ConfirmDialogListener;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserSettings;-setAutoFillProfile-(Landroid/webkit/WebSettingsClassic$AutoFillProfile; Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService;-access$6300-(Landroid/media/AudioService;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/provider/ContactsContract$RawContacts$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/SmsStorageMonitor$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-buildUpdate-(Landroid/content/Context;)Landroid/widget/RemoteViews;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/Context;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/InCallScreen;-onPause-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-configureQuickFix-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-setProcessLimit-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/MediaPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/DownloadTouchIcon;-doInBackground-([Ljava/lang/String;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/inputmethodservice/IInputMethodSessionWrapper$InputMethodEventCallbackWrapper;-finishedEvent-(I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView$2;-userActivity-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/phone/SimContacts;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/accounts/SyncSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-refreshSelectedContactUri-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WiredAccessoryManager;-<init>-(Landroid/content/Context; Lcom/android/server/input/InputManagerService;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/vpn2/VpnSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/FilterSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/ExchangeService$ConnectivityReceiver$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToRuim-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-enqueue-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService$WindowManagerFuncs;-requestTraversal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/StructuredPostalDataItem;-hasKindTypeColumn-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/DayView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/net/NetworkStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClassic;-showFindDialog-(Ljava/lang/String; Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/WallpaperManager;-clear-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/PhotoView$FullPicture;-drawTileView-(Lcom/android/gallery3d/ui/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccCardProxy;-updateIccAvailability-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-addCallAndContactMenuItems-(Landroid/view/ContextMenu; Lcom/android/mms/ui/ComposeMessageActivity$MsgListMenuClickListener; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserSwitch-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/model/dataitem/IdentityDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/downloads/DownloadReceiver;-access$000-(Lcom/android/providers/downloads/DownloadReceiver; Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/nfc/NfcService;-doOpenSecureElementConnection-()I' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/ZoomManager;-zoomToReadingLevel-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/input/InputManagerService;-registerShowTouchesSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/LocationSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/gsm/GsmCallTracker; Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavigationBarTablet;-stopOrRefresh-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/ConnectivityManager;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/WifiStateMachine;-access$2600-(Landroid/net/wifi/WifiStateMachine; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RingerVolumePreference;-onBindDialogView-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/preferences/WebViewPreview;-onCreateView-(Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/AddBookmarkPage$SaveBookmarkRunnable;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/transaction/NotificationTransaction;-<init>-(Landroid/content/Context; I Lcom/android/mms/transaction/TransactionSettings; Lcom/google/android/mms/pdu/NotificationInd;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/webkit/WebViewProvider;-resumeTimers-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BatteryService;-<init>-(Landroid/content/Context; Lcom/android/server/LightsService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Tab;-postCapture-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-endReordering-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/TrafficStats;-stopDataProfiling-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifyFailed-(Landroid/content/Context; Z J Z)V' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneProxy;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-access$000-(Lcom/android/contacts/activities/AttachPhotoActivity; Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/IAudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/model/ContactLoader;-loadInvitableAccountTypes-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-switchToState-(I F F)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/CropView$FaceHighlightView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-updateInCallTouchUi-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/pm/PackageManagerService;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;-maybeStartBiometricUnlock-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/SettingsView;-onClick-(Landroid/view/View;)V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/webkit/WebViewProvider;-goForward-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/view/IWindowSession$Stub;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/webkit/WebViewClassic;-setFocusControllerActive-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/ContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/telephony/SmsManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CsimFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-enableKeyguard-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/PowerManagerService;-updateUserActivitySummaryLocked-(J I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/NotificationPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/research/ResearchLogger;-sendFeedback-(Ljava/lang/String; Z)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handleCallWaitingInfo-(Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/INfcAdapterExtras$Stub;-authenticate-(Ljava/lang/String; [B)V' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/app/AlbumDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/DeviceStorageMonitorService;-access$000-(Lcom/android/server/DeviceStorageMonitorService; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CLEAR_APP_CACHE'],
	'Landroid/app/ContextImpl;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-notifySignalStrength-()Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/StateManager;-itemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/commands/bmgr/Bmgr;-doList-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/vpn2/VpnSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-createContact-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/SlideshowDataAdapter$SlideshowSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/DisplayPowerState$PhotonicModulator$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/content/ContentService;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Ljava/net/HttpURLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/data/WorkingMessage$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/wifi/p2p/WifiP2pSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/EasOutboxService;-acknowledgeRemoteWipe-(Lcom/android/exchange/EasSyncService; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/text/ToUpperCase;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/ContactListFilterController;-selectCustomFilter-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/ApplicationSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getBondedDevices-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/BackupManagerService;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/wifi/WifiAPITest;-onPreferenceClick-(Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/calllog/CallLogFragment;-updateOnTransition-(Z)V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/IConnectivityManager$Stub;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ActivityManagerNative;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Landroid/webkit/GeolocationService;-unregisterFromLocationUpdates-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/sip/ISipService$Stub;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/server/sip/SipService$IntervalMeasurementProcess;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/RenderScriptWallpaper$RenderScriptEngine;-onSurfaceDestroyed-(Landroid/view/SurfaceHolder;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/users/UserSettings;-access$700-(Lcom/android/settings/users/UserSettings; Landroid/content/pm/UserInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$10;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/WindowManagerService;-isKeyguardSecure-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/deviceinfo/Status;-setWifiStatus-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-initPreferences-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/PhoneGlobals;-updateInCallScreen-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/latin/LatinIME;-resetContactsDictionary-(Lcom/android/inputmethod/latin/ContactsBinaryDictionary;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/view/ViewRootImpl;-updateJoystickDirection-(Landroid/view/MotionEvent; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-setData-(Landroid/net/Uri; Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothAdapter;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleModeChange-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-checkMailboxes-()J' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/browser/UrlHandler$RLZTask;-onPostExecute-(Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-access$200-(Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/model/dataitem/SipAddressDataItem;-buildDataString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getEnabledProviders-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/location/ILocationManager;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-startAction-(I I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener; Z Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-sendUssd-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/webkit/GeolocationService;-registerForLocationUpdates-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-checkAndAddSourcePackageIntoValues-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/AccountUnlockScreen$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/phone/InCallScreen;-access$1100-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/accounts/AccountManager$2;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasAccountService;-postAutodiscover-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-checkSelection-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$4600-(Lcom/android/mms/ui/ComposeMessageActivity; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/sip/SipSessionGroup;-processIOException-(Ljavax/sip/IOExceptionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/recent/RecentsPanelView;-handleOnClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub$Proxy;-startFreezingScreen-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-turnOffUpstreamMobileConnection-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub;-setGlobalProxy-(Landroid/net/ProxyProperties;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ContactEntryListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5500-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/activities/NonPhoneActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/content/SyncManager;-cancelActiveSync-(Landroid/accounts/Account; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-enableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/common/contacts/BaseEmailAddressAdapter$DirectoryPartitionFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/net/UidDetailProvider;-buildUidDetail-(I)Lcom/android/settings/net/UidDetail;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-retrieveSettings-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-setState-(I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/TileImageView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestionProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-checkSelection-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-trySetupData-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/ActivityState;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackFragment;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$ScreenNailJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onResume-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothManager;-unregisterStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/ActivityController;-onLowMemory-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/text/StringLogger;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/base/InputStreamSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/OutgoingCallBroadcaster$OutgoingCallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-waitForKeyguard-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onBackPressed-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/FaceClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/PhoneUtils;-turnOnSpeaker-(Landroid/content/Context; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateUsbState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebSettingsClassic;-setDefaultZoom-(Landroid/webkit/WebSettings$ZoomDensity;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateNextButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportRequests-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Landroid/content/IContentService$Stub$Proxy;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager$10;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/exchange/ExchangeService$2;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService;-isMailboxSyncable-(Lcom/android/emailcommon/provider/Account; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/calllog/CallLogListItemHelper;-getCallActionDescription-(Lcom/android/contacts/PhoneCallDetails;)Ljava/lang/CharSequence;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/WebViewClassic;-recordNewContentSize-(I I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter$DayAdapterInfo;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/contacts/GlobalSearchSupport;-addSearchSuggestionsBasedOnFilter-(Landroid/database/MatrixCursor; Landroid/database/sqlite/SQLiteDatabase; [Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/OtaUtils;-otaShowActivateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/PhoneGlobals;-updateBluetoothIndication-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/MmsMessageSender;-sendReadRec-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/picasasource/PicasaSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/data/WorkingMessage;-access$300-(Lcom/android/mms/data/WorkingMessage; Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onBootCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getGroupUriFromId-(J)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/model/RawContactModifier;-migrateStructuredName-(Landroid/content/Context; Lcom/android/contacts/model/RawContactDelta; Lcom/android/contacts/model/RawContactDelta; Lcom/android/contacts/model/dataitem/DataKind;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/ConnectivityService;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/sip/SipEditor;-access$500-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/util/NameConverter;-displayNameToStructuredName-(Landroid/content/Context; Ljava/lang/String;)Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitorCallback;-onBootCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pStateChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallHelper;-onServiceStateChanged-(Landroid/os/Message;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/net/NetworkStatsService;-access$700-(Lcom/android/server/net/NetworkStatsService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-endInCallScreenSession-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$OnChallengeScrolledListener;-onScrollStateChanged-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/datepicker/DatePickerDialog$OnDateSetListener;-onDateSet-(Lcom/android/contacts/datepicker/DatePicker; I I I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/FlipEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier;-updateNotification-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/power/DisplayPowerController$4;-run-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Tab$2;-onUnhandledKeyEvent-(Landroid/webkit/WebView; Landroid/view/KeyEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/Phone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/SyncManager;-scheduleLocalSync-(Landroid/accounts/Account; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/sip/SipSettings$2$1;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/ui/PhotoView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/CountryDetectorService$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/MessagingNotification;-access$300-(Landroid/content/Context; [J)I' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/quicksearchbox/util/HttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/DayView;-access$5100-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-invokeExitMethods-(Lcom/android/internal/util/StateMachine$SmHandler$StateInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/text/ToUpperCase;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/SipAddressDataItem;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-requestChildFocus-(Landroid/view/View; Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/Utils$UsabilityStudyLogUtils$2;-run-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE'],
	'Lcom/android/server/CertBlacklister;-registerObservers-(Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/UserDictionary$Words;-addWord-(Landroid/content/Context; Ljava/lang/String; I Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/WebViewProvider;-addJavascriptInterface-(Ljava/lang/Object; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-removeAccount-(Landroid/accounts/Account; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/TransactionService;-renewMmsConnectivity-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/SlideshowPresenter$5;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/telephony/TelephonyManager;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-selectDefaultContact-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-startLongPressTimer-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/WebViewProvider;-documentHasImages-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/ShutdownThread;-access$000-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/ui/RecipientsAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-setGrabbedState-(I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/emailcommon/service/EmailServiceProxy$12;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/ComposeMessageActivity$24;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/Controller;-onProgressChanged-(Lcom/android/browser/Tab;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary$10;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/PanProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ISms;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/browser/Tab$2;-onReceivedLoginRequest-(Landroid/webkit/WebView; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/effect/effects/BlackWhiteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Connected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-disableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/ZoomManager;-setZoomScale-(F Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$1100-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/sip/SipEditor$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/TimerRingService;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadThread;-executeDownload-(Lcom/android/providers/downloads/DownloadThread$State; Landroid/net/http/AndroidHttpClient; Lorg/apache/http/client/methods/HttpGet;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothPan;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/IMediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$OngoingGroupRemovalState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityStack;-scheduleIdleLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/webkit/WebViewCore$EventHub;-sendMessage-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/PreparePageFadeoutTexture;-onGLIdle-(Lcom/android/gallery3d/ui/GLCanvas; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage;-pickPhoto-(I Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/util/DownloadManager$4;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView;-onChildDismissed-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vpndialogs/ManageDialog;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$InitialState;-chooseUpstreamType-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$HeaderAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendCallLogVcards-(I Ljavax/obex/Operation; I I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/app/CommonControllerOverlay;-onScrubbingEnd-(I I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-startScanActive-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/pm/IPackageManager$Stub;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/camera/PhotoModule;-onSharedPreferenceChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/deviceinfo/Status;-onResume-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByType-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-setFormattedDigits-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/os/IPowerManager$Stub;-acquireWakeLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/BrowserContract$Bookmarks;-buildFolderUri-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/BroadcastQueue;-deliverToRegisteredReceiverLocked-(Lcom/android/server/am/BroadcastRecord; Lcom/android/server/am/BroadcastFilter; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/ui/PhotoView$Picture;-draw-(Lcom/android/gallery3d/ui/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onStart-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/AudioPreview;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService;-sendMessageRequest-(Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/StructuredNameDataItem;-buildDataStringForDisplay-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ActivityManager;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/content/ISyncContext$Stub$Proxy;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Landroid/net/sip/ISipService$Stub;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/wm/WindowManagerService;-handleAppTransitionReadyLocked-(Lcom/android/server/wm/WindowList;)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewInputDispatcher$WebKitCallbacks;-dispatchWebKitEvent-(Landroid/webkit/WebViewInputDispatcher; Landroid/view/MotionEvent; I I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$WifiDisplaySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-initApnContextsAndDataConnection-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/EmergencyCallHelper;-scheduleRetryOrBailOut-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/model/dataitem/DataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/PhotoPage;-access$1500-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/ContentService;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-startObexSession-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/NumPadKey;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onActionBarAllowed-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/downloads/DownloadThread;-handleEndOfStream-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClassic;-centerFitRect-(Landroid/graphics/Rect;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Exception;' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManagerService;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/googlecode/mp4parser/authoring/container/mp4/MovieCreator;-build-(Ljava/nio/channels/ReadableByteChannel;)Lcom/googlecode/mp4parser/authoring/Movie;' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/internal/SuddenJumpingTouchEventHandler;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/exchange/ExchangeService;-access$900-(Lcom/android/exchange/ExchangeService; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity$TestPinnedHeaderListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-access$100-(Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-requestSync-(Lcom/android/emailcommon/provider/Mailbox; I Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/view/BasePieView;-layout-(I I Z F I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-drawTopPanel-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-onFadeStart-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LocationManagerService;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/IccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/camera/PhotoController$2;-onClick-(Lcom/android/camera/ui/PieItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/dreams/phototable/PhotoCarousel$PhotoLoadTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerSession;-onGetSuggestionsMultiple-([Landroid/view/textservice/TextInfo; I Z)[Landroid/view/textservice/SuggestionsInfo;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageItem;-interpretFrom-(Lcom/google/android/mms/pdu/EncodedStringValue; Landroid/net/Uri;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/Suggest;-getSuggestedWordsForBatchInput-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; I)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/preferences/FontSizePreview;-setupWebView-(Landroid/webkit/WebView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/btservice/JniCallbacks;-pinRequestCallback-([B [B I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IActivityManager;-killBackgroundProcesses-(Ljava/lang/String; I)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/browser/TabControl;-restoreState-(Landroid/os/Bundle; J Z Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-loadDictionary-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/model/dataitem/WebsiteDataItem;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-access$400-(Lcom/android/bluetooth/opp/BluetoothOppTransfer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/KeyboardLayoutPickerFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/power/PowerManagerService;-userActivityFromNative-(J I I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-buildQueryUri-(I I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Ljava/net/URLConnection;-getInputStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/CallDetailActivity;-getPhoneCallDetailsForUri-(Landroid/net/Uri;)Lcom/android/contacts/PhoneCallDetails;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/LocationManagerService$Receiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-switchState-(Lcom/android/gallery3d/app/ActivityState; Ljava/lang/Class; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/bluetooth/btservice/ProfileService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-clearShortcut-(C)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$InactiveState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/agenda/AgendaListView;-goTo-(Landroid/text/format/Time; J Ljava/lang/String; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/musicvis/RenderScriptWallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/contacts/model/dataitem/DataItem;-buildDataStringForDisplay-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getWifiServiceMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/content/ContextWrapper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/TelephonyManager;-listen-(Landroid/telephony/PhoneStateListener; I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarViewAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Landroid/media/AsyncPlayer;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/IConnectivityManager$Stub;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/MediaSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$7;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/ContactSaveService;-updateGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/nfc/tech/NdefFormatable;-format-(Landroid/nfc/NdefMessage;)V' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/ManageSimMessages;-init-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-rebootSafeMode-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$1;-onDeleteGroup-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/data/LocationClustering;-generateName-(Ljava/util/ArrayList; Lcom/android/gallery3d/util/ReverseGeocoder;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/TetherSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/AccessibilityInjector;-toggleAndroidVox-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/IVibratorService$Stub;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker$ApnChangeObserver;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/net/ConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-showConnectionDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/AppsCorpus;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/CorpusResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/INfcAdapter$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/DataConnection$DcInactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/NfcV;-reconnect-()V' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetooth$Stub;-fetchRemoteUuids-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/data/WorkingMessage;-discard-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/dataitem/WebsiteDataItem;-hasKindTypeColumn-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/util/DraftCache;-rebuildCache-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/camera/SecureCameraActivity;-openModule-(Lcom/android/camera/CameraModule; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/gallery3d/app/PhotoPage;-setCurrentPhotoByIntent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-isNdef-(I)Z' : ['android.permission.NFC'],
	'Lcom/android/phone/PhoneUtils;-setMuteInternal-(Lcom/android/internal/telephony/Phone; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRadioAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/am/Am$IntentReceiver;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfile;-getConnectionStatus-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-showMEIDPanel-(Landroid/content/Context; Z Landroid/telephony/TelephonyManager;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/location/ILocationManager$Stub;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/nfc/P2pLinkManager;-prepareMessageToSend-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/server/am/BatteryStatsService;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/location/GpsLocationProvider$4;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/TelephonyManager;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-enableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-doVisibilityChanged-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/net/IThrottleManager;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Contacts$People;-addToMyContactsGroup-(Landroid/content/ContentResolver; J)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/DockObserver;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/launcher2/Workspace;-setup-(Lcom/android/launcher2/DragController;)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/server/InputMethodManagerService;-setCurrentInputMethodSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/location/ILocationProvider$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityCallback;-showBackupSecurity-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/ZoomManager;-onNewPicture-(Landroid/webkit/WebViewCore$DrawData;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-access$300-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCallForward-(I I I Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-killApplication-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard/ObscureSpeechDelegate;-onInitializeAccessibilityNodeInfo-(Landroid/view/View; Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/CaptivePortalTracker$DelayedCaptiveCheckState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel;-onUserSwitched-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowSession$Stub;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/wallpaper/RenderScriptWallpaper$RenderScriptEngine;-onSurfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PickerActivity;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/browser/BrowserActivity;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplaySizeLocked-(Lcom/android/server/wm/DisplayContent; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen$14;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$000-(Lcom/android/bluetooth/opp/BluetoothOppService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPinView;-onWindowFocusChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/EmergencyCallHelper;-onDisconnect-(Landroid/os/Message;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$14;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/AddBookmarkPage;-setupTopCrumb-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthTokenLabel-(Ljava/lang/String; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-enforcePreference-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-refreshWifiInfo-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DockService;-access$200-(Lcom/android/settings/bluetooth/DockService; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-setBluetoothStateOn-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/SupplicantStateTracker$HandshakeState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/Dictionary;-getSuggestions-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo;)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onWindowFocusChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/util/IState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/MifareUltralight;-writePage-(I [B)V' : ['android.permission.NFC'],
	'Lcom/android/server/ConnectivityService;-handleConnect-(Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter$EasEmailSyncParser;-parse-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/LatinIME;-restartSuggestionsOnWordBeforeCursor-(Ljava/lang/CharSequence;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/app/ActivityManagerNative;-getRecentTasks-(I I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-resetMessage-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$9;-onAnimationStart-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoViewProxy$VideoPlayer;-pauseAndDispatch-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/GrainEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/IConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/webkit/WebView;-loadData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForSettingsChanges-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportItems-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-asyncReloadDictionaryIfRequired-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/CertBlacklister;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onSurfaceRedrawNeeded-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/MediaPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/PagedViewIcon;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/location/fused/FusionEngine;-<init>-(Landroid/content/Context; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/PhoneUi;-showWeb-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyApnIdUpToCurrent-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView$3;-goToUnlockScreen-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/WifiManager;-getWifiState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAbsKeyInputView;-onWindowFocusChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor;-handleUserSwitched-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebIconDatabaseClassic;-removeAllIcons-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/PhoneUi;-setUseQuickControls-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView$2;-onClockVisibilityChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/ContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-restoreNoiseSuppression-(Landroid/content/Context;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri; Z Z Z Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/wm/WindowManagerService;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/gallery3d/data/MtpDeviceSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/WiredAccessoryManager;-bootCompleted-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore$EventHub;-dispatchWebKitEvent-(Landroid/webkit/WebViewInputDispatcher; Landroid/view/MotionEvent; I I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/nfc/NfcAdapter;-disableForegroundDispatch-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/location/ILocationManager$Stub;-getProviderProperties-(Ljava/lang/String;)Lcom/android/internal/location/ProviderProperties;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcAdapterExtras;-authenticate-(Ljava/lang/String; [B)V' : ['android.permission.NFC'],
	'Lcom/android/voicedialer/VoiceDialerActivity$1;-onServiceConnected-(I Landroid/bluetooth/BluetoothProfile;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/users/UserSettings;-assignProfilePhoto-(Landroid/content/pm/UserInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/WifiStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService$19;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/common/widget/GroupingListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/downloads/DownloadProvider;-checkInsertPermissions-(Landroid/content/ContentValues;)V' : ['android.permission.INTERNET'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-showBrightnessDialog-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/content/pm/IPackageManager;-getPackageSizeInfo-(Ljava/lang/String; I Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/browser/preferences/InvertedContrastPreview;-updatePreview-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/ILocationManager;-addGpsStatusListener-(Landroid/location/IGpsStatusListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/CommandsInterface;-cancelPendingUssd-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-getSuggestionsWithSessionId-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; I)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/exchange/ExchangeService;-acquireWakeLock-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-doInBackground-([Landroid/content/Intent;)Lcom/android/contacts/model/RawContactDeltaList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView$KeyTimerHandler;-startKeyRepeatTimer-(Lcom/android/inputmethod/keyboard/PointerTracker;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/nfc/NfcService$TagService;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getRemoteUuids-(Landroid/bluetooth/BluetoothDevice;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-showIMEIPanel-(Landroid/content/Context; Z Landroid/telephony/TelephonyManager;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/util/DownloadManager;-getMessage-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/google/common/io/CharStreams$2;-getInput-()Ljava/io/InputStreamReader;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onAttachedToWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$1;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-commandsParser-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/model/dataitem/WebsiteDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-startDtmf-(C Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/PostalAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/DataManager;-onStitchingResult-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmInitReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/gadget/LocalPhotoSource;-getImage-(I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/contacts/SplitAggregateView;-<init>-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-updateProgressbar-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onSimStateChanged-(Lcom/android/internal/telephony/IccCardConstants$State;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService;-updateFromSettingsLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/SimUnlockScreen$1$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/calendar/SearchActivity$2;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/model/dataitem/EmailDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onProgressComplete-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/inputmethod/research/ResearchLogger;-onUserLoggingConsent-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/nfc/P2pEventManager;-onP2pHandoverNotSupported-()V' : ['android.permission.VIBRATE'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/SupplicantStateTracker$DisconnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/wm/WindowManagerService;-removeWindowInnerLocked-(Lcom/android/server/wm/Session; Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/VibratorService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityStack;-activityIdleInternal-(Landroid/os/IBinder; Z Landroid/content/res/Configuration;)Lcom/android/server/am/ActivityRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/Phone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onGenericMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onDialerClose-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LocationManagerService;-removeUpdates-(Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/Chronometer;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/server/BluetoothA2dpService;-onBluetoothEnable-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/IBluetoothPan$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/ContactEntryListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/model/RawContactModifier;-migrateStateForNewContact-(Landroid/content/Context; Lcom/android/contacts/model/RawContactDelta; Lcom/android/contacts/model/RawContactDelta; Lcom/android/contacts/model/account/AccountType; Lcom/android/contacts/model/account/AccountType;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-acquireAggregationSuggestions-(Landroid/content/Context; Lcom/android/contacts/editor/RawContactEditorView;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneProxy;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/EventInfoFragment$11;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/wm/KeyguardDisableHandler$KeyguardTokenWatcher;-released-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IccCardProxy;-setExternalState-(Lcom/android/internal/telephony/IccCardConstants$State; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getProfileProxy-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener; I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManagerService;-getAccountsAsUser-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-setAddWidgetEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-cancelDiscovery-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/LocationManagerService;-addGpsStatusListener-(Landroid/location/IGpsStatusListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-handleHide-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/speech/RecognitionService;-checkPermissions-(Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/server/input/InputManagerService;-notifyANR-(Lcom/android/server/input/InputApplicationHandle; Lcom/android/server/input/InputWindowHandle;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteFieldActivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Landroid/accounts/AccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/systemui/media/NotificationPlayer$CmdThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogFragment;-startVoicemailStatusQuery-()V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/list/AccountFilterActivity$MyLoaderCallbacks;-onLoadFinished-(Landroid/content/Loader; Ljava/util/List;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-scrollRight-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-trySwitchToFirstTouchState-(F F)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onSetUserDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/monkey/MonkeyNetworkMonitor;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; J I)V' : ['android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothInputDevice;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/AddBookmarkPage;-onRootFolderFound-(J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Ljava/net/URL;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothPan;-close-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/sip/ISipService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/provider/ContactsContract$Groups$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetoothPan;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClassic;-updateTextSelectionFromMessage-(I I Landroid/webkit/WebViewCore$TextSelectionData;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/GoogleAccountLogin;-<init>-(Landroid/app/Activity; Landroid/accounts/Account; Ljava/lang/Runnable;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Lcom/android/nfc/NfcService$TagService;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Landroid/bluetooth/BluetoothAdapter;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/WifiService;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/AccessibilitySettings$2;-register-(Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/editor/PhoneticNameEditorView;-onFieldChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/event/EditEventHelper;-saveRemindersWithBackRef-(Ljava/util/ArrayList; I Ljava/util/ArrayList; Ljava/util/ArrayList; Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/app/AlbumPage;-doCluster-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-beginBackup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/effect/effects/StraightenEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/AddBookmarkPage;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/calendar/CalendarReceiver;-removeScheduledAlarms-(Landroid/content/ContentResolver;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/EasAccountService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStoppingState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/SingleSourceCorpus;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/CorpusResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onMenuClicked-(Landroid/view/MenuItem; Ljava/lang/String; Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/NegativeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/DataUsageSummary;-isMobilePolicySplit-()Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/tts/TextToSpeechSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-callSelectedEntry-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/SubSettings;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-dispatchDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onScreenTurnedOn-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-addNmeaListener-(Landroid/location/GpsStatus$NmeaListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onLoadComplete-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsFragment;-eventsChanged-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/nfc/P2pEventManager;-onP2pInRange-()V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/AccessibilityInjector;-addTtsApis-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/Loader;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/BluetoothHeadset;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/AlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/CropImage$LoadBitmapDataTask;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Landroid/net/wifi/WifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getOperator-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic$WebViewInputConnection;-replaceSelection-(Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/SmsUsageMonitor;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/display/DisplayManagerService;-setWindowManager-(Lcom/android/server/display/DisplayManagerService$WindowManagerFuncs;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/RecipientListActivity$RecipientListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/alerts/QuickResponseActivity$QueryThread;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-computeSharingIntent-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/content/Intent;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/UndoBarView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccCardProxy;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogDisabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-updateClusters-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/ConnectivityManager;-startUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/view/inputmethod/InputMethodManager;-dispatchGenericMotionEvent-(Landroid/content/Context; I Landroid/view/MotionEvent; Landroid/view/inputmethod/InputMethodManager$FinishedEventCallback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/INfcTag$Stub;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onSurfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/location/GeofenceManager;-updateFences-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/GLRootView;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleShift-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/view/WindowManagerPolicy;-isKeyguardSecure-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/FilterTypeSet;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/vcard/VCardEntry$PostalData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/view/ViewRootImpl;-finishInputEvent-(Landroid/view/ViewRootImpl$QueuedInputEvent; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/WorkingMessage;-sendMmsWorker-(Lcom/android/mms/data/Conversation; Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onChanged-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-handleCarrierInfoUpdate-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallCard;-displaySecondaryCallStatus-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-handleMediaKeyEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-access$1800-(Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-registerStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccCardProxy;-changeIccFdnPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaFragment;-goTo-(Lcom/android/calendar/CalendarController$EventInfo; Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterfw/core/SyncRunner;-step-()I' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/sip/SipManager;-createSipSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipSession$Listener;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/phone/PhoneGlobals;-access$900-(Lcom/android/phone/PhoneGlobals; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/TransactionService;-endMmsConnectivity-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/BackupManagerService$RunBackupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService;-handleTimeout-(I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/IConnectivityManager;-getTetherableBluetoothRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItem-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/InCallTouchUi;-updateState-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/TrafficStats;-getDataLayerSnapshotForUid-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/gallery3d/data/MtpDeviceSet;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/wifi/WifiSettings;-forget-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/AudioService;-queueMsgUnderWakeLock-(Landroid/os/Handler; I I I Ljava/lang/Object; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DeviceInfoSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneUtils;-cancelMmiCode-(Lcom/android/internal/telephony/Phone;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/Tab$3;-access$1700-(Lcom/android/browser/Tab$3; Z Landroid/os/Message;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-showChallenge-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/VolumePanel;-onVolumeChanged-(I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/sip/SipSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/providers/calendar/CalendarProvider2;-verifyAccounts-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasOutboxService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHealth;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-sendEmergencyCallbackModeChange-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$800-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Utils;-getWifiIpAddresses-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-refreshImeWindowVisibilityLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-systemReady-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-pageBeginMoving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionMove-(Landroid/view/MotionEvent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/location/ILocationProvider$Stub$Proxy;-disable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/server/AlarmManagerService$ResultReceiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord;-keyDispatchingTimedOut-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/nfc/handover/BluetoothHeadsetHandover$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/inputmethodservice/KeyboardView;-access$400-(Landroid/inputmethodservice/KeyboardView; Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-removeAllDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/users/UserSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/InputStreamSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/app/MovieActivity;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/VoiceDialerActivity$4;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/ui/AudioAttachmentView;-access$000-(Lcom/android/mms/ui/AudioAttachmentView;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/ComboAlbum;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DevelopmentSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/common/widget/CompositeCursorAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/net/NetworkPolicyEditor$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-stopDtmf-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/CommonControllerOverlay;-onScrubbingStart-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$ActiveSyncContext;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetModel;-populateDayInfo-(I Landroid/text/format/Time;)Lcom/android/calendar/widget/CalendarAppWidgetModel$DayInfo;' : ['android.permission.READ_CALENDAR'],
	'Landroid/location/ILocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/nfc/INfcTag$Stub;-isNdef-(I)Z' : ['android.permission.NFC'],
	'Landroid/location/ILocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowSession$Stub$Proxy;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserWebView;-requestFocus-(I Landroid/graphics/Rect;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/TechListChooserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commandsParser-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-access$1000-(Lcom/android/phone/InCallScreen; Landroid/os/AsyncResult; C)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/widget/WaveView;-waveUpdateFrame-(F F Z)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebViewInputDispatcher;-dispatchUiEvents-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/INfcTag$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-explicitCallTransfer-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/WorkingMessage;-ensureThreadIdIfNeeded-(Lcom/android/mms/data/Conversation; Z)V' : ['android.permission.READ_SMS'],
	'Lcom/android/contacts/model/dataitem/GroupMembershipDataItem;-buildDataString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/HTML5VideoFullScreen$1;-surfaceDestroyed-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyCallHelper;-startEmergencyCallFromAirplaneModeSequence-(Ljava/lang/String;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/media/AudioService$AudioHandler;-cleanupPlayer-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-handleUp-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/VibratorService;-doVibratorOff-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-getProfileConnectionState-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$24;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Landroid/media/IAudioService;-setBluetoothA2dpDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onRequest-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToPrevImage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ComposeMessageActivity$SendIgnoreInvalidRecipientListener;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleExitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IActivityManager;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readIapFileAndWait-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-registerForSuppServiceNotification-(Landroid/os/Handler; I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/InputStreamSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewProvider;-goBack-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage$1;-doInBackground-([Ljava/lang/Void;)Landroid/util/Pair;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onSingleTapUp-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/DeviceStorageMonitorService;-sendNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$1;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-getBetterNumberFromContacts-(Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateSettings-(Landroid/content/ContentValues;)I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/nfc/P2pEventListener;-onP2pInRange-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-update-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/google/common/io/Files;-getDigest-(Ljava/io/File; Ljava/security/MessageDigest;)[B' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-requestUpdateBluetoothIndication-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/model/dataitem/PhoneDataItem;-getKindTypeColumn-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ManageSimMessages;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$19;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Landroid/widget/VideoView$6;-surfaceDestroyed-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-getBestProvider-(Landroid/location/Criteria; Z)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/MessageUtils;-getNotificationIndDetails-(Landroid/content/Context; Landroid/database/Cursor;)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/data/Conversation;-loadFromThreadId-(J Z)Z' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-acquireWifiLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-stayAwake-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService$Receiver;-callStatusChangedLocked-(Ljava/lang/String; I Landroid/os/Bundle;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-removeFence-(Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/widget/ChartSweepView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Browser;-clearSearches-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/DockService;-msgTypeDocked-(Landroid/bluetooth/BluetoothDevice; I I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewInputDispatcher;-enqueueWebKitEventLocked-(Landroid/webkit/WebViewInputDispatcher$DispatchEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasAccountService;-acknowledgeProvisionImpl-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Contacts$ContactMethods;-addPostalLocation-(Landroid/content/Context; J D D)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-getFreshLocationLocked-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-trySwitchToFirstTouchState-(F F)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/CallLog$Calls;-getLastOutgoingCall-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/EdgeView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/CallDetailActivity$1UpdateContactDetailsTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestore-(Landroid/os/ParcelFileDescriptor; I Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/SelectAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IBackupAgent;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/p2p/WifiP2pService;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/editor/ContactEditorFragment$EntityDeltaComparator;-compare-(Ljava/lang/Object; Ljava/lang/Object;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/app/IBatteryStats;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DataUsageSummary;-getActiveSubscriberId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-getDeltaForAttachingPhotoToContact-()Lcom/android/contacts/model/RawContactDeltaList;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/InCallScreen;-internalAnswerCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-updateNetworkRulesLocked-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/inputmethod/latin/UserHistoryDictionary;-getSuggestionsWithSessionId-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; I)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarController;-sendEventRelatedEvent-(Ljava/lang/Object; J J J J I I J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/power/PowerManagerService;-setTemporaryScreenBrightnessSettingOverrideInternal-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onCodeInput-(I I I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/power/PowerManagerService;-wakeUpInternal-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/SnailAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/BaseStatusBar$NotificationClicker;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebViewClassic;-finalize-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePeople-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/sip/ISipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Landroid/webkit/ZoomManager;-setZoomScale-(F Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-onClickRecentButton-()V' : ['android.permission.GET_TASKS'],
	'Landroid/app/NativeActivity;-preDispatchKeyEvent-(Landroid/view/KeyEvent; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebView;-goBack-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addCallAndContactMenuItems-(Landroid/view/ContextMenu; Lcom/android/mms/ui/ComposeMessageActivity$MsgListMenuClickListener; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/nfc/NfcService;-doDisconnect-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary;-buildLimitedNetworksList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/server/input/InputManagerService;-interceptKeyBeforeDispatching-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)J' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/phone/InCallTouchUi;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-outputRawContactsAsVCard-(Landroid/net/Uri; Ljava/io/OutputStream; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/content/SyncManager$SyncHandler;-maybeStartNextSyncLocked-()J' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/NfcAdapter;-setOnNdefPushCompleteCallback-(Landroid/nfc/NfcAdapter$OnNdefPushCompleteCallback; Landroid/app/Activity; [Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-selectAll-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/GlobalActions$GlobalActionsDialog;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/accounts/AccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/editor/SelectAccountDialogFragment;-onAccountSelected-(Lcom/android/contacts/model/account/AccountWithDataSet;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowManager$Stub;-setForcedDisplayDensity-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hdp/HealthService;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView$KeyTimerHandler;-startKeyRepeatTimer-(Lcom/android/inputmethod/keyboard/PointerTracker; J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-getActualState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-updateWallpaperLocked-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/editor/LabeledEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-sendUpdates-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitorCallback;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/WindowManagerPolicy;-exitKeyguardSecurely-(Landroid/view/WindowManagerPolicy$OnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/SecureAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/ResearchLogger;-onWordComplete-(Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-onContentChanged-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/ims/IsimFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$AccountAnalyzer;-next-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/wifi/WifiAPITest$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/CallLogProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserBackupAgent;-onRestore-(Landroid/app/backup/BackupDataInput; I Landroid/os/ParcelFileDescriptor;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator$ViewMediatorCallback;-keyguardDone-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-setPhoto-(J Landroid/graphics/Bitmap; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-createServerSession-(Ljavax/obex/ObexTransport;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadsetPhone$Stub;-answerCall-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onLongTap-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/PbapServerProfile;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/wifi/WifiSettings;-onResume-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/camera/ActivityBase;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/BackupManagerService$PerformFullBackupTask;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask$RestoreFileRunnable;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/model/dataitem/StructuredPostalDataItem;-getAccountType-()Lcom/android/contacts/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothInputDevice;-setProtocolMode-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/widget/MmsWidgetService$MmsFactory;-onDataSetChanged-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/sip/SipSettings;-access$500-(Lcom/android/phone/sip/SipSettings; Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/bluetooth/btservice/AdapterService;-fetchRemoteUuids-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateShare-(Landroid/database/Cursor; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-addVoiceMailNumberPanel-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/music/MusicUtils;-playAll-(Landroid/content/Context; [J I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-getCurrentDeviceName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/accounts/AddAccountSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/RawContactEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetoothA2dp;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebViewClassic;-goForward-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhotoByDataId-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/camera/ui/InLineSettingItem;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/vcard/VCardEntry;-toString-()Ljava/lang/String;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/IccCardProxy;-setIccFdnEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/SnapshotTab;-<init>-(Lcom/android/browser/WebViewController; Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/common/widget/GroupingListAdapter;-bindStandAloneView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity;-access$000-(Lcom/android/contacts/activities/PhotoSelectionActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-dialRecipient-()V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-setCurrentPreferredNetworkType-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AutofillHandler;-asyncLoadFromDb-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-refresh-(Landroid/text/format/Time; J Ljava/lang/String; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/PhoneApp;-onCreate-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_CALL_LOG', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-setEntityDeltaList-(Lcom/android/contacts/model/RawContactDeltaList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler;-getWritableEntityIndex-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView$4$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$900-(Lcom/android/contacts/activities/ConfirmAddDetailActivity; J Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/PhoneBase;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$2700-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BluetoothManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/DhcpStateMachine$WaitBeforeRenewalState;-exit-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/NameConverter;-structuredNameToDisplayName-(Landroid/content/Context; Landroid/content/ContentValues;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/AdnRecordCache;-updateAdnBySearch-(I Lcom/android/internal/telephony/AdnRecord; Lcom/android/internal/telephony/AdnRecord; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/net/NetworkStatsService;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/SlideshowView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessagesInSameThreadAsMessage-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$VpnSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$2;-onRemoveViewAnimationCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavScreen$1;-onRemovePosition-(I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfoForSelf-()Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/CallbackProxy;-onSavePassword-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneInterfaceManager;-call-(Ljava/lang/String;)V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/server/wm/WindowAnimator$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LocationManagerService;-access$300-(Lcom/android/server/LocationManagerService; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ConversationListItem;-access$000-(Lcom/android/mms/ui/ConversationListItem;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/ManageConferenceUtils$2;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/suggestions/MoreSuggestionsView$1;-onTextInput-(Ljava/lang/CharSequence;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/BluetoothManagerService;-registerStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/RecognitionService$RecognitionServiceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/server/pm/PackageManagerService;-installNewPackageLI-(Landroid/content/pm/PackageParser$Package; I I Landroid/os/UserHandle; Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onActionIntentReconnectAlarm-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/TrimControllerOverlay;-onScrubbingEnd-(I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/TechListChooserActivity;-onCreate-(Landroid/os/Bundle; Landroid/content/Intent; Ljava/lang/CharSequence; [Landroid/content/Intent; Ljava/util/List; Z)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onMeasure-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasAccountService;-sendHttpClientPost-(Ljava/lang/String; Lorg/apache/http/HttpEntity;)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-trySetupData-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-requestCloseOtaFailureNotice-(J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$BondStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPageWithVelocity-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onContactUriQueryFinished-(Landroid/net/Uri;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/browser/Tab;-loadUrl-(Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-notifySignalStrength-()Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/MediaSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-onNegative-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/os/RuntimeInit$UncaughtHandler;-uncaughtException-(Ljava/lang/Thread; Ljava/lang/Throwable;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/SyncManager;-readDataConnectionState-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-applyWakeLockFlagsOnAcquireLocked-(Lcom/android/server/power/PowerManagerService$WakeLock;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/net/DataUsageMeteredSettings;-buildMobilePref-(Landroid/content/Context;)Landroid/preference/Preference;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-setOnChallengeScrolledListener-(Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$OnChallengeScrolledListener;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ContactEditorActivity;-onBackPressed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/IContentService$Stub;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/deskclock/AlarmKlaxon;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService;-removeTracksInternal-(I I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoModule;-init-(Lcom/android/camera/CameraActivity; Landroid/view/View; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/model/dataitem/NicknameDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/effect/effects/AutoFixEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothHeadset;-startScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/model/dataitem/DataItem;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/ZoomButtonsController;-onContainerKey-(Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/server/search/SearchManagerService$GlobalSearchProviderObserver;-<init>-(Landroid/server/search/SearchManagerService; Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-showSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/EmergencyDialer;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItems-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/content/IContentService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/browser/DeviceAccountLogin;-handleLogin-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-onProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/event/AttendeesView;-access$100-(Lcom/android/calendar/event/AttendeesView; Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/PhoneGlobals;-updateProximitySensorMode-(Lcom/android/internal/telephony/PhoneConstants$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/location/GpsLocationProvider;-access$2100-(Lcom/android/server/location/GpsLocationProvider;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$2;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/data/ClusterAlbum$2;-consume-(I Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/BatteryStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/browser/AddBookmarkPage$EditBookmarkInfoLoader;-loadInBackground-()Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/SyncManager;-sendCancelSyncsMessage-(Landroid/accounts/Account; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/display/DisplayManagerService;-setInputManager-(Lcom/android/server/display/DisplayManagerService$InputManagerFuncs;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteUuids-(Landroid/bluetooth/BluetoothDevice;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/btservice/AdapterService;-access$100-(Lcom/android/bluetooth/btservice/AdapterService; Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/SnailSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-verifyUnlock-(Landroid/view/WindowManagerPolicy$OnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-getWithUri-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)Landroid/util/Pair;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/WifiStateMachine$DriverStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-access$2000-(Lcom/android/server/BluetoothManagerService;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onInvalidSelection-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/browser/NavScreen;-openNewTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/nfc/tech/NdefFormatable;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/app/PhotoPage$6;-onLoadingFinished-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/browser/BrowserWebView;-zoomIn-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/group/GroupBrowseListFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/WebViewInputDispatcher;-dispatchWebKitEvents-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleEctIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText;-getCarrierHelpTextForSimState-(Lcom/android/internal/telephony/IccCardConstants$State; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/CharSequence;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/vcard/VCardParser_V21;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/camera/ui/OverlayRenderer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/util/ThumbnailManager$ThumbnailTask$1;-run-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/SlotView$MyGestureListener;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-parse-()Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-initialize-(Landroid/os/Bundle; Lcom/android/contacts/list/ContactsRequest;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler$PhotoListener;-onUseAsPrimaryChosen-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/activities/ActionBarAdapter$MyTabListener;-onTabSelected-(Landroid/app/ActionBar$Tab; Landroid/app/FragmentTransaction;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/MtpDeviceSet;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/calendar/CalendarProvider2;-insertInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues; Z)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/nfc/NfcActivityManager;-setNdefPushContentUri-(Landroid/app/Activity; [Landroid/net/Uri;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryFacilityLockForApp-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$AmsTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebViewClassic;-notifyFindDialogDismissed-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-serviceRequest-(J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-updateResources-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-access$300-(Lcom/android/internal/widget/multiwaveview/MultiWaveView; I F F)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/display/DisplayManagerService;-access$1400-(Lcom/android/server/display/DisplayManagerService; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/NfcAdapter;-enableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/widget/LayoutSuppressingQuickContactBadge;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-setState-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/Vibrator;-vibrate-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/systemui/recent/RecentsActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-onConnectivityChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$24;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/gallery3d/gadget/WidgetSource;-reload-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/data/Conversation;-ensureThreadId-()J' : ['android.permission.READ_SMS'],
	'Lcom/google/android/mms/pdu/PduPersister;-loadRecipients-(I Ljava/util/HashSet; Ljava/util/HashMap; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$2;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/base/NullFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-verifyUnlock-(Landroid/view/WindowManagerPolicy$OnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToHitPicture-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-crashApplication-(Lcom/android/server/am/ProcessRecord; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/WifiService;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onClick-(Landroid/view/View;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler$PhotoActionListener;-onRemovePictureChosen-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/net/IConnectivityManager;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/GLView;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoSourcePlexor;-<init>-(Landroid/content/Context; Landroid/content/SharedPreferences;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DataUsageSummary;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$HeaderAdapter;-resume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-onRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/sip/SipManager;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/model/ContactLoader;-postViewNotificationToSyncAdapter-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-finalizeBackup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LightsService$1;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/contacts/model/RawContactDeltaList;-getFirstWritableRawContact-(Landroid/content/Context;)Lcom/android/contacts/model/RawContactDelta;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$GroupDelta;-fromSettings-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)Lcom/android/contacts/list/CustomContactListFilterActivity$GroupDelta;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/accounts/AuthenticatorHelper;-onAccountsUpdated-(Landroid/content/Context; [Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/list/ContactListFilterController;-checkFilterValidity-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/CallFeaturesSetting;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/ShutdownThread;-beginShutdownSequence-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/AccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneProxy;-deleteAndCreatePhone-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/webkit/WebViewClassic;-onFocusChanged-(Z I Landroid/graphics/Rect;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoViewProxy;-pauseAndDispatch-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserSettings;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressKey-(I Z I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterfw/core/FilterGraph;-tearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/SimUnlockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardScreenCallback; Lcom/android/internal/widget/LockPatternUtils;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/model/dataitem/RelationDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$AdapterStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/ViewRootImpl;-dispatchUnhandledKey-(Landroid/view/KeyEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-connectSocket-(Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-setCursor-(Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/group/GroupDetailFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/text/StringLogger;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NsdService;-create-(Landroid/content/Context;)Lcom/android/server/NsdService;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager$3;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/OtaStartupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/IActivityManager;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/LocationManager;-getProviders-(Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView$1;-onEndBatchInput-(Lcom/android/inputmethod/latin/InputPointers;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/InCallScreen;-access$2300-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/IccRecords;-onAllRecordsLoaded-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/tech/MifareClassic;-transfer-(I)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadService;-access$500-(Lcom/android/providers/downloads/DownloadService; Lcom/android/providers/downloads/DownloadInfo$Reader; Lcom/android/providers/downloads/DownloadInfo; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-initSstIcc-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/webkit/HTML5VideoView;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAudioSourceFunction-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/IRingtonePlayer$Stub;-play-(Landroid/os/IBinder; Landroid/net/Uri; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-createDictAndProximity-(Ljava/util/Locale;)Lcom/android/inputmethod/latin/spellcheck/DictAndProximity;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableBluetoothRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$3;-onFinish-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/FrameBranch;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/InputMethodManagerService;-showInputMethodMenu-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/DownloadManager;-getUriForDownloadedFile-(J)Landroid/net/Uri;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/am/BroadcastQueue;-setBroadcastTimeoutLocked-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchUnhandledKey-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/BatteryStatsService;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserHistoryPage;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/BackupManagerService;-bindToAgentSynchronous-(Landroid/content/pm/ApplicationInfo; I)Landroid/app/IBackupAgent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewCallback;-pokeWakelock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/transaction/SendTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/InputMethodManagerService;-setInputMethodLocked-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/IAccountManager;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Landroid/test/mock/MockContentResolver;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/gallery3d/ui/PhotoView$MyGestureListener;-onSingleTapUp-(F F)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-verifyUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-startPairing-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/editor/LabeledEditorView;-onLabelRebuilt-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/SearchActivity;-onQueryTextSubmit-(Ljava/lang/String;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/WebViewClassic;-sendViewSizeZoom-(Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/EditEventFragment;-access$000-(Lcom/android/calendar/event/EditEventFragment; I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/IIntentReceiver$Stub;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/IConnectivityManager;-updateLockdownVpn-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/AlarmManagerService;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/Gallery;-initializeByIntent-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/webkit/WebViewClassic;-dumpDomTree-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$VerifyingLinkState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService;-reloadQueue-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/LockdownVpnTracker;-reset-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/FindActionModeCallback;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/NfcService;-onSeMifareAccess-([B)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-handleIMEIDisplay-(Landroid/content/Context; Ljava/lang/String; Z)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/WebViewCore;-sendMessageAtFrontOfQueue-(I I I Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/PowerManagerService;-access$2100-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/DataManager;-rotate-(Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-getBondState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/LocationManagerService;-removeUpdatesLocked-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/SearchActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/EnableAccessibilityController;-<init>-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-verifyUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPage-(I I I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/media/RingtonePlayer;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAbsKeyInputView$3;-onFinish-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BrowserWebView;-findAllAsync-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ims/IsimFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NativeDaemonConnector;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/nfc/NfcService;-onRemoteFieldActivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEvent-(I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/NavTabScroller;-onLayout-(Z I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/systemui/recent/RecentTasksLoader;-getFirstTask-()Lcom/android/systemui/recent/TaskDescription;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView;-recreateLockScreen-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setFilter-(Lcom/android/contacts/list/ContactListFilter;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/nfc/INfcTag;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockScreen$SlidingTabMethods;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-createImportRequest-()Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/BluetoothPbap;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/systemui/SearchPanelView$GlowPadTriggerListener;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/MessageListAdapter;-onContentChanged-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-generateBinaryDictionary-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/base/OutputStreamTarget;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/WorkingMessage;-deleteDraftSmsMessage-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/os/IPowerManager$Stub$Proxy;-setStayOnSetting-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-dispatchAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-moveAppWindowsLocked-(Lcom/android/server/wm/AppWindowToken; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/webkit/ZoomManager;-zoom-(F)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pan/PanService;-handlePanDeviceStateChange-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String; I I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/ui/ConversationList;-createNewMessage-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiStateMachine$DriverStoppedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-getSuggestionsWithSessionId-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo; I)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/model/RawContact;-getAccountTypeManager-()Lcom/android/contacts/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-onImportFinished-(Lcom/android/contacts/vcard/ImportRequest; I Landroid/net/Uri;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-moveTo-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/PhoneUi;-hideNavScreen-(I Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/wifi/WifiSettings;-constructAccessPoints-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BaseUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-asyncReloadDictionaryIfRequired-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetoothHealth;-getConnectedHealthDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/tablet/NotificationPanel;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-bindData-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-setProtocolMode-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/model/ImageModel;-loadThumbnailBitmap-(Lcom/android/mms/util/ItemLoadedCallback;)Lcom/android/mms/util/ItemLoadedFuture;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/ThrottleService;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreenShowActivation;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerSession;-onGetSuggestions-(Landroid/view/textservice/TextInfo; Ljava/lang/String; I)Landroid/view/textservice/SuggestionsInfo;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/widget/VideoView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiApEnabler;-setSoftapEnabled-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/model/dataitem/ImDataItem;-getKindString-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-access$1600-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiApConfigStore$InactiveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-onVisibilityChanged-(Z)V' : ['android.permission.CAMERA'],
	'Lcom/android/settings/SettingsLicenseActivity;-access$000-(Lcom/android/settings/SettingsLicenseActivity; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/PasswordUnlockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardScreenCallback;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/nfc/handover/HandoverService;-doIncomingTransfer-(Landroid/os/Message;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/TrimControllerOverlay;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/SearchActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/IPowerManager$Stub;-updateWakeLockWorkSource-(Landroid/os/IBinder; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-removeJavascriptInterface-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityCallback;-reportSuccessfulUnlockAttempt-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-invokeCustomRequest-(I)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-requestStateChange-(Landroid/content/Context; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/wfd/WifiDisplaySettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkTimeUpdateService$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment;-selectAccountAndCreateGroup-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothPbap$Stub;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/INfcAdapterExtras;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Lcom/android/calendar/event/EditEventHelper$EditDoneRunnable;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyRepeatWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-processMiscUsage-()V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangup-(Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity;-cycleRepeat-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-performTransitions-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/text/StringSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToPageImmediately-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/INfcAdapterExtras$Stub$Proxy;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Lcom/android/bluetooth/btservice/AdapterService;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateButton-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/media/IAudioService$Stub;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IccCard;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnection$DcActivatingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DeviceAdminSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage$4;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-alarmExists-(Landroid/content/ContentResolver; J J J)Z' : ['android.permission.READ_CALENDAR'],
	'Landroid/webkit/WebViewClassic;-passToJavaScript-(Ljava/lang/String; Landroid/view/KeyEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame$7;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary$12;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-editProperties-(Ljava/lang/String; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/ErrorConsoleView$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/ViewRootImpl;-deliverGenericMotionEvent-(Landroid/view/ViewRootImpl$QueuedInputEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-queryCallWaiting-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/location/LocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/AccountUnlockScreen;-asyncCheckPassword-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView;-onFinishInflate-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitorCallback;-onRefreshCarrierInfo-(Ljava/lang/CharSequence; Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onRegisterKey-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/model/dataitem/GroupMembershipDataItem;-getKindTypeColumn-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothA2dp;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/IAccountManager$Stub;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage;-preSendSmsWorker-(Lcom/android/mms/data/Conversation; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-access$500-(Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/gallery3d/ui/TileImageView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/media/IRingtonePlayer$Stub$Proxy;-stopAsync-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/WorkingMessage;-saveDraft-(Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/mms/data/WorkingMessage;-saveAsMms-(Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/exchange/ExchangeService$2;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/usb/UsbAccessoryUriActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/net/IThrottleManager$Stub;-getPeriodStartTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDraggingApplication-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/ZoomManager;-updateDoubleTapZoom-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/TimerRingService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupDetailFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView;-onWindowFocusChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-setForegroundDispatch-(Landroid/app/PendingIntent; [Landroid/content/IntentFilter; Landroid/nfc/TechListParcel;)V' : ['android.permission.NFC'],
	'Lcom/android/contacts/quickcontact/DataAction;-<init>-(Landroid/content/Context; Lcom/android/contacts/model/dataitem/DataItem;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;-onMeasure-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/power/PowerUI;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$TagService;-reconnect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/ChallengeLayout;-hideBouncer-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/dialog/ClearFrequentsDialog$1$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-query-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/Conversation;-dumpThreadsTable-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/ui/MessageListItem;-updateAvatarView-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings$LocationSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/Phone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/NfcHandler;-register-(Landroid/app/Activity; Lcom/android/contacts/detail/ContactDetailFragment;)V' : ['android.permission.NFC'],
	'Landroid/net/IThrottleManager;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-setSyncKey-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/sip/SipManager;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccCardProxy;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebIconDatabaseClassic;-releaseIconForPageUrl-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/activities/DialtactsActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/google/common/io/ByteStreams;-length-(Lcom/google/common/io/InputSupplier;)J' : ['android.permission.INTERNET'],
	'Lcom/android/launcher2/Workspace;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/MccTable;-setSystemLocale-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/Connection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$BackgroundQueryHandler;-onDeleteComplete-(I Ljava/lang/Object; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-removeBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-main-(I)Landroid/content/Context;' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/content/Context;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-scrollLeft-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-getWifiApState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-updateLockdownVpn-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onVisibilityChanged-(Z)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothHealth;-registerAppConfiguration-(Ljava/lang/String; I I I Landroid/bluetooth/BluetoothHealthCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ActivityBase;-createCameraScreenNail-(Z)Lcom/android/gallery3d/ui/ScreenNail;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/browser/homepages/RequestHandler;-doHandleRequest-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-init-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/ActivityManagerNative;-updateConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService;-goToSleepInternal-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-handleVolumeKey-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-copyMedia-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/ui/TileImageView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$StateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager;-getLinkProperties-(I)Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/SimPukUnlockScreen;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/ThrottleManager;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/PeopleActivity;-areGroupWritableAccountsAvailable-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService;-checkScoAudioState-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.CALL_PHONE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/media/RingtonePlayer$Client;-<init>-(Lcom/android/systemui/media/RingtonePlayer; Landroid/os/IBinder; Landroid/net/Uri; Landroid/os/UserHandle; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItems-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/telephony/PhoneNumberUtils;-isVoiceMailNumber-(Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/CallDetailActivity$1UpdateContactDetailsTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$1900-(Lcom/android/bluetooth/pbap/BluetoothPbapService; I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$CustomFilterConfigurationLoader;-loadInBackground-()Lcom/android/contacts/list/CustomContactListFilterActivity$AccountSet;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-notifyScreenOffLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallCard;-updateForegroundCall-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/nfc/NfcActivityManager;-setOnNdefPushCompleteCallback-(Landroid/app/Activity; Landroid/nfc/NfcAdapter$OnNdefPushCompleteCallback;)V' : ['android.permission.NFC'],
	'Landroid/media/AsyncPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-setFrequencyBand-(I Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/PhoneUtils;-placeCall-(Landroid/content/Context; Lcom/android/internal/telephony/Phone; Ljava/lang/String; Landroid/net/Uri; Z Landroid/net/Uri;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView$Listener;-pickSuggestionManually-(I Ljava/lang/CharSequence;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/Settings$DreamSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/users/UserSettings;-access$800-(Lcom/android/settings/users/UserSettings;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-addEvent-(Lcom/android/exchange/adapter/CalendarSyncAdapter$CalendarOperations; Ljava/lang/String; Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$BugreportObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/BroadcastQueue$AppNotResponding;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-keyguardDone-(Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-handleUp-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-sendPdu-(J [B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-onResume-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/InputMethodManagerService;-access$000-(Lcom/android/server/InputMethodManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/provider/Account;-isAutomaticSyncDisabledByRoaming-(Landroid/content/Context; J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-access$400-(Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager; [Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/settings/SettingsBackupAgent$WifiRestoreRunnable;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/util/AddressUtils;-getFrom-(Landroid/content/Context; Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.READ_SMS'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-getPackageSizeInfo-(Ljava/lang/String; I Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Landroid/media/AudioService$SetModeDeathHandler;-binderDied-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-<init>-(Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/RingerVolumePreference;-cleanup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-notifyContactListFilterChanged-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/LocationManagerService$3;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothDevice;-removeBond-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/NfcService$NfcAdapterExtrasService;-_transceive-([B)[B' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-handleSettingsChangedLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/provider/Browser;-deleteHistoryTimeFrame-(Landroid/content/ContentResolver; J J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewStateManager;-onScrollStateChanged-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/NfcAdapter$1;-onPaused-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/SipCallOptionHandler;-access$100-(Lcom/android/phone/SipCallOptionHandler;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/recent/RecentsActivity;-onBackPressed-()V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Landroid/speech/IRecognitionService;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/IAudioService$Stub$Proxy;-setWiredDeviceConnectionState-(I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationFailed-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService$FeatureUser;-expire-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/SecureAlbum;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/inputmethod/UserDictionaryList;-getUserDictionaryLocalesSet-(Landroid/app/Activity;)Ljava/util/TreeSet;' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/RIL;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-sendIntentEnter-(Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/IconLoader;-readId-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$TagService;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Landroid/filterfw/core/GraphRunner;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/PasswordUnlockScreen$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/StatusBarManager;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPukForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/SyncSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$NotConnectedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/vcard/VCardEntry$AnniversaryData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/ui/MmsThumbnailPresenter$1;-onItemLoaded-(Lcom/android/mms/util/ThumbnailManager$ImageLoaded; Ljava/lang/Throwable;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/gadget/MediaSetSource;-reload-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/google/common/io/Files;-move-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Landroid/os/IVibratorService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ClassZeroActivity;-saveMessage-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/MasterClear;-establishInitialState-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-startVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-getDeviceIdentity-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/datepicker/DatePickerDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/view/inputmethod/BaseInputConnection;-commitText-(Ljava/lang/CharSequence; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-onSurfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.CAMERA'],
	'Lcom/android/server/power/Notifier;-updatePendingBroadcastLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getCdmaSubscriptionSource-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NewCallsQuery;-query-()[Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NewCall;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/webkit/WebViewProvider;-clearSslPreferences-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LocationManagerService;-updateProvidersLocked-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/event/AttendeesView;-updateAttendeeView-(Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/pm/PackageManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.READ_EXTERNAL_STORAGE', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/browser/DataController$DataControllerHandler;-doSaveThumbnail-(Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/RIL;-getIccCardStatus-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager;-setForcedDisplaySize-(I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/EventFieldEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/browser/Controller;-openIncognitoTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/deskclock/AlarmAlertWakeLock;-releaseCpuLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ConversationList$7;-onKey-(Landroid/view/View; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/gadget/PhotoAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/wifi/WifiSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationTimeout-(Landroid/net/sip/ISipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-execute-(Lcom/android/gallery3d/data/DataManager; Lcom/android/gallery3d/util/ThreadPool$JobContext; I Lcom/android/gallery3d/data/Path;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockPatternKeyguardView$3;-forgotPattern-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterfw/core/Filter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$SinglePressAction;-onLongPress-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendAcknowledgeInd-(Lcom/google/android/mms/pdu/RetrieveConf;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/SystemFacade;-isNetworkRoaming-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewProvider;-clearMatches-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$8;-onClick-(Landroid/view/View;)V' : ['android.permission.GET_TASKS'],
	'Landroid/net/wifi/IWifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager;-wakeWhenReadyTq-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/RadioInfo$22;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/PushReceiver;-isDuplicateNotification-(Landroid/content/Context; Lcom/google/android/mms/pdu/NotificationInd;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/contacts/model/dataitem/ImDataItem;-getDataKind-()Lcom/android/contacts/model/dataitem/DataKind;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/power/DisplayPowerController$3;-run-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/downloads/DownloadInfo;-getMyDownloadsUri-()Landroid/net/Uri;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/BluetoothManagerService;-access$2700-(Lcom/android/server/BluetoothManagerService; I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/AttachmentEditor;-update-(Lcom/android/mms/data/WorkingMessage;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/agenda/AgendaListView;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DataUsageSummary;-access$800-(Lcom/android/settings/DataUsageSummary; J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AudioService$ScoClient;-incCount-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewRootImpl;-deliverTrackballEventPostIme-(Landroid/view/ViewRootImpl$QueuedInputEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-insert-(Landroid/content/ContentResolver; J J J J I)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/telephony/gsm/SmsManager;-copyMessageToSim-([B [B I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/widget/LockScreenWidgetCallback;-userActivity-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/view/IWindowManager;-startFreezingScreen-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onBootCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-setSystemUiVisibility-(I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlotView$MyGestureListener;-onLongPress-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/vcard/ImportVCardActivity$VCardCacheThread;-constructImportRequest-([B Landroid/net/Uri; Ljava/lang/String;)Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/settings/Settings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/CaptivePortalTracker$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EmailSyncAlarmReceiver;-handleReceive-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewFragment;-onDestroy-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/PreloadRequestReceiver;-handlePreload-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-endReordering-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/ui/RenderOverlay$Renderer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/net/NetworkStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/providers/downloads/DownloadInfo;-checkCanUseNetwork-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothPhoneService;-sendClccResponseCdma-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/RadioInfo;-onPause-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/ContextImpl;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-enableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/list/PostalAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/accounts/AccountManager$3;-doWork-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/Controller$PruneThumbnails;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/SnapshotTab;-putInForeground-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Lcom/android/phone/CdmaSystemSelectListPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-checkPermissionsAndCreateUriData-(Landroid/net/Uri;)Lcom/android/providers/contacts/VoicemailContentProvider$UriData;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pConnectionChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/dataitem/IdentityDataItem;-buildDataStringForDisplay-()Ljava/lang/String;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/camera/ShutterButton$OnShutterButtonListener;-onShutterButtonClick-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/sip/ISipService;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/BackupManagerService$RunInitializeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/NetworkStateTracker;-teardown-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/commands/pm/Pm;-main-([Ljava/lang/String;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/mms/transaction/Transaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/handover/BluetoothHeadsetHandover;-start-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/WaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-hapticAndAudioFeedback-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView;-slideToNextPicture-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyDownUpListener;-onUp-(Landroid/view/MotionEvent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/LocationBasedCountryDetector$1;-onLocationChanged-(Landroid/location/Location;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmPreference$1;-doInBackground-([Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallerInfoCache;-startAsyncCache-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/support/v4/net/ConnectivityManagerCompat;-getNetworkInfoFromBroadcast-(Landroid/net/ConnectivityManager; Landroid/content/Intent;)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/FrameBranch;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$Listener;-onDown-(F F)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/InputMethodManagerService$MethodCallback;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/tech/MifareUltralight;-connect-()V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ActivityManagerNative;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiStateMachine;-setWifiApState-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/contacts/group/GroupEditorFragment$Member;-<init>-(J Ljava/lang/String; J Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView$2;-onBootCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/AllInOneActivity;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallTouchUi;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Pending;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/voicedialer/VoiceDialerActivity$3;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/nfc/NfcActivityManager;-requestNfcServiceCallback-(Z)V' : ['android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopPackageLocked-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/Tab$2$4;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsByFeatures-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/test/mock/MockContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/DialogPicker;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/ITelephony;-endCall-()Z' : ['android.permission.CALL_PHONE'],
	'Landroid/server/BluetoothA2dpService;-checkSinkSuspendState-(I)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-hideSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/Controller;-setActiveTab-(Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/systemui/media/NotificationPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/ObscureSpeechDelegate;-shouldObscureSpeech-()Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-dispatchUnhandledMove-(Landroid/view/View; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/IContentService$Stub$Proxy;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/webkit/WebViewCore;-jsConfirm-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-createConnectionDialogView-()Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebViewClassic;-externalRepresentation-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WifiService;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-screenTurningOn-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; J Z Landroid/net/Uri;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/PhoneUtils;-answerCall-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/inputmethod/research/ResearchLogger;-restart-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/camera/ui/InLineSettingSwitch$1;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/TabBar$TabView;-closeTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/Preloader$PreloaderSession;-<init>-(Lcom/android/browser/Preloader; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/pm/IPackageManager$Stub;-getPackageSizeInfo-(Ljava/lang/String; I Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/browser/search/OpenSearchSearchEngine;-getSuggestions-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiEnabled-(Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$UserAuthorizingInvitationState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS'],
	'Lcom/android/server/location/LocationProviderProxy;-disable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmKlaxon;-play-(Lcom/android/deskclock/Alarm;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/BackupManagerService;-prepareOperationTimeout-(I J Lcom/android/server/BackupManagerService$BackupRestoreTask;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/model/RawContactDeltaList;-buildSplitContactDiff-(Ljava/util/ArrayList; [I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/view/inputmethod/BaseInputConnection;-setComposingRegion-(I I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$VpnSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/display/DisplayManagerService;-setDisplayInfoOverrideFromWindowManager-(I Landroid/view/DisplayInfo;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/p2p/WifiP2pSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/event/EditEventView$DateListener;-onDateSet-(Landroid/widget/DatePicker; I I I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEstablished-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/SubSettings;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/WindowManagerPolicy;-screenTurningOn-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ims/IsimFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getIMEISV-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/CropImage$SaveOutput;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnection;-tearDownData-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getVoiceRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPINView;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/DetailsAddressResolver$AddressLookupJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/location/Address;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$4;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/ui/TileImageView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/BluetoothAdapter;-createNewRfcommSocketAndRecord-(Ljava/lang/String; Ljava/util/UUID; Z Z)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/dhimpl/NativeNfcManager;-notifySeFieldDeactivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/contacts/activities/GroupBrowserActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ThrottleService;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/UsimFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-addJavascriptInterface-(Ljava/lang/Object; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/commands/monkey/MonkeyNetworkMonitor;-register-(Landroid/app/IActivityManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DataUsageSummary;-isMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipSettings;-access$700-(Lcom/android/phone/sip/SipSettings; Z)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$SettingsObserver;-observe-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/inputmethod/InputMethodManager;-dispatchKeyEvent-(Landroid/content/Context; I Landroid/view/KeyEvent; Landroid/view/inputmethod/InputMethodManager$FinishedEventCallback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/power/PowerManagerService;-handleDreamFinishedLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/EditableInputConnection;-performEditorAction-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-showGlobalActionsDialog-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/location/ILocationManager;-removeUpdates-(Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/usb/UsbDebuggingActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Landroid/app/KeyguardManager$KeyguardLock;-disableKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-toggleRecentsActivity-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnection;-access$2000-(Lcom/android/internal/telephony/DataConnection; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$3;-reportFailedUnlockAttempt-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-simulateKeyPress-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/dreams/phototable/StockSource;-<init>-(Landroid/content/Context; Landroid/content/SharedPreferences;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/EdgeView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/mms/data/Contact$ContactsCache;-updateContact-(Lcom/android/mms/data/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/BluetoothAdapter;-setScanMode-(I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserWebView;-restoreState-(Landroid/os/Bundle;)Landroid/webkit/WebBackForwardList;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/CallLogProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/ThrottleManager;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Preloader;-getSession-(Ljava/lang/String;)Lcom/android/browser/Preloader$PreloaderSession;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/ObscureSpeechDelegate;-onPopulateAccessibilityEvent-(Landroid/view/View; Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/os/IPowerManager$Stub;-releaseWakeLock-(Landroid/os/IBinder; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebViewClassic;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Controller;-onPreloginFinished-(Landroid/os/Bundle; Landroid/content/Intent; J Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-haveSomethingToCopyToSDCard-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-goToUserSwitcher-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$000-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/UiController;-switchToTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyApnIdDisconnected-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IccCardProxy;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternView;-notifyCellAdded-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/vcard/ExportProcessor;-runInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onCreate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PackageSummary$1;-onClick-(Landroid/view/View;)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onCardEmulationDeselected-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Landroid/telephony/SmsManager;-sendMultipartTextMessage-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/calendar/EventInfoFragment;-initAttendeesCursor-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/inputmethod/pinyin/SoftKeyboardView;-tryVibrate-()V' : ['android.permission.VIBRATE'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ClearMissedCallsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/browser/BrowserWebView;-stopLoading-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-showSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebViewInputDispatcher;-scheduleLongPressLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothInputDevice;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/InputMethodManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/wm/WindowManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/DayView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/server/net/LockdownVpnTracker$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/input/InputManagerService$WindowManagerCallbacks;-notifyANR-(Lcom/android/server/input/InputApplicationHandle; Lcom/android/server/input/InputWindowHandle;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/webkit/WebViewCore;-sendMessages-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewClassic;-deleteSelection-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onSeListenDeactivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/browser/UiController;-closeCurrentTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/browser/DataController$DataControllerHandler;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockScreen;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/pm/PackageManagerService;-scanAvailableAsecs-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/inputmethodservice/ExtractButton;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-createDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SlideshowDataAdapter$SlideshowSource;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaFragment$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/data/WorkingMessage;-access$1300-(Lcom/google/android/mms/pdu/PduPersister; Lcom/google/android/mms/pdu/SendReq; Lcom/android/mms/model/SlideshowModel; Landroid/net/Uri; Landroid/content/Context; Ljava/util/HashMap;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler$PhotoActionListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/wm/WindowManagerService;-makeWindowFreezingScreenIfNeededLocked-(Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-dismiss-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/FrameStore;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;-access$400-(Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/wallpaper/grass/GrassRS;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/sip/SipWakeLock;-acquire-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/UserDictionaryList;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-refreshName-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onPostExecute-(Ljava/lang/Void;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ActivityBase;-reuseCameraScreenNail-(Z)Lcom/android/gallery3d/ui/ScreenNail;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/systemui/recent/RecentsHorizontalScrollView;-onChildDismissed-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/PhoneBase;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager$Stub;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/webkit/WebViewCore;-sendMessageDelayed-(I Ljava/lang/Object; J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewProvider;-restoreState-(Landroid/os/Bundle;)Landroid/webkit/WebBackForwardList;' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/AutoFixEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/VolumePanel;-onVibrate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/browser/NetworkStateHandler;-access$000-(Lcom/android/browser/NetworkStateHandler; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/NotificationMgr;-updateNotificationAndLaunchIncomingCallUi-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/DataUsageSummary;-hasWifiRadio-(Landroid/content/Context;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallNotifier;-onCdmaCallWaiting-(Landroid/os/AsyncResult;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-handleNotifyScreenOn-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager$ShowListener;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/FaceUnlock;-handlePokeWakelock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPin-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-updateResizingWindows-(Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitorCallback;-onUserSwitched-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/UsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardParser_V40;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/UsimFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-loadUrlDataIn-(Lcom/android/browser/Tab; Lcom/android/browser/IntentHandler$UrlData;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-appDiedLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/app/IApplicationThread;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/sip/SipService;-onConnectivityChanged-(Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/wm/DragState;-unregister-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView$1;-onPressKey-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/editor/LabeledEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/content/IContentService;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/ConnectivityManager;-requestRouteToHostAddress-(I Ljava/net/InetAddress;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/ProfileProvider;-deleteInTransaction-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_PROFILE'],
	'Lcom/android/browser/BrowserActivity;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiManager;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ApplicationThreadNative;-scheduleRegisteredReceiver-(Landroid/content/IIntentReceiver; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/power/Notifier$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Controller;-access$100-(Lcom/android/browser/Controller; Landroid/os/Bundle; Landroid/content/Intent; J Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-updateNotification-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$HideNavInputEventReceiver$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManager$7;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/ui/SlideView;-startVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/LoadingListener;-onLoadingFinished-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-enforceReceiveAndSend-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/vcard/VCardComposer;-init-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/providers/contacts/GlobalSearchSupport$SearchSuggestion;-asList-([Ljava/lang/String;)Ljava/util/ArrayList;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/Recycler$SmsRecycler;-anyThreadOverLimit-(Landroid/content/Context;)Z' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/webkit/WebViewClassic;-zoomIn-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/RetryScheduler;-update-(Lcom/android/mms/transaction/Observable;)V' : ['android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/server/BluetoothManagerService;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Controller;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$1700-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/ui/ZoomRenderer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothInputDevice;-getReport-(Landroid/bluetooth/BluetoothDevice; B B I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/DhcpStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager$Stub$Proxy;-setTestProviderEnabled-(Ljava/lang/String; Z)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneProxy;-<init>-(Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/SearchActivity;-initFragments-(J Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/HTML5VideoView;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/UiModeManagerService$4;-onTwilightStateChanged-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CsimFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/android/mms/pdu/PduPersister;-load-(Landroid/net/Uri;)Lcom/google/android/mms/pdu/GenericPdu;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/nfc/INfcAdapterExtras$Stub$Proxy;-authenticate-(Ljava/lang/String; [B)V' : ['android.permission.NFC'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/InputMethodManagerService;-switchUserLocked-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-shutdown-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/ui/GLView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/server/WifiService;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/alerts/AlertReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleBroadcastSms-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/MultiInputStream;-read-()I' : ['android.permission.INTERNET'],
	'Landroid/net/IThrottleManager;-getPeriodStartTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserWebViewFactory;-initWebViewSettings-(Landroid/webkit/WebView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/GLRootView;-onDrawFrameLocked-(Ljavax/microedition/khronos/opengles/GL10;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/SlideEditorActivity;-showCurrentSlide-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$SyncHandler;-onBootCompleted-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine;-setWifiState-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-showPrimarySecurityScreen-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/EditEventHelper;-saveEvent-(Lcom/android/calendar/CalendarEventModel; Lcom/android/calendar/CalendarEventModel; I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-init-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordContents;-delete-(Landroid/content/Context;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/HTML5Audio;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/CameraModule;-init-(Lcom/android/camera/CameraActivity; Landroid/view/View; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/LockScreen$1;-onUserSwitched-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyDefaultData-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/SnapshotTab;-dismissSubWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-access$500-(Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/SipCallOptionHandler;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/contacts/DbModifierWithNotification;-notifyVoicemailChange-(Landroid/net/Uri; Ljava/util/Set; [Ljava/lang/String;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/display/DisplayAdapter$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetDataLoader;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneBase;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/DownloadManager;-markState-(Landroid/net/Uri; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/data/LocalSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hdp/HealthService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Controller;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-checkPackagePermission-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/widget/ZoomButtonsController;-access$800-(Landroid/widget/ZoomButtonsController; Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/ContentResolver;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$FullImageJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/graphics/BitmapRegionDecoder;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-openToReceiveCalls-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter;-disableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/editor/SelectAccountDialogFragment$Listener;-onAccountChosen-(Lcom/android/contacts/model/account/AccountWithDataSet; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/widget/ChartDataUsageView$3;-onSweep-(Lcom/android/settings/widget/ChartSweepView; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/WebViewClassic;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewInputDispatcher;-skipWebkitForRemainingTouchStream-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoFullScreen;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onMMIComplete-(Lcom/android/internal/telephony/MmiCode;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/imageproc/BitmapSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiStatusTest$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-stopPlaybackAtPosition-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onDisconnectDone-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ConversationListItem;-bind-(Landroid/content/Context; Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-reportVisibility-()V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/RIL;-changeIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/DeskClock;-createTabs-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/dataitem/RelationDataItem;-getKindTypeColumn-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneInterfaceManager;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/model/ContactLoader;-loadStreamItems-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/BluetoothInputDevice;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity$1;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator;-access$1900-(Lcom/android/internal/policy/impl/keyguard_obsolete/KeyguardViewMediator; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/browser/WebViewFactory;-createWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.WRITE_SETTINGS', 'android.permission.INTERNET'],
	'Lcom/android/development/EnterURL$DisplayEditText;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/GroupMemberLoader;-constructLoaderForGroupDetailQuery-(Landroid/content/Context; J)Lcom/android/contacts/GroupMemberLoader;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/development/Connectivity;-access$2000-(Lcom/android/development/Connectivity;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/UrlHandler;-startActivityForUrl-(Lcom/android/browser/Tab; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onClockVisibilityChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Controller;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/BluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment;-updateDeviceName-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/Gallery;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/phone/InCallScreen$7;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PeopleActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/data/WorkingMessage;-setHasMultipleRecipients-(Z Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ConversationListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/app/ActivityManager;-getRunningTasks-(I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/camera/VideoModule;-onPauseBeforeSuper-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getBondedDevices-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$3;-onPostExecute-(Ljava/lang/Exception;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/INetworkPolicyManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/ChooserActivity;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/common/contacts/DataUsageStatUpdater;-updateWithAddress-(Ljava/util/Collection;)Z' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/list/ProfileAndContactsLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/location/LocationManager;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/browser/SuggestionsAdapter$CompletionListener;-onSelect-(Ljava/lang/String; I Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/SlideshowAttachmentView;-setVideo-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/media/NotificationPlayer;-play-(Landroid/content/Context; Landroid/net/Uri; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NsdService$NsdStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/test/mock/MockContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/media/IRingtonePlayer;-playAsync-(Landroid/net/Uri; Landroid/os/UserHandle; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebIconDatabaseClassic;-open-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/wm/WindowManagerService;-performLayoutAndPlaceSurfacesLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterfw/core/Filter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClassic;-freeMemory-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-getAutomaticLookback-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OutgoingCallBroadcaster$OutgoingCallReceiver;-doReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/google/android/mms/util/PduCache;-put-(Landroid/net/Uri; Lcom/google/android/mms/util/PduCacheEntry;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/test/mock/MockContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine$ObtainingIpState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-switchHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPan$Stub;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/Gallery;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebViewCore;-openFileChooser-(Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/month/MonthListView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/MediaPlaybackService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothInputDevice;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager$Stub;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ClassZeroActivity;-replaceMessage-(Landroid/telephony/SmsMessage;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/effect/effects/CrossProcessEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getVoiceRadioTechnology-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-loadMessagesAndDraft-(I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/widget/VideoView;-resume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl$1;-run-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Landroid/provider/Browser;-getAllVisitedUrls-(Landroid/content/ContentResolver;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateOrganizations-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/detail/ContactDetailFragment$AddToMyContactsQuickFix;-isApplicable-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.INTERNET'],
	'Landroid/content/ISyncStatusObserver$Stub$Proxy;-onStatusChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPinView;-onResume-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getLastCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-getNetworkQuotaInfoUnchecked-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/systemui/statusbar/policy/CurrentUserTracker;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-access$300-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor$SimArgs;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pan/PanService;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/Call;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$2;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-onCreate-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/net/wifi/IWifiManager$Stub;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/NfcAdapter;-setNdefPushMessage-(Landroid/nfc/NdefMessage; Landroid/app/Activity; [Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/providers/downloads/DownloadProvider;-logVerboseOpenFileInfo-(Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/AccessibilitySettings$ToggleAccessibilityServicePreferenceFragment;-onResume-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/BroadcastQueue;-skipCurrentReceiverLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/SyncManager;-<init>-(Landroid/content/Context; Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/MediaPlayer;-access$300-(Landroid/media/MediaPlayer; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/SecureCameraActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-setCurrentPage-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$LoaderTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Boolean;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/ui/MessageUtils;-getMultimediaMessageDetails-(Landroid/content/Context; Landroid/database/Cursor; I)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-makeAppNotRespondingLocked-(Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/util/ThreadPool$Job;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/gallery3d/data/SnailSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/AccessibilityInjector$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$UpdateContent;-call-()Ljava/lang/Void;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/pm/PackageManagerService;-access$1700-(Lcom/android/server/pm/PackageManagerService; Ljava/io/File; I I J Landroid/os/UserHandle;)Landroid/content/pm/PackageParser$Package;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/bluetooth/BluetoothDeviceFilter$ClassUuidFilter;-matches-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/ContactEditorActivity;-onStart-()V' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/power/ShutdownThread;-shutdown-(Landroid/content/Context; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/PhoneGlobals;-clearInCallScreenMode-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/ContextImpl;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/GLRootView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/phone/NotificationMgr;-updateInCallNotification-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/WallpaperHandler;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;-onProgressStart-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/DeleteDropTarget;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler;-<init>-(Landroid/content/Context; Landroid/view/View; I Z Lcom/android/contacts/model/RawContactDeltaList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/musicvis/RenderScriptWallpaper$RenderScriptEngine;-reportVisibility-()V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-getOutgoingServiceCenter-(J)Ljava/lang/String;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/IWallpaperManager;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/editor/ContactEditorFragment$5;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Landroid/content/ContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/ContextImpl;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ProviderStatusWatcher;-notifyListeners-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebViewClassic$8;-onPostExecute-(Landroid/webkit/WebViewCore$DrawData;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ConversationList;-onStart-()V' : ['android.permission.READ_SMS'],
	'Landroid/media/IRingtonePlayer$Stub$Proxy;-play-(Landroid/os/IBinder; Landroid/net/Uri; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setFrequencyBand-(I Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/SyncManager$ActiveSyncContext;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewProvider;-zoomIn-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/gallery3d/data/MtpSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActiveServices;-startServiceLocked-(Landroid/app/IApplicationThread; Landroid/content/Intent; Ljava/lang/String; I I I)Landroid/content/ComponentName;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/soundrecorder/SoundRecorder;-access$000-(Lcom/android/soundrecorder/SoundRecorder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/users/ProfileUpdateReceiver;-copyProfileName-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/launcher2/FolderEditText;-onEditorAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/EmergencyDialer;-keyPressed-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/net/DnsPinger;-getCurrentLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAccountsByTypeAsUser-(Ljava/lang/String; Landroid/os/UserHandle;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/AccountManager$1;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wm/WindowStateAnimator;-createSurfaceLocked-()Landroid/view/Surface;' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-showEmptyState-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onProgressStart-(Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings$ToggleFeaturePreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/AccountsTester$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/ActivityController;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/view/WindowManagerPolicy;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/recent/RecentsPanelView;-simulateClick-(I)Z' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/phone/InCallScreen;-connectBluetoothAudio-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/MccTable;-setLocaleFromMccIfNeeded-(Landroid/content/Context; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/InputMethodManagerService;-access$1100-(Lcom/android/server/InputMethodManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/tech/NfcBarcode;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/RIL;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-launchHomeFromHotKey-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WiredAccessoryManager;-access$100-(Lcom/android/server/WiredAccessoryManager; 