/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.internal.Sb;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.X0;
import com.android.tools.r8.utils.t0;
import com.android.tools.r8.utils.u0;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Keep
public class JdkClassFileProvider
implements ClassFileResourceProvider,
Closeable {
    static final /* synthetic */ boolean f;
    private Origin a;
    private final HashSet b;
    private final HashMap c;
    private URLClassLoader d;
    private FileSystem e;

    public static ClassFileResourceProvider fromSystemJdk() throws IOException {
        return new JdkClassFileProvider();
    }

    public static ClassFileResourceProvider fromSystemModulesJdk(Path home) throws IOException {
        Path path = home.resolve("lib").resolve("jrt-fs.jar");
        if (Files.exists(path, new LinkOption[0])) {
            Path path2;
            return new JdkClassFileProvider(path2);
        }
        throw new NoSuchFileException(path.toString());
    }

    public static ClassFileResourceProvider fromJdkHome(Path home) throws IOException {
        Path path;
        if (Files.exists(home.resolve("lib").resolve("jrt-fs.jar"), new LinkOption[0])) {
            return JdkClassFileProvider.fromSystemModulesJdk(path);
        }
        Path path2 = path.resolve("jre").resolve("lib").resolve("rt.jar");
        if (Files.exists(path2, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(path2);
        }
        path2 = path.resolve("lib").resolve("rt.jar");
        if (Files.exists(path2, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(path2);
        }
        throw new IOException("Path " + path + " does not look like a Java home");
    }

    public static ClassFileResourceProvider fromJavaRuntimeJar(Path archive) throws IOException {
        Path path;
        return new ArchiveClassFileProvider(path);
    }

    private JdkClassFileProvider() {
        JdkClassFileProvider jdkClassFileProvider = this;
        jdkClassFileProvider.b = new HashSet();
        jdkClassFileProvider.c = new HashMap();
        jdkClassFileProvider.a = Origin.unknown();
        jdkClassFileProvider.a(FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap()));
    }

    private JdkClassFileProvider(Path path) {
        JdkClassFileProvider jdkClassFileProvider;
        ((JdkClassFileProvider)((Object)map)).b = new HashSet();
        ((JdkClassFileProvider)((Object)map)).c = new HashMap();
        ((JdkClassFileProvider)((Object)map)).a = new PathOrigin(path);
        path = path.resolve("lib").resolve("jrt-fs.jar");
        if (!f && !Files.exists(path, new LinkOption[0])) {
            throw new AssertionError();
        }
        ((JdkClassFileProvider)((Object)map)).d = new URLClassLoader(new URL[]{path.toUri().toURL()});
        JdkClassFileProvider jdkClassFileProvider2 = map;
        Map map = Collections.emptyMap();
        jdkClassFileProvider.a(FileSystems.newFileSystem(URI.create("jrt:/"), map, (ClassLoader)jdkClassFileProvider2.d));
    }

    private void a(FileSystem fileSystem) {
        this.e = fileSystem;
        Files.walk(fileSystem.getPath("/modules", new String[0]), new FileVisitOption[0]).forEach(object -> {
            if (X0.b((Path)object)) {
                JdkClassFileProvider jdkClassFileProvider = this;
                Object object2 = this = u0.x(object.toString());
                object = ((t0)object2).a();
                jdkClassFileProvider.c.put(object, ((t0)object2).b());
                jdkClassFileProvider.b.add(((t0)this).a());
            }
        });
    }

    static {
        f = JdkClassFileProvider.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.b);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgramResource getProgramResource(String descriptor) {
        ProgramResource.Kind kind;
        JdkClassFileProvider jdkClassFileProvider;
        void v12;
        Origin origin;
        void var1_1;
        if (!((JdkClassFileProvider)((Object)this_)).b.contains(var1_1)) {
            return null;
        }
        try {
            origin = Origin.unknown();
            v12 = var1_1;
            jdkClassFileProvider = this_;
            kind = ProgramResource.Kind.CF;
        }
        catch (IOException iOException) {
            JdkClassFileProvider jdkClassFileProvider2 = this_;
            String this_ = "Failed to read '" + (String)var1_1;
            throw new Sb(this_, jdkClassFileProvider2.a);
        }
        FileSystem fileSystem = jdkClassFileProvider.e;
        String string = "modules";
        String[] stringArray = new String[2];
        stringArray[0] = (String)((JdkClassFileProvider)((Object)this_)).c.get(var1_1);
        int n11 = 1;
        stringArray[n11] = u0.s((String)var1_1);
        byte[] byArray = Files.readAllBytes(fileSystem.getPath(string, stringArray));
        Set<void> set = Collections.singleton(v12);
        return ProgramResource.fromBytes(origin, kind, byArray, set);
    }

    protected final void finalize() {
        JdkClassFileProvider jdkClassFileProvider = this;
        jdkClassFileProvider.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        JdkClassFileProvider jdkClassFileProvider = this_;
        jdkClassFileProvider.e.close();
        Closeable this_ = jdkClassFileProvider.d;
        if (this_ != null) {
            ((URLClassLoader)this_).close();
        }
    }
}

