/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.securityconfig;

import java.security.Provider;
import java.security.Security;
import java.util.logging.Logger;
import org.conscrypt.securityconfig.ApplicationConfig;

public final class NetworkSecurityConfigProvider
extends Provider {
    private static final String LOG_TAG = "nsconfig";
    private static final Logger logger = Logger.getLogger("nsconfig");
    private static final String PREFIX = NetworkSecurityConfigProvider.class.getPackage().getName() + ".";

    public NetworkSecurityConfigProvider() {
        super("AndroidNSSP", 1.0, "Android Network Security Policy Provider");
        this.put("TrustManagerFactory.PKIX", PREFIX + "RootTrustManagerFactorySpi");
        this.put("Alg.Alias.TrustManagerFactory.X509", "PKIX");
    }

    public static void install() {
        ApplicationConfig config = new ApplicationConfig();
        ApplicationConfig.setDefaultInstance(config);
        int pos = Security.insertProviderAt(new NetworkSecurityConfigProvider(), 1);
        if (pos != 1) {
            throw new RuntimeException("Failed to install provider as highest priority provider. Provider was installed at position " + pos);
        }
    }

    public static void handleNewApplication(String processName) {
        ApplicationConfig config = new ApplicationConfig();
        ApplicationConfig defaultConfig = ApplicationConfig.getDefaultInstance();
        if (defaultConfig != null && defaultConfig.isCleartextTrafficPermitted() != config.isCleartextTrafficPermitted()) {
            logger.warning((processName == null ? "Unknown process" : processName) + ": New config does not match the previously set config.");
            if (defaultConfig.hasPerDomainConfigs() || config.hasPerDomainConfigs()) {
                throw new RuntimeException("Found multiple conflicting per-domain rules");
            }
            config = defaultConfig.isCleartextTrafficPermitted() ? defaultConfig : config;
        }
        ApplicationConfig.setDefaultInstance(config);
    }
}

