/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.assistant.runtime;

import com.android.tools.r8.assistant.runtime.ReflectiveEventType;
import com.android.tools.r8.assistant.runtime.ReflectiveOperationReceiver;
import com.android.tools.r8.assistant.runtime.ReflectiveOracle;
import com.android.tools.r8.keepanno.annotations.KeepForApi;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;

@KeepForApi
public class ReflectiveOperationJsonLogger
implements ReflectiveOperationReceiver {
    private final FileWriter output;

    public ReflectiveOperationJsonLogger() throws IOException {
        String property = System.getProperty("com.android.tools.r8.reflectiveJsonLogger", "log.txt");
        File file = new File(property);
        file.createNewFile();
        this.output = new FileWriter(file);
        this.output.write("[");
    }

    public void finished() throws IOException {
        this.output.write("{}]");
        this.output.close();
    }

    private String[] methodToString(Class<?> returnType, Class<?> holder, String method, Class<?> ... parameters) {
        String[] methodStrings = new String[parameters.length + 3];
        methodStrings[0] = this.printClass(returnType);
        methodStrings[1] = this.printClass(holder);
        methodStrings[2] = method;
        for (int i15 = 0; i15 < parameters.length; ++i15) {
            methodStrings[i15 + 3] = this.printClass(parameters[i15]);
        }
        return methodStrings;
    }

    private String[] constructorToString(Class<?> holder, Class<?> ... parameters) {
        return this.methodToString(Void.TYPE, holder, "<init>", parameters);
    }

    private String printClass(Class<?> clazz) {
        return clazz == null ? "null" : clazz.getName();
    }

    private String printClassLoader(ClassLoader classLoader) {
        return classLoader == null ? "null" : this.printClass(classLoader.getClass());
    }

    private void output(ReflectiveEventType event, ReflectiveOracle.Stack stack, String ... args) {
        try {
            this.output.write("{\"event\": \"");
            this.output.write(event.name());
            this.output.write("\"");
            if (stack != null) {
                this.output.write(", \"stack\": ");
                this.printArray(stack.stackTraceElementsAsString());
            }
            assert (args != null);
            this.output.write(", \"args\": ");
            this.printArray(args);
            this.output.write("},\n");
            this.output.flush();
        }
        catch (IOException e15) {
            throw new RuntimeException(e15);
        }
    }

    private void printArray(String ... args) throws IOException {
        this.output.write("[");
        for (int i15 = 0; i15 < args.length; ++i15) {
            this.output.write("\"");
            this.output.write(args[i15]);
            this.output.write("\"");
            if (i15 == args.length - 1) continue;
            this.output.write(", ");
        }
        this.output.write("]");
    }

    @Override
    public void onClassNewInstance(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_NEW_INSTANCE, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetDeclaredMethod(ReflectiveOracle.Stack stack, Class<?> returnType, Class<?> clazz, String method, Class<?> ... parameters) {
        this.output(ReflectiveEventType.CLASS_GET_DECLARED_METHOD, stack, this.methodToString(returnType, clazz, method, parameters));
    }

    @Override
    public void onClassGetDeclaredMethods(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_DECLARED_METHODS, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetDeclaredField(ReflectiveOracle.Stack stack, Class<?> fieldType, Class<?> clazz, String fieldName) {
        this.output(ReflectiveEventType.CLASS_GET_DECLARED_FIELD, stack, this.printClass(fieldType), this.printClass(clazz), fieldName);
    }

    @Override
    public void onClassGetDeclaredFields(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_DECLARED_FIELDS, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetDeclaredConstructor(ReflectiveOracle.Stack stack, Class<?> clazz, Class<?> ... parameters) {
        this.output(ReflectiveEventType.CLASS_GET_DECLARED_CONSTRUCTOR, stack, this.constructorToString(clazz, parameters));
    }

    @Override
    public void onClassGetDeclaredConstructors(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_DECLARED_CONSTRUCTORS, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetMethod(ReflectiveOracle.Stack stack, Class<?> returnType, Class<?> clazz, String method, Class<?> ... parameters) {
        this.output(ReflectiveEventType.CLASS_GET_METHOD, stack, this.methodToString(returnType, clazz, method, parameters));
    }

    @Override
    public void onClassGetMethods(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_METHODS, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetField(ReflectiveOracle.Stack stack, Class<?> fieldType, Class<?> clazz, String fieldName) {
        this.output(ReflectiveEventType.CLASS_GET_FIELD, stack, this.printClass(fieldType), this.printClass(clazz), fieldName);
    }

    @Override
    public void onClassGetFields(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_FIELDS, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetConstructor(ReflectiveOracle.Stack stack, Class<?> clazz, Class<?> ... parameters) {
        this.output(ReflectiveEventType.CLASS_GET_CONSTRUCTOR, stack, this.constructorToString(clazz, parameters));
    }

    @Override
    public void onClassGetConstructors(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_CONSTRUCTORS, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetName(ReflectiveOracle.Stack stack, Class<?> clazz, ReflectiveOperationReceiver.NameLookupType lookupType) {
        this.output(ReflectiveEventType.CLASS_GET_NAME, stack, this.printClass(clazz), lookupType.name());
    }

    @Override
    public void onClassForName(ReflectiveOracle.Stack stack, String className, boolean initialize, ClassLoader classLoader) {
        this.output(ReflectiveEventType.CLASS_FOR_NAME, stack, className, Boolean.toString(initialize), this.printClassLoader(classLoader));
    }

    @Override
    public void onClassGetComponentType(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_COMPONENT_TYPE, stack, this.printClass(clazz));
    }

    @Override
    public void onClassGetPackage(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_PACKAGE, stack, this.printClass(clazz));
    }

    @Override
    public void onClassIsAssignableFrom(ReflectiveOracle.Stack stack, Class<?> clazz, Class<?> sup) {
        this.output(ReflectiveEventType.CLASS_IS_ASSIGNABLE_FROM, stack, this.printClass(clazz), this.printClass(sup));
    }

    @Override
    public void onClassGetSuperclass(ReflectiveOracle.Stack stack, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_GET_SUPERCLASS, stack, this.printClass(clazz));
    }

    @Override
    public void onClassAsSubclass(ReflectiveOracle.Stack stack, Class<?> holder, Class<?> clazz) {
        this.output(ReflectiveEventType.CLASS_AS_SUBCLASS, stack, this.printClass(holder), this.printClass(clazz));
    }

    @Override
    public void onClassIsInstance(ReflectiveOracle.Stack stack, Class<?> holder, Object object) {
        this.output(ReflectiveEventType.CLASS_IS_INSTANCE, stack, this.printClass(holder), this.printClass(object.getClass()));
    }

    @Override
    public void onClassCast(ReflectiveOracle.Stack stack, Class<?> holder, Object object) {
        this.output(ReflectiveEventType.CLASS_CAST, stack, this.printClass(holder), this.printClass(object.getClass()));
    }

    @Override
    public void onClassFlag(ReflectiveOracle.Stack stack, Class<?> clazz, ReflectiveOperationReceiver.ClassFlag classFlag) {
        this.output(ReflectiveEventType.CLASS_FLAG, stack, this.printClass(clazz), classFlag.name());
    }

    @Override
    public void onAtomicFieldUpdaterNewUpdater(ReflectiveOracle.Stack stack, Class<?> fieldClass, Class<?> clazz, String name) {
        this.output(ReflectiveEventType.ATOMIC_FIELD_UPDATER_NEW_UPDATER, stack, this.printClass(fieldClass), this.printClass(clazz), name);
    }

    @Override
    public void onServiceLoaderLoad(ReflectiveOracle.Stack stack, Class<?> clazz, ClassLoader classLoader) {
        this.output(ReflectiveEventType.SERVICE_LOADER_LOAD, stack, this.printClass(clazz), this.printClassLoader(classLoader));
    }

    @Override
    public void onProxyNewProxyInstance(ReflectiveOracle.Stack stack, ClassLoader classLoader, Class<?>[] interfaces, InvocationHandler invocationHandler) {
        String[] methodStrings = new String[interfaces.length + 2];
        methodStrings[0] = this.printClassLoader(classLoader);
        methodStrings[1] = invocationHandler.toString();
        for (int i15 = 0; i15 < interfaces.length; ++i15) {
            methodStrings[i15 + 2] = this.printClass(interfaces[i15]);
        }
        this.output(ReflectiveEventType.PROXY_NEW_PROXY_INSTANCE, stack, methodStrings);
    }

    @Override
    public boolean requiresStackInformation() {
        return true;
    }
}

