# Events

An Event is a piece of data discovered by BBOT. Examples include `IP_ADDRESS`, `DNS_NAME`, `EMAIL_ADDRESS`, `URL`, etc. When you run a BBOT scan, events are constantly being exchanged between modules. They are also output to the console:

```text
[DNS_NAME]      www.evilcorp.com    sslcert         (distance-0, in-scope, resolved, subdomain, a-record)
 ^^^^^^^^       ^^^^^^^^^^^^^^^^    ^^^^^^^          ^^^^^^^^^^
event type      event data          source module    tags
```

## Event Attributes

Each BBOT event has the following attributes. Not all of these attributes are visible in the terminal output. However, they are always saved in `output.json` in the scan output folder. If you want to see them on the terminal, you can use `--json`.

- `.type`: the event type (e.g. `DNS_NAME`, `IP_ADDRESS`, `OPEN_TCP_PORT`, etc.)
- `.id`: an identifier representing the event type + a SHA1 hash of its data (note: multiple events can have the same `.id`)
- `.uuid`: a universally unique identifier for the event (e.g. `DNS_NAME:6c96d512-090a-47f0-82e4-6860e46aac13`)
- `.scope_description`: describes the scope of the event (e.g. `in-scope`, `affiliate`, `distance-2`)
- `.data`: the actual discovered data (for some events like `DNS_NAME` or `IP_ADDRESS`, this is a string. For other more complex events like `HTTP_RESPONSE`, it's a dictionary)
- `.host`: the hostname or IP address (e.g. `evilcorp.com` or `1.2.3.4`)
- `.port`: the port number (e.g. `80`, `443`)
- `.netloc`: the network location, including both the hostname and port (e.g. `www.evilcorp.com:443`)
- `.resolved_hosts`: a list of all resolved hosts for the event (`A`, `AAAA`, and `CNAME` records)
- `.dns_children`: a dictionary of all DNS records for the event (typically only present on `DNS_NAME`)
- `.web_spider_distance`: a count of how many URL links have been followed in a row to get to this event
- `.scope_distance`: a count of how many hops it is from the main scope (0 == in-scope)
- `.scan`: the ID of the scan that produced the event
- `.timestamp`: the date/time when the event was discovered
- `.parent`: the ID of the parent event that led to the discovery of this event
- `.parent_uuid`: the universally unique identifier for the parent event
- `.tags`: a list of tags describing the event (e.g. `mx-record`, `http-title`, etc.)
- `.module`: the module that discovered the event
- `.module_sequence`: the recent sequence of modules that were executed to discover the event (including omitted events)
- `.discovery_context`: a description of the context in which the event was discovered
- `.discovery_path`: a list of every discovery context leading to this event
- `.parent_chain`: a list of every event UUID leading to the discovery of this event (corresponds exactly to `.discovery_path`)

These attributes allow us to construct a visual graph of events (e.g. in [Neo4j](output.md#neo4j)) and query/filter/grep them more easily. Here is what a typical event looks like in JSON format:

```json
{
  "type": "DNS_NAME",
  "id": "DNS_NAME:33bc005c2bdfea4d73e07db733bd11861cf6520e",
  "uuid": "DNS_NAME:6c96d512-090a-47f0-82e4-6860e46aac13",
  "scope_description": "in-scope",
  "data": "link.evilcorp.com",
  "host": "link.evilcorp.com",
  "resolved_hosts": [
    "184.31.52.65",
    "2600:1402:b800:d82::700",
    "2600:1402:b800:d87::700",
    "link.evilcorp.com.edgekey.net"
  ],
  "dns_children": {
    "A": [
      "184.31.52.65"
    ],
    "AAAA": [
      "2600:1402:b800:d82::700",
      "2600:1402:b800:d87::700"
    ],
    "CNAME": [
      "link.evilcorp.com.edgekey.net"
    ]
  },
  "web_spider_distance": 0,
  "scope_distance": 0,
  "scan": "SCAN:b6ef48bc036bc8d001595ae5061846a7e6beadb6",
  "timestamp": "2024-10-18T15:40:13.716880+00:00",
  "parent": "DNS_NAME:94c92b7eaed431b37ae2a757fec4e678cc3bd213",
  "parent_uuid": "DNS_NAME:c737dffa-d4f0-4b6e-a72d-cc8c05bd892e",
  "tags": [
    "subdomain",
    "a-record",
    "cdn-akamai",
    "in-scope",
    "cname-record",
    "aaaa-record"
  ],
  "module": "speculate",
  "module_sequence": "speculate->speculate",
  "discovery_context": "speculated parent DNS_NAME: link.evilcorp.com",
  "discovery_path": [
    "Scan insidious_frederick seeded with DNS_NAME: evilcorp.com",
    "TXT record for evilcorp.com contains IP_ADDRESS: 149.72.247.52",
    "PTR record for 149.72.247.52 contains DNS_NAME: o1.ptr2410.link.evilcorp.com",
    "speculated parent DNS_NAME: ptr2410.link.evilcorp.com",
    "speculated parent DNS_NAME: link.evilcorp.com"
  ],
  "parent_chain": [
    "DNS_NAME:34c657a3-0bfa-457e-9e6e-0f22f04b8da5",
    "IP_ADDRESS:efc0fb3b-1b42-44da-916e-83db2360e10e",
    "DNS_NAME:c737dffa-d4f0-4b6e-a72d-cc8c05bd892e",
    "DNS_NAME_UNRESOLVED:722a3473-30c6-40f1-90aa-908d47105d5a",
    "DNS_NAME:6c96d512-090a-47f0-82e4-6860e46aac13"
  ]
}
```

For a more detailed description of BBOT events, see [Developer Documentation - Event](../dev/event.md).

Below is a full list of event types along with which modules produce/consume them.

## List of Event Types

<!-- BBOT EVENTS -->
| Event Type          | # Consuming Modules   | # Producing Modules   | Consuming Modules                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Producing Modules                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
|---------------------|-----------------------|-----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| *                   | 18                    | 0                     | affiliates, cloudcheck, csv, discord, dnsresolve, http, json, mysql, neo4j, postgres, python, slack, splunk, sqlite, stdout, teams, txt, websocket                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ASN                 | 0                     | 1                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | asn                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| AZURE_TENANT        | 1                     | 0                     | speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| CODE_REPOSITORY     | 7                     | 8                     | docker_pull, git_clone, gitdumper, github_workflows, google_playstore, postman_download, trufflehog                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | code_repository, dockerhub, git, github_codesearch, github_org, gitlab_com, gitlab_onprem, postman                                                                                                                                                                                                                                                                                                                                                                          |
| DNS_NAME            | 60                    | 43                    | anubisdb, asset_inventory, azure_realm, azure_tenant, baddns, baddns_zone, bevigil, bucket_amazon, bucket_digitalocean, bucket_firebase, bucket_google, bucket_microsoft, bufferoverrun, builtwith, c99, censys_dns, certspotter, chaos, credshed, crt, crt_db, dehashed, digitorus, dnsbimi, dnsbrute, dnsbrute_mutations, dnscaa, dnscommonsrv, dnsdumpster, dnstlsrpt, emailformat, fullhunt, github_codesearch, github_usersearch, hackertarget, hunterio, leakix, myssl, nmap_xml, oauth, otx, passivetotal, pgp, portscan, rapiddns, securitytrails, securitytxt, shodan_dns, shodan_idb, sitedossier, skymem, speculate, subdomaincenter, subdomainradar, subdomains, trickest, urlscan, viewdns, virustotal, wayback | anubisdb, azure_tenant, bevigil, bufferoverrun, builtwith, c99, censys_dns, censys_ip, certspotter, chaos, crt, crt_db, digitorus, dnsbrute, dnsbrute_mutations, dnscaa, dnscommonsrv, dnsdumpster, dnsresolve, fullhunt, hackertarget, hunterio, leakix, myssl, ntlm, oauth, otx, passivetotal, rapiddns, securitytrails, shodan_dns, shodan_idb, sitedossier, speculate, sslcert, subdomaincenter, subdomainradar, trickest, urlscan, vhost, viewdns, virustotal, wayback |
| DNS_NAME_UNRESOLVED | 3                     | 0                     | baddns, speculate, subdomains                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| EMAIL_ADDRESS       | 1                     | 11                    | emails                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | credshed, dehashed, dnscaa, dnstlsrpt, emailformat, github_usersearch, hunterio, pgp, securitytxt, skymem, sslcert                                                                                                                                                                                                                                                                                                                                                          |
| FILESYSTEM          | 4                     | 9                     | extractous, jadx, trufflehog, unarchive                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | apkpure, docker_pull, filedownload, git_clone, gitdumper, github_workflows, jadx, postman_download, unarchive                                                                                                                                                                                                                                                                                                                                                               |
| FINDING             | 2                     | 32                    | asset_inventory, web_report                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | ajaxpro, baddns, baddns_direct, baddns_zone, badsecrets, bucket_amazon, bucket_digitalocean, bucket_firebase, bucket_google, bucket_microsoft, bypass403, git, gitlab_onprem, graphql_introspection, host_header, hunt, legba, lightfuzz, newsletters, ntlm, nuclei, paramminer_cookies, paramminer_getparams, reflected_parameters, retirejs, shodan_idb, smuggler, speculate, telerik, trufflehog, url_manipulation, wpscan                                               |
| GEOLOCATION         | 0                     | 2                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip2location, ipstack                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| HASHED_PASSWORD     | 0                     | 2                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | credshed, dehashed                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| HTTP_RESPONSE       | 18                    | 1                     | ajaxpro, asset_inventory, badsecrets, dotnetnuke, excavate, filedownload, gitlab_onprem, host_header, newsletters, nmap_xml, ntlm, paramminer_cookies, paramminer_getparams, paramminer_headers, speculate, telerik, trufflehog, wpscan                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | httpx                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| IP_ADDRESS          | 10                    | 5                     | asn, asset_inventory, censys_ip, ip2location, ipneighbor, ipstack, nmap_xml, portscan, shodan_idb, speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | asset_inventory, censys_ip, dnsresolve, ipneighbor, speculate                                                                                                                                                                                                                                                                                                                                                                                                               |
| IP_RANGE            | 2                     | 0                     | portscan, speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| MOBILE_APP          | 1                     | 1                     | apkpure                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | google_playstore                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| OPEN_TCP_PORT       | 6                     | 5                     | asset_inventory, fingerprintx, httpx, nmap_xml, portfilter, sslcert                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | asset_inventory, censys_ip, portscan, shodan_idb, speculate                                                                                                                                                                                                                                                                                                                                                                                                                 |
| OPEN_UDP_PORT       | 0                     | 1                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | censys_ip                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| ORG_STUB            | 4                     | 1                     | dockerhub, github_org, google_playstore, postman                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| PASSWORD            | 0                     | 2                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | credshed, dehashed                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| PROTOCOL            | 3                     | 2                     | legba, medusa, nmap_xml                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | censys_ip, fingerprintx                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| RAW_DNS_RECORD      | 0                     | 3                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | dnsbimi, dnsresolve, dnstlsrpt                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| RAW_TEXT            | 2                     | 1                     | excavate, trufflehog                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | extractous                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| SOCIAL              | 7                     | 4                     | dockerhub, github_org, gitlab_com, gitlab_onprem, gowitness, postman, speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | dockerhub, github_usersearch, gitlab_onprem, social                                                                                                                                                                                                                                                                                                                                                                                                                         |
| STORAGE_BUCKET      | 8                     | 5                     | baddns_direct, bucket_amazon, bucket_digitalocean, bucket_file_enum, bucket_firebase, bucket_google, bucket_microsoft, speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | bucket_amazon, bucket_digitalocean, bucket_firebase, bucket_google, bucket_microsoft                                                                                                                                                                                                                                                                                                                                                                                        |
| TECHNOLOGY          | 4                     | 8                     | asset_inventory, gitlab_onprem, web_report, wpscan                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | badsecrets, censys_ip, dotnetnuke, gitlab_onprem, gowitness, nuclei, shodan_idb, wpscan                                                                                                                                                                                                                                                                                                                                                                                     |
| URL                 | 24                    | 2                     | ajaxpro, aspnet_bin_exposure, asset_inventory, baddns_direct, bypass403, ffuf, generic_ssrf, git, gowitness, graphql_introspection, httpx, iis_shortnames, lightfuzz, ntlm, nuclei, portfilter, robots, smuggler, speculate, telerik, url_manipulation, vhost, wafw00f, web_report                                                                                                                                                                                                                                                                                                                                                                                                                                           | gowitness, httpx                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| URL_HINT            | 1                     | 1                     | ffuf_shortnames                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | iis_shortnames                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| URL_UNVERIFIED      | 8                     | 19                    | code_repository, filedownload, httpx, oauth, portfilter, retirejs, social, speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | azure_realm, bevigil, bucket_file_enum, censys_ip, dnsbimi, dnscaa, dnstlsrpt, dockerhub, excavate, ffuf, ffuf_shortnames, github_codesearch, gowitness, hunterio, robots, securitytxt, urlscan, wayback, wpscan                                                                                                                                                                                                                                                            |
| USERNAME            | 1                     | 2                     | speculate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | credshed, dehashed                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| VHOST               | 1                     | 1                     | web_report                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | vhost                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| VULNERABILITY       | 2                     | 15                    | asset_inventory, web_report                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | ajaxpro, aspnet_bin_exposure, baddns, baddns_direct, baddns_zone, badsecrets, dotnetnuke, generic_ssrf, lightfuzz, medusa, nuclei, shodan_idb, telerik, trufflehog, wpscan                                                                                                                                                                                                                                                                                                  |
| WAF                 | 1                     | 1                     | asset_inventory                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | wafw00f                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| WEBSCREENSHOT       | 0                     | 1                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | gowitness                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| WEB_PARAMETER       | 7                     | 4                     | hunt, lightfuzz, paramminer_cookies, paramminer_getparams, paramminer_headers, reflected_parameters, web_parameters                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | excavate, paramminer_cookies, paramminer_getparams, paramminer_headers                                                                                                                                                                                                                                                                                                                                                                                                      |
<!-- END BBOT EVENTS -->

## Findings Vs. Vulnerabilities

BBOT has a sharp distinction between Findings and Vulnerabilities:

**VULNERABILITY**

* There's a higher standard for what is allowed to be a vulnerability. They should be considered **confirmed** and **actionable** - no additional confirmation required
* They are always assigned a severity. The possible severities are: LOW, MEDIUM, HIGH, or CRITICAL

**FINDING**

* Findings can range anywhere from "slightly interesting behavior" to "likely, but unconfirmed vulnerability"
* Are often false positives

By making this separation, actionable vulnerabilities can be identified quickly in the midst of a large scan
